*************************************************************
* SHOWEVNT.PRG
* Displays all the events that fire for a form, two push-
* buttons, and an editor in an editor window. Helpful in
* determining which events fire in what order.
*************************************************************
 
DEFINE EDITOR ed1 FROM 0,0 TO 35,20 ;
   PROPERTY ;
      OnClose OnCls, ;
      OnGotFocus OnGF, ;
      OnHelp OnHlp, ;
      OnLostFocus OnLF, ;
      OnOpen OnOpn

DEFINE FORM ShowEvent ;
   PROPERTY ;
      OnClose OnCls, ;
      OnGotFocus OnGF, ;
      OnHelp OnHlp, ;
      OnLostFocus OnLF, ;
      OnMouseDblClk OnMDClk, ;
      OnOpen OnOpn, ;
      OnSize OnSz, ;
      Text "Order of event execution", ;
      Width 40, Height 10, Top 10, Left 25

DEFINE PUSHBUTTON pb1 OF ShowEvent ;
   PROPERTY ;
      OnClick  OnClk, ;
      OnGotFocus  OnGF, ;
      OnHelp OnHlp, ;
      OnLostFocus OnLF, ;
      Text "Button 1", ;
      Width 11, Height 2, Top 2, Left 7

DEFINE PUSHBUTTON pb2 OF ShowEvent ;
   PROPERTY ;
      OnClick  OnClk, ;
      OnGotFocus  OnGF, ;
      OnHelp OnHlp, ;
      OnLostFocus OnLF, ;
      Text "Button 2", ;
      Width 11, Height 2, Top 2, Left 21

lVoid = ed1.Open()               && Open the editor window.
lVoid = ShowEvent.Open()         && Open the form window.
lVoid = ShowEvent.pb1.SetFocus() && Shift focus to Button 1.


*--------------------------------------------------------------
* The following event handlers take the name of the current
* object, concatenate to it the name of the associated 
* event-handling property, and display it on the current line 
* of the editor object. Each procedure is anonymous (can work
* with any object that has that event).
*------------------------------------------------------------- 
PROCEDURE OnCls
   ed1.InsertLine = this.Name + ".OnClose"
RETURN

PROCEDURE OnGF
   ed1.InsertLine = this.Name + ".OnGotFocus"
RETURN

PROCEDURE OnHlp
   ed1.InsertLine = this.Name + ".OnHelp"
RETURN

PROCEDURE OnLF
   ed1.InsertLine = this.Name + ".OnLostFocus"
RETURN

PROCEDURE OnOpn
   ed1.InsertLine = this.Name + ".OnOpen"
RETURN

PROCEDURE OnMDClk
   ed1.InsertLine = this.Name + ".OnMOuseDblClk"
RETURN

PROCEDURE OnMv
   ed1.InsertLine = this.Name + ".OnMove"
RETURN

PROCEDURE OnSz
   ed1.InsertLine = this.Name + ".OnSize"
RETURN

PROCEDURE OnClk
   ed1.InsertLine = this.Name + ".OnClick"
RETURN
