* dBASE 5.0 DFM DRIVER - Do not remove this line
PROCEDURE ORDERS     && Main program
*-----------------------------------------------------------------
* NAME
*   ORDERS.PRG - Main program for form.
*
*-----------------------------------------------------------------
    PRIVATE lTalk, lVoid, cOldProc, cFormRun, cDispMode, cNewMode
    IF SET( 'TALK' ) = 'ON'
        SET TALK OFF
        lTalk = .T.
    ELSE
        lTalk = .F.
    ENDIF
    *--------------------------------------------
    *-- Make sure that FormRun.dbo file is active
    *--------------------------------------------
    cOldProc = SET( 'PROCEDURE' )
    cFormRun = HOME() + 'FORMRUN.DBO'
    * SET PROCEDURE TO &cFormRun
    #include "ORDERS.DFM"
    IF TYPE("ORDERS.SetDisp") = "L" .AND. TYPE("ORDERS.DispMode") = "C"
        IF ORDERS.SetDisp
            cDispMode = SET('DISPLAY')
            cNewMode = ORDERS.DispMode
            SET DISPLAY TO &cNewMode
        ENDIF
    ENDIF
    *-------------------------------------------
    *-- If ModalForm is missing from .DFM set it
    *-------------------------------------------
    IF TYPE( 'ORDERS.ModalForm' ) # 'L'
        ORDERS.ModalForm = .T.        && Assume modal form if not set
    ENDIF
    *-----------------------------------
    *-- Open the form based on ModalForm
    *-----------------------------------
    IF ORDERS.ModalForm
        *-----------------------------------
        *-- Use Readmodal() to open the form
        *-----------------------------------
        ORDERS.Action = .F.        && Set .T. by OKHAND before closing
        lVoid = ORDERS.ReadModal()
        DO UDTEXT
        IF ORDERS.Action
            *-------------------------------------------
            *-- Place code here to process OK pushbutton
            *-------------------------------------------
        ENDIF
        IF TYPE("ORDERS.SetDisp") = "L"
            IF ORDERS.SetDisp
                SET DISPLAY TO &cDispMode
            ENDIF
        ENDIF
        RELEASE ORDERS        && Release the form and object ref.
    ELSE
        *------------------------------
        *-- Use Open() to open the form
        *------------------------------
        _CmdWindow.oBForm = m->Orders
        lVoid = ORDERS.Open()
        Orders.TxName13.Text = LTRIM(Goods->Part_Name)
        Orders.TxName24.Text = LTRIM(STR(Goods->Price))
        Orders.TxName27.Text = LTRIM(STR(Goods->Qty_OnHand))
        Orders.TxName25.Text = LTRIM(STR((Goods->Price - Goods->Cost) / 100))
        Name = TRIM(Employee->FirstName)+" "+Employee->LastName
        Orders.TxName18.text = name
        * Show user if the record is marked for deletion
        IF DELETED()
           Orders.TxName23.Text = "DELETED"
        ELSE
           Orders.TxName23.Text = ""
        ENDIF
        *-------------------------------------------
        *-- Make the form release itself when closed
        *-- Comment out the RELEASE command to keep
        *-- the form defined when closed.
        *-------------------------------------------
        RELEASE ORDERS
    ENDIF
    IF .NOT. ISBLANK( m->cOldProc )
        SET PROCEDURE TO &cOldProc
    ENDIF
    IF lTalk
        SET TALK ON
    ENDIF
RETURN
*-- EOP: C:\DBASE\NEW\ORDERS.PRG

PROCEDURE Closeme     && PBNAME5.ONCLICK
*-----------------------------------------------------------------
* NAME
*   ONCLICK - Event handler for PBNAME5
*
*-----------------------------------------------------------------
    Form.Action = .F.
    lVoid = Form.Close()
RETURN

PROCEDURE Add_new     && PBNAME3.ONCLICK
*-----------------------------------------------------------------
* NAME
*   ONCLICK - Event handler for PBNAME3
*
*-----------------------------------------------------------------
    NewRecord = .T.
    *Write data to disk
    lvoid = Form.submit()
    * Append a record
    APPEND BLANK
    Lvoid=form.Cust_Id001.SETFOCUS()
    *Refresh Screen Data
    lvoid = Form.refresh()
    Form.TxName13.Text = ""
    Form.TxName24.Text = ""
    Form.TxName27.Text = ""
    Form.TxName25.Text = ""
    Form.TxName18.text = ""
    Form.TxName23.Text = ""
RETURN

PROCEDURE DelIt     && PBNAME4.ONCLICK
*-----------------------------------------------------------------
* NAME
*   ONCLICK - Event handler for PBNAME4
*
*-----------------------------------------------------------------
    IF DELETED()
      Form.TxName23.Text = ""
      RECALL
    ELSE
      Form.TxName23.Text = "DELETED"
      DELETE
    ENDIF
RETURN

PROCEDURE Printme     && PBNAME6.ONCLICK
*-----------------------------------------------------------------
* NAME
*   ONCLICK - Event handler for PBNAME6
*
*-----------------------------------------------------------------
DEFINE FORM Prt FROM 5,25 TO 16,50 ;
    PROPERTY ;
        TEXT "Print Form"
DEFINE TEXT t1 OF Prt AT 1,1 ;
    PROPERTY ;
        Text "Type :",;
        COLORNORMAL "R/W"
DEFINE RADIOBUTTON Rep OF Prt AT 2,1 ;
    PROPERTY ;
        Text "Report",;
        Group .T.,;
        COLORNORMAL "N/W",;
        WIDTH 15
DEFINE TEXT T3 OF Prt AT 9,5 ;
    PROPERTY ;
        TEXT "PRINTING ..." ,;
        VISIBLE .F.,;
        WIDTH 15
DEFINE PUSHBUTTON P1 OF Prt AT 8,12 ;
    PROPERTY ;
        TEXT "&Ok",;
        ONCLICK "RunRep",;
        Width 10
DEFINE PUSHBUTTON P2 OF Prt AT 8,2 ;
    PROPERTY ;
        TEXT "&Cancel",;
        ONCLICK "CloseMe",;
        Width 10
lVoid = Prt.Open()

******************
PROCEDURE Runrep

* Check for Labels or Reports
SET CONSOLE OFF
DO CASE
    CASE Form.Rep.Value
         * display to user something is happening
         Form.T3.Visible = .t.
         REPORT FORM Orders TO PRINTER
ENDCASE
SET CONSOLE ON
SKIP -1
lVoid = Form.Close()
lVoid = Form.Release()
RETURN

PROCEDURE SkipFor     && PBNAME21.ONCLICK
*-----------------------------------------------------------------
* NAME
*   ONCLICK - Event handler for PBNAME21
*
*-----------------------------------------------------------------
    DO SkipHand
    DO UdText
RETURN

PROCEDURE SkipBack     && PBNAME22.ONCLICK
*-----------------------------------------------------------------
* NAME
*   ONCLICK - Event handler for PBNAME22
*
*-----------------------------------------------------------------
    DO PrevHand
    DO UdText
RETURN

PROCEDURE UdText
*-----------------------------------------------------------------
*
*  Updates text objects on Next or Previous buttons
*
*-----------------------------------------------------------------
    IF .NOT. EOF()
        Form.TxName13.Text = LTRIM(Goods->Part_Name)
        Form.TxName24.Text = LTRIM(STR(Goods->Price))
        Form.TxName27.Text = LTRIM(STR(Goods->Qty_OnHand))
        Form.TxName25.Text = LTRIM(STR((Goods->Price - Goods->Cost) / 100))
        Name = TRIM(Employee->FirstName)+" "+Employee->LastName
        Form.TxName18.text = name
        * Show user if the record is marked for deletion
        IF DELETED()
           Form.TxName23.Text = "DELETED"
        ELSE
           Form.TxName23.Text = ""
        ENDIF
    ENDIF
RETURN

PROCEDURE CloseOrd     && ORDERS.ONCLOSE
*-----------------------------------------------------------------
* NAME
*   ONCLOSE - Event handler for ORDERS
*
*-----------------------------------------------------------------
    IF This.Action
        lVoid = This.Submit()
    ELSE
           IF This.Modified()
            DO ErrorMsg WITH "Data write was cancelled!"
           ENDIF
    ENDIF
    USE IN ORDERS
    USE IN CUST
    USE IN GOODS
    USE IN EMPLOYEE
    *USE IN ORDEMP
    *USE IN ORDCUST
    *USE IN ORDGOODS
    lVoid = This.Release()
    mFormOpen=.F.
    DEFINE FORM mTemp PROPERTY VISIBLE .F.
    lVoid = mTemp.OPEN()
    mDesk = mTemp.PARENT
    lVoid = mTemp.CLOSE()
    mFormName=SPACE(8)
    mActive=mDesk.ActiveControl()
    IF TYPE("mActive.ClassName")="C"
        mClass=mActive.ClassName
        IF mClass="FORM"
            mFormName=mActive.Name
            mFormOpen=.T.
        ENDIF
    ENDIF
    IF .NOT. mFormOpen
         Main.F1.CloseAll.Enabled=.T.
         Main.S.Srch.Enabled=.F.
         Main.S.Tp.Enabled=.F.
         Main.S.Btm.Enabled=.F.
         Main.S.Pck.Enabled=.T.
         Main.S.Indx.Enabled=.T.
         Main.E.Undo.Enabled=.F.
         Main.E.Save.Enabled=.F.
         Main.App.Cust.Enabled=.T.
         Main.App.Gds.Enabled=.T.
         Main.App.Acc.Enabled=.T.
         Main.App.Emp.Enabled=.T.
         Main.F1.Bac.Enabled=.T.
         Main.App.Inv.Enabled=.T.
    ENDIF
    Main.App.Ord.Enabled=.T.
    RELEASE _CmdWindow.oBForm
RETURN

PROCEDURE OpenOrd     && ORDERS.ONOPEN
*-----------------------------------------------------------------
* NAME
*   ONOPEN - Event handler for ORDERS
*
*-----------------------------------------------------------------
    PUBLIC NewRecord
    NewRecord = .F.
    mFormOpen = .F.
    This.TxName23.Text = ""
    IF .F.

    SELECT SELECT()
    USE Goods ORDER Part_Id ALIAS OrdGoods AGAIN
    SEEK(Orders->Part_ID)
    SELECT SELECT()
    USE Employee ORDER Emp_ID ALIAS OrdEmp AGAIN
    SEEK(Orders->Emp_Id)
    SELECT SELECT()
    USE Cust ORDER Cust_ID ALIAS OrdCust AGAIN
    SEEK(Orders->Cust_ID)
    This.TxName13.Text = LTRIM(OrdGoods->Part_Name)
    This.TxName24.Text = LTRIM(STR(OrdGoods->Price))
    This.TxName27.Text = LTRIM(STR(OrdGoods->Qty_OnHand))
    This.TxName25.Text = LTRIM(STR((OrdGoods->Price - OrdGoods->Cost) / 100))
    Name = TRIM(OrdEmp->FirstName) +" "+OrdEmp->LastName
    This.TxName18.Text = Name
        SELE Orders
    endif
    IF .NOT. mFormOpen
        Main.F1.CloseAll.Enabled=.F.
        Main.S.Srch.Enabled=.T.
        Main.S.Tp.Enabled=.T.
        Main.S.Btm.Enabled=.T.
        Main.S.Pck.Enabled=.F.
        Main.S.Indx.Enabled=.F.
        Main.E.Undo.Enabled=.T.
        Main.E.Save.Enabled=.T.
        Main.App.Cust.Enabled=.F.
        Main.App.Gds.Enabled=.F.
        Main.App.Acc.Enabled=.F.
        Main.App.Emp.Enabled=.F.
        Main.F1.Bac.Enabled=.F.
        Main.App.Inv.Enabled=.F.
    ENDIF
    Main.App.Ord.Enabled=.F.
RETURN

PROCEDURE Repaint     && ORDERS.ONGOTFOCUS
*-----------------------------------------------------------------
* NAME
*   ONGOTFOCUS - Event handler for ORDERS
*
*-----------------------------------------------------------------
    SELE Orders
*   lVoid = This.Refresh()
RETURN

FUNCTION ChkLook
*-----------------------------------------------------------
* NAME
*   ChkLook
*
* DESCRIPTION
*   Calls the routine to process a lookup and returns result
*
*-----------------------------------------------------------
    PRIVATE lRet
    lRet = LookVal(This, Form)
RETURN lRet
