***-----------------------------------------------------------------***
***------------------------------------------------------------------***
***  File   :  NCO.PRG
***  Program:  dCALCULATOR
***  Date   :  April 25, 1994
***
***               - dBASE 5 precision related errors: dBASE returns
***                 2.100000000000001 for 1.1 + 1 when set decimals
***                 is 15 or above.  There is no work around this
***                 problem in the code.
***
***               - Monochrome colors are not verified for correct display.
***
***               - To make the TAPE function available and to save
***                 data from the calculator you must set a DOS
***                 environment variable as follows:
***
***                         SET CALCULATOR=<valid directory>
***
***------------------------------------------------------------------***
***------------------------------------------------------------------***
#include "NCO.H"

*** Does not allow second copy of dCalculator to be executed.
*** All objects are public and do not instanciated as in true OOP
*** environment, therefore errors will occur in the second time.

IF TYPE("dCALCULATOR") # "U"
   DO CalcError WITH E_ALREADY
   RETURN
ELSE
   PUBLIC dCALCULATOR        && If defined dCalculator is running
   PRIVATE IdleVar
ENDIF

DO DefObjects                && Define objects that contain calc properties
DO SetEnv                    && Set environment (dBASE SET commands)
DO Assignments               && Assign values to variables / properties
DO About WITH FALSE          && Display credit form
DO SetFiles                  && Detrmines path and access to tape and save files
DO RestCalc                  && Restore values from previous session
DO DefForm                   && Define the main form
DO DefPush                   && Define all pushbuttons
DO DispTop                   && Define the indicators and display objects

m->IdleVar = CalcForm.OPEN()                    && Open the form
                                                && Since Open() method is used,
                                                && execution will continue
                                                && pass this statement
m->IdleVar = CalcForm.S36.SetFocus()            && Set focus to = pushbutton

IF .NOT. Options.Save2Dir                       && Error if tape not available
    DO CalcError WITH E_SAVETAPE
ENDIF
IF .NOT. PRINTSTATUS()                          && Error if printer not available
    DO CalcError WITH E_PRINTER
ENDIF

RETURN

*** End of main module NCO.PRG


***--------------------------------------------------------------***
***--------------------------------------------------------------***
***  Procedure   : DefObjects
***  Description : Define all objects.  Effort was made to gather
***                all related variables in an object to minimize
***                the number of private and public variables in
***                the program.
***--------------------------------------------------------------***
***--------------------------------------------------------------***
PROCEDURE DefObjects

*** Screen related values
DEFINE OBJECT ScreenAttr CUSTOM                               ;
       IsColor     ISCOLOR()                                , ;
       ScrHeight   VAL(RIGHT(SET("DISPLAY"),2))             , ;
       ScrHgtAdj   NILL                                     , ;
       ScrWidth    80                                       , ;
       ScrWthAdj   NILL

*** Files and saved values
DEFINE OBJECT Options CUSTOM                                  ;
       Save2Dir       FALSE                                 , ;
       TapeFn         PP_TAPEFILENAME                       , ;
       SaveFn         PP_SAVEFILENAME                       , ;
       MemValue       NILL                                  , ;
       CalcValue      NILL                                  , ;
       PrevOper       NILL                                  , ;
       CurrOper       NILL                                  , ;
       DispVar        NULL                                  , ;
       NewVarFlg      TRUE                                  , ;
       ClearFlag      FALSE                                 , ;
       DispMode       DEC_MODE                              , ;
       Tape           FALSE                                 , ;
       Prntr          FALSE                                 , ;
       CFormTop       PP_CALCFORM_TOP                       , ;
       CFormLeft      PP_CALCFORM_LEFT                      , ;
       WinState       NILL

*** All affected SETs values
DEFINE OBJECT EnvirnSets CUSTOM                               ;
       STalk        SET("TALK")                             , ;
       SEcho        SET("ECHO")                             , ;
       SEsca        SET("ESCAPE")                           , ;
       SSafe        SET("SAFETY")                           , ;
       SCent        SET("CENTURY")                          , ;
       SDeci        SET("DECIMALS")                         , ;
       SExac        SET("EXACT")                            , ;
       SType        SET("TYPEAHEAD")                        , ;
       SCons        SET("CONSOLE")                          , ;
       SPrin        SET("PRINTER")                          , ;
       SPoin        SET("POINT")

*** Colors used in dCalculator
DEFINE OBJECT Colors CUSTOM                                   ;
       CFNormal     IIF(ScreenAttr.IsColor, PP_C_CFNORMAL  , PP_M_CFNORMAL  )  , ;
       CFIcon       IIF(ScreenAttr.IsColor, PP_C_CFICON    , PP_M_CFICON    )  , ;
       CFBorder     IIF(ScreenAttr.IsColor, PP_C_CFBORDER  , PP_M_CFBORDER  )  , ;
       CFHigh       IIF(ScreenAttr.IsColor, PP_C_CFHIGH    , PP_M_CFHIGH    )  , ;
       CFText       IIF(ScreenAttr.IsColor, PP_C_CFTEXT    , PP_M_CFTEXT    )  , ;
       CFFolder     IIF(ScreenAttr.IsColor, PP_C_CFFOLDER  , PP_M_CFFOLDER  )  , ;
       CFEditor     IIF(ScreenAttr.IsColor, PP_C_CFEDITOR  , PP_M_CFEDITOR  )  , ;
       CFTBlank     IIF(ScreenAttr.IsColor, PP_C_CFTBLANK  , PP_M_CFTBLANK  )  , ;
       CFTPrint     IIF(ScreenAttr.IsColor, PP_C_CFTPRINT  , PP_M_CFTPRINT  )  , ;
       CFTMemory    IIF(ScreenAttr.IsColor, PP_C_CFTMEMORY , PP_M_CFTMEMORY )  , ;
       CFTOpratr    IIF(ScreenAttr.IsColor, PP_C_CFTOPRATR , PP_M_CFTOPRATR )  , ;
       CFTHexDec    IIF(ScreenAttr.IsColor, PP_C_CFTHEXDEC , PP_M_CFTHEXDEC )  , ;
       CFTDisplay   IIF(ScreenAttr.IsColor, PP_C_CFTDISPLAY, PP_M_CFTDISPLAY)  , ;
       CFPNormal    IIF(ScreenAttr.IsColor, PP_C_CFPNORMAL , PP_M_CFPNORMAL )  , ;
       CFPPnormal   IIF(ScreenAttr.IsColor, PP_C_CFPPNORMAL, PP_M_CFPPNORMAL)  , ;
       CFPHilite    IIF(ScreenAttr.IsColor, PP_C_CFPHILITE , PP_M_CFPHILITE )  , ;
       CFPPhilite   IIF(ScreenAttr.IsColor, PP_C_CFPPHILITE, PP_M_CFPPHILITE)  , ;
       CFPShadow    IIF(ScreenAttr.IsColor, PP_C_CFPSHADOW , PP_M_CFPSHADOW )  , ;
       CFPDisable   IIF(ScreenAttr.IsColor, PP_C_CFPDISABLE, PP_M_CFPDISABLE)  , ;
       CFPClear     IIF(ScreenAttr.IsColor, PP_C_CFPCLEAR  , PP_M_CFPCLEAR  )  , ;
       EFButton     IIF(ScreenAttr.IsColor, PP_C_EFBUTTON  , PP_M_EFBUTTON  )  , ;
       EFNormal     IIF(ScreenAttr.IsColor, PP_C_EFNORMAL  , PP_M_EFNORMAL  )  , ;
       EFHilite     IIF(ScreenAttr.IsColor, PP_C_EFHILITE  , PP_M_EFHILITE  )

RETURN

*** End of procedure DefObjects

***--------------------------------------------------------------***
***--------------------------------------------------------------***
***  Procedure   : SetEnv
***  Description : Called every time the form gets focus.
***                Sets all the directly affected SETs
***--------------------------------------------------------------***
***--------------------------------------------------------------***
PROCEDURE SetEnv

SET TALK          OFF
SET ECHO          OFF
SET ESCAPE        OFF
SET SAFETY        OFF
SET CENTURY       OFF
SET DECIMAL TO    DCML
SET EXACT         ON
SET TYPEAHEAD TO  MAXDISP
SET CONSOLE       ON
SET PRINTER       OFF

*** If compiled - clear the screen
IF "COMPILER" $ UPPER(VERSION())
   SET COLOR TO
   SET STATUS OFF
   SET SCOREBOARD OFF
ENDIF

RETURN

*** End of procedure SetEnv


***--------------------------------------------------------------***
***--------------------------------------------------------------***
***  Procedure   : Assignments
***  Description : Assigns values after SetEnv is executed
***                Avoid 'littering' the screen if TALK is ON
***--------------------------------------------------------------***
***--------------------------------------------------------------***
PROCEDURE Assignments

m->dCALCULATOR = TRUE
ScreenAttr.ScrHgtAdj = IIF(ScreenAttr.ScrHeight==50, 12,    ;
                       IIF(ScreenAttr.ScrHeight==43,  9, 0 ))

RETURN

*** End of procedure Assignments


***--------------------------------------------------------------***
***--------------------------------------------------------------***
***  Procedure   : SetFiles
***  Description : Sets Save2Dir and path to tape and save files.
***                If DOS environmental variable dCALCULATOR is
***                set to a valid directory, all will be saved,
***                and tape will be available.
***                If variable does not exist, changes will be
***                saved and tape available only if at least one
***                of the 2 files already exists in current directory.
***--------------------------------------------------------------***
***--------------------------------------------------------------***
PROCEDURE SetFiles
PRIVATE DirArr, NumFiles, SaveDir

m->SaveDir = GETENV("dCALCULATOR")
IF m->SaveDir == NULL
   m->SaveDir =  ".\"
   Options.Save2Dir = IIF( FILE(Options.TapeFn) .OR. ;
                           FILE(Options.SaveFn), TRUE, FALSE )
ELSE
   m->SaveDir  = IIF(SUBSTR(m->SaveDir,LEN(m->SaveDir),1) # "\", ;
                 m->SaveDir + "\", m->SaveDir )

   DECLARE DirArr[1]
   NumFiles = ADIR( DirArr, m->SaveDir + "*.*", "ADHRS" )

   IF m->NumFiles > NILL
      Options.Save2Dir = TRUE
   ELSE
      Options.Save2Dir = FALSE
   ENDIF
ENDIF

Options.SaveFN   = m->SaveDir + PP_SAVEFILENAME
Options.TapeFN   = m->SaveDir + PP_TAPEFILENAME

RETURN

*** End of procedure SetFiles


***--------------------------------------------------------------***
***--------------------------------------------------------------***
***  Procedure   : RestCalc
***  Description : Restore calculator state and assign to Option
***                object's properties.
***--------------------------------------------------------------***
***--------------------------------------------------------------***
PROCEDURE RestCalc

IF Options.Save2Dir .AND. FILE( Options.SaveFN )
   RESTORE FROM (Options.SaveFN) ADDITIVE
   Options.MemValue   =  dCalcV1
   Options.CalcValue  =  dCalcV2
   Options.PrevOper   =  dCalcV3
   Options.CurrOper   =  dCalcV4
   Options.DispVar    =  dCalcV5
   Options.NewVarFlg  =  dCalcV6
   Options.ClearFlag  =  dCalcV7
   Options.DispMode   =  dCalcV8
   Options.Tape       =  IIF(Options.Save2Dir=TRUE, dCalcV9, FALSE)
   Options.Prntr      =  dCalcV10
   Options.CFormTop   =  dCalcV11
   Options.CFormLeft  =  dCalcV12
   Options.WinState   =  dCalcV13
ENDIF
Options.DispVar = MakeVar(Options.CalcValue)

RETURN

*** End of procedure RestCalc


***--------------------------------------------------------------***
***--------------------------------------------------------------***
***  Procedure   :  RestEnv
***  Description :  Resets the dBASE environment to its original
***                 state.  Called every time the calculator form
***                 loses focus.
***                 Due to a conflict between the dot reference
***                 notation and the macrosubstitution notation,
***                 it is not possible to use & on an objects
***                 property.  Hence the crude way of handling
***                 the Sets
***--------------------------------------------------------------***
***--------------------------------------------------------------***
PROCEDURE RestEnv
PRIVATE VTemp

SET DECIMAL   TO EnvirnSets.SDeci
SET TYPEAHEAD TO EnvirnSets.SType

m->VTemp =       EnvirnSets.SExac
SET EXACT        &VTemp
m->VTemp =       EnvirnSets.SCent
SET CENTURY      &VTemp
m->VTemp =       EnvirnSets.SSafe
SET SAFETY       &VTemp
m->VTemp =       EnvirnSets.SEsca
SET ESCAPE       &VTemp
m->VTemp =       EnvirnSets.SPrin
SET PRINTER      &VTemp
m->VTemp =       EnvirnSets.SCons
SET CONSOLE      &VTemp
m->VTemp =       EnvirnSets.SEcho
SET ECHO         &VTemp
m->VTemp =       EnvirnSets.STalk
SET TALK         &VTemp

RETURN

*** End of procedure RestFiles


***--------------------------------------------------------------***
***--------------------------------------------------------------***
***  Procedure   :  DefForm
***  Description :  Defines the form and rectangles.  If tape is up
***                 It will be defined as well.
***--------------------------------------------------------------***
***--------------------------------------------------------------***
PROCEDURE DefForm

DEFINE FORM CalcForm                                             ;
       FROM Options.CFormTop   + ScreenAttr.ScrHgtAdj,           ;
            Options.CFormLeft  + ScreenAttr.ScrWthAdj            ;
       TO   Options.CFormTop   + PP_CALCFORM_HEIGHT + ScreenAttr.ScrHgtAdj,      ;
            Options.CFormLeft  + PP_CALCFORM_WIDTH  + ScreenAttr.ScrWthAdj       ;
       PROPERTY                                                  ;
            OnOpen                "UnAbout"                    , ;
            OnClose               RelForm                      , ;
            OnGotFocus            SetEnv                       , ;
            OnLostFocus           RestEnv                      , ;
            Text                  PP_C_CFORM_HEADER            , ;
            ColorNormal           Colors.CFNormal              , ;
            ColorIcon             Colors.CFIcon                , ;
            ColorBorder           Colors.CFBorder              , ;
            ColorBorderHighlight  Colors.CFBorder              , ;
            Moveable              TRUE                         , ;
            Sizeable              FALSE                        , ;
            Maximize              FALSE                        , ;
            Minimize              TRUE                         , ;
            WindowState           Options.WinState             , ;
            EscExit               TRUE                         , ;
            Shadow                TRUE

*** Indicator rectangle
DEFINE RECTANGLE R00 OF CalcForm FROM PP_R00_TOP,    PP_R00_LEFT    ;
                                 TO   PP_R00_BOTTOM, PP_R00_RIGHT   ;
      PROPERTY                                                      ;
           ColorNormal           Colors.CFNormal                  , ;
           BorderStyle           RAISED                           , ;
           Shadow                FALSE                            , ;
           Border                TRUE

*** Display rectangle
DEFINE RECTANGLE R01 OF CalcForm FROM PP_R01_TOP,    PP_R01_LEFT    ;
                                 TO   PP_R01_BOTTOM, PP_R01_RIGHT   ;
      PROPERTY                                                      ;
           ColorNormal           Colors.CFNormal                  , ;
           BorderStyle           RAISED                           , ;
           Shadow                FALSE                            , ;
           Border                TRUE

*** Functions, operators and digits outer rectangle
DEFINE RECTANGLE R02 OF CalcForm FROM PP_R02_TOP,    PP_R02_LEFT    ;
                                 TO   PP_R02_BOTTOM, PP_R02_RIGHT   ;
      PROPERTY                                                      ;
           ColorNormal           Colors.CFNormal                  , ;
           BorderStyle           RAISED                           , ;
           Shadow                FALSE                            , ;
           Border                TRUE

*** Functions rectangle
DEFINE RECTANGLE R1 OF CalcForm FROM PP_R1_TOP,    PP_R1_LEFT       ;
                                TO   PP_R1_BOTTOM, PP_R1_RIGHT      ;
      PROPERTY                                                      ;
           ColorNormal          Colors.CFNormal                   , ;
           BorderStyle          LOWERED                           , ;
           Shadow               FALSE                             , ;
           Border               TRUE

*** Digits rectangle
DEFINE RECTANGLE R2 OF CalcForm FROM PP_R2_TOP,    PP_R2_LEFT       ;
                                TO   PP_R2_BOTTOM, PP_R2_RIGHT      ;
      PROPERTY                                                      ;
           ColorNormal          Colors.CFNormal                   , ;
           BorderStyle          LOWERED                           , ;
           Shadow               FALSE                             , ;
           Border               TRUE

*** Operators rectangle
DEFINE RECTANGLE R3 OF CalcForm FROM PP_R3_TOP,    PP_R3_LEFT       ;
                                TO   PP_R3_BOTTOM, PP_R3_RIGHT      ;
      PROPERTY                                                      ;
           ColorNormal          Colors.CFNormal                   , ;
           BorderStyle          LOWERED                           , ;
           Shadow               FALSE                             , ;
           Border               TRUE

IF Options.Tape
   DO AdjForm
ENDIF

RETURN

*** End of procedure DefForm



***--------------------------------------------------------------***
***--------------------------------------------------------------***
***  Procedure   :  AdjForm
***  Description :
***--------------------------------------------------------------***
***--------------------------------------------------------------***
PROCEDURE AdjForm

CalcForm.Draw  = FALSE

IF Options.Tape
   CalcForm.Width = PP_CALCFORM_RIGHT - PP_CALCFORM_LEFT + MAXDISP +   ;
                                                         FOLDERADJ + 9

   DEFINE RECTANGLE R4 OF CalcForm FROM PP_R4_TOP,    PP_R4_LEFT        ;
                                   TO   PP_R4_BOTTOM, PP_R4_RIGHT       ;
          PROPERTY                                                      ;
               ColorNormal          Colors.CFNormal                   , ;
               BorderStyle          RAISED                            , ;
               Shadow               FALSE                             , ;
               Border               TRUE

   DO DefEditor

#ifdef FOLDER
   DO DefFolder
#endif

#ifdef EDFRAME
   DO DefFrame
#endif

ELSE

#ifdef FOLDER
   DO RelFolder
#endif

   m->IdleVar=CalcForm.Ed.Save()
   m->IdleVar=CalcForm.Ed.Release()
   m->IdleVar=CalcForm.R4.Release()

   CalcForm.Width = PP_CALCFORM_RIGHT - PP_CALCFORM_LEFT + 1
ENDIF

CalcForm.Draw  = TRUE

RETURN

*** End of procedure AdjForm



***--------------------------------------------------------------***
***--------------------------------------------------------------***
***  Procedure   :  DefEditor
***  Description :  Define the tape (editor)
***--------------------------------------------------------------***
***--------------------------------------------------------------***
PROCEDURE DefEditor
PRIVATE FN

CalcForm.Draw  = FALSE

m->FN = Options.TapeFN
DEFINE EDITOR Ed OF CalcForm FROM PP_ED_TOP,    PP_ED_LEFT       ;
                             TO   PP_ED_BOTTOM, PP_ED_RIGHT      ;
       PROPERTY                                                  ;
             DataSource           "FILENAME " + Options.TapeFN , ;
             Text                 NULL                         , ;
             ColorNormal          Colors.CFEditor              , ;
             ColorHighlight       Colors.CFEditor              , ;
             ColorBorder          Colors.CFEditor              , ;
             ColorBorderHighlight Colors.CFEditor              , ;
             ColorDisabled        Colors.CFEditor              , ;
             ColorIcon            Colors.CFEditor              , ;
             ColorScrollBar       Colors.CFNormal              , ;
             SysMenu              FALSE                        , ;
             Sizeable             FALSE                        , ;
             EscExit              FALSE                        , ;
             Modify               FALSE                        , ;
             Moveable             FALSE                        , ;
             Shadow               FALSE

#ifdef EDFRAME
   CalcForm.Ed.OnOpen      = "DefFrame"
   CalcForm.Ed.OnLostFocus = "DefFrame"
   CalcForm.Ed.OnGotFocus  = "RelFrame"
   CalcForm.Ed.OnClose     = "RelFrame"
#endif

CalcForm.Ed.LineNo = CalcForm.Ed.Lines
CalcForm.Draw  = TRUE

RETURN

*** End of procedure DefEditor


#ifdef FOLDER
***--------------------------------------------------------------***
***--------------------------------------------------------------***
***  Procedure   :  DefFolder
***  Description :  Define folder (text objects).
***                 It is compiled only if FOLDER is defined in NCO.H
***--------------------------------------------------------------***
***--------------------------------------------------------------***
PROCEDURE DefFolder

CalcForm.Draw  = FALSE
FOR Indx = 0 TO 17
    m->ObjName = "TS" + LTRIM(STR(m->Indx))
    DEFINE TEXT &ObjName OF CalcForm AT Indx, PP_R01_RIGHT+2  ;
           PROPERTY TEXT "", ColorNormal Colors.CFFolder, Label FALSE
NEXT
CalcForm.Draw  = TRUE

RETURN

*** End of procedure DefFolder


***--------------------------------------------------------------***
***--------------------------------------------------------------***
***  Procedure   :  RelFolder
***  Description :  Release all text objects used for the folder.
***                 It is compiled only if FOLDER is defined in NCO.H
***--------------------------------------------------------------***
***--------------------------------------------------------------***
PROCEDURE RelFolder
PRIVATE Indx, ObjName

CalcForm.Draw  = FALSE
FOR Indx = 0 TO 17
    m->ObjName = "TS" + LTRIM(STR(m->Indx))
    m->IdleVar = CalcForm.&ObjName..Release()
NEXT
CalcForm.Draw  = TRUE

RETURN

*** End of procedure RelFolder
#endif


#ifdef EDFRAME
***--------------------------------------------------------------***
***--------------------------------------------------------------***
***  Procedure   :  DefFrame
***  Description :  Define editor frame to emulate a rectangle.
***                 It is compiled only if EDFRAME is defined in NCO.H
***--------------------------------------------------------------***
***--------------------------------------------------------------***
PROCEDURE DefFrame
PRIVATE Indx, ObjName

CalcForm.Draw  = FALSE

DEFINE TEXT LN0  OF CalcForm AT  PP_ED_TOP + 0, PP_ED_RIGHT ;
       PROPERTY TEXT "", ColorNormal Colors.CFNormal
FOR Indx = 1 TO 14
    m->ObjName = "LN" + LTRIM(STR(m->Indx))
    DEFINE TEXT &ObjName OF CalcForm AT m->Indx + PP_ED_TOP, PP_ED_RIGHT ;
           PROPERTY TEXT "", ColorNormal Colors.CFNormal
NEXT
DEFINE TEXT LN15 OF CalcForm AT PP_ED_TOP + 15, PP_ED_LEFT+1 ;
       PROPERTY TEXT REPLICATE("",CalcForm.Ed.Width-2)+"", ColorNormal Colors.CFNormal

CalcForm.Draw  = TRUE
RETURN

*** End of procedure DefFrame


***--------------------------------------------------------------***
***--------------------------------------------------------------***
***  Procedure   :  RelFrame
***  Description :  Release all text objects used to emulate the fame.
***                 It is compiled only if EDFRAME is defined in NCO.H
***--------------------------------------------------------------***
***--------------------------------------------------------------***
PROCEDURE RelFrame
PRIVATE Indx, ObjName

CalcForm.Draw  = FALSE
FOR Indx = 0 TO 15
    m->ObjName = "LN" + LTRIM(STR(m->Indx))
    m->IdleVar = CalcForm.&ObjName..Release()
NEXT
CalcForm.Draw  = TRUE

RETURN

*** End of procedure RelFrame
#endif


***--------------------------------------------------------------***
***--------------------------------------------------------------***
***  Procedure   :  DefPush
***  Description :  Define all pushbuttons.
***--------------------------------------------------------------***
***--------------------------------------------------------------***
PROCEDURE DefPush

*** Rectangle 1 ----------------------------------------------

DEFINE PUSHBUTTON S1 OF CalcForm AT PP_S1_TOP, PP_S1_LEFT    ;
       PROPERTY                                              ;
            OnClick             "CalcAct"                  , ;
            Text                PP_C_CFORM_PS_TEXT         , ;
            Width               LEN(PP_C_CFORM_PS_TEXT)+3  , ;
            Height              1                          , ;
            StatusMessage       PP_C_CFORM_PS_MESS         , ;
            ColorNormal         Colors.CFPNormal           , ;
            ColorPickNormal     Colors.CFPPnormal          , ;
            ColorHighlight      Colors.CFPPhilite          , ;
            ColorPickHighlight  Colors.CFPPhilite          , ;
            ColorShadow         Colors.CFPShadow           , ;
            Border              FALSE

DEFINE PUSHBUTTON S5 OF CalcForm AT PP_S5_TOP, PP_S5_LEFT    ;
       PROPERTY                                              ;
            OnClick             "CalcAct"                  , ;
            Text                PP_C_CFORM_NW_TEXT         , ;
            Width               LEN(PP_C_CFORM_NW_TEXT)+3  , ;
            Height              1                          , ;
            StatusMessage       PP_C_CFORM_NW_MESS         , ;
            ColorNormal         Colors.CFPNormal           , ;
            ColorPickNormal     Colors.CFPPnormal          , ;
            ColorHighlight      Colors.CFPPhilite          , ;
            ColorPickHighlight  Colors.CFPPhilite          , ;
            ColorShadow         Colors.CFPShadow           , ;
            Border              FALSE

DEFINE PUSHBUTTON S2 OF CalcForm AT PP_S2_TOP, PP_S2_LEFT    ;
       PROPERTY                                              ;
            OnClick             "CalcAct"                  , ;
            Text                PP_C_CFORM_TP_TEXT         , ;
            Width               LEN(PP_C_CFORM_TP_TEXT)+3  , ;
            Height              1                          , ;
            StatusMessage       PP_C_CFORM_TP_MESS         , ;
            ColorNormal         Colors.CFPNormal           , ;
            ColorPickNormal     Colors.CFPPnormal          , ;
            ColorHighlight      Colors.CFPPhilite          , ;
            ColorPickHighlight  Colors.CFPPhilite          , ;
            ColorShadow         Colors.CFPShadow           , ;
            ColorDisabled       Colors.CFPDisable          , ;
            Border              FALSE                      , ;
            Enabled             (Options.Save2Dir = TRUE)

DEFINE PUSHBUTTON S3 OF CalcForm AT PP_S3_TOP, PP_S3_LEFT    ;
       PROPERTY                                              ;
            OnClick             "CalcAct"                  , ;
            Text                PP_C_CFORM_PR_TEXT         , ;
            Width               LEN(PP_C_CFORM_PR_TEXT)+3  , ;
            Height              1                          , ;
            StatusMessage       PP_C_CFORM_PR_MESS         , ;
            ColorNormal         Colors.CFPNormal           , ;
            ColorPickNormal     Colors.CFPPnormal          , ;
            ColorHighlight      Colors.CFPPhilite          , ;
            ColorPickHighlight  Colors.CFPPhilite          , ;
            ColorShadow         Colors.CFPShadow           , ;
            ColorDisabled       Colors.CFPDisable          , ;
            Border              FALSE                      , ;
            Enabled             PRINTSTATUS()

DEFINE PUSHBUTTON S6 OF CalcForm AT PP_S6_TOP, PP_S6_LEFT    ;
       PROPERTY                                              ;
            OnClick             "CalcAct"                  , ;
            Text                PP_C_CFORM_HD_TEXT         , ;
            Width               LEN(PP_C_CFORM_HD_TEXT)+3  , ;
            Height              1                          , ;
            StatusMessage       PP_C_CFORM_HD_MESS         , ;
            ColorNormal         Colors.CFPNormal           , ;
            ColorPickNormal     Colors.CFPPnormal          , ;
            ColorHighlight      Colors.CFPPhilite          , ;
            ColorPickHighlight  Colors.CFPPhilite          , ;
            ColorShadow         Colors.CFPShadow           , ;
            Border              FALSE

DEFINE PUSHBUTTON S4 OF CalcForm AT PP_S4_TOP, PP_S4_LEFT    ;
       PROPERTY                                              ;
            OnClick             "CalcAct"                  , ;
            Text                PP_C_CFORM_AB_TEXT         , ;
            Width               LEN(PP_C_CFORM_AB_TEXT)+3  , ;
            Height              1                          , ;
            ColorNormal         Colors.CFPNormal           , ;
            ColorPickNormal     Colors.CFPPnormal          , ;
            ColorHighlight      Colors.CFPPhilite          , ;
            ColorPickHighlight  Colors.CFPPhilite          , ;
            ColorShadow         Colors.CFPShadow           , ;
            Border              FALSE

*** Rectangle 2 ----------------------------------------------

DEFINE PUSHBUTTON S10 OF CalcForm AT PP_S10_TOP, PP_S10_LEFT ;
       PROPERTY                                              ;
            Text                "&D"                       , ;
            OnClick             "CalcAct"                  , ;
            Width               5                          , ;
            Height              1                          , ;
            ColorNormal         Colors.CFPNormal           , ;
            ColorPickNormal     Colors.CFPPnormal          , ;
            ColorHighlight      Colors.CFPHilite           , ;
            ColorPickHighlight  Colors.CFPPhilite          , ;
            ColorShadow         Colors.CFPShadow           , ;
            ColorDisabled       Colors.CFPDisable          , ;
            Border              FALSE                      , ;
            Enabled             (Options.DispMode = HEX_MODE)

DEFINE PUSHBUTTON S11 OF CalcForm AT PP_S11_TOP, PP_S11_LEFT ;
       PROPERTY                                              ;
            Text                "&E"                       , ;
            OnClick             "CalcAct"                  , ;
            Width               5                          , ;
            Height              1                          , ;
            ColorNormal         Colors.CFPNormal           , ;
            ColorPickNormal     Colors.CFPPnormal          , ;
            ColorHighlight      Colors.CFPHilite           , ;
            ColorPickHighlight  Colors.CFPPhilite          , ;
            ColorShadow         Colors.CFPShadow           , ;
            ColorDisabled       Colors.CFPDisable          , ;
            Border              FALSE                      , ;
            Enabled             (Options.DispMode = HEX_MODE)

DEFINE PUSHBUTTON S12 OF CalcForm AT PP_S12_TOP, PP_S12_LEFT ;
       PROPERTY                                              ;
            Text                "&F"                       , ;
            OnClick             "CalcAct"                  , ;
            Width               5                          , ;
            Height              1                          , ;
            ColorNormal         Colors.CFPNormal           , ;
            ColorPickNormal     Colors.CFPPnormal          , ;
            ColorHighlight      Colors.CFPHilite           , ;
            ColorPickHighlight  Colors.CFPPhilite          , ;
            ColorShadow         Colors.CFPShadow           , ;
            ColorDisabled       Colors.CFPDisable          , ;
            Border              FALSE                      , ;
            Enabled             (Options.DispMode = HEX_MODE)

DEFINE PUSHBUTTON S7  OF CalcForm AT PP_S7_TOP, PP_S7_LEFT   ;
       PROPERTY                                              ;
            Text                "&A"                       , ;
            OnClick             "CalcAct"                  , ;
            Width               5                          , ;
            Height              1                          , ;
            ColorNormal         Colors.CFPNormal           , ;
            ColorPickNormal     Colors.CFPPnormal          , ;
            ColorHighlight      Colors.CFPHilite           , ;
            ColorPickHighlight  Colors.CFPPhilite          , ;
            ColorShadow         Colors.CFPShadow           , ;
            ColorDisabled       Colors.CFPDisable          , ;
            Border              FALSE                      , ;
            Enabled             (Options.DispMode = HEX_MODE)

DEFINE PUSHBUTTON S8  OF CalcForm AT PP_S8_TOP, PP_S8_LEFT   ;
       PROPERTY                                              ;
            Text                "&B"                       , ;
            OnClick             "CalcAct"                  , ;
            Width               5                          , ;
            Height              1                          , ;
            ColorNormal         Colors.CFPNormal           , ;
            ColorPickNormal     Colors.CFPPnormal          , ;
            ColorHighlight      Colors.CFPHilite           , ;
            ColorPickHighlight  Colors.CFPPhilite          , ;
            ColorShadow         Colors.CFPShadow           , ;
            ColorDisabled       Colors.CFPDisable          , ;
            Border              FALSE                      , ;
            Enabled             (Options.DispMode = HEX_MODE)

DEFINE PUSHBUTTON S9  OF CalcForm AT PP_S9_TOP, PP_S9_LEFT   ;
       PROPERTY                                              ;
            Text                "&C"                       , ;
            OnClick             "CalcAct"                  , ;
            Width               5                          , ;
            Height              1                          , ;
            ColorNormal         Colors.CFPNormal           , ;
            ColorPickNormal     Colors.CFPPnormal          , ;
            ColorHighlight      Colors.CFPHilite           , ;
            ColorPickHighlight  Colors.CFPPhilite          , ;
            ColorShadow         Colors.CFPShadow           , ;
            ColorDisabled       Colors.CFPDisable          , ;
            Border              FALSE                      , ;
            Enabled             (Options.DispMode = HEX_MODE)

DEFINE PUSHBUTTON S14 OF CalcForm AT PP_S14_TOP, PP_S14_LEFT ;
       PROPERTY                                              ;
            Text                "&7"                       , ;
            OnClick             "CalcAct"                  , ;
            Width               5                          , ;
            Height              1                          , ;
            ColorNormal         Colors.CFPNormal           , ;
            ColorPickNormal     Colors.CFPPnormal          , ;
            ColorHighlight      Colors.CFPHilite           , ;
            ColorPickHighlight  Colors.CFPPhilite          , ;
            ColorShadow         Colors.CFPShadow           , ;
            Border              FALSE

DEFINE PUSHBUTTON S15 OF CalcForm AT PP_S15_TOP, PP_S15_LEFT ;
       PROPERTY                                              ;
            Text                "&8"                       , ;
            OnClick             "CalcAct"                  , ;
            Width               5                          , ;
            Height              1                          , ;
            ColorNormal         Colors.CFPNormal           , ;
            ColorPickNormal     Colors.CFPPnormal          , ;
            ColorHighlight      Colors.CFPHilite           , ;
            ColorPickHighlight  Colors.CFPPhilite          , ;
            ColorShadow         Colors.CFPShadow           , ;
            Border              FALSE

DEFINE PUSHBUTTON S16 OF CalcForm AT PP_S16_TOP, PP_S16_LEFT ;
       PROPERTY                                              ;
            Text                "&9"                       , ;
            OnClick             "CalcAct"                  , ;
            Width               5                          , ;
            Height              1                          , ;
            ColorNormal         Colors.CFPNormal           , ;
            ColorPickNormal     Colors.CFPPnormal          , ;
            ColorHighlight      Colors.CFPHilite           , ;
            ColorPickHighlight  Colors.CFPPhilite          , ;
            ColorShadow         Colors.CFPShadow           , ;
            Border              FALSE

DEFINE PUSHBUTTON S20 OF CalcForm AT PP_S20_TOP, PP_S20_LEFT ;
       PROPERTY                                              ;
            Text                "&4"                       , ;
            OnClick             "CalcAct"                  , ;
            Width               5                          , ;
            Height              1                          , ;
            ColorNormal         Colors.CFPNormal           , ;
            ColorPickNormal     Colors.CFPPnormal          , ;
            ColorHighlight      Colors.CFPHilite           , ;
            ColorPickHighlight  Colors.CFPPhilite          , ;
            ColorShadow         Colors.CFPShadow           , ;
            Border              FALSE

DEFINE PUSHBUTTON S21 OF CalcForm AT PP_S21_TOP, PP_S21_LEFT ;
       PROPERTY                                              ;
            Text                "&5"                       , ;
            OnClick             "CalcAct"                  , ;
            Width               5                          , ;
            Height              1                          , ;
            ColorNormal         Colors.CFPNormal           , ;
            ColorPickNormal     Colors.CFPPnormal          , ;
            ColorHighlight      Colors.CFPHilite           , ;
            ColorPickHighlight  Colors.CFPPhilite          , ;
            ColorShadow         Colors.CFPShadow           , ;
            Border              FALSE

DEFINE PUSHBUTTON S22 OF CalcForm AT PP_S22_TOP, PP_S22_LEFT ;
       PROPERTY                                              ;
            Text                "&6"                       , ;
            OnClick             "CalcAct"                  , ;
            Width               5                          , ;
            Height              1                          , ;
            ColorNormal         Colors.CFPNormal           , ;
            ColorPickNormal     Colors.CFPPnormal          , ;
            ColorHighlight      Colors.CFPHilite           , ;
            ColorPickHighlight  Colors.CFPPhilite          , ;
            ColorShadow         Colors.CFPShadow           , ;
            Border              FALSE

DEFINE PUSHBUTTON S26 OF CalcForm AT PP_S26_TOP, PP_S26_LEFT ;
       PROPERTY                                              ;
            Text                "&1"                       , ;
            OnClick             "CalcAct"                  , ;
            Width               5                          , ;
            Height              1                          , ;
            ColorNormal         Colors.CFPNormal           , ;
            ColorPickNormal     Colors.CFPPnormal          , ;
            ColorHighlight      Colors.CFPHilite           , ;
            ColorPickHighlight  Colors.CFPPhilite          , ;
            ColorShadow         Colors.CFPShadow           , ;
            Border              FALSE

DEFINE PUSHBUTTON S27 OF CalcForm AT PP_S27_TOP, PP_S27_LEFT ;
       PROPERTY                                              ;
            Text                "&2"                       , ;
            OnClick             "CalcAct"                  , ;
            Width               5                          , ;
            Height              1                          , ;
            ColorNormal         Colors.CFPNormal           , ;
            ColorPickNormal     Colors.CFPPnormal          , ;
            ColorHighlight      Colors.CFPHilite           , ;
            ColorPickHighlight  Colors.CFPPhilite          , ;
            ColorShadow         Colors.CFPShadow           , ;
            Border              FALSE

DEFINE PUSHBUTTON S28 OF CalcForm AT PP_S28_TOP, PP_S28_LEFT ;
       PROPERTY                                              ;
            Text                "&3"                       , ;
            OnClick             "CalcAct"                  , ;
            Width               5                          , ;
            Height              1                          , ;
            ColorNormal         Colors.CFPNormal           , ;
            ColorPickNormal     Colors.CFPPnormal          , ;
            ColorHighlight      Colors.CFPHilite           , ;
            ColorPickHighlight  Colors.CFPPhilite          , ;
            ColorShadow         Colors.CFPShadow           , ;
            Border              FALSE

DEFINE PUSHBUTTON S33 OF CalcForm AT PP_S33_TOP, PP_S33_LEFT ;
       PROPERTY                                              ;
            Text                "&"+EnvirnSets.Spoin       , ;
            OnClick             "CalcAct"                  , ;
            Width               5                          , ;
            Height              1                          , ;
            ColorNormal         Colors.CFPNormal           , ;
            ColorPickNormal     Colors.CFPPnormal          , ;
            ColorHighlight      Colors.CFPHilite           , ;
            ColorPickHighlight  Colors.CFPPhilite          , ;
            ColorShadow         Colors.CFPShadow           , ;
            ColorDisabled       Colors.CFPDisable          , ;
            Border              FALSE                      , ;
            Enabled             (Options.DispMode = DEC_MODE)

DEFINE PUSHBUTTON S32 OF CalcForm AT PP_S32_TOP, PP_S32_LEFT ;
       PROPERTY                                              ;
            Text                "&0"                       , ;
            OnClick             "CalcAct"                  , ;
            Width               5                          , ;
            Height              1                          , ;
            ColorNormal         Colors.CFPNormal           , ;
            ColorPickNormal     Colors.CFPPnormal          , ;
            ColorHighlight      Colors.CFPHilite           , ;
            ColorPickHighlight  Colors.CFPPhilite          , ;
            ColorShadow         Colors.CFPShadow           , ;
            Border              FALSE

DEFINE PUSHBUTTON S34 OF CalcForm AT PP_S34_TOP, PP_S34_LEFT ;
       PROPERTY                                              ;
            Text                "&"+SYMBOLPLUSMI           , ;
            OnClick             "CalcAct"                  , ;
            Width               5                          , ;
            Height              1                          , ;
            ColorNormal         Colors.CFPNormal           , ;
            ColorPickNormal     Colors.CFPPnormal          , ;
            ColorHighlight      Colors.CFPHilite           , ;
            ColorPickHighlight  Colors.CFPPhilite          , ;
            ColorShadow         Colors.CFPShadow           , ;
            ColorDisabled       Colors.CFPDisable          , ;
            Border              FALSE                      , ;
            Enabled             (Options.DispMode = DEC_MODE)

*** Rectangle 3 ----------------------------------------------

DEFINE PUSHBUTTON S13 OF CalcForm AT PP_S13_TOP, PP_S13_LEFT ;
       PROPERTY                                              ;
            OnClick             "CalcAct"                  , ;
            Text                "&"+SYMBOLMEMORY+SYMBOLPLUS, ;
            StatusMessage       PP_C_CFORM_MADD_MESS       , ;
            Width               6                          , ;
            Height              1                          , ;
            ColorNormal         Colors.CFTMemory           , ;
            ColorPickNormal     Colors.CFPPnormal          , ;
            ColorHighlight      Colors.CFTMemory           , ;
            ColorPickHighlight  Colors.CFPPhilite          , ;
            ColorShadow         Colors.CFPShadow           , ;
            Border              FALSE

DEFINE PUSHBUTTON S25 OF CalcForm AT PP_S25_TOP, PP_S25_LEFT ;
       PROPERTY                                              ;
            OnClick             "CalcAct"                  , ;
            Text                SYMBOLMEMORY+SYMBOLRECALL  , ;
            StatusMessage       PP_C_CFORM_MRCL_MESS       , ;
            Width               6                          , ;
            Height              1                          , ;
            ColorNormal         Colors.CFTmemory           , ;
            ColorPickNormal     Colors.CFPPnormal          , ;
            ColorHighlight      Colors.CFPPhilite          , ;
            ColorPickHighlight  Colors.CFPPhilite          , ;
            ColorShadow         Colors.CFPShadow           , ;
            ColorDisabled       Colors.CFPDisable          , ;
            Border              FALSE                      , ;
            Enabled             (Options.MemValue # NILL)

DEFINE PUSHBUTTON S19 OF CalcForm AT PP_S19_TOP, PP_S19_LEFT ;
       PROPERTY                                              ;
            OnClick             "CalcAct"                  , ;
            Text                SYMBOLMEMORY+SYMBOLMINUS   , ;
            StatusMessage       PP_C_CFORM_MSUB_MESS       , ;
            Width               6                          , ;
            Height              1                          , ;
            ColorNormal         Colors.CFTMemory           , ;
            ColorPickNormal     Colors.CFPPnormal          , ;
            ColorHighlight      Colors.CFPPhilite          , ;
            ColorPickHighlight  Colors.CFPPhilite          , ;
            ColorShadow         Colors.CFPShadow           , ;
            Border              FALSE

DEFINE PUSHBUTTON S31 OF CalcForm AT PP_S31_TOP, PP_S31_LEFT ;
       PROPERTY                                              ;
            OnClick             "CalcAct"                  , ;
            Text                SYMBOLMEMORY+SYMBOLCLEAR   , ;
            StatusMessage       PP_C_CFORM_MCLR_MESS       , ;
            Width               6                          , ;
            Height              1                          , ;
            ColorNormal         Colors.CFTMemory           , ;
            ColorPickNormal     Colors.CFPPnormal          , ;
            ColorHighlight      Colors.CFTMemory           , ;
            ColorHighlight      Colors.CFPPhilite          , ;
            ColorShadow         Colors.CFPShadow           , ;
            ColorDisabled       Colors.CFPDisable          , ;
            Border              FALSE                      , ;
            Enabled             (Options.MemValue # NILL)

DEFINE PUSHBUTTON S35 OF CalcForm AT PP_S35_TOP, PP_S35_LEFT ;
       PROPERTY                                              ;
            Text                "&"+SYMBOLPLUS             , ;
            OnClick             "CalcAct"                  , ;
            Width               5                          , ;
            Height              1                          , ;
            ColorNormal         Colors.CFPNormal           , ;
            ColorPickNormal     Colors.CFPPnormal          , ;
            ColorHighlight      Colors.CFPHilite           , ;
            ColorPickHighlight  Colors.CFPPhilite          , ;
            ColorShadow         Colors.CFPShadow           , ;
            Border              FALSE

DEFINE PUSHBUTTON S29 OF CalcForm AT PP_S29_TOP, PP_S29_LEFT ;
       PROPERTY                                              ;
            Text                "&"+SYMBOLMINUS            , ;
            OnClick             "CalcAct"                  , ;
            Width               5                          , ;
            Height              1                          , ;
            ColorNormal         Colors.CFPNormal           , ;
            ColorPickNormal     Colors.CFPPnormal          , ;
            ColorHighlight      Colors.CFPHilite           , ;
            ColorPickHighlight  Colors.CFPPhilite          , ;
            ColorShadow         Colors.CFPShadow           , ;
            Border              FALSE

DEFINE PUSHBUTTON S23 OF CalcForm AT PP_S23_TOP, PP_S23_LEFT ;
       PROPERTY                                              ;
            Text                "&"+SYMBOLMULTI            , ;
            OnClick             "CalcAct"                  , ;
            Width               5                          , ;
            Height              1                          , ;
            ColorNormal         Colors.CFPNormal           , ;
            ColorPickNormal     Colors.CFPPnormal          , ;
            ColorHighlight      Colors.CFPHilite           , ;
            ColorPickHighlight  Colors.CFPPhilite          , ;
            ColorShadow         Colors.CFPShadow           , ;
            Border              FALSE

DEFINE PUSHBUTTON S17 OF CalcForm AT PP_S17_TOP, PP_S17_LEFT ;
       PROPERTY                                              ;
            Text                "&"+SYMBOLDIVIDE           , ;
            OnClick             "CalcAct"                  , ;
            Width               5                          , ;
            Height              1                          , ;
            ColorNormal         Colors.CFPNormal           , ;
            ColorPickNormal     Colors.CFPPnormal          , ;
            ColorHighlight      Colors.CFPHilite           , ;
            ColorPickHighlight  Colors.CFPPhilite          , ;
            ColorShadow         Colors.CFPShadow           , ;
            Border              FALSE

DEFINE PUSHBUTTON S24 OF CalcForm AT PP_S24_TOP, PP_S24_LEFT ;
       PROPERTY                                              ;
            Text                "&"+SYMBOLSQUARE           , ;
            Onclick             "CalcAct"                  , ;
            Width               5                          , ;
            Height              1                          , ;
            ColorNormal         Colors.CFPNormal           , ;
            ColorPickNormal     Colors.CFPPnormal          , ;
            ColorHighlight      Colors.CFPHilite           , ;
            ColorPickHighlight  Colors.CFPPhilite          , ;
            ColorShadow         Colors.CFPShadow           , ;
            Border              FALSE

DEFINE PUSHBUTTON S30 OF CalcForm AT PP_S30_TOP, PP_S30_LEFT ;
       PROPERTY                                              ;
            Text                "&"+SYMBOLPERCE            , ;
            Onclick             "CalcAct"                  , ;
            Width               5                          , ;
            Height              1                          , ;
            ColorNormal         Colors.CFPNormal           , ;
            ColorPickNormal     Colors.CFPPnormal          , ;
            ColorHighlight      Colors.CFPHilite           , ;
            ColorPickHighlight  Colors.CFPPhilite          , ;
            ColorShadow         Colors.CFPShadow           , ;
            Border              FALSE

DEFINE PUSHBUTTON S36 OF CalcForm AT PP_S36_TOP,PP_S36_LEFT  ;
       PROPERTY                                              ;
            Text                "&"+SYMBOLEQUAL            , ;
            OnClick             "CalcAct"                  , ;
            Width               5                          , ;
            Height              1                          , ;
            ColorNormal         Colors.CFPNormal           , ;
            ColorPickNormal     Colors.CFPPnormal          , ;
            ColorHighlight      Colors.CFPHilite           , ;
            ColorPickHighlight  Colors.CFPPhilite          , ;
            ColorShadow         Colors.CFPShadow           , ;
            ColorSelected       Colors.CFPPhilite          , ;
            Default             TRUE                       , ;
            Border              FALSE

DEFINE PUSHBUTTON S18 OF CalcForm AT PP_S18_TOP,PP_S18_LEFT  ;
       PROPERTY                                              ;
            Text                SYMBOLCLEAR                , ;
            OnClick             "CalcAct"                  , ;
            Width               5                          , ;
            Height              1                          , ;
            ColorNormal         Colors.CFPClear            , ;
            ColorPickNormal     Colors.CFPClear            , ;
            ColorHighlight      Colors.CFPPhilite          , ;
            ColorPickHighlight  Colors.CFPClear            , ;
            ColorShadow         Colors.CFPShadow           , ;
            Border              FALSE

RETURN

*** End of procedure DefPush


***--------------------------------------------------------------***
***--------------------------------------------------------------***
***  Procedure   :  DispTop
***  Description :  Define text object for indicators and display
***--------------------------------------------------------------***
***--------------------------------------------------------------***
PROCEDURE DispTop

CalcForm.Draw = FALSE

DEFINE TEXT TOP1 OF CalcForm AT PP_TOP1_TOP, PP_TOP1_LEFT                            ;
       PROPERTY                                                                      ;
            Text             IIF( Options.Prntr, SYMBOLPRINT, SYMBOLBLANK )        , ;
            Label            FALSE                                                 , ;
            ColorNormal      IIF( Options.Prntr, Colors.CFTPrint,                    ;
                                                 Colors.CFTBlank )

DEFINE TEXT TOP2 OF CalcForm AT PP_TOP2_TOP, PP_TOP2_LEFT                            ;
       PROPERTY                                                                      ;
            Text             IIF( Options.MemValue=NILL, SYMBOLBLANK, SYMBOLMEMORY), ;
            Label            FALSE                                                 , ;
            ColorNormal      IIF( Options.MemValue=NILL, Colors.CFTBlank,            ;
                                                         Colors.CFTMemory)

DEFINE TEXT TOP3 OF CalcForm AT PP_TOP3_TOP, PP_TOP3_LEFT                  ;
       PROPERTY                                                            ;
            Text             Options.DispMode                            , ;
            Label            FALSE                                       , ;
            ColorNormal      Colors.CFTHexDec

DEFINE TEXT TOP4 OF CalcForm AT PP_TOP4_TOP, PP_TOP4_LEFT                  ;
       PROPERTY                                                            ;
            Text             Symbol(Options.PrevOper)                    , ;
            Label            FALSE                                       , ;
            ColorNormal      Colors.CFTOpratr

DEFINE TEXT TOP5 OF CalcForm AT PP_TOP5_TOP, PP_TOP5_LEFT                   ;
       PROPERTY                                                             ;
            Text             IIF( Options.MemValue = NILL,                  ;
                                  REPLICATE(SYMBOLBLANK,MAXDISP),           ;
                                  MakeVar(Options.MemValue) )             , ;
            Label            FALSE                                        , ;
            ColorNormal      IIF( Options.MemValue=NILL, Colors.CFTBlank,   ;
                                                         Colors.CFTMemory )

DEFINE TEXT TOP6 OF CalcForm AT PP_TOP6_TOP, PP_TOP6_LEFT                   ;
       PROPERTY                                                             ;
            Text             Options.DispVar                              , ;
            Label            FALSE                                        , ;
            ColorNormal      Colors.CFTDisplay

CalcForm.Draw = TRUE

RETURN

*** End of procedure DispTop


***--------------------------------------------------------------***
***--------------------------------------------------------------***
***  Procedure   :  RelForm
***  Description :  Called when OnClose of CalcForm is fired.
***                 Saves the calculator state and releases
***                 all objects and forms.
***--------------------------------------------------------------***
***--------------------------------------------------------------***
PROCEDURE RelForm

PRIVATE dCalcV1, dCalcV2, dCalcV3, dCalcV4,  dCalcV5,  dCalcV6
PRIVATE dCalcV7, dCalcV8, dCalcV9, dCalcV10, dCalcV11, dCalcV12
PRIVATE VTalk

DO SetEnv             && Because RestEnv is executed OnLostFocus of CalcForm
IF Options.Save2Dir
   dCalcV1  =  Options.MemValue
   dCalcV2  =  Options.CalcValue
   dCalcV3  =  Options.PrevOper
   dCalcV4  =  Options.CurrOper
   dCalcV5  =  Options.DispVar
   dCalcV6  =  Options.NewVarFlg
   dCalcV7  =  Options.ClearFlag
   dCalcV8  =  Options.DispMode
   dCalcV9  =  Options.Tape
   dCalcV10 =  Options.Prntr
   dCalcV11 =  CalcForm.Top
   dCalcV12 =  CalcForm.Left
   dCalcV13 =  CalcForm.WindowState
   SAVE TO (Options.SaveFN) ALL LIKE dCalcV*
   Release ALL LIKE dCalcV*.*
ENDIF

Release m->dCALCULATOR

m->IdleVar = CalcForm.RELEASE()
m->IdleVar = ScreenAttr.Release()
m->IdleVar = Options.Release()
m->IdleVar = Colors.Release()

DO RestEnv
** We still dont want to 'litter' the screen
IF SET("TALK") = "ON"
   SET TALK OFF
   m->VTalk = SET('TALK')
ELSE
   m->VTalk = "OFF"
ENDIF
m->IdleVar = EnvirnSets.Release()
SET TALK &VTalk

RETURN

*** End of procedure RelForm


***--------------------------------------------------------------***
***--------------------------------------------------------------***
***  Procedure   :  CalcAct
***  Description :  Main dispatching procedure for all pushbuttons.
***--------------------------------------------------------------***
***--------------------------------------------------------------***
PROCEDURE CalcAct
PRIVATE Object

m->Object = UPPER(This.Name)
DO CASE
   CASE m->Object == "S1"
        DO Paste
        RETURN
   CASE m->Object == "S2"
        DO TapeUp
   CASE m->Object == "S3"
        DO PrinterUp
   CASE m->Object == "S4"
        DO About WITH TRUE
   CASE m->Object == "S5"
        DO New
   CASE m->Object == "S6"
        DO HexToggle
   CASE m->Object == "S7"
        DO Digit WITH "A"
   CASE m->Object == "S8"
        DO Digit WITH "B"
   CASE m->Object == "S9"
        DO Digit WITH "C"
   CASE m->Object == "S10"
        DO Digit WITH "D"
   CASE m->Object == "S11"
        DO Digit WITH "E"
   CASE m->Object == "S12"
        DO Digit WITH "F"
   CASE m->Object == "S13"
        DO MemoAct WITH M_ADD
   CASE m->Object == "S14"
        DO Digit WITH "7"
   CASE m->Object == "S15"
        DO Digit WITH "8"
   CASE m->Object == "S16"
        DO Digit WITH "9"
   CASE m->Object == "S17"
        DO OperAct WITH DIVIDE
   CASE m->Object == "S18"
        DO ClearAct
   CASE m->Object == "S19"
        DO MemoAct WITH M_SUB
   CASE m->Object == "S20"
        DO Digit WITH "4"
   CASE m->Object == "S21"
        DO Digit WITH "5"
   CASE m->Object == "S22"
        DO Digit WITH "6"
   CASE m->Object == "S23"
        DO OperAct WITH MULTI
   CASE m->Object == "S24"
        DO OperAct WITH SQUARE
   CASE m->Object == "S25"
        DO MemoAct WITH M_REC
   CASE m->Object == "S26"
        DO Digit WITH "1"
   CASE m->Object == "S27"
        DO Digit WITH "2"
   CASE m->Object == "S28"
        DO Digit WITH "3"
   CASE m->Object == "S29"
        DO OperAct WITH MINUS
   CASE m->Object == "S30"
        DO OperAct WITH PERCE
   CASE m->Object == "S31"
        DO MemoAct WITH M_CLR
   CASE m->Object == "S32"
        DO Digit WITH NILLSTR
   CASE m->Object == "S33"
        DO Period
   CASE m->Object == "S34"
        DO Negate
   CASE m->Object == "S35"
        DO OperAct WITH PLUS
   CASE m->Object == "S36"
        DO OperAct WITH EQUAL
ENDCASE

CalcForm.TOP6.Text = Options.DispVar
m->IdleVar         = CalcForm.S36.SetFocus()         && Focus on =

RETURN

*** End of procedure CalcAct


***--------------------------------------------------------------***
***--------------------------------------------------------------***
***  Function    :  MakeVar
***  Description :  Accepts numeric value and transfers it manualy
***                 to a string that can be displayed as calculator
***                 or memory display.  It translate to either Decimal
***                 or Hexadecimal string based on current calculator
***                 mode.  STR() of dBASE does not always returns
***                 strings formatted nicely, and that is why there
***                 is a need for such elaborated function.
***                 Currently there is a problem with high precision
***                 decimal point and 1.0 is returned as 1.00000000000001
***                 I have no work around this problem.
***--------------------------------------------------------------***
***--------------------------------------------------------------***
FUNCTION MakeVar
PARAMETER Num

PRIVATE Temp, MaxVal

IF Options.DispMode = DEC_MODE
   m->MaxVal = VAL(REPLICATE("9",MAXDISP-1))
   IF m->Num > m->MaxVal .OR. m->Num < NILL-m->MaxVal
      DO CalcError WITH IIF(m->Object=="S13".OR.m->Object=="S19",E_OVER_FLM,E_OVER_FLD)
      m->Num = NILL
   ENDIF
   m->Temp = LTRIM(STR(m->Num,MAXDISP-IIF(m->Num<NILL,NILL,1),DCML-1))
   m->Temp = SPACE(MAXDISP-LEN(m->Temp)) + m->Temp
   IF AT(EnvirnSets.Spoin, m->Temp) > NILL
      m->Temp = STUFF( m->Temp, AT(EnvirnSets.Spoin,m->Temp), 1, "." )
   ENDIF
   DO WHILE SUBSTR(m->Temp,MAXDISP,1) = NILLSTR .AND. AT( ".", m->Temp) > NILL
      m->Temp = SPACE(1) + SUBSTR(m->Temp,1,MAXDISP-1)
   ENDDO
   IF SUBSTR(m->Temp,MAXDISP,1) == "."
      m->Temp = SPACE(1) + SUBSTR(m->Temp,1,MAXDISP-1)
   ENDIF
   IF AT(".", m->Temp) > NILL
      m->Temp = STUFF( m->Temp, AT(".",m->Temp), 1, EnvirnSets.Spoin )
   ENDIF
ELSE
   m->MaxVal = HTOI(REPLICATE("F",MAXDISP))
   IF m->Num > m->MaxVal .OR. m->Num < NILL-m->MaxVal
      DO CalcError WITH IIF(m->Object=="S13".OR.m->Object=="S19",E_OVER_FLM,E_OVER_FLD)
      m->Num = NILL
   ENDIF
   m->Temp = ITOH( m->Num )
   m->Temp = m->Temp + SPACE(MAXDISP-LEN(m->Temp))
ENDIF
RETURN m->Temp

*** End of procedure MakeVar


***--------------------------------------------------------------***
***--------------------------------------------------------------***
***  Function    :  ITOH
***  Description :  Accepts decimal number and returns the equivalent
***                 Hex string.  If the number is less than 1, 0 will
***                 be returned. (no fraction or negative is processed.
***--------------------------------------------------------------***
***--------------------------------------------------------------***
FUNCTION ITOH
PARAMETER Num

PRIVATE Nnum, Ret, TDiv, TRem, HStr
m->Nnum  = INT(Num)
m->HStr = "0123456789ABCDEF"
m->Ret  = NULL
IF m->Nnum > 1
   IF m->Nnum < 16
      m->Ret = SUBSTR(m->HStr, m->Nnum+1, 1)
   ELSE
      DO WHILE m->Nnum > 15
         m->TDiv = INT(m->Nnum/16)
         m->TRem = MOD(m->Nnum,16)
         m->Ret = SUBSTR(m->HStr, m->TRem+1, 1) + m->Ret
         m->Nnum = m->TDiv
      ENDDO
      m->Ret = SUBSTR(m->HStr, m->TDiv+1, 1) + m->Ret
   ENDIF
ELSE
   m->Ret = NILLSTR
ENDIF
RETURN m->Ret

*** End of function ITOH


***--------------------------------------------------------------***
***--------------------------------------------------------------***
***  Function    :  HTOI
***  Description :  Accepts string representing a Hex number and
***                 translate it to its decimal numeric value.
***--------------------------------------------------------------***
***--------------------------------------------------------------***
FUNCTION HTOI
PARAMETER String

PRIVATE Ret, Indx, TChar
m->String = UPPER(LTRIM(RTRIM(m->String)))
m->Ret = NILL
FOR m->Indx=1 TO LEN(m->String)
    m->TChar = SUBSTR(m->String, LEN(m->String)-m->Indx+1, 1)
    DO CASE
       CASE m->TChar $ "ABCDEF"
            m->Ret = m->Ret + ( (ASC(m->TChar)-55) * 16^(m->Indx-1) )
       CASE m->TChar $ "0123456789"
            m->Ret = m->Ret + ( VAL(m->TChar) * 16^(m->Indx-1) )
       OTHERWISE
            m->Ret = NILL
            EXIT
    ENDCASE
NEXT
RETURN m->Ret

*** End of function HTOI


***--------------------------------------------------------------***
***--------------------------------------------------------------***
***  Procedure   :  Paste
***  Description :  Keyboards the value in calculator display
***                 and closes the CalcForm.  If value is 0 it
***                 will not be keyboarded.
***--------------------------------------------------------------***
***--------------------------------------------------------------***
PROCEDURE Paste

IF (IIF(Options.DispMode=DEC_MODE, VAL(Options.DispVar), ;
                                   HTOI(Options.DispVar)) # NILL)
   KEYBOARD ALLTRIM(Options.DispVar)
ENDIF
m->IdleVar = CalcForm.CLOSE()
RETURN

*** End of procedure Paste


***--------------------------------------------------------------***
***--------------------------------------------------------------***
***  Procedure   :  New
***  Description :  Erase the save file (NCO.SAV) and the tape
***                 file (NCO.TAP).  Clear the display and the
***                 operator.  Start new tape.
***--------------------------------------------------------------***
***--------------------------------------------------------------***
PROCEDURE New

IF Options.Save2Dir
   IF FILE( Options.SaveFN )
      ERASE ( Options.SaveFN )
   ENDIF
   IF Options.Tape
      m->IdleVar = CalcForm.Ed.Release()
   ENDIF
   IF FILE( Options.TapeFN )
      ERASE ( Options.TapeFN )
   ENDIF
   IF Options.Tape
      Do DefEditor
#ifdef EDFRAME
      DO DefFrame
#endif
   ENDIF
ENDIF
Options.ClearFlag  = FALSE
Options.PrevOper   = NILL
Options.CurrOper   = NILL
Options.CalcValue  = NILL
Options.MemValue   = NILL
Options.DispVar    = IIF(Options.DispMode == DEC_MODE, SPACE(MAXDISP-1) + NILLSTR, ;
                     NILLSTR + SPACE(MAXDISP-1))
DO DispTop

RETURN

*** End of procedure New


***--------------------------------------------------------------***
***--------------------------------------------------------------***
***  Procedure   :  TapeUp
***  Description :  Toggles the tape part on/off.  If the tape was
***                 open, the time and date of closure will be
***                 written to it before it closes.
***--------------------------------------------------------------***
***--------------------------------------------------------------***
PROCEDURE TapeUp

IF Options.Tape
   DO WriteTape WITH NULL
   DO WriteTape WITH PP_TAPE_OFF_LINE1
   DO WriteTape WITH PP_TAPE_OFF_LINE2
   DO WriteTape WITH NULL
   Options.Tape = FALSE
ELSE
   Options.Tape = TRUE
ENDIF

DO AdjForm
IF Options.Tape
   DO WriteTape WITH Symbol(Options.PrevOper) + SYMBOLBLANK + Options.DispVar
ENDIF
DO DispTop

RETURN

*** End of procedure TapeUp


***--------------------------------------------------------------***
***--------------------------------------------------------------***
***  Procedure   :  PrinterUp
***  Description :  Toggles the printer redirection on/off.  Any
***                 calculation that would be written to the tape
***                 is also directed to the printer.  The current
***                 printer is assumed (or LPT1 if nothing else
***                 is specified)
***--------------------------------------------------------------***
***--------------------------------------------------------------***
PROCEDURE PrinterUp

IF Options.Prntr
   Options.Prntr = FALSE
   DO DispTop
ELSE
   IF PRINTSTATUS()
      Options.Prntr = TRUE
      DO DispTop
   ELSE
      DO CalcError WITH E_PRINTER          && printer problem
   ENDIF
ENDIF

RETURN

*** End of procedure PrinterUp


***--------------------------------------------------------------***
***--------------------------------------------------------------***
***  Procedure   :  Period
***  Description :  Add decimal point to displayed number
***                 Available only in Decimal mode.
***--------------------------------------------------------------***
***--------------------------------------------------------------***
PROCEDURE Period

IF Options.DispMode = DEC_MODE
   IF LEN(LTRIM(Options.DispVar)) >= MAXDISP - 1 .AND. .NOT. Options.NewVarFlg
      RETURN
   ENDIF
   IF Options.NewVarFlg
      Options.DispVar   = SPACE(MAXDISP-1) + NILLSTR
      Options.NewVarFlg = FALSE
   ENDIF
   IF AT( EnvirnSets.Spoin, Options.DispVar ) == NILL
      Options.DispVar = SUBSTR(Options.DispVar,2) + EnvirnSets.Spoin
   ENDIF
   Options.ClearFlag = FALSE
ENDIF
RETURN

*** End of procedure Period


***--------------------------------------------------------------***
***--------------------------------------------------------------***
***  Procedure   :  Negate
***  Description :  Negate the number in the display.
***                 Available only in Decimal mode.
***--------------------------------------------------------------***
***--------------------------------------------------------------***
PROCEDURE Negate
PRIVATE DashPos

IF Options.DispMode = DEC_MODE
  IF VAL(Options.DispVar) # NILL
     DO WriteTape WITH SYMBOLPLUSMI + SYMBOLBLANK + Options.DispVar
     m->DashPos = AT("-", Options.DispVar)
     IF m->DashPos = NILL             && positive, make negative
        m->DashPos = MAXDISP - LEN(LTRIM(Options.DispVar))
        Options.DispVar = STUFF(Options.DispVar,m->DashPos,1,"-")
     ELSE                             && negative, make positive
        Options.DispVar = STUFF(Options.DispVar,m->DashPos,1," ")
     ENDIF
     Options.ClearFlag = FALSE
  ENDIF
ENDIF
RETURN

*** End of procedure Negate


***--------------------------------------------------------------***
***--------------------------------------------------------------***
***  Procedure   :  Digit
***  Description :  Add any digit (or A-F) to number in display.
***--------------------------------------------------------------***
***--------------------------------------------------------------***
PROCEDURE Digit
PARAMETER Dig

IF Options.DispMode = DEC_MODE
   IF SUBSTR(Options.DispVar,MAXDISP,1)=NILLSTR .AND. ;
              LEN(LTRIM(Options.DispVar))=1 .AND. m->Dig=NILLSTR
      RETURN
   ENDIF
   IF Options.NewVarFlg
      Options.DispVar = SPACE(MAXDISP-1) + NILLSTR
      Options.NewVarFlg = FALSE
   ENDIF
   IF LEN(LTRIM(Options.DispVar)) < MAXDISP-1       && will it fit in display ?
      IF SUBSTR(Options.DispVar,MAXDISP,1)=NILLSTR .AND. ;
         LEN(LTRIM(Options.DispVar))=1
         Options.DispVar = SPACE(MAXDISP)
      ENDIF
      Options.DispVar = SUBSTR(Options.DispVar,2) + m->Dig
      Options.ClearFlag = FALSE
   ENDIF
ELSE
   IF SUBSTR(Options.DispVar,1,1)=NILLSTR .AND. ;
      LEN(RTRIM(Options.DispVar))=1 .AND. m->Dig=NILLSTR
      RETURN
   ENDIF
   IF Options.NewVarFlg
      Options.DispVar = NILLSTR + SPACE(MAXDISP-1)
      Options.NewVarFlg = FALSE
   ENDIF
   IF LEN(RTRIM(Options.DispVar)) < MAXDISP
      IF SUBSTR(Options.DispVar,1,1)=NILLSTR .AND. LEN(RTRIM(Options.DispVar))=1
         Options.DispVar = NULL
      ENDIF
      Options.DispVar = RTRIM(Options.DispVar) + m->Dig
      Options.DispVar = Options.DispVar + SPACE(MAXDISP-LEN(Options.DispVar))
      Options.ClearFlag = FALSE
   ENDIF
ENDIF
RETURN

*** End of procedure Digit

***--------------------------------------------------------------***
***--------------------------------------------------------------***
***  Procedure   :  MemoAct
***  Description :  Perform actions associated with the memory
***                 of the calculator.
***                 Memory Recall and Memory Clear are disabled
***                 When The value in memory is 0.
***--------------------------------------------------------------***
***--------------------------------------------------------------***
PROCEDURE MemoAct
PARAMETER MAct

DO CASE
   CASE m->MAct = M_CLR
        Options.MemValue = NILL
   CASE m->MAct = M_ADD
        Options.MemValue = Options.MemValue + IIF(Options.DispMode=DEC_MODE, VAL(Options.DispVar), HTOI(Options.DispVar))
        Options.NewVarFlg = TRUE
   CASE m->MAct = M_SUB
        Options.MemValue = Options.MemValue - IIF(Options.DispMode=DEC_MODE, VAL(Options.DispVar), HTOI(Options.DispVar))
   CASE m->MAct = M_REC
        IF Options.MemValue # NILL
           Options.DispVar = MakeVar(Options.MemValue)
           Options.NewVarFlg = TRUE
        ENDIF
ENDCASE

Options.ClearFlag = FALSE
CalcForm.S25.Enabled = (Options.MemValue # NILL )
CalcForm.S31.Enabled = (Options.MemValue # NILL )
DO DispTop

RETURN

*** End of procedure MemoAct


***--------------------------------------------------------------***
***--------------------------------------------------------------***
***  Procedure   :  ClearAct
***  Description :  Two phase clear action.
***                 The first clears the value from the display
***                 and leaves the operator alive (C).  The second
***                 clears the value and the operator (CE)
***--------------------------------------------------------------***
***--------------------------------------------------------------***
PROCEDURE ClearAct

IF .NOT. Options.ClearFlag
   Options.ClearFlag = TRUE
ELSE
   Options.ClearFlag = FALSE
   Options.PrevOper  = NILL
   Options.CalcValue = NILL
   CalcForm.TOP4.Text = SYMBOLBLANK
   DO WriteTape WITH SYMBOLCLEAR
ENDIF
Options.DispVar = IIF(Options.DispMode=DEC_MODE, SPACE(MAXDISP-1) + NILLSTR, ;
                  NILLSTR + SPACE(MAXDISP-1))

RETURN

*** End of procedure ClearAct


***--------------------------------------------------------------***
***--------------------------------------------------------------***
***  Procedure   :  OperAct
***  Description :  Performs the actual calculation when an operator
***                 is pressed.  The +-*/ are carried to next value
***                 while the square root and % are immediate
***                 operators.  String are sent to tape in numerous
***                 places.
***--------------------------------------------------------------***
***--------------------------------------------------------------***
PROCEDURE OperAct
PARAMETER PCurrOper

PRIVATE Temp, Write

DO CASE
   CASE m->PCurrOper < SQUARE
        m->Write = TRUE
        DO CASE
           CASE Options.PrevOper == NILL
                Options.CalcValue = IIF(Options.DispMode=DEC_MODE, VAL(Options.DispVar), HTOI(Options.DispVar))
           CASE Options.PrevOper == PLUS .OR. Options.PrevOper == MINUS
                IF Options.PrevOper == PLUS
                   Options.CalcValue = Options.CalcValue + IIF(Options.DispMode=DEC_MODE, VAL(Options.DispVar), HTOI(Options.DispVar))
                   DO WriteTape WITH SYMBOLPLUS + SYMBOLBLANK + Options.DispVar
                ELSE
                   Options.CalcValue = Options.CalcValue - IIF(Options.DispMode=DEC_MODE, VAL(Options.DispVar), HTOI(Options.DispVar))
                   DO WriteTape WITH SYMBOLMINUS + SYMBOLBLANK + Options.DispVar
                ENDIF
           CASE Options.PrevOper == MULTI .OR. Options.PrevOper == DIVIDE
                IF Options.PrevOper = MULTI
                   Options.CalcValue  = Options.CalcValue * IIF(Options.DispMode=DEC_MODE, VAL(Options.DispVar), HTOI(Options.DispVar))
                   DO WriteTape WITH SYMBOLMULTI + SYMBOLBLANK + Options.DispVar
                ELSE
                   IF (Options.DispMode == DEC_MODE .AND. VAL(Options.DispVar)  == NILL ) .OR. ;
                      (Options.DispMode == HEX_MODE .AND. TRIM(Options.DispVar) == NILLSTR )
                      DO CalcError WITH E_DIVISION
                      m->Write = FALSE
                   ELSE
                      Options.CalcValue  = Options.CalcValue / IIF(Options.DispMode=DEC_MODE, VAL(Options.DispVar), HTOI(Options.DispVar))
                      DO WriteTape WITH SYMBOLDIVIDE + SYMBOLBLANK + Options.DispVar
                   ENDIF
                ENDIF
           CASE Options.PrevOper == EQUAL
                m->Write = FALSE
                Options.CalcValue = IIF(Options.DispMode=DEC_MODE, VAL(Options.DispVar), HTOI(Options.DispVar))
           CASE Options.PrevOper == SQUARE
                Options.DispVar = MakeVar( IIF(Options.DispMode=DEC_MODE, VAL(Options.DispVar), HTOI(Options.DispVar)) ^0.5 )
                m->Write = FALSE
        ENDCASE
        Options.PrevOper = m->PCurrOper
        Options.DispVar  = MakeVar(Options.CalcValue)
        IF m->Write
            DO WriteTape WITH SYMBOLEQUAL + SYMBOLBLANK + Options.DispVar
        ENDIF

   CASE m->PCurrOper == SQUARE
        IF (IIF(Options.DispMode=DEC_MODE, VAL(Options.DispVar), HTOI(Options.DispVar)) >= NILL)
           DO CASE
              CASE Options.PrevOper = NILL
                   DO WriteTape WITH SYMBOLSQUARE + SYMBOLBLANK + Options.DispVar
                   Options.DispVar = MakeVar( IIF(Options.DispMode=DEC_MODE, VAL(Options.DispVar), HTOI(Options.DispVar)) ^0.5 )
                   Options.CalcValue = IIF(Options.DispMode=DEC_MODE, VAL(Options.DispVar), HTOI(Options.DispVar))
                   DO WriteTape WITH SYMBOLBLANK + SYMBOLBLANK + Options.DispVar
                   Options.PrevOper = SQUARE
              CASE Options.PrevOper = EQUAL
                   DO WriteTape WITH SYMBOLSQUARE + SYMBOLBLANK + Options.DispVar
                   Options.DispVar = MakeVar( IIF(Options.DispMode=DEC_MODE, VAL(Options.DispVar), HTOI(Options.DispVar)) ^0.5 )
                   DO WriteTape WITH SYMBOLBLANK + SYMBOLBLANK + Options.DispVar
              OTHERWISE
                 IF (IIF(Options.DispMode=DEC_MODE, VAL(Options.DispVar), HTOI(Options.DispVar)) >= NILL)
                     DO WriteTape WITH SYMBOLSQUARE + SYMBOLBLANK + Options.DispVar
                     Options.DispVar = MakeVar( IIF(Options.DispMode=DEC_MODE, VAL(Options.DispVar), HTOI(Options.DispVar)) ^0.5 )
                 ELSE
                     DO CalcError WITH E_NEG_SQR
                 ENDIF
           ENDCASE
        ELSE
           DO CalcError WITH E_NEG_SQR
        ENDIF

   CASE m->PCurrOper == PERCE
        DO WriteTape WITH SYMBOLPERCE + SYMBOLBLANK + Options.DispVar
        DO CASE
           CASE Options.PrevOper == PLUS .OR. Options.PrevOper == MINUS
                m->TEMP = IIF(Options.PrevOper = PLUS,  IIF(Options.DispMode=DEC_MODE, ;
                       VAL(Options.DispVar), HTOI(Options.DispVar)) /100, 0-(IIF(Options.DispMode=DEC_MODE, ;
                       VAL(Options.DispVar), HTOI(Options.DispVar)) /100)) * Options.CalcValue
                Options.CalcValue = Options.CalcValue  + m->Temp
                DO WriteTape WITH Symbol(Options.PrevOper) + SYMBOLBLANK + MakeVar(m->Temp)
           CASE Options.PrevOper == MULTI .OR. Options.PrevOper == DIVIDE
                m->Temp = IIF(Options.DispMode=DEC_MODE,VAL(Options.DispVar), HTOI(Options.DispVar))/100*Options.CalcValue
                Options.CalcValue = Options.CalcValue  * IIF(Options.PrevOper = MULTI, m->Temp, 1/m->Temp)
                DO WriteTape WITH Symbol(Options.PrevOper) + SYMBOLBLANK + MakeVar(m->Temp)
        ENDCASE
        Options.DispVar  = MakeVar(Options.CalcValue)
        CalcForm.TOP4.Text = SYMBOLEQUAL
        DO WriteTape WITH SYMBOLEQUAL + SYMBOLBLANK + Options.DispVar
        Options.PrevOper = EQUAL

   CASE m->PCurrOper == EQUAL
        DO WriteTape WITH Symbol(Options.PrevOper) + SYMBOLBLANK + MakeVar(Options.DispVar)

ENDCASE

Options.ClearFlag = FALSE
Options.NewVarFlg = TRUE
IF m->PCurrOper < SQUARE
   CalcForm.TOP4.Text = Symbol(m->PCurrOper)
ENDIF
Options.CurrOper = m->PCurrOper

RETURN

*** End of procedure OperAct


***--------------------------------------------------------------***
***--------------------------------------------------------------***
***  Procedure   :  HexToggle
***  Description :  Toggles between hex and decimal modes.
***                 In Decimal mode A-F are not available.
***                 In Hex mode . and  are not available.
***--------------------------------------------------------------***
***--------------------------------------------------------------***
PROCEDURE HexToggle

IF Options.DispMode = HEX_MODE
   Options.DispMode = DEC_MODE
   Options.DispVar = MakeVar(HTOI(Options.DispVar))
ELSE
   Options.DispMode = HEX_MODE
   Options.DispVar = MakeVar(VAL(Options.DispVar))
ENDIF
CalcForm.TOP5.Text    = IIF( Options.MemValue=NILL, REPLICATE(SYMBOLBLANK, ;
                        MAXDISP), MakeVar(Options.MemValue) )
CalcForm.S7.Enabled   = (Options.DispMode=HEX_MODE)
CalcForm.S8.Enabled   = (Options.DispMode=HEX_MODE)
CalcForm.S9.Enabled   = (Options.DispMode=HEX_MODE)
CalcForm.S10.Enabled  = (Options.DispMode=HEX_MODE)
CalcForm.S11.Enabled  = (Options.DispMode=HEX_MODE)
CalcForm.S12.Enabled  = (Options.DispMode=HEX_MODE)
CalcForm.S33.Enabled  = (Options.DispMode=DEC_MODE)
CalcForm.S34.Enabled  = (Options.DispMode=DEC_MODE)
DO WriteTape WITH NULL
DO WriteTape WITH IIF(Options.DispMode=HEX_MODE, PP_TAPE_MODE_HEX, PP_TAPE_MODE_DEC)
DO WriteTape WITH SYMBOLBLANK + SYMBOLBLANK + Options.DispVar
DO DispTop

RETURN

*** End of procedure HexToggle


***--------------------------------------------------------------***
***--------------------------------------------------------------***
***  Procedure   :  WriteTape
***  Description :  Sends information to the text file (tape) and
***                 To the printer if open.
***--------------------------------------------------------------***
***--------------------------------------------------------------***
PROCEDURE WriteTape
PARAMETER String

IF Options.Tape .OR. (Options.Prntr .AND. PRINTSTATUS())

   SET CONSOLE OFF
   IF Options.Prntr .AND. PRINTSTATUS()
      SET PRINTER ON
      ? LMARGIN + m->String
      SET PRINTER OFF
   ENDIF
   IF Options.Tape
      CalcForm.Ed.LineNo = CalcForm.Ed.Lines + 1
      CalcForm.Ed.InsertLine = m->String
   ENDIF
   SET CONSOLE ON

ENDIF

RETURN

*** END OF PROCEDURE WriteTape


***--------------------------------------------------------------***
***--------------------------------------------------------------***
***  Function    :  Symbol
***  Description :  Returns character based on its numeric code
***                 Had to be done that way because define object
***                 does not allow array inclusion.
***--------------------------------------------------------------***
***--------------------------------------------------------------***
FUNCTION Symbol
PARAMETER SymbolNum

PRIVATE SymbolChar

DO CASE
   CASE SymbolNum == PLUS
        SymbolChar = SYMBOLPLUS
   CASE SymbolNum == MINUS
        SymbolChar = SYMBOLMINUS
   CASE SymbolNum == MULTI
        SymbolChar = SYMBOLMULTI
   CASE SymbolNum == DIVIDE
        SymbolChar = SYMBOLDIVIDE
   CASE SymbolNum == EQUAL
        SymbolChar = SYMBOLEQUAL
   CASE SymbolNum == SQUARE
        SymbolChar = SYMBOLSQUARE
   CASE SymbolNum == PERCE
        SymbolChar = SYMBOLPERCE
   CASE SymbolNum == PLUSMI
        SymbolChar = SYMBOLPLUSMI
   OTHERWISE
        SymbolChar = SYMBOLBLANK
ENDCASE

RETURN SymbolChar

*** End of function Symbol

***--------------------------------------------------------------***
***--------------------------------------------------------------***
***  Procedure   :  About
***  Description :  Credit form.  A .T. or .F. is passed to it.
***                 If .T. is passed, a pushbutton is defined
***                 and the form is opened with OPEN() method.
***                 If .F. is passed (occurs only at start) the
***                 form is opened with a READMODAL() and no
***                 pushbutton is defined.  It is closed from the
***                 OnOpen procedure of CalcForm.
***--------------------------------------------------------------***
***--------------------------------------------------------------***
PROCEDURE About
PARAMETER PushIt

DEFINE FORM LogoForm                                             ;
       FROM PP_ABOUTFORM_TOP    + ScreenAttr.ScrHgtAdj,          ;
            PP_ABOUTFORM_LEFT   + ScreenAttr.ScrWthAdj           ;
       TO   PP_ABOUTFORM_BOTTOM + ScreenAttr.ScrHgtAdj,          ;
            PP_ABOUTFORM_RIGHT  + ScreenAttr.ScrWthAdj           ;
       PROPERTY                                                  ;
            Text                  PP_C_CFORM_HEADER            , ;
            ColorNormal           Colors.CFNormal              , ;
            ColorIcon             Colors.CFIcon                , ;
            ColorBorder           Colors.CFBorder              , ;
            ColorBorderHighlight  Colors.CFBorder              , ;
            Moveable              TRUE                         , ;
            Sizeable              FALSE                        , ;
            Maximize              FALSE                        , ;
            Minimize              FALSE                        , ;
            EscExit               FALSE                        , ;
            Shadow                TRUE

DEFINE RECTANGLE R1 OF LogoForm FROM PP_RA1_TOP,    PP_RA1_LEFT           ;
                                TO   PP_RA1_BOTTOM, PP_RA1_RIGHT          ;
      PROPERTY                                                            ;
           ColorNormal           Colors.CFNormal                        , ;
           BorderStyle           RAISED                                 , ;
           Shadow                FALSE                                  , ;
           Border                TRUE

  DEFINE TEXT L0 OF LogoForm AT  PP_RA1_TOP + 1, PP_RA1_LEFT + 1             ;
        PROPERTY                                                             ;
             Text                  Center(PP_C_CFORM_HEADER,PP_ABOUTWIDTH) , ;
             Label                 FALSE                                   , ;
             ColorNormal           Colors.CFHigh

DEFINE TEXT L1 OF LogoForm AT PP_RA1_TOP + 3, PP_RA1_LEFT + 1              ;
      PROPERTY                                                             ;
           Text                  Center(PP_LOGO_LINE1,PP_ABOUTWIDTH)     , ;
           Label                 FALSE                                   , ;
           ColorNormal           Colors.CFText

DEFINE TEXT L2 OF LogoForm AT PP_RA1_TOP + 4, PP_RA1_LEFT + 1              ;
      PROPERTY                                                             ;
           Text                  Center(PP_LOGO_LINE2,PP_ABOUTWIDTH)     , ;
           Label                 FALSE                                   , ;
           ColorNormal           Colors.CFText

DEFINE TEXT L3 OF LogoForm AT PP_RA1_TOP + 5, PP_RA1_LEFT + 1              ;
      PROPERTY                                                             ;
           Text                  Center(PP_LOGO_LINE3,PP_ABOUTWIDTH)     , ;
           Label                 FALSE                                   , ;
           ColorNormal           Colors.CFText

DEFINE TEXT L4 OF LogoForm AT PP_RA1_TOP + 6, PP_RA1_LEFT + 1              ;
      PROPERTY                                                             ;
           Text                  Center(PP_LOGO_LINE4,PP_ABOUTWIDTH)     , ;
           Label                 FALSE                                   , ;
           ColorNormal           Colors.CFHigh

IF m->PushIt
   LogoForm.Height = LogoForm.Height + 2
   DEFINE PUSHBUTTON P1 OF LogoForm AT PP_RA1_TOP + 8,         ;
                     (PP_ABOUTWIDTH-LEN(PP_LOGO_PUSH)-8)/2     ;
         PROPERTY                                              ;
              Text                  PP_LOGO_PUSH             , ;
              Width                 LEN(PP_LOGO_PUSH) + 7    , ;
              OnClick               UnAbout                  , ;
              ColorNormal           Colors.CFPNormal         , ;
              ColorPickNormal       Colors.CFPPnormal        , ;
              ColorHighlight        Colors.CFPHilite         , ;
              ColorPickHighlight    Colors.CFPPhilite

   m->IdleVar = LogoForm.READMODAL()
ELSE
   m->IdleVar = LogoForm.OPEN()
ENDIF

RETURN

*** End of procedure About


***--------------------------------------------------------------***
***--------------------------------------------------------------***
***  Procedure   :  UnAbout
***  Description :  This is the OnClick procedure of the About form
***                 pushbutton.  It closes the LogoForm and releases
***                 it.
***--------------------------------------------------------------***
***--------------------------------------------------------------***
PROCEDURE UnAbout

m->IdleVar = LogoForm.CLOSE()
m->IdleVar = LogoForm.RELEASE()

RETURN


*** End of procedure UnAbout


***--------------------------------------------------------------***
***--------------------------------------------------------------***
***  Procedure   :  CalcError
***  Description :  Display a string (and perform actions) based
***                 on a calculator error.
***--------------------------------------------------------------***
***--------------------------------------------------------------***
PROCEDURE CalcError
PARAMETER ErrNum

PRIVATE ErrorText

DEFINE FORM CErrForm ;
       FROM CalcForm.Top +  6,  CalcForm.Left +  2               ;
       TO   CalcForm.Top + 13,  CalcForm.Left + 42               ;
       PROPERTY                                                  ;
            Text                  PP_CERR_HEADER               , ;
            ColorNormal           Colors.CFNormal              , ;
            ColorIcon             Colors.CFIcon                , ;
            ColorBorder           Colors.CFBorder              , ;
            ColorBorderHighlight  Colors.CFBorder              , ;
            Moveable              TRUE                         , ;
            Sizeable              FALSE                        , ;
            Maximize              FALSE                        , ;
            Minimize              FALSE                        , ;
            EscExit               TRUE                         , ;
            Shadow                TRUE

DO CASE
   CASE m->ErrNum   == E_NEG_SQR
        m->ErrorText = PP_CERR_MESS1
   CASE m->ErrNum   == E_OVER_FLD
        m->ClearFlag = TRUE
        DO ClearAct
        m->ErrorText = PP_CERR_MESS2
   CASE m->ErrNum   == E_OVER_FLM
        m->ClearFlag = FALSE
        m->MemValue  = NILL
        m->ErrorText = PP_CERR_MESS3
   CASE m->ErrNum   == E_DIVISION
        m->ClearFlag = TRUE
        DO ClearAct
        m->ErrorText = PP_CERR_MESS4
   CASE m->ErrNum   == E_PRINTER
        m->ErrorText = PP_CERR_MESS5
   CASE m->ErrNum   == E_SAVETAPE
        m->ErrorText = PP_CERR_MESS6
   CASE m->ErrNum   == E_ALREADY
        m->ErrorText = PP_CERR_MESS7
ENDCASE

DEFINE RECTANGLE RE1 OF CErrForm FROM PP_RE1_TOP,    PP_RE1_LEFT  ;
                                 TO   PP_RE1_BOTTOM, PP_RE1_RIGHT ;
       PROPERTY                                                ;
            ColorNormal           Colors.CFNormal            , ;
            BorderStyle           RAISED                     , ;
            Shadow                FALSE                      , ;
            Border                TRUE

DEFINE TEXT T1 OF CErrForm AT PP_RE1_TOP+1, PP_RE1_LEFT+3      ;
       PROPERTY                                                ;
            Text                  m->ErrorText               , ;
            Label                 FALSE                      , ;
            ColorNormal           Colors.EFNormal            , ;
            ColorHighlight        Colors.EFNormal

DEFINE PUSHBUTTON PB1 OF CErrForm AT PP_RE1_TOP+3, PP_RE1_LEFT+14 ;
       PROPERTY                                                ;
            Text                  PP_CERR_PUSH               , ;
            Width                 LEN(PP_CERR_PUSH) + 5      , ;
            OnClick               CloseErr                   , ;
            ColorNormal           Colors.EFButton            , ;
            ColorHighlight        Colors.EFButton            , ;
            ColorPickHighlight    Colors.EFHilite

m->IdleVar = CErrForm.ReadModal()

RETURN

*** End of procedure CalcError


***--------------------------------------------------------------***
***--------------------------------------------------------------***
***  Procedure   :  CloseErr
***  Description :  Closes and releases the Error form.
***--------------------------------------------------------------***
***--------------------------------------------------------------***
PROCEDURE CloseErr

m->IdleVar = CErrForm.Close()
m->IdleVar = CErrForm.Release()

RETURN

*** End of procedure CloseErr


***------------------------------------------------------------------***
*** END OF FILE NCO.PRG
***------------------------------------------------------------------***
