*.............................................................................
*
*   Program Name: MDIDXKEY.PRG        Copyright: Borland International
*   Date Created:  7 Apr 94            Language: dBASE 5.0
*   Time Created: 23:04:52               Author: Borland dBASE R&D
*   /brief/library.src
*.............................................................................

#define ALLTRIM(kStr) LTRIM(RTRIM(kStr))

*............................................................................
* Procedure Name:   MDIdxKey
* Parameters:       None
* Ext Memvars:      None
* Description:      Searches for the first record with the given index value
*............................................................................
PROCEDURE MDIdxKey
    PRIVATE lVoid, cStr, nKLen, nTLen, nLeft, nRec, xValue, lFlag, oForm, nLen
    PRIVATE cIntlM1, oRef, cIntlM2, cIntlM3
    
    #include "TalkOff.hdb"
    
    oRef = This
    
    cIntlM1 = [This file has no records to search against.]
    cIntlM2 = [Search value not found]
    cIntlM3 = [Index not active]
    
    IF RECCOUNT() = 0
        DO InfoMsg WITH m->cIntlM1
        #include "Talkon.hdb"
        RETURN
    ENDIF            
    
    oForm = This.Form
    IF .NOT. SubmitFm( m->oForm )
        #include "talkon.hdb"
        RETURN
    ENDIF
    
    lFlag = .F.

    IF .NOT. ISBLANK(ALIAS())
        IF .NOT. ISBLANK(ORDER())
            cStr = KEY()
            nKLen = LEN(m->cStr)
            nTLen = FldLen(m->cStr)
            
            #include "MDIDXKEY.DFM"
            
            MDIdxKey.txName5.Text = UPPER(ALLTRIM(LEFT(m->cStr, 40)))

            IF nKLen > 40
                MDIdxKey.txName5.Width = 40     && Key text
                nKLen = 40
            ENDIF
            
            IF nTLen > 40    
                MDIdxKey.etName4.Width = 40     && value to search for
                nTLen = 40
            ELSE 
                MDIdxKey.etName4.Width = m->nTLen    
            ENDIF
            
            nLeft = MAX(m->nKLen, m->nTLen)
            
            IF m->nLeft < 40
                nLeft = 1 + INT((40 - m->nLeft) / 2)
                MDIdxKey.txName5.Left = m->nLeft
                MDIdxKey.etName4.Left = m->nLeft
            ENDIF
            
            xValue = EVALUATE(m->cStr)
            
            DO CASE
                CASE TYPE("m->xValue") = "C"
                    nLen = LEN(m->xValue)
                    MDIdxKey.etName4.Value = SPACE(m->nLen)
                    IF m->nLen > 40
                        MDIdxKey.etName4.Width = 40
                    ENDIF    
                CASE (TYPE("m->xValue") = "F") .OR. (TYPE("m->xValue") = "N")
                    MDIdxKey.etName4.Value = 0
                CASE TYPE(m->cStr) = "D"
                    MDIdxKey.etName4.Value = {}
            ENDCASE            

            DO WHILE .NOT. m->lFlag
                lVoid = MDIdxKey.etName4.SetFocus()
                lVoid = MDIdxKey.ReadModal()
            
                IF MDIdxKey.Action
                    nRec = RECNO()
                    xValue = MDIdxKey.etName4.Value
                    IF .NOT. SEEK(m->xValue)
                        DO InfoMsg WITH m->cIntlM2
                        GOTO m->nRec
                        MDIdxKey.Action = .F.
                    ELSE
                        *-----------------------------------------------
                        *-- This little dance step is a workaround until
                        *-- browse knows about seek()
                        *-----------------------------------------------
                        nRec = RECNO()
                        GOTO m->nRec
                        lFlag = .T.
                        IF TYPE("oForm.ClassName") = "C" .AND. ;
                           oForm.ClassName = "FORM"
                           DO UpLook WITH m->oForm
                           lVoid = oForm.Refresh()
                           *------------------------------------------
                           *-- Check for need to update Detail regions
                           *------------------------------------------
                           IF TYPE( "Form.DetExist" ) = "L" .AND. Form.DetExist
                               DO UpDetail WITH m->Form
                           ENDIF
                        ENDIF    
                    ENDIF
                ELSE
                    lFlag = .T.
                ENDIF
            ENDDO
            
            lVoid = MDIdxKey.Release()

        ELSE
            DO InfoMsg WITH m->cIntlM3
        ENDIF
    ENDIF
#include "Talkon.hdb"
RETURN                                                            

