
*.............................................................................
*
*   Program Name: MDFWD.PRG           Copyright: Borland International
*   Date Created:  8 Apr 94            Language: dBASE 5.0
*   Time Created: 16:24:01               Author: Borland dBASE R&D
*   /brief/library.src
*.............................................................................

#define ALLTRIM(kStr) LTRIM(RTRIM(kStr))
#define kQte CHR(34)

*........................................................................
* Procedure Name:   MDFwd
* Parameters:       None
* Ext Memvars:      None
* Description:      Searches forward from the current record for a given
*                   value in the current field
*........................................................................
PROCEDURE MDFwd
    PRIVATE lVoid, xValue, cFilter, nRec, oFRef, oRef, lValid, cStr, nLen
    PRIVATE nLeft, lFlag, lCase, tFilter, nSDec, nSPre, tStr, lFwd, ;
            startAtEof
    
    #include "TALKOFF.HDB"

    lValid = .F.
    lFlag  = .F.
    lCase  = .F.
    lFwd   = .T.

    *-------------------------------------------------------
    *-- Check to see if this is a forward or backward search
    *-------------------------------------------------------
    IF UPPER(This.Name) = "DBMITEM8"
        lFwd = .F.
    ENDIF    

    *------------------------------------------------------------------
    *-- Get the object reference to the Form object.  Remember This. is
    *-- the menu item.
    *------------------------------------------------------------------
    oFRef = This.Form

    IF .NOT. SubmitFm( m->oFRef )
        #include "talkon.hdb"
        RETURN
    ENDIF

    IF oFRef.ClassName = "FORM" .OR. oFRef.ClassName = "BROWSE"

        IF RECCOUNT() = 0
            DO InfoMsg WITH [This file has no records to search against.]
            #include "TALKON.HDB"
            RETURN
        ENDIF

        *-----------------------------------------------------------
        *-- Get an object reference to the current field on the form
        *-- or browse and make sure it has a datalink.
        *-----------------------------------------------------------
        IF UPPER(oFRef.ClassName) = "FORM"
            oRef = oFRef.ActiveControl()
        ENDIF
        DO CASE
            CASE UPPER(oFRef.ClassName) = "BROWSE"
                oRef = oFRef.FieldList
                oRef = oRef.ActiveField()
                IF TYPE( "oRef.DataLink" ) = "C" .AND. ;
                   .NOT. ISBLANK(oRef.DataLink)
                    lValid = .T.
                ENDIF    
            CASE UPPER(oRef.ClassName) = "ENTRYFIELD"
                IF TYPE( "oRef.DataLink" ) = "C" .AND. ;
                   .NOT. ISBLANK(oRef.DataLink)
                    lValid = .T.
                ENDIF    
        ENDCASE

        *-----------------------------------------
        *-- Don't search if we are on a memo field
        *-----------------------------------------
        IF lValid
            tStr = UPPER(FldStr(oRef.DataLInk))
            tStr = RIGHT(tStr, LEN(tStr) - RAT("[", tStr))
            IF "M" $ tStr
                lValid = .F.
            ENDIF    
        ENDIF

        IF lValid

            StartAtEof = EOF()

            lCase = IIF(oFRef.MenuBar1.dbMBar3.dbMItem9.Checked, .T., .N.)
            cStr = oRef.DataLink
            nLen = FldLen(cStr)
            
            #include "MDFWD.DFM"
            
            IF .NOT. lFwd
                MDFwd.Text = [Backward Search]
            ENDIF
                
            IF nLen > 40
                MDFwd.etName4.Width = 40
                nLen = 40
            ELSE
                MDFwd.etName4.Width = nLen
            ENDIF
            
            nLeft = MAX(nLen,LEN(ALLTRIM(LEFT(cStr, 40))))
            
            IF nLeft < 40
                nLeft = 1 + INT((40 - nLeft) / 2)
                MDFwd.txName5.Left = nLeft
                MDFwd.etName4.Left = nLeft
            ENDIF
            
            xValue = EVALUATE(cStr)
            
            DO CASE
                CASE TYPE("xValue") = "C"
                    nLen = LEN( m->xValue )
                    MDFwd.etName4.Value = SPACE( nLen )
                    IF nLen > 40
                        MDFwd.etName4.Width = 40
                    ENDIF
                CASE (TYPE("xValue") = "F") .OR. (TYPE("xValue") = "N")
                    MDFwd.etName4.Value = 0
                CASE TYPE("xValue") = "D"
                    MDFwd.etName4.Value = {}
                CASE TYPE("xValue") = "L"
                    MDFwd.etName4.Value = .F.    
            ENDCASE            

            cFilter = SET("FILTER")

            DO WHILE .NOT. lFlag
                lVoid = MDFwd.etName4.SetFocus()
                lVoid = MDFwd.ReadModal()

                IF MDFwd.Action
                    nRec = RECNO()

                    xValue = MDFwd.etName4.Value

                    DO CASE
                        CASE TYPE("xValue") = "C"
                            *--------------------------------------------
                            *-- Is a filter already active.  If so, start
                            *-- with it and work from there.
                            *--------------------------------------------
                            IF .NOT. ISBLANK( cFilter )
                                tFilter = "(" + cFilter + ").AND."
                            ELSE
                                tFilter = ""
                            ENDIF

                            *-----------------------------------------
                            *-- If this a case insensitive search, add
                            *-- UPPER() around the datalink
                            *-----------------------------------------
                            IF .NOT. lCase
                                cSrchFld = "UPPER(" + oRef.DataLink + ")"
                                cSrchVal = IIF(.NOT. ISBLANK(ALLTRIM(m->xValue)),;
                                    Delimit(TRIM(UPPER(xValue))), kQte + kQte)
                            ELSE
                                cSrchFld = oRef.DataLink
                                cSrchVal = IIF(.NOT. ISBLANK(ALLTRIM(m->xValue)),; 
                                    Delimit(TRIM(xValue)), kQte + kQte)
                            ENDIF

                            *------------------------------------------
                            *-- Create the LIKE expression is wild card
                            *-- values are in the search string.
                            *------------------------------------------
                            IF AT( "*", xValue ) > 0 .OR. ;
                               AT( "?", xValue ) > 0
                                cSrchExp = "LIKE(" + ;
                                           m->cSrchVal + ;
                                           "," + ;
                                           m->cSrchFld + ")"
                            ELSE
                                cSrchExp = cSrchFld + "==" + cSrchVal
                            ENDIF


                            *----------------------
                            *-- Put it all together
                            *----------------------
                            tFilter = tFilter + cSrchExp

                        CASE (TYPE("xValue") = "F") .OR. (TYPE("xValue") = "N")
                            nSDec = SET("DECIMALS")
                            nSPre = SET("PRECISION")
                            SET PRECISION TO 20
                            SET DECIMAL TO 18
                            xValue = STR(xValue, 20, 18)
                            DO WHILE RIGHT(xValue,1) = "0"
                                xValue = LEFT(xValue, LEN(xValue) - 1)
                            ENDDO
                            IF RIGHT(xValue,1) = "."
                                xValue = LEFT(xValue, LEN(xValue) - 1)
                            ENDIF        
                            tFilter = IIF(.NOT. ISBLANK(cFilter),; 
                                "(" + cFilter + ") .AND. (" + oRef.DataLink + " = " + xValue + ")",;
                                oRef.DataLink + " = " + xValue)
                            SET PRECISION TO nSPre
                            SET DECIMALS  TO nSDec    
                        CASE TYPE("xValue") = "D"        
                            tFilter = IIF(.NOT. ISBLANK(cFilter),; 
                                "(" + cFilter + ") .AND. (" + oRef.DataLink + " = {" + DTOC(xValue) + "})",;
                                oRef.DataLink + " = {" + DTOC(xValue) + "}")
                        CASE TYPE("xValue") = "L"        
                            tFilter = IIF(.NOT. ISBLANK(cFilter),; 
                                "(" + cFilter + ") .AND. (" + oRef.DataLink + " = " + IIF(xValue, ".T.", ".F.") + ")",;
                                oRef.DataLink + " = " + IIF(xValue, ".T.", ".F."))
                    ENDCASE            
                                    
                    IF UPPER(oFRef.ClassName) = "BROWSE"
                        oFRef.Draw = .F.
                    ENDIF

                    SET FILTER TO &tFilter
                    ON ERROR DO SrError
                    GO TOP
                    lEof = EOF()
                    IF .NOT. lEof
                        IF lFwd
                            GO nRec
                            *-------------------------------------------
                            *-- If a DEFINE BROWSE is active, we need to
                            *-- check if the GO worked.
                            *-------------------------------------------
                            IF nRec = RECNO()
                                SKIP
                            ENDIF
                        ELSE
                            GO nRec
                            IF nRec = RECNO()
                                SKIP -1
                            ENDIF
                        ENDIF        
                    ENDIF
                    ON ERROR
                    lEof = EOF()
                    SET FILTER TO &cFilter
                    IF lEof
                        DO InfoMsg WITH [Search value not found]
                        IF startAtEof
                            GO BOTTOM
                            SKIP
                        ELSE
                            GOTO nRec
                        ENDIF
                        MDFwd.Action = .F.
                        *..................................
                        * TEMPORARY FIX TO GET AROUND BUG!
                        *..................................
                        lFlag = .T.
                    ELSE
                        lFlag = .T.
                        IF oFRef.Classname = "FORM"
                            lVoid = oFRef.Refresh()
                            DO UpLook WITH m->oFRef
                            lVoid = oFRef.Refresh()
                            *------------------------------------------
                            *-- Check for need to update Detail regions
                            *------------------------------------------
                            IF TYPE( "oFRef.DetExist" ) = "L" .AND. oFRef.DetExist
                                DO UpDetail WITH m->oFRef
                            ENDIF
                        ENDIF
                    ENDIF
                    IF UPPER(oFRef.ClassName) = "BROWSE"
                        oFRef.Draw = .T.
                    ENDIF
                ELSE
                    lFlag = .T.
                ENDIF
            ENDDO
            
            lVoid = MDFwd.Release()
            
        ENDIF                       
    ENDIF            
    
    #include "TALKON.HDB"
    
RETURN    

    
*....................................................
* Procedure Name:   SrError
* Parameters:       None
* Ext Memvars:      None
* Description:      Error handler for search routine
*                   runs when no match is found
*....................................................
PROCEDURE SrError
    SET FILTER TO &cFilter
    GOTO BOTTOM
    SKIP
RETURN    

FUNCTION Delimit
PARAMETERS pcString
*----------------------------------------------------------------------------
* DESCRIPTION
*   Create a quoted 
*
* PARAMETERS
*   pcString   = Starting string value.
*
*----------------------------------------------------------------------------
  IF ASC( pcString ) < 32
    IF LEN( pcString ) = 1
      lcResult = "CHR( " + ASC( pcString ) + " )"
    ELSE
      IF LEN( pcString ) = 0
        lcResult = ""
      ELSE
        lcResult = "REPLICATE( CHR( " + ASC( pcString ) + " ), " + ;
                    STR( LEN( pcString ) ) + " )"
      ENDIF
    ENDIF
  ELSE
    cLeft= '"'
    cRight = '"'
    IF AT( '"', pcString ) > 0
      IF AT( "'", pcString ) > 0
        cLeft = "["
        cRight = "]"
      ELSE
        cLeft = "'"
        cRight = "'"
      ENDIF
    ENDIF
    lcResult = cLeft + pcString + cRight
  ENDIF

RETURN( lcResult )
*-- EOF: Delimit( pcString )
