PROCEDURE LookCopy
PARAMETERS poThis
*----------------------------------------------------------------------------
* NAME
*   LookCopy - Copy the field values from the lookup table that match
*              the field names in the main table.
*
*              The Lookup alias is currently in use.
*
*              Memo fields in the source file are ignored during the copy.
*
* PARAMETERS
*   poThis     = oRef to the lookup field
*
*----------------------------------------------------------------------------
    PRIVATE cTrigData, cTrigAlias, nFldCnt, nHits, i, nVoid, modTrigA, ;
            oParrent, oFirst, oCurrent, nItem, cPostFrom

    cTrigData = poThis.DataLink
    cTrigAlias = LEFT( m->cTrigData, AT( "->", m->cTrigData ) - 1 )

    *-------------------------------------------------------------
    *-- Scan the fields in the Lookup alias for field name matches 
    *-- in the form.
    *-------------------------------------------------------------
    nFldCnt = AFIELDS( dB5___ALk )
    DECLARE dB5___AMt[ m->nFldCnt ]
    nHits = 0
    FOR i = 1 TO m->nFldCnt

        *--------------------------------------------------------------
        *-- Make up a field name that could be in the master file using
        *-- the field from the lookup table.
        *--------------------------------------------------------------
        tryField = m->cTrigAlias + "->" + dB5___ALk[ m->i, 1 ]

        *-------------------------------------------------------------
        *-- If this field exists and the types match, add the field to
        *-- the array for scanning later.
        *-------------------------------------------------------------
        IF TYPE( m->tryField ) = dB5___ALk[ m->i, 2 ]
            nHits = m->nHits + 1
            dB5___AMt[ m->nHits ] = m->tryField
        ENDIF

    ENDFOR

    *----------------------------------------
    *-- Did any fields match names and types?
    *----------------------------------------
    IF m->nHits > 0

        modTrigA = m->cTrigAlias + "->" && Lookup field alias prefix

        *-------------------------------------------------------------
        *-- Resize the matching field array to the number that matched
        *-------------------------------------------------------------
        nVoid = ARESIZE( dB5___AMt, m->nHits )

        *----------------------------------------------------------
        *-- Now scan each object with an datalink against the array
        *----------------------------------------------------------
        oParent = poThis.Parent         && Get an oRef to this form
        oFirst = oParent.First          && Get an oRef to the first object
        oCurrent = m->oFirst            && Set the start object before loop
        DO WHILE .T.

            *------------------------------------------------------------
            *-- If this object has a datalink and the datalink matchs the
            *-- the trigger field alias, then
            *------------------------------------------------------------
            IF TYPE( "oCurrent.DataLink" ) = "C" .AND. ;
                AT( modTrigA, UPPER( oCurrent.DataLink ) ) = 1

                *-------------------------------------------------
                *-- Search the matching field array for this field
                *-------------------------------------------------
                nItem = ASCAN( dB5___AMt, UPPER( oCurrent.DataLink ) )

                IF m->nItem > 0         && A match!

                    *---------------------------------------------------
                    *-- Reconstruct the lookup field name before posting
                    *---------------------------------------------------
                    cPostFrom = poThis.LookAlias + "->" + ;
                                SUBSTR( dB5___AMt[ m->nItem ], ;
                                        AT( "->", dB5___AMt[ m->nItem ] )+2 )

                    *------------------------------------------------
                    *-- Post the corresponding value to the main file
                    *------------------------------------------------
                    IF .NOT. TYPE( m->cPostFrom ) $ "M,G"
                        oCurrent.Value = EVALUATE( m->cPostFrom )
                    ENDIF
                ENDIF
            ENDIF

            *------------------------------------------------------------
            *-- Get the next object on the form.  If it matches the first
            *-- object, we are done.
            *------------------------------------------------------------
            oCurrent = oCurrent.After
            IF oCurrent = m->oFirst
                EXIT
            ENDIF
        ENDDO
    ENDIF

    RELEASE dB5___AMt, dB5___ALk

RETURN
*-- EOP: LookCopy WITH poThis


