PROCEDURE IFDlgFil
PARAMETERS filetypes, title
*----------------------------------------------------------------------------
* NAME
*   IFDLGFile - File to run for a baseline Open File dialog
*
*----------------------------------------------------------------------------
#include "TALKOFF.HDB"

    PRIVATE lStatus, cIntlNoFi, cAlias, cCatName, nError, cType, ;
            cTmpIndex, i, lVoid, cIntlMod, cIntlDo

    cIntlMod  = [~U~se]
    cIntlDo   = [~D~o]
    cIntlNoFi = [No files of the requested type ] + ;
                [in this drive or catalog]

    db5___file.FileSpec  =  m->filetypes
    db5___file.ShowRadio =  .F.
    db5___file.ModText   =  m->cIntlMod
    db5___file.DoText    =  m->cIntlDo
    db5___file.TypeArray =  m->fileTypes
    db5___file.TypeStart =  m->fileTypes
    db5___file.FormTitle =  m->title
    db5___file.FileMod   =  .F.
    db5___file.DoIt      =  .F.
    db5___file.NewName   =  .F.
    db5___file.HelpVal   =  "32000"     && Just like the old system

    IF .NOT. ISBLANK( CATALOG() )
        SAVE SCREEN TO db5___co
        lStatus = SET( "STATUS" ) = "ON"
        SET STATUS OFF
        RESTORE SCREEN FROM db5___co

        *----------------------------------------------------------------
        *-- Because someone said take out _CATALOG, we have to contrive a
        *-- way to access the active catalog.
        *----------------------------------------------------------------
        cAlias = ALIAS()
        cCatName = CATALOG()
        SET CATALOG OFF
        SET CATALOG TO
        SELECT SELECT()
        nError = 0
        ON ERROR nError = ERROR()
        USE ( m->cCatName ) EXCLUSIVE ALIAS dB5___Cat
        ON ERROR
        IF m->nError > 0

            *----------------------------------------------------
            *-- This should never happen, but display the message
            *----------------------------------------------------
            DO InfoMsg WITH m->cIntlNoFi

        ELSE

            *-------------------------------------------------------
            *-- Create a temp index on file_name with a FOR clause on
            *-- the type field to limit the entries.
            *-------------------------------------------------------
            cType = FileType( m->fileTypes )
            cTmpIndex = TmpName( ".MDX" )
            INDEX ON UPPER( file_name ) TAG fileLst ;
                OF &cTmpIndex ;
                FOR UPPER( type ) = m->cType

            *--------------------------------
            *-- Build the array of file names
            *--------------------------------
            COUNT TO nFiles
            IF m->nFiles > 0

                *--------------------------------------
                *-- Define the dialog and set the title
                *--------------------------------------
                #include "dB5___CT.DFM"
                dB5___CT.Text = m->title
                dB5___CT.TXCatName.Text = m->cCatName

                DECLARE db5___acf[ m->nFiles ]

                i = 1
                SCAN
                    db5___acf[ m->i ] = TRIM( UPPER( file_name ) )
                    i = m->i + 1
                ENDSCAN

                dB5___CT.LBName2.DataSource = "ARRAY dB5___acf"
                dB5___CT.LBName2.CurSel = 1

                DO ShowInfo WITH dB5___CT.LBName2

                lVoid = dB5___Ct.LBName2.SetFocus()
                dB5___Ct.Action = .F.

                lVoid = dB5___Ct.ReadModal()

                IF dB5___Ct.Action
                    *----------------------------------
                    *-- Get the file name from the Path
                    *----------------------------------
                    db5___file.FileName = LOWER( TRIM( Path ) )

                ENDIF

                lVoid = dB5___CT.Release()
                RELEASE dB5___CT

            ELSE
                DO InfoMsg WITH m->cIntlNoFi
            ENDIF

            USE
            ERASE ( m->cTmpIndex )

        ENDIF

        *----------------------------
        *-- Restore that catalog file
        *----------------------------
        IF .NOT. ISBLANK( m->cAlias )
            SELECT ( m->cAlias )
        ENDIF
        SET CATALOG TO ( m->cCatName )
        SET CATALOG ON

        IF m->lStatus
            SET STATUS ON
        ENDIF
        RESTORE SCREEN FROM db5___co
        RELEASE SCREEN db5___co

    ELSE

        *-----------------------------------
        *-- Normal open file dialog box here
        *-----------------------------------
        DO Openfile WITH m->db5___file
        db5___file.FileName = LOWER( db5___file.FileName )

    ENDIF

#include "TALKON.HDB"
RETURN
*-- EOP: IFDlgFil.prg

PROCEDURE ShowInfo
*----------------------------------------------------------------------------
* NAME
*   ShowInfo - Display any path and catalog description in the dialog.
*
*----------------------------------------------------------------------------
    *----------------------------------------------
    *-- Go to the record based on the CurSel value.
    *----------------------------------------------
    GO TOP
    SKIP dB5___Ct.LBName2.CurSel - 1

    *--------------------------------
    *-- Update the description fields
    *--------------------------------
    dB5___CT.Draw = .F.
    dB5___CT.TXDesc.Text = TRIM( title )
    dB5___CT.TXPath.Text = TRIM( path )
    dB5___CT.TXDesc.Width = 51
    dB5___CT.TXPath.Width = 51
    dB5___CT.Draw = .T.

RETURN
*-- EOP: ShowInfo WITH poThis


