
*.............................................................................
*
*   Program Name: HELPDSPY.PRG        Copyright: Borland International
*   Date Created: 13 Apr 94            Language: dBASE 5.0
*   Time Created: 10:44:38               Author: Borland dBASE R&D
*   /brief/library.src
*.............................................................................

#define ALLTRIM(kStr) LTRIM(RTRIM(kStr))

*...........................................................................
* Procedure Name:   HelpDspy
* Parameters:       Object Reference
* Ext Memvars:      None
* Description:      A help display system for the forms designer
*...........................................................................
PROCEDURE HelpDspy
PARAMETERS oRef
    PRIVATE lVoid, cForm, cObj, cOldAlias, cFile, cHead, cTmp
    PRIVATE cFile, lNew, oForm, lSDelete, lSFields, lFlag, oF, oC
    
    PUBLIC oSysMenu
    
    #include "TALKOFF.HDB"
    
    cOldAlias = ALIAS()
    cHlpTitle = ""
    cFile     = ""
    lNew      = .F.
    oForm     = GetForm(m->oRef)
    cObj      = UPPER(oRef.Name)
    lSDelete  = SET("DELETED") = "ON"
    lSFields  = SET("FIELDS")  = "ON"
    lFlag     = .F.
    
    SET DELETED ON
    SET FIELDS OFF

    IF TYPE("oForm.cForm") = "C"
        cForm = UPPER(oForm.cForm)
    ELSE
        cForm = UPPER(oForm.Name)
    ENDIF
    
    IF TYPE(cForm + ".ClassName") # "C"
        STORE m->oForm TO &cForm
        lFlag = .T.        
    ENDIF    
    
    IF SELECT("SYSHELP") = 0
        IF FILE("SYSHELP.DBF")
            USE SYSHELP ORDER DFMNAME IN SELECT()
        ELSE
            DO NoHelp WITH m->cOldAlias
            RETURN
        ENDIF
    ENDIF
    
	IF SELECT("SYSHELP") # 0
	    SELECT SYSHELP
	ENDIF    
    
    IF ORDER() # "DFMNAME"
        SET ORDER TO DFMNAME
    ENDIF
    
    #include "HELPDSGN.DFM"
    
    HelpDsgn.ProcFile = "HELPDSPY.PRG"
    lVoid = HelpDsgn.pbName6.Release()  && delete Heading button to avoid hot key conflict
    
    HelpDsgn.cOldAlias = m->cOldAlias
    
    IF SEEK(m->cForm, "SYSHELP")
        SET KEY TO m->cForm
        GOTO TOP
        
        SCAN
            cObjStr = ALLTRIM(SYSHELP->DFMNAME) + IIF(ALLTRIM(SYSHELP->DFMNAME) # ALLTRIM(SYSHELP->OBJNAME), "." + ALLTRIM(SYSHELP->OBJNAME), "")
            IF TYPE(cObjStr + ".ClassName") # "C"
                DELETE
            ENDIF
        ENDSCAN
                
        GOTO TOP
        LOCATE FOR SYSHELP->OBJNAME = UPPER(m->cObj)
        IF .NOT. FOUND()
            DO NoHelp WITH m->cOldAlias
        ELSE
            HelpDsgn.Text  = ALLTRIM(SYSHELP->HLPTITLE)

            HelpDsgn.OnClose     = "ClHelp"
            HelpDsgn.OnGotFocus  = "SelHelp"
            HelpDsgn.OnLostFocus = "SelAlias"
    
            HelpDSgn.bOK9.Visible    = .F.

            HelpDsgn.edName8.DataSource = "MEMO SYSHELP->HLPFRAME"
            HelpDsgn.edName8.Modify = .F.
            HelpDsgn.edName8.Text = ""
            
            cTmp = SET("ATTRIBUTE")
            cTmp = LEFT(m->cTmp, AT(",", m->cTmp) - 1)
            cTmp = RIGHT(m->cTmp, LEN(m->cTmp) - AT("/", m->cTmp))
            cTmp = m->cTmp + "/" + m->cTmp

            *-----------------------------------------------------------
            *-- Grap the object refrence to the active menu if it exists
            *-----------------------------------------------------------
            oF = _ClipBoard.Parent.After
            oC = m->oF
            HelpDsgn.OldMenu = .F.
            DO WHILE TYPE( "oC" ) = "O"
                IF oC.ClassName = "MENUBAR" .AND. LEFT( oC.Name, 1 ) # "_"
                    HelpDsgn.OldMenu = m->oC
                    EXIT
                ENDIF
                oC = oC.After
                IF m->oC = m->oF
                    EXIT
                ENDIF
            ENDDO
            
            DEFINE MENUBAR mbHelp PROPERTY COLORMENUBARNORMAL m->cTmp
            lVoid = mbHelp.Open()
            
            lVoid = HelpDsgn.pbName2.SetFocus()
            lVoid = HelpDsgn.ReadModal()
        ENDIF
    ELSE
        DO NoHelp WITH m->cOldAlias
    ENDIF
                               
    IF lFlag
        RELEASE &cForm
    ENDIF    

    IF .NOT. lSDelete
        SET DELETED OFF
    ENDIF
    
    IF lSFields
        SET FIELDS ON
    ENDIF    
RETURN


*...................................................................
* Procedure Name:   SelHelp
* Parameters:       None
* Ext Memvars:      DBF()
* Description:      ONGOTFOCUS handler, sets SYSHELP to current DBF
*...................................................................
PROCEDURE SelHelp
    IF SELECT("SYSHELP") = 0
        USE SYSHELP IN SELECT() ORDER DFMNAME
    ENDIF

    IF SELECT("SYSHELP") # 0
	    SELECT SYSHELP
	ENDIF    
RETURN


*...........................................................................
* Procedure Name:   SelAlias
* Parameters:       None
* Ext Memvars:      DBF()
* Description:      ONLOSTFOCUS handler, sets current DBF to previous alias
*...........................................................................
PROCEDURE SelAlias
    IF TYPE("This.cOldAlias") = "C"
        IF .NOT. ISBLANK(This.cOldAlias)
            SELECT (This.cOldAlias)
        ENDIF    
    ENDIF    
RETURN


*.........................................................
* Procedure Name:   GoNext
* Parameters:       None
* Ext Memvars:      None
* Description:      Skips to next record in the help file
*.........................................................
PROCEDURE GoNext
    IF .NOT. EOF()
        SKIP 1
        IF EOF()
            SKIP -1
        ENDIF    
        Form.Text = ALLTRIM(SYSHELP->HLPTITLE)
        Form.edName8.DataSource = "MEMO SYSHELP->HLPFRAME"
    ENDIF    
RETURN


*.............................................................
* Procedure Name:   GoPrev
* Parameters:       None
* Ext Memvars:      None
* Description:      Skips to previous record in the help file
*.............................................................
PROCEDURE GoPrev
    IF .NOT. BOF()
        SKIP -1
        Form.Text = ALLTRIM(SYSHELP->HLPTITLE)
        Form.edName8.DataSource = "MEMO SYSHELP->HLPFRAME"
    ENDIF    
RETURN
    

*......................................................
* Procedure Name:   ClHelp
* Parameters:       None
* Ext Memvars:      HelpDsgn
* Description:      Shuts down the help display system
*......................................................
PROCEDURE ClHelp
    PRIVATE cAlias, oRef, lVoid
    
    oRef = This
    cAlias = ALIAS()
    
    IF TYPE("mbHelp.ClassName") = "C"
        lVoid = mbHelp.Release()
        RELEASE mbHelp
    ENDIF    

    IF TYPE( "oRef.OldMenu" ) = "O" 
        lVoid = oRef.OldMenu.Open()
    ENDIF

    IF m->cAlias = "SYSHELP"
        cAlias = ""
    ENDIF    

    IF SELECT("SYSHELP") # 0
        SELECT SYSHELP
        USE
    ENDIF

    IF .NOT. ISBLANK(m->cAlias)
        SELECT (m->cAlias)
    ENDIF    

    IF TYPE("_CmdWindow.cHFile") = "C"
        IF FILE(_CmdWindow.cHFile)
            ERASE (_CmdWindow.cHFile)
        ENDIF
    ENDIF    

    lVoid = oRef.Release()
    RELEASE HelpDsgn, oSysMenu

    IF TYPE("_CmdWindow.ClassName") = "C"
        _CmdWindow.cHFile = .F.
    ENDIF    
RETURN    


*........................................................................
* Procedure Name:   HContent
* Parameters:       None
* Ext Memvars:      None
* Description:      Switches display to show help contents for this form
*........................................................................
PROCEDURE HContent
    PRIVATE nVoid, i, oRef, oBut
    
    oBut = This
    oRef = This.Form
    
    IF TYPE("oRef.lHead") = "O"
        oRef.edName8.Visible = .F.
        oRef.lHead.Visible   = .T.
        oBut.Text    = [~S~elect]
        oBut.OnClick = "HSelect"
        oBut.Default = .T.
    ELSE    
        DECLARE aHead[1]
    
        GOTO TOP

        aHead[1] = SYSHELP->HlpTitle    
        SKIP        

        i = 2        
        DO WHILE .NOT. EOF()
            nVoid = AGROW(m->aHead, 1)
            aHead[m->i] = SYSHELP->HlpTitle
            SKIP
            i = m->i + 1
        ENDDO
    
        oRef.edName8.Visible = .F.

        DEFINE LISTBOX lHead OF oRef; 
            PROPERTY ;
              DATASOURCE    "ARRAY aHead",;
              HEIGHT         13,;
              LEFT            1,;
              STATUSMESSAGE [Select a help topic to view],;
              TOP             1,;
              WIDTH          53

        oBut.Text    = [~S~elect]
        oBut.OnClick = "HSelect"
        oBut.Default = .T.
    ENDIF
    
    GOTO TOP
    
    oRef.Text = [Table of CONTENTS: ] + UPPER(LEFT(ALLTRIM(SYSHELP->DFMNAME), 1)) + LOWER(RIGHT(ALLTRIM(SYSHELP->DFMNAME), LEN(ALLTRIM(SYSHELP->DFMNAME)) - 1))
    
    oRef.pbName2.Enabled = .F.
    oRef.pbName3.Enabled = .F.
    oRef.pbName5.Enabled = .F.
    oRef.pbName7.Enabled = .F.
    
    lVoid = oBut.SetFocus()
    oBut.Default = .T.
    lVoid = oRef.lHead.SetFocus()
RETURN


*..............................................................
* Procedure Name:   HSelect
* Parameters:       None
* Ext Memvars:      None
* Description:      Switches display to current help selection
*..............................................................
PROCEDURE HSelect
    PRIVATE oRef, oBut, nSel, cFile
    
    oBut = This
    oRef = This.Form
    nSel = oRef.lHead.CurSel
    nSel = m->nSel - 1
    
    oRef.lHead.Visible = .F.
    oRef.edName8.Visible = .T.
    oBut.Text = [~C~ontents]
    oBut.Default = .F.
    oBut.OnClick = "HContent"
    
    GOTO TOP
    SKIP m->nSel

    HelpDsgn.Text  = ALLTRIM(SYSHELP->HLPTITLE)
    HelpDsgn.edName8.DataSource = "MEMO SYSHELP->HLPFRAME"
    HelpDsgn.edName8.Modify = .F.
    
    oRef.pbName2.Enabled = .T.
    oRef.pbName3.Enabled = .T.
    oRef.pbName5.Enabled = .T.
    oRef.pbName7.Enabled = .T.
    
    lVoid = HelpDsgn.pbName2.SetFocus()
RETURN


*........................................................
* Procedure Name:   HPrint
* Parameters:       None
* Ext Memvars:      None
* Description:      Prints current help frame to printer
*........................................................
PROCEDURE HPrint
    PRIVATE nRec, cIntlPrt
    
    cIntlPrt = [Printer not ready]
    
    nRec = RECNO()
    
    IF PRINTSTATUS()
        SET CONSOLE OFF
        SET PRINTER ON
        LOCATE FOR RECNO() = m->nRec
        SET PRINTER ON
        DO SysHelp WITH .F., .F., .F., "", .F.
        SET PRINTER OFF
        SET CONSOLE ON
    ELSE 
        DO ErrorMsg WITH m->cIntlPrt
    ENDIF
            
RETURN    
    

*...........................................................
* Procedure Name:   HCopy
* Parameters:       None
* Ext Memvars:      _Clipboard
* Description:      Copies current help frame to _Clipboard 
*...........................................................
PROCEDURE HCopy
    PRIVATE nCLine, nLines, i
    
    nLines = HelpDsgn.edName8.Lines
    nCLine = _ClipBoard.Lines
    
    FOR i = 1 TO m->nLines
        HelpDsgn.edName8.LineNo = m->i
        _Clipboard.InsertLine   = HelpDsgn.edName8.Value
    ENDFOR

    _Clipboard.LineNo = m->nCLine
    _Clipboard.Column = 1
    _Clipboard.ExtendSelection = .T.
    _Clipboard.LineNo = _Clipboard.Lines
    _Clipboard.ExtendSelection = .F.
RETURN


*.................................................
* Procedure Name:   NoHelp
* Parameters:       None
* Ext Memvars:      None
* Description:      Display error message when object should have help
*                   but doesn't 
*.................................................
PROCEDURE NoHelp
PARAMETERS cAlias
    PRIVATE cIntlHlp
    
    cIntlHlp = [No help available for this object]

    DO ErrorMsg WITH m->cIntlHlp

    IF TYPE("m->cAlias") = "C"
        IF m->cAlias = "SYSHELP"
            cAlias = ""
        ENDIF    

		IF SELECT("SYSHELP") # 0
	        SELECT SYSHELP
    	    USE
    	ENDIF    

        IF .NOT. ISBLANK(m->cAlias)
            SELECT (m->cAlias)
        ENDIF
    ENDIF    
RETURN    

