
*.............................................................................
*
*   Program Name: FNAME.PRG           Copyright: Borland International
*   Date Created:  7 Jul 94            Language: dBASE 5.0
*   Time Created: 14:58:53               Author: Borland dBASE R&D
*   /brief/library.src
*.............................................................................

*............................................................................
* Function Name:    FName
* Parameters:       string (filename), numeric (function code)
* Ext Memvars:      None
* Return Value:     string or logical
* Description:      Function to check various aspects of a given filename.
*                   The first parameter must be a filename, with or without
*                   the path.  Not passing the first parameter, or passing
*                   a non-character value, returns a NULL string.
*                   The second parameter, if given, is a numeric and has
*                   the following meanings:
*                   0: returns the drive, path and full name of the file
*                   1: returns the drive and path of the file
*                   2: returns the file name (no extension)
*                   3: returns the file extension
*                   4: returns the file name and extension
*                   5: returns .T. if the filename is a valid DOS filename,
*                      otherwise returns .F.
*                   Passing no second parameter, or a non-numeric, is the 
*                   same as passing 0.
*                   Passing a number > 5 or < 0 for the second parameter 
*                   will return a NULL string.
*
* Examples:         ? FNAME("C:\DBASE\DBASE.EXE", 0)
*                   C:\DBASE\DBASE.EXE
*                   ? FNAME("C:\DBASE\DBASE.EXE", 1)
*                   C:\DBASE\
*                   ? FNAME("C:\DBASE\DBASE.EXE", 2)
*                   DBASE
*                   ? FNAME("C:\DBASE\DBASE.EXE", 3)
*                   EXE
*                   ? FNAME("C:\DBASE\DBASE.EXE", 4)
*                   DBASE.EXE
*                   ? FNAME("C:\DBASE\DBASE.EXE", 5)    && Valid DOS filename
*                   .T.
*                   ? FNAME("C:\DB..ASE\DB ASE.EXE", 5) && Bad DOS filename
*                   .F.
*
*............................................................................
FUNCTION FName
PARAMETERS cFileName, nParam
    PRIVATE cRet, nFlag, nVoid
    
    #include "TALKOFF.HDB"

    cRet  = ""          && function return value
    nFlag = m->nParam   && copy of second parameter
    nVoid = 0           && unused value to pass to ValFile
    
    IF TYPE("m->cFileName") = "C"
        IF .NOT. ISBLANK(m->cFileName)
            IF (TYPE("m->nFlag") # "N") .AND. (TYPE("m->nFlag") # "F")
                nFlag = 0
            ENDIF

            nFlag = INT(m->nFlag)

            IF (m->nFlag >= 0) .AND. (m->nFlag <= 5)
                DO CASE
                    CASE m->nFlag = 0
                        cRet = FILEDRV(m->cFileName) + ":"; 
                               + FILEPATH(m->cFileName);
                               + FILEROOT(m->cFileName) + "."; 
                               + FILETYPE(m->cFileName)
                    CASE m->nFlag = 1    
                        cRet = FILEDRV(m->cFileName) + ":"; 
                               + FILEPATH(m->cFileName)
                    CASE m->nFlag = 2
                        cRet = FILEROOT(m->cFileName)
                    CASE m->nFlag = 3
                        cRet = FILETYPE(m->cFileName)
                    CASE m->nFlag = 4
                        cRet = FILEROOT(m->cFileName) + "."; 
                               + FILETYPE(m->cFileName)
                    CASE m->nFlag = 5           
                        cRet = VALFILE(m->cFileName, m->nVoid)
                ENDCASE
            ENDIF
        ENDIF
    ENDIF

    #include "TALKON.HDB"
    
RETURN m->cRet                

