
*.............................................................................
*
*   Program Name: FLDSTR.PRG          Copyright: Borland International
*   Date Created: 02/17/94             Language: dBASE 5.0
*   Time Created: 19:47:49               Author: Borland dBASE R&D
*   /brief/library.src
*.............................................................................


FUNCTION FldStr
PARAMETERS pcField
*----------------------------------------------------------------------------
* NAME
*   FldStr() - Return a field string with type
*
* DESCRIPTION
*   FldStr() appends the field type and length for character and
*   numeric fields in square brackets.
*
* PARAMETERS
*   pcField    = field name as a string
*
* DEPENDENCIES
*   DBF for the field must be active.  If not, field is returned intact.
*
*----------------------------------------------------------------------------
  PRIVATE cType, cField, cNumber, cLen, cExp, cFieldName

  cType = TYPE( m->pcField )
  cFieldName = TRIM( m->pcField )
  DO CASE
    CASE m->cType = "C"
      cLen = LTRIM( STR( LEN( &cFieldName ) ) )
      cExp = ' [C' + m->cLen + ']'
    CASE m->cType $ "NF"
      cNumber = TRANSFORM( &cFieldName, "@L" )
      cLen = LTRIM( STR( LEN( m->cNumber ) ) )
      cExp = ' [' + m->cType + m->cLen + ']'
    CASE m->cType = "D"
      cExp = ' [D]'
    CASE m->cType = "M"
      cExp = ' [M]'
    CASE m->cType = "L"
      cExp = ' [L]'
    OTHERWISE
      cExp = ''
  ENDCASE

RETURN (m->cFieldName + m->cExp)
*-- EOF: FldStr( pcField )



