*
* This short example demonstrates a simple method of communicating with
* CopyIt/2 from a TDBS application.
*
* This program copies all files from the BBS machine to a directory
* on the server retaining the directory structure. This program will be
* able to copy while the BBS is running.  Because TDBS cannot make
* directories, it sends a request to CopyIt/2, which issues the command.
*

public server_dir, CI2Path, TempPath, error

server_dir = "w:\BBSBAK"      && Destination for backup files
CI2Path = "w:\ci2\"           && Location of CopyIt/2
TempPath = "w:\temp\"+uline() && Directory for temporary communication files

ON ESCAPE QUIT
ON ERROR error = error()

? "Backing up TBBS machine to SERVER."
? ""

*
* The database file "BAKDIRS.DBF" lists the files and directories that
* should be backed up.  If the entry ends in a backslash, a directory is
* assumed, and all files within that path, including subdirectories, are
* included. All entries must begin with a backslash or drive letter, and 
* include the full DOS pathname.
* NOTE: Use the free VIEWDBF program to modify "BBSBAK.DBF".
*       VIEWDBF can be downloaded from our BBS.
*

use "BAKDIRS.DBF"

do while recno() <= lastrec()
  path = rtrim(dir)
  if right(path,1) = "\"

    * This entry is a directory... copy everything in it.
    do CopyDir with path
  else

    * This entry is a file... print its name and copy to SERVER
    ? "c:"+path
    copy file ("c:"+path) to (server_dir+path)
  endif
  skip
enddo

quit


*********
procedure CopyDir
*********
parameters DirName
private filename, filedata

  ? "["+DirName+"]"

  * Make sure the directory exists
  FileName = findfirst(filedata,server_dir+left(dirname,len(dirname)-1),"X....",attr)
  if empty(FileName)
    ? "Making "+server_dir+DirName
    do MakeDir with DirName
  endif

  * Search for files within the directory
  filename = findfirst(filedata,dirname+"*.*","X....",attr)
  do while .not. empty(filename)
    if substr(attr,2,1) = "X"
      if .not. Filename = "."
      
        * If the file is another subdirectory... recursively copy
        do CopyDir with DirName+FileName+"\"
      endif
    else
      if .not. right(filename,3) = "$$$"

        * Copy the file to Destination, as long as it is not a temporary file
        error = 0
        ? "c:"+dirname+filename
        copy file ("c:"+dirname+filename) to (server_dir+DirName+filename)
        if error > 0
          ?? " WARNING: Copy Failed."
        endif
      endif
    endif
    filename = findnext(filedata,attr)
  enddo
return

*
* Procedure: MakeDir - Create a request file that will be copied to
*            the directory where CopyIt/2 is running.
*

*********
procedure MakeDir
*********
parameters ReqDir
  
  * Create the request
  fcreate rHandle ("req" + uline()+".ci2") 13
  flwrite rHandle Dummy "COMPATH "+TempPath + chr(13) + chr(10)
  flwrite rHandle Dummy "SHELL MD "+server_dir+left(ReqDir,len(ReqDir)-1)
  fclose rHandle
  
  * Erase any response that may be left over from a previous request
  erase (TempPath+"\response.flg")
  
  * Copy the request to CopyIt/2
  copy file ("req"+uline()+".ci2") to (CI2Path+"req"+uline()+".ci2")
  ReqOK = .f.
  do WaitForServerResponse
  if .not. ReqOK
    ? "Server failed to make directory: "+ReqDir
    key = inkey(3)
  endif
return

*********
procedure WaitForServerResponse
*********
private StartTime, ResFile

  if file(CI2Path+"noserver.flg")
    ? "The server is not active at this time."
    key = inkey(3)
    ReqOK = .f.
    return
  endif
  
  * Wait for a response from CopyIt/2
  StartTime = seconds()
  do while .t.
    
    * Pause for five seconds
    x = 0
    do while x < 5
      x = x+1
      key = inkey(1)

      * if escape is hit, abort
      if key = 27
        return
      endif
    enddo
    
    * If response is found, exit with good status
    if file(TempPath+"\response.flg")
      erase (TempPath+"\response.flg")
      ReqOK = .t.
      exit
    endif

    * If two minutes has passed, abort
    if seconds() > StartTime + 120
      return
    endif
  enddo
  
  * clean up the response
  erase (TempPath+"\response.flg")
return
