VERSION 2.00
Begin Form frmMhOutboxSample 
   BorderStyle     =   1  'Fixed Single
   Caption         =   "MhOutbox Sample"
   FillColor       =   &H00FFFFFF&
   Height          =   6990
   Left            =   750
   LinkTopic       =   "Form1"
   ScaleHeight     =   6300
   ScaleWidth      =   8730
   Top             =   240
   Width           =   8850
   Begin CommandButton Command14 
      Caption         =   "Bezier Curves"
      Height          =   330
      Left            =   5430
      TabIndex        =   17
      Top             =   30
      Width           =   1575
   End
   Begin CommandButton Command13 
      Caption         =   "Text"
      Height          =   330
      Left            =   7080
      TabIndex        =   12
      Top             =   1200
      Width           =   1575
   End
   Begin CommandButton Command12 
      Caption         =   "Zoom -"
      Height          =   330
      Left            =   7890
      TabIndex        =   16
      Top             =   1575
      Width           =   750
   End
   Begin CommandButton Command11 
      Caption         =   "Zoom +"
      Height          =   330
      Left            =   7065
      TabIndex        =   15
      Top             =   1575
      Width           =   780
   End
   Begin CommandButton Command10 
      Caption         =   "Clear"
      Height          =   375
      Left            =   7230
      TabIndex        =   14
      Top             =   2025
      Width           =   1455
   End
   Begin CommandButton Command9 
      Caption         =   "Plot"
      Height          =   330
      Left            =   7080
      TabIndex        =   11
      Top             =   795
      Width           =   1575
   End
   Begin CommandButton Command8 
      Caption         =   "Shapes - String"
      Height          =   330
      Left            =   5430
      TabIndex        =   10
      Top             =   795
      Width           =   1575
   End
   Begin CommandButton Command7 
      Caption         =   "Save to Disk"
      Height          =   375
      Left            =   5445
      TabIndex        =   9
      Top             =   2025
      Width           =   1680
   End
   Begin CommandButton Command6 
      Caption         =   "Horoscope"
      Height          =   330
      Left            =   7080
      TabIndex        =   8
      Top             =   405
      Width           =   1575
   End
   Begin CommandButton Command5 
      Caption         =   "Print"
      Height          =   375
      Left            =   7230
      TabIndex        =   7
      Top             =   2445
      Width           =   1455
   End
   Begin CommandButton Command4 
      Caption         =   "Copy to Clipboard"
      Height          =   375
      Left            =   5430
      TabIndex        =   6
      Top             =   2445
      Width           =   1695
   End
   Begin PictureBox Picture1 
      Height          =   2625
      Left            =   5580
      Picture         =   MHOUTBOX.FRX:0000
      ScaleHeight     =   2595
      ScaleWidth      =   2625
      TabIndex        =   4
      Top             =   3600
      Width           =   2655
   End
   Begin CommandButton Command3 
      Caption         =   "Wheel"
      Height          =   330
      Left            =   7080
      TabIndex        =   3
      Top             =   30
      Width           =   1575
   End
   Begin CommandButton Command2 
      Caption         =   "Random Circles"
      Height          =   330
      Left            =   5430
      TabIndex        =   2
      Top             =   1200
      Width           =   1575
   End
   Begin CommandButton Command1 
      Caption         =   "Shapes - Numeric"
      Height          =   330
      Left            =   5430
      TabIndex        =   1
      Top             =   405
      Width           =   1575
   End
   Begin MhOutbox MhOutbox1 
      Arc             =   ""
      AutoSize        =   0   'False
      BackMode        =   2  'Opaque
      BCircle         =   ""
      BezierSteps     =   32
      BLine           =   ""
      BorderStyle     =   1  'Fixed Single
      BrushStyle      =   0  'Solid
      Chord           =   ""
      ClearBox        =   0   'False
      ClipControls    =   0   'False
      ColorPrint      =   0   'False
      CopyToClip      =   0   'False
      Ellipse         =   ""
      EndOfDoc        =   0   'False
      EndPage         =   0   'False
      EndPageIsEndDoc =   -1  'True
      EraseForRead    =   0   'False
      ExtTextOut      =   ""
      FillColor       =   &H00FFFFFF&
      HatchStyle      =   0  'Horizontal
      Height          =   5292
      Left            =   0
      LineTo          =   ""
      MapMode         =   8  'Anisotropic (arbitrary)
      MapRatioX       =   1
      MapRatioY       =   1
      MetaFileName    =   "SAMPLE.WMF"
      MoveTo          =   "0 0"
      OutContext      =   0  'Screen
      PassThrough     =   ""
      PasteFromClip   =   0   'False
      PenStyle        =   0  'Solid
      PenWidth        =   0
      Pie             =   ""
      PlaceableDiskMeta=   -1  'True
      PolyBezier      =   ""
      Polygon         =   ""
      Polyline        =   ""
      PolyPolyC       =   ""
      PolyPolyP       =   ""
      PrintJobName    =   "MhOutbox1"
      Rectangle       =   ""
      RoundRect       =   ""
      SaveMetaFile    =   0   'False
      ScaleRatioX     =   1
      ScaleRatioY     =   1
      SetPixel        =   ""
      TabIndex        =   0
      Text            =   "MhOutbox1"
      TextAlignCP     =   0   'False
      TextAlignH      =   0  'Left
      TextAlignV      =   0  'Top
      TextOut         =   "4000 3600"
      Top             =   960
      ViewportExtX    =   9292
      ViewportExtY    =   9292
      ViewportOrgX    =   0
      ViewportOrgY    =   0
      Width           =   5292
      WindowExtX      =   9292
      WindowExtY      =   9292
      WindowMaxX      =   9291
      WindowMaxY      =   9291
      WindowMinX      =   0
      WindowMinY      =   0
      WindowOrgX      =   0
      WindowOrgY      =   0
      ZZZPicture      =   MHOUTBOX.FRX:027A
   End
   Begin Line Line1 
      BorderWidth     =   4
      X1              =   5445
      X2              =   8661
      Y1              =   1940
      Y2              =   1932
   End
   Begin Label Label3 
      Caption         =   "MhOutbox1 - Draw/Print to this control and set the .OutContext property to send to Screen, Printer, Clipboard, or File.   Click the MhOutbox to copy from the Picture1 to the MhOutBox."
      Height          =   768
      Left            =   180
      TabIndex        =   13
      Top             =   108
      Width           =   4392
   End
   Begin Label Label1 
      Caption         =   "Picture1:  Click this picture box to copy contents from the MhOutBox to the picture box.  "
      Height          =   600
      Left            =   5445
      TabIndex        =   5
      Top             =   2880
      Width           =   2970
   End
   Begin Menu Mnu 
      Caption         =   "&File"
      Index           =   0
      Begin Menu Fil 
         Caption         =   "E&xit"
         Index           =   1
      End
   End
   Begin Menu Mnu 
      Caption         =   "&Output"
      Index           =   1
      Begin Menu OutCon 
         Caption         =   "&Screen"
         Index           =   1
      End
      Begin Menu OutCon 
         Caption         =   "&Printer"
         Index           =   2
      End
      Begin Menu OutCon 
         Caption         =   "&Clipboard"
         Index           =   3
      End
      Begin Menu OutCon 
         Caption         =   "&Metafile"
         Index           =   4
      End
   End
   Begin Menu Mnu 
      Caption         =   "&MapMode"
      Index           =   2
      Begin Menu MapM 
         Caption         =   "&Text"
         Index           =   1
      End
      Begin Menu MapM 
         Caption         =   "&LoMetric"
         Index           =   2
      End
      Begin Menu MapM 
         Caption         =   "Hi&Metric"
         Index           =   3
      End
      Begin Menu MapM 
         Caption         =   "Lo&English"
         Index           =   4
      End
      Begin Menu MapM 
         Caption         =   "&HiEnglish"
         Index           =   5
      End
      Begin Menu MapM 
         Caption         =   "T&wips"
         Index           =   6
      End
      Begin Menu MapM 
         Caption         =   "&Isotropic"
         Index           =   7
      End
      Begin Menu MapM 
         Caption         =   "&Anisotropic"
         Index           =   8
      End
   End
   Begin Menu Mnu 
      Caption         =   "&Help"
      Index           =   3
      Begin Menu Hlp 
         Caption         =   "&About"
         Index           =   1
      End
   End
End
Dim FlagClear As Integer, FlagScale As Integer
Dim PL(99) As Integer
Dim Vert(10) As Integer
Dim LColorsF(1 To 12) As Long
Dim LColorsB(1 To 12) As Long

Sub Command1_Click ()
'Shapes - Numeric
If FlagScale Then
  MhOutbox1.WindowExtX = MhOutbox1.ViewportExtX
  MhOutbox1.WindowExtY = MhOutbox1.ViewportExtY
  FlagScale = 0
End If
X1 = MhOutbox1.WindowExtX / 6700 * MhOutbox1.MapRatioX
Y1 = MhOutbox1.WindowExtY / 6700 * MhOutbox1.MapRatioY
If MhOutbox1.MapMode > 1 And MhOutbox1.MapMode < 7 Then
  Y1 = -Y1
End If
t$ = "  100  300 1100  300 1200  300 1200 1600 1000 2400  600 3800 2600"
t$ = t$ + " 1300  300 2300  300 4000  600 5600 2600 4000 2800 5600 4800  300  300"
t$ = t$ + " 2400    0 5000  500 2400  200 5000  200  200 2800 2200 4800  400 3400 2000 4400"
t$ = t$ + " 2400 3100 3800 4500 2600 3300 3600 3300"
t$ = t$ + " 3200 5000 2400 6000 2400 6600 3600 6400 4000 5800 3400 5000"
t$ = t$ + "  200 5000 1000 6000  200 6600 1400 6400 2200 5800 1200 5200"
t$ = t$ + " 4200 5000 6200 5800 5000 6000 4200 5000 4200 6600 5400 6400 5200 5200 4200 6600"
t$ = t$ + " 6200 300 5200 2300 7200 4300 6200 6300"
XY = 0
For i = 1 To 99
PL(i) = Val(Mid$(t$, i * 5 - 4, 5))
If XY Then PL(i) = Int(PL(i) * Y1) Else PL(i) = Int(PL(i) * X1)
XY = 1 - XY
If i = 9 Then XY = 0
Next i
MhOutbox1.BrushStyle = 0
MhOutbox1.PenWidth = 0
If FlagClear Then MhOutbox1.Clear
MhOutbox1.FillColor = RGB(255, 0, 0)
Rem Compare these calls to the setting of string properties
Rem 2 coords:
Call MhObMoveTo(MhOutbox1, PL(1), PL(2))
Call MhObLineTo(MhOutbox1, PL(3), PL(4))
Call MhObSetPixel(MhOutbox1, PL(5), PL(6))
Rem 3 coords:
Call MhObCircle(MhOutbox1, PL(7), PL(8), PL(9))
Rem 4 coords:
Call MhObEllipse(MhOutbox1, PL(10), PL(11), PL(12), PL(13))
Call MhObLine(MhOutbox1, PL(14), PL(15), PL(16), PL(17))
Call MhObRectangle(MhOutbox1, PL(18), PL(19), PL(20), PL(21))
Rem 6 coords:
Call MhObRoundRect(MhOutbox1, PL(22), PL(23), PL(24), PL(25), PL(26), PL(27))
Rem 8 coords:
Call MhObArc(MhOutbox1, PL(28), PL(29), PL(30), PL(31), PL(32), PL(33), PL(34), PL(35))
Call MhObChord(MhOutbox1, PL(36), PL(37), PL(38), PL(39), PL(40), PL(41), PL(42), PL(43))
Call MhObPie(MhOutbox1, PL(44), PL(45), PL(46), PL(47), PL(48), PL(49), PL(50), PL(51))
Rem pass arrays:
Call MhObPolyline(MhOutbox1, PL(52), 6)
Call MhObPolygon(MhOutbox1, PL(64), 6)
Vert(0) = 4: Vert(1) = 4
Call MhObPolyPolygon(MhOutbox1, PL(76), Vert(0), 2)
MhOutbox1.FillColor = RGB(255, 255, 255)
End Sub

Sub Command10_Click ()
'Clear
MhOutbox1.Clear
End Sub

Sub Command11_Click ()
'Zoom +
MhOutbox1.ViewportExtX = MhOutbox1.ViewportExtX * 2
MhOutbox1.ViewportExtY = MhOutbox1.ViewportExtY * 2
MhOutbox1.Refresh
End Sub

Sub Command12_Click ()
'Zoom -
MhOutbox1.ViewportExtX = MhOutbox1.ViewportExtX \ 2
MhOutbox1.ViewportExtY = MhOutbox1.ViewportExtY \ 2
MhOutbox1.Refresh
End Sub

Sub Command13_Click ()
'Text
' Let user select a font
frmFontPick.Show 1
On Error GoTo Cmd13FontErr
MhOutbox1.FontName = gFontName
On Error GoTo 0
MhOutbox1.FontSize = 7.8
MhOutbox1.FontBold = gIBold
MhOutbox1.FontItalic = gIItalic
SetAnisoText
If FlagClear Then MhOutbox1.Clear
MhOutbox1.TextAlignV = 0
MhOutbox1.Text = "Gettysburg Address - Abraham Lincoln - Nov. 19, 1863"
MhOutbox1.TextOut = "10 0"
t$ = "Fourscore and seven years ago our fathers brought forth on this continent a new nation, conceived in liberty and dedicated to the proposition that all men are created equal. Now we are engaged in a great civil war, testing whether "
t$ = t$ + "that nation or any nation so conceived and so dedicated can long endure. We are met on a great battlefield of that war. We have come to dedicate a portion of that field as a final resting-place for those who here gave "
t$ = t$ + "their lives that that nation might live. It is altogether fitting and proper that we should do this. But in a larger sense, we cannot dedicate, we cannot consecrate, we cannot hallow this ground. The brave men, living "
t$ = t$ + "and dead, who struggled here have consecrated it far above our poor power to add or detract. The world will little note nor long remember what we say here, but it can never forget what they did here. It is for us "
t$ = t$ + "the living rather to be dedicated here to the unfinished work which they who fought here have thus far so nobly advanced. It is rather for us to be here dedicated to the great task remaining before us--that from these honored "
t$ = t$ + "dead we take increased devotion to that cause for which they gave the last full measure of devotion--that we here highly resolve that these dead shall not have died in vain, that this nation under God shall have a "
t$ = t$ + "new birth of freedom, and that government of the people, by the people, for the people shall not perish from the earth."
MhOutbox1.Text = t$
If MhOutbox1.MapMode > 1 And MhOutbox1.MapMode < 7 Then Y1 = -24 Else Y1 = 24
X2 = MhOutbox1.WindowExtX
Y2 = MhOutbox1.WindowExtY * Sgn(Y1)
If MhOutbox1.MapMode > 1 And MhOutbox1.MapMode < 8 Then
  X2 = Int(X2 / MhOutbox1.MapRatioX)
  Y2 = Int(Y2 / MhOutbox1.MapRatioY)
End If
MhOutbox1.ExtTextOut = "0 " + Str$(Y1) + " 8 0 0" + Str$(X2) + " " + Str$(Y2)
    'restore several default to avoid messing up other options
    MhOutbox1.FontName = "MS Sans Serif"
    MhOutbox1.FontSize = 8.25
    gIBold = True
    gIItalic = False
    MhOutbox1.TextAlignV = 0
    MhOutbox1.TextAlignH = 0
    Exit Sub
    
Cmd13FontErr:

    ' Font was not available; set a default
    MsgBox "Font '" & gFontName & "' is a printer-only font, and is not available for display. Setting font to 'MS Sans Serif'.", 0, "Font Not Available"
    gFontName = "MS Sans Serif"
    Resume Next

End Sub

Sub Command14_Click ()
'Bezier Curves
Randomize
If FlagScale Then
  MhOutbox1.WindowExtX = MhOutbox1.ViewportExtX
  MhOutbox1.WindowExtY = MhOutbox1.ViewportExtY
  FlagScale = 0
End If
If FlagClear Then MhOutbox1.Clear
If MhOutbox1.MapMode > 1 And MhOutbox1.MapMode < 7 Then
  yax = -1
Else
  yax = 1
End If

For i = 1 To 9
x$ = Str$(Int(Rnd(i) * MhOutbox1.WindowExtX) * MhOutbox1.MapRatioX)
y$ = Str$(Int(Rnd(i) * MhOutbox1.WindowExtY) * yax * MhOutbox1.MapRatioY)

X1$ = Str$(Int(Rnd(i) * MhOutbox1.WindowExtX) * MhOutbox1.MapRatioX)
Y1$ = Str$(Int(Rnd(i) * MhOutbox1.WindowExtY) * yax * MhOutbox1.MapRatioY)

X2$ = Str$(Int(Rnd(i) * MhOutbox1.WindowExtX) * MhOutbox1.MapRatioX)
Y2$ = Str$(Int(Rnd(i) * MhOutbox1.WindowExtY) * yax * MhOutbox1.MapRatioY)

x3$ = Str$(Int(Rnd(i) * MhOutbox1.WindowExtX) * MhOutbox1.MapRatioX)
y3$ = Str$(Int(Rnd(i) * MhOutbox1.WindowExtY) * yax * MhOutbox1.MapRatioY)

MhOutbox1.PenWidth = Int(Rnd(1) * 75)
MhOutbox1.ForeColor = RGB(Int(Rnd(1) * 255), Int(Rnd(1) * 255), Int(Rnd(1) * 255))
MhOutbox1.PolyBezier = x$ + y$ + X1$ + Y1$ + X2$ + Y2$ + x3$ + y3$

Next i

End Sub

Sub Command2_Click ()
'Random Circles
Randomize
If FlagScale Then
  MhOutbox1.WindowExtX = MhOutbox1.ViewportExtX
  MhOutbox1.WindowExtY = MhOutbox1.ViewportExtY
  FlagScale = 0
End If
If FlagClear Then MhOutbox1.Clear
If MhOutbox1.MapMode > 1 And MhOutbox1.MapMode < 7 Then
  yax = -1
Else
  yax = 1
End If
For i = 1 To 100
x = Int(Rnd(i) * MhOutbox1.WindowExtX) * MhOutbox1.MapRatioX
y = Int(Rnd(i) * MhOutbox1.WindowExtY) * yax * MhOutbox1.MapRatioY
r = Int(Rnd(i) * MhOutbox1.WindowExtX * MhOutbox1.MapRatioX / 7)
MhOutbox1.BrushStyle = Int(Rnd(1) * 3)
MhOutbox1.HatchStyle = Int(Rnd(1) * 6)
MhOutbox1.ForeColor = RGB(Int(Rnd(x) * 255), Int(Rnd(x) * 255), Int(Rnd(x) * 255))
MhOutbox1.FillColor = RGB(Int(Rnd(x) * 255), Int(Rnd(x) * 255), Int(Rnd(x) * 255))
Call MhObCircle(MhOutbox1, x, y, r)
Next i
MhOutbox1.FillColor = RGB(255, 255, 255)
End Sub

Sub Command3_Click ()
'Wheel
If FlagScale Then
  MhOutbox1.WindowExtX = MhOutbox1.ViewportExtX
  MhOutbox1.WindowExtY = MhOutbox1.ViewportExtY
  FlagScale = 0
End If
MhOutbox1.BrushStyle = 0
MhOutbox1.PenWidth = 0
If FlagClear Then MhOutbox1.Clear
MhOutbox1.FillColor = RGB(0, 255, 255)
If MhOutbox1.MapMode > 1 And MhOutbox1.MapMode < 7 Then yax = -1 Else yax = 1
DEGRAD = 3.1415926535 / 180
RIN = MhOutbox1.WindowExtX * MhOutbox1.MapRatioX / 30
ROUT = MhOutbox1.WindowExtX * MhOutbox1.MapRatioX / 6
ROLL = 0
CentY = ROUT * yax
For PASS = 1 To 3
If PASS = 1 Or PASS = 3 Then
  Begin = MhOutbox1.WindowOrgX * MhOutbox1.MapRatioX + ROUT
  Finish = MhOutbox1.WindowExtX * MhOutbox1.MapRatioX - ROUT
  Stp = ROUT
Else
  Begin = MhOutbox1.WindowExtX * MhOutbox1.MapRatioX - ROUT
  Finish = MhOutbox1.WindowOrgX * MhOutbox1.MapRatioX + ROUT
  Stp = -ROUT
End If
For CENT = Begin To Finish Step Stp
Call MhObCircle(MhOutbox1, CENT, CentY, ROUT)
Call MhObCircle(MhOutbox1, CENT, CentY, RIN)
For ANG = 0 + ROLL To 330 + ROLL Step 60
AR = ANG * DEGRAD
SA = Sin(AR)
CA = Cos(AR)
X1 = Int(CA * RIN + CENT)
Y1 = Int(SA * RIN + CentY)
X2 = Int(CA * (ROUT - 1) + CENT)
Y2 = Int(SA * (ROUT - 1) + CentY)
Call MhObLine(MhOutbox1, X1, Y1, X2, Y2)
Next ANG
ROLL = ROLL + 15
CentY = CentY + Int(ROUT / 2.9) * yax
Next CENT
Next PASS
MhOutbox1.FillColor = RGB(255, 255, 255)
End Sub

Sub Command4_Click ()
'Copy to Clipboard
MhOutbox1.CopyToClip = True
End Sub

Sub Command5_Click ()
'Print
x = MhOutbox1.ViewportExtX
y = MhOutbox1.ViewportExtY
Rem change to printer:
MhOutbox1.OutContext = 1
Rem change scale for printer (8 inches horizontal in hi metric):
MhOutbox1.ViewportExtX = 20320
MhOutbox1.ViewportExtY = 21000
'same size as screen instead of scaled up would be:
'MhOutbox1.ViewportExtX = 9292: MhOutbox1.ViewportExtY = 9292
Rem uncommenting these 5 lines would cause a 2-page printout with Numeric shapes as page 2:
'MhOutbox1.EndPageIsEndDoc = False
'MhOutbox1.EndPage = True
'FlagClear = 0
'Call Command1_Click
'FlagClear = -1
Rem This finally triggers actual printing:
MhOutbox1.EndOfDoc = True
Rem back to screen:
MhOutbox1.OutContext = 0
MhOutbox1.ViewportExtX = x
MhOutbox1.ViewportExtY = y
End Sub

Sub Command6_Click ()
'Horoscope
    ' Let user select a font
    frmFontPick.Show 1
    MhOutbox1.BrushStyle = 0
    MhOutbox1.PenWidth = 0
    ' This should be done before the .Clear;
    ' Failure to initiate the extents in anisotropic .MapMode
    ' will yield inaccurate rendering of most fonts (at the very least!)
    SetAnisoText
    If FlagClear Then MhOutbox1.Clear
    ' Calculate a center
    CentX = Int(MhOutbox1.WindowExtX / 2)
    CentY = Int(MhOutbox1.WindowExtY / 2)
    RIN = Int(MhOutbox1.WindowExtX / 12)
    ROUT = Int(MhOutbox1.WindowExtX / 2.3)
    ' Output title
    MhOutbox1.TextAlignV = 0
    MhOutbox1.TextAlignH = 2
    MhOutbox1.FontSize = 8.25
    MhOutbox1.FontName = "MS Sans Serif"
    MhOutbox1.Text = "Horoscope Houses"
    MhOutbox1.TextOut = Str$(CentX) & " 1"
    ' Convert degrees to radians
    DEGRAD = 3.1415926535 / 180
    ' Set color to CYAN & draw the outer circle
    MhOutbox1.FillColor = &HFFFF00
    Call MhObCircle(MhOutbox1, CentX, CentY, ROUT)
    ' Set color to WHITE & draw the inner circle
    MhOutbox1.FillColor = &HFFFFFF
    Call MhObCircle(MhOutbox1, CentX, CentY, RIN)
    ' Set transparent mode
    MhOutbox1.BackMode = 1
    'MhOutBox1.BackColor = &HFF&
    ' Set the alignment and font
    MhOutbox1.TextAlignV = 2
    MhOutbox1.TextAlignH = 2
    On Error GoTo SetFontErr
    MhOutbox1.FontName = gFontName
    On Error GoTo 0
    MhOutbox1.FontSize = 12
    MhOutbox1.FontBold = gIBold
    MhOutbox1.FontItalic = gIItalic
    ' Set an initial angle for a line
    ANG = 150
    ' Draw the segment lines, boxes, and text
    For House = 1 To 12
        AR = ANG * DEGRAD
        SA = Sin(AR)
        CA = Cos(AR)
        X1 = Int(CA * RIN + CentX)
        Y1 = Int(SA * RIN + CentY)
        X2 = Int(CA * ROUT + CentX)
        Y2 = Int(SA * ROUT + CentY)
        ' Draw a line radially between the circles
        MhOutbox1.ForeColor = &H0&
        Call MhObLine(MhOutbox1, X1, Y1, X2, Y2)
        ' Pick a color for the rounded rectangle
        MhOutbox1.FillColor = LColorsF(House)
        ' Calculate base coordinates
        X1 = Int(Cos((ANG + 15) * DEGRAD) * (ROUT - RIN) + CentX)
        Y1 = Int(Sin((ANG + 15) * DEGRAD) * (ROUT - RIN) + CentY)
        ' One or two digits?
        If House < 10 Then
            MhOutbox1.RoundRect = Str$(X1 - 13) & " " & Str$(Y1 - 20) & Str$(X1 + 17) & " " & Str$(Y1 + 10) & " " & Str$(3) & " " & Str$(3)
        Else
            MhOutbox1.RoundRect = Str$(X1 - 12) & " " & Str$(Y1 - 20) & Str$(X1 + 18) & " " & Str$(Y1 + 10) & " " & Str$(3) & " " & Str$(3)
        End If
        
        ' Pick a color for the text
        Select Case House
            
            Case 2, 4, 6, 9, 11
                ' White for darker colors
                MhOutbox1.ForeColor = &HFFFFFF
            Case Else
                ' Black for lighter colors
                ' (do nothing)
        
        End Select
        ' Set and output a house's text string
        MhOutbox1.Text = Str$(House)
        ' Defines a clipping rectangle to lie within rounded rectangle
        MhOutbox1.ExtTextOut = Str$(X1) & " " & Str$(Y1) & " 8 " & Str$(X1 - 10) & " " & Str$(Y1 - 15) & Str$(X1 + 15) & " " & Str$(Y1 + 15)
        ANG = ANG - 30
        If ANG < 0 Then ANG = ANG + 360
    Next House
    'restore several default to avoid messing up other options
    MhOutbox1.FontName = "MS Sans Serif"
    MhOutbox1.FontSize = 8.25
    gIBold = True
    gIItalic = False
    MhOutbox1.TextAlignV = 0
    MhOutbox1.TextAlignH = 0
    Exit Sub
    
SetFontErr:

    ' Font was not available; set a default
    MsgBox "Font '" & gFontName & "' is a printer-only font, and is not available for display. Setting font to 'MS Sans Serif'.", 0, "Font Not Available"
    gFontName = "MS Sans Serif"
    Resume Next

End Sub

Sub Command7_Click ()
'Save to Disk
Rem This will save to the file name in the property
Rem MhOutbox1.MetaFileName.  Be sure to include any path.
a$ = InputBox$("What Path/Filename to save to (use .wmf extension)?")
If a$ > "" Then
    MhOutbox1.MetaFileName = a$
    MhOutbox1.SaveMetaFile = True
End If
End Sub

Sub Command8_Click ()
'Shapes - String
If FlagScale Then
  MhOutbox1.WindowExtX = MhOutbox1.ViewportExtX
  MhOutbox1.WindowExtY = MhOutbox1.ViewportExtY
  FlagScale = 0
End If
X1 = MhOutbox1.WindowExtX / 6700 * MhOutbox1.MapRatioX
Y1 = MhOutbox1.WindowExtY / 6700 * MhOutbox1.MapRatioY
If MhOutbox1.MapMode > 1 And MhOutbox1.MapMode < 7 Then
  Y1 = -Y1
End If
MhOutbox1.BrushStyle = 0
MhOutbox1.PenWidth = 0
If FlagClear Then MhOutbox1.Clear
MhOutbox1.FillColor = RGB(0, 0, 255)
Rem Setting with string constants is as easy as using calls
Rem with numeric constants.  With variables, this format
Rem involves more processing because of multiple STR$().
Rem The 3 Poly shapes take variable argument lists.
t$ = "  100  300 1100  300 1200  300 1200 1600 1000 2400  600 3800 2600"
t$ = t$ + " 1300  300 2300  300 4000  600 5600 2600 4000 2800 5600 4800  300  300"
t$ = t$ + " 2400    0 5000  500 2400  200 5000  200  200 2800 2200 4800  400 3400 2000 4400"
t$ = t$ + " 2400 3100 3800 4500 2600 3300 3600 3300"
t$ = t$ + " 3200 5000 2400 6000 2400 6600 3600 6400 4000 5800 3400 5000"
t$ = t$ + "  200 5000 1000 6000  200 6600 1400 6400 2200 5800 1200 5200"
t$ = t$ + " 4200 5000 6200 5800 5000 6000 4200 5000 4200 6600 5400 6400 5200 5200 4200 6600"
t$ = t$ + " 6200 300 5200 2300 7200 4300 6200 6300"
XY = 0
For i = 1 To 99
PL(i) = Val(Mid$(t$, i * 5 - 4, 5))
If XY Then PL(i) = Int(PL(i) * Y1) Else PL(i) = Int(PL(i) * X1)
XY = 1 - XY
If i = 9 Then XY = 0
Next i
Rem 2 coords:
MhOutbox1.MoveTo = Str$(PL(1)) + " " + Str$(PL(2))
MhOutbox1.LineTo = Str$(PL(3)) + " " + Str$(PL(4))
MhOutbox1.SetPixel = Str$(PL(5)) + " " + Str$(PL(6))
Rem 3 coords:
MhOutbox1.BCircle = Str$(PL(7)) + " " + Str$(PL(8)) + " " + Str$(PL(9))
Rem 4 coords:
MhOutbox1.Ellipse = Str$(PL(10)) + " " + Str$(PL(11)) + " " + Str$(PL(12)) + " " + Str$(PL(13))
MhOutbox1.BLine = Str$(PL(14)) + " " + Str$(PL(15)) + " " + Str$(PL(16)) + " " + Str$(PL(17))
MhOutbox1.Rectangle = Str$(PL(18)) + " " + Str$(PL(19)) + " " + Str$(PL(20)) + " " + Str$(PL(21))
Rem 6 coords:
MhOutbox1.RoundRect = Str$(PL(22)) + " " + Str$(PL(23)) + " " + Str$(PL(24)) + " " + Str$(PL(25)) + " " + Str$(PL(26)) + " " + Str$(PL(27))
Rem 8 coords:
MhOutbox1.Arc = Str$(PL(28)) + " " + Str$(PL(29)) + " " + Str$(PL(30)) + " " + Str$(PL(31)) + " " + Str$(PL(32)) + " " + Str$(PL(33)) + " " + Str$(PL(34)) + " " + Str$(PL(35))
MhOutbox1.Chord = Str$(PL(36)) + " " + Str$(PL(37)) + " " + Str$(PL(38)) + " " + Str$(PL(39)) + " " + Str$(PL(40)) + " " + Str$(PL(41)) + " " + Str$(PL(42)) + " " + Str$(PL(43))
MhOutbox1.Pie = Str$(PL(44)) + " " + Str$(PL(45)) + " " + Str$(PL(46)) + " " + Str$(PL(47)) + " " + Str$(PL(48)) + " " + Str$(PL(49)) + " " + Str$(PL(50)) + " " + Str$(PL(51))
Rem at least 2 pairs of coords:
MhOutbox1.Polyline = Str$(PL(52)) + " " + Str$(PL(53)) + " " + Str$(PL(54)) + " " + Str$(PL(55)) + " " + Str$(PL(56)) + " " + Str$(PL(57)) + " " + Str$(PL(58)) + " " + Str$(PL(59)) + " " + Str$(PL(60)) + " " + Str$(PL(61)) + " " + Str$(PL(62)) + " " + Str$(PL(63))
Rem at least 3 pairs of coords:
MhOutbox1.Polygon = Str$(PL(64)) + " " + Str$(PL(65)) + " " + Str$(PL(66)) + " " + Str$(PL(67)) + " " + Str$(PL(68)) + " " + Str$(PL(69)) + " " + Str$(PL(70)) + " " + Str$(PL(71)) + " " + Str$(PL(72)) + " " + Str$(PL(73)) + " " + Str$(PL(74)) + " " + Str$(PL(75))

Rem at least 8 pairs of coords & at least 2 counts:
MhOutbox1.PolyPolyP = Str$(PL(76)) + " " + Str$(PL(77)) + " " + Str$(PL(78)) + " " + Str$(PL(79)) + " " + Str$(PL(80)) + " " + Str$(PL(81)) + " " + Str$(PL(82)) + " " + Str$(PL(83)) + " " + Str$(PL(84)) + " " + Str$(PL(85)) + " " + Str$(PL(86)) + " " + Str$(PL(87)) + " " + Str$(PL(88)) + " " + Str$(PL(89)) + " " + Str$(PL(90)) + " " + Str$(PL(91))
MhOutbox1.PolyPolyC = "4 4"
Rem at least 4 pairs of coords:
MhOutbox1.PolyBezier = Str$(PL(92)) + " " + Str$(PL(93)) + " " + Str$(PL(94)) + " " + Str$(PL(95)) + " " + Str$(PL(96)) + " " + Str$(PL(97)) + " " + Str$(PL(98)) + " " + Str$(PL(99))
MhOutbox1.FillColor = RGB(255, 255, 255)
End Sub

Sub Command9_Click ()
'Plot
If FlagScale Then
  MhOutbox1.WindowExtX = MhOutbox1.ViewportExtX
  MhOutbox1.WindowExtY = MhOutbox1.ViewportExtY
  FlagScale = 0
End If
MhOutbox1.BrushStyle = 0
MhOutbox1.PenWidth = 0
If FlagClear Then MhOutbox1.Clear
X1 = Int(MhOutbox1.WindowExtX * MhOutbox1.MapRatioX)
X2 = Int(X1 / 2)
drift = Int(X1 / 6)
marksize = Int(X1 / 100)
Y1 = Int((MhOutbox1.WindowExtY * MhOutbox1.MapRatioY) * .95)
If MhOutbox1.MapMode > 1 And MhOutbox1.MapMode < 7 Then
  Y1 = -Y1
End If
Y2 = Int(Y1 / 2)
Call MhObLine(MhOutbox1, 0, Y2, X1, Y2)
x3 = Int(X2 / 5)
For tickmark = X2 + x3 To X1 Step x3
Call MhObLine(MhOutbox1, tickmark, Y2 - marksize, tickmark, Y2 + marksize)
Next tickmark
For tickmark = X2 - x3 To 0 Step -x3
Call MhObLine(MhOutbox1, tickmark, Y2 - marksize, tickmark, Y2 + marksize)
Next tickmark
Call MhObLine(MhOutbox1, X2, 0, X2, Y1)
y3 = Int(Y2 / 5)
For tickmark = Y2 + y3 To Y1 Step y3
Call MhObLine(MhOutbox1, X2 - marksize, tickmark, X2 + marksize, tickmark)
Next tickmark
For tickmark = Y2 - y3 To 0 Step -y3
Call MhObLine(MhOutbox1, X2 - marksize, tickmark, X2 + marksize, tickmark)
Next tickmark
Randomize
MhOutbox1.ForeColor = RGB(255, 0, 0)
For i = 1 To 100
displ = Int(Rnd(i) * X2)
x = X2 + Sgn(50 - i) * displ + Int(Rnd(i) * drift)
y = Y2 + Sgn(50 - i) * displ + Int(Rnd(i) * drift)
Call MhObRectangle(MhOutbox1, x - marksize, y - marksize, x + marksize, y + marksize)
Next i
MhOutbox1.ForeColor = RGB(0, 255, 0)
For i = 1 To 100
displ = Int(Rnd(i) * X2)
x = X2 + Sgn(50 - i) * displ + Int(Rnd(i) * drift)
y = Y2 - Sgn(50 - i) * displ - Int(Rnd(i) * drift)
Call MhObCircle(MhOutbox1, x, y, marksize)
Next i
MhOutbox1.ForeColor = RGB(0, 0, 255)
Call MhObLine(MhOutbox1, 0, Y1, X1, 0)
MhOutbox1.Text = "Trends"
MhOutbox1.TextAlignV = 1
MhOutbox1.TextOut = Str$(X2 - 20) + " " + Str$(Sgn(Y1) * MhOutbox1.WindowExtY)
MhOutbox1.ForeColor = RGB(0, 0, 0)
End Sub

Sub Fil_Click (index As Integer)
End
End Sub

Sub Form_Load ()
    
    InitLColors
    CenterForm Me
    gIBold = True
    OutCon(MhOutbox1.OutContext + 1).Checked = True
    MapM(MhOutbox1.MapMode).Checked = True
    FlagClear = -1'Normally clear--set to false to omit clear
    FlagScale = 0

End Sub

Sub Hlp_Click (index As Integer)
m$ = "MhOutbox -- device independence via Metafiles"
m$ = m$ + Chr$(10) + "Written by Mark Pottenger"
MsgBox m$
End Sub

Sub InitLColors ()

    ' Set up arrays of colors for painting the Horoscope Example
    LColorsF(1) = &HFFFFFF  ' bright white
    LColorsF(2) = &H800080  ' magenta
    LColorsF(3) = &HFF0000  ' bright blue
    LColorsF(4) = &H8080&   ' yellow
    LColorsF(5) = &HFF00&   ' light green
    LColorsF(6) = &H80&     ' red
    LColorsF(7) = &HC0C0C0  ' light gray
    LColorsF(8) = &HFF00FF  ' light magenta
    LColorsF(9) = &H800000  ' blue
    LColorsF(10) = &HFFFF&  ' light yellow
    LColorsF(11) = &H8000&  ' green
    LColorsF(12) = &HFF&    ' bright red


End Sub

Sub MapM_Click (index As Integer)
For i = 1 To 8
MapM(i).Checked = False
Next i
MapM(index).Checked = True
MhOutbox1.MapMode = index
End Sub

Sub MhOutbox1_Click ()
MhOutbox1.Clear
MhOutbox1.Picture = Picture1.Picture
End Sub

Sub OutCon_Click (index As Integer)
For i = 1 To 4
OutCon(i).Checked = False
Next i
OutCon(index).Checked = True
MhOutbox1.OutContext = index - 1
End Sub

Sub Picture1_Click ()
Picture1.Picture = MhOutbox1.Picture
End Sub

Sub SetAnisoText ()

If FlagScale Then
  MhOutbox1.WindowExtX = MhOutbox1.ViewportExtX
  MhOutbox1.WindowExtY = MhOutbox1.ViewportExtY
  FlagScale = 0
End If
'set Outbox Window values in Anisotropic mode to
'scale of text mode (a very good precaution for text work)
If MhOutbox1.MapMode = 1 Or MhOutbox1.MapMode = 8 Then
  If MhOutbox1.MapMode = 8 Then
    MhOutbox1.MapMode = 1
    X1 = MhOutbox1.ViewportExtX * MhOutbox1.MapRatioX
    Y1 = MhOutbox1.ViewportExtY * MhOutbox1.MapRatioY
    MhOutbox1.MapMode = 8
  Else
    X1 = MhOutbox1.ViewportExtX * MhOutbox1.MapRatioX
    Y1 = MhOutbox1.ViewportExtY * MhOutbox1.MapRatioY
  End If
  ' we are setting the window values to text mode pixels in the box
  MhOutbox1.WindowExtX = Int(X1)
  MhOutbox1.WindowExtY = Int(Y1)
  FlagScale = -1
End If

End Sub

