Option Explicit
'----------------------------------------------
' The following constants and global variables
' are specific to 3Dfx
'----------------------------------------------

' Box styles
Global Const BOX_RAISED = 0
Global Const BOX_SUNKEN = 1
Global Const BOX_SUNKENLINE = 2
Global Const BOX_RAISEDLINE = 3
Global Const BOX_SHADOWED = 4
Global Const BOX_CLEARBACKGROUND = 5
Global Const BOX_BEVELED = 6

' Label Styles
Global Const LBL_STANDARD = 0
Global Const LBL_RAISED = 1
Global Const LBL_SUNKEN = 2

' Label Alignment
Global Const LBL_LEFT = 0
Global Const LBL_CENTER = 1
Global Const LBL_RIGHT = 2

' Color constants
Global Const BOX_WHITE& = &HFFFFFF
Global Const BOX_LIGHTGRAY& = &HC0C0C0
Global Const BOX_DARKGRAY& = &H808080
Global Const BOX_BLACK& = &H0&

' Fill patterns
Global Const PAT_ZIGZAG = 1
Global Const PAT_BRICKS = 2
Global Const PAT_LIGHTGRAY = 3
Global Const PAT_DIAMONDS = 4
Global Const PAT_CIRCLES = 5
Global Const PAT_BRUSHED = 6
Global Const PAT_SOLID = 7
Global Const PAT_CUSTOM = 99

' Check Box Styles
Global Const CHK_PICWIDTH = 24
Global Const CHK_PICHEIGHT = 20

Global Const CHK_XWIDTH = 10
Global Const CHK_XHEIGHT = 10
Global Const CHK_CHECKWIDTH = 8
Global Const CHK_CHECKHEIGHT = 8


' pixel offsets into 3DBOXCH.BMP bitmap
Global Const CHK_BOXSUNKEN = 1
Global Const CHK_BOXRAISED = 25
Global Const CHK_DIAMONDSUNKEN = 49
Global Const CHK_DIAMONDRAISED = 73

Global Const CHK_BLUECHECK = 97
Global Const CHK_REDCHECK = 121
Global Const CHK_SMALLX = 145
Global Const CHK_LARGEX = 167

Global Const OPT_OFF_3D = 193
Global Const OPT_ON_3D = 217
Global Const OPT_OFF_DIAMOND = 241
Global Const OPT_ON_DIAMOND = 265

Global Const OPT_3D = 1
Global Const OPT_DIAMOND = 2

' set at startup to three appropriate color values.
' If not otherwise set, a gray scale will be used
Global Box_Highlight As Long
Global Box_BackGround As Long
Global Box_Dimmed As Long

' Array of bitmap patterns for Pattern fill functions
Global FXBitArray(7) As Integer

'Initialization values
Global FXTPPX As Integer
Global FXTPPY As Integer

Global ScaledFXTPPX As Integer
Global ScaledFXTPPY As Integer

'----------------------------------------------
' The following declarations and types are
' generic to VB or the Win API. Comment out or
' remove them if they are defined elsewhere.
'----------------------------------------------

Type RECT
    Left As Integer
    Top As Integer
    right As Integer
    bottom As Integer
End Type

'  Ternary raster operations
Global Const SRCCOPY = &HCC0020 ' (DWORD) dest = source
'Global Const SRCPAINT = &HEE0086    ' (DWORD) dest = source OR dest
'Global Const SRCAND = &H8800C6  ' (DWORD) dest = source AND dest
'Global Const SRCINVERT = &H660046   ' (DWORD) dest = source XOR dest
'Global Const SRCERASE = &H440328    ' (DWORD) dest = source AND (NOT dest )
'Global Const NOTSRCCOPY = &H330008  ' (DWORD) dest = (NOT source)
'Global Const NOTSRCERASE = &H1100A6 ' (DWORD) dest = (NOT src) AND (NOT dest)
'Global Const MERGECOPY = &HC000CA   ' (DWORD) dest = (source AND pattern)
'Global Const MERGEPAINT = &HBB0226  ' (DWORD) dest = (NOT source) OR dest
Global Const PATCOPY = &HF00021 ' (DWORD) dest = pattern
'Global Const PATPAINT = &HFB0A09    ' (DWORD) dest = DPSnoo
'Global Const PATINVERT = &H5A0049   ' (DWORD) dest = pattern XOR dest
'Global Const DSTINVERT = &H550009   ' (DWORD) dest = (NOT dest)
'Global Const BLACKNESS = &H42&  ' (DWORD) dest = BLACK
'Global Const WHITENESS = &HFF0062   ' (DWORD) dest = WHITE

Declare Function PatBlt Lib "GDI" (ByVal hDC As Integer, ByVal x As Integer, ByVal y As Integer, ByVal nWidth As Integer, ByVal nHeight As Integer, ByVal dwRop As Long) As Integer
Declare Function BitBlt Lib "GDI" (ByVal hDestDC As Integer, ByVal x As Integer, ByVal y As Integer, ByVal nWidth As Integer, ByVal nHeight As Integer, ByVal hSrcDC As Integer, ByVal XSrc As Integer, ByVal YSrc As Integer, ByVal dwRop As Long) As Integer
Declare Function CreatePatternBrush Lib "GDI" (ByVal hBitmap As Integer) As Integer

Declare Function CreateBitmap Lib "GDI" (ByVal nWidth As Integer, ByVal nHeight As Integer, ByVal nPlanes As Integer, ByVal nBitCount As Integer, lpBits As Any) As Integer
'NOTE: The declaration of CreateBitmap is WRONG in the WINAPI.TXT file. It has lpBits as "byval"

Declare Function DeleteObject Lib "GDI" (ByVal hObject As Integer) As Integer
Declare Function SelectObject Lib "GDI" (ByVal hDC As Integer, ByVal hObject As Integer) As Integer
Declare Function UnrealizeObject Lib "GDI" (ByVal hObject As Integer) As Integer
Declare Function GetDC Lib "User" (ByVal hWnd As Integer) As Integer
Declare Function ReleaseDC Lib "User" (ByVal hWnd As Integer, ByVal hDC As Integer) As Integer

Static Sub BoxControlOnControl (c As Control, c_container As PictureBox, b_width As Integer, box_effect As Integer, Line_Width As Integer)
'
' This routine is used to provide a 3d box effect around a control
' which is placed on another control, usually a picture box.
'
'  Parameters      Type       Comment
'    c            Control     name of the control to box
'    c_container  PictureBox  container of the first control
'    b_width      Integer     distance in pixels from edge of control
'    box_effect   Integer     one of BOX_RAISED, BOX_SUNKEN,
'                                BOX_RAISEDLINE, BOX_SUNKENLINE,
'                                BOX_SHADOWED, or BOX_BEVELED
'    line_width   Integer     width of the line in pixels
'
'  Note:
'    The line_width parameter is ignored for BOX_SHADOWED and BOX_BEVELED
'    The b_width parameter is ignored for the BOX_BEVELED

'  Example:
'     BoxControlOnControl label1, picture1, 5, BOX_RAISED, 2
'--------------------------------------------------------------

    'If box_effect < 0 Or box_effect > 6 Then
    '   MsgBox "Program error calling BoxControlOnControl. Invalid effect type"
    '   End
    'End If
    
    If box_effect = BOX_BEVELED Then
        DoBoxBeveledOnControl c_container, c
        Exit Sub
    End If

    Dim savesm_c As Integer

    Dim r As RECT

    savesm_c = c_container.ScaleMode

    r.Left = (c.Left \ ScaledFXTPPX) - b_width
    r.Top = (c.Top \ ScaledFXTPPX) - b_width
    
    r.right = ((c.Left + c.Width - 1) \ ScaledFXTPPX) + b_width
    r.bottom = ((c.Top + c.Height - 1) \ ScaledFXTPPX) + b_width
    
    BoxDrawControl c_container, box_effect, Line_Width, r

    c_container.ScaleMode = savesm_c

End Sub
            

Static Sub BoxControlOnForm (c As Control, b_width As Integer, box_effect As Integer, Line_Width As Integer)
'
' This routine is used to provide a 3d box effect around a
' control which is placed directly on a form.
'
'  Parameters      Type     Comment
'    c            Control   name of the control to box
'    b_width      Integer   distance in pixels from edge of control
'    box_effect   Integer   one of BOX_RAISED, BOX_SUNKEN,
'                             BOX_RAISEDLINE, BOX_SUNKENLINE,
'                             BOX_SHADOWED, or BOX_BEVELED
'    line_width   Integer   width of the line in pixels
'
'  Example:
'    BoxControlOnForm label1, 5, BOX_RAISEDLINE, 2
'
'  Note:
'    in order to box all controls on a form, use the following code:
'
'        For i% = 0 To Me.Count - 1
'            BoxControlOnForm me.controls(i%), 5, BOX_RAISED, 1
'        Next i%
'  The line_width parameter is ignored for BOX_SHADOWED and BOX_BEVELED
'  The b_width parameter is ignored for the BOX_BEVELED
'---------------------------------------------------------

    'If box_effect < 0 Or box_effect > 6 Then
    '   MsgBox "Program error calling BoxControlOnForm. Invalid effect type"
    '   End
    'End If
    
    If box_effect = BOX_BEVELED Then
        DoBoxBeveledOnForm c
        Exit Sub
    End If

    Dim savesm As Integer
    Dim r As RECT
    
    savesm = c.Parent.ScaleMode

    c.Parent.ScaleMode = 1 'twips

    '---- Calc inner-most of 3D effect
    r.Left = (c.Left \ ScaledFXTPPX) - b_width
    r.Top = (c.Top \ ScaledFXTPPX) - b_width

    r.right = ((c.Left + c.Width - 1) \ ScaledFXTPPX) + b_width
    r.bottom = ((c.Top + c.Height - 1) \ ScaledFXTPPX) + b_width
    
    BoxDrawForm c.Parent, box_effect, Line_Width, r

    c.Parent.ScaleMode = savesm
End Sub

Static Sub BoxDrawControl (c As PictureBox, box_effect As Integer, Line_Width As Integer, r As RECT)
'
' Modified 8/3/94  PC 'More accurately locates and draws the 3D effects
'
' This routine is used to draw 3d boxes on picture boxes
' based on pixel coordinates. The pixel count is based on
' screens with 15 twips per pixel. Monitors with 12 twips
' per pixel are automatically adjusted.
'
'  Parameters      Type       Comment
'    c            PictureBox  name of the control on which to
'                             draw the box
'    box_effect   Integer     one of BOX_RAISED, BOX_SUNKEN,
'                               BOX_RAISEDLINE, BOX_SUNKENLINE
'                               BOX_SHADOWED, or BOX_CLEARBACKGROUND
'    line_width   Integer     width of line in pixels (has no
'                               effect with BOX_SHADOWED)
'    r            RECT        structure with fields for top, bottom,
'                               left, right. Type is defined in
'                               3dfx.bas
'
'  Example:
'    dim r as RECT
'    r.top = 100 : r.left = 50
'    r.bottom = r.top + 200 : r.right = r.left + 200
'    BoxDrawControl picture1, BOX_SUNKEN, 1, r
'
'----------------------------------------------------------------

    'If box_effect < 0 Or box_effect > 5 Then
    '   MsgBox "Program error calling BoxDraw. Invalid effect type"
    '   End
    'End If
    
    Dim savefc As Long
    Dim savesm As Integer
    Dim savedw As Integer
    Dim N As Integer
    Dim HOffset As Integer
    Dim VOffset As Integer

    savefc = c.ForeColor
    savesm = c.ScaleMode
    savedw = c.DrawWidth
    
    HOffset = 0
    VOffset = 0

    c.ScaleMode = 1 'twips

    r.Top = r.Top * ScaledFXTPPY
    r.bottom = r.bottom * ScaledFXTPPY
    r.Left = r.Left * ScaledFXTPPX
    r.right = r.right * ScaledFXTPPX

    c.DrawWidth = Line_Width

    Select Case box_effect
        Case BOX_RAISED
            c.DrawWidth = 1
            '---- Draw 3D box expanding outward from control, offset "BWidth" from control
            For N = 1 To Line_Width
              'vertical left line
              c.Line (r.Left - HOffset, r.Top - VOffset)-(r.Left - HOffset, r.bottom + VOffset), Box_Highlight
              'horizontal top line
              c.Line (r.Left - HOffset, r.Top - VOffset)-(r.right + HOffset, r.Top - VOffset), Box_Highlight
              'vertical right line
              c.Line (r.right + HOffset, r.Top - VOffset)-(r.right + HOffset, r.bottom + VOffset + ScaledFXTPPY), Box_Dimmed
              'horizontal bottom line
              c.Line (r.Left - HOffset, r.bottom + VOffset)-(r.right + HOffset + ScaledFXTPPX, r.bottom + VOffset), Box_Dimmed
              
              HOffset = HOffset + ScaledFXTPPX
              VOffset = VOffset + ScaledFXTPPY
            Next

        Case BOX_SUNKEN
            c.DrawWidth = 1
            '---- Draw 3D box expanding outward from control, offset "BWidth" from control
            For N = 1 To Line_Width
              'vertical left line
              c.Line (r.Left - HOffset, r.Top - VOffset)-(r.Left - HOffset, r.bottom + VOffset), Box_Dimmed
              'horizontal top line
              c.Line (r.Left - HOffset, r.Top - VOffset)-(r.right + HOffset, r.Top - VOffset), Box_Dimmed
              'vertical right line
              c.Line (r.right + HOffset, r.Top - VOffset)-(r.right + HOffset, r.bottom + VOffset + ScaledFXTPPY), Box_Highlight
              'horizontal bottom line
              c.Line (r.Left - HOffset, r.bottom + VOffset)-(r.right + HOffset + ScaledFXTPPX, r.bottom + VOffset), Box_Highlight
              
              HOffset = HOffset + ScaledFXTPPX
              VOffset = VOffset + ScaledFXTPPY
            Next
        
        Case BOX_SUNKENLINE
            '---- Calc offsets required for thick lines
            HOffset = ((Line_Width \ 2) + (Line_Width Mod 2) - 1) * ScaledFXTPPX
            VOffset = ((Line_Width \ 2) + (Line_Width Mod 2) - 1) * ScaledFXTPPY
            
            '---- Draw highlight box first
            c.Line (r.Left - HOffset, r.Top - VOffset)-(r.right + 2 * ScaledFXTPPX + HOffset + (Abs(Line_Width Mod 2 = 0) * ScaledFXTPPX), r.bottom + 2 * ScaledFXTPPY + VOffset + (Abs(Line_Width Mod 2 = 0) * ScaledFXTPPY)), Box_Highlight, B
            '---- Shift the shadow box up and left one pixel
            c.Line (r.Left - ScaledFXTPPX - HOffset, r.Top - ScaledFXTPPY - VOffset)-(r.right + HOffset + (Abs(Line_Width Mod 2 = 0) * ScaledFXTPPX) + ScaledFXTPPX, r.bottom + VOffset + (Abs(Line_Width Mod 2 = 0) * ScaledFXTPPY) + ScaledFXTPPY), Box_Dimmed, B
        
        Case BOX_RAISEDLINE
            '---- Calc offsets required for thick lines
            HOffset = ((Line_Width \ 2) + (Line_Width Mod 2) - 1) * ScaledFXTPPX
            VOffset = ((Line_Width \ 2) + (Line_Width Mod 2) - 1) * ScaledFXTPPY
            
            '---- Draw highlight box first
            c.Line (r.Left - HOffset, r.Top - VOffset)-(r.right + 2 * ScaledFXTPPX + HOffset + (Abs(Line_Width Mod 2 = 0) * ScaledFXTPPX), r.bottom + 2 * ScaledFXTPPY + VOffset + (Abs(Line_Width Mod 2 = 0) * ScaledFXTPPY)), Box_Dimmed, B
            '---- Shift the shadow box up and left one pixel
            c.Line (r.Left - ScaledFXTPPX - HOffset, r.Top - ScaledFXTPPY - VOffset)-(r.right + HOffset + (Abs(Line_Width Mod 2 = 0) * ScaledFXTPPX) + ScaledFXTPPX, r.bottom + VOffset + (Abs(Line_Width Mod 2 = 0) * ScaledFXTPPY) + ScaledFXTPPY), Box_Highlight, B

        Case BOX_SHADOWED
            c.DrawWidth = 1
            c.Line (r.Left, r.Top)-(r.right, r.bottom), Box_Highlight, B
                'vertical right line
            c.DrawWidth = 4
            c.Line (r.right + (3 * ScaledFXTPPX), r.Top + (8 * ScaledFXTPPY))-(r.right + (3 * ScaledFXTPPX), r.bottom), Box_Dimmed
                'horizontal bottom line
            c.Line (r.Left + (8 * ScaledFXTPPX), r.bottom + (3 * ScaledFXTPPY))-(r.right + (3 * ScaledFXTPPX), r.bottom + (3 * ScaledFXTPPY)), Box_Dimmed

        Case BOX_CLEARBACKGROUND
            c.DrawWidth = 1
            For N = 1 To Line_Width
              c.Line (r.Left - HOffset, r.Top - VOffset)-(r.right + HOffset, r.bottom + VOffset), Box_BackGround, B
              HOffset = HOffset + ScaledFXTPPX
              VOffset = VOffset + ScaledFXTPPY
            Next
    
    End Select

    c.ForeColor = savefc
    c.ScaleMode = savesm
    c.DrawWidth = savedw

End Sub

Static Sub BoxDrawForm (f As Form, box_effect As Integer, Line_Width As Integer, rect_struct As RECT)
'
' Modified 8/3/94  PC 'More accurately draws and locates the 3D effects
'
' This routine is used to draw 3d boxes on forms based on
' pixel coordinates. The pixel count is based on screens
' with 15 twips per pixel. Monitors with 12 twips per pixel
' are automatically adjusted.
'
'  Parameters      Type     Comment
'    f            Form      form on which to draw the box
'    box_effect   Integer   one of BOX_RAISED, BOX_SUNKEN,
'                             BOX_RAISEDLINE, BOX_SUNKENLINE,
'                             BOX_SHADOWED, BOX_CLEARBACKGROUND
'    line_width   Integer   width of line in pixels (no effect
'                             with BOX_SHADOWED)
'    r            RECT      structure with fields for top, bottom,
'                            left, right
'  Example:
'    dim r as RECT
'    r.top = 100 : r.left = 50
'    r.bottom = r.top + 200 : r.right = r.left + 200
'    BoxDrawForm form1, BOX_SUNKEN, 1, r
'
'-----------------------------------------------------------------

    'If box_effect < 0 Or box_effect > 5 Then
    '   MsgBox "Program error calling BoxDraw. Invalid effect type"
    '   End
    'End If

    Dim savefc As Long
    Dim savesm As Integer
    Dim savedw As Integer
    Dim N As Integer        'For/Next counter
    Dim HOffset As Integer
    Dim VOffset As Integer

    Dim r As RECT

    r = rect_struct

    savefc = f.ForeColor
    savesm = f.ScaleMode
    savedw = f.DrawWidth
    
    HOffset = 0
    VOffset = 0

    f.ScaleMode = 1 'twips

    '---- Pixel to twip of point nearest the control  PC
    r.Top = r.Top * ScaledFXTPPY'X PC
    r.bottom = r.bottom * ScaledFXTPPY 'X PC
    r.Left = r.Left * ScaledFXTPPX
    r.right = r.right * ScaledFXTPPX

    f.DrawWidth = Line_Width

    Select Case box_effect
        Case BOX_RAISED
            f.DrawWidth = 1
            '---- Draw 3D box expanding outward from control, offset "BWidth" from control
            For N = 1 To Line_Width
              'vertical left line
              f.Line (r.Left - HOffset, r.Top - VOffset)-(r.Left - HOffset, r.bottom + VOffset), Box_Highlight
              'horizontal top line
              f.Line (r.Left - HOffset, r.Top - VOffset)-(r.right + HOffset, r.Top - VOffset), Box_Highlight
              'vertical right line
              f.Line (r.right + HOffset, r.Top - VOffset)-(r.right + HOffset, r.bottom + VOffset + ScaledFXTPPY), Box_Dimmed
              'horizontal bottom line
              f.Line (r.Left - HOffset, r.bottom + VOffset)-(r.right + HOffset + ScaledFXTPPX, r.bottom + VOffset), Box_Dimmed
              
              HOffset = HOffset + ScaledFXTPPX
              VOffset = VOffset + ScaledFXTPPY
            Next

        Case BOX_SUNKEN
            f.DrawWidth = 1
            '---- Draw 3D box expanding outward from control, offset "BWidth" from control
            For N = 1 To Line_Width
              'vertical left line
              f.Line (r.Left - HOffset, r.Top - VOffset)-(r.Left - HOffset, r.bottom + VOffset), Box_Dimmed
              'horizontal top line
              f.Line (r.Left - HOffset, r.Top - VOffset)-(r.right + HOffset, r.Top - VOffset), Box_Dimmed
              'vertical right line
              f.Line (r.right + HOffset, r.Top - VOffset)-(r.right + HOffset, r.bottom + VOffset + ScaledFXTPPY), Box_Highlight
              'horizontal bottom line
              f.Line (r.Left - HOffset, r.bottom + VOffset)-(r.right + HOffset + ScaledFXTPPX, r.bottom + VOffset), Box_Highlight
              
              HOffset = HOffset + ScaledFXTPPX
              VOffset = VOffset + ScaledFXTPPY
            Next
        
        Case BOX_SUNKENLINE
            '---- Calc offsets required for thick lines
            HOffset = ((Line_Width \ 2) + (Line_Width Mod 2) - 1) * ScaledFXTPPX
            VOffset = ((Line_Width \ 2) + (Line_Width Mod 2) - 1) * ScaledFXTPPY
            
            '---- Draw highlight box first
            f.Line (r.Left - HOffset, r.Top - VOffset)-(r.right + 2 * ScaledFXTPPX + HOffset + (Abs(Line_Width Mod 2 = 0) * ScaledFXTPPX), r.bottom + 2 * ScaledFXTPPY + VOffset + (Abs(Line_Width Mod 2 = 0) * ScaledFXTPPY)), Box_Highlight, B
            '---- Shift the shadow box up and left one pixel
            f.Line (r.Left - ScaledFXTPPX - HOffset, r.Top - ScaledFXTPPY - VOffset)-(r.right + HOffset + (Abs(Line_Width Mod 2 = 0) * ScaledFXTPPX) + ScaledFXTPPX, r.bottom + VOffset + (Abs(Line_Width Mod 2 = 0) * ScaledFXTPPY) + ScaledFXTPPY), Box_Dimmed, B
        
        Case BOX_RAISEDLINE
            '---- Calc offsets required for thick lines
            HOffset = ((Line_Width \ 2) + (Line_Width Mod 2) - 1) * ScaledFXTPPX
            VOffset = ((Line_Width \ 2) + (Line_Width Mod 2) - 1) * ScaledFXTPPY
            
            '---- Draw highlight box first
            f.Line (r.Left - HOffset, r.Top - VOffset)-(r.right + 2 * ScaledFXTPPX + HOffset + (Abs(Line_Width Mod 2 = 0) * ScaledFXTPPX), r.bottom + 2 * ScaledFXTPPY + VOffset + (Abs(Line_Width Mod 2 = 0) * ScaledFXTPPY)), Box_Dimmed, B
            '---- Shift the shadow box up and left one pixel
            f.Line (r.Left - ScaledFXTPPX - HOffset, r.Top - ScaledFXTPPY - VOffset)-(r.right + HOffset + (Abs(Line_Width Mod 2 = 0) * ScaledFXTPPX) + ScaledFXTPPX, r.bottom + VOffset + (Abs(Line_Width Mod 2 = 0) * ScaledFXTPPY) + ScaledFXTPPY), Box_Highlight, B

        Case BOX_SHADOWED
            f.DrawWidth = 1
            f.Line (r.Left, r.Top)-(r.right, r.bottom), Box_Highlight, B
                'vertical right line
            f.DrawWidth = 4
            f.Line (r.right + (3 * ScaledFXTPPX), r.Top + (8 * ScaledFXTPPY))-(r.right + (3 * ScaledFXTPPX), r.bottom), Box_Dimmed
                'horizontal bottom line
            f.Line (r.Left + (8 * ScaledFXTPPX), r.bottom + (3 * ScaledFXTPPY))-(r.right + (3 * ScaledFXTPPX), r.bottom + (3 * ScaledFXTPPY)), Box_Dimmed

        Case BOX_CLEARBACKGROUND
            f.DrawWidth = 1
            For N = 1 To Line_Width
              f.Line (r.Left - HOffset, r.Top - VOffset)-(r.right + HOffset, r.bottom + VOffset), Box_BackGround, B
              HOffset = HOffset + ScaledFXTPPX
              VOffset = VOffset + ScaledFXTPPY
            Next
    
    End Select

    f.ForeColor = savefc
    f.ScaleMode = savesm
    f.DrawWidth = savedw

End Sub

Private Static Sub DoBoxBeveledOnControl (p As PictureBox, c As Control)

Dim savefc As Long
Dim savesm As Integer

    savefc = p.ForeColor
    savesm = p.ScaleMode

    p.ScaleMode = 3 'pixels
    
    p.ForeColor = BOX_BLACK
    
    'vertical left
    p.Line (c.Left - 1, c.Top - 1)-(c.Left - 1, c.Top + c.Height + 1)
    'horizontal top
    p.Line (c.Left - 1, c.Top - 1)-(c.Left + c.Width, c.Top - 1)

    p.ForeColor = BOX_DARKGRAY
    
    'vertical left
    p.Line (c.Left - 2, c.Top - 2)-(c.Left - 2, c.Top + c.Height + 1)
    'horizontal top
    p.Line (c.Left - 2, c.Top - 2)-(c.Left + c.Width + 1, c.Top - 2)

    p.ForeColor = BOX_LIGHTGRAY
    
    'horizontal bottom
    p.Line (c.Left, c.Top + c.Height)-(c.Left + c.Width + 1, c.Top + c.Height)
    'vertical right
    p.Line (c.Left + c.Width, c.Top - 1)-(c.Left + c.Width, c.Top + c.Height + 1)

    p.ForeColor = BOX_WHITE

    'horizontal bottom
    p.Line (c.Left - 1, c.Top + c.Height + 1)-(c.Left + c.Width + 2, c.Top + c.Height + 1)
    'vertical right
    p.Line (c.Left + c.Width + 1, c.Top - 1)-(c.Left + c.Width + 1, c.Top + c.Height + 1)

    p.ForeColor = savefc
    p.ScaleMode = savesm

End Sub

Private Static Sub DoBoxBeveledOnForm (c As Control)

Dim f As Form
Dim savefc As Long
Dim savesm As Integer

    Set f = c.Parent
    savefc = f.ForeColor
    savesm = f.ScaleMode

    f.ScaleMode = 3 'pixels
    
    f.ForeColor = BOX_BLACK
    
    'vertical left
    f.Line (c.Left - 1, c.Top - 1)-(c.Left - 1, c.Top + c.Height + 1)
    'horizontal top
    f.Line (c.Left - 1, c.Top - 1)-(c.Left + c.Width, c.Top - 1)

    f.ForeColor = BOX_DARKGRAY
    
    'vertical left
    f.Line (c.Left - 2, c.Top - 2)-(c.Left - 2, c.Top + c.Height + 1)
    'horizontal top
    f.Line (c.Left - 2, c.Top - 2)-(c.Left + c.Width + 1, c.Top - 2)

    f.ForeColor = BOX_LIGHTGRAY
    
    'horizontal bottom
    f.Line (c.Left, c.Top + c.Height)-(c.Left + c.Width + 1, c.Top + c.Height)
    'vertical right
    f.Line (c.Left + c.Width, c.Top - 1)-(c.Left + c.Width, c.Top + c.Height + 1)

    f.ForeColor = BOX_WHITE

    'horizontal bottom
    f.Line (c.Left - 1, c.Top + c.Height + 1)-(c.Left + c.Width + 2, c.Top + c.Height + 1)
    'vertical right
    f.Line (c.Left + c.Width + 1, c.Top - 1)-(c.Left + c.Width + 1, c.Top + c.Height + 1)


    f.ForeColor = savefc
    f.ScaleMode = savesm
    

End Sub

Static Sub DoCheckBox (on_off As Integer, srcPic As PictureBox, destPic As PictureBox, box_style As Integer, check_style As Integer)
' With this routine you can simulate a 3D check box in one of
' various styles by using a normal check box in conjunction with
' a small bitmap. The bitmap covers the box portion of the check
' box control. This routine bitblt's the appropriate bitmap onto
' the picture depending on the state of the actual check box. Use
' this routine in conjunction with the "PassPicClickToCheck"
' routine, which passes mouse clicks on the bitmap onto the actual
' underlying check box.
'
'Parameters      Type       Comment
'  on_off       Integer     specifies whether or not to add the
'                             check bitmap onto the bitmap of the
'                             3D check box. Should be '0' or '1'.
'                             The 'gray' state is not supported.
'  srcPic       PictureBox  The picture box which contains the
'                             provided "3dboxch.bmp" picture. The
'                             picture should be accessible from
'                             anywhere in the project, preferably
'                             placed in the startup form.
'  destPic      PictureBox  The picture box which will receive the
'                             bitmap.
'  box_style    Integer     One of CHK_BOXSUNKEN, CHK_BOXRAISED,
'                             CHK_DIAMONDSUNKEN, CHK_DIAMONDRAISED
'  check_style  Integer     One of CHK_BLUECHECK, CHK_REDCHECK,
'                             CHK_SMALLX, CHK_LARGEX
'
'Example:
'  Place the following code in the real Check Box's Click Event:
'
'  Sub chkCheck_Click (index As Integer)
'    Select Case index
'        Case 0
'          DoCheckBox (chkCheck(index).Value), MDIMain!picCheckBoxes, picCheck(index), CHK_BOXSUNKEN, CHK_SMALLX
'        Case 1
'            DoCheckBox (chkCheck(index).Value), MDIMain!picCheckBoxes, picCheck(index), CHK_BOXRAISED, CHK_LARGEX
'     End Select
'  End Sub
'----------------------------------------------------------------------

Dim x As Integer
    
    destPic.AutoRedraw = True
     
    'copy the correct check box picture to the pic box
    x = BitBlt(destPic.hDC, 0, 0, CHK_PICWIDTH, CHK_PICHEIGHT, srcPic.hDC, box_style, 0, SRCCOPY)
     
    'if the box is supposed to be checked, add the appropriate check mark bitmap
    If on_off = 1 Then
        If check_style = CHK_SMALLX Or check_style = CHK_LARGEX Then
            x = BitBlt(destPic.hDC, 6, 6, CHK_XWIDTH, CHK_XHEIGHT, srcPic.hDC, check_style, 0, SRCCOPY)
        ElseIf check_style = CHK_REDCHECK Or check_style = CHK_BLUECHECK Then
            x = BitBlt(destPic.hDC, 6, 6, CHK_CHECKWIDTH, CHK_CHECKHEIGHT, srcPic.hDC, check_style, 0, SRCCOPY)
        End If
    End If
     
    destPic = destPic.Image
    destPic.AutoRedraw = False
End Sub

Static Sub DoControlLabelEmbossed (p As PictureBox, L1 As Label, L2 As Label, L3 As Label, label_text As String, label_effect As Integer, label_forecolor As Long)
'
'This routine is used to create an "embossed" effect using
'ordinary lightweight label controls which are placed
'on a picture box. First create three
'labels and place them on the picture. The first label will be
'the "real" label. The second and third labels provide the
'embossed effect. All labels must have their "BackStyle"
'property set to 0 - transparent
'
'It is usually simplest to create a three-element
'control array, and use label1(0) as the real label, and
'label1(1) and label1(2) as the shadow labels.
'
'Either put the actual caption on the first label, or use
'dummy text as a placeholder, and set the caption through
'this function.
'
' Parameters         Type       Comment
'   p               PictureBox  container for the labels
'   L1              Label       the "real" label
'   L2              Label       a shadow label
'   L3              Label       a shadow label
'   label_text      string      if = "", the caption from L1 will be used
'   label_effect    integer     one of LBL_STANDARD, LBL_RAISED, LBL_SUNKEN
'   label_forecolor long        color of top label
'
' Example:
'     'Use existing text in label1(0)
'   DoControlLabelEmbossed picture1, label1(0), label1(1), label1(2), "", LBL_RAISED
'
'     'Set label text in this function
'   DoControlLabelEmbossed picture1, label1(0), label1(1), label1(2), "My Label", LBL_SUNKEN
'
'----------------------------------------------------------------------

'Dim lt As String
'Dim savesm As Integer
'
'    L1.Visible = False
'    L2.Visible = False
'    L3.Visible = False
'
'    savesm = p.ScaleMode
'    p.ScaleMode = 3 'pixels
'
'    If label_text = "" Then
'        lt = L1
'    Else
'        lt = label_text
'    End If
'
'    L1 = lt
'    L2 = lt
'    L3 = lt
'
'    L1.BackStyle = 0 'transparent
'    L1.ForeColor = label_forecolor
'
'    L2.Width = L1.Width
'    L2.Height = L1.Height
'    L2.BackStyle = L1.BackStyle
'    L2.ForeColor = Box_Dimmed
'
'    L3.Width = L1.Width
'    L3.Height = L1.Height
'    L3.BackStyle = L1.BackStyle
'    L3.ForeColor = Box_Highlight
'
'    Select Case label_effect
'    '    Case LBL_STANDARD:
'    '        L2.Left = L1.Left
'        Case LBL_SUNKEN
'            L2.Left = L1.Left - 1
'            L2.Top = L1.Top - 1
'            L3.Left = L1.Left + 1
'            L3.Top = L1.Top + 1
'            L1.ZOrder
'        Case LBL_RAISED
'            L2.Left = L1.Left + 1
'            L2.Top = L1.Top + 1
'            L3.Left = L1.Left - 1
'            L3.Top = L1.Top - 1
'            L1.ZOrder
'
'    End Select
'    p.ScaleMode = savesm
'
'    L1.Visible = True
'    L2.Visible = True
'    L3.Visible = True
'
'
End Sub

Static Sub DoFormLabelEmbossed (L1 As Label, L2 As Label, L3 As Label, label_text As String, label_effect As Integer, label_forecolor As Long, label_depth As Integer)
'
'This routine is used to create an "embossed" effect using
'ordinary lightweight label controls which are placed
'directly on a form. First create three
'labels and place them on the form. The first label will be
'the "real" label. The second and third labels provide the
'embossed effect. All labels must have their "BackStyle"
'property set to 0 - transparent
'
'It is usually simplest to create a three-element
'control array, and use label1(0) as the real label, and
'label1(1) and label1(2) as the shadow labels.
'
'Either put the actual caption on the first label, or use
'dummy text as a placeholder, and set the caption through
'this function.
'
' Parameters         Type     Comment
'   L1              Label     the "real" label
'   L2              Label     a shadow label
'   L3              Label     a shadow label
'   label_text      string    if = "", the caption from L1 will be used
'   label_effect    integer   one of LBL_STANDARD, LBL_RAISED, LBL_SUNKEN
'   label_forecolor long        color of top label
'   label_forecolor long        color of top label
'
' Example:
'     'Use existing text in label1(0)
'   DoFormLabelEmbossed label1(0), label1(1), label1(2), "", LBL_RAISED
'
'     'Set label text in this function
'   DoFormLabelEmbossed label1(0), label1(1), label1(2), "My Label", LBL_SUNKEN
'
'----------------------------------------------------------------------

Dim lt As String
Dim savesm As Integer
Dim f As Form
Set f = L1.Parent
    
    L1.Visible = False
    L2.Visible = False
    L3.Visible = False

    savesm = f.ScaleMode
    f.ScaleMode = 3 'pixels

    If label_text = "" Then
        lt = L1
    Else
        lt = label_text
    End If

    L1 = lt
    L2 = lt
    L3 = lt

    L1.BackStyle = 0 'transparent
    L1.ForeColor = label_forecolor

    L2.Width = L1.Width
    L2.Height = L1.Height
    L2.BackStyle = L1.BackStyle
    L2.ForeColor = Box_Dimmed

    L3.Width = L1.Width
    L3.Height = L1.Height
    L3.BackStyle = L1.BackStyle
    L3.ForeColor = Box_Highlight

    Select Case label_effect
        Case LBL_SUNKEN
            L2.Left = L1.Left - label_depth
            L2.Top = L1.Top - label_depth
            L3.Left = L1.Left + label_depth
            L3.Top = L1.Top + label_depth
        Case LBL_RAISED
            L2.Left = L1.Left + label_depth
            L2.Top = L1.Top + label_depth
            L3.Left = L1.Left - label_depth
            L3.Top = L1.Top - label_depth

    End Select
    f.ScaleMode = savesm

    L1.Visible = True
    L2.Visible = True
    L3.Visible = True
    L1.ZOrder


End Sub

Static Sub DoLabelOnControl (c_container As PictureBox, L1 As Label, L2 As Label, label_text As String, label_effect As Integer)
'
' This routine is used to create a normal or 3d-effect with
' standard labels which are placed on containers such as
' picture boxes. First create two labels and place them on
' the container. The first label will be the "real" label. The
' second label provides the 3d effect. Both labels must have
' their "BackStyle" property set to 0 - transparent
'
' It is usually simplest to create a two-element
' control array, and use label1(0) as the real label, and
' label1(1) as the shadow label.
'
' Either put the actual caption on the first label, or use
' dummy text as a placeholder, and set the caption through
' this function.
'
' Parameters      Type       Comment
'   c_container  PictureBox  the container control
'   L1           Label     the "real" label
'   L2           Label     the shadow label
'   label_text   string      if = "", the caption from L1 will be used
'   label_effect integer     one of LBL_STANDARD, LBL_RAISED, LBL_SUNKEN
'
' Example:
'     'Use existing text in label1(0)
'   DoLabelOnControl picture1, label1(0), label1(1), "", LBL_RAISED
'
'     'Set label text in this function
'   DoLabelOnControl picture1, label1(0), label1(1), "My Label", LBL_SUNKEN
'
'----------------------------------------------------------------------

Dim lt As String
Dim savesm As Integer
Dim f As Form
Set f = L1.Parent
    
    If label_text = "" Then
        lt = L1
    Else
        lt = label_text
    End If
    
    L1 = lt
    L2 = lt
    L2.Width = L1.Width
    L2.Height = L1.Height

    savesm = c_container.ScaleMode
    c_container.ScaleMode = 3 'pixels

    Select Case label_effect
        Case LBL_STANDARD:
            L2.Left = L1.Left
            L2.Top = L1.Top
            L2 = L1
        Case LBL_SUNKEN
            L2.Left = L1.Left + 1
            L2.Top = L1.Top + 1
            L2.ForeColor = Box_Highlight
            L2.ZOrder
            L1.ForeColor = BOX_BLACK
            L1.ZOrder
        Case LBL_RAISED
            L2.Left = L1.Left - 1
            L2.Top = L1.Top - 1
            L2.ForeColor = Box_Highlight
            L2.ZOrder
            L1.ForeColor = BOX_BLACK
            L1.ZOrder

    End Select
    c_container.ScaleMode = savesm

End Sub

Static Sub DoLabelOnForm (L1 As Label, L2 As Label, label_text As String, label_effect As Integer)
'
' This routine is used to create a normal or 3d-effect with
' standard labels. First create two labels and place them on
' the form. The first label will be the "real" label. The
' second label provides the 3d effect. Both labels must have
' their "BackStyle" property set to 0 - transparent
'
' It is usually simplest to create a two-element
' control array, and use label1(0) as the real label, and
' label1(1) as the shadow label.
'
' Either put the actual caption on the first label, or use
' dummy text as a placeholder, and set the caption through
' this function.
'
' Parameters      Type     Comment
'   L1           Label     the "real" label
'   L2           Label     the shadow label
'   label_text   string    if = "", the caption from L1 will be used
'   label_effect integer   one of LBL_STANDARD, LBL_RAISED, LBL_SUNKEN
'
' Example:
'     'Use existing text in label1(0)
'   DoLabelOnForm label1(0), label1(1), "", LBL_RAISED
'
'     'Set label text in this function
'   DoLabelOnForm label1(0), label1(1), "My Label", LBL_SUNKEN
'
'----------------------------------------------------------------------

Dim lt As String
Dim savesm As Integer
Dim f As Form
Set f = L1.Parent
    
    savesm = f.ScaleMode
    f.ScaleMode = 3 'pixels

    If label_text = "" Then
        lt = L1
    Else
        lt = label_text
    End If
    
    L1 = lt
    L2 = lt
    L2.Width = L1.Width
    L2.Height = L1.Height

    Select Case label_effect
        Case LBL_STANDARD:
            L2.Left = L1.Left
        Case LBL_SUNKEN
            L2.Left = L1.Left + 1
            L2.Top = L1.Top + 1
            L2.ForeColor = Box_Highlight
            L2.ZOrder
            L1.ForeColor = BOX_BLACK
            L1.ZOrder
        Case LBL_RAISED
            L2.Left = L1.Left - 1
            L2.Top = L1.Top - 1
            L2.ForeColor = Box_Highlight
            L2.ZOrder
            L1.ForeColor = BOX_BLACK
            L1.ZOrder

    End Select
    f.ScaleMode = savesm
End Sub

Static Sub DoOptionButton (on_off As Integer, srcPic As PictureBox, destPic As PictureBox, opt_style As Integer)
' With this routine you can simulate a 3D option button by using
' a normal option button in conjunction with a small bitmap. The
' bitmap covers the button portion of the option button control.
' This routine bitblt's the appropriate bitmap onto the picture
' depending on the state of the actual option button. Use this
' routine in conjunction with the "PassPicClickToOption"  routine,
' which passes mouse clicks on the bitmap onto the actual
' underlying check box.
'
'Parameters      Type       Comment
'  on_off       Integer     specifies whether to show the chosen
'                             or not-chose version of the option
'                             bitmap. Should be 'true' or 'false'.'
'  srcPic       PictureBox  The picture box which contains the
'                             provided "3dboxch.bmp" picture. The
'                             picture should be accessible from
'                             anywhere in the project, preferably
'                             placed in the startup form.
'  destPic      PictureBox  The picture box which will receive the
'                             bitmap.
'
'  opt_style    integer     One of OPT_3D or OPT_DIAMOND
'
'Example:
'  Place the following code in the real Option Button's Click Event:
'  Notice that the bitmap for ALL of the grouped option buttons
'  must be changed when the option changes.
'
'Sub optOption_Click (index As Integer)
'    For i = 0 To 1
'        DoOptionButton (optOption(i).Value), MDIMain!picCheckBoxes, picOption(i), OPT_3D
'    Next i
'End Sub
'----------------------------------------------------------------------

Dim x As Integer
Dim p_offset As Integer

    If FXTPPX = 15 Then
        p_offset = 0
    Else
        p_offset = 3
    End If

    destPic.AutoRedraw = True
    destPic.BackColor = BOX_LIGHTGRAY

    If on_off = True Then
        Select Case opt_style
            Case OPT_3D
                x = BitBlt(destPic.hDC, p_offset, p_offset, CHK_PICWIDTH, CHK_PICHEIGHT, srcPic.hDC, OPT_ON_3D, 0, SRCCOPY)
            Case OPT_DIAMOND
                x = BitBlt(destPic.hDC, p_offset, p_offset, CHK_PICWIDTH, CHK_PICHEIGHT, srcPic.hDC, OPT_ON_DIAMOND, 0, SRCCOPY)
        End Select
    Else
        Select Case opt_style
            Case OPT_3D
                x = BitBlt(destPic.hDC, p_offset, p_offset, CHK_PICWIDTH, CHK_PICHEIGHT, srcPic.hDC, OPT_OFF_3D, 0, SRCCOPY)
            Case OPT_DIAMOND
                x = BitBlt(destPic.hDC, p_offset, p_offset, CHK_PICWIDTH, CHK_PICHEIGHT, srcPic.hDC, OPT_OFF_DIAMOND, 0, SRCCOPY)
        End Select
    End If
     
    destPic = destPic.Image
    destPic.AutoRedraw = False

End Sub

Static Sub DoPictureLabelEmbossed (p As PictureBox, L1 As Label, L2 As Label, L3 As Label, label_text As String, label_effect As Integer, label_forecolor As Long)
'
'This routine is used to create an "embossed" effect using
'ordinary lightweight label controls which are placed
'within a picture box. First create three
'labels and place them on the picture. The first label will be
'the "real" label. The second and third labels provide the
'embossed effect. All labels must have their "BackStyle"
'property set to 0 - transparent
'
'It is usually simplest to create a three-element
'control array, and use label1(0) as the real label, and
'label1(1) and label1(2) as the shadow labels.
'
'Either put the actual caption on the first label, or use
'dummy text as a placeholder, and set the caption through
'this function.
'
' Parameters         Type       Comment
'   p               PictureBox  the container for the labels
'   L1              Label       the "real" label
'   L2              Label       a shadow label
'   L3              Label       a shadow label
'   label_text      string      if = "", the caption from L1 will be used
'   label_effect    integer     one of LBL_STANDARD, LBL_RAISED, LBL_SUNKEN
'   label_forecolor long        color of front label
'
' Example:
'     'Use existing text in label1(0)
'   DoPictureLabelEmbossed picture1, label1(0), label1(1), label1(2), "", LBL_RAISED
'
'     'Set label text in this function
'   DoPictureLabelEmbossed picture1, label1(0), label1(1), label1(2), "My Label", LBL_SUNKEN
'
'----------------------------------------------------------------------
Dim lt As String
Dim savesm As Integer
    L1.Visible = False
    L2.Visible = False
    L3.Visible = False

    savesm = p.ScaleMode
    p.ScaleMode = 3 'pixels

    If label_text = "" Then
        lt = L1
    Else
        lt = label_text
    End If
    
    L1 = lt
    L2 = lt
    L3 = lt
    
    L1.BackStyle = 0 'transparent
    L1.ForeColor = label_forecolor
    
    L2.Width = L1.Width
    L2.Height = L1.Height
    L2.BackStyle = L1.BackStyle
    L2.ForeColor = Box_Dimmed

    L3.Width = L1.Width
    L3.Height = L1.Height
    L3.BackStyle = L1.BackStyle
    L3.ForeColor = Box_Highlight

    Select Case label_effect
    '    Case LBL_STANDARD:
    '        L2.Left = L1.Left
        Case LBL_SUNKEN
            L2.Left = L1.Left - 1
            L2.Top = L1.Top - 1
            L3.Left = L1.Left + 1
            L3.Top = L1.Top + 1
            L1.ZOrder
        Case LBL_RAISED
            L2.Left = L1.Left + 1
            L2.Top = L1.Top + 1
            L3.Left = L1.Left - 1
            L3.Top = L1.Top - 1
            L1.ZOrder

    End Select
    p.ScaleMode = savesm
    
    L1.Visible = True
    L2.Visible = True
    L3.Visible = True


End Sub

Static Sub FillFormClientArea (f As Form, fPattern As Integer, fcolor As Long, fHeight As Integer, fWidth As Integer)
'
' This routine is used to fill a form's client area with a bitmap
' built from an 8x8 pixel grid built at run-time. You can either
' use one of several pre-defined patterns or use a custom pattern.
'
'  Parameters      Type       Comment
'    f            Form        Form to fill. Autoredraw must be false
'    fPattern     integer     one of PAT_ZIGZAG, PAT_DIAMONDS
'                               PAT_BRICKS, PAT_LIGHTGRAY
'                               or PAT_CUSTOM
'    fColor       long        foreground color
'    fHeight      integer     height of client area to fill
'    fWidth       integer     width of client area to fill
'
'  Example:
'      For sizeable windows, fill entire screen area:
'        FillFormClientArea me, PAT_ZIGZAG, BOX_BLACK, (screen.height), (screen.width)
'
'      For fixed-size windows, fill only the client area:
'        FillFormClientArea me, PAT_LIGHTGRAY, BOX_BLACK, (me.scaleheight), (me.scalewidth)
'
'    To use a custom pattern, first call the helper routine
'    FillBitArray 8 times to establish the custom bit pattern.
'
'      FillBitArray 0, &HFF
'      FillBitArray 1, &HAA 'etc for 2 through 7
'      FillFormClientArea me, PAT_CUSTOM, BOX_BLACK, me.scaleheight, me.scalewidth
'-----------------------------------------------------------------

Dim hdcpict As Integer
Dim hBitmap As Integer
Dim hBrush As Integer
Dim hbPrevious As Integer
Dim savesm As Integer
Dim savefc As Long

Dim x As Integer
Dim i As Integer

Static lpvBits(0 To 7) As Integer

    savesm = f.ScaleMode
    savefc = f.ForeColor

    f.ScaleMode = 3
    f.ForeColor = fcolor

    Select Case fPattern
        Case PAT_CUSTOM
            For i = 0 To 7
                lpvBits(i) = GetFXBitArray(i)
            Next i

        Case PAT_ZIGZAG
            lpvBits(0) = &HFF
            lpvBits(1) = &HF7
            lpvBits(2) = &HEB
            lpvBits(3) = &HDD
            lpvBits(4) = &HBE
            lpvBits(5) = &H7F
            lpvBits(6) = &HFF
            lpvBits(7) = &HFF
        
        Case PAT_BRICKS
            lpvBits(0) = &HFF
            lpvBits(1) = &HC
            lpvBits(2) = &HC
            lpvBits(3) = &HC
            lpvBits(4) = &HFF
            lpvBits(5) = &HC0
            lpvBits(6) = &HC0
            lpvBits(7) = &HC0

        Case PAT_LIGHTGRAY
            lpvBits(0) = &H55
            lpvBits(1) = &HAA
            lpvBits(2) = &H55
            lpvBits(3) = &HAA
            lpvBits(4) = &H55
            lpvBits(5) = &HAA
            lpvBits(6) = &H55
            lpvBits(7) = &HAA
        
        Case PAT_DIAMONDS
            lpvBits(0) = &HEF
            lpvBits(1) = &HC7
            lpvBits(2) = &H83
            lpvBits(3) = &H1
            lpvBits(4) = &H83
            lpvBits(5) = &HC7
            lpvBits(6) = &HEF
            lpvBits(7) = &HFF
        
        Case PAT_CIRCLES
            lpvBits(0) = &HBB
            lpvBits(1) = &H7C
            lpvBits(2) = &HFF
            lpvBits(3) = &HFF
            lpvBits(4) = &H7C
            lpvBits(5) = &HBB
            lpvBits(6) = &HD7
            lpvBits(7) = &HD7
        
        Case PAT_BRUSHED
            lpvBits(0) = &H0
            lpvBits(1) = &H55
            lpvBits(2) = &H0
            lpvBits(3) = &H55
            lpvBits(4) = &H0
            lpvBits(5) = &H55
            lpvBits(6) = &H0
            lpvBits(7) = &H55

    End Select

    hBitmap = CreateBitmap(8, 8, 1, 1, lpvBits(0))

    hBrush = CreatePatternBrush(hBitmap)
    
    hdcpict = GetDC(f.hWnd)

    x = UnrealizeObject(hBrush)

    hbPrevious = SelectObject(f.hDC, hBrush)
    
    x = PatBlt(f.hDC, 0, 0, (fWidth \ FXTPPX), (fHeight \ FXTPPY), PATCOPY)
    
    x = SelectObject(f.hDC, hbPrevious)
    x = ReleaseDC(f.hWnd, hdcpict)

    x = DeleteObject(hBitmap)
    x = DeleteObject(hBrush)
    
    f.ScaleMode = savesm
    f.ForeColor = savefc
End Sub

Sub FillFXBitArray (apos As Integer, avalue As Integer)

    If apos < 0 Or apos > 7 Then
        MsgBox "Subscript error: FillFXBitArray"
        End
    End If

    FXBitArray(apos) = avalue

End Sub

Static Sub FillPicture (p As PictureBox, fPattern As Integer, fcolor As Long, fheightpercent As Integer, fwidthpercent As Integer)
'
' This routine is used to fill a picture box with a bitmap built
' from an 8x8 pixel grid built at run-time. You can either use
' one of several pre-defined patterns or use a custom pattern.
' If the fwidthpercent or fheightpercent numbers are negative
' then the fill is done from right to left or bottom to top
'
'  Parameters        Type       Comment
'    p              PictureBox  Picture to fill
'    fPattern       integer     one of PAT_ZIGZAG, PAT_DIAMONDS
'                               PAT_BRICKS, PAT_LIGHTGRAY, PAT_SOLID,
'                               or PAT_CUSTOM
'    fColor          long        foreground color
'    FHeightPercent  integer    number from 0 to 100, height to fill
'                                the box
'    FWidthPercent   ineger     number from 0 to 100, width to fill
'                                the box
'
'  Example:
'      FillPicture Picture1, PAT_ZIGZAG, BOX_BLACK, 100, 75
'
'    To use a custom pattern, first call the helper routine
'    FillFXBitArray 8 times to establish the custom bit pattern.
'
'      FillFXBitArray 0, &HFF
'      FillFXBitArray 1, &HAA 'etc for 2 through 7
'      FillPicture Picture1, PAT_CUSTOM, BOX_BLACK
'-----------------------------------------------------------------

Dim hdcpict As Integer
Dim hBitmap As Integer
Dim hBrush As Integer
Dim hbPrevious As Integer
Dim savesm As Integer
Dim startx As Integer
Dim starty As Integer

Dim x As Integer

Static lpvBits(0 To 7) As Integer
Dim i As Integer

    savesm = p.ScaleMode

    p.ScaleMode = 3
    p.ForeColor = fcolor

    Select Case fPattern
        Case PAT_CUSTOM
            For i = 0 To 7
                lpvBits(i) = GetFXBitArray(i)
            Next i

        Case PAT_ZIGZAG
            lpvBits(0) = &HFF
            lpvBits(1) = &HF7
            lpvBits(2) = &HEB
            lpvBits(3) = &HDD
            lpvBits(4) = &HBE
            lpvBits(5) = &H7F
            lpvBits(6) = &HFF
            lpvBits(7) = &HFF
        Case PAT_BRICKS
            lpvBits(0) = &HFF
            lpvBits(1) = &HC
            lpvBits(2) = &HC
            lpvBits(3) = &HC
            lpvBits(4) = &HFF
            lpvBits(5) = &HC0
            lpvBits(6) = &HC0
            lpvBits(7) = &HC0
        Case PAT_LIGHTGRAY
            lpvBits(0) = &H55
            lpvBits(1) = &HAA
            lpvBits(2) = &H55
            lpvBits(3) = &HAA
            lpvBits(4) = &H55
            lpvBits(5) = &HAA
            lpvBits(6) = &H55
            lpvBits(7) = &HAA
        Case PAT_SOLID
            lpvBits(0) = &H0
            lpvBits(1) = &H0
            lpvBits(2) = &H0
            lpvBits(3) = &H0
            lpvBits(4) = &H0
            lpvBits(5) = &H0
            lpvBits(6) = &H0
            lpvBits(7) = &H0

        Case PAT_DIAMONDS
            lpvBits(0) = &HEF
            lpvBits(1) = &HC7
            lpvBits(2) = &H83
            lpvBits(3) = &H1
            lpvBits(4) = &H83
            lpvBits(5) = &HC7
            lpvBits(6) = &HEF
            lpvBits(7) = &HFF
        Case PAT_CIRCLES
            lpvBits(0) = &HBB
            lpvBits(1) = &H7C
            lpvBits(2) = &HFF
            lpvBits(3) = &HFF
            lpvBits(4) = &H7C
            lpvBits(5) = &HBB
            lpvBits(6) = &HD7
            lpvBits(7) = &HD7
    End Select

    hBitmap = CreateBitmap(8, 8, 1, 1, lpvBits(0))

    hBrush = CreatePatternBrush(hBitmap)
    
    hdcpict = GetDC(p.hWnd)

    x = UnrealizeObject(hBrush)

    hbPrevious = SelectObject(p.hDC, hBrush)

    If fwidthpercent >= 0 Then
        startx = 0
    Else
        startx = p.ScaleWidth - (p.ScaleWidth * (Abs(fwidthpercent) / 100))
    End If

    If fheightpercent >= 0 Then
        starty = 0
    Else
        starty = p.ScaleHeight - (p.ScaleHeight * (Abs(fheightpercent) / 100))
    End If
   
    x = PatBlt(p.hDC, startx, starty, p.ScaleWidth * (Abs(fwidthpercent) / 100), p.ScaleHeight * (Abs(fheightpercent) / 100), PATCOPY)

    x = SelectObject(p.hDC, hbPrevious)
    x = ReleaseDC(p.hWnd, hdcpict)

    x = DeleteObject(hBitmap)
    x = DeleteObject(hBrush)
    
    p.ScaleMode = savesm

End Sub

Static Sub FramePictureOnControl (c As Control, c_container As PictureBox, b_width As Integer, box_effect As Integer, Line_Width As Integer, f_label As String, label_effect As Integer, label_align As Integer)
'
' This sub is used to simulate a 3d frame control when the control
' you are framing is placed within another control, usually a picture
' box.
'
' First create a picture box as a frame with no border. Set its
' backcolor to the value of "Box_Background".
'
' Then use this sub to frame it with 3d effects.
'  Parameters      Type       Comment
'    c            control     the control being framed
'    c_container  PictureBox  container of the first control
'    b_width      Integer     distance from box in pixels. A value
'                               of 6 or 7 is good
'    box_effect   Integer     one of BOX_RAISED, BOX_SUNKEN,
'                               BOX_RAISEDLINE, BOX_SUNKENLINE
'                               or BOX_SHADOWED
'    line_width   Integer     width of frame in pixels
'    f_label      String      label text for the "frame"
'    label_effect Integer     one of LBL_STANDARD, LBL_RAISED, LBL_SUNKEN
'    label_align  integer     one of LBL_LEFT, LBL_CENTER, LBL_RIGHT
'
' Example:
'   FramePictureOnControl picture2, picture1, 6, BOX_SHADOWED, 1, "My Caption", LBL_RAISED, LBL_RIGHT
'
'------------------------------------------------------------

Dim savefc As Long
Dim savedw As Integer
Dim savesm As Integer

Dim savefc_c As Long
Dim savedw_c As Integer
Dim savesm_c As Integer

Dim tempx As Integer
Dim tempy As Integer

Dim startx As Integer
Dim starty As Integer

    savefc_c = c_container.ForeColor
    savedw_c = c_container.DrawWidth
    savesm_c = c_container.ScaleMode
    
    savefc = c.ForeColor
    savedw = c.DrawWidth
    savesm = c.ScaleMode

    BoxControlOnControl c, c_container, b_width, box_effect, Line_Width
    
    c.ScaleMode = 3 'pixels
    c_container.ScaleMode = 3'
  
    Select Case label_align
        Case LBL_LEFT
            startx = c.Left + 5
        Case LBL_CENTER
            startx = c.Left + ((c.Width - c_container.TextWidth(f_label)) \ 2)
        Case LBL_RIGHT
            startx = (c.Left + c.Width) - c_container.TextWidth(f_label) - 5
    End Select

    c_container.CurrentX = startx
    c_container.CurrentY = c.Top - b_width
    c_container.DrawWidth = 14
    c_container.Line (c_container.CurrentX, c_container.CurrentY)-(c_container.CurrentX + c_container.TextWidth(f_label), c_container.CurrentY), Box_BackGround
    
    starty = c.Top - b_width - (c_container.TextHeight("ABC") \ 2)
    
    c_container.ForeColor = BOX_BLACK
    
    Select Case label_effect
        Case LBL_STANDARD
            c_container.CurrentX = startx
            c_container.CurrentY = starty
            c_container.Print f_label
        Case LBL_SUNKEN
            tempx = startx
            tempy = starty
            c_container.CurrentX = startx
            c_container.CurrentY = starty
            c_container.ForeColor = Box_Highlight
            c_container.Print f_label
            c_container.CurrentX = tempx - 1
            c_container.CurrentY = tempy - 1
            c_container.ForeColor = BOX_BLACK
            c_container.Print f_label
        Case LBL_RAISED
            tempx = startx
            tempy = starty
            c_container.CurrentX = startx
            c_container.CurrentY = starty
            c_container.ForeColor = Box_Highlight
            c_container.Print f_label
            c_container.CurrentX = tempx + 1
            c_container.CurrentY = tempy + 1
            c_container.ForeColor = BOX_BLACK
            c_container.Print f_label

    End Select

    c_container.ForeColor = savefc_c
    c_container.DrawWidth = savedw_c
    c_container.ScaleMode = savesm_c
    
    c.ForeColor = savefc
    c.DrawWidth = savedw
    c.ScaleMode = savesm


End Sub

Static Sub FramePictureOnForm (c As PictureBox, b_width As Integer, box_effect As Integer, Line_Width As Integer, f_label As String, label_effect As Integer, label_align As Integer)
'
' This sub is used to simulate a 3d frame control when the control
' you are framing is placed directly on a form.
'
' First create a picture box as a frame with no border. Set its
' backcolor to the value of "Box_Background".
'
' Then use this sub to frame it with 3d effects.
'  Parameters      Type       Comment
'    c            PictureBox  the control being framed
'    b_width      Integer     distance from box in pixels. A value
'                               of 6 or 7 is good
'    box_effect   Integer     one of BOX_RAISED, BOX_SUNKEN,
'                               BOX_RAISEDLINE, BOX_SUNKENLINE
'                               or BOX_SHADOWED
'    line_width   Integer     width of frame in pixels
'    f_label      String      label text for the "frame"
'    label_effect Integer     one of LBL_STANDARD, LBL_RAISED, LBL_SUNKEN
'    label_align  integer     one of LBL_LEFT, LBL_CENTER, LBL_RIGHT
'
' Example:
'   FramePictureOnForm picture1, 6, BOX_SHADOWED, 1, "My Caption", LBL_RAISED, LBL_RIGHT
'
'------------------------------------------------------------

Dim savefc As Long
Dim savedw As Integer
Dim savesm As Integer

Dim tempx As Integer
Dim tempy As Integer

Dim startx As Integer
Dim starty As Integer

Dim f As Form
Set f = c.Parent
    
    savefc = f.ForeColor
    savedw = f.DrawWidth
    savesm = f.ScaleMode

    f.ScaleMode = 3 'pixels

    BoxControlOnForm c, b_width, box_effect, Line_Width
  
    f.ForeColor = Box_BackGround

    Select Case label_align
        Case LBL_LEFT
            startx = c.Left + 5
        Case LBL_CENTER
            startx = c.Left + ((c.Width - f.TextWidth(f_label)) \ 2)
        Case LBL_RIGHT
            startx = (c.Left + c.Width) - f.TextWidth(f_label) - 5
    End Select
    
    f.CurrentX = startx
    f.CurrentY = c.Top - b_width
    f.DrawWidth = 14
    f.Line (f.CurrentX, f.CurrentY)-(f.CurrentX + f.TextWidth(f_label), f.CurrentY)

    starty = c.Top - b_width - (f.TextHeight("ABC") \ 2)
    
    f.ForeColor = BOX_BLACK
    Select Case label_effect
        Case LBL_STANDARD
            f.CurrentX = startx
            f.CurrentY = starty
            f.Print f_label
        Case LBL_SUNKEN
            tempx = startx
            tempy = starty
            f.CurrentX = startx
            f.CurrentY = starty
            f.ForeColor = Box_Highlight
            f.Print f_label
            f.CurrentX = tempx - 1
            f.CurrentY = tempy - 1
            f.ForeColor = BOX_BLACK
            f.Print f_label
        Case LBL_RAISED
            tempx = startx
            tempy = starty
            f.CurrentX = startx
            f.CurrentY = starty
            f.ForeColor = Box_Highlight
            f.Print f_label
            f.CurrentX = tempx + 1
            f.CurrentY = tempy + 1
            f.ForeColor = BOX_BLACK
            f.Print f_label

    End Select

    f.ForeColor = savefc
    f.DrawWidth = savedw
    f.ScaleMode = savesm
End Sub

Private Function GetFXBitArray (apos As Integer) As Integer
    GetFXBitArray = FXBitArray(apos)
End Function

Sub Initialize3DFX ()
    If Box_Highlight = 0 Then
        Box_Highlight = BOX_WHITE
        Box_BackGround = BOX_LIGHTGRAY
        Box_Dimmed = BOX_DARKGRAY
    
    End If
    
    FXTPPX = screen.TwipsPerPixelX
    FXTPPY = screen.TwipsPerPixelY

    If FXTPPX = 12 Then
        ScaledFXTPPX = FXTPPX * 1.25
    Else                   'if tppx = 15 normally
        ScaledFXTPPX = FXTPPX
    End If
    
    If FXTPPY = 12 Then
        ScaledFXTPPY = FXTPPY * 1.25
    Else                   'if tppy = 15 normally
        ScaledFXTPPY = FXTPPY
    End If




End Sub

Static Sub LineOnForm (f As Form, line_effect As Integer, Line_Width As Integer, X1 As Integer, Y1 As Integer, X2 As Integer, Y2 As Integer)
'
' This routine is used to draw etched or raised lines on
' forms based on pixel coordinates. The pixel count is
' based on screens with 15 twips per pixel. Monitors with
' 12 twips per pixel are automatically adjusted.
'
'  Parameters      Type     Comment
'    f             Form      form on which to draw the line
'    line_effect   Integer   one of BOX_RAISEDLINE or BOX_SUNKENLINE
'    line_width    Integer   width of line in pixels
'    X1            Integer   Starting X position of the line
'    Y1            Integer   Starting Y position of the line
'    X2            Integer   Ending X position of the line
'    Y2            Integer   Ending Y position of the line
'
'  Example:
'    LineOnForm me, BOX_RAISEDLINE, 1, 100, 100, 200, 200
'
'-----------------------------------------------------------------

Dim savefc As Long
Dim savesm As Integer
Dim savedw As Integer
    savefc = f.ForeColor
    savesm = f.ScaleMode
    savedw = f.DrawWidth

    f.ScaleMode = 1 'twips
    
    X1 = X1 * ScaledFXTPPX
    Y1 = Y1 * ScaledFXTPPX
    X2 = X2 * ScaledFXTPPX
    Y2 = Y2 * ScaledFXTPPX

    f.DrawWidth = Line_Width

    Select Case line_effect
        Case BOX_SUNKENLINE
            f.Line (X1, Y1)-(X2, Y2), Box_Highlight
            f.Line (X1 - (1 * ScaledFXTPPX), Y1 - (1 * ScaledFXTPPX))-(X2 - (1 * ScaledFXTPPX), Y2 - (1 * ScaledFXTPPX)), Box_Dimmed

        Case BOX_RAISEDLINE
            f.Line (X1, Y1)-(X2, Y2), Box_Dimmed
            f.Line (X1 - (1 * ScaledFXTPPX), Y1 - (1 * ScaledFXTPPX))-(X2 - (1 * ScaledFXTPPX), Y2 - (1 * ScaledFXTPPX)), Box_Highlight

    End Select

    f.ForeColor = savefc
    f.ScaleMode = savesm
    f.DrawWidth = savedw
End Sub

Static Sub LineOnPicture (p As PictureBox, line_effect As Integer, Line_Width As Integer, X1 As Integer, Y1 As Integer, X2 As Integer, Y2 As Integer)
'
' This routine is used to draw etched or raised lines on
' a picture box based on pixel coordinates. The pixel count
' is based on screens with 15 twips per pixel. Monitors
' with 12 twips per pixel are automatically adjusted.
'
'  Parameters      Type        Comment
'    p             PictureBox  form on which to draw the line
'    line_effect   Integer     one of BOX_RAISEDLINE or BOX_SUNKENLINE
'    line_width    Integer     width of line in pixels
'    X1            Integer     Starting X position of the line
'    Y1            Integer     Starting Y position of the line
'    X2            Integer     Ending X position of the line
'    Y2            Integer     Ending Y position of the line
'
'  Example:
'    LineOnPicture Picture1, BOX_SUNKENLINE, 1, 100, 100, 200, 200
'
'-----------------------------------------------------------------

Dim savefc As Long
Dim savesm As Integer
Dim savedw As Integer
    X1 = X1 * ScaledFXTPPX
    Y1 = Y1 * ScaledFXTPPX
    X2 = X2 * ScaledFXTPPX
    Y2 = Y2 * ScaledFXTPPX

    
    savefc = p.ForeColor
    savesm = p.ScaleMode
    savedw = p.DrawWidth

    p.ScaleMode = 1 'twips

    p.DrawWidth = Line_Width

    Select Case line_effect
        Case BOX_SUNKENLINE
            p.Line (X1, Y1)-(X2, Y2), Box_Highlight
            p.Line (X1 - (1 * ScaledFXTPPX), Y1 - (1 * ScaledFXTPPX))-(X2 - (1 * ScaledFXTPPX), Y2 - (1 * ScaledFXTPPX)), Box_Dimmed

        Case BOX_RAISEDLINE
            p.Line (X1, Y1)-(X2, Y2), Box_Dimmed
            p.Line (X1 - (1 * ScaledFXTPPX), Y1 - (1 * ScaledFXTPPX))-(X2 - (1 * ScaledFXTPPX), Y2 - (1 * ScaledFXTPPX)), Box_Highlight

    End Select

    p.ForeColor = savefc
    p.ScaleMode = savesm
    p.DrawWidth = savedw

End Sub

Static Sub PassPicClickToCheck (chk As CheckBox)
' Call this routine from the Click event of the bitmap
' which is associated with an actual Check Box. When
' the bitmap is clicked, this routine simply manually
' changes the value of the real Check Box. This in turn
' causes the Click event of the real Check Box to trigger
' as it would if the user had clicked on it instead of
' the bitmap
'
'Parameters      Type       Comment
'  chk           CheckBox     The Check Box to trigger
'
'Example:
'
'  Place the following code in the click event of the bitmap:
'
'Sub picCheck_Click (index As Integer)
'   PassPicClickToCheck chkCheck(index)
'End Sub
'----------------------------------------------------------------------
    
    If chk = 1 Then
        chk = 0
    Else
        chk = 1
    End If
    chk.SetFocus

End Sub

Static Sub PassPicClickToOption (opt As OptionButton)
' Call this routine from the Click event of the bitmap
' which is associated with an actual Option Button. When
' the bitmap is clicked, this routine simply manually
' changes the value of the real Option Button. This in
' turn causes the Click event of the real Option Button
' to trigger as it would if the user had clicked on it
' instead of the bitmap
'
'Parameters      Type          Comment
'  opt           OptionButton  The Option Button to trigger
'
'Example:
'
'  Place the following code in the click event of the bitmap:
'
'Sub picOption_Click (index As Integer)
'   PassPicClickToOption optOption(index)
'End Sub

'----------------------------------------------------------------------
    
    If opt = True Then
        opt = False
    Else
        opt = True
    End If
    opt.SetFocus

End Sub

Static Sub SizeButton (img As Image, shp As Shape)
Dim savesm As Integer
Dim f As Form

    Set f = img.Parent
        
    savesm = f.ScaleMode
    f.ScaleMode = 3

    shp.Top = img.Top - 4
    shp.Left = img.Left - 4
    shp.Width = img.Width + 8
    shp.Height = img.Height + 8

    f.ScaleMode = savesm

End Sub

