
/***********************************************************/
/* Copyright (C) 1993 AT&T Bell Labs.  All rights reserved.*/
/***********************************************************/
/*
 *  tdrvr.h    TSERVER Driver Events Defines
 *
 *  Header File Dependencies
 *   	drvrdefs.h
 *
 */

#include "drvrdefs.h"

#define	TDRVRREQUEST		7
#define	TDRVRUNSOLICITED	8
#define	TDRVRCONFIRMATION	9

typedef struct 
{
	union 
	{
		TSRVDriverOAMEvent_t		driverEvent;
	} u;
} TSRVDriverUnsolicitedEvent;

typedef struct 
{
	InvokeID_t	invokeID;
	union 
	{
		TSRVDriverOAMConfEvent_t	driverConf;
	} u;
} TSRVDriverConfirmationEvent;

#define TSRV_DRIVER_HEAP	1024

typedef struct 
{
	ACSEventHeader_t	eventHeader;
	union 
	{
		ACSUnsolicitedEvent		acsUnsolicited;
		ACSConfirmationEvent		acsConfirmation;
		TSRVDriverUnsolicitedEvent	driverUnsolicited;
		TSRVDriverConfirmationEvent	driverConfirmation;
	} event;
	char	heap[TSRV_DRIVER_HEAP];
	  
} TSRVDriverEvent_t;


// function prototypes

TSAPI
tsrvDriverRequest (	ACSHandle_t			acsHandle,
					InvokeID_t			invokeID,
				    unsigned char   FAR *data,
				    int             	length);
