/***********************************************************/
/* Copyright (C) 1993 AT&T Bell Labs.  All rights reserved.*/
/***********************************************************/
/*
 *  csta.h    CSTA Events Defines
 *
 *  Header File Dependencies
 *   	cstadefs.h, acs.h
 *
 */

#ifndef	CSTA_H
#define	CSTA_H

#include "cstadefs.h"

// This is the version for the CSTA API that should be used in
// the call to acsOpenStream().
#define CSTA_API_VERSION        "1.6"	/* Current version number of CSTA API */


// defines for CSTA event classes

#define	CSTAREQUEST		3
#define	CSTAUNSOLICITED		4
#define	CSTACONFIRMATION	5
#define	CSTAEVENTREPORT		6


#define CSTA_MAX_GET_DEVICE	20	/* Maximum number of devices
					 * a CSTAGetDevice call can
					 * return 
					 */
typedef struct 
{
	InvokeID_t	invokeID;
	union 
	{
		CSTARouteRequestEvent_t		routeRequest;
		CSTAReRouteRequest_t		reRouteRequest;
		CSTAEscapeSvcReqEvent_t		escapeSvcReqeust;
		CSTASysStatReqEvent_t		sysStatRequest;
	} u;
} CSTARequestEvent;

typedef struct
{
	union
	{
		CSTARouteRegisterAbortEvent_t   registerAbort;
		CSTARouteUsedEvent_t		routeUsed;
		CSTARouteEndEvent_t		routeEnd;
		CSTAPrivateEvent_t		privateEvent;
		CSTASysStatEvent_t		sysStat;
		CSTASysStatEndedEvent_t		sysStatEnded;
	}u;
} CSTAEventReport;

typedef struct 
{
	CSTAMonitorCrossRefID_t		monitorCrossRefId;
	union 
	{
		CSTACallClearedEvent_t		callCleared;
		CSTAConferencedEvent_t		conferenced;
		CSTAConnectionClearedEvent_t	connectionCleared;
		CSTADeliveredEvent_t		delivered;
		CSTADivertedEvent_t		diverted;
		CSTAEstablishedEvent_t		established;
		CSTAFailedEvent_t		failed;
		CSTAHeldEvent_t			held;
		CSTANetworkReachedEvent_t	networkReached;
		CSTAOriginatedEvent_t		originated;
		CSTAQueuedEvent_t		queued;
		CSTARetrievedEvent_t		retrieved;
		CSTAServiceInitiatedEvent_t	serviceInitiated;
		CSTATransferredEvent_t		transferred;
		CSTACallInformationEvent_t	callInformation;
		CSTADoNotDisturbEvent_t		doNotDisturb;
		CSTAForwardingEvent_t		forwarding;
		CSTAMessageWaitingEvent_t	messageWaiting;
		CSTALoggedOnEvent_t		loggedOn;
		CSTALoggedOffEvent_t		loggedOff;
		CSTANotReadyEvent_t		notReady;
		CSTAReadyEvent_t		ready;
		CSTAWorkNotReadyEvent_t		workNotReady;
		CSTAWorkReadyEvent_t		workReady;
		CSTABackInServiceEvent_t	backInService;
		CSTAOutOfServiceEvent_t		outOfService;
		CSTAPrivateStatusEvent_t	privateStatus;
		CSTAMonitorEndedEvent_t  	monitorEnded;
	} u;

} CSTAUnsolicitedEvent;


typedef struct 
{
	InvokeID_t	invokeID;
	union 
	{
		CSTAAlternateCallConfEvent_t		alternateCall;
		CSTAAnswerCallConfEvent_t		answerCall;
		CSTACallCompletionConfEvent_t		callCompletion;
		CSTAClearCallConfEvent_t		clearCall;
		CSTAClearConnectionConfEvent_t    	clearConnection;
		CSTAConferenceCallConfEvent_t		conferenceCall;
		CSTAConsultationCallConfEvent_t		consultationCall;
		CSTADeflectCallConfEvent_t		deflectCall;
		CSTAPickupCallConfEvent_t		pickupCall;
		CSTAGroupPickupCallConfEvent_t		groupPickupCall;
		CSTAHoldCallConfEvent_t			holdCall;
		CSTAMakeCallConfEvent_t			makeCall;
		CSTAMakePredictiveCallConfEvent_t 	makePredictiveCall;
		CSTAQueryMwiConfEvent_t			queryMwi;
		CSTAQueryDndConfEvent_t			queryDnd;
		CSTAQueryFwdConfEvent_t			queryFwd;
		CSTAQueryAgentStateConfEvent_t		queryAgentState;
		CSTAQueryLastNumberConfEvent_t		queryLastNumber;
		CSTAQueryDeviceInfoConfEvent_t		queryDeviceInfo;
		CSTAReconnectCallConfEvent_t		reconnectCall;
		CSTARetrieveCallConfEvent_t		retrieveCall;
		CSTASetMwiConfEvent_t			setMwi;
		CSTASetDndConfEvent_t			setDnd;
		CSTASetFwdConfEvent_t			setFwd;
		CSTASetAgentStateConfEvent_t		setAgentState;
		CSTATransferCallConfEvent_t		transferCall;
		CSTAUniversalFailureConfEvent_t		universalFailure;
		CSTAMonitorConfEvent_t			monitorStart;
		CSTAChangeMonitorFilterConfEvent_t	changeMonitorFilter;
		CSTAMonitorStopConfEvent_t		monitorStop;
		CSTASnapshotDeviceConfEvent_t		snapshotDevice;
		CSTASnapshotCallConfEvent_t		snapshotCall;
		CSTARouteRegisterReqConfEvent_t		routeRegister;
		CSTARouteRegisterCancelConfEvent_t	routeCancel;
		CSTAEscapeSvcConfEvent_t		escapeService;
		CSTASysStatReqConfEvent_t		sysStatReq;
		CSTASysStatStartConfEvent_t		sysStatStart;
		CSTASysStatStopConfEvent_t		sysStatStop;
		CSTAChangeSysStatFilterConfEvent_t	changeSysStatFilter;
		CSTAGetAPICapsConfEvent_t		getAPICaps;
		CSTAGetDeviceListConfEvent_t	getDeviceList;
		CSTAQueryCallMonitorConfEvent_t	queryCallMonitor;
		
	} u;

} CSTAConfirmationEvent;


#define CSTA_MAX_HEAP	1024

typedef struct 
{
	ACSEventHeader_t	eventHeader;
	union 
	{
		ACSUnsolicitedEvent	acsUnsolicited;
		ACSConfirmationEvent	acsConfirmation;
		CSTARequestEvent	cstaRequest;
		CSTAUnsolicitedEvent	cstaUnsolicited;
		CSTAConfirmationEvent	cstaConfirmation;
		CSTAEventReport		cstaEventReport;
	} event;
	char	heap[CSTA_MAX_HEAP];
} CSTAEvent_t;

// function prototypes

#ifdef __cplusplus
extern "C"
{
#endif  

// Basic Call Control Services

TSAPI
cstaAlternateCall (	ACSHandle_t			acsHandle,
					InvokeID_t			invokeID,
					ConnectionID_t	FAR	*activeCall,
					ConnectionID_t	FAR	*otherCall,
					PrivateData_t	FAR	*privateData);


TSAPI
cstaAnswerCall (ACSHandle_t			acsHandle,
				InvokeID_t			invokeID,
				ConnectionID_t	FAR	*alertingCall,
				PrivateData_t	FAR	*privateData);


TSAPI
cstaCallCompletion (ACSHandle_t			acsHandle,
					InvokeID_t			invokeID,
					Feature_t			feature,
					ConnectionID_t	FAR	*call,
					PrivateData_t	FAR	*privateData);


TSAPI
cstaClearCall (	ACSHandle_t			acsHandle,
				InvokeID_t			invokeID,
				ConnectionID_t	FAR	*call,
				PrivateData_t	FAR	*privateData);


TSAPI
cstaClearConnection (	ACSHandle_t			acsHandle,
						InvokeID_t			invokeID,
						ConnectionID_t	FAR	*call,
						PrivateData_t	FAR	*privateData);


TSAPI
cstaConferenceCall (ACSHandle_t			acsHandle,
					InvokeID_t			invokeID,
					ConnectionID_t	FAR	*heldCall,
					ConnectionID_t	FAR	*activeCall,
					PrivateData_t	FAR	*privateData);


TSAPI
cstaConsultationCall (	ACSHandle_t			acsHandle,
						InvokeID_t			invokeID,
						ConnectionID_t	FAR	*activeCall,
						DeviceID_t		FAR	*calledDevice,
						PrivateData_t	FAR	*privateData);


TSAPI
cstaDeflectCall (	ACSHandle_t			acsHandle,
					InvokeID_t			invokeID,
					ConnectionID_t	FAR	*deflectCall,
					DeviceID_t		FAR	*calledDevice,
					PrivateData_t	FAR	*privateData);


TSAPI
cstaGroupPickupCall (	ACSHandle_t			acsHandle,
						InvokeID_t			invokeID,
						ConnectionID_t	FAR	*deflectCall,
						DeviceID_t		FAR	*pickupDevice,
						PrivateData_t	FAR	*privateData);


TSAPI
cstaHoldCall (	ACSHandle_t			acsHandle,
				InvokeID_t			invokeID,
				ConnectionID_t	FAR	*activeCall,
				Boolean				reservation,
				PrivateData_t	FAR	*privateData);


TSAPI
cstaMakeCall (	ACSHandle_t			acsHandle,
				InvokeID_t			invokeID,
				DeviceID_t		FAR	*callingDevice,
				DeviceID_t		FAR	*calledDevice,
				PrivateData_t	FAR	*privateData);


TSAPI
cstaMakePredictiveCall (ACSHandle_t				acsHandle,
						InvokeID_t				invokeID,
						DeviceID_t			FAR	*callingDevice,
						DeviceID_t			FAR	*calledDevice,
						AllocationState_t		allocationState,
						PrivateData_t		FAR	*privateData);


TSAPI
cstaPickupCall (	ACSHandle_t			acsHandle,
					InvokeID_t			invokeID,
					ConnectionID_t	FAR	*deflectCall,
					DeviceID_t		FAR	*calledDevice,
					PrivateData_t	FAR	*privateData);


TSAPI
cstaReconnectCall (	ACSHandle_t			acsHandle,
					InvokeID_t			invokeID,
					ConnectionID_t	FAR	*activeCall,
					ConnectionID_t	FAR	*heldCall,
					PrivateData_t	FAR	*privateData);


TSAPI
cstaRetrieveCall (	ACSHandle_t			acsHandle,
					InvokeID_t			invokeID,
					ConnectionID_t	FAR	*heldCall,
					PrivateData_t	FAR	*privateData);


TSAPI
cstaTransferCall (	ACSHandle_t			acsHandle,
					InvokeID_t			invokeID,
					ConnectionID_t	FAR	*heldCall,
					ConnectionID_t	FAR	*activeCall,
					PrivateData_t	FAR	*privateData);


// Telephony Supplementary Services

TSAPI
cstaSetMsgWaitingInd (	ACSHandle_t			acsHandle,
						InvokeID_t			invokeID,
						DeviceID_t		FAR	*device,
						Boolean				messages,
						PrivateData_t	FAR	*privateData);


TSAPI
cstaSetDoNotDisturb (	ACSHandle_t			acsHandle,
						InvokeID_t			invokeID,
						DeviceID_t		FAR	*device,
						Boolean				doNotDisturb,
						PrivateData_t	FAR	*privateData);


TSAPI
cstaSetForwarding (	ACSHandle_t				acsHandle,
					InvokeID_t				invokeID,
					DeviceID_t			FAR	*device,
					ForwardingType_t		forwardingType,
					Boolean					forwardingOn,
					DeviceID_t			FAR	*forwardingDestination,
					PrivateData_t		FAR	*privateData);


TSAPI
cstaSetAgentState (	ACSHandle_t			acsHandle,
					InvokeID_t			invokeID,
					DeviceID_t		FAR	*device,
					AgentMode_t			agentMode,
					AgentID_t		FAR	*agentID,
					AgentGroup_t	FAR	*agentGroup,
					AgentPassword_t	FAR	*agentPassword,
					PrivateData_t	FAR	*privateData);


TSAPI
cstaQueryMsgWaitingInd (ACSHandle_t			acsHandle,
						InvokeID_t			invokeID,
						DeviceID_t		FAR	*device,
						PrivateData_t	FAR	*privateData);


TSAPI
cstaQueryDoNotDisturb (	ACSHandle_t			acsHandle,
						InvokeID_t			invokeID,
						DeviceID_t		FAR	*device,
						PrivateData_t	FAR	*privateData);


TSAPI
cstaQueryForwarding (	ACSHandle_t			acsHandle,
						InvokeID_t			invokeID,
						DeviceID_t		FAR	*device,
						PrivateData_t	FAR	*privateData);


TSAPI
cstaQueryAgentState (	ACSHandle_t			acsHandle,
						InvokeID_t			invokeID,
						DeviceID_t		FAR	*device,
						PrivateData_t	FAR	*privateData);


TSAPI
cstaQueryLastNumber (	ACSHandle_t			acsHandle,
						InvokeID_t			invokeID,
						DeviceID_t		FAR	*device,
						PrivateData_t	FAR	*privateData);


TSAPI
cstaQueryDeviceInfo (	ACSHandle_t			acsHandle,
						InvokeID_t			invokeID,
						DeviceID_t		FAR	*device,
						PrivateData_t	FAR	*privateData);


// Monitor Services

TSAPI
cstaMonitorDevice (	ACSHandle_t				acsHandle,
					InvokeID_t				invokeID,
					DeviceID_t			FAR	*deviceID,
					CSTAMonitorFilter_t	FAR	*monitorFilter,
					PrivateData_t		FAR	*privateData);


TSAPI
cstaMonitorCall (	ACSHandle_t				acsHandle,
					InvokeID_t				invokeID,
					ConnectionID_t		FAR	*call,
					CSTAMonitorFilter_t	FAR	*monitorFilter,
					PrivateData_t		FAR	*privateData);


TSAPI
cstaMonitorCallsViaDevice (	ACSHandle_t				acsHandle,
							InvokeID_t				invokeID,
							DeviceID_t			FAR	*deviceID,
							CSTAMonitorFilter_t	FAR	*monitorFilter,
							PrivateData_t		FAR	*privateData);


TSAPI
cstaChangeMonitorFilter (	ACSHandle_t					acsHandle,
							InvokeID_t					invokeID,
							CSTAMonitorCrossRefID_t		monitorCrossRefID,
							CSTAMonitorFilter_t		FAR	*filterlist,
							PrivateData_t			FAR	*privateData);


TSAPI
cstaMonitorStop (	ACSHandle_t					acsHandle,
					InvokeID_t					invokeID,
					CSTAMonitorCrossRefID_t		monitorCrossRefID,
					PrivateData_t			FAR	*privateData);

// Snapshot Services

TSAPI
cstaSnapshotCallReq (	ACSHandle_t			acsHandle,
						InvokeID_t			invokeID,
						ConnectionID_t	FAR	*snapshotObj,
						PrivateData_t	FAR	*privateData);


TSAPI
cstaSnapshotDeviceReq (	ACSHandle_t			acsHandle,
						InvokeID_t			invokeID,
						DeviceID_t		FAR	*snapshotObj,
						PrivateData_t	FAR	*privateData);


// Routing Services

TSAPI
cstaRouteRegisterReq (	ACSHandle_t			acsHandle,
						InvokeID_t			invokeID,
						DeviceID_t		FAR	*routingDevice,
						PrivateData_t	FAR	*privateData);


TSAPI
cstaRouteRegisterCancel (	ACSHandle_t				acsHandle,
							InvokeID_t				invokeID,
							RouteRegisterReqID_t	routeRegisterReqID,
							PrivateData_t		FAR	*privateData);


TSAPI
cstaRouteSelect (	ACSHandle_t				acsHandle,
					RouteRegisterReqID_t 	routeRegisterReqID,
					RoutingCrossRefID_t		routingCrossRefID,
					DeviceID_t			FAR	*routeSelected,
					RetryValue_t			remainRetry,
					SetUpValues_t		FAR *setupInformation,
					Boolean					routeUsedReq,
					PrivateData_t		FAR	*privateData);


TSAPI
cstaRouteEnd (	ACSHandle_t					acsHandle,
				RouteRegisterReqID_t		routeRegisterReqID,
				RoutingCrossRefID_t			routingCrossRefID,
				CSTAUniversalFailure_t		errorValue,
				PrivateData_t			FAR	*privateData);


// Escape Services

TSAPI
cstaEscapeService (	ACSHandle_t			acsHandle,
					InvokeID_t			invokeID,
					PrivateData_t	FAR	*privateData);


TSAPI
cstaEscapeServiceConf (	ACSHandle_t					acsHandle,
						InvokeID_t					invokeID,
						CSTAUniversalFailure_t		error,
						PrivateData_t			FAR	*privateData);


TSAPI
cstaSendPrivateEvent (	ACSHandle_t			acsHandle,
						PrivateData_t	FAR	*privateData);


// Maintenance Services

TSAPI
cstaSysStatReq (ACSHandle_t			acsHandle,
				InvokeID_t			invokeID,
				PrivateData_t	FAR	*privateData);


TSAPI
cstaSysStatStart (	ACSHandle_t					acsHandle,
					InvokeID_t					invokeID,
					SystemStatusFilter_t		statusFilter,
					PrivateData_t			FAR	*privateData);


TSAPI
cstaSysStatStop (	ACSHandle_t			acsHandle,
					InvokeID_t			invokeID,
					PrivateData_t	FAR	*privateData);


TSAPI
cstaChangeSysStatFilter (	ACSHandle_t				acsHandle,
							InvokeID_t				invokeID,
							SystemStatusFilter_t	statusFilter,
							PrivateData_t		FAR	*privateData);


TSAPI
cstaSysStatReqConf (ACSHandle_t			acsHandle,
					InvokeID_t			invokeID,
					SystemStatus_t		systemStatus,
					PrivateData_t	FAR	*privateData);


TSAPI
cstaSysStatEvent (	ACSHandle_t			acsHandle,
					SystemStatus_t		systemStatus,
					PrivateData_t	FAR	*privateData);


TSAPI
cstaGetAPICaps (ACSHandle_t acsHandle, InvokeID_t invokeID);
 
 
TSAPI
cstaGetDeviceList (	ACSHandle_t	acsHandle,
					InvokeID_t	invokeID,
				    long		index,
				    CSTALevel_t	level);

					
TSAPI
cstaQueryCallMonitor (ACSHandle_t acsHandle, InvokeID_t invokeID);


#ifdef __cplusplus
}
#endif  

#endif

