/*		AT&T private data templates		*/

/*
	data member of PrivateData_t partitioned into N tagged items

                |<- 1st item->|   |<- 2nd item->|   |<- 3rd item->|
     _______________________________________________________________
    |   |   |   |   |         |   |   |         |   |   |         | 
    |enc| N |tag|len|  value  |tag|len|  value  |tag|len|  value  | ...
    |___|___|___|___|_________|___|___|_________|___|___|_________|_
    | 2 | 2 | 2 |    len*     | 2 |    len*     | 2 |    len*     |

	(*) value is padded to even boundary
	Intel (lo/hi) byte order is used
*/

typedef unsigned char	UINT8;
typedef unsigned short	UINT16;

//	tags for data types

#define	ATT_PRIV_UEC	1	// user entered code
//	others to be defined


//	G3 CSTA user entered code

#define MAX_USER_CODE	24  // current max is 24
#define MAX_VDN			9

typedef struct UserEnteredCode_t
{
	UINT16	size;					// sizeof(UserEnteredCode_t)
			
	UINT8	type;					// type of user code
#define			UE_ANY					'\x00'
#define			UE_LOGIN_DIGITS			'\x02'
#define			UE_CALL_PROMPTER		'\x05'
#define			UE_DATA_BASE_PROVIDED	'\x11'
#define			UE_TONE_DETECTOR		'\x20'

	UINT8	timeout;				// timeout interval 0-63 (not used)
	
	UINT8	indicator;				// collect/collected indication
#define 		UE_COLLECT 	'\x00'		// digits to be collected
#define 		UE_ENTERED	'\x01'		// user entered digits

	char	data[MAX_USER_CODE+1];	// NULL terminated string of digits

	char	collectVDN[MAX_VDN+1];	// NULL terminated string of digits

} UserEnteredCode_t;


// function prototypes

#ifdef __cplusplus
extern "C"
{
#endif  

#if defined _MSDOS || defined __MSDOS__
 #define FPEXPORT	__far __pascal __export
 #ifndef FAR
  #define FAR __far
 #endif
#else
 #define FPEXPORT	/* */
 #ifndef FAR
  #define FAR /* */
 #endif
#endif

void
FPEXPORT
initATTPrivate (PrivateData_t FAR *priv);

void
FPEXPORT
addATTPrivate (UINT16 itemTag, void FAR *itemPtr, PrivateData_t FAR *priv);

void *
FPEXPORT
getATTPrivate (UINT16 tag, PrivateData_t FAR *priv, UINT16 occ);

#ifdef __cplusplus
}
#endif  

        