/* Pre-installation routine for E-Teller */
'@echo off'
'cls'
say 'E-Teller Pre-Installation'
say '~~~~~~~~~~~~~~~~~~~~~~~~~'
say''
say 'This pre-installation routine exists solely to ensure that a user does'
say 'not attempt to run the _install.exe VX-Rexx program without first moving'
say 'vrobj.dll to a location within his/her libpath or, if a copy of vrobj.dll'
say '2.0a already exists, deleting the copy in the current directory.'
say ''

VROBJExists:
say 'Do you already have vrobj.dll 2.0a installed (y/n)?'
parse upper pull answer
if( answer <> 'Y' & answer <> 'N' )then do
   'cls'
   say answer 'is not a valid selection.  Please try again.'
   signal VROBJExists
end
if answer = 'Y' then
   signal BeginInstall
if answer = 'N' then do
   'cls'
   say 'Install VROBJ.DLL'
   say '~~~~~~~~~~~~~~~~~'
   signal InstallVROBJ
do
exit

InstallVROBJ:
say''
say 'On what drive is your config.sys located (enter only a drive letter)?'
parse upper pull answer
if Length( answer ) > 1 then
   answer = Left( answer, 1 )
rc = stream( answer||':\config.sys', 'c', 'query exists' )
if rc = '' then do
   'cls'
   say 'Your config.sys file has not been located in the root of drive 'answer':.'
   say 'Please try again.'
   signal InstallVROBJ
end
config = answer||':\config.sys'
call stream config, 'c', 'close'
call linein config, 1, 0
do forever
   if lines( config ) = 0 then
      leave
   line = linein( config )
   parse var line value '=' string
   value = Translate( value )
   if value = 'LIBPATH' then
      leave
end
call stream config, 'c', 'close'
if( string <> 'STRING' & string <> '' )then
   do
      'cls'
      say 'Your libpath statement is:'
      say ''
      say string
      say ''
      say 'Please enter a path from the libpath where VROBJ.DLL should be located.'
      parse pull answer
      if( Right( answer, 1 ) <> '\' )then
         answer = answer||'\'
      'copy vrobj.dll' answer
      rc = stream( answer||'vrobj.dll', 'c', 'query exists' )
      if rc <> '' then
         signal BeginInstall
      else
         do
            say 'Copy unsuccessful.  Aborting.'
            exit
         end
   end
else
   do
      say 'Libpath statement not found.'
      exit
   end
exit

BeginInstall:
say 'Removing vrobj.dll from current directory.'
'erase vrobj.dll'
say ''
say 'Beginning installation...'
'start _install.exe'
exit
