@echo off
goto args

:help
echo.
echo    Usage: pwpatch file password
echo.
echo            PWPATCH installs patches obtained from The Wollongong Group's
echo            BBS.  PWPATCH saves affected files in .\P_BACKUP.  
echo.
echo            file: Patch File a required parameter that is the name of the
echo            patch file obtained from Wollongong's BBS
echo.
echo            passwd: Password obtained from Wollongong Support to decrypt
echo            the patch.
echo.
echo            To access the BBS, you need a computer, a modem and a 
echo            telecommunications program that supports 8-data bits, no parity,
echo            1 stop bid, and a baud rate up to 38,400.
echo.
echo            Dial 415/965-3601.  When you make the connection, the BBS will
echo            prompt you for the desired service.  Respond with bbs[CR].  At
echo            this point you will be prompted for a USERNAME.  Type your user
echo            name or NEW to create a new account.
echo.
echo            Please call the Product Support Hotline at 415/962-7140 if you
echo            experience any problems with down-loading or using a file.
goto end

REM ********************************************************************
REM * * * * * * Create Patch Area in PathWay Directory * * * * * * * * *
REM ********************************************************************

:args
if "%1" == "" goto help
if "%2" == "" goto help

if exist %1 goto install
echo.
echo    %1 Patch File not found.
echo.
goto end

REM ********************************************************************
REM * * * * * * * * * * Install Patch with Backup  * * * * * * * * * * *
REM ********************************************************************

:install
if not exist tmp_ptch\nul md tmp_ptch
if not exist p_backup\nul md p_backup
cd tmp_ptch

REM copy and execute patch file in directory patch

copy ..\%1 
%1 -s%2

del %1

for %%F in (*.*) do copy ..\%%F ..\p_backup
for %%F in (*.*) do copy %%F ..\%%F
for %%F in (*.*) do del %%F

cd ..
rmdir tmp_ptch

REM ********************************************************************
REM * * * * * * * *  Compare Versions of Existing Files  * * * * * * * *
REM ********************************************************************
echo.
echo Checking versions on your PATHWAY directory
echo.

pwver *.* /c pwver.dat

:end
echo on
