       IDENTIFICATION DIVISION.
       PROGRAM-ID.  MESSAGE-BOX IS INITIAL PROGRAM.
       DATE-WRITTEN.    15-Jul-90 - TDC.
           03-Oct-90 - Add color support (can change values in 
                       INITIALIZE-MESSAGE paragraph.
       REMARKS.
           This program provide message box support.  It can be used
           to communicate a simple message to the user and get standardized
           responses.  This routine simulates the message box style
           used by Presentation Manager and MS Windows, but uses character
           mode terminals.

           The routine is passed a message type, which can be:

               '1'    - Error message
               '2'    - Warning message
               '3'    - Informational message

           It is also passed a parameter that lists the valid responses.  
           Currently supported types:

               '1'    - "Ok" only
               '2'    - "Yes" and "No"
               '3'    - "Ok" and "Cancel"
               '4'    - "Yes", "No" and "Cancel"

           You can also specify the default response by pre-pending the
           default button number to the listed types.  For example,
           type "22" allows a "Yes-No" response with a default value of
           "No".  

           Finally, you can pass one to three message lines (40 characters
           each).  

           The message box displays the messages and gets the user's
           response.  The response value is returned in the response-type
           parameter.  The returned values are listed in the Linkage 
           Section below.
   
       DATA DIVISION.
       WORKING-STORAGE SECTION.
      * Change the following to support other languages
       01  TEXT-LITERALS.
           03  OK-NAME               PIC X(4) VALUE "<Ok>".
           03  YES-NAME              PIC X(5) VALUE "<Yes>".
           03  NO-NAME               PIC X(4) VALUE "<No>".
           03  CANCEL-NAME           PIC X(8) VALUE "<Cancel>".
           03  ERROR-TITLE           PIC X(6) VALUE "Error!".
           03  WARNING-TITLE         PIC X(7) VALUE "Warning".

       77  COUNTER                             PIC 99.
       77  NUM-ARGS                            PIC 99 COMP-1.
       77  BOX-WIDTH                           PIC 99.
       77  BOX-HEIGHT                          PIC 99.
       77  BOX-LINE                            PIC 99.
       77  BOX-COL                             PIC 99.
       77  BOX-TITLE                           PIC X(10).
       77  BOX-HANDLE                          PIC X(10).
       77  BUTTON-COUNT                        PIC 9.
       77  BUTTON-LINE                         PIC 9.
       77  CUR-BUTTON                          PIC 9.

       77  SELECT-COLOR                        PIC 9(4) COMP-1.
       77  OFF-COLOR                           PIC 9(4) COMP-1.
       77  BOX-COLOR                           PIC 9(4) COMP-1.
       77  TEXT-COLOR                          PIC 9(4) COMP-1.

       01  ENTRY                               PIC X.
       01  F-KEY                               PIC 9(3).
           88  AUTO-TERM                       VALUE ZERO.
           88  RETURN-KEY-PRESSED              VALUE 13.
           88  TAB-KEY-PRESSED                 VALUE 9.
           88  LEFT-KEY-PRESSED                VALUE 51.
           88  RIGHT-KEY-PRESSED               VALUE 52.

       01  BUTTONS.
           03  BUTTON-INFO OCCURS 3 TIMES
               INDEXED BY B-NDX.
               05  LOC                         PIC 99.
               05  BSIZE                       PIC 99.
               05  BUTTON                      PIC X(10).

       01  TERM-INFO.
           03  FILLER                          PIC X(10).
           03  FILLER                          PIC X.
               88  HAS-REVERSE                 VALUE "Y".
           03  FILLER                          PIC X(4).
           03  FILLER                          PIC X.
               88  HAS-COLOR                   VALUE "Y".
           03  FILLER                          PIC X.
           03  SCREEN-LINES                    PIC 999.
           03  SCREEN-COLS                     PIC 999.
           03  FILLER                          PIC X.
           03  FILLER                          PIC X.
               88  HAS-MAGIC-COOKIES           VALUE "Y".

       01  SAVE-CURSOR-MODE                    PIC 9(1).
       01  CURSOR-OFF                          PIC X VALUE "2".
       01  CURSOR-ON                           PIC X VALUE "3".


       LINKAGE SECTION.
       01  MESSAGE-TYPE                        PIC 9.
           88  ERROR-TYPE                      VALUE 1.
           88  WARNING-TYPE                    VALUE 2.
           88  INFORMATION-TYPE                VALUE 3.

       01  RESPONSE-TYPE.
           03  DEFAULT-BUTTON                  PIC 9.
               88  DEFAULT-1                   VALUES ZERO, 1.
               88  DEFAULT-2                   VALUE 2.
               88  DEFAULT-3                   VALUE 3.
           03  BUTTON-TYPES                    PIC 9.
               88  OK-TYPE                     VALUE 1.
               88  YES-NO-TYPE                 VALUE 2.
               88  OK-CANCEL-TYPE              VALUE 3.
               88  YES-NO-CANCEL-TYPE          VALUE 4.

       01  RESPONSE REDEFINES RESPONSE-TYPE    PIC 99.
           88  RESPOND-OK                      VALUE 1.
           88  RESPOND-YES                     VALUE 1.
           88  RESPOND-NO                      VALUE 2.
           88  RESPOND-CANCEL                  VALUE 3.

       01  MESSAGE-1                           PIC X(40).
       01  MESSAGE-2                           PIC X(40).
       01  MESSAGE-3                           PIC X(40).


       PROCEDURE DIVISION USING MESSAGE-TYPE, RESPONSE-TYPE, 
                                MESSAGE-1, MESSAGE-2, MESSAGE-3.
       LEVEL-1 SECTION.
       MAIN-LOGIC.
           PERFORM INITIALIZE-MESSAGE.
           PERFORM COMPUTE-BOX-SIZE.
           PERFORM DISPLAY-MESSAGE-BOX.
           MOVE DEFAULT-BUTTON TO CUR-BUTTON.
           IF CUR-BUTTON < 1 OR > 3
               MOVE 1 TO CUR-BUTTON.
           PERFORM GET-BUTTON-PRESS, TEST AFTER, 
                   UNTIL RETURN-KEY-PRESSED.

           EVALUATE TRUE
             WHEN OK-TYPE
                   SET RESPOND-OK TO TRUE
             WHEN YES-NO-TYPE
             WHEN YES-NO-CANCEL-TYPE
                   MOVE CUR-BUTTON TO RESPONSE
             WHEN OK-CANCEL-TYPE
                   IF CUR-BUTTON IS = 2
                       SET RESPOND-CANCEL TO TRUE
                   ELSE
                       SET RESPOND-OK TO TRUE
                   END-IF
           END-EVALUATE.

       MAIN-LOGIC-EXIT.
           CLOSE WINDOW BOX-HANDLE.
           SET ENVIRONMENT "CURSOR-MODE" TO SAVE-CURSOR-MODE.
           CALL "C$KEYMAP" USING "0".
           EXIT PROGRAM.

       LEVEL-2 SECTION.
       GET-BUTTON-PRESS.
           DISPLAY BUTTON( CUR-BUTTON ), 
                   LINE BUTTON-LINE, COLUMN LOC( CUR-BUTTON ),
                   SIZE BSIZE( CUR-BUTTON ), COLOR SELECT-COLOR.

           ADD 1 TO LOC( CUR-BUTTON ) GIVING COUNTER.
           ACCEPT ENTRY, LINE BUTTON-LINE, COLUMN COUNTER, 
                  AUTO, NO ECHO, SAME, UPPER, CONTROL KEY IN F-KEY.
           
           DISPLAY BUTTON( CUR-BUTTON ),
                   LINE BUTTON-LINE, COLUMN LOC( CUR-BUTTON ),
                   SIZE BSIZE( CUR-BUTTON ), COLOR OFF-COLOR.

           EVALUATE TRUE
             WHEN RETURN-KEY-PRESSED OR ( AUTO-TERM AND ENTRY = SPACE )
                   SET RETURN-KEY-PRESSED TO TRUE

             WHEN RIGHT-KEY-PRESSED OR TAB-KEY-PRESSED
                   ADD 1 TO CUR-BUTTON
                   IF CUR-BUTTON > BUTTON-COUNT
                       MOVE 1 TO CUR-BUTTON
                   END-IF

             WHEN LEFT-KEY-PRESSED
                   SUBTRACT 1 FROM CUR-BUTTON
                   IF CUR-BUTTON < 1 
                       MOVE BUTTON-COUNT TO CUR-BUTTON
                   END-IF

             WHEN AUTO-TERM
                   SET B-NDX TO 1
                   SEARCH BUTTON-INFO
                       WHEN BUTTON( B-NDX )( 2:1 ) IS = ENTRY
                            SET CUR-BUTTON TO B-NDX
                            SET RETURN-KEY-PRESSED TO TRUE
                   END-SEARCH
           END-EVALUATE.

       DISPLAY-MESSAGE-BOX.
           IF ERROR-TYPE
               MOVE ERROR-TITLE TO BOX-TITLE
           ELSE IF WARNING-TYPE
               MOVE WARNING-TITLE TO BOX-TITLE
           ELSE
               MOVE SPACES TO BOX-TITLE.

           COMPUTE BOX-LINE = ( SCREEN-LINES - BOX-HEIGHT ) / 2.
           COMPUTE BOX-COL = ( SCREEN-COLS - BOX-WIDTH ) / 2.

           DISPLAY WINDOW, LINE BOX-LINE, COLUMN BOX-COL, 
                   SIZE BOX-WIDTH, LINES BOX-HEIGHT, BOXED,
                   TITLE IS BOX-TITLE, ERASE, NO WRAP
                   COLOR BOX-COLOR, SHADOW,
                   POP-UP AREA IS BOX-HANDLE.

           DISPLAY MESSAGE-1, LINE 2, SIZE BOX-WIDTH, CENTERED,
                   COLOR TEXT-COLOR
           IF NUM-ARGS > 1
               DISPLAY MESSAGE-2, LINE 3, SIZE BOX-WIDTH, CENTERED
                       COLOR TEXT-COLOR
               IF NUM-ARGS > 2
                   DISPLAY MESSAGE-3, LINE 4, SIZE BOX-WIDTH, CENTERED
                           COLOR TEXT-COLOR.

           COMPUTE BUTTON-LINE = BOX-HEIGHT - 1.

           EVALUATE TRUE
             WHEN OK-TYPE
                   MOVE 1 TO BUTTON-COUNT
                   MOVE OK-NAME TO BUTTON(1)
             WHEN YES-NO-TYPE
                   MOVE 2 TO BUTTON-COUNT
                   MOVE YES-NAME TO BUTTON(1)
                   MOVE NO-NAME TO BUTTON(2)
             WHEN OK-CANCEL-TYPE
                   MOVE 2 TO BUTTON-COUNT
                   MOVE OK-NAME TO BUTTON(1)
                   MOVE CANCEL-NAME TO BUTTON(2)
             WHEN YES-NO-CANCEL-TYPE
                   MOVE 3 TO BUTTON-COUNT
                   MOVE YES-NAME TO BUTTON(1)
                   MOVE NO-NAME TO BUTTON(2)
                   MOVE CANCEL-NAME TO BUTTON(3)
           END-EVALUATE.

           EVALUATE BUTTON-COUNT
             WHEN 1
                   MOVE ZERO TO BSIZE(1)
                   INSPECT BUTTON(1) TALLYING BSIZE(1) FOR CHARACTERS
                                    BEFORE SPACE
                   COMPUTE LOC(1) = ( BOX-WIDTH - BSIZE(1) ) / 2 + 1
             WHEN 2
                   MOVE ZERO TO BSIZE(1), BSIZE(2), LOC(1)
                   INSPECT BUTTON(1) TALLYING BSIZE(1) FOR CHARACTERS
                                    BEFORE SPACE
                   ADD BSIZE(1), 3 GIVING LOC(2), COUNTER
                   INSPECT BUTTON(2) TALLYING BSIZE(2) FOR CHARACTERS
                                    BEFORE SPACE
                   ADD BSIZE(2) TO COUNTER
                   COMPUTE COUNTER = ( BOX-WIDTH - COUNTER ) / 2 + 1
                   ADD COUNTER TO LOC(1), LOC(2)
             WHEN 3
                   MOVE ZERO TO BSIZE(1), BSIZE(2), BSIZE(3), LOC(1)
                   INSPECT BUTTON(1) TALLYING BSIZE(1) FOR CHARACTERS
                                    BEFORE SPACE
                   ADD BSIZE(1), 2 GIVING LOC(2)
                   INSPECT BUTTON(2) TALLYING BSIZE(2) FOR CHARACTERS
                                    BEFORE SPACE
                   ADD BSIZE(2), 2, LOC(2) GIVING LOC(3), COUNTER
                   INSPECT BUTTON(3) TALLYING BSIZE(3) FOR CHARACTERS
                                    BEFORE SPACES
                   ADD BSIZE(3) TO COUNTER
                   COMPUTE COUNTER = ( BOX-WIDTH - COUNTER ) / 2 + 1
                   ADD COUNTER TO LOC(1), LOC(2), LOC(3)
           END-EVALUATE.

           DISPLAY BUTTON(1), LINE BUTTON-LINE, COLUMN LOC(1),
                   COLOR OFF-COLOR.
           IF BUTTON-COUNT > 1
               DISPLAY BUTTON(2), LINE BUTTON-LINE, COLUMN LOC(2)
                       COLOR OFF-COLOR
               IF BUTTON-COUNT > 2
                   DISPLAY BUTTON(3), LINE BUTTON-LINE, COLUMN LOC(3)
                           COLOR OFF-COLOR.


       COMPUTE-BOX-SIZE.
           IF MESSAGE-1( 31 : 10 ) IS NOT = SPACES
               MOVE 40 TO BOX-WIDTH
           ELSE IF MESSAGE-1( 21 : 20 ) IS NOT = SPACES
               MOVE 30 TO BOX-WIDTH
           ELSE
               MOVE 20 TO BOX-WIDTH.

           IF NUM-ARGS > 1 
               IF MESSAGE-2( 31 : 10 ) IS NOT = SPACES
                   MOVE 40 TO BOX-WIDTH
               ELSE IF MESSAGE-2( 21 : 20 ) IS NOT = SPACES AND
                                     BOX-WIDTH IS < 30
                   MOVE 30 TO BOX-WIDTH.

           IF NUM-ARGS > 2
               IF MESSAGE-3( 31 : 10 ) IS NOT = SPACES
                   MOVE 40 TO BOX-WIDTH
               ELSE IF MESSAGE-3( 21 : 20 ) IS NOT = SPACES AND
                                     BOX-WIDTH IS < 30
                   MOVE 30 TO BOX-WIDTH.

           ADD 6 TO BOX-WIDTH.
           ADD 4, NUM-ARGS GIVING BOX-HEIGHT.

       INITIALIZE-MESSAGE.
           ACCEPT SAVE-CURSOR-MODE FROM ENVIRONMENT "CURSOR-MODE"
           ACCEPT TERM-INFO FROM TERMINAL-INFO.
           EVALUATE TRUE
             WHEN HAS-COLOR AND HAS-REVERSE
                   MOVE 168 TO BOX-COLOR
                   MOVE 4096 TO TEXT-COLOR
                   MOVE 1024 TO SELECT-COLOR
                   MOVE ZERO TO OFF-COLOR
                   SET ENVIRONMENT "CURSOR-MODE" TO CURSOR-OFF
             WHEN HAS-MAGIC-COOKIES OR NOT HAS-REVERSE
                   MOVE 2048 TO OFF-COLOR
                   MOVE 4096 TO SELECT-COLOR, TEXT-COLOR
                   MOVE ZERO TO BOX-COLOR
                   SET ENVIRONMENT "CURSOR-MODE" TO CURSOR-ON
             WHEN OTHER
                   MOVE 4096 TO TEXT-COLOR
                   MOVE 1024 TO SELECT-COLOR
                   MOVE ZERO TO OFF-COLOR, BOX-COLOR
                   SET ENVIRONMENT "CURSOR-MODE" TO CURSOR-OFF
           END-EVALUATE.

           CALL "C$KEYMAP" USING "1".
           SET ENVIRONMENT "KEYSTROKE" TO "Exception=51 kl",
                           "KEYSTROKE" TO "Exception=52 kr",
                           "KEYSTROKE" TO "Terminate=13 ^M",
                           "KEYSTROKE" TO "Terminate=9  ^I".

           CALL "C$NARG" USING NUM-ARGS.
           SUBTRACT 2 FROM NUM-ARGS.
           IF NUM-ARGS IS = 3 AND MESSAGE-3 IS = SPACES
               MOVE 2 TO NUM-ARGS.
           IF NUM-ARGS IS = 2 AND MESSAGE-2 IS = SPACES
               MOVE 1 TO NUM-ARGS.
