/* sub.h - header file to be included in 'C' subroutines  */

/* This file contains definitions used by the sub.c file.		*/
/* It provides the basic interface structures and definitions.		*/
/* This file is equivalent to the file "rmc85call.h" provided with 	*/
/* Unix versions of RM/COBOL-85 and may be used in place of that file.	*/


/* PROCTABLE is a structure that relates a CALL name to its 'C' routine	*/

struct	PROCTABLE {
	char	*name;			/* subroutine name */
	int	(*routine)();		/* pointer to function to call */
};


struct	DIRECTTABLE {
	char	*name;			/* subroutine name */
	int	(*routine)();		/* pointer to routine */
	short	return_type;		/* routine's return type */
};

struct	FORTRANTABLE {
	char	*name;			/* subroutine name */
	int	(*routine)();		/* pointer to routine */
	short	return_type;		/* routine's return type */
};

/* The following are valid values for "return_type" */

#define	C_int		0
#define	C_unsigned	1
#define	C_short		2
#define	C_char		3
#define	C_long		4
#define	C_pointer	5
#define	C_void		6

#define	FUNC	(int(*)())	/* useful cast for DIRECTTABLE entries */


/* EXTRNTABLE is a structure that relates external 'C' variables to 	*/
/* their COBOL external names  */

struct	EXTRNTABLE {
	char	*name;			/* COBOL data name */
	char	*addr;			/* address of data item */
};

/* COMMONTABLE is a structure that relates FORTRAN COMMON to 	*/
/* their COBOL external names  */

struct	COMMONTABLE {
	char	*name;			/* COBOL data name */
	char	*addr;			/* address of data item */
};


/* ARGUMENT_ENTRY is a structure that is passed to the 'C' routine for	*/
/* each USING argument.  It defines the layout of that argument. 	*/

struct	ARGUMENT_ENTRY {
	char	*a_address;		/* pointer to actual data */
	long	a_length;		/* size of data item (in bytes) */
	short	a_type;			/* COBOL data type, see below */
	char	a_digits;		/* # of digits for numeric items */
	char	a_scale;		/* implied decimal point offset */
	char	*a_picture;		/* unused - always NULL */
};

typedef	struct ARGUMENT_ENTRY	Argument;

#define	a_size(arg)	(unsigned) (arg).a_length
#define	Scale(s)	( ((s) & 0x80) ? ( (-1 << 8) | (s) ) : (s) )


/* The "a_type" value can be one of the following.  */

#define	NumEdited	0	/* Numeric edited */
#define	NumUnsigned	1	/* Unsigned numeric */
#define	NumSignSep	2	/* Signed numeric (trailing separate) */
#define	NumSigned	3	/* Signed numeric (trailing combined) */
#define	NumSepLead	4	/* Signed numeric (leading separate) */
#define	NumLeading	5	/* Signed numeric (leading combined) */
#define	CompSigned	6	/* Signed computational */
#define	CompUnsigned	7	/* Unsigned computational */
#define	PackedPositive	8	/* Positive packed-decimal */
#define	PackedSigned	9	/* Signed packed-decimal */
#define	PackedUnsigned	10	/* Computational-6 */
#define	BinarySigned	11	/* Signed binary */
#define	BinaryUnsigned	12	/* Unsigned binary */
#define	NativeSigned	13	/* Signed native-order binary */
#define	NativeUnsigned	14	/* Unsigned native-order binary */
#define	Alphanum	16	/* Alphanumeric */
#define	JustAN		17	/* Alphanumeric (justified) */
#define	Alphabetic	18	/* Alphabetic */
#define	JustAlpha	19	/* Alphabetic (justified) */
#define	AlphaEdited	20	/* Alphanumeric Edited */
#define	Group		22	/* Group */

#define	Numeric(x)	( (x) > NumEdited && (x) < Alphanum )


/* The following can be used as return codes from the 'C' routines */

#define	Okay		0	/* routine found - no errors */
#define	Halt		1	/* routine requests STOP RUN */
#define	NotFound	-1	/* routine not found, continue searching */


/* The following definitions are provided for RM/COBOL-85 compatibility */

#define	RM_NSE		NumEdited
#define	RM_NSU		NumUnsigned
#define	RM_NTS		NumSignSep
#define	RM_NTC		NumSigned
#define	RM_NLS		NumSepLead
#define	RM_NLC		NumLeading
#define	RM_NCS		CompSigned
#define	RM_NCU		CompUnsigned
#define	RM_NPP		PackedPositive
#define	RM_NPS		PackedSigned
#define	RM_NPU		PackedUnsigned
#define	RM_NBS		BinarySigned
#define	RM_NBU		BinaryUnsigned
#define	RM_ANS		Alphanum
#define	RM_ANSR		JustAN
#define	RM_ABS		Alphabetic
#define	RM_ABSR		JustAlpha
#define	RM_ANSE		AlphaEdited
#define	RM_ABSE		21		/* Unused */
#define	RM_GRPF		Group

#define	RM_FND		Okay
#define	RM_STOP		Halt
#define	RM_NFND		NotFound


/* The following two routines are used to set the terminal state to its	*/
/* default operating state (resetunit) and to the state it needs to be	*/
/* in to run ACUCOBOL (setunit).  */

#define	setunit()	w_set_term()
#define	resetunit()	w_reset_term()


/* Declare the standard return value "return-code". */

extern	long		return_code;

/* */
