/* This routine provides an interface to C routines */

#include <stdio.h>
#include "sub.h"


/* Include the direct 'C' interface */

#include "direct.c"


/* Include the RM/COBOL-85 compatible 'C' interface */

#include "sub85.c"


/* Include runtime configuration file */

#include "config85.c"


#ifdef	FORTRAN
/* Include the direct FORTRAN interface */

#include "fortran.c"
#endif



/* The "sub" function is executed by each COBOL CALL before searching	*/
/* for the called file.  This routine can intercept certain calls to 	*/
/* be handled by C routines.						*/

/* The "sub" function, receives two parameters: an argument count	*/
/* and a vector of passed parameters, just like the C routine "main".	*/
/* The first parameter is always a pointer to the name being called.	*/
/* The remaining parameters are pointers to each USING parameter.	*/
/* Each parameter is passed as an address of the physical data area	*/
/* the variable occupies, it is up to the C routine to know its format.	*/

/* The routine can return a 0 if it handled the particular CALL, the	*/
/* runtime system will consider the CALL to have been completed.	*/
/* It should return -1 if it doesn't handle the CALL.  The runtime	*/
/* system will continue its searching algorithm.  Finally, any positive	*/
/* return will be treated as an error and cause a STOP RUN to be	*/
/* performed.								*/

int
sub( argc, argv )
int	argc;
char	*argv[];
{
	/* Sample 'SYSTEM' call.  Note that this is redundant because	*/
	/* of the other 'SYSTEM' sample in sub85.c.  For this reason,	*/
	/* it is commented out here.  */
#if 0
	if ( strcmp( argv[0], "SYSTEM" ) == 0 ) {
		w_reset_term();
		system( argv[1] );
		w_set_term();
		return Okay;
        }
#endif
	return NotFound;

}   /* sub */


/* exam_args is called immediately upon startup and is passed the 	*/
/* command line arguments that were passed to Acurun.  This can be used	*/
/* to examine the arguments for special values.  Return 0 for default	*/
/* handling by Acurun, -1 to halt or 1 to cause Acurun to ignore 	*/
/* errors in the command line arguments.  This last case should be used	*/
/* if you introduce new arguments that Acurun can't understand.  Note	*/
/* that arguments used by Acurun cannot have their meaning changed.	*/
/* It is also not possible to supply arguments of the form "-f arg" 	*/
/* because Acurun will interpert "arg" to be the name of the program to	*/
/* run.  You can, however, put additional arguments after the program	*/
/* name.  */

int
exam_args( argc, argv )
int	argc;
char	*argv[];
{
	return 0;
}


/* startup is called after initialization but before the main program	*/
/* is loaded.  It can return 0 to continue, or anything else to cause	*/
/* a halt.  It is passed the name of the program to load.  */

int
Startup( pgm_name )
char	*pgm_name;
{
	return 0;
}


/* shutdown is called after all files are closed but before the final	*/
/* halt of the program.  It is passed 0 if this is a normal STOP RUN,	*/
/* 1 if this is due to an error.  */

void
Shutdown( error_halt )
int	error_halt;
{
	return;
}
