/* filetbl - table of available file systems */

/* Copyright notice: copyright (c) 1991 Acucobol, Inc. */

/* This file gets modified to indicate which host file system(s) are 	*/
/* being used to manage indexed files.  Selecting any file system other	*/
/* than Vision (or RMS for VAX systems) requires the appropriate file	*/
/* system interface from Acucobol.  Instructions are provided with 	*/
/* those interfaces on how to use this file.  */

#include <stdio.h>

#define	USE_VISION	1
#define	USE_RMS		0
#define	USE_CISAM	0
#define	USE_MINISAM	0
#define	USE_BTRIEVE	0
#define	USE_INFORMIX	0
#define	USE_ISAMPLUS	0

typedef	long		DISPATCH_TBL;
typedef	DISPATCH_TBL	*TBLPTR;

typedef	struct _tbl_ent {
	TBLPTR		dispatch;
	char		name[6];
} TABLE_ENTRY;

extern	DISPATCH_TBL	v3_dispatch, ci_dispatch, ms_dispatch, bt_dispatch;
extern	DISPATCH_TBL	rms_dispatch, ifx_dispatch, ip_dispatch;

TABLE_ENTRY	file_table[] = {
#if USE_VISION
		&v3_dispatch,	"VISIO",
#endif
#if USE_RMS
		&rms_dispatch,	"RMS",
#endif
#if USE_CISAM
		&ci_dispatch,	"C-ISA",
#endif
#if USE_MINISAM
		&ms_dispatch,	"MINIS",
#endif
#if USE_BTRIEVE
		&bt_dispatch,	"BTRIE",
#endif
#if USE_INFORMIX
		&ifx_dispatch,	"INFOR",
#endif
#if USE_ISAMPLUS
		&ip_dispatch,	"ISAMP",
#endif
		NULL,		"\0"
		};

short	num_file_systems = ( sizeof(file_table) / sizeof(TABLE_ENTRY) ) - 1;

/* */
