#include "ipcerr.h"

#ifdef __cplusplus
extern "C" {            /* Assume C declarations for C++ */
#endif  /* __cplusplus */

/*-----------------------------------------------------------------
| windows defininition
|------------------------------------------------------------------*/
#if !defined(_INC_WINDOWS)
typedef struct
{
	int left, top, right, bottom;
} RECT, far * LPRECT;

typedef struct
{
	int x, y;
} POINT, far * LPPOINT;
#endif	/* _INC_WINDOWS */

typedef short _far * LPSHORT;
typedef float _far * LPFLOAT;

/*-----------------------------------------------------------------
| HIL definitions
|------------------------------------------------------------------*/
#if !defined(_INC_HIL)
#define IMC_BILEVEL 				0
#define IMC_GRAY					1
#define IMC_PALETTE 				2
#define IMC_RGB 					3
#define IMC_GRAY12					4
#define IMC_FLOAT					5

#define OR_LEFTRIGHT				1
#define OR_UPDOWN					2
#define OR_TRANSPOSE				3
#define OR_ROTATE90 				4
#define OR_ROTATE270				5
#define OR_ROTATE180				6

#define RA_TOPLEFT					1
#define RA_TOP						2
#define RA_TOPRIGHT 				3
#define RA_LEFT 					4
#define RA_CENTER					5
#define RA_RIGHT					6
#define RA_BOTTOMLEFT				7
#define RA_BOTTOM					8
#define RA_BOTTOMRIGHT				9

#define EQ_BESTFIT					0
#define EQ_LINEAR					1
#define EQ_BELL 					2
#define EQ_LOGARITHMIC				3
#define EQ_EXPONENTIAL				4

#define IFFCOMP_NONE				0
#define IFFCOMP_DEFAULT 			1
#define IFFCOMP_RLE 				2
#define IFFCOMP_CCITT1D 			3
#define IFFCOMP_CCITTG3 			4
#define IFFCOMP_CCITTG4 			5
#define IFFCOMP_LZW 				6
#define IFFCOMP_LZWHPRED			7
#define IFFCOMP_JPEG				8

#define IFFCL_BILEVEL				0
#define IFFCL_GRAY					1
#define IFFCL_PALETTE				2
#define IFFCL_RGB					3
#define IFFCL_RGBPLANAR 			4
#define IFFCL_RGBA					5
#define IFFCL_RGBAPLANAR			6

#endif	/* _INC_HIL */

/*-----------------------------------------------------------------
| HAIL definitions
|------------------------------------------------------------------*/
#if !defined(_INC_HAIL)

#define CM_RGB						0
#define CM_HSI						1
#define CM_HSV						2
#define CM_YIQ						3

#define BLBM_AREA	    0
#define BLBM_ASPECT	    1
#define BLBM_BOX_AREA	    2
#define BLBM_BOX_XY	    3
#define BLBM_CENTRX	    4
#define BLBM_CENTRY	    5
#define BLBM_DENSITY	    6
#define BLBM_DIRECTION	    7
#define BLBM_HOLEAREA	    8
#define BLBM_HOLEAREARATIO  9
#define BLBM_MAJORAX	    10
#define BLBM_MINORAX	    11
#define BLBM_MAXFERRET	    12
#define BLBM_MINFERRET	    13
#define BLBM_MEANFERRET     14
#define BLBM_MAXRADIUS	    15
#define BLBM_MINRADIUS	    16
#define BLBM_NUMHOLES	    17
#define BLBM_PERIMETER	    18
#define BLBM_RADIUSRATIO    19
#define BLBM_ROUNDNESS	    20
#define BLBM_CLUSTER	    21
#define BLBM_RED				22
#define BLBM_GREEN			23
#define BLBM_BLUE				24
#define BLBM_PERAREA			25

#define OPA_ADD 					0
#define OPA_SUB 					1
#define OPA_DIFF					2
#define OPA_MULT					3
#define OPA_DIV 					4
#define OPA_AVG 					5
#define OPA_MAX 					6
#define OPA_MIN 					7

#define OPL_AND 					0
#define OPL_OR						1
#define OPL_XOR 					2
#define OPL_NAND					3
#define OPL_NOR 					4
#define OPL_NOT                                         5
#define OPL_COPY                                        6

#define MORPHO_2x2SQUARE			0
#define MORPHO_3x1ROW				1
#define MORPHO_1x3COLUMN			2
#define MORPHO_3x3CROSS 			3
#define MORPHO_5x5OCTAGON			4
#define MORPHO_CUSTOM				5

#define FFT_NOTCH					0x0000
#define FFT_PHASE					0x0001
#define FFT_SPECTRUM				0x0002
#define FFT_HANNING 				0x1000
#endif	/* _INC_HAIL */

#define MORPHO_7x7OCTAGON 6
#define MORPHO_11x11OCTAGON 7

#define FFT_SOURCE	-1
#define FFT_NEWIMAGE -2

/*-----------------------------------------------------------------
| IPWIN definitions
|------------------------------------------------------------------*/
#define COLORMODEL					100
#define AUTOUPDATE					102
#define SCAL						103
#define ICAL						104
#define ACCUMULATE					105
#define LINETYPE					106
#define BIN 						107
#define BRIGHTNESS					108
#define CONTRAST					109
#define GAMMA						110
#define STATISTICS					111
#define ORIGIN						112
#define GRID						113
#define REFERENCE					114
#define FREEZE						115
#define CURVE						116
#define UNIT						117
#define CHANNEL					118
#define CHANNEL1					120
#define CHANNEL2					121
#define CHANNEL3					122


#define BLOB_OUTLINEMODE			0
#define BLOB_OUTLINECOLOR			1
#define BLOB_LABELMODE				2
#define BLOB_LABELCOLOR 			3
#define BLOB_SMOOTHING				4
#define BLOB_MINAREA				5
#define BLOB_FILLHOLES				6
#define BLOB_BRIGHTOBJ				8
#define BLOB_AUTORANGE				9
#define BLOB_MEASUREOBJECTS 		10
#define BLOB_FILTEROBJECTS			11
#define BLOB_ADDCOUNT				12
#define BLOB_CLEANBORDER			13

#define CM							0
#define INCHES						1
#define PIXELS						2

#define SEG_SELNEW					0
#define SEG_SELADD					1
#define SEG_SELSUBTRACT 			2

#define MASK_BILEVELNEW 			0
#define MASK_FOREGROUND 			1
#define MASK_BACKGROUND 			2
#define MASK_BILEVELINPLACE 		3

#define FILLCOLOR					0
#define FILLHUE 					1
#define FILLTINT					2
#define FILLPATTERN 				3
#define FILLTEXTURE 				4

#define CLRFORE 					0
#define CLRBACK 					1
#define CLRWHITE					2
#define CLRBLACK					3

#define FRAME_NONE					0
#define FRAME_RECTANGLE 			1
#define FRAME_ELLIPSE				2
#define FRAME_IRREGULAR 			3

#define THICKNORMAL				0
#define THICKHORZ					1
#define THICKVERT					2
#define THICKAVG					3
#define THICKSTDDEV				4

#define INF_TITLE					0
#define INF_ARTIST					1
#define INF_DATE					2
#define INF_DESCRIPTION 			3
#define INF_DPIX					4
#define INF_DPIY					5

#define LUT_BRIGHTNESS				0
#define LUT_CONTRAST				1
#define LUT_GAMMA					2
#define LUT_HISHAD					3
#define LUT_4TONES					4
#define LUT_8TONES					5
#define LUT_FREEFORM				6
#define LUT_ALL					7

#define MEAS_STATS					0
#define MEAS_DISPCOLOR				1
#define MEAS_LABELCOLOR 			2
#define MEAS_THICKMODE				3
#define MEAS_LENGTH 				4
#define MEAS_AREA					5
#define MEAS_ANGLE					6
#define MEAS_TRACE					7
#define MEAS_THICK					8
#define MEAS_TAG						-2
#define MEAS_ALL						-1


#define AOIDELETE 	0
#define AOIADD			1
#define AOISET 		2
#define AOISHOWDLG	3
#define AOIHIDEDLG	4
#define AOILOAD		5
#define AOISAVE		6

#define IPCFUNC 	IPCERROR WINAPI _export


#define DOCSEL_NEXTID	-1
#define DOCSEL_PREVID	-2
#define DOCSEL_ACTIVE	-3

/* IpAppArrange() */
#define DOCS_CASCADE		0
#define DOCS_TILE			1
#define DOCS_OVERLAP		2

/* IpAcqSnap() */
#define ACQ_NEW -1
#define ACQ_CURRENT -2

/* IpAppRun() */
#define RUN_NORMAL	 5		/* SW_SHOW */
#define RUN_MINIMIZED 2		/* SW_SHOWMINIMIZED */
#define RUN_MAXIMIZED 3		/* SW_SHOWMAXIMIZED */
#define RUN_AUTOCLOSE 1
#define RUN_MODAL 2

/* IpHstSave(), IpProfSave(), IpBlbSave...(), ... */
#define S_APPEND	1
#define S_STATS	2
#define S_DATA		4
#define S_RANGE	8
#define S_CLIPBOARD 16
#define S_HEADER	256
#define S_LEGEND	512
#define S_X_AXIS	1024

/* IpAppMenuSelect() */
#define MENU_ID 		1
#define MENU_NAME 	2
#define MENU_COORD	4
#define MENU_DLL		8

/* IpWsLoadRes() */
#define LOAD_PROMPT	-1
#define LOAD_SMALLEST -3

/* IpPrtSize() */
#define PRT_ACTUAL 1
#define PRT_FIT 2
#define PRT_DISTORT 3

/* IpAppGet() */
#define GETACTDOC 1 
#define GETACTWND 2
#define GETACTVRI 3
#define GETAPPWND   4

/* IpBlbGet() */
#define GETNUMOBJ 1

/* IpWsCreateFromVri() */
#define VRI_SHARE 0
#define VRI_COPY 1
#define VRI_NODELETE 2

/* IpMacroStop() */
#define MS_MODAL 		0x0001	
#define MS_YESNO 		0x0010
#define MS_OKCAN 		0x0020
#define MS_YESNOCAN 	0x0040
#define MS_STOP		0x0100
#define MS_EXCLAM		0x0200
#define MS_QUEST		0x0400
#define MS_DEF2		0x0800
#define MS_DEF3		0x1000

/*-----------------------------------------------------------------
| Pre-defined variables
|------------------------------------------------------------------*/
extern	RECT	ipRect;
extern	POINT	Pts[2048];
extern	short	Lut[256];
extern	float	ipBins[16];
extern	short	ipClassifiers[3];
extern	float	ipICal[256 * 2];
extern	short	ipHalfTypes[7];
extern	short	ipHalfScreens[7];
extern	short ret;


IPCFUNC IpEscape(LPSTR LibName, short LoadMode, short sParam, LPSTR szParam);

/*-----------------------------------------------------------------
| Video acquisition
|------------------------------------------------------------------*/
IPCFUNC IpAcqAverage(short Frames, short Divider);
IPCFUNC IpAcqSnap(short destVri);
IPCFUNC IpAcqTimed(LPSTR Dir, LPSTR Prefix, short StartNumber, short Frames, long Interval);

/*-----------------------------------------------------------------
| Aoi manager functions
|------------------------------------------------------------------*/
IPCFUNC IpAoiCreateBox(LPRECT ipRect);
IPCFUNC IpAoiCreateEllipse(LPRECT ipRect);
IPCFUNC IpAoiCreateIrregular(LPPOINT ipAoiPoint, short NumPoints);
IPCFUNC IpAoiShow(short FrameType);
IPCFUNC IpAoiManager(short FuncID, LPSTR Name);
IPCFUNC IpAoiChangeName(LPSTR oldName, LPSTR newName);
IPCFUNC IpAoiMove(short deltax, short deltay);

/*-----------------------------------------------------------------
| Application functions
|------------------------------------------------------------------*/
IPCFUNC IpAppArrange(short mode);
IPCFUNC IpAppCloseAll();
IPCFUNC IpAppExit();
IPCFUNC IpAppMaximize();
IPCFUNC IpAppMinimize();
IPCFUNC IpAppMove(short x, short y);
IPCFUNC IpAppRestore();
IPCFUNC IpAppSelectDoc(short DocId);
IPCFUNC IpAppSize(short Width, short Height);
IPCFUNC IpAppUpdateDoc(short DocId);
IPCFUNC IpAppHide(short hide);
IPCFUNC IpAppRun(LPSTR CommandLine, short mode, short AutoClose);
IPCFUNC IpAppMenuSelect(short Id1, short Id2, LPSTR ItemName, short mode);
IPCFUNC IpAppGet(short Command, short wParam, void far *lpParam);

/*-----------------------------------------------------------------
| Blob manager functions		BLOBDLG.DLL
|------------------------------------------------------------------*/
IPCFUNC IpBlbCount();
IPCFUNC IpBlbDelete();
IPCFUNC IpBlbEnableMeas(short MeasurementType, short bEnable);
IPCFUNC IpBlbLoadOutline(LPSTR OutlineFile);
IPCFUNC IpBlbLoadSetting(LPSTR SettingFile);
IPCFUNC IpBlbSaveData(LPSTR DataFile, short append);
IPCFUNC IpBlbSaveOutline(LPSTR OutlineFile);
IPCFUNC IpBlbSaveSetting(LPSTR SettingFile);
IPCFUNC IpBlbSetAttr(short Attrib, short Value);
IPCFUNC IpBlbSetRange(short Start, short End);
IPCFUNC IpBlbShow(short bShow);
IPCFUNC IpBlbShowAutoClass(LPSHORT ipClassifiers, short NumMeas, short NumClasses, short bIterate, short bShow);
IPCFUNC IpBlbShowCluster(short bShow);
IPCFUNC IpBlbShowData(short bShow);
IPCFUNC IpBlbShowHistogram(short Measure, short Bins, short bShow);
IPCFUNC IpBlbShowObjectWindow(short bShow);
IPCFUNC IpBlbShowScattergram(short Measure1, short Measure2, short bShow);
IPCFUNC IpBlbShowSingleClass(short NumMeasurements, LPFLOAT ipBins, short NumClasses, short bShow);
IPCFUNC IpBlbShowStatistics(short bShow);
IPCFUNC IpBlbSplitObjects(short bWatershed);
IPCFUNC IpBlbUpdate(short bRedrawImage);
IPCFUNC IpBlbRemoveHoles(void);
IPCFUNC IpBlbSmoothObjects(short smoothing);
IPCFUNC IpBlbSavePopDensities(LPSTR DataFile, short append);
IPCFUNC IpBlbSaveClasses(LPSTR DataFile, short append);
IPCFUNC IpBlbShowPopDens(LPSTR OutlineFile, short bShow);
IPCFUNC IpBlbMeasure(void);
IPCFUNC IpBlbFilter(void);
IPCFUNC IpBlbSetFilterRange(short MeasurementType, float min, float max);
IPCFUNC IpBlbGet(short Command, short wParam, void far *lpParam);

/*-----------------------------------------------------------------
| calibration functions
|------------------------------------------------------------------*/
IPCFUNC IpCalLoad(LPSTR FileName);
IPCFUNC IpCalSave(LPSTR FileName);

IPCFUNC IpICalCreate();
IPCFUNC IpICalDestroy();
IPCFUNC IpICalMove(short x, short y);
IPCFUNC IpICalReset();
IPCFUNC IpICalSelect(LPSTR szICal);
IPCFUNC IpICalSetName(LPSTR szICal);
IPCFUNC IpICalSetOptDens(float BlackLevel, float IncidentLevel);
IPCFUNC IpICalSetPoints(LPFLOAT ipICalPoints, short NumPoints, short fitmode);
IPCFUNC IpICalSetSamples(short NumSamples);
IPCFUNC IpICalSetUnitName(LPSTR UnitName);
IPCFUNC IpICalShow(short bShow);
IPCFUNC IpICalShowFormat(short bOptDens);

IPCFUNC IpSCalCreate();
IPCFUNC IpSCalDestroy();
IPCFUNC IpSCalMove(short x, short y);
IPCFUNC IpSCalReset();
IPCFUNC IpSCalSelect(LPSTR szSCal);
IPCFUNC IpSCalSetAngle(float Angle);
IPCFUNC IpSCalSetAspect(float AspectRatio);
IPCFUNC IpSCalSetName(LPSTR szSCal);
IPCFUNC IpSCalSetOrigin(float x, float y);
IPCFUNC IpSCalSetUnit(float x, float y);
IPCFUNC IpSCalSetUnitName(LPSTR UnitName);
IPCFUNC IpSCalShow(short bShow);

/*-----------------------------------------------------------------
| Screen capture
|------------------------------------------------------------------*/
IPCFUNC IpCapArea(LPRECT ipRect, short bCursor);
IPCFUNC IpCapFile(LPSTR FileFormat, LPSTR Directory, LPSTR Prefix, short Number);
IPCFUNC IpCapHotKey(LPSTR KeyName, short bShift, short bCtrl, short bAlt);
IPCFUNC IpCapWindow(LPSTR Title, short bClientOnly, short bCursor);

/*-----------------------------------------------------------------
| COLORDLG.DLL - Color Transformation Functions
|------------------------------------------------------------------*/
IPCFUNC IpCmChannelExtract(short cmColor, short cmComp, short Channel);
IPCFUNC IpCmChannelMerge(short WsId, short cmColor, short Channel);
IPCFUNC IpCmTransform(short cmOut, short cmIn, short bNewImage);

/*-----------------------------------------------------------------
| Document window functions
|------------------------------------------------------------------*/
IPCFUNC IpDocClose();
IPCFUNC IpDocMaximize();
IPCFUNC IpDocMinimize();
IPCFUNC IpDocMove(short x, short y);
IPCFUNC IpDocRestore();
IPCFUNC IpDocSize(short Width, short Height);

/*-----------------------------------------------------------------
| FFTDLG.DLL - Fast Fourier Transform functions
|------------------------------------------------------------------*/
IPCFUNC IpFftForward(short DisplayType, short bFullFft);
IPCFUNC IpFftHiPass(short Type, short Transition, short PreserveNil);
IPCFUNC IpFftInverse(short WsId, short PreserveData);
IPCFUNC IpFftLoad(LPSTR FileName);
IPCFUNC IpFftLoPass(short Type, short Transition);
IPCFUNC IpFftSave(LPSTR FileName);
IPCFUNC IpFftSpikeCut(short Type, short Transition, short Symmetrical);
IPCFUNC IpFftSpikeBoost(short Type, short Transition, short Symmetrical);
IPCFUNC IpFftShow(short bShow);

/*-----------------------------------------------------------------
| FILTRDLG.DLL - Spatial filtering
|------------------------------------------------------------------*/
IPCFUNC IpFltClose(short Shape, short Passes);
IPCFUNC IpFltConvolveKernel(LPSTR KernelName, short Strength, short Passes);
IPCFUNC IpFltDilate(short Shape, short Passes);
IPCFUNC IpFltErode(short Shape, short Passes);
IPCFUNC IpFltExtractBkgnd(short BrightOnDark, short ObjectSize);
IPCFUNC IpFltFlatten(short BrightOnDark, short ObjectSize);
IPCFUNC IpFltHiPass(short Size, short Strength, short Passes);
IPCFUNC IpFltLaplacian(short Size, short Strength, short Passes);
IPCFUNC IpFltLoPass(short Size, short Strength, short Passes);
IPCFUNC IpFltMedian(short Size, short Passes);
IPCFUNC IpFltOpen(short Shape, short Passes);
IPCFUNC IpFltPhase();
IPCFUNC IpFltRoberts();
IPCFUNC IpFltSharpen(short Size, short Strength, short Passes);
IPCFUNC IpFltSobel();
IPCFUNC IpFltThin(short Threshold);
IPCFUNC IpFltWatershed(short Threshold);
IPCFUNC IpFltShow(short bShow);

/*-----------------------------------------------------------------
| Gallery
|------------------------------------------------------------------*/
IPCFUNC IpGalAdd(LPSTR FileName);
IPCFUNC IpGalChangeDescription(short DescriptionType, LPSTR Description);
IPCFUNC IpGalDelete(LPSTR GalleryName);
IPCFUNC IpGalGetActive(LPSTR GalleryName);
IPCFUNC IpGalNew(LPSTR FileName);
IPCFUNC IpGalOpen(LPSTR FileName);
IPCFUNC IpGalOpenPhotoCD(LPSTR DriveLetter, LPSTR GalleryName, short Resolution);
IPCFUNC IpGalRemove(short bFromDisk);
IPCFUNC IpGalSetActive(short GalId);
IPCFUNC IpGalShow(short bShow);
IPCFUNC IpGalSort(short bByName, short bAscending);
IPCFUNC IpGalTag(short SlotNumber, short bTag);
IPCFUNC IpGalUpdate();
IPCFUNC IpGalImageOpen(short imageId);
IPCFUNC IpGalClose(void);

/*-----------------------------------------------------------------
| HISTO.DLL - histogram functions
|------------------------------------------------------------------*/
IPCFUNC IpHstEqualize(short Method);
IPCFUNC IpHstCreate();
IPCFUNC IpHstDestroy();
IPCFUNC IpHstMaximize();
IPCFUNC IpHstMinimize();
IPCFUNC IpHstMove(short x, short y);
IPCFUNC IpHstRestore();
IPCFUNC IpHstSave(LPSTR FileName, short bAppend);
IPCFUNC IpHstScale(short bVert, short bAuto, float From, float End);
IPCFUNC IpHstSelect(short HstId);
IPCFUNC IpHstSetAttr(short AttrType, short AttrValue);
IPCFUNC IpHstSize(short cx, short cy);
IPCFUNC IpHstUpdate();
IPCFUNC IpHstGet(short Command, short wParam, void far *lpParam);

/*-----------------------------------------------------------------
|	Lookup Table
|------------------------------------------------------------------*/
IPCFUNC IpLutApply();
IPCFUNC IpLutBinarize(short MinRange, short MaxRange, short WhiteOnBlack);
IPCFUNC IpLutLoad(LPSTR FileName);
IPCFUNC IpLutReset(short Channel, short Type);
IPCFUNC IpLutSave(LPSTR FileName, LPSTR Description);
IPCFUNC IpLutSetAttr(short AttrType, short AttrValue);
IPCFUNC IpLutSetControl(short ControlType, LPSHORT ipLutControls, short Count);
IPCFUNC IpLutShow(short Show);
IPCFUNC IpLutStretch(float in1, float in2, float out1, float out2, short WrapAround);


/*-----------------------------------------------------------------
| Measurements
|------------------------------------------------------------------*/
IPCFUNC IpMeasAttr(short bAttr, short Value);
IPCFUNC IpMeasDelete(short bMeasurement);
IPCFUNC IpMeasLoadOutline(LPSTR OutlineFile);
IPCFUNC IpMeasMaximize();
IPCFUNC IpMeasMinimize();
IPCFUNC IpMeasMove(short x, short y);
IPCFUNC IpMeasRestore();
IPCFUNC IpMeasSaveData(LPSTR DataFile, short saveMode);
IPCFUNC IpMeasSaveOutline(LPSTR OutlineFile);
IPCFUNC IpMeasShow(short bShow);
IPCFUNC IpMeasSize(short cx, short cy);
IPCFUNC IpMeasTool(short tool);
IPCFUNC IpMeasTag(short Id, short OnOff);

/*-----------------------------------------------------------------
| OPSDLG.DLL - Arithmetics and logical operations
|------------------------------------------------------------------*/
IPCFUNC IpOpBkgndCorrect(short WsBackId, short BlackLevel, short bNewImage);
IPCFUNC IpOpBkgndSubtract(short WsBackId, short bNewImage);
IPCFUNC IpOpImageArithmetics(short WsId, float Number, short OpaCode, short bNewImage);
IPCFUNC IpOpImageLogic(short WsId, short OplCode, short bNewImage);
IPCFUNC IpOpNumberArithmetics(float Number, short OpaCode, short bNewImage);
IPCFUNC IpOpNumberLogic(short Number, short OplCode, short bNewImage);
IPCFUNC IpOpShow(short bShow);

/*-----------------------------------------------------------------
| Palette tool
|------------------------------------------------------------------*/
IPCFUNC IpPalShow(short bShow);
IPCFUNC IpPalSetPaletteColor(short PaletteIndex, short Red, short Green, short Blue);
IPCFUNC IpPalSetGrayBrush(short bForeGround, short GrayIndex);
IPCFUNC IpPalSetPaletteBrush(short bForeGround, short PaletteIndex);
IPCFUNC IpPalSetRGBBrush(short bForeGround, short Red, short Green, short Blue);

/*-----------------------------------------------------------------
| Line profile
|------------------------------------------------------------------*/
IPCFUNC IpProfCreate();
IPCFUNC IpProfDestroy(void);
IPCFUNC IpProfLineMove(short x1, short y1, short x2, short y2);
IPCFUNC IpProfMaximize();
IPCFUNC IpProfMinimize();
IPCFUNC IpProfMove(short x, short y);
IPCFUNC IpProfRestore();
IPCFUNC IpProfSave(LPSTR FileName, short bAppend);
IPCFUNC IpProfSelect(short ProfId);
IPCFUNC IpProfSetAttr(short AttrType, short AttrValue);
IPCFUNC IpProfSize(short cx, short cy);
IPCFUNC IpProfUpdate();
IPCFUNC IpProfGet(short Command, short wParam, void far *lpParam);

/*-----------------------------------------------------------------
| IPPRINT.DLL - Printing
|------------------------------------------------------------------*/
IPCFUNC IpPrtHalftone(short bUsePrtHalftone, short bUsePrtScaling, short HalftoneType, short HaltoneOption);
IPCFUNC IpPrtPage(short PageNo, short bUsePrtComp, short Copies);
IPCFUNC IpPrtSize(short bActual, short bCentered, float Top, float Left, float Width, float Height, short bSmooth);

/*-----------------------------------------------------------------
| Pseudo color
|------------------------------------------------------------------*/
IPCFUNC IpPcLoad(LPSTR PseudoColorFile);
IPCFUNC IpPcSave(LPSTR PseudoColorFile);
IPCFUNC IpPcSetColor(short DivNo, short Red, short Green, short Blue);
IPCFUNC IpPcSetDivisions(short Divisions);
IPCFUNC IpPcSetRange(short DivNo, short FromVal, short ToVal);
IPCFUNC IpPcShow(short bShow);

/*-----------------------------------------------------------------
| scan functions
|------------------------------------------------------------------*/
IPCFUNC IpScanShow();

/*-----------------------------------------------------------------
| color segmentation functions
|------------------------------------------------------------------*/
IPCFUNC IpSegCreateMask(short MaskType);
IPCFUNC IpSegLoad(LPSTR ColorRangesFile);
IPCFUNC IpSegMerge(LPSTR ColorRangesFile);
IPCFUNC IpSegReset();
IPCFUNC IpSegSave(LPSTR ColorRangesFile, short bHSI);
IPCFUNC IpSegSelect(short SelectionType, short sensitivity);
IPCFUNC IpSegShow(short bShow);
IPCFUNC IpSegPreview(short bShow);

/*-----------------------------------------------------------------
| Workspace functions
|------------------------------------------------------------------*/
IPCFUNC IpWsChangeDescription(short DescriptionType, LPSTR Description);
IPCFUNC IpWsChangeInfo(short InfoType, short Info);
IPCFUNC IpWsConvertFile(LPSTR DstFile, LPSTR DstFormat, LPSTR SrcFile, LPSTR SrcFormat, short Compr, short imClass, short HalfType, short HalfOpt, short Dpi);
IPCFUNC IpWsConvertToBilevel(short HalftoneType, short Screen, short OutputDpi);
IPCFUNC IpWsConvertToFloat();
IPCFUNC IpWsConvertToGray();
IPCFUNC IpWsConvertToGray12();
IPCFUNC IpWsConvertToPaletteMColor();
IPCFUNC IpWsConvertToPaletteMedian(short StartIndex, short NumColors);
IPCFUNC IpWsConvertToRGB();
IPCFUNC IpWsCopy();
IPCFUNC IpWsCreate(short Width, short Height, short Dpi, short Class);
IPCFUNC IpWsCreateFromClipboard();
IPCFUNC IpWsDuplicate();
IPCFUNC IpWsFill(short FillType, short ColorType, short Transparency);
IPCFUNC IpWsFillPattern(LPSTR PatternFile);
IPCFUNC IpWsGetId(LPSTR WsName, LPSHORT Id);
IPCFUNC IpWsGetName(short Id, LPSTR WsName, short WsNameBufSize);
IPCFUNC IpWsLoad(LPSTR FileName, LPSTR FileFormat);
IPCFUNC IpWsLoadNumber(short Number);
IPCFUNC IpWsLoadPreview(LPSTR FileName, LPSTR FileFormat, short Left, short Top, short Right, short Bottom);
IPCFUNC IpWsMove(short x, short y);
IPCFUNC IpWsOrient(short OrientType);
IPCFUNC IpWsPan(short x, short y);
IPCFUNC IpWsPaste(short x, short y);
IPCFUNC IpWsRedo(short Number);
IPCFUNC IpWsReload();
IPCFUNC IpWsRotate(short Angle, short Anchor);
IPCFUNC IpWsRulerShow(short bShow);
IPCFUNC IpWsRulerType(short RulerType);
IPCFUNC IpWsSave();
IPCFUNC IpWsSaveAs(LPSTR FileName, LPSTR FileFormat);
IPCFUNC IpWsSaveEx(LPSTR FileName, LPSTR FileFormat, short Compression, short BitsPerPlane);
IPCFUNC IpWsScale(short Width, short Height, short bSmooth);
IPCFUNC IpWsTestStrips(short HorzPage, short VertPage, short Type, short MinValue, short MaxValue, short Reduction, short bRed, short bGreen, short bBlue);
IPCFUNC IpWsTestStrips2(short HorzPage, short VertPage, short Type1, short MinValue1, short MaxValue1, short Type2, short MinValue2, short MaxValue2, short Reduction, short bRed, short bGreen, short bBlue);
IPCFUNC IpWsTestStripsHalftone(short AllTypes, short Color, LPSHORT ipHalfTypes, LPSHORT ipHalfScreens, short OutputDpi, short Reduction);
IPCFUNC IpWsUndo(short Number);
IPCFUNC IpWsZoom(short PercentZoom);
IPCFUNC IpWsLoadSetRes(short Number);
IPCFUNC IpWsCreateFromVri(short Vri, LPSTR Name, short Mode);

/*-----------------------------------------------------------------
| Template Mode functions
|------------------------------------------------------------------*/
IPCFUNC IpTemplateMode(short OnOff);	    /* 1: ON; 0: OFF */

/*-----------------------------------------------------------------
| Macro Management functions
|------------------------------------------------------------------*/
IPCFUNC IpMacroRun(LPSTR macroName, LPSTR scriptFile);
IPCFUNC IpMacroLoad(LPSTR scriptFile);
IPCFUNC IpMacroStop(LPSTR message, short exclusif);

/*-----------------------------------------------------------------
| Miscellaneous
|------------------------------------------------------------------*/

IPCFUNC IpStAutoName(LPSTR Format, short Number, LPSTR Filename);
IPCFUNC IpStSearchDir(LPSTR Directory, LPSTR Filter, short Number, LPSTR Filename);
IPCFUNC IpStGetName(LPSTR Title, LPSTR Default, LPSTR Filter, LPSTR Filename);

#ifdef __cplusplus
}
#endif  /* __cplusplus */
