/*   GALACTICOMM Major BBS user account/billing header file                */
/*   Copyright (C) 1987-1994 GALACTICOMM, Inc.    All Rights Reserved.     */

#define UIDSIZ 30             /* user-id size (including trailing zero)    */
#define PSWSIZ 10             /* password size (ditto)                     */
#define NADSIZ 30             /* name/address line size (ditto)            */
#define PHOSIZ 16             /* phone number field size (ditto)           */
#define KEYSIZ 16             /* key (and class) name size (ditto)         */
#define XRFSIZ 15             /* maximum size for uid cross ref strings    */
#define XMSGSZ 640            /* size for class exit messages              */
#define AXSSIZ 7              /* number of ints for "access" info          */
#define DATSIZ 9              /* size of a date in xx/xx/xx format         */
#define USRACCSPARE (338-301) /* spare space, decrease when adding entries */

struct usracc {
     char userid[UIDSIZ];     /* user-id                                   */
     char psword[PSWSIZ];     /* password                                  */
     char usrnam[NADSIZ];     /* user name                                 */
     char usrad1[NADSIZ];     /* address line 1 (company)                  */
     char usrad2[NADSIZ];     /* address line 2                            */
     char usrad3[NADSIZ];     /* address line 3                            */
     char usrad4[NADSIZ];     /* address line 4                            */
     char usrpho[PHOSIZ];     /* phone number                              */
     char systyp;             /* system type code                          */
     char usrprf;             /* user preference flags                     */
     char ansifl;             /* ANSI flags                                */
     char scnwid;             /* screen width in columns                   */
     char scnbrk;             /* screen length for page breaks             */
     char scnfse;             /* screen length for FSE stuff               */
     char age;                /* user's age                                */
     char sex;                /* user's sex ('M' or 'F')                   */
     unsigned int credat;     /* account creation date                     */
     unsigned int usedat;     /* date of last use of account               */
     int csicnt;              /* classified-ad counts used so far          */
     int flags;               /* various saved bit flags                   */
     int access[AXSSIZ];      /* array of remote sysop access bits         */
     long emllim;             /* e-mail limit reached so far (new/old bdy) */
     char prmcls[KEYSIZ];     /* class to return user to if necessary      */
     char curcls[KEYSIZ];     /* current class of this user                */
     long timtdy;             /* time user has been online today (in secs) */
     unsigned int daystt;     /* days left in this class (if applicable)   */
     unsigned int fgvdys;     /* days since debt was last "forgiven"       */
     long creds;              /* credits available or debt (if negative)   */
     long totcreds;           /* total credits ever posted (paid & free)   */
     long totpaid;            /* total credits ever posted (paid only)     */
     char birthd[DATSIZ];     /* this user's birthday date                 */
     char spare[USRACCSPARE]; /* spare space, for graceful upgrades        */
};

                              /* ansifl bit definitions                    */
#define ANSON       1         /*   ANSI on=1; off=0                        */
#define ANSMAN      2         /*   ANSI manual override (0=auto sensing)   */

                              /* flags bit definitions                     */
#define HASMST      1         /*   user has the "MASTER" key for the BBS   */
#define UNDAXS      2         /*   this account cannot be deleted          */
#define SUSPEN      4         /*   this account is "suspended"             */
#define DELTAG      8         /*   this account is tagged for deletion     */
#define GOINVB      16        /*   this account is "invisible" upon logon  */

                              /* usrprf bit definitions                    */
#define PRFLIN      1         /*   always use line editor?   yes=1         */

extern
struct usracc *usaptr,        /* user accounting block pointer for usrnum  */
              *othuap,        /* gen purp other-user accounting data ptr   */
               acctmp;        /* temporary user account storage area       */

struct keyrec {               /* key (or keyring) structure                */
     char userid[UIDSIZ];     /*   User-ID (or keyring name)               */
     char keys[1];            /*   variable length list of key names       */
};

extern
struct uidxrf {                    /* user-id cross reference structure    */
     char xrfstg[XRFSIZ+1];        /*   cross reference string             */
     char userid[UIDSIZ];          /*   user-id for this cross reference   */
     char spare[6];                /*   spare space for graceful upgrades  */
} uidxrf;

struct acclass {              /* accounting class structure                */
     char clname[KEYSIZ];     /*   class name                              */
     char nxtcls[4][KEYSIZ];  /*   class to return to when expires         */
     int limcal;              /*   limit per call (-1=no limit)            */
     int limday;              /*   limit per day (-1=no limit)             */
     int dftday;              /*   default days before expiring (-1=never) */
     long dbtlmt;             /*   debt limit (0=none)                     */
     int fgvday;              /*   wait how many days before "forgiving"   */
     int idlday;              /*   inactive days before delete (-1=never)  */
     int flags;               /*   general bit flags                       */
     long seconds;            /*   seconds used so far this month          */
     unsigned users;          /*   total number of users in this class     */
     char msgs[2][XMSGSZ];    /*   exiting class messages                  */
     char spare[2032-2022];   /*   spare space - decrease when needed      */
};
                              /* indexes for nxtcls[] when a user...       */
#define DOUTTIM 0             /*   is out of time for the day              */
#define DLOAFER 1             /*   hasn't logged in for x number of days   */
#define DEXPIRE 2             /*   has been around x number of days        */
#define DCREDIT 3             /*   has/doesn't have credits                */

                              /* struct acclass bit flag definitions       */
#define KCKOFF 1              /*   out of time: knock the user offline     */
#define CLSCHG 2              /*   out of time: temporarily change class   */
#define NOCRED 4              /*   expire when: credits < 1                */
#define DBTLMT 8              /*   expire when: user reaches a debt limit  */
#define HASCRD 16             /*   expire when: credits > 0                */
#define DAYEXP 32             /*   expire when: x number of days passes    */
#define IDLEXP 64             /*   expire when: no log on for x # of days  */
#define MONDAY 128            /*   forgive: every Monday                   */
#define FSTMTH 256            /*   forgive: on the first of each month     */
#define NUMDAY 512            /*   forgive: every x number of days         */
#define HITLMT 1024           /*   forgive: when they hit their debt limit */
#define REPDBT 2048           /*   report debt when forgiven?              */
#define CRDXMT 4096           /*   this class exempt from credit charges?  */

struct clstab {               /* structure for in-memory class table       */
     char clname[KEYSIZ];     /*   class name                              */
     char nxtcls[4][KEYSIZ];  /*   class to return to when expires         */
     int limcal;              /*   limit per call (-1=no limit)            */
     int limday;              /*   limit per day (-1=no limit)             */
     int dftday;              /*   default days before expiring (-1=never) */
     long dbtlmt;             /*   debt limit (-1=none)                    */
     int fgvday;              /*   wait how many days before "forgiving"   */
     int idlday;              /*   inactive days before delete (-1=never)  */
     int flags;               /*   general bit flags                       */
     long seconds;            /*   seconds used so far this month          */
     unsigned users;          /*   total number of users in this class     */
     struct clstab *next;     /*   ptr to next element in linked list      */
};

extern int numcls;            /* total number of classes in system         */
extern unsigned dtrack;       /* days tracked so far (for statistic avgs)  */

extern
struct clstab *clshead,       /* head record for class table               */
              *clsptr;        /* general purpose ptr to a class table entry*/

extern
BTVFILE *accbb;               /* user account database BTRIEVE file ptr    */

/* ACCOUNT.C 03/04/92 11.19.18 */
void iniacc(void);
struct usracc *uacoff(int unum);
int crtclass(struct acclass *cptr);
struct clstab *fndcls(char *clsname);
void swtcls(struct usracc *uacc,int makprm,char *clsnam,int dest,
                   int days);
int namacls(char *clsname);
int dedcrd(long amt,int asmuch);
int rdedcrd(long amt,int asmuch);
int odedcrd(int unum,long amt,int real,int asmuch);
int ndedcrd(char *uid,long amt,int real,int asmuch);
int gdedcrd(char *uid,long amt,int real,int asmuch);
int ldedcrd(struct usracc *uptr,long amt,int real,int asmuch);
long hdedcrd(struct usracc *uptr,long amt,int real,int asmuch);
int tstcrd(long amt);
int rtstcrd(long amt);
int otstcrd(int unum,long amt,int real);
int ntstcrd(char *uid,long amt,int real);
int gtstcrd(char *uid,long amt,int real);
int ltstcrd(struct usracc *uptr,long amt,int real);
void dltcls(struct clstab *tabptr);
int addcrd(char *keyuid,char *tckstg,int real);
int crdusr(char *keyuid,char *tckstg,int real,int affall);
int saycrd(char *tckstg,int real);
void cpykey(char *dest,char *src,int len);
void decevy(void);
void chkliu(void);
void savvbl(void);
int imbump(int logon);
int wtwait(int lomin,int himin);
int nliniu(void);
void updacc(void);
int accmcu(void);
void accacct(struct usracc *accptr,int plusor);
int delacct(char *userid);
int kiluid(char *userid);
void howbuy(void);
void clsacc(void);

