/***************************************************************************
 *                                                                         *
 *   REMSYS.C                                                              *
 *                                                                         *
 *   Copyright (C) 1987-1994 GALACTICOMM, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   This is The Major BBS Remote Sysop module.  In addition this module   *
 *   handles the creation and editing for the "Class" accounting system.   *
 *                                                                         *
 *                               - S. Brinker & R. Skurnick 3/29/91        *
 *                                                                         *
 *                               (based upon Functions and Utilities by    *
 *                                A. Von Gauss, R. Skurnick, & S. Brinker) *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"
#include "sys\stat.h"
#include "majorbbs.h"
#include "galrsy.h"
#include "remote.h"
#include "filexfer.h"

STATIC void rsop35(void);
STATIC void rsop71i1(void);
STATIC void rsop71j2(void);
STATIC void rsop71j3(void);
STATIC void rsop71j4(void);
STATIC void rsop71ja(void);
STATIC void rsop71jv(void);
STATIC void rsop71je(void);
STATIC int tshrem(int tshcod);
STATIC int fuprnw(int fupcode);
STATIC int fuprem(int fupcod);
STATIC void prfjdje(void);
STATIC void remall(struct usracc *uacptr,int onoff);
STATIC void hdlbit(int tbit);
STATIC void flgmsg(int tbit,int sflag);
STATIC void dspdir(void);
STATIC int ask4uid(int on);
STATIC int chksfil(int shut);
STATIC void getfil(void);
STATIC void lstuon(void);
STATIC void sporf(void);
STATIC void bgnaud(int start);
STATIC void getaud(void);
STATIC void bgnads(void);
STATIC void scnacc(void);
STATIC void chkstg(char *stg);
STATIC void chkint(int numb);
STATIC void prfaxlin(struct usracc *uacptr,int msg,int b1,int b2,int b3,int b4);
STATIC int axs4op(struct usracc *uacptr,int op);
STATIC void togaxs(struct usracc *uacptr,int op);
STATIC int isvalop(char *opstg);
STATIC void chkkey(int remove);
STATIC void impkey(int remove);
STATIC char *setdft(char c);
STATIC void dspkys(char *keyr,int ring);
STATIC int canedt(void);
STATIC int ok2poll(void);
STATIC int dnlmnu(int on);

int  rmsyst;
struct module remotesys={     /* module interface block               */
     "",                      /*    description for main menu         */
     NULL,                    /*    user logon supplemental routine   */
     account,                 /*    input routine if selected         */
     acsthn,                  /*    status-input routine if selected  */
     NULL,                    /*    "injoth" routine for this module  */
     NULL,                    /*    user logoff supplemental routine  */
     zaprsy,                  /*    hangup (lost carrier) routine     */
     NULL,                    /*    midnight cleanup routine          */
     NULL,                    /*    delete-account routine            */
     clsrsy                   /*    finish-up (sys shutdown) routine  */
};

extern
BTVFILE *audbb,               /* Btrieve file block ptr for audit trail    */
        *clsbb;               /* Btrieve file block ptr for class data     */

FILE *rsymb;                  /* remote Sysop message file block ptr       */

struct acclass *rclsptr;      /* single occurance of a class element       */

#define EMUCHT      'C'       /* control-key used to toggle sysop chat     */
#define EMUZAP      'Z'       /* control-key used to zap emulated channel  */
#define EMUEXT      27        /* control-key used to exit emulation        */

int rsykil=-1;                     /* remote sysop event kill counter      */

static
int op;                            /* global "op" number                   */

extern
int detflg;                        /* shwusr(): called frm here, DETAIL cmd  */

struct valop {
     char *opname;
     int msgstt;
     int op;
} valops[]={
     {"SENDALL", RSOP11,11},
     {"SEND",    RSOP12,12},
     {"LOGON",   RSOP13,13},
     {"DETAIL",  RSOP22,22},
     {"AUDIT",   RSOP23,23},
     {"USERS",   RSOP24,24},
     {"SEARCH",  RSOP25Z,25},
     {"HANGUP",  RSOP31,31},
     {"SUSPEND", RSOP32,32},
     {"PROTECT",  RSOP33,33},
     {"DELETE",  RSOP34,34},
     {"SHUTDOWN",RSOP35,35},
     {"CLEANUP", RSOP36,36},
     {"SYSTATS", RSOP412,41},
     {"MODSTATS",RSOP422,42},
     {"DEMSTATS",RSOP43,43},
     {"CLSSTATS",RSOP442,44},
     {"EMULATE", RSOP51,51},
     {"MONITOR", RSOP52,52},
     {"INPUT",   RSOP53,53},
     {"CHANGE",  RSOP54,54},
     {"TYPE",    RSOP61,61},
     {"COPY",    RSOP62,62},
     {"RENAME",  RSOP63,63},
     {"DIR",     RSOP64,64},
     {"MD",      RSOP65,65},
     {"RD",      RSOP66,66},
     {"DEL",     RSOP67,67},
     {"ACCOUNT", RSOP71,71},
     {"TRANSFER",RSOP73,73},
     {"SYSOP",   RSOP99,99}
};

static int xflags[]={IDLEXP,DAYEXP,NOCRED,HASCRD,DBTLMT};
static int kilmins[]={1,2,5,10,0,-1,0};
static int fflags[]={FSTMTH,MONDAY,NUMDAY,HITLMT};
static int glthrv[5][3]={{0,1,0},{0,0,1},{1,0,0},{0,1,1},{1,1,0}};

void EXPORT
init__remsys(void)                 /* initialize remote sysop module       */
{
     stzcpy(remotesys.descrp,gmdnam("GALRSY.MDF"),MNMSIZ);
     rmsyst=register_module(&remotesys);
     rsymb=opnmsg("galrsy.mcv");                  /* allocate enough vda to*/
     dclvda(max(RINGSZ,sizeof(struct rsysop)));   /* import keyrings w/ tmp*/
     rclsptr=(struct acclass *)alcmem(sizeof(struct acclass));
     ntfysopr=ntfysop;
}

STATIC void
rsop35(void)                       /* remote shutdown                      */
{
     int unum;

     op=cncint();
     if (op >= 1 && op <= 7) {
          if (op == 5) {
               kilipg=0;
               errcod=1;
               rsmode=NORMRS;
               unum=usrnum;
               prepff();
               kilctr=-1;
               curusr(unum);
               rsprom(RSSMNU);
          }
          else {
               rsyptr->rkilctr=kilmins[op-1];
               rsprom(RSOP35A);
          }
     }
     else {
          cncall();
          prfmsg(INVOPT);
          rsprom(RSOP35);
     }
}

STATIC void
rsop71i1(void)                     /* editing a class                      */
{
     switch(cncchr()) {
     case 'N':
          rsprom(RSOP71H);
          break;
     case 'E':
          setbtv(clsbb);
          geqbtv(rclsptr,rsyptr->cltptr->clname,0);
          rsyptr->flags|=EDTCLS;
          rsprom(RSOP71J1);
          break;
     case 'K':
          rsyptr->text[0]=RINGID;
          rsyptr->text[1]='\0';
          strcat(rsyptr->text,rsyptr->cltptr->clname);
          rsyptr->flags|=EDTKYR;
          prfmsg(ROP71JL1);
          rsprom(RSOP71JM);
          break;
     case 'D':
          rsprom(RSOP71I2);
          break;
     default:
          cncall();
          rsprom(RSOP71I1);
     }
}

STATIC void
rsop71j2(void)
{
     if (sameto("Unl",nxtcmd)) {
          cncwrd();
          rclsptr->limday=-1;
          rclsptr->flags|=KCKOFF;
          if (rsyptr->flags&EDTCLS) {
               rclsptr->msgs[0][0]=rclsptr->nxtcls[0][0]='\0';
          }
          rclsptr->flags&=~CLSCHG;
          rsprom(ROP71J7A);
     }
     else if (isdigit(*nxtcmd) && (op=cncint()) >= 0 && op <= 1440) {
          rclsptr->limday=op;
          rsprom(RSOP71J3);
     }
     else {
          prfmsg(INVAMT);
          rsprom(RSOP71J2);
          cncall();
     }
}

STATIC void
rsop71j3(void)
{
     if ((op=cncint()) > 0 && op < 3) {
          rclsptr->flags&=~(KCKOFF|CLSCHG);
          rclsptr->flags|=(op == 1 ? KCKOFF : CLSCHG);
          if (op == 1) {
               rclsptr->nxtcls[0][0]='\0';
               rclsptr->msgs[0][0]='\0';
               rsprom(ROP71J7A);
          }
          else {
               rsprom(RSOP71J4);
          }
     }
     else {
          prfmsg(INVAMT);
          rsprom(RSOP71J3);
          cncall();
     }
}

STATIC void
rsop71j4(void)                     /* switching class if out of time today */
{
     if (morcnc() == '?') {
          cncall();
          dspcll();
          rsprom(RSOP71J4);
          return;
     }
     strcpy(rsyptr->text,cncall());
     if (namacls(rsyptr->text)) {
          strcpy(rclsptr->nxtcls[0],rsyptr->text);
          if (sameas(rsyptr->text,"DELETE_ACCOUNT")) {
               rclsptr->msgs[0][0]='\0';
               rsprom(ROP71J7A);
          }
          else if (fndcls(rsyptr->text) == NULL) {
               prfmsg(DELWRN,strupr(rsyptr->text));
               rsprom(RSOP71J5);
          }
          else {
               rsprom(RSOP71J5);
          }
     }
     else {
          prfmsg(INVKYR);
          rsprom(RSOP71J4);
     }
}

STATIC void
rsop71ja(void)
{
     if ((op=cncint()) > 0 && op <= 5) {
          rclsptr->flags&=~(FSTMTH|MONDAY|NUMDAY|HITLMT);
          rclsptr->flags|=REPDBT;
          if (op != 3) {
               rclsptr->fgvday=0;
          }
          if (op < 5) {
               rclsptr->flags|=fflags[op-1];
               if (op == 3) {
                    rsprom(RSOP71JB);
               }
               else {
                    prfjdje();
               }
          }
          else {
               rclsptr->flags&=~REPDBT;
               prfjdje();
          }
     }
     else {
          prfmsg(INVAMT);
          rsprom(RSOP71JA);
     }
}

STATIC void
rsop71jv(void)
{
     if (cncyesno() == 'Y') {
          if (rsyptr->flags&CRTCLS) {
               if (crtclass(rclsptr)) {
                    prfmsg(CLSCRT);
               }
               else {
                    dlkeys(rsyptr->text);
                    prfmsg(CLSNOG);
               }
          }
          else {
               movmem(rclsptr,rsyptr->cltptr,
                  sizeof(struct clstab)-sizeof(struct clstab *));
               setbtv(clsbb);
               geqbtv(NULL,rclsptr->clname,0);
               updbtv(rclsptr);
               prfmsg(CLSEDT);
          }
     }
     else {
          if (rsyptr->flags&CRTCLS) {
               dlkeys(rsyptr->text);
          }
     }
     rsyptr->flags&=~(CRTCLS|EDTCLS);
     rsprom(RSOP71H);
     cncall();
}

STATIC void
rsop71je(void)
{
     op=morcnc();
     if (!isdigit(op) || (rsyptr->chan=op=cncint()) < 0
         || ((rclsptr->flags&CRDXMT) && op > 2)
         || ((rclsptr->dbtlmt == 0L && op > 4) || op > 5)) {
          cncall();
          prfmsg(INVAMT);
          rsprom(RSOP71JE);
          return;
     }
     else if (op == 0) {
          rsyptr->text[0]=RINGID;
          rsyptr->text[1]='\0';
          strcat(rsyptr->text,rclsptr->clname);
          if (rsyptr->flags&CRTCLS) {
               nkyrec(rsyptr->text);
          }
          prfmsg(RSOP71JL);
          rsprom(RSOP71JM);
          return;
     }
     else if (op == 3 && (rclsptr->flags&HASCRD)) {
          rsyptr->genctr=4;
          strcpy(rsyptr->sfname,"when users run out of credits");
          strcpy(rsyptr->dfname,"when users are posted credits");
     }
     else if (op == 3 && (rclsptr->flags&DBTLMT)) {
          rsyptr->genctr=5;
          strcpy(rsyptr->sfname,"when users run out of credits");
          strcpy(rsyptr->dfname,"when users reach their debt limit");
     }
     else if (op == 4 && (rclsptr->flags&NOCRED)) {
          rsyptr->genctr=3;
          strcpy(rsyptr->sfname,"when users are posted credits");
          strcpy(rsyptr->dfname,"when users run out of credits");
     }
     else if (op == 4 && (rclsptr->flags&DBTLMT)) {
          rsyptr->genctr=5;
          strcpy(rsyptr->sfname,"when users are posted credits");
          strcpy(rsyptr->dfname,"when users reach their debt limit");
     }
     else if (op == 5 && (rclsptr->flags&NOCRED)) {
          rsyptr->genctr=3;
          strcpy(rsyptr->sfname,"when users reach their debt limit");
          strcpy(rsyptr->dfname,"when users run out of credits");
     }
     else if (op == 5 && (rclsptr->flags&HASCRD)) {
          rsyptr->genctr=4;
          strcpy(rsyptr->sfname,"when users reach their debt limit");
          strcpy(rsyptr->dfname,"when users are posted credits");
     }
     else {
          rclsptr->flags|=xflags[op-1];
          rsprom(op == 1 ? RSOP71JG : op == 2 ?  RSOP71JH : RSOP71JI);
          return;
     }
     rsprom(RSOP71JK);
}

STATIC int
tshrem(int tshcod)     /* Handle tagspecs for your remote sysop application */
{                    /* implicit inputs: ftgptr,usrnum,usrptr,usaptr,vdaptr */
                                  /* return value meaning depends on tshcod */
                             /* implicit input/output in many cases: tshmsg */
                                     /* expect caller to do outprf() if any */
     int rc=0;
     FILE *fp;

     setmbk(rsymb);
     switch(tshcod) {
     case TSHDSC:                            /* Describe tagspec in English */
          sprintf(tshmsg,"file(s) \"%s\" for remote sysop use",
                         ftgptr->tagspc);
          break;
     case TSHVIS:                                  /* Visible to this user? */
          if (ftgptr->flags&FTGWLD) {
               rc=1;
          }
          else {
               strcpy(tshmsg,rsyptr->text);
               strcat(tshmsg,ftgptr->tagspc);
               if (sameas(ftgptr->tagspc,"BBSMNU.DAT")) {
                    strcpy(tshmsg,"");
                    rc=1;
               }
               else if ((fp=fopen(tshmsg,FOPRB)) != NULL) {
                    fread(tshmsg,1,TSHLEN,fp);
                    fclose(fp);
                    rc=1;
               }
          }
          break;
     case TSHSCN:             /* Scan of multi-file wildcard tagspec begins */
          strcpy(tshmsg,rsyptr->text);
          strcat(tshmsg,ftgptr->tagspc);
          if (fnd1st(&ftuptr->fb,tshmsg,0)) {
               strcpy(tshmsg,ftuptr->fb.name);
               rc=1;
          }
          else {
               strcpy(tshmsg,"");                  /* clean up after myself */
          }
          break;
     case TSHNXT:                             /* Next file in wildcard scan */
          if (fndnxt(&ftuptr->fb)) {
               strcpy(tshmsg,ftuptr->fb.name);
               rc=1;
          }
          break;
     case TSHBEG:              /* Begin download, check permission, reserve */
          if (sameas(ftgptr->tagspc,"BBSMNU.DAT")) {
               if (!dnlmnu(1)) {
                    strcpy(tshmsg,"Someone else is already downloading BBSMNU.DAT!");
                    return(0);
               }
          }
          strcpy(tshmsg,rsyptr->text);
          strcat(tshmsg,ftgptr->tagspc);
          strcpy(ftfscb->fname,ftgptr->tagspc);
          rc=1;
          break;
     case TSHEND:             /* End complete download of a file, unreserve */
          break;
     case TSHSKP:                     /* Skip incomplete download of a file */
          break;
     case TSHFIN:                            /* Finish file tranfer session */
          dnlmnu(0);
          usrptr->state=rmsyst;
          rsprom(RSOP73);
          rc=1;
          break;
     case TSHHUP:                /* Finish session because user logging off */
          dnlmnu(0);
          break;
     }
     return(rc);
}

STATIC int
fuprnw(int fupcode)              /* upload handler for replacing BBSMNU.DAT */
{
     extern BTVFILE *mnubb;

     switch(fupcode) {
     case FUPBEG:
          if (ftfscb->fname[0] != '\0' && !sameas(ftfscb->fname,"BBSMNU.DAT")) {
               strcpy(ftfbuf,"The 'U' option is only for uploading BBSMNU.DAT");
               return(0);
          }
          strcpy(ftfbuf,"NEWMNU.$$$");
          stzcpy(rsyptr->sfname,ftfbuf,FNSIZE);
          return(1);
     case FUPEND:
          clsbtv(mnubb);
          unlink("BBSMNU.DAT");
          rename("NEWMNU.$$$","BBSMNU.DAT");
          mnubb=opnbtv("bbsmnu.dat",sizeof(struct menupag));
          shocst("NEW BBSMNU.DAT UPLOADED","Uploading user: %s",
                 uacoff(usrnum)->userid);
          ftfbuf[0]='\0';
          return(0);
     case FUPSKP:
          unlink("NEWMNU.$$$");
          return(0);
     }
     return(fuprem(fupcode));
}

STATIC int
fuprem(int fupcod)              /* Handle uploads for the remote sysop      */
{                          /* implicit inputs:  usrnum,usrptr,usaptr,vdaptr */
                                  /* return value meaning depends on fupcod */
                             /* implicit input/output in many cases: fupmsg */
                                     /* expect caller to do outprf() if any */
     int rc=0;

     setmbk(rsymb);
     switch(fupcod) {
     case FUPBEG:                /* Begin upload, check permission, reserve */
          strcpy(ftfbuf,rsyptr->text);
          if (rsyptr->text[100] != '\0') {
               strcat(ftfbuf,&rsyptr->text[100]);
          }
          else {
               strcat(ftfbuf,ftfscb->fname);
          }
          stzcpy(rsyptr->sfname,ftfbuf,FNSIZE);
          rc=1;
          break;
     case FUPEND:               /* End complete upload of a file, unreserve */
          strcpy(ftfbuf,ftfscb->fname);
          rsyptr->sfname[0]='\0';
          break;
     case FUPSKP:                       /* Skip incomplete upload of a file */
          unlink(ftfscb->fname);
          rsyptr->sfname[0]='\0';
          break;
     case FUPFIN:                             /* Finish file upload session */
          usrptr->state=rmsyst;
          rsprom(RSOP73);
          rc=1;
          break;
     case FUPHUP:                /* Finish session because user logging off */
          break;
     }
     return(rc);
}

int
account(void)                      /* remote Sysop "account" handler       */
{
     char *ptr,*bas;
     int i,msg,unum;
     long l;

     setmbk(rsymb);
     chkdft(rsyptr->dftinp);
     if ((ptr=setdft(input[0])) != NULL) {
          strcpy(input,ptr);
          inplen=strlen(input);
     }
     if (margc == 0 || usrptr->flags&INJOIP) {
          acczero();
     }
     else if (margc == 1 && sameas(margv[0],"x")) {
          clrxrf();
          if (!acconex()) {
               return(0);
          }
     }
     else {
          do {
               bgncnc();
               switch (usrptr->substt) {
               case 0:
                    cncchr();
                    rsprom(RSMENU);
                    usrptr->substt=RSSMNU;
                    break;
               case RSMENU:
               case RSSMNU:
                    if (morcnc() == '?') {
                         cncall();
                         rsprom(RSMENU);
                    }
                    else if ((msg=isvalop(cncwrd())) == 0) {
                         cncwrd();
                         prfmsg(INVOPT);
                         rsprom(RSMENU);
                    }
                    else if (!axs4op(usaptr,op)) {
                         cncall();
                         prfmsg(op == 99 ? INVOPT : NARSOP);
                         rsprom(RSSMNU);
                    }
                    else {
                         rsprom(msg);
                    }
                    break;
               case RSOP12:
                    if (ask4uid(1)) {
                         cncall();
                         op=0;
                         op|=(ED_CLRTXT|ED_CLRTOP);
                         bgnedt(MTXSIZ,rsyptr->text,0,NULL,dwedt12,op);
                         return(1);
                    }
                    break;
               case RSOP22:
                    if (ask4uid(0)) {
                         if (onsysn(rsyptr->acc.userid,1)) {
                              movmem(othuap,&rsyptr->acc,sizeof(struct usracc));
                         }
                         detflg=1;
                         shwusr(&rsyptr->acc);
                         prfmsg(DETPT3,l2as(rsyptr->acc.totcreds),
                                       l2as(rsyptr->acc.totcreds-
                                            rsyptr->acc.totpaid),
                                       l2as(rsyptr->acc.totpaid));
                         rsprom(RSSMNU);
                    }
                    break;
               case RSOP23:
                    switch (op=cncchr()) {
                    case 'B':
                         bgnaud(1);
                         break;
                    case 'E':
                         bgnaud(0);
                         break;
                    default:
                         prfmsg(INVOPT);
                         prfmsg(RSOP23);
                    }
                    cncall();
                    break;
               case RSOP23A:
                    prf("");
                    break;
               case RSOP25Z:
                    if ((op=cncint()) < 1 || op > 16) {
                         cncall();
                         prfmsg(INVOPT);
                         rsprom(RSOP25Z);
                    }
                    else {
                         if (op == 15 || op == 16) {
                              rsprom(RSOP25B);
                         }
                         else {
                              rsprom(RSOP25A);
                         }
                         rsyptr->chan=op;
                    }
                    break;
               case RSOP25A:
                    strcpy(rsyptr->text,cncall());
                    if (rsyptr->chan == 9 ||
                       (rsyptr->chan >= 12 && rsyptr->chan <= 14)) {
                         rsprom(RSOP25C);
                    }
                    else {
                         bgnads();
                    }
                    break;
               case RSOP25B:
                    strcpy(rsyptr->text,cncall());
                    if (dcdate(rsyptr->text) == -1) {
                         prfmsg(INVDAT);
                         rsprom(RSOP25B);
                    }
                    else {
                         rsprom(RSOP25C);
                    }
                    break;
               case RSOP25C:
                    if ((rsyptr->genctr=cncint()) < 1 || rsyptr->genctr > 5) {
                         prfmsg(INVOPT);
                         rsprom(RSOP25C);
                    }
                    else {
                         bgnads();
                    }
                    break;
               case RSOP25D:
                    prf("");
                    break;
               case RSOP31:
                    if (ask4uid(1)) {
                         btuinj(rsyptr->chan,RING);
                         prfmsg(USRZAP);
                         rsprom(RSSMNU);
                    }
                    break;
               case RSOP32:
                    if (ask4uid(0)) {
                         if ((rsyptr->acc.flags&HASMST)
                           || sameas(rsyptr->acc.userid,"Sysop")) {
                              prfmsg(NO2SYS);
                              rsprom(RSOP32);
                         }
                         else {
                              rsyptr->chan=(rsyptr->acc.flags&SUSPEN) ? 1 : 0;
                              rsprom(RSOP32A);
                         }
                    }
                    break;
               case RSOP32A:
                    hdlbit(SUSPEN);
                    break;
               case RSOP33:
                    if (ask4uid(0)) {
                         rsyptr->chan=(rsyptr->acc.flags&UNDAXS) ? 1 : 0;
                         rsprom(RSOP33A);
                    }
                    break;
               case RSOP33A:
                    hdlbit(UNDAXS);
                    break;
               case RSOP34:
                    if (ask4uid(0)) {
                         if (!(rsyptr->acc.flags&UNDAXS)) {
                              op=onsysn(rsyptr->acc.userid,1);
                              if (op && othusn == usrnum) {
                                   rblwof(USRNDL);
                                   break;
                              }
                              if (op) {
                                   unum=usrnum;
                                   curusr(othusn);
                                   loscar();
                                   curusr(unum);
                                   setmbk(rsymb);
                              }
                              if (delacct(rsyptr->acc.userid) >= 0) {
                                   setmbk(rsymb);
                                   rblwof(USRDEL2);
                                   break;
                              }
                         }
                         prfmsg(USRNDL);
                         rsprom(RSSMNU);
                    }
                    break;
               case RSOP35:
                    rsop35();
                    break;
               case RSOP35A:
                    if (cncyesno() == 'Y') {
                         kilsrc=usrnum;
                         errcod=8;
                         kilctr=rsyptr->rkilctr;
                         fupkil();
                         setmbk(rsymb);
                    }
                    cncall();
                    rsprom(RSSMNU);
                    break;
               case RSOP36:
                    if ((rsyptr->chan=cncint()) < 1 || rsyptr->chan > 5) {
                         cncall();
                         prfmsg(INVOPT);
                         rsprom(RSOP36);
                    }
                    else {
                         rsprom(RSOP36A);
                    }
                    break;
               case RSOP36A:
                    if ((rsykil=cncint()) < 1 || rsykil > 10) {
                         cncall();
                         prfmsg(BERESN);
                         rsprom(RSOP36A);
                    }
                    else {
                         rsykil++;
                         errcod=(rsyptr->chan == 1 ? 0 : rsyptr->chan+9);
                         rsyptr->chan=usrnum;
                         rsmode=rsetop;
                         prepff();
                         curusr(rsyptr->chan);
                         prfmsg(SET4EV);
                         outprf(usrnum);
                         rsyevt();
                         rsprom(RSSMNU);
                    }
                    break;
               case RSOP51:
                    if (ask4uid(2)) {
                         if (emuinu()) {
                              rblwof(EMUINU);
                         }
                         else if (othusn == usrnum) {
                              rblwof(EMUYOU);
                         }
                         else if (othusn == nterms-1) {
                              rblwof(EMULCL);
                         }
                         else {
                              btutrg(usrnum,1);
                              rmtsys=usrnum;
                              usrptr->flags|=NOINJO;
                              emuchn(rsyptr->chan);
                              prfmsg(usrptr->substt=RSOP51A);
                              btuscr(usrnum,0);
                              prf("\r\n\n");
                         }
                    }
                    break;
               case RSOP51A:                 /* Emulation just ignore      */
               case RSOP52A:                 /* Monitor stuff just ignore  */
                    break;
               case RSOP54:
                    if (ask4uid(2)) {
                         if (user[rsyptr->chan].class != VACANT) {
                              prfmsg(ACTCHN);
                              prfmsg(RSOP54);
                         }
                         else {
                              rsprom(RSOP54A);
                         }
                    }
                    break;
               case RSOP54A:
                    switch (cncchr()) {
                    case 'R':
                         op=NORMRS;
                         break;
                    case 'B':
                         op=BUSYRS;
                         break;
                    case 'N':
                         op=NANSRS;
                         break;
                    default:
                         cncall();
                         prfmsg(INVOPT);
                         prfmsg(RSOP54A);
                         break;
                    }
                    rsmodes[rsyptr->chan]=op;
                    kilchn(rsyptr->chan);
                    prfmsg(CHNCHG);
                    rsprom(RSSMNU);
                    break;
               case RSOP61:
                    if (chksfil(0)) {
                         clrprf();
                         usrptr->flags|=NOINJO;
                         usrptr->substt=RSOP61A;
                    }
                    break;
               case RSOP61A:
                    break;
               case RSOP62:
                    rsop62();
                    break;
               case RSOP62A:
                    rsop62a();
                    break;
               case RSOP62B:
                    break;
               case RSOP63:
                    cncall();
                    parsin();
                    if (margc == 2) {
                         if (fnamchk(margv[0]) || fnamchk(margv[1])) {
                              prfmsg(FILINU);
                         }
                         else {
                              prfmsg(rename(margv[0],margv[1]) == 0
                                ? RSOP63A : RSOP63B,margv[0],margv[1]);
                         }
                    }
                    else {
                         prfmsg(RSOP63C);
                    }
                    rsprom(RSSMNU);
                    break;
               case RSOP64:
                    getfil();
                    if (fnd1st(&rsyptr->dirblk,rsyptr->sfname,FAMDIR)) {
                         prf("\r");
                         dspdir();
                         usrptr->substt=RSOP64A;
                    }
                    else {
                         prfmsg(RSOP64B);
                         rsprom(RSSMNU);
                    }
                    break;
               case RSOP64A:
                    prf("");
                    break;
               case RSOP65:
                    strcpy(rsyptr->text,cncall());
                    prfmsg(mkdir(rsyptr->text) == 0 ? RSOP65A : RSOP65B,
                           rsyptr->text);
                    rsprom(RSSMNU);
                    break;
               case RSOP66:
                    strcpy(rsyptr->text,cncall());
                    prfmsg(rmdir(rsyptr->text) == 0 ? RSOP66A : RSOP66B,
                           rsyptr->text);
                    rsprom(RSSMNU);
                    break;
               case RSOP67:
                    if (chksfil(1)) {
                         prfmsg(unlink(rsyptr->sfname) == 0 ? RSOP67A : RSOP67B,
                                rsyptr->sfname);
                         rsprom(RSSMNU);
                    }
                    break;
               case RSOP71:
                    rsop71();
                    break;
               case RSOP71A:
                    if (ask4uid(0)) {
                         rsprom(RSOP71AA);
                    }
                    break;
               case RSOP71AA:
                    cpykey(rsyptr->text,cncnum(),8);
                    if (atol(rsyptr->text) == 0L) {
                         rsprom(RSOP71AA);
                    }
                    else {
                         rsprom(RSOP71AB);
                    }
                    break;
               case RSOP71AB:
                    sporf();
                    break;
               case RSOP71AC:
                    sisokq();
                    break;
               case RSOP71B:
                    if (morcnc() == '?') {
                         cncall();
                         dspcll();
                         rsprom(RSOP71B);
                    }
                    else {
                         dspkys(cncall(),1);
                         rsprom(RSOP71);
                    }
                    break;
               case RSOP71C:
                    if (ask4uid(0)) {
                         if (sameas(rsyptr->acc.prmcls,rsyptr->acc.curcls)) {
                              prfmsg(RSOP71C2,rsyptr->acc.userid,
                                     rsyptr->acc.prmcls);
                         }
                         else {
                              prfmsg(RSOP71C3,rsyptr->acc.userid,
                                     rsyptr->acc.curcls,rsyptr->acc.prmcls);
                         }
                         rsprom(RSOP71C1);
                    }
                    break;
               case RSOP71C1:
                    if (morcnc() == '?') {
                         cncall();
                         dspcll();
                         rsprom(RSOP71C1);
                    }
                    else {
                         strcpy(rsyptr->text,strupr(cncall()));
                         if (!namacls(rsyptr->text)) {
                              prfmsg(INVKYR);
                              rsprom(RSOP71C1);
                              break;
                         }
                         else if (fndcls(rsyptr->text) == NULL) {
                              prfmsg(NOSKYR);
                              rsprom(RSOP71C1);
                              break;
                         }
                         if ((rsyptr->cltptr=fndcls(rsyptr->text)) != NULL
                             && (rsyptr->cltptr->flags&DAYEXP)) {
                              rsprom(RSOP71C4);
                         }
                         else if (!(rsyptr->cltptr->flags&HASCRD
                              && rsyptr->cltptr->flags&NOCRED)) {
                              swtcls(&rsyptr->acc,1,rsyptr->text,3,0);
                              prfmsg(OKSWCH,rsyptr->acc.userid,rsyptr->text);
                              rsprom(RSOP71);
                         }
                         else {
                              rsyptr->cltptr=NULL;
                              prfmsg(NOSKYR);
                              rsprom(RSOP71C1);
                         }
                    }
                    break;
               case RSOP71C4:
                    i=0;
                    if (morcnc() == '.' || ((i=cncint()) > 0 && i < 32000)) {
                         if (i == 0) {
                              cncchr();
                         }
                         swtcls(&rsyptr->acc,1,rsyptr->text,3,i);
                         prfmsg(OKSWCH,rsyptr->acc.userid,rsyptr->text);
                         rsprom(RSOP71);
                    }
                    else {
                         cncall();
                         prfmsg(INVAMT);
                         rsprom(RSOP71C4);
                    }
                    break;
               case RSOP71D:
                    if (ask4uid(0)) {
                         strcpy(rsyptr->text,rsyptr->acc.userid);
                         prfmsg(ROP71JL1);
                         rsprom(RSOP71JM);
                    }
                    break;
               case RSOP71H:
                    if (morcnc() == '?') {
                         cncall();
                         dspcll();
                         rsprom(RSOP71H);
                    }
                    else {
                         strcpy(rsyptr->text,cncall());
                         if (!namacls(rsyptr->text)) {
                              prfmsg(INVKYR);
                              rsprom(RSOP71H);
                              break;
                         }
                         if (!canedt()) {
                              prfmsg(CNTEDT);
                              rsprom(RSOP71H);
                         }
                         else if ((rsyptr->cltptr=fndcls(rsyptr->text)) != NULL
                                  && !(rsyptr->cltptr->flags&HASCRD
                                       && rsyptr->cltptr->flags&NOCRED)) {
                              rsprom(RSOP71I1);
                         }
                         else {
                              if (rsyptr->cltptr != NULL) {
                                   dltcls(rsyptr->cltptr);
                                   rsyptr->cltptr=NULL;
                              }
                              rsyptr->flags|=CRTCLS;
                              setmem(rclsptr,sizeof(struct acclass),0);
                              strcpy(rclsptr->clname,rsyptr->text);
                              rsprom(RSOP71I);
                         }
                    }
                    break;
               case RSOP71I:
                    if (cncyesno() == 'Y') {
                         rsprom(RSOP71J1);
                    }
                    else {
                         rsyptr->flags&=~CRTCLS;
                         rsprom(RSOP71H);
                    }
                    cncall();
                    break;
               case RSOP71I1:
                    rsop71i1();
                    break;
               case RSOP71I2:
                    if (cncyesno() == 'Y') {
                         dltcls(rsyptr->cltptr);
                         prfmsg(OKDLTD);
                    }
                    rsprom(RSOP71H);
                    break;
               case RSOP71J1:
                    if (sameto("Unl",nxtcmd)) {
                         cncwrd();
                         rclsptr->limcal=-1;
                         rsprom(RSOP71J2);
                    }
                    else if (isdigit(*nxtcmd) && (op=cncint()) >= 0 &&
                             op <= 1440) {
                         rclsptr->limcal=op;
                         rsprom(RSOP71J2);
                    }
                    else {
                         prfmsg(INVAMT);
                         rsprom(RSOP71J1);
                         cncall();
                    }
                    break;
               case RSOP71J2:
                    rsop71j2();
                    break;
               case RSOP71J3:
                    rsop71j3();
                    break;
               case RSOP71J4:
                    rsop71j4();
                    break;
               case RSOP71J5:
                    if (cncyesno() == 'Y') {
                         prfmsg(RSOP71J6);
                         outprf(usrnum);
                         bgnedt(XMSGSZ,rclsptr->msgs[0],0,NULL,dwedtj5,0);
                         return(1);
                    }
                    else {
                         cncall();
                         rclsptr->msgs[0][0]='\0';
                         prfmsg(RSOP71J7);
                         rsprom(ROP71J7A);
                    }
                    break;
               case ROP71J7A:
                    if (cncyesno() == 'Y') {
                         rclsptr->flags|=CRDXMT;
                         rclsptr->dbtlmt=0L;
                         prfjdje();
                    }
                    else {
                         rclsptr->flags&=~CRDXMT;
                         cncall();
                         rsprom(RSOP71J8);
                    }
                    break;
               case RSOP71J8:
                    if (cncyesno() == 'Y') {
                         rsprom(RSOP71J9);
                    }
                    else {
                         cncall();
                         rclsptr->dbtlmt=0L;
                         prfjdje();
                    }
                    break;
               case RSOP71J9:
                    if (sameto("Unl",nxtcmd)) {
                         cncwrd();
                         rclsptr->dbtlmt=-1L;
                         rsprom(RSOP71JA);
                    }
                    else if (isdigit(*nxtcmd) && (l=cnclon()) > 0L &&
                             l <= 9999999L) {
                         rclsptr->dbtlmt=l;
                         rsprom(RSOP71JA);
                    }
                    else {
                         prfmsg(INVAMT);
                         rsprom(usrptr->substt);
                    }
                    break;
               case RSOP71JA:
                    rsop71ja();
                    break;
               case RSOP71JB:
                    if ((op=cncint()) > 0 && op < 32000) {
                         rclsptr->fgvday=op;
                         prfjdje();
                    }
                    else {
                         prfmsg(INVAMT);
                         rsprom(RSOP71JB);
                    }
                    break;
               case RSOP71JE:
                    rsop71je();
                    break;
               case RSOP71JG:
                    if ((op=cncint()) > 0 && op < 32000) {
                         rclsptr->idlday=op;
                         rsprom(RSOP71JI);
                    }
                    else {
                         prfmsg(INVAMT);
                         rsprom(RSOP71JG);
                    }
                    break;
               case RSOP71JH:
                    if ((op=cncint()) > 0 && op < 32000) {
                         rclsptr->dftday=op;
                         rsprom(RSOP71JI);
                    }
                    else {
                         prfmsg(INVAMT);
                         rsprom(RSOP71JH);
                    }
                    break;
               case RSOP71JI:
                    if (morcnc() == '?') {
                         cncall();
                         dspcll();
                         rsprom(RSOP71JI);
                         break;
                    }
                    strcpy(rsyptr->text,cncall());
                    if (namacls(rsyptr->text)) {
                         strcpy(rclsptr->nxtcls[rsyptr->chan > 2 ? 3 :
                                rsyptr->chan],rsyptr->text);
                         if (sameas(rsyptr->text,"DELETE_ACCOUNT")) {
                              if (rsyptr->chan > 2) {
                                   rclsptr->msgs[1][0]='\0';
                              }
                              rsprom(RSOP71JE);
                         }
                         else if (fndcls(rsyptr->text) == NULL) {
                              prfmsg(DELWRN,strupr(rsyptr->text));
                              rsprom(rsyptr->chan <= 2 ? RSOP71JE : RSOP71JJ);
                         }
                         else {
                              rsprom(rsyptr->chan <= 2 ? RSOP71JE : RSOP71JJ);
                         }
                    }
                    else {
                         prfmsg(INVKYR);
                         rsprom(RSOP71JI);
                    }
                    break;
               case RSOP71JJ:
                    if (cncyesno() == 'Y') {
                         prfmsg(ROP71JJ1);
                         outprf(usrnum);
                         bgnedt(XMSGSZ,rclsptr->msgs[1],0,NULL,dwedtjj,0);
                         return(1);
                    }
                    else {
                         cncall();
                         rclsptr->msgs[1][0]='\0';
                         prfmsg(MSGDFT);
                         rsprom(RSOP71JE);
                    }
                    break;
               case RSOP71JK:
                    if (cncyesno() == 'Y') {
                         rclsptr->flags&=~xflags[rsyptr->genctr-1];
                         rclsptr->flags|=xflags[(op=rsyptr->chan)-1];
                         rsprom(op == 1 ? RSOP71JG : op == 2 ?  RSOP71JH : RSOP71JI);
                    }
                    else {
                         cncall();
                         rsprom(RSOP71JE);
                    }
                    break;
               case RSOP71JM:
                    if (morcnc() == '?') {
                         cncchr();
                         rsprom(RSOP71JN);
                    }
                    else if (morcnc() == '.' && *(nxtcmd+1) == '\0') {
                         rsprom((rsyptr->flags&(EDTCLS|CRTCLS)) ? RSOP71JV :
                                RSOP71);
                         cncall();
                    }
                    else if (morcnc() == '-') {
                         cncchr();
                         chkkey(1);
                    }
                    else {
                         chkkey(0);
                    }
                    break;
               case RSOP71JN:
                    if (sameto("CLASSES",nxtcmd)) {
                         cncwrd();
                         dspcll();
                         rsprom(RSOP71JM);
                    }
                    else if (sameto("CLEAR",nxtcmd)) {
                         cncwrd();
                         nkyrec(rsyptr->text);
                         prfmsg(OKCLRD);
                         rsprom(RSOP71JM);
                    }
                    else if (sameto("SOFAR",nxtcmd)) {
                         cncwrd();
                         if (rsyptr->text[0] == RINGID) {
                              dspkys(rsyptr->text+1,1);
                         }
                         else {
                              dspkys(rsyptr->text,0);
                         }
                         rsprom(RSOP71JM);
                    }
                    else if (sameto("LIST",nxtcmd)) {
                         cncwrd();
                         rsprom(RSOP71JQ);
                    }
                    else if (sameto("ADD",nxtcmd)) {
                         cncwrd();
                         rsprom(RSOP71JS);
                    }
                    else if (sameto("REMOVE",nxtcmd)) {
                         cncwrd();
                         rsprom(RSOP71JT);
                    }
                    else {
                         cncall();
                         rsprom(RSOP71JN);
                    }
                    break;
               case RSOP71JQ:
                    if (morcnc() == '?') {
                         cncall();
                         dspcll();
                         rsprom(RSOP71JQ);
                         break;
                    }
                    dspkys(cncall(),1);
                    rsprom(RSOP71JM);
                    break;
               case RSOP71JS:
                    if (morcnc() == '?') {
                         cncall();
                         dspcll();
                         rsprom(RSOP71JS);
                         break;
                    }
                    impkey(0);
                    break;
               case RSOP71JT:
                    if (morcnc() == '?') {
                         cncall();
                         dspcll();
                         rsprom(RSOP71JT);
                         break;
                    }
                    impkey(1);
                    break;
               case RSOP71JV:
                    rsop71jv();
                    break;
               case RSOP71JW:
                    if (cncyesno() == 'Y') {
                         if (rsyptr->text[0] == RINGID && (rsyptr->flags&CRTCLS)) {
                              dlkeys(rsyptr->text);
                         }
                         rsyptr->flags&=~(CRTCLS|EDTCLS);
                         rsprom(RSOP71H);
                    }
                    else {
                         rsprom((int)(rsyptr->fpos));
                    }
                    cncall();
                    break;
               case RSOP73:
                    switch (cncchr()) {
                    case 'U':
                         rsprom(RSOP73A);
                         break;
                    case 'D':
                         rsprom(RSOP73C);
                         break;
                    case 'M':
                         morcnc();
                         fileup("BBSMNU.DAT",cncall(),fuprnw);
                         break;
                    default:
                         cncall();
                         prfmsg(INVOPT);
                         rsprom(RSOP73);
                    }
                    break;
               case RSOP73A:
                    if (morcnc() == '.') {
                         cncchr();
                         strcpy(rsyptr->text,"");
                    }
                    else {
                         strcpy(rsyptr->text,cncall());
                         if (rsyptr->text[strlen(rsyptr->text)-1] != '\\') {
                              strcat(rsyptr->text,"\\");
                         }
                    }
                    rsprom(RSOP73B);
                    break;
               case RSOP73B:
                    if (morcnc() == '.') {
                         cncchr();
                    }
                    ptr=cncwrd();
                    strcpy(&rsyptr->text[100],ptr);
                    morcnc();
                    fileup(ptr,cncall(),fuprem);
                    break;
               case RSOP73C:
                    if (ftgnew()) {
                         bas=ptr=cncall();
                         ftgptr->flags=(strchr(ptr,'*') != NULL
                                     || strchr(ptr,'?') != NULL) ? FTGWLD : 0;
                         ptr=fnwext(bas);
                         stzcpy(ftgptr->tagspc,ptr,TSLENG);
                         *ptr='\0';
                         strcpy(rsyptr->text,bas);
                         ftgptr->tshndl=tshrem;
                    }
                    morcnc();
                    ftgsbm(cncall());
                    break;
               case RSOP99:
                    if (ask4uid(0)) {
                         if (sameas(rsyptr->acc.userid,"Sysop")) {
                              prfmsg(SYSNOT);
                              rsprom(RSOP99);
                         }
                         else {
                              rsprom(RSOP99B);
                         }
                    }
                    break;
               case RSOP99B:
                    if (sameas(nxtcmd,"ON")) {
                         remall(&rsyptr->acc,1);
                         cncall();
                    }
                    else if (sameas(nxtcmd,"OFF")) {
                         remall(&rsyptr->acc,0);
                         cncall();
                    }
                    else if (morcnc() == '?') {
                         cncchr();
                         rsprom(RSOP99B);
                         break;
                    }
                    else if (isvalop(cncwrd())) {
                         if (op == 99) {
                              rsyptr->acc.flags^=HASMST;
                         }
                         togaxs(&rsyptr->acc,op);
                    }
                    else {
                         cncall();
                         prfmsg(INVOPT);
                    }
                    prfmsg(RSOP99B);
                    break;
               default:
                    catastro("REMSYS STATE %d ERROR",usrptr->substt);
               }
          } while (!endcnc());
     }
     if (usrptr->state != rmsyst
      || (usrptr->substt != RSOP11
       && usrptr->substt != RSOP13)) {
          outprf(usrnum);
     }
     return(1);
}

STATIC void
prfjdje()
{
     rclsptr->flags&=~(DBTLMT|NOCRED|HASCRD|DAYEXP|IDLEXP);
     prfmsg(RSOP71JD);
     rsprom(RSOP71JE);
}

STATIC void
remall(uacptr,onoff)               /* turn on/off all options for a user   */
struct usracc *uacptr;             /* this includes HASMST flag too!       */
int onoff;
{
     int i;

     for (i=0 ; i < AXSSIZ ; i++) {
          uacptr->access[i]=(onoff ? ~0 : 0);
     }
     if (onoff) {
          uacptr->flags|=HASMST;
     }
     else {
          uacptr->flags&=~HASMST;
     }
}

STATIC void
hdlbit(                            /* handle changing a usracc bit flag    */
int tbit)                          /* bit to be changed                    */
{
     int ison,flag,unum;

     if (cncyesno() == 'Y') {
          if (rsyptr->acc.flags&HASMST && tbit == SUSPEN) {
               rblwof(NO2SYS);
               return;
          }
          if ((ison=onbbs(rsyptr->acc.userid,1)) == 1) {
               movmem(uacoff(uisusn),&rsyptr->acc,sizeof(struct usracc));
          }
          flag=(rsyptr->acc.flags&tbit) ? 1 : 0;
          if (rsyptr->chan != flag) {
               rblwof(FLGALC);
               return;
          }
          if (tbit == SUSPEN && !(rsyptr->acc.flags&tbit) && ison) {
               unum=usrnum;
               curusr(uisusn);
               if (usrptr->class > SUPIPG) {
                    loscar();
               }
               else {
                    rstchn();
               }
               curusr(unum);
          }
          if (rsyptr->chan) {
               rsyptr->acc.flags&=~tbit;
          }
          else {
               rsyptr->acc.flags|=tbit;
          }
          setbtv(accbb);
          geqbtv(NULL,rsyptr->acc.userid,0);
          updbtv(&rsyptr->acc);
          flgmsg(tbit,rsyptr->chan);
          if (ison) {
               if (rsyptr->chan) {
                    uacoff(uisusn)->flags&=~tbit;
               }
               else {
                    uacoff(uisusn)->flags|=tbit;
               }
          }
     }
     rsprom(RSSMNU);
}

STATIC void
flgmsg(                       /* display results of flag bit change        */
int tbit,                     /* which bit was changed                     */
int sflag)                    /* what the new position is                  */
{
     int word;
     static char wrds[][12]={"PROTECTED","UNPROTECTED","SUSPENDED","UNSUSPENDED"};

     word=(tbit == SUSPEN)*2+sflag;
     shocst(spr("USER ACCOUNT %s",wrds[word]),"%s %s %s",usaptr->userid,
            wrds[word],rsyptr->acc.userid);
     setmbk(rsymb);
     prfmsg(FLGCHG,rsyptr->acc.userid,wrds[word]);
}

void
rcpydat(void)                 /* copy some data for file copy              */
{
     long tmandt;
     int i=0,siz;
     char fname[FNSIZE];

     setmbk(rsymb);
     do {
          siz=fread(&rsyptr->text,1,128,rsyptr->sfp);
          fwrite(&rsyptr->text,1,siz,rsyptr->dfp);
          i++;
     } while (i < 8 && siz !=0);
     if (i < 8) {
          tmandt=getdtd(fileno(rsyptr->sfp));
          strcpy(fname,rsyptr->dfname);
          clsfils();
          setdtd(fname,(unsigned)tmandt,(unsigned)(tmandt>>16));
          prfmsg(CPYDUN);
          stop_polling(usrnum);
          rsprom(RSSMNU);
     }
     else {
          prf(".");
     }
     outprf(usrnum);
}

void
dspsts(void)                  /* display overall statistics                */
{
     cncall();
     prfmsg(RSOP412);
     prfmsg(RSOP41A2,l2as(sv.dwnlds),l2as(sv.uplds),l2as(sv2.totcalls));
     prfmsg(RSOP41B2,l2as(sv.msgtot),sv.emlopn,sv.sigopn);
     prfmsg(RSOP41C2,l2as(sv2.paidpst+sv2.freepst),l2as(sv2.freepst),
                     l2as(sv2.x25mbs),l2as(sv2.x25kps));
     rsprom(RSSMNU);
}

void
dspmdu(void)                  /* display module use statistics             */
{
     int i;

     cncall();
     prfmsg(RSOP422);
     for (i=0 ; i < nmods ; i++) {
          prf("%-25.25s |%7.7s|%9.9s|\r",module[i]->descrp,
              l2as((mdstats[i].seconds+1800L)/3600L),l2as(mdstats[i].creds));
     }
     rsprom(RSSMNU);
}

void
dspsaa(void)                  /* display system demographics               */
{
     int x,y;
     unsigned totcnt,runtot;
     unsigned total[NAGEBK];

     cncall();
     setmem(total,sizeof(unsigned)*NAGEBK,0);
     prfmsg(RSOP43);
     for (x=0,runtot=0 ; x < NCOMTY ; x++) {
          prf("%20.20s |",sysstg[x]);
          for (y=0,totcnt=0 ; y < NAGEBK ; y++) {
               totcnt+=sv2.matrix[x][y];
               total[y]+=sv2.matrix[x][y];
               prf("%5.5u|",sv2.matrix[x][y]);
          }
          runtot+=totcnt;
          prf("%5.5u|\r",totcnt);
     }
     prfmsg(RSOP43A);
     for (y=0 ; y < NAGEBK ; y++) {
          prf("%5.5u|",total[y]);
     }
     prf("%5.5u|\r",runtot);
     prfmsg(RSOP43B2,(sv2.numact-sv2.numfem),sv2.numfem,sv2.numcor,sv2.numans);
     rsprom(RSSMNU);
}

void
dspcus(void)                  /* Display all the class statistics          */
{
     long val;

     cncall();
     prfmsg(RSOP442);
     for (clsptr=clshead ; clsptr != NULL; clsptr=clsptr->next) {
          if (!(clsptr->flags&HASCRD && clsptr->flags&NOCRED)) {
               val=((clsptr->seconds)*24+dtrack/2)/dtrack;
               val=(val/(clsptr->users > 0 ? clsptr->users : 1)+30L)/60L;
               prf("%-16.16s |%7.7s|%7.7s|%7u|%16.16s|\r",clsptr->clname,
                   l2as((clsptr->seconds+1800L)/3600L),
                   l2as(((clsptr->seconds+1800L)/3600L*24+dtrack/2)/dtrack),
                   clsptr->users,
                   l2as(val));
          }
     }
     rsprom(RSSMNU);
}

STATIC void
dspdir(void)                  /* display a directory entry                 */
{
     int hr;

     hr=dthour(rsyptr->dirblk.time)%12;
     if (hr == 0) {
          hr=12;
     }
     prf("%-12.12s %8.8s  %8.8s  %s\r",rsyptr->dirblk.name,
        (rsyptr->dirblk.attr&FAMDIR) ? "<DIR>" : l2as(rsyptr->dirblk.size),
         ncdate(rsyptr->dirblk.date),
         spr("%2d:%02d%s",hr,dtmin(rsyptr->dirblk.time),
         ((dthour(rsyptr->dirblk.time)/12) ? "p" : "a")));
     btuinj(usrnum,CYCLE);
}

void
acsthn(void)                  /* status handler for remote Sysop stuff     */
{
     setmbk(rsymb);
     if (status == CYCLE) {
          if (btuoba(usrnum) >= outbsz-256) {
               switch (usrptr->substt) {
               case RSOP64A:
                    if (fndnxt(&rsyptr->dirblk)) {
                         dspdir();
                    }
                    else {
                         rsprom(RSSMNU);
                    }
                    break;
               case RSOP61A:
                    if (rdfile()) {
                         return;
                    }
                    usrptr->flags&=~NOINJO;
                    setmem(rsyptr->sfname,FNSIZE,0);
                    setmem(rsyptr->dfname,FNSIZE,0);
                    rsprom(RSSMNU);
                    break;
               default:
                    prf("");
               }
          }
          else {
               prf("");
               btuinj(usrnum,CYCLE);
          }
          outprf(usrnum);
     }
     else if (status == INBLK) {
          emuinp(0);
     }
     else {
          dfsthn();
     }
}

void
emuinp(                       /* emulation input handler                   */
int hangup)                   /* should a hangup be performed              */
{
     char c;

     if (usrnum == rmtsys) {
          btuict(usrnum,&c);
          if ((c == (EMUEXT&0x1F)) || hangup) {
               clremu(rmtsys);
          }
          else {
               curusr(chnemd);
               if (c == (EMUCHT&0x1F)) {
                    if (usrptr->flags&OPCHAT) {
                         lvchat();
                    }
                    else if (usrptr->class > SUPIPG) {
                         entcht();
                    }
               }
               else if (c == (EMUZAP&0x1F)) {
                    if ((usrptr->flags&NOHDWE) || (usrptr->class != VACANT)) {
                         btuinj(usrnum,RING);
                         clremu(rmtsys);
                    }
               }
               else {
                    btumks(c);
               }
          }
     }
}

void
clremu(                       /* clear emulation when done                 */
int unum)                     /* user number to deal with                  */
{
     btutrg(unum,0);
     btuscr(unum,'\n');
     rmtsys=-1;
     user[unum].flags&=~NOINJO;
     if (user[chnemd].flags&OPCHAT) {
          lvchat();
     }
     curusr(unum);
     setmbk(rsymb);
     prfmsg(RSOP51B);
     outprf(usrnum);
     usrptr->substt=RSSMNU;
     injacr();
}

STATIC int
ask4uid(                      /* does uid exist (and is he on?)            */
int on)                       /* 1=uid must be logged on. 2=any hex is ok  */
{
     int i;

     if (on) {
          if (morcnc() == '?') {
               cncall();
               lstuon();
               rsprom(usrptr->substt);
          }
          else {
               if (strlen(nxtcmd) < 3 && (i=cnchex()) != -1) {
                    if ((othusn=usridx(i)) < 0) {
                         cncall();
                         prfmsg(INVCHN);
                         rsprom(usrptr->substt);
                         return(0);
                    }
                    if (user[othusn].class != VACANT) {
                         movmem(uacoff(othusn),&rsyptr->acc,sizeof(struct usracc));
                         rsyptr->chan=othusn;
                         return(1);
                    }
                    if (on == 2 && othusn != -1) {
                         rsyptr->chan=othusn;
                         return(1);
                    }
                    cncall();
                    prfmsg(CHNACT);
                    rsprom(usrptr->substt);
                    return(0);
               }
               else if (onsysn(cncuid(),1)) {
                    movmem(othuap,&rsyptr->acc,sizeof(struct usracc));
                    rsyptr->chan=othusn;
                    return(1);
               }
               cncall();
               prfmsg(NUIDON);
               rsprom(usrptr->substt);
          }
     }
     else {
          switch (hdluid(cncall())) {
          case UIDPMT:
               rsprom(usrptr->substt);
               break;
          case UIDFND:
               setbtv(accbb);
               if (acqbtv(&rsyptr->acc,uidxrf.userid,0)) {
                    rstbtv();
                    return(1);
               }
               rstbtv();
               break;
          }
     }
     return(0);
}

void
updaxs(void)                  /* update access (leaving editing state)     */
{
     if (onsysn(rsyptr->acc.userid,1)) {
          movmem(&rsyptr->acc.access,uacoff(othusn)->access,sizeof(int)*AXSSIZ);
          if (rsyptr->acc.flags&HASMST) {
               uacoff(othusn)->flags|=HASMST;
          }
          else {
               uacoff(othusn)->flags&=~HASMST;
          }
          movmem(uacoff(othusn),&rsyptr->acc,sizeof(struct usracc));
     }
     setbtv(accbb);
     if (acqbtv(NULL,rsyptr->acc.userid,0)) {
          updbtv(&rsyptr->acc);
          prfmsg(EDTSUC);
     }
     else {
          prfmsg(EDTFAI);
     }
     rsprom(RSSMNU);
}

void
bgnmon(                       /* begin monitoring status                   */
int msg,                      /* message number to be displayed to channel */
unsigned long wch)            /* bit to be turned on                       */
{
     cncall();
     prfmsg(msg);
     usrptr->substt=RSOP52A;
     usrptr->flags|=(NOINJO+wch);
     btuech(usrnum,0);
}

void
rblwof(                       /* blow off process and return to main       */
int msg)                      /* message number to be displayed to channel */
{
     cncall();
     prfmsg(msg);
     rsprom(RSSMNU);
}

STATIC int
chksfil(                      /* check for existance of source file        */
int shut)                     /* 0=leave file open, 1=shut the file        */
{
     strcpy(rsyptr->sfname,cncall());
     if (fnamchk(rsyptr->sfname)) {
          prfmsg(FILINU);
          prfmsg(usrptr->substt);
          return(0);
     }
     if ((shut && (rsyptr->sfp=fopen(rsyptr->sfname,FOPRB)) == NULL)
         || !opfile(rsyptr->sfname)) {
          prfmsg(BADFIL,rsyptr->sfname);
          setmem(rsyptr->sfname,FNSIZE,0);
          prfmsg(usrptr->substt);
          return(0);
     }
     if (shut) {
          fclose(rsyptr->sfp);
          rsyptr->sfp=NULL;
     }
     return(1);
}

STATIC void
getfil(void)                  /* get first file name for a directory list  */
{
     strcpy(rsyptr->sfname,cncall());
     switch(*(rsyptr->sfname+(strlen(rsyptr->sfname)-1))) {
     case ':':
     case '\\':
          strcat(rsyptr->sfname,"*.*");
          break;
     default:
          if (fnd1st(&rsyptr->dirblk,rsyptr->sfname,FAMDIR)) {
               if (rsyptr->dirblk.attr&FAMDIR) {
                    if (fnd1st(&rsyptr->dirblk,
                      spr("%s\\*.*",rsyptr->sfname),FAMDIR)) {
                         strcat(rsyptr->sfname,"\\*.*");
                    }
               }
          }
     }
}

STATIC void
lstuon(void)                  /* list current users on-line                */
{
     int i,pos=0;
     struct user *uptr;
     struct usracc *aptr;

     prf("\rUsers Online:\r");
     for (i=0,uptr=user ; i < nterms ; i++,uptr++) {
          aptr=uacoff(i);
          if (uptr->class != VACANT && aptr->userid[0] != '\0') {
               prf("%-9s   ",aptr->userid);
               if (++pos == 4) {
                    prf("\r");
                    pos=0;
               }
          }
     }
     prf("\r");
}

STATIC void
sporf(void)                   /* check to see if credits are paid or free  */
{
     rsyptr->chan=0;
     switch (cncchr()) {
     case 'P':
          rsyptr->chan=1;
     case 'F':
          rsprom(RSOP71AC);
          break;
     default:
          cncall();
          rsprom(usrptr->substt);
     }
}

void
sisokq(void)                  /* verify if posting credits is OK           */
{
     switch (cncyesno()) {
     case 'N':
          cncall();
          rsprom(RSOP71);
          break;
     case 'Y':
          switch (addcrd(rsyptr->acc.userid,rsyptr->text,rsyptr->chan)) {
          case -1:
               prfmsg(MYSDEL,rsyptr->acc.userid);
          case 0:
               break;
          case 1:
               if (othusn == usrnum) {
                    prf("You got it.\r");
               }
               else {
                    prfmsg(saycrd(rsyptr->text,rsyptr->chan) ? NOTIF : CANTNO,
                            rsyptr->acc.userid);
               }
               break;
          }
          rsprom(RSOP71);
          break;
     default:
          cncall();
          rsprom(usrptr->substt);
          break;
     }
}

void
dsponl(void)                  /* display users online status               */
{
     int i;

     cncall();
     prfmsg(RSOP24);
     for (i=0 ; i < nterms ; i++) {
          othuap=uacoff(i);
          othusp=&user[i];
          if (othusp->class > SUPIPG) {
               prf("%02x %-29s %-10s %-6d %-20.20s\r",
                    channel[i],
                    othuap->userid,
                    l2as(othuap->creds),
                    (othusp->minut4/4),
                    module[othusp->state]->descrp);
          }
          else {
               switch (othusp->class) {
               case VACANT:
                    break;
               case ONLINE:
                    prf("%02x     (log-on in progress)\r",channel[i]);
                    break;
               case SUPIPG:
                    prf("%02x     (sign-up in progress)\r",channel[i]);
                    break;
               }
          }
     }
     rsprom(RSSMNU);
}

STATIC void
bgnaud(                       /* begin scanning through Audit Trail        */
int start)                    /* 0=start at beginning 1=start at end       */
{
     usrptr->flags|=NOINJO;
     rsyptr->chan=start;
     setbtv(audbb);
     if (start) {
          qlobtv(0);
     }
     else {
          qhibtv(0);
     }
     rsyptr->fpos=absbtv();
     rsprom(RSOP23A);
     begin_polling(usrnum,getaud);
}

STATIC void
getaud(void)                  /* get next audit trail record for cycling   */
{
     int success;

     if (!ok2poll()) {
          return;
     }
     setbtv(audbb);
     gabbtv(NULL,rsyptr->fpos,0);
     prf("\n%14.14s %-32.32s %-21.21s\n",
         audbb->data,audbb->data+14,audbb->data+47);
     prf("      %-64s",audbb->data+67);
     success=(rsyptr->chan ? qnxbtv() : qprbtv());
     if (success) {
          rsyptr->fpos=absbtv();
     }
     else {
          usrptr->flags&=~NOINJO;
          setmbk(rsymb);
          prfmsg(rsyptr->chan ? RSOP23B : RSOP23C);
          stop_polling(usrnum);
          rsprom(RSSMNU);
     }
     outprf(usrnum);
}

STATIC void
bgnads(void)                  /* begin account database search             */
{
     setbtv(accbb);
     slobtv(&rsyptr->acc);
     usrptr->flags|=NOINJO;
     rsyptr->fpos=absbtv();
     rsprom(RSOP25D);
     begin_polling(usrnum,scnacc);
}

STATIC void
scnacc(void)                  /* scan account and find next one for        */
{                             /*    account database search cycling        */
     if (!ok2poll()) {
          return;
     }
     setmbk(rsymb);
     setbtv(accbb);
     gabbtv(&rsyptr->acc,rsyptr->fpos,0);
     switch (rsyptr->chan) {
     case 1:
          chkstg(rsyptr->acc.userid);
          break;
     case 2:
          chkstg(rsyptr->acc.psword);
          break;
     case 3:
          chkstg(rsyptr->acc.usrnam);
          break;
     case 4:
          chkstg(rsyptr->acc.usrad1);
          break;
     case 5:
          chkstg(rsyptr->acc.usrad2);
          break;
     case 6:
          chkstg(rsyptr->acc.usrad3);
          break;
     case 7:
          chkstg(rsyptr->acc.usrpho);
          break;
     case 8:
          chkstg(sysstg[rsyptr->acc.systyp]);
          break;
     case 9:
          chkint(rsyptr->acc.age);
          break;
     case 10:
          if (toupper(rsyptr->text[0]) == rsyptr->acc.sex) {
               prfmsg(RSOP25E,rsyptr->acc.userid,rsyptr->acc.usrnam);
          }
          break;
     case 11:
          chkstg(rsyptr->acc.curcls);
          break;
     case 12:
          chkcrd(rsyptr->acc.totcreds);
          break;
     case 13:
          chkcrd(rsyptr->acc.totpaid);
          break;
     case 14:
          chkcrd(rsyptr->acc.creds);
          break;
     case 15:
          chkdat(rsyptr->acc.credat);
          break;
     case 16:
          chkdat(rsyptr->acc.usedat);
          break;
     }
     if (snxbtv(&rsyptr->acc)) {
          rsyptr->fpos=absbtv();
          prf("");
     }
     else {
          usrptr->flags&=~NOINJO;
          prfmsg(RSOP25F);
          stop_polling(usrnum);
          rsprom(RSSMNU);
     }
     outprf(usrnum);
}

STATIC void
chkstg(stg)                        /* check string for account search */
char *stg;
{
     if (findstg(rsyptr->text,stg)) {
          prfmsg(RSOP25E,rsyptr->acc.userid,rsyptr->acc.usrnam);
     }
}

STATIC void
chkint(                            /* check int for account search         */
int numb)                          /* number to compare against search crit*/
{
     int a,retval=0;

     a=atoi(rsyptr->text);
     retval=glthrv[rsyptr->genctr-1]
                  [(numb >= a ? 1 : 0)+(numb > a ? 1 : 0)];
     if (retval) {
          prfmsg(RSOP25E,rsyptr->acc.userid,rsyptr->acc.usrnam);
     }
}

void
chkdat(                            /* check date for account search        */
int date)                          /* date to compare against search crit  */
{
     int a,retval=0;

     a=dcdate(rsyptr->text);
     retval=glthrv[rsyptr->genctr-1]
                  [(date >= a ? 1 : 0)+(date > a ? 1 : 0)];
     if (retval) {
          prfmsg(RSOP25E,rsyptr->acc.userid,rsyptr->acc.usrnam);
     }
}

void
chkcrd(                            /* check credits for account search     */
long credits)                      /* amount to compare against search crit*/
{
     int retval=0;
     long a;

     a=atol(rsyptr->text);
     retval=glthrv[rsyptr->genctr-1]
                  [(credits >= a ? 1 : 0)+(credits > a ? 1 : 0)];
     if (retval) {
          prfmsg(RSOP25E,rsyptr->acc.userid,rsyptr->acc.usrnam);
     }
}

void
xltescp(void)                 /* translate ctrl chars to up-arrow seqs     */
{                             /* for remote sysop setting logon message    */
     char *lptr,*aptr,c;

     setmem(rsyptr->text,MTXSIZ,0);
     rsyptr->text[0]='\r';
     for (lptr=sv.lonmsg,aptr=rsyptr->text+1 ; *lptr != '\0' ; lptr++) {
          if ((c=*lptr) < ' ' && c != '\r') {
              *aptr++='^';
              *aptr++=c|0x40;
          }
          else {
               *aptr++=c;
          }
     }
}

STATIC void
prfaxlin(                          /* print one line of remote menu        */
struct usracc *uacptr,             /* pointer to user account to display   */
int msg,                           /* message to display                   */
int b1,int b2, int b3, int b4)     /* bit positions to check               */
{
     static char *arrow="=>",*space="  ";

     prfmsg(msg,(axs4op(uacptr,b1) ? arrow : space),
                (axs4op(uacptr,b2) ? arrow : space),
                (axs4op(uacptr,b3) ? arrow : space),
                (axs4op(uacptr,b4) ? arrow : space));
}

void
prfaxs(                            /* print access-marked sysop menu       */
struct usracc *uacptr)             /* pointer to user account to display   */
{
     prfaxlin(uacptr,AXSM10,11,41,12,42);
     prfaxlin(uacptr,AXSM11,13,43,44,00);
     prfaxlin(uacptr,AXSM12,71,22,51,00);
     prfaxlin(uacptr,AXSM13,23,52,24,53);
     prfaxlin(uacptr,AXSM14,25,54,31,61);
     prfaxlin(uacptr,AXSM15,32,62,33,63);
     prfaxlin(uacptr,AXSM16,34,64,35,65);
     prfaxlin(uacptr,AXSM17,36,66,73,67);
}

STATIC int
axs4op(                            /* does user have access to this op?    */
struct usracc *uacptr,             /* pointer to user account to check     */
int op)                            /* operation to check access to         */
{
     if (sameas(uacptr->userid,"Sysop")
       || (op == 99 && usrptr->flags&MASTER)) {
          return(1);
     }
     return(uacptr->access[op>>4]&(1<<(op%16)));
}

STATIC void
togaxs(                            /* toggle user's access to this op      */
struct usracc *uacptr,             /* pointer to user account to toggle    */
int op)                            /* operation to toggle access to        */
{
     int opdiv,opmod;

     opdiv=op>>4;
     opmod=op%16;
     if (axs4op(uacptr,op)) {
          uacptr->access[opdiv]&=~(1<<opmod);
     }
     else {
          uacptr->access[opdiv]|=(1<<opmod);
     }
}

STATIC int
isvalop(                           /* is this a valid op?                  */
char *opstg)                       /* option name to check                 */
{
     int i;

     for (i=0 ; i < sizeof(valops)/sizeof(struct valop) ; i++) {
          if (sameas(valops[i].opname,opstg)) {
               op=valops[i].op;
               return(valops[i].msgstt);
          }
     }
     return(0);
}

void
clsfils(void)                 /* close open files if they are open         */
{
     if (rsyptr->sfp != NULL) {
          fclose(rsyptr->sfp);
          rsyptr->sfp=NULL;
          setmem(rsyptr->sfname,FNSIZE,0);
     }
     if (rsyptr->dfp != NULL) {
          fclose(rsyptr->dfp);
          rsyptr->dfp=NULL;
          setmem(rsyptr->dfname,FNSIZE,0);
     }
}

int
fnamchk(                      /* go through file names checking for use    */
char *touse)                  /* name of file to check to see if in use    */
{
     int i=0;

     while (i < nterms) {
          if (i != usrnum && user[i].state == rmsyst) {
               if (ckfnams(touse,remoff(i)->sfname)
                 || ckfnams(touse,remoff(i)->dfname)) {
                    return(1);
               }
          }
          i++;
     }
     return(0);
}

/* class-based Stuff */

STATIC void
chkkey(                            /* check proposed key name & add if ok  */
int remove)                             /* remove if there? (1 or 0)       */
{
     static char key[KEYSIZ];

     strcpy(key,cncall());
     if (!keynam(key)) {
          prfmsg(BADKEY);
     }
     else if (remove) {
          rmvkey(rsyptr->text,key);
          prfmsg(OKGONE);
     }
     else if (!givkey(rsyptr->text,key)) {
          prfmsg(NOSKEY);
     }
     else {
          prfmsg(OKKEY);
     }
     rsprom(RSOP71JM);
}

STATIC void
impkey(                            /* import one keyring into another      */
int remove)                             /* remove the list? (1 or 0)       */
{
     char keyring[UIDSIZ];
     int len;

     keyring[0]=RINGID;
     strcpy(keyring+1,cncall());
     if (namacls(keyring+1)) {
          if (getlst(keyring,NULL)) {
               len=strlen(&kysbuf[KLSTOF])+1;
               movmem(&kysbuf[KLSTOF],vdatmp,len);
               if (remove) {
                    rmvkey(rsyptr->text,vdatmp);
               }
               else {
                    if (!givkey(rsyptr->text,vdatmp)) {
                         prfmsg(RSOP71JU);
                         return;
                    }
               }
               prfmsg(remove ? OKDKRR : OKDKRA);
          }
          else {
               prfmsg(NOSKYR);
          }
     }
     else {
          prfmsg(INVKYR);
     }
     rsprom(RSOP71JM);
}

STATIC char *
setdft(c)                          /* show default selection for class     */
char c;
{
     int tmp;
     char *ptr=NULL;

     if (!(rsyptr->flags&EDTCLS) || c != '.') {
          return(NULL);
     }
     switch (usrptr->substt) {
     case RSOP71J1:
          ptr=rclsptr->limcal == -1 ? "UNLIMITED" : spr("%d",rclsptr->limcal);
          break;
     case RSOP71J2:
          ptr=rclsptr->limday == -1 ? "UNLIMITED" : spr("%d",rclsptr->limday);
          break;
     case RSOP71J3:
          ptr=(rclsptr->flags&KCKOFF) ? "1" : "2";
          break;
     case RSOP71J4:
          ptr=rclsptr->nxtcls[0];
          break;
     case RSOP71J5:
          ptr=rclsptr->msgs[0][0] != '\0' ? "Yes" : "No";
          break;
     case ROP71J7A:
          ptr=rclsptr->flags&CRDXMT ? "Yes" : "No";
          break;
     case RSOP71J8:
          ptr=rclsptr->dbtlmt != 0L ? "Yes" : "No";
          break;
     case RSOP71J9:
          if (rclsptr->dbtlmt) {
               ptr=rclsptr->dbtlmt < 0L ? "UNLIMITED" : l2as(rclsptr->dbtlmt);
          }
          break;
     case RSOP71JA:
          tmp=rclsptr->flags;
          ptr=(tmp&FSTMTH) ? "1" : (tmp&MONDAY) ? "2" :
                              (tmp&NUMDAY) ? "3" : (tmp&HITLMT) ? "4" : "5";
          break;
     case RSOP71JB:
          ptr=rclsptr->fgvday < 1 ? "7" : spr("%d",rclsptr->fgvday);
          break;
     case RSOP71JG:
          ptr=rclsptr->idlday < 1 ? "60" : spr("%d",rclsptr->idlday);
          break;
     case RSOP71JH:
          ptr=rclsptr->dftday < 1 ? "30" : spr("%d",rclsptr->dftday);
          break;
     case RSOP71JI:
          tmp=(rsyptr->chan > 2 ? 3 : rsyptr->chan);
          if (rclsptr->nxtcls[tmp][0] != '\0') {
               ptr=rclsptr->nxtcls[tmp];
          }
          break;
     case RSOP71JJ:
          ptr=rclsptr->msgs[1][0] != '\0' ? "Yes" : "No";
          break;
     }
     return(ptr);
}

void
shwdft(void)                       /* show default selection for class     */
{
     char *ptr;

     if (!(rsyptr->flags&EDTCLS) || rsyptr->dftinp != '.') {
          return;
     }
     if ((ptr=setdft(rsyptr->dftinp)) != NULL) {
          prfmsg(DFTSEL,ptr);
     }
}

void
dspcll(void)                       /* display a rough list of classes      */
{
     if (clshead != NULL) {
          prfmsg(RSOP71JO);
          for (clsptr=clshead ; clsptr != NULL ; clsptr=clsptr->next) {
               if (!(clsptr->flags&HASCRD && clsptr->flags&NOCRED)) {
                    prf("%-15.15s ",clsptr->clname);
               }
          }
          prf("\r");
     }
     else {
          prfmsg(NOCLSS);
     }
}

STATIC void
dspkys(                            /* display a rough list of keys in list */
char *keyr,                             /* keyring name to display (or UID)*/
int ring)                               /* is it a keyring? (0 or 1)       */
{
     int i=0;
     char *bas,*ptr,keyring[UIDSIZ];

     if (ring) {
          keyring[0]=RINGID;
          strcpy(keyring+1,keyr);
          if (!namacls(keyring+1)) {
               prfmsg(INVKYR);
               return;
          }
     }
     else {
          strcpy(keyring,keyr);
     }
     if (!getlst(keyring,NULL)) {
          prfmsg(ring ? NOSKYR : UNOTEX2);
          return;
     }
     ptr=&kysbuf[KLSTOF];
     prfmsg(ring ? RSOP71JR : UIDKYS,keyr);
     while (1) {
          bas=ptr;
          while (*ptr != ' ') {
               if (*ptr++ == '\0') {
                    prf("%-16.16s\r",bas);
                    return;
               }
          }
          *ptr='\0';
          prf("%-16.16s ",bas);
          *ptr++=' ';
          if (++i > 3) {
               prf("\r");
               i=0;
          }
     }
}

STATIC int
canedt(void)                       /* can this guy edit a class right now? */
{
     int i=-1;

     while (++i < nterms) {
          if (i != usrnum && (user[i].state == rmsyst || inedit(i,dwedtj5) ||
              inedit(i,dwedtjj))) {
               if (remoff(i)->flags&(EDTCLS|CRTCLS)) {
                    return(0);
               }
          }
     }
     return(1);
}

STATIC int
ok2poll(void)                      /* enough space to prf for a pollrou?   */
{
     return(btuoba(usrnum) >= outbsz-256);
}

STATIC int
dnlmnu(on)                         /* download BBSMNU.DAT (start or end)   */
int on;                                 /* are we beginning or ending?     */
{
     extern BTVFILE *mnubb;

     if (on && mnudnl == usrnum) {      /* trying a download again...      */
          return(1);
     }
     if ((on && mnudnl != -1) || (!on && mnudnl != usrnum)) {
          return(0);
     }
     if (on) {
          clsbtv(mnubb);
          chmod("BBSMNU.DAT",S_IREAD);
          omdbtv(RONLBV);
          mnubb=opnbtv("bbsmnu.dat",sizeof(struct menupag));
          omdbtv(PRIMBV);
          mnudnl=usrnum;
     }
     else {
          clsbtv(mnubb);
          chmod("BBSMNU.DAT",S_IREAD|S_IWRITE);
          mnubb=opnbtv("bbsmnu.dat",sizeof(struct menupag));
          mnudnl=-1;
     }
     return(1);
}

