/***************************************************************************
 *                                                                         *
 *   MJREXIT.C                                                             *
 *                                                                         *
 *   Copyright (C) 1987-1990 GALACTICOMM, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   This is the Major BBS default user-exit handler.                      *
 *                                                                         *
 *                                            - T. Stryker 6/28/86         *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"
#include "majorbbs.h"
#include "bbsmajor.h"

void EXPORT init__exit(void);
int xitter(void);
int finlof(void);

struct module exit_bbs={      /* module interface block               */
     "",                      /*    name used to refer to this module */
     NULL,                    /*    user logon supplemental routine   */
     xitter,                  /*    input routine if selected         */
     dfsthn,                  /*    status-input routine if selected  */
     NULL,                    /*    "injoth" routine for this module  */
     finlof,                  /*    user logoff supplemental routine  */
     NULL,                    /*    hangup (lost carrier) routine     */
     NULL,                    /*    midnight cleanup routine          */
     NULL,                    /*    delete-account routine            */
     NULL                     /*    finish-up (sys shutdown) routine  */
};

extern
FILE *mjrmb;                  /* executive named-message file block ptr    */

void EXPORT
init__exit(void)                   /* initialize exit module               */
{
     stzcpy(exit_bbs.descrp,gmdnam("GALXIT.MDF"),MNMSIZ);
     register_module(&exit_bbs);
}

int
xitter(void)                       /* exit handler                         */
{
     bgnlof();
     return(1);
}

int
finlof(void)                       /* finish off logoff procedure          */
{
     setmbk(mjrmb);
     if (usrptr->substt == 0 || margc == 0) {
          prfmsg(hasmkey(RLGKEY) ? RUSXITL : RUSXITN);
          outprf(usrnum);
          usrptr->substt=1;
     }
     else {
          switch (lingyn(margv[0][0])) {
          case 'Y':
               byenow(SEEYA);
               break;
          case 'R':
               if (hasmkey(RLGKEY)) {
                    btuinj(usrnum,RELOG);
                    break;
               }
          default:
               return(0);
          }
     }
     return(1);
}
