/***************************************************************************
 *                                                                         *
 *   MAJORBBS.H                                                            *
 *                                                                         *
 *   Copyright (C) 1987-1994 GALACTICOMM, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   This is the main Major BBS header file.                               *
 *                                                                         *
 *                                            - T. Stryker 6/24/86         *
 *                                                                         *
 ***************************************************************************/

#include "brkthu.h"
#include "locknkey.h"
#include "usracc.h"
#include "autorip.h"

#define BBSVER        621     /* BBS underlying version code               */
#define BBSIRV        "f"     /* BBS underlying internal "rev" code        */

#define INPSIZ        256     /* input buffer size for each channel        */
#define OUTSIZ     outbsz     /* config parameter: output buffer size/chan */
#define MTXSIZ        400     /* maximum message-text string size          */
#define DFTIMX        127     /* default input-char count maximum per line */
#define NCOMTY          8     /* number of computer type codes             */
#define NAGEBK          5     /* number of age brackets tallied            */
#define AUDSIZ        132     /* size of audit trail records               */
#define CTNUOS          2     /* screen length code used for "continuous"  */
#define XTRIES         10     /* number of times to inject X's fo "go" cmd */
#define TVRSIZ         16     /* maximum size of a text variable name      */
#define MAXSEL         25     /* maximum number of selections per page     */
#define FNMSIZ         80     /* maximum size of a file (with path)        */
#define PNMSIZ         16     /* maximum size for menu page names          */
#define MNMSIZ         25     /* maximum size for module names             */
#define CMDSIZ         60     /* maximum size for command strings          */
#define SHDSIZ         31     /* maximum size for short descriptions       */
#define TITLSZ         43     /* maximum size for menu page titles         */
#define NGROUPS        17     /* number of channel groups fm BBSMAJOR.MSG  */
#define TPERSC         18     /* real-time irpts/sec (== Flash rate)       */
#define MAXXRF         16     /* maximum # of displayed possible uid x-refs*/
#define GENSIZ       8192     /* maximum size of a generic user dbase rec  */
#define ZAPINT          5     /* interval to decrement zaptbl values       */
#define ZAPMAX         60     /* max value of a zaptbl entry               */

int
bgnedt(int,char *,int,char *,int (*)(),int);      /* System editor call    */
                              /* flags that can be passed to bgnedt()      */
#define ED_FILIMP       1     /*   allow importing from DOS files          */
#define ED_READON       2     /*   "read only" mode                        */
#define ED_CLRTOP       4     /*   clear topic buffer upon entry           */
#define ED_CLRTXT       8     /*   clear text buffer upon entry            */
#define ED_FILESD      16     /*   use "file" flavor of editor             */
#define ED_LINEMO      32     /*   force use of the line editor            */
#define ED_FIXTOP      64     /*   don't allow changing of the topic field */

                              /* flags passed to the editor's whndun() rou */
#define ED_QUITEX     256     /*   user quit the editing session           */

int inedit(int usn,int (*exipnt)());    /* is this user editing from here? */

struct user {                 /* volatile per-user info maintained         */
     int class;               /*    class (offline, or flavor of online)   */
     int *keys;               /*    dynamically alloc'd array of key bits  */
     int state;               /*    state (module number in effect)        */
     int substt;              /*    substate (for convenience of module)   */
     int lofstt;              /*    state which has final lofrou() routine */
     int usetmr;              /*    usage timer (for nonlive timeouts etc) */
     int minut4;              /*    total minutes of use, times 4          */
     int countr;              /*    general purpose counter                */
     int pfnacc;              /*    profanity accumulator                  */
     unsigned long flags;     /*    runtime flags                          */
     unsigned baud;           /*    baud rate currently in effect          */
     int crdrat;              /*    credit-consumption rate                */
     int nazapc;              /*    no-activity auto-logoff counter        */
     int linlim;              /*    "logged in" module loop limit          */
     struct clstab *cltptr;   /*    pointer to guys current class in table */
     void (*polrou)();        /*    pointer to current poll routine        */
     char lcstat;             /*    LAN chan state (IPX.H) 0=nonlan/nonhdw */
};

struct extusr {               /* extra volatile per-user info              */
     int lingo;               /*    user language, 0 to nlingo-1 (LINGO.H) */
     char col;                /*    current column for secret char echo    */
     char wid;                /*    line width for secret char echo        */
     char ech;                /*    character to echo for secret char echo */
};

extern
struct usrmnu {               /* user's menuing-specific variables         */
     char curpag[PNMSIZ];     /*    current menu page                      */
     char parpag[PNMSIZ];     /*    parent menu page                       */
     char selchrs[MAXSEL];    /*    select characters currently available  */
     char pages[MAXSEL][PNMSIZ]; /* pages or file names for select chars   */
     char optdsp[MAXSEL];     /*    instructions on how to display options */
     int keyreq[MAXSEL];      /*    key required for each select character */
     FILE *fp;                /*    pointer to file currently being viewed */
     char mnuttl[TITLSZ];     /*    menu page title                        */
} *mnuusr;

extern
struct menupag {              /* menu page data structure (btrieve layout) */
     char pagnam[PNMSIZ];     /*    menu page name                         */
     char parpag[PNMSIZ];     /*    parent menu page                       */
     char fname[FNMSIZ];      /*    file name for menus and displayed files*/
     char selchrs[MAXSEL];    /*    select characters currently available  */
     char pages[MAXSEL][PNMSIZ];/*  destination pages for select chars     */
     char optdsp[MAXSEL];     /*    instructions on how to display options */
     char keyreq[MAXSEL][KEYSIZ];/* key required for each select character */
     char shortd[MAXSEL][SHDSIZ];/* short descriptions for each option     */
     char modnam[MNMSIZ];     /*    module name to enter (if a module lnk) */
     char cmdstg[CMDSIZ];     /*    command string for entry to module     */
     char golock[KEYSIZ];     /*    lock placed on "go"ing to this page    */
     int flags;               /*    flags for things like cond'l/mod pages */
     char mnuttl[TITLSZ];     /*    menu page title                        */
     char spare[127];         /*    spare space for future expansion       */
} *mnupag;

#define AUTPAG      1              /*    auto-select page                  */
#define MDLPAG      2              /*    module link page                  */
#define FILPAG      4              /*    file display page                 */
#define CNGOTO      8              /*    can "go" to this page             */
#define DFTDSP     16              /*    use default menu display          */
#define DISABL     32              /*    page is currently disabled        */
#define TPOTRE     64              /*    page is top of a menu tree        */
#define NOMPHD    128              /* don't dsp module pag hdr if mod page */
#define NOFPHD    256              /* don't dsp file pag hdr if file page  */

extern int mnudnl;                 /* user # downloading BBSMNU.DAT (or -1)*/

                                   /* user class codes                     */
#define VACANT 0                   /*    vacant, offline                   */
#define ONLINE 1                   /*    online, not logged on             */
#define BBSPRV 2                   /*    online, private class (internal)  */
#define SUPIPG 3                   /*    signup in progress                */
#define SUPLON 4                   /*    supplemental logon in progress    */
#define SUPLOF 5                   /*    supplemental logoff in progress   */
#define ACTUSR 6                   /*    logged on and active in a class   */

                         /* VACANT class state codes:                      */
#define JSTRST   0       /* just reset, awaiting command confirmation      */
#define EMTATZ  -1       /* emitting ATZ, awaiting completion              */
#define EKLVEC  -2       /* emitting kill-vector, awaiting completion      */
#define W4KILL  -3       /* waiting for kill-system to take effect         */
#define ATZDUN  -4       /* ATZ OK received, waiting 1/10 sec extra        */
#define ESTVEC  -5       /* emitting startup string, awaiting completion   */
#define W4ISOK  -6       /* waiting for OK in response to init string      */
#define AWAITC  -7       /* awaiting call                                  */
#define XERING  -8       /* XE1201/3 phone rang, answered, awaiting carrier*/
#define HARING  -9       /* Hayes-style phone rang, answd, awaiting carrier*/
#define HPAUSE -10       /* Hayes-style post-connect 2-second pause        */
#define AUTSNS -11       /* Auto sensors doing their stuff (AUTSNS.C)      */
#define WAIT29 -20       /* wait to be able to send X.29 string            */
#define W4SPXT -21       /* wait for old SPX session to terminate          */

                                   /* standard profanity thresholds        */
#define WRNPFN 7                   /*    warning level                     */
#define MAXPFN 12                  /*    logoff level                      */

                                   /* user runtime flag bit values         */
#define NOINJO 0x00000001L         /*    unable to receive injoth() msgs   */
#define INJOIP 0x00000002L         /*    injoth() operation in progress    */
#define BYEBYE 0x00000004L         /*    going away, just wait for msg done*/
#define NOHDWE 0x00000008L         /*    no hardware, emulation chan only  */
#define OPCHAT 0x00000010L         /*    chatting-with-sysop flag          */
#define ACTIVE 0x00000020L         /*    channel-is-active (gen'ing status)*/
#define MASTER 0x00000040L         /*    user has the "master key" flag    */
#define IS2698 0x00000080L         /*    channel-is-2698 (XE2400)          */
#define NOZAP  0x00000100L         /*    don't logoff freeloader flag      */
#define ISRIAL 0x00000200L         /*    channel-is-serial-port            */
#define X2MAIN 0x00000400L         /*    exit-to-main-menu when sysop chat */
#define CONCEX 0x00000800L         /*    commands concatenated -- exit fast*/
#define ISX25  0x00001000L         /*    channel-is-X.25                   */
#define NOGLOB 0x00002000L         /*    don't interpret global commands   */
#define INVISB 0x00004000L         /*    user is "invisible" to others     */
#define ABOIP  0x00008000L         /*    abort output in-progress          */
#define MONALL 0x00010000L         /*    monitor all in progress           */
#define MONINP 0x00020000L         /*    monitor input in progress         */
#define ONEMIN 0x00040000L         /*    got one-min. warning of logoff    */
#define NON550 0x00080000L         /*    real hardware isn't 16550         */
#define IS1201 0x00100000L         /*    Model 16 or 4, using XECOM 1201's */

                              /* Special GSBL status codes:                */
#define FSESTS       191      /* FSE status cycle code                     */
#define POLSTS       192      /* polling status code (like CYCLE, but auto)*/

#define CLOX29       230      /* btux29() call produced window-full error  */
#define ERRX29       231      /* btux29() produced some other fatal error  */
#define CYCLE        240      /* cycle-thru-other-users pseudo-status code */
#define RELOG        241      /* re-log-in pseudo-status code              */

extern
struct module {                    /* module interface block               */
     char descrp[MNMSIZ];          /*    description for main menu         */
     int (*lonrou)();              /*    user logon supplemental routine   */
     int (*sttrou)();              /*    input routine if selected         */
     void (*stsrou)();             /*    status-input routine if selected  */
     int (*injrou)();              /*    "injoth" routine for this module  */
     int (*lofrou)();              /*    user logoff supplemental routine  */
     void (*huprou)();             /*    hangup (lost carrier) routine     */
     void (*mcurou)();             /*    midnight cleanup routine          */
     void (*dlarou)();             /*    delete-account routine            */
     void (*finrou)();             /*    finish-up (sys shutdown) routine  */
} **module;

extern int nmods;                  /* number of modules currently online   */

extern
struct mdstats {                   /* module statistics data structure     */
     char mdname[MNMSIZ];          /*   name of module (key for btrieve)   */
     unsigned long seconds;        /*   number of hours consumed in module */
     unsigned long creds;          /*   number of creds consumed in module */
     char spare[60-33];            /*   spare space for future additions   */
} *mdstats;

extern
struct textvar {                   /* text variable structure              */
     char name[TVRSIZ];            /*   name of text variable              */
     char *(*varrou)();            /*   pointer to text variable function  */
} *txtvars;

extern int ntvars;                 /* number of text variables in memory   */

extern
struct sysvbl {                    /* system-variable btrieve record layout*/
     char key[4];                  /*    4-character dummy key of "key"    */
     char dspopt[6];               /*    display options by position number*/
     long calls[8];                /*    number of calls this month/baud rt*/
     char lonmsg[MTXSIZ];          /*    log-on message in effect          */
     long dwnlds;                  /*    total downloads to date           */
     long uplds;                   /*    total uploads to date             */
     long msgtot;                  /*    msg (E-mail/Forums) total to date */
     unsigned emlopn;              /*    E-Mail open at the moment         */
     unsigned sigopn;              /*    Forum messages open at the moment */
     int hisign;                   /*    highest Forum number used to date */
     char monmal;                  /*    Aux. CRT display selector         */
     char savmin;                  /*    Minutes to save screen            */
     long oldsec[8][24];           /*    old sec/grp/hr (now in sv3.secghr)*/
     char spare[1300-1230];        /*    spare space for graceful upgrades */
} sv;

extern
struct sysvb2 {                    /* second system variable btrieve layout*/
     char ky2[4];                  /*    4-character dummy key of "ky2"    */
     unsigned matrix[NCOMTY][NAGEBK];   /*   matrix of accts (computer/age)*/
     long oldcrd[8][24];           /*    old crd/grp/hr (now in sv3.crdghr)*/
     int nliniu[48];               /*    number of lines in use per hlf/hr */
     int lstzer;                   /*    date of last zeroing of stats     */
     long x25kps;                  /*    X.25 kilopackets sent or received */
     unsigned x25ps;               /*    fractional X.25 kilopackets       */
     long x25mbs;                  /*    X.25 megabytes sent or received   */
     long x25bs;                   /*    fractional X.25 megabytes         */
     unsigned numact;              /*    total number of user accounts     */
     unsigned numfem;              /*    number of female users            */
     unsigned numcor;              /*    number of corporate users         */
     unsigned numans;              /*    number of ANSI users              */
     unsigned long paidpst;        /*    credits paid-for so far           */
     unsigned long freepst;        /*    credits given away free so far    */
     long totcalls;                /*    total calls-to-date               */
     int lastmcu;                  /*    date of last midnight cleanup     */
     char spare[1300-986];         /*    spare space for graceful upgrades */
} sv2;

extern
struct sysvb3 {                    /* third system variable btrieve layout */
     char ky3[4];                  /*    4-character dummy key of "ky3"    */
     long secghr[NGROUPS-1][24];   /*    seconds used (channel grp/hr)     */
     long crdghr[NGROUPS-1][24];   /*    credits consumed (channel grp/hr) */
} sv3;

extern int digalw;                 /* digits allowed in User-IDs?          */

#define   UIDFND     0             /* hdluid(): found user-id              */
#define   UIDPMT    -1             /* hdluid(): uid not found: re-prompt   */
#define   UIDCAL    -2             /* hdluid(): uid not found: call again  */

extern
int nterms,                   /* this many simultaneous users are supported*/
    hichp1,                   /* highest channel number in use, plus 1     */
    usrnum,                   /* global user-number (channel) in effect    */
    othusn,                   /* general purpose other-user channel number */
    uisusn;                   /* uinsys() other-user channel number        */
extern
struct user *user,            /* user volatile-data structure array        */
            *usrptr,          /* global pointer to user data in effect     */
            *othusp;          /* gen purp other-user user structure ptr    */

extern
struct extusr *extptr,        /* global pointer to extra info about cur usr*/
              *othexp;        /* gen purp other-user user structre ptr     */

extern int *channel;          /* array of channel codes (as displayed)     */

extern volatile unsigned ticker; /* seconds-ticker from brkthu             */

extern int *grpnum;           /* array of group numbers, by channel number */

extern char chanty[];         /* array of btusdf() codes for LAN chan grps */
extern char grtype[];         /* array of Group Type codes:                */
extern char version[];        /* main version code, in form X.YY           */
extern char subvers[];        /* sub-version info, ext ed rls letters      */

extern char *startv[NGROUPS]; /* array of pointers to startup AT-commands  */

#define GTMODEM  1            /* group type code:  Modem channels          */
#define GTMLOCK  2            /* group type code:  Locked modem channels   */
#define GTSERIAL 3            /* group type code:  Serial channels         */
#define GTX25    4            /* group type code:  X.25 channels           */
#define GTLAN    5            /* group type code:  LAN channels            */
#define GTNONE   0            /* group type code:  No channels             */

extern char *chantn[];        /* LAN channel type names                    */

extern
char input[INPSIZ],           /* raw user input data buffer                */
     *margv[INPSIZ/2],        /* array of ptrs to word starts, a la argv[] */
     *margn[INPSIZ/2],        /* array of ptrs to word ends, for rstrin()  */
     *nxtcmd;                 /* pointer to next char for command concat.  */
extern
int margc,                    /* number of words in margv[], a la argc     */
    inplen,                   /* overall raw input string length           */
    pfnlvl,                   /* profanity level of current input (0-3)    */
    status,                   /* raw status from btusts, where appropriate */
    shortm,                   /* display short (0) or long (1) menus on x? */
    numcat;                   /* number of concat'd commands so far        */

#define GLBMAX 25             /* max number of global command handlers     */

extern
int nglobs,                   /* # of global command handlers in operation */
    (*globs[GLBMAX])();       /* array of ptrs to glbl cmd hdlr functions  */
extern
void (*hdlcon)();             /* "handle connect" function pointer -- if   */
                              /* calling this rou, don't do anything after-*/
                              /* wards.  Save what's in this ptr and       */
                              /* replace it (like an interrupt handler) to */
                              /* do something special at connect time.     */
                              /* ditto for these next three:               */
extern
void (*hdlc25)();             /* handle incoming X.25 call string (margv)  */
extern
void (*hdlnrg)();             /* handle non-RING strings during AWAITC     */
extern
void (*hdlrng)();             /* handle RING (non X25) during AWAITC,HARING*/
extern
int (*hdlcnc)();              /* handle non-RING whatever during HARING    */
                              /* return 1=connect, 0=reset, -1=ignore      */
extern
int (*gomvec)();              /* vector for cmd stg handling in gomodl()   */

extern jmp_buf eximod;        /* exit-module longjmp save block            */

#define PFBSIZ      outbsz    /* size of prfbuf variable                   */

extern int emubel;            /* emulation bell period                     */
extern int vdasiz;            /* max. size requirement of volatile data    */
extern char *vdarea;          /* pointer to first vda element (bkwd. comp.)*/
extern
char *vdaptr,                 /* user's pointer to volatile data area      */
     *vdatmp;                 /* general-purpose temporary vda-size area   */
extern
char *sysstg[],               /* system type description strings           */
     *ansstg[],               /* ANSI support flavor strings               */
     *syskey;                 /* key distinguishing sysop-types            */

extern
unsigned syslod;              /* system loading (1 percent units)          */
extern
unsigned long sysinj;         /* time of injection for system loading      */
extern
int slmeas;                   /* flag that measurement is taking place     */

extern
void (*tjoinrou)(),           /* teleconference "join from other" rouptr   */
     (*ntfysopr)(char *audrec),    /* notify remote sysop routine          */
     (*emlsdrou)();           /* Send Email to Sysop/ New User routine     */

extern
BTVFILE *genbb;               /* generic user data file btrieve file ptr   */

struct bbsgen {               /* generic user data records for main exec   */
     char userid[UIDSIZ];          /* User-ID                              */
     char modnam[MNMSIZ];          /* Module Name ("Main Executive")       */
     char lngnam[LNGSIZ];          /* default language name                */
                                   /* (add fields here, default to all-0's)*/
};
#define BBSGMX "Main Executive" /* 2nd field of all "struct bbsgen" rec'ds */

extern
char *bbsttl,                 /* Title of your BBS                         */
     *company,                /* Your company name                         */
     *addres1,                /* Address                                   */
     *addres2,                /* Address                                   */
     *dataph,                 /* The first phone line connected to BBS     */
     *liveph,                 /* The first phone line reserved 4 live users*/
     *chghour,                /* Connect time charge per hour              */
     *chgmin,                 /* Minimum charge                            */
     *chgtime,                /* Minimum connect time                      */
     *mmuatr,                 /* default attribute for main menu selections*/
     *ansdim;                 /* dimmed attribute for main menu selections */

extern
int outbsz,                   /* output buffer size per channel            */
    mmucrr,                   /* Main menu credit consumption rate per min */
    rsmode,                   /* reset-mode code for channels              */
    *rsmodes,                 /* reset-mode array by channel number        */
#define NORMRS 0              /*   normal reset                            */
#define BUSYRS 'B'            /*   busy-out                                */
#define NANSRS 'N'            /*   no-answer                               */
    vispsw,                   /* make passwords visible in detail displays?*/
    maxcat,                   /* maximum number of concat'd commands       */
    svrate;                   /* how many seconds between saving sysvbls?  */

extern char eurmsk;           /* 0x7F if U.S.A. only, 0xFF if European     */
extern int nlocks;            /* number of currently accounted for in mem  */
extern char **locks;          /* in-memory array of locks accounted for    */
extern char btrset[80];       /* parameters we're passing to Btrieve       */

extern int multsk;            /* is a multitasker being used?              */
extern int mulmth;            /* if multitasking what method is used       */

                              /* methods used when multitasker is used     */
#define TIMER  1              /*   using alternate timer source method     */
#define COMIRP 2              /*   using COM port interrupt method         */

extern
struct bbsgen genbuf;    /* for reading Main Exec records from BBSGEN.DAT  */

void joint(unsigned chan);    /* teleconference entry pt for other modules */

/*** Signup question indexes ***/

#define TBLLNG 1                   /* language preference                  */
#define TBLANS 2                   /* can you display ANSI graphics?       */
#define TBLNAM 3                   /* what's your real name?               */
#define TBLAD1 4                   /* what's your address? (line 1)        */
#define TBLAD2 5                   /* what's your address? (line 2)        */
#define TBLAD3 6                   /* what's your address? (line 3)        */
#define TBLAD4 7                   /* what's your address? (line 4)        */
#define TBLPHO 8                   /* what's your phone number?            */
#define TBLSYS 9                   /* what's your system type?             */
#define TBLBDY 10                  /* what is your birthday?               */
#define TBLSEX 11                  /* are you male or female?              */
#define TBLSUP 12                  /* sysop-configurable signup questions  */
#define TBLUSE 13                  /* use your real name as your User-ID?  */
#define TBLUID 14                  /* what User-ID do you want to use?     */
#define ASTSIZ 15                  /* number of entries in asktbl[]        */

/*** NOTE: update these TBLxxx constants and asktbl[][] in SIGNUP.C in sync ***/

typedef int AUTOSENSE(             /* Autosensor routine, 0=working 1=done */
     unsigned snccon,              /* since connect, 1/16 sec (see note)   */
     char *incbuf,                 /* bytes coming in (not NUL terminated) */
     int nbytes);                  /* number of bytes coming in            */

         /* NOTE: the snccon parameter will always be 0 when initiating an */
         /* autosensing session, and always at least 1 thereafter.         */

extern char *poslng;               /* possible languages autosensed        */
extern unsigned *austim;           /* array[nterms] of the time of bgnaus()*/
extern int numcand;                /* # of candidates -- cntcand() ret val */
extern int fstcand;                /* first candidate -- cntcand() ret val */
extern char maxcand;               /* best candidate  -- cntcand() ret val */
extern unsigned auswait;           /* master timeout, 1/16 of second units */
extern int numaus;                 /* number of autosense handlers         */

/* MAJORBBS.C 03/04/92 10.56.44 */
void ckrsch(void);
void globalcmd(int (*rouptr)());
void rtihdlr(void (*rouptr)(void));
void xltctls(char *txtbuf);
int usridx(int chan);
void begin_polling(int unum,void (*rouptr)());
void stop_polling(int unum);
int register_textvar(char *name,char *(*varrou)());
int findtvar(char *name);
int register_module(struct module *mod);
int findmod(char *name);
char *gmdnam(char *mdfnam);
void dclvda(int size);
void alcvda(void);
char *vdaoff(int unum);
void powprf(void);
int bdspec(void);
void kiletc(char *legend);
void condex(void);
void injacr(void);
void clrinp(void);
int sampok(void);
void hdlinp(void);
void clrxrf(void);
void addxrf(char *newuid);
void delxrf(char *userid);
int hdluid(char *stg);
void delgen(char *userid);
int getgen(struct bbsgen *genbuf,char *userid);
void setgen(struct bbsgen *genbuf);
int onsys(char *uid);
int onsysn(char *uid,int invis);
int uinsys(char *uid);
int onbbs(char *uid,int invis);
int instat(char *uid,int qstate);
int fmtx3(char *prmstg);
char *catfix1(void);
void prepff(void);
void ckmcu(void);
void zapdec(void);
void midnit(void);
char *getin(void);
void parsin(void);
void paccin(void);
void paccit(void);
void rstrin(void);
void chkdft(char c);
char getdft(void);
void byenow();
long lincst(int unum);
void rstchn(void);
void rstx25(char *dspstg,char dspc);
void rstlan(int ishard);
void rstrxf(void);
unsigned long hrtval(void);
int hpkrou(int chan,char c);
void stansi(void);
void echon(void);
void echonu(int usrnum);
void echsec(char ech,int lwidth);
int injoth(void);
void dftinj(void);
int lonstf(void);
void nxtlon(void);
void bgnlof(void);
void nxtlof(void);
int mainu(void);
void curusr(int uno);
struct extusr *extoff(int unum);
void usrson(void);
int glorys(void);
void glolok(void);
void gloinv(void);
void musthn(void);
void dfsthn(void);
char *getmsg(int msgnum);
void kiloop(void);
void bootem(char *who);
void kilchn(int num);
void loscar(void);
void hupall(void);
void mjrfin(void);
void initmsg(unsigned siz);
void insdbz(void);
void rmvdbz(void);
void freekey(void);
/* MENUING.C 03/04/92 10.33.40 */
void inimnu(void);
int iniarip(void);
int globalgo(void);
void enapag(char *pagnam);
void dispag(char *pagnam);
void bgnfnd(void);
void cntfnd(void);
void chk4mtch(void);
void abtfnd(void);
int gopage(char *pagnam,int lngmnu,int reting);
int gomodl(void);
int gomutl(void);
int gocond(void);
int gomenu(int lngmnu);
int gofile(void);
int dspmnu(int lngmnu);
struct usrmnu *mnuoff(int unum);
void redolocks(int inserted);
int opnans(char *filnam);
int opfile(char *filnam);
int rdfile(void);
void clfile(void);
void xltmnu(char *buffer);
char *xlttxv(char *buffer,int size);
int grbtxv(char *buffer);
int selnum(char selchr);
void clsmnu(void);
/* OPRLOW.C 07/04/92 09.22.38 */
void inilopr(int mxscn,int auxena);
void endlopr(void);
char *actvscn(int scnhdl);
char *actvscnsp(int scnhdl,int x1,int y1,int x2,int y2,int scr);
void updbckgnd(void);
void conupd(void);
void occhdl(void);
unsigned keyhit(unsigned scan);
void scngoaway(int scnhdl);
void scn2mai(int scnhdl);
void scn2aux(int scnhdl);
void mai2aux(void);
int regscn();
void shobox(int w,int sho);
void unsavscns(void);
void savscns(void);
void memswap(char *source,char *dest,int length);
int baudat(unsigned baud,int blink);
void cls(char *buf,int atr);
void printfat();
char *dbytes(long bytes);
void *vidalc(int len);
/* SIGNUP.C 09/04/92 12.15.22 */
void inisup(void);
int signup(void);
int uinfok(int pmtmsn,int minlen,int maxsiz,char *stgptr);
int unumok(int pmtmsn,int minnum,int maxnum,int *number);
int udatok(int pmtmsn,char *stgptr);
int okbday(char *stg);
int usexok(void);
void lnglist(int all);
void lngfoot(int all);
void stripb(char *stg);
void makhdl(char *stg);
void zonkhl(char *stg);
int isuplo(char *stg);
int loadup(void);
void shwusr(struct usracc *usaptr);
void finsup(void);
int valpsw(char *psw);
int issupc(int c);
void supcyc(void);
void suphup(void);
void cntsup(void);
/* CNCUTL.C 03/04/92 11.29.04 */
void bgncnc(void);
int endcnc(void);
char cncchr(void);
int cncint(void);
long cnclon(void);
char *cncuid(void);
char *cncsig(void);
char cncyesno(void);
char *cncwrd(void);
char *cncall(void);
char morcnc(void);
int cnchex(void);
char *cncnum(void);
int cnclng(void);
/* EDITFSE.C 25/02/92 19.37.34 */
void inifse(void);
void clsedt(void);
void fsesthn(void);
void edtimr(int (*imradr)());
int bgnedt(int siz,char *buf,int tsiz,char *topic,int (*whndun)(),
         int flags);
int stfse(int siz,char *buf,int tsiz,char *topic);
int stline(int siz,char *buf,int tsiz,char *topic);
int dunedt(void);
char fsechi(int chan,int c);
int ldunedt(void);
void rtfedt(void);
void rststf(void);
void edtmnu(void);
void edtpmt(void);
void hlpmnu(void);
int procln(void);
int morspc(void);
int hdlecm(void);
void bgnmsg(void);
void bgntpc(void);
void hdlhcm(void);
void rplcwt(void);
char *inword(char *stg1,char *stg2);
void dellin(void);
int chk4nl(int msg,long parm);
void apndtx(void);
void insttx(void);
void lstlns(int shwlines);
void extlin(void);
int vldlin(int msg);
void rplctx(void);
void rstrln(void);
void strtov(int siz,char *buf,int tsiz,char *topic);
int msgtpc(void);
/* ACCSCN.C 25/02/92 14.06.28 */
void actrep(void);
void actdis(void);
unsigned actkey(unsigned scncod);
/* AUDIT.C 16/02/92 01.35.36 */
void audrep(void);
void auddis(void);
unsigned audkey(unsigned scncod);
/* EMULATE.C 25/02/92 18.30.28 */
void emulupd(void);
unsigned emulkey(unsigned scncod);
void oprmks(int chr);
void emuchn(int chn2em);
void emuset(int chn2em);
void emdisp();
void lvchat(void);
void winupdt(void);
/* MONITOR.C 25/02/92 18.32.46 */
unsigned monkey(unsigned scncod);
void monrep(void);
void mondis(void);
void shomal(void);
/* SUMMARY.C 16/04/92 16.24.14 */
void sumocc(void);
unsigned sumkey(unsigned scncod);
void softgroup(void);
void squiet(void);
void sseldsp(void);
void smsgdsp(void);
void sscnsav(void);
void skill(void);
void sentmin(void);
void sauxcrt(void);
void scklmod(void);
void ssndac(void);
void sentamt(void);
void sentapf(void);
void sentuid(void);
void dwtxte(void);
void sselpos(void);
void sinpchn(void);
void sinpch2(void);
void sumrep(void);
void sumdis(void);
void inisho(void);
void inisho2(void);
void finsho(void);
void dwopr(void);
void iniaud(void);
void shocst();
void scroat(int dirct);
void shochn(char *legend);
void shochb(char *legend,int blink);
void shochl(char *legend,char sing,int attr);
void loadgph(int min);
int linsusd(void);
void doaditbx(void);
void quiesk(int blk);
void zappo(void);
void plosk(int sktnum);
void zapskl(void);
void lblsk(int sknum,char *lblstg);
void acckey(void);
void bckspc(void);
void hdlskm(char *echstg,int opistt);
void hdlskc(int opistt);
void hdlsk(char *echstg,int opistt);
void retkey(void);
void auxups(char snum);
void collap(void);
void fupkil(void);
void snd2ch(int chan,char *text);
void snd2al(char *text);
void dftbel(int local);
void savdisp(void);
char *chlpfn(void);
void psmatm(void);
/* USERS.C 25/02/92 11.34.06 */
unsigned usskey(unsigned scncod);
void ussrep(void);
void ussocc(void);
void ussdis(void);
void updbank(int bnk);
void usrchl(void);
void usrchan(int chan);
/* ABOUT.C 25/02/92 13.50.46 */
unsigned abokey(unsigned scncod);
void aborep(void);
/* LOCAL.C 25/02/92 11.32.40 */
void lsesupd(void);
unsigned lseskey(unsigned scncod);
void oprmk2(int chr);
void entlse(int chn2em);
/* SCANPL.C 19/02/92 11.20.46 */
unsigned loadmod(char *name);
void far *getprocaddr(char far *modname,char far *funcname);
void callinits(void);
int pltile(unsigned long size,int bsel,unsigned stride,unsigned tsize);
long btparm(char *opt,char *val);
void setbparm(void);
/* EMULATE.C   */
void entcht(void);
/* AUTSNS.C 04/02/93 11.40.38 */
void iniaus(void);
void regautsns(AUTOSENSE *aushdl);
int bgnaus(int foreal);
int prcaus(void);
void setbyprot(char *prot,char value);
int cntcand(void);
int lngposn(int chc);
/* BBSRIP.C 23/11/93 14.53.06 */
void inirmdl (void);
void ripcls (void);
