/***************************************************************************
 *                                                                         *
 *   GALQWK.C                                                              *
 *                                                                         *
 *   Copyright (C) 1992-1994 GALACTICOMM, Inc. All Rights Reserved.        *
 *                                                                         *
 *   QWK-compatible module Forums/E-mail     V1.0 by Greg Hewgill  8/10/91 *
 *                                           V2.0 adapted by Tim Stryker   *
 *                                                            8/18/92      *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"
#include "majorbbs.h"
#include "filexfer.h"
#include "message.h"
#include "galqwk.h"

void EXPORT init__qwkmail(void);
void iniqwk(void);
void qwkmail_status(void);
int qwkmail(void);
int qwkmail_menu(void);
int fupqwk(int fupcod);
void exit_qwkmail(void);
int start_dl(void);
int cont_dl(void);
void do_return_receipt(void);
int out_msg(void);
int done_dl(void);
void sbmqwk(char *protsl);
int tshqwk(int tshcod);
void abort_dl(void);
void upload_done(int ok);
void upload_check(void);
int start_ul(void);
int cont_ul(void);
int sameasn(char *stg1,char *stg2,int n);
int dwreqs(int sig);
void finish_ul(int error_msg);
int accslv(char *userid,int signo);
void delete_ul(void);
char *attach_fn(int sig,long msgno);
char *attach_fs(int sig,long msgno);
int zip_init(char *fn);
int zip_open(char *fn);
int zip_write(void *buf,int len);
int zip_close(void);
int zip_copy(char *src,char *dest);
int zip_done(void);
int unzip_open(char *zn,char *fn);
int unzip_read(char *p,int n);
void unzip_close(void);
void load_sf_tree(struct sf_tree *t,int tree_size);
int reverse_bits(int x);
int read_via_tree(struct sf_tree *t);
int read_bits(int b);
void output_byte(char b);
unsigned long mks_to_long(unsigned long x);
unsigned long long_to_mks(unsigned long x);
unsigned long crc32block(void *buf,int len,unsigned long crc);
unsigned long crc32(char c,unsigned long crc);
void copy_fill(char *d,char *s,int len);
void copy_fill_upper(char *d,char *s,int len);
void close_if_open(FILE *f);
int exist(char *fn);
void qwkmail_hangup(void);
void restqs(void);
void qwkmail_cleanup(void);
void qwkmail_close(void);
int initfixd(void);
void inflate(void);
int readbyte(unsigned short *x);
int outb(int intc);
int huft_build(unsigned *b,unsigned n,unsigned s,unsigned short *d,
     unsigned short *e,struct huft **t,int *m);
int huft_free(struct huft *t);
char *tvqname(void);
char *tvqtogg(void);

struct module mmail={         /* module interface block               */
     "",                      /*    name used to refer to this module */
     NULL,                    /*    user logon supplemental routine   */
     qwkmail,                 /*    input routine if selected         */
     qwkmail_status,          /*    status-input routine if selected  */
     NULL,                    /*    "injoth" routine for this module  */
     NULL,                    /*    user logoff supplemental routine  */
     qwkmail_hangup,          /*    hangup (lost carrier) routine     */
     qwkmail_cleanup,         /*    midnight cleanup routine          */
     NULL,                    /*    delete-account routine            */
     qwkmail_close            /*    finish-up (sys shutdown) routine  */
};



static
FILE *qwkmail_msgs;           /* qwkmail message file                 */



#define QWKMAIL_NAME "GALQWK" /* name of the pseudo-account for the qwkmail*/
#define QWKMAIL_DIR  "GALQW"  /* beginning of qwkmail directory name       */



struct SIG_MSGNO {            /* struct for attachment rec in REQUEST.LST  */
     int sig;
     long num;
};

                              /* zip file structure definitions            */
#define ZIP_LOCAL_HEADER_SIG       0x04034b50L
#define ZIP_CENTRAL_RECORD_SIG     0x02014b50L
#define ZIP_END_CENTRAL_RECORD_SIG 0x06054b50L

#define ZIP_STORED   0
#define ZIP_SHRUNK   1
#define ZIP_IMPLODED 6
#define ZIP_DEFLATED 8

struct ZIP_LOCAL_HEADER {
     unsigned long signature;
     int ver_needed;
     int gen_flags;
     int compression;
     int ftime;
     int fdate;
     unsigned long crc;
     unsigned long compressed;
     unsigned long uncompressed;
     int filename_len;
     int extra_len;
     char filename[13];
};

struct ZIP_CENTRAL_RECORD {
     unsigned long signature;
     int ver_made_by;
     int ver_needed;
     int gen_flags;
     int compression;
     int ftime;
     int fdate;
     unsigned long crc;
     unsigned long compressed;
     unsigned long uncompressed;
     int filename_len;
     int extra_len;
     int fcomment_len;
     int disk_start;
     int internal_attrs;
     unsigned long external_attrs;
     unsigned long local_header_offset;
     char filename[13];
};

struct ZIP_END_CENTRAL_RECORD {
     unsigned long signature;
     int disk_number;
     int central_dir_disk;
     int central_entries_disk;
     int central_entries;
     unsigned long central_size;
     unsigned long central_start_offset;
     int zcomment_len;
};

                              /* unzip data type declarations */
struct sf_tree_entry {
     char bit_length;
     int code;
     char value;
};

struct sf_tree {
     struct sf_tree_entry *tree;
     int entries;
     int max_length;
};

struct UNZIP_DATA {
                              /* general zip stuff                         */
#define INPUT_BUFFER_SIZE  512
#define OUTPUT_BUFFER_SIZE (msg_size+8192)

     FILE *zip_file;
     char zip_eof;
     unsigned long crc;

     struct ZIP_LOCAL_HEADER zlhdr;

     char *input_buf;
     int input_index;
     int input_avail;
     long input_offset;

     char *output_buf;
     int output_index;
     int output_avail;
     long output_offset;

     int bits_left;

                              /* unshrinking variables                     */
#define INIT_BITS       9
#define MAX_BITS        13
#define MAX_CODE        (1<<MAX_BITS)
#define FIRST_ENTRY     257
#define CLEAR_CODE      256
#define ZIP_BUFFER_SIZE 8192

     int *prefix_of;
     char *suffix_of;
     char *stack;
     int stack_index;

     int code_bits;
     int first_free;
     int final_char;
     int last_code;

                              /* exploding variables                       */
     struct sf_tree literal_tree;
     struct sf_tree length_tree;
     struct sf_tree distance_tree;

     char literal_tree_present;
     int min_match_length;
     int lower_dict_bits;
};

                              /* Stuff for PKUNZIP v2's INFLATE (method 8) */

#define INFLATE2  12               /* Various inflate() "states"           */
#define INFLATE3  13
#define INFLATE4  14
#define INFNOK    15
#define INFOK     16
#define INFLATE5  17
#define INFLATE6  18
#define INFLATE7  19
#define WSIZE     0x8000           /* window size: (a power of two >= 32K) */
#define BMAX   16
#define N_MAX  288
#define NEXTBYTE    (readbyte(&zp.bytebuf), zp.bytebuf)
#define NEEDBITS(n) {while(k<(n)){b|=((unsigned long)NEXTBYTE)<<k;k+=8;}}
#define DUMPBITS(n) {b>>=(n);k-=(n);}
#define NEEDBITS2(n) {while(zp.k<(n))\
     {zp.b|=((unsigned long)NEXTBYTE)<<zp.k;zp.k+=8;}}
#define DUMPBITS2(n) {zp.b>>=(n);zp.k-=(n);}
#define NEEDBITS3(n) {while(zp.k4<(n))\
     {zp.b4|=((unsigned long)NEXTBYTE)<<zp.k4;zp.k4+=8;}}
#define DUMPBITS3(n) {zp.b4>>=(n);zp.k4-=(n);}
#define NEEDBITS4(n) {while(zp.k3<(n))\
     {zp.b3|=((unsigned long)NEXTBYTE)<<zp.k3;zp.k3+=8;}}
#define DUMPBITS4(n) {zp.b3>>=(n);zp.k3-=(n);}
#define NEEDBITS5(n) {while(zp.k5<(n))\
     {zp.b5|=((unsigned long)NEXTBYTE)<<zp.k5;zp.k5+=8;}}
#define DUMPBITS5(n) {zp.b5>>=(n);zp.k5-=(n);}
#define READBIT(nbits,zdest) {if(nbits>uz.bits_left) FillBitBuffer();\
     zdest=(int)((unsigned short)uz.bitbuf&mask_bits[nbits]);\
     uz.bitbuf>>=nbits;uz.bits_left-=nbits;}

typedef unsigned char  byte;       /* code assumes UNSIGNED bytes          */

struct huft {
     byte e;                       /* number of extra bits or operation    */
     byte b;                       /* number of bits in this code/subcode  */
     union {
          unsigned short n;        /* literal, length base, or dist base   */
          struct huft *t;          /* pointer to next level of table       */
     } v;
};

struct inflate {
     unsigned short bytebuf;
     unsigned hufts;
     unsigned wp;                  /* current position in slide            */
     unsigned long bb;             /* bit buffer                           */
     unsigned bk;                  /* bits in bit buffer                   */
     int lbits;                    /* bits in base lit/len lookup table    */
     int dbits;                    /* bits in base distance lookup table   */
     unsigned long b;              /* bit buffer                           */
     unsigned int k;               /* number of bits in bit buffer         */
     int e2;                       /* last block flag                      */
     unsigned h2;                  /* maximum struct huft's malloc'ed      */
     unsigned t3;                  /* block type                           */
     unsigned long b3;             /* bit buffer                           */
     unsigned int k3;              /* number of bits in bit buffer         */
     int i4;                       /* temporary variables                  */
     unsigned j4;
     unsigned l4;                  /* last length                          */
     unsigned m4;                  /* mask for bit lengths table           */
     unsigned n4;                  /* number of lengths to get             */
     struct huft *tl4;             /* literal/length code table            */
     struct huft *td4;             /* distance code table                  */
     int bl4;                      /* lookup bits for tl                   */
     int bd4;                      /* lookup bits for td                   */
     unsigned nb4;                 /* number of bit length codes           */
     unsigned nl4;                 /* number of literal/length codes       */
     unsigned nd4;                 /* number of distance codes             */
     unsigned ll4[286+30];         /* literal/length and distance code len */
     unsigned long b4;             /* bit buffer                           */
     unsigned int k4;              /* number of bits in bit buffer         */
     unsigned int e5;              /* table entry flag/number of xtra bits */
     unsigned n5, d5;              /* length and index for copy            */
     unsigned w5;                  /* current window position              */
     struct huft *t5;              /* pointer to table entry               */
     unsigned ml5, md5;            /* masks for bl and bd bits             */
     unsigned long b5;             /* bit buffer                           */
     unsigned int k5;              /* number of bits in bit buffer         */
     int defstate;                 /* current "state" of inflate routine   */
     long csize;                   /* bytes-remaining to inflate           */
     long cur_zip_bs;
     char *inptr;
};

static unsigned border[]={16,17,18,0,8,7,9,6,10,5,11,4,12,3,13,2,14,1,15};
static unsigned short cplens[]={3,4,5,6,7,8,9,10,11,13,15,17,19,23,27,31,35,
     43,51,59,67,83,99,115,131,163,195,227,258,0,0};
static unsigned short cplext[]={0,0,0,0,0,0,0,0,1,1,1,1,2,2,2,2,3,3,3,3,4,4,
     4,4,5,5,5,5,0,99,99};
static unsigned short cpdist[]={1,2,3,4,5,7,9,13,17,25,33,49,65,97,129,193,
     257,385,513,769,1025,1537,2049,3073,4097,6145,8193,12289,16385,24577};
static unsigned short cpdext[]={0,0,0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7,8,8,9,9,
     10,10,11,11,12,12,13,13};
unsigned short mask_bits[]={0x0000,0x0001,0x0003,0x0007,0x000f,0x001f,0x003f,
     0x007f,0x00ff,0x01ff,0x03ff,0x07ff,0x0fff,0x1fff,0x3fff,0x7fff,0xffff};

byte slide[WSIZE];
int outcnt;

                              /* qwk packet structure definitions          */

#define QMAIL_COPYRIGHT "Produced by Qmail...Copyright (c) 1987 by Sparkware.  All Rights Reserved       "\
                        "Above for Compatibility with Qmail              "

#define STATUS_NORMAL              ' '
#define STATUS_NORMAL_READ         '-'
#define STATUS_RECEIVER_ONLY       '*'
#define STATUS_RECEIVER_ONLY_READ  '+'

#define MESSAGE_ACTIVE        225
#define MESSAGE_INACTIVE      226

#define PCBEOL                227

#define FILLEN                3 /* "fill" size at end of QWK_MESSAGE_HEADER */

struct QWK_MESSAGE_HEADER {
     char status;
     char number[7];
     char date[8];
     char time[5];
     char whoto[25];
     char from[25];
     char subject[25];
     char password[12];
     char reference[8];
     char blocks[6];
     char active;
     unsigned int conference;
     char fill[FILLEN];
};

struct QWK_INDEX_RECORD {
     unsigned long block_number;
     char conference;
};

                              /* static data                               */
#define BUFFER_SIZE outbsz

static char *buffer;

static int msg_size;

static struct ZIP_CENTRAL_RECORD     *zip_central_record;
static struct ZIP_END_CENTRAL_RECORD *zip_end_central_record;
static struct QWK_MESSAGE_HEADER     *qwk_message_header;
static struct QWK_INDEX_RECORD        qwk_index_record;

static struct UPLOAD_DATA {
     long msg_number;
     char user_from[UIDSIZ];
     int msgs_posted;
     struct message msg;
} *ul;

static struct UNZIP_DATA uz;
static struct inflate zp;

static char prop[] = "/-\\|";

int mjmstt;
struct mhsinf mhstmp;

#define   MINDLY    10             /* num cycles per msg for QWK building  */

int numqwk;                        /* number of users building packets     */

                                   /* volatile per-user data structure     */
static struct VOLATILE_DATA {
     FILE *zip_file;
     FILE *zip_central_file;
     int znum;
     long zoffset;
     struct ZIP_LOCAL_HEADER zlhdr;

     int current_sig;
     long abs_pos;

     long current_block;
     int prop_index;
     int total_msgs;
     int personal_msgs;
     int sig_msgs;
     int personal_sig_msgs;
     int num_attachments;
     FILE *index_file;
     FILE *pindex_file;
     FILE *attach_file;

     int cycdly;
     int uplding;
     int indexing;
     int copying;
     struct fndblk fb;

     struct message msg;
};

#define vd ((struct VOLATILE_DATA *)vdaptr)
#define email_vd ((struct esgusr *)vdaptr)

struct qwksid {                    /* a few QWK little items on the side   */
     char protsl[5];               /*   download protocol selection (+ "!")*/
     char gotbeg;                  /*   flag: 1=got TSHBEG, 2=got TSHSKP   */
     int  fnewb4;                  /*   ret val from ftgnew() b4 starting  */
     int  wroteq;                  /*   wrote quickscan data this session  */
} *qwksid;

                                   /* options from galqwk.msg             */
char *qwk_name,                    /* name of the QWK packet              */
     *qdlkey,                      /* QWK-mail download permission key    */
     *qulkey,                      /* QWK-mail upload permission key      */
     *newsfl;                      /* QWK-mail "news" filename            */

int inter_packet, /* time between processing different packets            */
    intra_packet, /* time delay between processing messages in one packet */
    frmlmt,       /* per-forum limit on number of messages per packet     */
    valto;        /* validate TO: address?  1=yes 0=no                    */

/* local copies of stuff not necessarily exported from GALMSG.DLL          */
struct compos compos;         /* composite user-id/msg# for searches       */
struct qscfg *sopqsc;         /* singular scratch area                     */
#define acclvl(x,sn) (((sn)&1) ? x[(sn)>>1]>>4 : (x[(sn)>>1]&0x0F))

void EXPORT
init__qwkmail(void)                /* initialize the qwkmail module        */
{
     stzcpy(mmail.descrp,gmdnam("GALQWK.MDF"),MNMSIZ);
     mjmstt=register_module(&mmail);
     numqwk=0;
     register_textvar("QWK_NAME",tvqname);
     register_textvar("QWK_TOGG",tvqtogg);
     rtkick(1,iniqwk);
}

void
iniqwk(void)                       /* finish init'ing (after SIGs is done) */
{
     qscsiz=sizeof(struct qscfg)+sizeof(long)*nsigs+(nsigs+1)/2;
     sopqsc=(struct qscfg *)alcmem(qscsiz);
     qwksid=(struct qwksid *)alczer(nterms*sizeof(struct qwksid));
     qwkmail_msgs=opnmsg("galqwk.mcv");
     qwk_name=strupr(stgopt(QWKNAME));
     qdlkey=stgopt(QDLKEY);
     qulkey=stgopt(QULKEY);
     inter_packet=numopt(INTERPKT,1,300);
     intra_packet=numopt(INTRAPKT,1,5);
     newsfl=stgopt(NEWSFL);
     frmlmt=numopt(FRMLMT,1,30000);
     valto=ynopt(VALTO);
     zip_central_record=(struct ZIP_CENTRAL_RECORD *)alcmem(sizeof(struct ZIP_CENTRAL_RECORD));
     zip_end_central_record=(struct ZIP_END_CENTRAL_RECORD *)alcmem(sizeof(struct ZIP_END_CENTRAL_RECORD));
     qwk_message_header=(struct QWK_MESSAGE_HEADER *)alcmem(sizeof(struct QWK_MESSAGE_HEADER));
     buffer=alcmem(BUFFER_SIZE);
     msg_size=outbsz-384;
     dclvda(sizeof(struct VOLATILE_DATA)+msg_size+128);
     ul=(struct UPLOAD_DATA *)alcmem(sizeof(struct UPLOAD_DATA)+msg_size+128);

     uz.input_buf=(char *)alcmem(INPUT_BUFFER_SIZE);
     uz.output_buf=(char *)alcmem(OUTPUT_BUFFER_SIZE);
     uz.prefix_of=(int *)alcmem(ZIP_BUFFER_SIZE*sizeof(int));
     uz.suffix_of=(char *)alcmem(ZIP_BUFFER_SIZE);
     uz.stack=(char *)alcmem(ZIP_BUFFER_SIZE);
     uz.literal_tree.tree=(struct sf_tree_entry *)alcmem(256*sizeof(struct sf_tree_entry));
     uz.length_tree.tree=(struct sf_tree_entry *)alcmem(64*sizeof(struct sf_tree_entry));
     uz.distance_tree.tree=(struct sf_tree_entry *)alcmem(64*sizeof(struct sf_tree_entry));
     rtkick(inter_packet,upload_check);
}

void
qwkmail_status(void)               /* status handler for cycled procs      */
{
     if (status == CYCLE) {
          qscptr=qscoff(usrnum);
          setmbk(qwkmail_msgs);
          setbtv(esgbb);
          clrprf();
          switch (usrptr->substt) {
          case MAKEPCKT:
               if (btuoba(usrnum) > outbsz-2-1024) {
                    if (cont_dl()) {
                         btuinj(usrnum,CYCLE);
                    }
               }
               else {
                    btuinj(usrnum,CYCLE);
               }
               break;
          }
          if (prfptr != prfbuf) {
               outprf(usrnum);
          }
     }
     else {
          dfsthn();
     }
}

int
qwkmail(void)                      /* module input handler                 */
{
     long num;
     int i;

     qscptr=qscoff(usrnum);
     iniqsc();
     setmbk(qwkmail_msgs);
     setbtv(esgbb);
     clrprf();
     if (usrptr->flags&INJOIP) {
          switch (usrptr->substt) {
          case MAKEPCKT:
               break;
          case RESET:
               prfmsg(RESET,l2as(sv.msgtot));
               break;
          default:
               prfmsg(usrptr->substt);
               break;
          }
     }
     else if (margc == 0) {
          switch (usrptr->substt) {
          case MAKEPCKT:
               abort_dl();
               prfmsg(DLABORTD);
               restqs();
               prfmsg(PREVUS);
               prfmsg(usrptr->substt=MENU1);
               break;
          case RESET:
               prfmsg(NOTRESET);
               exit_qwkmail();
               prfmsg(usrptr->substt=MENU1);
               break;
          default:
               prfmsg(usrptr->substt);
               break;
          }
     }
     else {
          do {
               bgncnc();
               switch (usrptr->substt) {
               case 0:
                    mkdir(spr("%s%d",QWKMAIL_DIR,usrnum));
                    cncchr();
                    btuxnf(usrnum,0,19);
                    prfmsg(usrptr->substt=MENU1);
                    break;
               case MENU1:
                    if (!qwkmail_menu()) {
                         outprf(usrnum);
                         rstrxf();
                         return(0);
                    }
                    break;
               case MAKEPCKT:
                    abort_dl();
                    prfmsg(DLABORTD);
                    restqs();
                    prfmsg(PREVUS);
                    prfmsg(usrptr->substt=MENU1);
                    break;
               case RESET:
                    num=cnclon();
                    if (num <= 0) {
                         prfmsg(NOTRESET);
                    }
                    else {
                         if (num > sv.msgtot) {
                              num=sv.msgtot+1;
                         }
                         usaptr->emllim=num-1;
                         for (i=0 ; i < nsigs ; i++) {
                              if (LSOFAR[i] >= 0) {
                                   LSOFAR[i]=num-1;
                              }
                         }
                         prfmsg(RESETTO,l2as(num));
                    }
                    exit_qwkmail();
                    prfmsg(usrptr->substt=MENU1);
                    break;
               default:
                    catastro("Substate error in GALQWK: %d",usrptr->substt);
               }
          } while (!endcnc());
     }
     if (prfptr != prfbuf) {
          outprf(usrnum);
     }
     return(1);
}

int
qwkmail_menu(void)                 /* main menu handler                    */
{
     switch (cncchr()) {
     case 'D':
          if (haskey(qdlkey)) {
               while (morcnc() == ' ') {
                    cncchr();
               }
               stzcpy(qwksid[usrnum].protsl,cncall(),5);
               prfmsg(usrptr->substt=MAKEPCKT);
               if (!start_dl()) {
                    abort_dl();
                    prfmsg(FILERR);
                    prfmsg(usrptr->substt=MENU1);
               }
          }
          else {
               prfmsg(LACKKEY,"download");
               exit_qwkmail();
               prfmsg(usrptr->substt=MENU1);
          }
          cncall();
          break;
     case 'U':
          if (!haskey(qulkey)) {
               cncall();
               prfmsg(LACKKEY,"upload");
               exit_qwkmail();
               prfmsg(usrptr->substt=MENU1);
               break;
          }
          setmem(email_vd,sizeof(struct esgusr),0);
          email_vd->msg.msgno=++sv.msgtot;
          strcpy(email_vd->msg.userto,QWKMAIL_NAME);
          strcpy(email_vd->msg.from,usaptr->userid);
          email_vd->msg.from[0]=clrchr(email_vd->msg.from[0]);
          strcpy(email_vd->msg.to,QWKMAIL_NAME);
          strcpy(email_vd->msg.topic,".");
          email_vd->msg.crdate=today();
          email_vd->msg.crtime=now();
          email_vd->msg.flags=FILATT+APPVED;
          strcpy(email_vd->msg.text,"\r");
          fileup(spr("%s.REP",qwk_name),cncall(),fupqwk);
          break;
     case 'A':
          cncall();
          qscptr->flags^=QSATT;
          prfmsg(ATTONOFF,(qscptr->flags&QSATT) ? "" : " NOT");
          exit_qwkmail();
          prfmsg(usrptr->substt=MENU1);
          break;
     case 'R':
          prfmsg(usrptr->substt=RESET,l2as(sv.msgtot));
          break;
     case '?':
          cncall();
          prfmsg(QWKHELP);
          prfmsg(UHELP1);
          exit_qwkmail();
          usrptr->substt=MENU1;
          prfmsg(PRESENTR);
          break;
     case 'X':
          return(0);
     default:
          prfmsg(NOTCMD);
          prfmsg(usrptr->substt=MENU1);
          cncall();
          break;
     }
     return(1);
}

int
fupqwk(int fupcod)       /* Handle uploads for the QWK application         */
{                        /* implicit inputs: usrnum, usrptr, usaptr, vdaptr*/
                         /* return value meaning depends on fupcod         */
                         /* implicit input/output in many cases: ftfbuf    */
                         /* expect caller to do outprf() if any            */
     int rc=0;
     struct fndblk fb;

     setmbk(qwkmail_msgs);
     switch (fupcod) {
     case FUPPTH:                 /* Find out what path the file would use */
     case FUPBEG:               /* Begin upload, check permission, reserve */
     case FUPEND:              /* End complete upload of a file, unreserve */
          strcpy(ftfbuf,attach_fn(-1,email_vd->msg.msgno));
          rc=1;
          break;
     case FUPSKP:                      /* Skip incomplete upload of a file */
          unlink(attach_fn(-1,email_vd->msg.msgno));
          break;
     case FUPFIN:                            /* Finish file upload session */
          upload_done(fnd1st(&fb,attach_fn(-1,email_vd->msg.msgno),0));
          rc=1;
          break;
     case FUPHUP:               /* Finish session because user logging off */
          break;
     }
     return(rc);
}

char *
tvqname(void)                      /* QWK - name of system                 */
{
     return(qwk_name);
}

char *
tvqtogg(void)                      /* QWK - attachment toggle on?          */
{
     return((qscptr->flags&QSATT) ? "ON" : "OFF");
}

void
exit_qwkmail(void)                 /* exit module handler                  */
{
     cncall();
     if (usrptr->flags&CONCEX) {
          rstrxf();
          condex();
     }
}

int
start_dl(void)                     /* initialize the download procedure    */
{
     struct fndblk fb;
     int i;
     FILE *fp,*fpo;

     numqwk++;
     restqs();
     i=fnd1st(&fb,spr("%s%d\\*.*",QWKMAIL_DIR,usrnum),0);
     while (i) {
          if (!sameas(fb.name,"REQUEST.BAK")) {
               unlink(spr("%s%d\\%s",QWKMAIL_DIR,usrnum,fb.name));
          }
          i=fndnxt(&fb);
     }
     if ((fp=fopen(spr("%s%d\\REQUEST.BAK",QWKMAIL_DIR,usrnum),FOPRB)) != NULL) {
          if ((fpo=fopen(spr("%s%d\\REQUEST.LST",QWKMAIL_DIR,usrnum),FOPWB)) != NULL) {
               do {
                    if ((i=fread(buffer,1,BUFFER_SIZE,fp)) > 0) {
                         fwrite(buffer,1,i,fpo);
                    }
               } while (i > 0);
               fclose(fpo);
          }
          fclose(fp);
     }

     if ((fp=fopen(spr("%s%d\\TMPQSC.IMG",QWKMAIL_DIR,usrnum),FOPWB)) == NULL) {
          return(0);
     }
     if (!fwrite(&usaptr->emllim,sizeof(long),1,fp)
      || !fwrite(qscoff(usrnum),qscsiz,1,fp)) {
          fclose(fp);
          return(0);
     }
     fclose(fp);
     qwksid[usrnum].wroteq=1;
     vd->zip_file=NULL;
     vd->zip_central_file=NULL;
     if (!zip_init(spr("%s%d\\%s.QWK",QWKMAIL_DIR,usrnum,qwk_name))) {
          return(0);
     }
     if (!zip_open("MESSAGES.DAT")) {
          return(0);
     }
     strcpy(buffer,QMAIL_COPYRIGHT);
     if (!zip_write(buffer,128)) {
          return(0);
     }
     vd->current_sig=-1;
     vd->abs_pos=0;
     vd->current_block=2;
     vd->prop_index=0;
     vd->total_msgs=0;
     vd->personal_msgs=0;
     vd->sig_msgs=0;
     vd->personal_sig_msgs=0;
     vd->num_attachments=0;
     vd->index_file=NULL;
     vd->pindex_file=NULL;
     vd->attach_file=NULL;
     vd->cycdly=0;
     vd->indexing=0;
     vd->copying=0;

     prfmsg(SCANHDR);

     if (cont_dl()) {
          btuinj(usrnum,CYCLE);
     }
     return(1);
}


int
cont_dl(void)                      /* continue download                    */
{                                  /* returns 1 if not done                */
     int n;
     char fname[MAXPATH];
     struct SIG_MSGNO att;

     if (++vd->cycdly < MINDLY*numqwk) {
          return(1);
     }
     vd->cycdly=0;
     if (vd->indexing) {
          stzcpy(fname,spr("%s%d\\%s",QWKMAIL_DIR,usrnum,vd->fb.name),MAXPATH);
          if (!zip_copy(fname,vd->fb.name)) {
               abort_dl();
               prfmsg(FILERR);
               prfmsg(usrptr->substt=MENU1);
               return(0);
          }
          vd->indexing=fndnxt(&vd->fb);
          unlink(fname);
          if (vd->indexing) {
               return(1);
          }
          vd->copying=1;
          return(1);
     }
     if (vd->copying) {
          if (vd->attach_file == NULL) {
               if ((vd->attach_file=fopen(spr("%s%d\\REQUEST.LST",QWKMAIL_DIR,usrnum),FOPRB)) != NULL
                  && !fseek(vd->attach_file,(vd->copying-1)*sizeof(struct SIG_MSGNO),SEEK_SET)
                  && fread(&att,sizeof(struct SIG_MSGNO),1,vd->attach_file)) {
                    fclose(vd->attach_file);
                    if ((vd->attach_file=fopen(attach_fs(att.sig,att.num),FOPRB)) != NULL) {
                         if (!zip_open(spr("%ld.ATT",att.num))) {
                              abort_dl();
                              prfmsg(FILERR);
                              prfmsg(usrptr->substt=MENU1);
                              return(0);
                         }
                         if (vd->copying == 1) {
                              prfmsg(ATTCOPY);
                         }
                         else {
                              prf("\b\b\b\b, ");
                         }
                         prf("%s...%c",l2as(att.num),prop[vd->prop_index]);
                         vd->prop_index=(vd->prop_index+1)&3;
                    }
                    else {
                         vd->copying++;
                    }
                    return(1);
               }
               close_if_open(vd->attach_file);
               vd->attach_file=NULL;
               if (vd->copying > 1) {
                    prf("\b\b\b\b    ");
               }
               if (vd->num_attachments > 1) {
                    prfmsg(ATTNOTE,vd->num_attachments,(vd->copying > 1) ? " new" : "");
               }
               else if (vd->num_attachments > 0) {
                    prfmsg(ATTNOTE1,(vd->copying > 1) ? " new" : "");
               }
               vd->copying=0;

               if (!done_dl()) {
                    abort_dl();
                    prfmsg(FILERR);
                    prfmsg(usrptr->substt=MENU1);
               }
               return(0);
          }
          else {
               prf("\b%c",prop[vd->prop_index]);
               vd->prop_index=(vd->prop_index+1)&3;
               n=fread(buffer,1,BUFFER_SIZE,vd->attach_file);
               if (n > 0) {
                    if (!zip_write(buffer,n)) {
                         abort_dl();
                         prfmsg(FILERR);
                         prfmsg(usrptr->substt=MENU1);
                         return(0);
                    }
               }
               else {
                    if (!zip_close()) {
                         abort_dl();
                         prfmsg(FILERR);
                         prfmsg(usrptr->substt=MENU1);
                         return(0);
                    }
                    fclose(vd->attach_file);
                    vd->attach_file=0;
                    vd->copying++;
               }
          }
          return(1);
     }
     if (vd->abs_pos != 0) {
          gabbtv(&vd->msg,vd->abs_pos,TONUM);
          if (anibtv(&vd->msg)) {
               prf("\b%c",prop[vd->prop_index]);
               vd->prop_index=(vd->prop_index+1)&3;
               if (!out_msg()) {
                    abort_dl();
                    prfmsg(FILERR);
                    prfmsg(usrptr->substt=MENU1);
                    return(0);
               }
               vd->abs_pos=absbtv();
               if (vd->current_sig == -1) {
                    do_return_receipt();
               }
               if (vd->sig_msgs < frmlmt) {
                    return(1);
               }
          }
          prf("\b ");
          if (vd->current_sig == -1) {
               vd->current_sig=-2;
               prfmsg(SCANL2,vd->sig_msgs,vd->sig_msgs);
          }
          else {
               prfmsg(SCANL2,vd->sig_msgs,vd->personal_sig_msgs);
          }
          vd->sig_msgs=0;
          vd->personal_sig_msgs=0;
     }
     if (vd->index_file != NULL) {
          fclose(vd->index_file);
          vd->index_file=NULL;
     }
     if (vd->current_sig == -1) {
          prfmsg(SCANL1,"E-mail","Private messages");
          movmem(usaptr->userid,compos.userid,UIDSIZ);
          compos.msgno=usaptr->emllim;
          if (agtbtv(&vd->msg,&compos,TONUM)
            && sameas(vd->msg.userto,compos.userid)) {
               if ((vd->index_file=fopen(spr("%s%d\\000.NDX",QWKMAIL_DIR,usrnum),FOPWB)) == NULL) {
                    abort_dl();
                    prfmsg(FILERR);
                    prfmsg(usrptr->substt=MENU1);
                    return(0);
               }
               if (!out_msg()) {
                    abort_dl();
                    prfmsg(FILERR);
                    prfmsg(usrptr->substt=MENU1);
                    return(0);
               }
               vd->abs_pos=absbtv();
               do_return_receipt();
          }
          else {
               prfmsg(SCANL2,0,0);
               vd->abs_pos=0;
               vd->current_sig=-2;
               vd->sig_msgs=0;
               vd->personal_sig_msgs=0;
          }
          return(1);
     }
     else if ((vd->current_sig=qsignx(vd->current_sig+1+(vd->current_sig == -2))) != NOSIG) {
          prfmsg(SCANL1,sigoff(vd->current_sig)->signam,sigoff(vd->current_sig)->descrp);
          stzcpy(compos.userid,sigoff(vd->current_sig)->signam,UIDSIZ);
          compos.msgno=LSOFAR[vd->current_sig];
          if (agtbtv(&vd->msg,&compos,TONUM)
            && sameas(vd->msg.to,compos.userid)) {
               if ((vd->index_file=fopen(spr("%s%d\\%03d.NDX",QWKMAIL_DIR,usrnum,vd->current_sig+1),FOPWB)) == NULL) {
                    abort_dl();
                    prfmsg(FILERR);
                    prfmsg(usrptr->substt=MENU1);
                    return(0);
               }
               if (!out_msg()) {
                    abort_dl();
                    prfmsg(FILERR);
                    prfmsg(usrptr->substt=MENU1);
                    return(0);
               }
               vd->abs_pos=absbtv();
          }
          else {
               prfmsg(SCANL2,0,0);
               vd->abs_pos=0;
               vd->sig_msgs=0;
               vd->personal_sig_msgs=0;
          }
          return(1);
     }
     else {
          prfmsg(TOTALFND,vd->total_msgs);
          if (vd->personal_msgs) {
               prfmsg(PRSNLFND,vd->personal_msgs,(vd->personal_msgs == 1 ? "" : "s"));
          }

          if (vd->total_msgs == 0 && !exist(spr("%s%d\\REQUEST.LST",QWKMAIL_DIR,usrnum))) {
               abort_dl();
               prfmsg(NOTHFND);
               qwksid[usrnum].wroteq=0;
               exit_qwkmail();
               prfmsg(usrptr->substt=MENU1);
               return(0);
          }

          if (!zip_close()) {
               abort_dl();
               prfmsg(FILERR);
               prfmsg(usrptr->substt=MENU1);
               return(0);
          }

          if (vd->pindex_file != NULL) {
               fclose(vd->pindex_file);
               vd->pindex_file=NULL;
          }

          vd->indexing=fnd1st(&vd->fb,spr("%s%d\\*.NDX",QWKMAIL_DIR,usrnum),0);

          if (vd->indexing) {
               return(1);
          }
          vd->copying=1;
     }
     return(1);
}

void
do_return_receipt(void)            /* handle return receipt if needed      */
{
     if (!(vd->msg.flags&RECREQ) || !sameas(usaptr->userid,vd->msg.userto)) {
          return;
     }
     gabbtv(&vd->msg,vd->abs_pos,TONUM);
     vd->msg.flags&=~RECREQ;
     upvbtv(&vd->msg,NVMSIZ+strlen(vd->msg.text));

     sprintf(vd->msg.text,rrrtxt,
             usaptr->userid,l2as(vd->msg.msgno),
             ncedat(vd->msg.crdate),nctime(vd->msg.crtime),
             vd->msg.topic,vd->msg.auxtpc[0] == '\0' ? "" : spr("(%s)",vd->msg.auxtpc));
     movmem(vd->msg.from,vd->msg.userto,UIDSIZ);
     movmem(vd->msg.from,vd->msg.to,UIDSIZ);
     movmem(usaptr->userid,vd->msg.from,UIDSIZ);
     sprintf(vd->msg.topic,rrrtpc,l2as(vd->msg.msgno));
     vd->msg.auxtpc[0]='\0';
     vd->msg.crdate=today();
     vd->msg.crtime=now();
     vd->msg.nreply=0;
     vd->msg.flags=0;
     vd->msg.msgno=++sv.msgtot;
     sendmsg(&vd->msg,NULL);
}


int
out_msg(void)                      /* output the current msg to the qwk file*/
{
     int i,mblocks;
     char wasto;
     struct SIG_MSGNO att;

     wasto=vd->msg.userto[0];
     vd->msg.userto[0]=uclchr(vd->msg.userto[0]);

     if (vd->msg.to[0] == SIGIDC) {
          if (vd->msg.userto[0] == wasto) {
               qwk_message_header->status=STATUS_NORMAL;
          }
          else {
               qwk_message_header->status=STATUS_NORMAL_READ;
          }
     }
     else {
          qwk_message_header->status=STATUS_RECEIVER_ONLY_READ;
     }
     copy_fill(qwk_message_header->number,l2as(vd->msg.msgno),7);
     copy_fill(qwk_message_header->date,spr("%02d-%02d-%02d",
                                            ddmon(vd->msg.crdate),
                                            ddday(vd->msg.crdate),
                                            ddyear(vd->msg.crdate)%100),8);
     copy_fill(qwk_message_header->time,spr("%02d:%02d",
                                            dthour(vd->msg.crtime),
                                            dtmin(vd->msg.crtime)),5);
     copy_fill(qwk_message_header->whoto,vd->msg.userto,25);
     copy_fill(qwk_message_header->from,vd->msg.from,25);
     copy_fill(qwk_message_header->subject,vd->msg.topic,25);
     copy_fill(qwk_message_header->password,"",12);
     if (sameto("Reply to #",vd->msg.auxtpc)) {
          copy_fill(qwk_message_header->reference,l2as(atol(&vd->msg.auxtpc[10])),8);
     }
     else {
          copy_fill(qwk_message_header->reference,"",8);
     }
     /* qwk_message_header->blocks is filled in after text created */
     qwk_message_header->active=MESSAGE_ACTIVE;
     qwk_message_header->conference=vd->current_sig+1;
     copy_fill(qwk_message_header->fill,"",FILLEN);

     i=0;
     if (vd->msg.text[0] != '\0') {
          while (vd->msg.text[i+1] != '\0') {
               if (vd->msg.text[i+1] == '\r' || vd->msg.text[i+1] == '\n') {
                    vd->msg.text[i+1]=PCBEOL;
               }
               i++;
          }
     }
     vd->msg.text[i+1]=PCBEOL;
     i++;
     if ((vd->msg.flags&FILATT)
      && accslv(usaptr->userid,vd->current_sig) >= DLAXES
      && ((vd->msg.flags&APPVED) || accslv(usaptr->userid,vd->current_sig) >= OPAXES)
      && fnd1st(&vd->fb,attach_fs(vd->current_sig,vd->msg.msgno),0)) {
          vd->msg.text[i+1]='\0';
          strcat(&vd->msg.text[i+1],getmsg(ATTDTEXT));
          sprintf(buffer,getmsg(ATTTEXT),vd->fb.size);
          strcat(&vd->msg.text[i+1],buffer);
          if (qscptr->flags&QSATT) {
               if ((vd->attach_file=fopen(spr("%s%d\\REQUEST.LST",QWKMAIL_DIR,usrnum),FOPAB)) == NULL) {
                    return(0);
               }
               att.sig=vd->current_sig;
               att.num=vd->msg.msgno;
               if (!fwrite(&att,sizeof(struct SIG_MSGNO),1,vd->attach_file)) {
                    return(0);
               }
               fclose(vd->attach_file);
               vd->attach_file=NULL;
               sprintf(buffer,getmsg(AINCTEXT),vd->msg.msgno);
               strcat(&vd->msg.text[i+1],buffer);
          }
          else {
               sprintf(buffer,getmsg(AREQTEXT),QWKMAIL_NAME,vd->msg.msgno);
               strcat(&vd->msg.text[i+1],buffer);
               vd->num_attachments++;
          }
          while (vd->msg.text[i+1] != '\0') {
               i++;
          }
     }
     while ((i-1)%128 != 0) {
          vd->msg.text[i+1]=' ';
          i++;
     }
     mblocks=(i-1)/128;

     copy_fill(qwk_message_header->blocks,spr("%d",1+mblocks),6);

     if (!zip_write(qwk_message_header,sizeof(struct QWK_MESSAGE_HEADER))) {
          return(0);
     }
     if (!zip_write(&vd->msg.text[1],mblocks*128)) {
          return(0);
     }

     qwk_index_record.block_number=long_to_mks(vd->current_block);
     qwk_index_record.conference=qwk_message_header->conference;

     if (!fwrite(&qwk_index_record,sizeof(struct QWK_INDEX_RECORD),1,vd->index_file)) {
          return(0);
     }

     vd->total_msgs++;
     vd->sig_msgs++;

     if (vd->msg.to[0] == SIGIDC && sameas(vd->msg.userto,usaptr->userid)) {
          if (vd->pindex_file == NULL) {
               if ((vd->pindex_file=fopen(spr("%s%d\\PERSONAL.NDX",QWKMAIL_DIR,usrnum),FOPWB)) == NULL) {
                    return(0);
               }
          }

          if (!fwrite(&qwk_index_record,sizeof(struct QWK_INDEX_RECORD),1,vd->pindex_file)) {
               return(0);
          }

          vd->personal_msgs++;
          vd->personal_sig_msgs++;

          vd->msg.userto[0]=wasto;
          if (sameas(usaptr->userid,vd->msg.userto)) {
               gcrbtv(&vd->msg,TONUM);
               vd->msg.userto[0]=clrchr(vd->msg.userto[0]);
               upvbtv(&vd->msg,NVMSIZ+strlen(vd->msg.text));
          }
     }

     vd->current_block+=1+mblocks;

     if (vd->current_sig == -1) {
          if (usaptr->emllim < vd->msg.msgno) {
               usaptr->emllim=vd->msg.msgno;
          }
     }
     else if (LSOFAR[vd->current_sig] < vd->msg.msgno) {
          LSOFAR[vd->current_sig]=vd->msg.msgno;
     }

     return(1);
}


int
done_dl(void)                      /* finished download, clean up and post */
{
     FILE *f;
     int n,i;
     struct fndblk fb;
     int sendnews;

     if ((f=fopen(spr("%s%d\\CONTROL.DAT",QWKMAIL_DIR,usrnum),FOPWA)) == NULL) {
          return(0);
     }
     fprintf(f,"%s\n",bbsttl);
     fprintf(f,"(The Major BBS)\n");
     fprintf(f,"%s\n",dataph);
     fprintf(f,"Sysop, Sysop\n");
     fprintf(f,"30000,%s\n",qwk_name);
     fprintf(f,"%02d-%02d-%04d,%02d:%02d:%02d\n",
                         ddmon(today()),
                         ddday(today()),
                         ddyear(today()),
                         dthour(now()),
                         dtmin(now()),
                         dtsec(now()));
     i=0;
     while (usaptr->userid[i] != '\0') {
          fprintf(f,"%c",toupper(usaptr->userid[i]));
          i++;
     }
     fprintf(f,"\n");
     fprintf(f,"\n");
     fprintf(f,"0\n");
     fprintf(f,"0\n");
     n=0;
     for (i=0; i <= sv.hisign; i++) {
          if (rdautl(i) > NOAXES) {
               n++;
          }
     }
     fprintf(f,"%d\n",n);
     fprintf(f,"0\n");
     fprintf(f,"E-mail\n");
     for (i=0; i <= sv.hisign; i++) {
          if (rdautl(i) > NOAXES) {
               fprintf(f,"%d\n",i+1);
               fprintf(f,"%s\n",&(sigoff(i)->signam[1]));
          }
     }
     sendnews=(newsfl[0] != '\0' && fnd1st(&fb,newsfl,0)
                                 && usaptr->usedat <= fb.date);
     fprintf(f,"\n");
     fprintf(f,"%s\n",sendnews ? newsfl : "");
     fprintf(f,"\n");
     fprintf(f,"0\n");
     fprintf(f,"24\n");

     fclose(f);

     if (sendnews) {
          if (!zip_copy(newsfl,newsfl)) {
               return(0);
          }
     }

     if (!zip_copy(spr("%s%d\\CONTROL.DAT",QWKMAIL_DIR,usrnum),"CONTROL.DAT")) {
          return(0);
     }
     if ((f=fopen(spr("%s%d\\DOOR.ID",QWKMAIL_DIR,usrnum),FOPWA)) == NULL) {
          return(0);
     }

     fprintf(f,"DOOR=GALQWK\n");
     fprintf(f,"VERSION=%s\n",version);
     fprintf(f,"SYSTEM=MajorBBS\n");
     fprintf(f,"RECEIPT\n");
     fprintf(f,"CONTROLNAME=GALQWK\n");
     fprintf(f,"CONTROLTYPE=REQUEST\n");

     fclose(f);

     if (!zip_copy(spr("%s%d\\DOOR.ID",QWKMAIL_DIR,usrnum),"DOOR.ID")) {
          return(0);
     }
     if (!zip_done()) {
          return(0);
     }
     fnd1st(&fb,spr("%s%d\\%s.QWK",QWKMAIL_DIR,usrnum,qwk_name),0);
     prfmsg(QWKRDY1,l2as(fb.size));
     outprf(usrnum);
     sbmqwk(qwksid[usrnum].protsl);
     numqwk--;
     return(1);
}

void
sbmqwk(char *protsl)               /* submit QWK packet for download       */
{
     if ((qwksid[usrnum].fnewb4=ftgnew()) != 0) {
          sprintf(ftgptr->tagspc,"%s.QWK",qwk_name);
          ftgptr->flags=FTGABL;
          ftgptr->tshndl=tshqwk;
     }
     qwksid[usrnum].gotbeg=0;
     ftgsbm(protsl);
     if (usrptr->state == mjmstt && sameto("T",protsl)) {
          prfmsg(usrptr->substt=MENU1);
     }
}

int
tshqwk(int tshcod)                /* Handle tagspecs for application       */
{                 /* implicit inputs: ftgptr,usrnum,usrptr,usaptr */
                   /* for TSHFIN and TSHHUP, vdaptr is also valid */
                        /* return value meaning depends on tshcod */
                   /* implicit input/output in many cases: tshmsg */
                           /* expect caller to do outprf() if any */
     int rc=0;

     setmbk(qwkmail_msgs);
     switch (tshcod) {
     case TSHDSC:                  /* Describe tagspec in English */
          sprintf(tshmsg,"QWK-mail packet %s.QWK",qwk_name);
          break;
     case TSHVIS:                        /* Visible to this user? */
          setmem(tshmsg,TSHLEN,0);           /*(suppress V option)*/
          rc=1;
          break;
     case TSHBEG:    /* Begin download, check permission, reserve */
          sprintf(tshmsg,"%s%d\\%s.QWK",QWKMAIL_DIR,usrnum,qwk_name);
          strcpy(ftfscb->fname,ftgptr->tagspc);
          qwksid[usrnum].gotbeg=1;
          rc=1;
          break;
     case TSHEND:   /* End complete download of a file, unreserve */
          unlink(spr("%s%d\\REQUEST.BAK",QWKMAIL_DIR,usrnum));
          qwksid[usrnum].wroteq=0;
          break;
     case TSHSKP:           /* Skip incomplete download of a file */
          qwksid[usrnum].gotbeg=2;
          break;
     case TSHFIN:                 /* Finish file transfer session */
          switch (qwksid[usrnum].gotbeg) {
          case 0:
               if (ftgnew() != qwksid[usrnum].fnewb4) {
                    break;              /* file was tagged for later  */
               }
          case 2:                       /* download was aborted       */
               restqs();
               prfmsg(PREVUS);
          case 1:                       /* TSHEND took care of things */
               break;
          }
          rc=0;
          break;
     case TSHHUP:      /* Finish session because user logging off */
          break;
     }
     return(rc);
}


void
abort_dl(void)                /* abort the download for whatever reason    */
{
     close_if_open(vd->zip_file);
     close_if_open(vd->zip_central_file);
     close_if_open(vd->index_file);
     close_if_open(vd->pindex_file);
     close_if_open(vd->attach_file);

     vd->zip_file        =NULL;
     vd->zip_central_file=NULL;
     vd->index_file      =NULL;
     vd->pindex_file     =NULL;
     vd->attach_file     =NULL;

     numqwk--;
}


void
upload_done(int ok)           /* routine to invoke when finished uploading */
{
     setmbk(qwkmail_msgs);
     if (ok) {
          sendmsg(&esgptr->msg,NULL);
          prfmsg(UPLDONE);
     }
     setmem(vd,sizeof(struct VOLATILE_DATA),0);
     usrptr->state=mjmstt;
     exit_qwkmail();
     prfmsg(usrptr->substt=MENU1);
}

void
upload_check(void)            /* check for newly uploaded reply packets    */
{
     int wait;

     setmbk(qwkmail_msgs);
     setbtv(esgbb);

     if (ul->msg_number) {
          if (cont_ul()) {
               wait=intra_packet;
          }
          else {
               wait=inter_packet;
          }
     }
     else if (start_ul()) {
          wait=intra_packet;
     }
     else {
          wait=inter_packet;
     }

     rtkick(wait,upload_check);
}


int
start_ul(void)                /* start the upload process                  */
{                             /* return 1 if not finished                  */
     int i;

     setmem(&compos,sizeof(compos),0);
     strcpy(compos.userid,QWKMAIL_NAME);
     compos.msgno=0;

     if (!agtbtv(&ul->msg,&compos,TONUM) || !sameas(ul->msg.to,QWKMAIL_NAME)) {
          ul->msg_number=0;
          return(0);
     }

     ul->msg_number=ul->msg.msgno;

     delbtv();
     sv.emlopn--;

     strcpy(ul->user_from,ul->msg.from);
     ul->user_from[0]=uclchr(ul->user_from[0]);

     ul->msgs_posted=0;

     if (!unzip_open(attach_fn(-1,ul->msg_number),spr("%s.MSG",qwk_name))) {
          finish_ul(NOTVALID);
          return(0);
     }

     if (unzip_read(buffer,128) < 128) {
          finish_ul(NOTVALID);
          return(0);
     }

     i=0;
     while (i < 128 && buffer[i] > ' ') {
          i++;
     }

     if (i < 128) {
          buffer[i]='\0';
     }
     else {
          finish_ul(NOTVALID);
          return(0);
     }

     if (!sameas(buffer,qwk_name)) {
          finish_ul(NOTVALID);
          return(0);
     }

     return(1);
}

int
cont_ul(void)                 /* continue upload procedure                 */
{                             /* return 1 if not finished                  */
     int blocks,sig,i,unread;
     long reference;
     char savtpc[TPCSIZ];
     char savto[UIDSIZ];
     struct mhsinf mhstmp;

     if (unzip_read((char *)qwk_message_header,sizeof(struct QWK_MESSAGE_HEADER)) < sizeof(struct QWK_MESSAGE_HEADER)) {
          finish_ul(POSTED0);
          return(0);
     }

     i=0;
     while (i < 5 && qwk_message_header->blocks[i] == ' ') {
          i++;
     }
     while (i < 5 && qwk_message_header->blocks[i] != ' ') {
          i++;
     }
     if (i >= 5) {
          finish_ul(NOTVALID);
          return(0);
     }

     qwk_message_header->blocks[i]='\0';
     blocks=atoi(qwk_message_header->blocks);
     if (blocks == 0 || blocks >= 128) {
          finish_ul(NOTVALID);
          return(0);
     }

     i=25;
     while (i > 0 && qwk_message_header->whoto[i-1] == ' ') {
          i--;
     }
     qwk_message_header->whoto[i]='\0';

     i=25;
     while (i > 0 && qwk_message_header->from[i-1] == ' ') {
          i--;
     }
     qwk_message_header->from[i]='\0';

     i=25;
     while (i > 0 && qwk_message_header->subject[i-1] == ' ') {
          i--;
     }
     qwk_message_header->subject[i]='\0';

     i=0;
     while (i < 4 && qwk_message_header->number[i] != ' ') {
          i++;
     }
     qwk_message_header->number[i]='\0';
     sig=atoi(qwk_message_header->number)-1;
     if (sig >= 0 && sig >= nsigs) {
          finish_ul(NOTVALID);
          return(0);
     }

     unread=(blocks-1)*128;

     savtpc[0]='\0';
     savto[0]='\0';
     mhstmp.addr[0]='\0';
     if (qwk_message_header->reference[0] == ' ') {
          reference=0;
     }
     else if ((reference=atol(qwk_message_header->reference)) > 0) {
          setmem(&compos,sizeof(compos),0);
          strcpy(compos.userid,(sig >= 0) ? sigoff(sig)->signam : ul->user_from);
          compos.msgno=reference;
          if (acqbtv(&ul->msg,&compos,TONUM)) {
               ul->msg.nreply++;
               upvbtv(&ul->msg,NVMSIZ+strlen(ul->msg.text));
               strcpy(savtpc,ul->msg.topic);
               strcpy(savto,ul->msg.from);
               if (ul->msg.flags&MHSMSG) {
                    setbtv(mhsbb);
                    if (!acqbtv(&mhstmp,&ul->msg.msgno,0)) {
                         mhstmp.addr[0]='\0';
                    }
                    rstbtv();
               }
          }
     }
     if (qwk_message_header->status == STATUS_RECEIVER_ONLY
      || qwk_message_header->status == STATUS_RECEIVER_ONLY_READ) {
          sig=-1;        /* (E)mail reply */
     }
     else if (sig >= 0) {
          mhstmp.addr[0]='\0';
     }

     if (qwk_message_header->active == MESSAGE_INACTIVE
      || dwreqs(sig)
      || accslv(ul->user_from,sig) < WRAXES
       && (sig >= 0 || !sameas(qwk_message_header->whoto,"Sysop"))
      || sig >= 0 && !gtstcrd(ul->user_from,(long)sigtck,0)
      || sig < 0 && !gtstcrd(ul->user_from,(long)emltck,0)
       && !sameas(qwk_message_header->whoto,"Sysop")
      || (valto
       && !sameas(qwk_message_header->whoto,"All")
       && !sameas(qwk_message_header->whoto,ALL)
       && !sameas(qwk_message_header->whoto,"Netmail")
       && !valmhs(qwk_message_header->whoto)
       && !valmhs(mhstmp.addr)
       && !uidxst(qwk_message_header->whoto)
       && !uidxst(savto))) {
          while (unread > 0) {
               unread-=unzip_read(buffer,min(unread,BUFFER_SIZE));
          }
          return(1);
     }

     if (qwk_message_header->date[2] != '-'
      || qwk_message_header->date[5] != '-'
      || qwk_message_header->time[2] != ':'
      || strlen(qwk_message_header->whoto) >= UIDSIZ
      || strlen(qwk_message_header->from) >= UIDSIZ) {
          finish_ul(NOTVALID);
          return(0);
     }

     setmem(&ul->msg,NVMSIZ,0);
     ul->msg.msgno=++sv.msgtot;
     strcpy(ul->msg.userto,(sameas(qwk_message_header->whoto,"All") ? ALL : qwk_message_header->whoto));
     strcpy(ul->msg.from,ul->user_from);
     strcpy(ul->msg.to,(sig >= 0 ? sigoff(sig)->signam : qwk_message_header->whoto));
     if (sameasn(ul->msg.to,savto,25)) {
          strcpy(ul->msg.to,savto);
          strcpy(ul->msg.userto,savto);
     }
     if (sig < 0
      && qwk_message_header->subject[0] == 'R'
      && qwk_message_header->subject[1] == 'R'
      && qwk_message_header->subject[2] == 'R') {
          stzcpy(ul->msg.topic,&qwk_message_header->subject[3],TPCSIZ);
          ul->msg.flags|=RECREQ;
     }
     else {
          stzcpy(ul->msg.topic,qwk_message_header->subject,TPCSIZ);
     }
     if (strncmp(ul->msg.topic,savtpc,25) == 0) {
          strcpy(ul->msg.topic,savtpc);
     }
     if (reference > 0) {
          sprintf(ul->msg.auxtpc,"Reply to #%ld",reference);
     }
     ul->msg.crdate=today();
     ul->msg.crtime=now();

     i=min(unread,BUFFER_SIZE);
     unread-=i;
     i=unzip_read(buffer,i);

     i=min(msg_size,i);
     movmem(buffer,&ul->msg.text[1],i);

     while (unread > 0) {
          unread-=unzip_read(buffer,min(unread,BUFFER_SIZE));
     }

     while (i > 0 && (ul->msg.text[i] == ' ' || ul->msg.text[i] == PCBEOL)) {
          i--;
     }
     ul->msg.text[i+1]='\0';

     while (i > 0) {
          if (ul->msg.text[i] == PCBEOL) {
               ul->msg.text[i]='\r';
          }
          i--;
     }
     ul->msg.text[0]='\r';

     if (sendmsg(&ul->msg,mhstmp.addr)) {
          if (sig >= 0) {
               gdedcrd(ul->user_from,(long)sigtck,0,1);
          }
          else {
               gdedcrd(ul->user_from,(long)emltck,0,1);
          }
          if (!autfwd && onsysn(ul->msg.userto,1)) {
               if (sig >= 0) {
                    prfmlt(SWRITTEN,ul->user_from,ul->msg.to);
               }
               else {
                    prfmlt(EWRITTEN,ul->user_from);
               }
               injoth();
          }
          ul->msgs_posted++;
     }
     return(1);
}

int
sameasn(stg1,stg2,n)          /* Are strings same, up to n chars? (U/L N/A) */
char *stg1,*stg2;
int n;
{
     int i;

     for (i=0 ; i < n && *stg1 != '\0' ; i++) {
          if (tolower(*stg1) != tolower(*stg2)) {
               return(0);
          }
          stg1++;
          stg2++;
     }
     return(i == n || *stg2 == '\0');
}

int
dwreqs(int sig)               /* deal with requests                        */
{
     struct SIG_MSGNO att;
     FILE *f;

     if (sameas(qwk_message_header->whoto,QWKMAIL_NAME)
       && sameto("REQUEST ",qwk_message_header->subject)
       && (att.num=atol(&qwk_message_header->subject[8])) > 0
       && onsysn(ul->user_from,1)
       && accslv(ul->user_from,sig) >= DLAXES) {
          att.sig=sig;
          setmem(&compos,sizeof(compos),0);
          strcpy(compos.userid,(sig >= 0) ? sigoff(sig)->signam : ul->user_from);
          compos.msgno=att.num;
          if (acqbtv(&ul->msg,&compos,TONUM)
           && (f=fopen(spr("%s%d\\REQUEST.BAK",QWKMAIL_DIR,othusn),FOPAB)) != NULL) {
               fwrite(&att,sizeof(struct SIG_MSGNO),1,f);
               fclose(f);
          }
          return(1);
     }
     return(0);
}

void
finish_ul(int error_msg)      /* finish upl, charging credits, post confirm*/
{
     if (onsysn(ul->user_from,1)) {
          prfmlt(FMMMGR);
          if (ul->msgs_posted > 0) {
               if (ul->msgs_posted == 1) {
                    prfmlt(POSTED1);
               }
               else {
                    prfmlt(POSTED2,ul->msgs_posted);
               }
          }
          else {
               prfmlt(error_msg);
          }
          if (exist(spr("%s%d\\REQUEST.BAK",QWKMAIL_DIR,othusn))) {
               prfmlt(POSTEDR);
          }
          injoth();
     }
     unzip_close();
     delete_ul();
     ul->msg_number=0;
}


int
accslv(char *userid,int signo)/* access level of user in sig (-1 for email)*/
{
     struct qscfg *othuqp;

     if (uhskey(userid,sigsys)) {
          return(SYAXES);
     }
     if (signo < 0) {
          if (uhskey(userid,emlkey)) {
               if (gtstcrd(userid,(long)emltck,0)) {
                    return(OPAXES);
               }
          }
          return(DLAXES);
     }
     if ((othuqp=getqsc(userid,sopqsc)) == NULL) {
          return(NOAXES);
     }
     return(alvutl(othuqp,signo));
}

void
delete_ul(void)               /* del attachment for msg number ul->msg_number*/
{
     unlink(attach_fn(-1,ul->msg_number));
}



char *
attach_fn(int sig,long msgno) /* attachment filename routines              */
{
     static char filespec[FSPSIZ];
     char *fnp;
     int fnplen;

     strcpy(filespec,sig == -1 ? "EMAIL" : &(sigoff(sig)->signam[1]));
     fnp=spr("\\%ld.ATT",msgno);
     while ((fnplen=strlen(fnp)) >= 14) {         /* ensures over 2 billion */
          fnp[fnplen-2]=fnp[fnplen-1];            /*   unique filenames     */
          fnp[fnplen-1]=fnp[1];
          movmem(fnp+2,fnp+1,strlen(fnp+1));
     }
     strcat(filespec,fnp);
     return(filespec);
}

char *
attach_fs(int sig,long msgno) /* attachment filespec, net (may be indirect) */
{
     FILE *indrfp;
     struct fndblk fb;
     char *filespec;
     static char indrfs[FSPSIZ];

     filespec=attach_fn(sig,msgno);
     if (fnd1st(&fb,filespec,0)
       && fb.size == FSPSIZ-1
       && (indrfp=fopen(filespec,FOPRA)) != NULL) {
          if (fread(indrfs,FSPSIZ-1,1,indrfp) == 1
            && fnd1st(&fb,indrfs,0)) {
               filespec=indrfs;
          }
          fclose(indrfp);
     }
     return(filespec);
}

                                   /* zip file utility routines            */
int
zip_init(char *fn)
{
     if ((vd->zip_file=fopen(fn,FOPWB"+")) == NULL) {
          return(0);
     }
     if ((vd->zip_central_file=fopen(spr("%s%d\\ZCENTRAL",QWKMAIL_DIR,usrnum),FOPWB"+")) == NULL) {
          return(0);
     }
     vd->znum=0;

     return(1);
}

int
zip_open(char *fn)
{
     vd->zoffset=ftell(vd->zip_file);

     vd->zlhdr.signature   =ZIP_LOCAL_HEADER_SIG;
     vd->zlhdr.ver_needed  =0;
     vd->zlhdr.gen_flags   =0;
     vd->zlhdr.compression =ZIP_STORED;
     vd->zlhdr.ftime       =now();
     vd->zlhdr.fdate       =today();
     vd->zlhdr.crc         =0xffffffffL;
     vd->zlhdr.compressed  =0;
     vd->zlhdr.uncompressed=0;
     vd->zlhdr.filename_len=strlen(fn);
     vd->zlhdr.extra_len   =0;
     strcpy(vd->zlhdr.filename,fn);

     if (!fwrite(&vd->zlhdr,sizeof(struct ZIP_LOCAL_HEADER)-13+strlen(fn),1,vd->zip_file)) {
          return(0);
     }
     return(1);
}

int
zip_write(void *buf,int len)
{
     vd->zlhdr.crc=crc32block(buf,len,vd->zlhdr.crc);

     if (!fwrite(buf,len,1,vd->zip_file)) {
          return(0);
     }
     vd->zlhdr.uncompressed+=len;

     return(1);
}

int
zip_close(void)
{
     vd->zlhdr.crc=~vd->zlhdr.crc;
     vd->zlhdr.compressed=vd->zlhdr.uncompressed;

     fseek(vd->zip_file,vd->zoffset+14,SEEK_SET);
     if (!fwrite(&vd->zlhdr.crc,12,1,vd->zip_file)) {
          return(0);
     }
     fseek(vd->zip_file,0,SEEK_END);

     zip_central_record->signature          =ZIP_CENTRAL_RECORD_SIG;
     zip_central_record->ver_made_by        =0;
     zip_central_record->ver_needed         =vd->zlhdr.ver_needed;
     zip_central_record->gen_flags          =vd->zlhdr.gen_flags;
     zip_central_record->compression        =vd->zlhdr.compression;
     zip_central_record->ftime              =vd->zlhdr.ftime;
     zip_central_record->fdate              =vd->zlhdr.fdate;
     zip_central_record->crc                =vd->zlhdr.crc;
     zip_central_record->compressed         =vd->zlhdr.compressed;
     zip_central_record->uncompressed       =vd->zlhdr.uncompressed;
     zip_central_record->filename_len       =vd->zlhdr.filename_len;
     zip_central_record->extra_len          =vd->zlhdr.extra_len;
     zip_central_record->fcomment_len       =0;
     zip_central_record->disk_start         =0;
     zip_central_record->internal_attrs     =0;
     zip_central_record->external_attrs     =0;
     zip_central_record->local_header_offset=vd->zoffset;
     strcpy(zip_central_record->filename,vd->zlhdr.filename);

     if (!fwrite(zip_central_record,sizeof(struct ZIP_CENTRAL_RECORD)-13+strlen(vd->zlhdr.filename),1,vd->zip_central_file)) {
          return(0);
     }
     vd->znum++;

     return(1);
}

int
zip_copy(char *src,char *dest)
{
     FILE *srcf;
     int n;

     if ((srcf=fopen(src,FOPRB)) == NULL) {
          return(0);
     }
     if (!zip_open(dest)) {
          return(0);
     }
     while (1) {
          n=fread(buffer,1,BUFFER_SIZE,srcf);
          if (n == 0) {
               break;
          }
          if (!zip_write(buffer,n)) {
               return(0);
          }
     }

     if (!zip_close()) {
          return(0);
     }
     fclose(srcf);

     return(1);
}

int
zip_done(void)
{
     int n;
     long central_offset,central_size;

     central_offset=ftell(vd->zip_file);
     central_size=ftell(vd->zip_central_file);

     fseek(vd->zip_central_file,0,SEEK_SET);
     while (1) {
          n=fread(buffer,1,BUFFER_SIZE,vd->zip_central_file);
          if (n == 0) {
               break;
          }
          if (!fwrite(buffer,n,1,vd->zip_file)) {
               return(0);
          }
     }

     zip_end_central_record->signature           =ZIP_END_CENTRAL_RECORD_SIG;
     zip_end_central_record->disk_number         =0;
     zip_end_central_record->central_dir_disk    =0;
     zip_end_central_record->central_entries_disk=vd->znum;
     zip_end_central_record->central_entries     =vd->znum;
     zip_end_central_record->central_size        =central_size;
     zip_end_central_record->central_start_offset=central_offset;
     zip_end_central_record->zcomment_len        =0;

     if (!fwrite(zip_end_central_record,sizeof(struct ZIP_END_CENTRAL_RECORD),1,vd->zip_file)) {
          return(0);
     }

     fclose(vd->zip_file);
     vd->zip_file=NULL;

     fclose(vd->zip_central_file);
     vd->zip_central_file=NULL;

     unlink(spr("%s%d\\ZCENTRAL",QWKMAIL_DIR,usrnum));

     return(1);
}

                              /* unzip utility routines                    */
int
unzip_open(char *zn,char *fn)
{
     int i;

     if ((uz.zip_file=fopen(zn,FOPRB)) == NULL) {
          return(0);
     }

     if (!fread(&uz.zlhdr,sizeof(struct ZIP_LOCAL_HEADER)-13,1,uz.zip_file)) {
          fclose(uz.zip_file);
          uz.zip_file=NULL;
          return(0);
     }

     if (uz.zlhdr.signature != ZIP_LOCAL_HEADER_SIG) {
          fseek(uz.zip_file,0,SEEK_SET);
          uz.zlhdr.compression=ZIP_STORED;
          uz.zlhdr.compressed=0x7fffffffL;
          return(1);
     }

     setmem(uz.zlhdr.filename,13,0);
     if (!fread(uz.zlhdr.filename,min(uz.zlhdr.filename_len,12),1,uz.zip_file)) {
          fclose(uz.zip_file);
          uz.zip_file=NULL;
          return(0);
     }
     if (fn != NULL && !sameas(fn,uz.zlhdr.filename)) {
          fclose(uz.zip_file);
          uz.zip_file=NULL;
          return(0);
     }

     if (uz.zlhdr.extra_len) {
          fseek(uz.zip_file,uz.zlhdr.extra_len,SEEK_CUR);
     }

     uz.zip_eof=0;
     uz.crc=0xffffffffL;
     uz.input_index=0;
     uz.input_avail=0;
     uz.input_offset=0;
     uz.output_index=0;
     uz.output_avail=0;
     uz.output_offset=0;
     uz.bits_left=0;
     setmem(uz.output_buf,OUTPUT_BUFFER_SIZE,0);

     switch (uz.zlhdr.compression) {
     case ZIP_STORED:
          break;
     case ZIP_SHRUNK:
          uz.code_bits=INIT_BITS;
          uz.first_free=FIRST_ENTRY;
          setmem(uz.prefix_of,ZIP_BUFFER_SIZE*sizeof(int),0xff);
          for (i=0; i < 256; i++) {
               uz.prefix_of[i]=0;
               uz.suffix_of[i]=i;
          }
          uz.last_code=read_bits(uz.code_bits);
          if (uz.zip_eof) {
               fclose(uz.zip_file);
               uz.zip_file=NULL;
               return(0);
          }
          uz.final_char=uz.last_code;
          output_byte(uz.final_char);
          uz.stack_index=0;
          break;
     case ZIP_IMPLODED:
          if (uz.zlhdr.gen_flags&2) {
               uz.lower_dict_bits=7;
          }
          else {
               uz.lower_dict_bits=6;
          }
          if (uz.zlhdr.gen_flags&4) {
               uz.min_match_length=3;
               load_sf_tree(&uz.literal_tree,256);
               uz.literal_tree_present=1;
          }
          else {
               uz.min_match_length=2;
               uz.literal_tree_present=0;
          }
          load_sf_tree(&uz.length_tree,64);
          load_sf_tree(&uz.distance_tree,64);
          break;
     case ZIP_DEFLATED:
          zp.lbits=9;
          zp.dbits=6;
          zp.wp=0;
          zp.bk=0;
          zp.bb=0;
          zp.h2=0;
          zp.hufts=0;
          zp.defstate=INFLATE2;
          zp.csize=uz.zlhdr.compressed;
          break;
     default:
          fclose(uz.zip_file);
          uz.zip_file=NULL;
          return(0);
     }
     return(1);
}

int
unzip_read(char *p,int n)
{
     int start_output,i;

     start_output=uz.output_index-uz.output_avail;
     if (start_output < 0) {
          start_output+=OUTPUT_BUFFER_SIZE;
     }
     switch (uz.zlhdr.compression) {
     case ZIP_STORED:
          if (uz.zlhdr.compressed < n) {
               n=(int)uz.zlhdr.compressed;
          }
          i=fread(p,1,n,uz.zip_file);
          uz.zlhdr.compressed-=i;
          return(i);
     case ZIP_SHRUNK:
          {
               int this_code, code;
               int prefix;

               while (uz.output_avail < n && !uz.zip_eof) {
read_again:
                    code=read_bits(uz.code_bits);
                    if (uz.zip_eof)
                         break;
                    if (code == CLEAR_CODE) {
                         code=read_bits(uz.code_bits);
                         switch (code) {
                         case 1:
                              uz.code_bits++;
                              break;
                         case 2:
                              for (code=FIRST_ENTRY ; code < uz.first_free ; code++) {
                                   uz.prefix_of[code]|=0x8000;
                              }
                              for (code=FIRST_ENTRY ; code < uz.first_free ; code++) {
                                   prefix=uz.prefix_of[code]&0x7fff;
                                   if (prefix >= FIRST_ENTRY) {
                                        uz.prefix_of[prefix]&=0x7fff;
                                   }
                              }
                              for (code=FIRST_ENTRY ; code < uz.first_free ; code++) {
                                   if (uz.prefix_of[code]&0x8000) {
                                        uz.prefix_of[code]=-1;
                                   }
                              }
                              uz.first_free=FIRST_ENTRY;
                              while (uz.first_free < MAX_CODE && uz.prefix_of[uz.first_free] != -1) {
                                   uz.first_free++;
                              }
                              break;
                         }
                         goto read_again;
                    }
                    this_code=code;
                    if (uz.prefix_of[code] == -1) {
                         uz.stack[uz.stack_index++]=uz.final_char;
                         code=uz.last_code;
                    }
                    while (code >= FIRST_ENTRY) {
                         uz.stack[uz.stack_index++]=uz.suffix_of[code];
                         code=uz.prefix_of[code];
                    }
                    uz.final_char=uz.suffix_of[code];
                    uz.stack[uz.stack_index++]=uz.final_char;
                    while (uz.stack_index) {
                         output_byte(uz.stack[--uz.stack_index]);
                    }
                    code=uz.first_free;
                    if (code < MAX_CODE) {
                         uz.prefix_of[code]=uz.last_code;
                         uz.suffix_of[code]=uz.final_char;
                         while (uz.first_free < MAX_CODE && uz.prefix_of[uz.first_free] != -1) {
                              uz.first_free++;
                         }
                    }
                    uz.last_code=this_code;
               }
          }
          break;
     case ZIP_IMPLODED:
          {
               int distance, length;
               int back_index;

               while (uz.output_avail < n && !uz.zip_eof && uz.output_offset < uz.zlhdr.uncompressed) {
                    if (read_bits(1)) {
                         if (uz.literal_tree_present) {
                              output_byte(read_via_tree(&uz.literal_tree));
                              if (uz.zip_eof) {
                                   break;
                              }
                         }
                         else {
                              output_byte(read_bits(8));
                              if (uz.zip_eof) {
                                   break;
                              }
                         }
                    }
                    else {
                         if (uz.zip_eof) {
                              break;
                         }
                         distance=read_bits(uz.lower_dict_bits) + (read_via_tree(&uz.distance_tree) << uz.lower_dict_bits);
                         if (uz.zip_eof) {
                              break;
                         }
                         length=read_via_tree(&uz.length_tree) + uz.min_match_length;
                         if (uz.zip_eof) {
                              break;
                         }
                         if (length == 63 + uz.min_match_length) {
                              length += read_bits(8);
                         }
                         back_index=uz.output_index - (distance+1);
                         if (back_index < 0) {
                              /* uz.output_buf is initialized to zero so we */
                              /* deal with the output wrap below 0 properly */
                              back_index += OUTPUT_BUFFER_SIZE;
                         }
                         while (length) {
                              output_byte(uz.output_buf[back_index]);
                              back_index=(back_index + 1) % OUTPUT_BUFFER_SIZE;
                              length--;
                         }
                    }
               }
          }
          break;
     case ZIP_DEFLATED:
          {
               while (outcnt < n && zp.defstate != INFOK
                && zp.defstate != INFNOK) {
                    inflate();
               }
               if (zp.defstate == INFNOK) {
                    return(0);
               }
               i=0;
               while (i < n && outcnt) {
                    *p++=uz.output_buf[i];
                    i++;
                    outcnt--;
               }
               movmem(&uz.output_buf[i],uz.output_buf,outcnt);
               return(i);
          }
     }
     i=0;
     while (i < n && uz.output_avail) {
          *p++=uz.output_buf[start_output];
          start_output=(start_output+1)%OUTPUT_BUFFER_SIZE;
          i++;
          uz.output_avail--;
     }
     return(i);
}

STATIC int
initfixd(void)                     /* init inflate of fixed code block     */
{
     int i;

     for (i=0 ; i < 144 ; i++) {
          zp.ll4[i]=8;
     }
     for (; i < 256 ; i++) {
          zp.ll4[i]=9;
     }
     for (; i < 280 ; i++) {
          zp.ll4[i]=7;
     }
     for (; i < 288 ; i++) {
          zp.ll4[i]=8;
     }
     zp.bl4=7;
     if ((i=huft_build(zp.ll4,288,257,cplens,cplext,&zp.tl4,&zp.bl4)) != 0) {
          return(0);
     }
     for (i=0 ; i < 30 ; i++) {
          zp.ll4[i]=5;
     }
     zp.bd4=5;
     if ((i=huft_build(zp.ll4,30,0,cpdist,cpdext,&zp.td4,&zp.bd4)) > 1) {
          huft_free(zp.tl4);
          return(0);
     }
     return(1);
}

void
inflate(void)                      /* Routine to INFLATE deflated .ZIPs    */
{
     unsigned i;

     switch (zp.defstate) {
     case INFLATE2:
          zp.b3=zp.bb;
          zp.k3=zp.bk;
          NEEDBITS4(1)
          zp.e2=(int)zp.b3&1;
          DUMPBITS4(1)
          NEEDBITS4(2)
          zp.t3=(unsigned)zp.b3&3;
          DUMPBITS4(2)
          zp.bb=zp.b3;
          zp.bk=zp.k3;
          switch (zp.t3) {
          case 2:
               zp.defstate=INFLATE3;
               break;
          case 1:
               if (initfixd()) {
                    zp.defstate=INFLATE4;
                    break;
               }
          default:
               zp.defstate=INFNOK;
          }
          return;
     case INFLATE3:
          zp.b4=zp.bb;
          zp.k4=zp.bk;
          NEEDBITS3(5)
          zp.nl4=257+((unsigned)zp.b4&0x1f);
          DUMPBITS3(5)
          NEEDBITS3(5)
          zp.nd4=1+((unsigned)zp.b4&0x1f);
          DUMPBITS3(5)
          NEEDBITS3(4)
          zp.nb4=4+((unsigned)zp.b4&0xf);
          DUMPBITS3(4)
          if (zp.nl4 > 286 || zp.nd4 > 30) {
               zp.defstate=INFNOK;
               return;
          }
          for (zp.j4=0 ; zp.j4 < zp.nb4 ; zp.j4++) {
               NEEDBITS3(3)
               zp.ll4[border[zp.j4]]=(unsigned)zp.b4&7;
               DUMPBITS3(3)
          }
          for ( ; zp.j4 < 19 ; zp.j4++) {
               zp.ll4[border[zp.j4]]=0;
          }
          zp.bl4=7;
          if ((zp.i4=huft_build(zp.ll4,19,19,NULL,NULL,
              &zp.tl4,&zp.bl4)) != 0) {
               if (zp.i4 == 1) {
                    huft_free(zp.tl4);
               }
               zp.defstate=INFNOK;
               return;
          }
          zp.n4=zp.nl4+zp.nd4;
          zp.m4=mask_bits[zp.bl4];
          zp.i4=zp.l4=0;
          while ((unsigned)zp.i4 < zp.n4) {
               NEEDBITS3((unsigned)zp.bl4)
               zp.j4=(zp.td4=zp.tl4+((unsigned)zp.b4&zp.m4))->b;
               DUMPBITS3(zp.j4)
               zp.j4=zp.td4->v.n;
               if (zp.j4 < 16) {
                    zp.ll4[zp.i4++]=zp.l4=zp.j4;
               }
               else if (zp.j4 == 16) {
                    NEEDBITS3(2)
                    zp.j4=3+((unsigned)zp.b4&3);
                    DUMPBITS3(2)
                    if ((unsigned)zp.i4+zp.j4 > zp.n4) {
                         zp.defstate=INFNOK;
                         return;
                    }
                    while (zp.j4--)
                         zp.ll4[zp.i4++]=zp.l4;
               }
               else if (zp.j4 == 17) {
                    NEEDBITS3(3)
                    zp.j4=3+((unsigned)zp.b4&7);
                    DUMPBITS3(3)
                    if ((unsigned)zp.i4+zp.j4 > zp.n4) {
                         zp.defstate=INFNOK;
                         return;
                    }
                    while (zp.j4--) {
                         zp.ll4[zp.i4++]=0;
                    }
                    zp.l4=0;
               }
               else {
                    NEEDBITS3(7)
                    zp.j4=11+((unsigned)zp.b4&0x7f);
                    DUMPBITS3(7)
                    if ((unsigned)zp.i4+zp.j4 > zp.n4) {
                         zp.defstate=INFNOK;
                         return;
                    }
                    while (zp.j4--) {
                         zp.ll4[zp.i4++]=0;
                    }
                    zp.l4=0;
               }
          }
          huft_free(zp.tl4);
          zp.bb=zp.b4;
          zp.bk=zp.k4;
          zp.bl4=zp.lbits;
          if ((zp.i4=huft_build(zp.ll4,zp.nl4,257,cplens,cplext,
               &zp.tl4,&zp.bl4)) != 0) {
               if (zp.i4 == 1) {
                    huft_free(zp.tl4);
               }
               zp.defstate=INFNOK;
               return;
          }
          zp.bd4=zp.dbits;
          if ((zp.i4=huft_build(zp.ll4+zp.nl4,zp.nd4,0,
              cpdist,cpdext,&zp.td4,&zp.bd4)) != 0) {
               if (zp.i4 == 1) {
                    huft_free(zp.td4);
               }
               huft_free(zp.tl4);
               zp.defstate=INFNOK;
               return;
          }
          zp.defstate=INFLATE4;
          return;
     case INFLATE4:
          zp.b5=zp.bb;
          zp.k5=zp.bk;
          zp.w5=zp.wp;
          zp.ml5=mask_bits[zp.bl4];
          zp.md5=mask_bits[zp.bd4];
          zp.defstate=INFLATE5;
          return;
     case INFLATE5:
          NEEDBITS5((unsigned)zp.bl4)
          if ((zp.e5=(zp.t5=zp.tl4+
              ((unsigned)zp.b5&zp.ml5))->e) > 16) {
               do {
                    if (zp.e5 == 99) {
                         zp.defstate=INFNOK;
                    }
                    DUMPBITS5(zp.t5->b)
                    zp.e5-=16;
                    NEEDBITS5(zp.e5)
               } while ((zp.e5=(zp.t5=zp.t5->v.t+
                 ((unsigned)zp.b5&mask_bits[zp.e5]))->e) > 16);
          }
          DUMPBITS5(zp.t5->b)
          if (zp.e5 == 16) {
               slide[zp.w5++]=outb((unsigned char)zp.t5->v.n);
               if (zp.w5 == WSIZE) {
                    zp.w5=0;
               }
          }
          else {
               /* exit if end of block */
               if (zp.e5 == 15) {
                    zp.defstate=INFLATE6;
                    return;
               }
               NEEDBITS5(zp.e5)
               zp.n5=zp.t5->v.n+((unsigned)zp.b5&mask_bits[zp.e5]);
               DUMPBITS5(zp.e5);
               NEEDBITS5((unsigned)zp.bd4)
               if ((zp.e5=(zp.t5=zp.td4+
                   ((unsigned)zp.b5&zp.md5))->e) > 16) {
                    do {
                         if (zp.e5 == 99) {
                              zp.defstate=INFNOK;
                         }
                         DUMPBITS5(zp.t5->b)
                         zp.e5-=16;
                         NEEDBITS5(zp.e5)
                    } while ((zp.e5=(zp.t5=zp.t5->v.t+
                       ((unsigned)zp.b5&mask_bits[zp.e5]))->e)
                        > 16);
               }
               DUMPBITS5(zp.t5->b)
               NEEDBITS5(zp.e5)
               zp.d5=zp.w5-zp.t5->v.n-((unsigned)zp.b5&mask_bits[zp.e5]);
               DUMPBITS5(zp.e5)
               zp.defstate=INFLATE7;
               return;
          }
          return;
     case INFLATE6:
          zp.wp=zp.w5;
          zp.bb=zp.b5;
          zp.bk=zp.k5;
          huft_free(zp.tl4);
          huft_free(zp.td4);
          if (zp.hufts > zp.h2) {
               zp.h2=zp.hufts;
          }
          if (!zp.e2) {
               zp.hufts=0;
               zp.defstate=INFLATE2;
               return;
          }
          zp.defstate=INFOK;
          return;
     case INFLATE7:
          zp.n5-=(zp.e5=(zp.e5=WSIZE-((zp.d5&=WSIZE-1)
           > zp.w5 ? zp.d5 : zp.w5)) > zp.n5 ? zp.n5 :
            zp.e5);
          if (zp.w5-zp.d5 >= zp.e5) {
               for (i=0 ; i < zp.e5 ; i++) {
                    slide[zp.w5+i]=outb(slide[zp.d5+i]);
               }
               zp.w5+=zp.e5;
               zp.d5+=zp.e5;
          }
          else {
               do {
                    slide[zp.w5++]=outb(slide[zp.d5++]);
               } while (--zp.e5);
          }
          if (zp.w5 == WSIZE) {
               zp.w5=0;
          }
          if (!zp.n5) { /* 3 */
               zp.defstate=INFLATE5;
          }
          return;
     }
}

int                                /* build huftman tables                 */
huft_build(unsigned *b,
           unsigned n,
           unsigned s,
           unsigned short *d,
           unsigned short *e,
           struct huft **t,
           int *m)
{
     unsigned a;                   /* counter for codes of length k        */
     unsigned c[BMAX+1];           /* bit length count table               */
     unsigned f;                   /* i repeats in table every f entries   */
     int g;                        /* maximum code length                  */
     int h;                        /* table level                          */
     unsigned int i;               /* counter, current code                */
     unsigned int j;               /* counter                              */
     int k;                        /* number of bits in current code       */
     int l;                        /* bits per table (returned in m)       */
     unsigned int *p;              /* pointer into c[], b[], or v[]        */
     struct huft *q;               /* points to current table              */
     struct huft r;                /* table entry for structure assignment */
     struct huft *u[BMAX];         /* table stack                          */
     unsigned v[N_MAX];            /* values in order of bit length        */
     int w;                        /* bits before this table == (l * h)    */
     unsigned x[BMAX+1];           /* bit offsets, then code stack         */
     unsigned *xp;                 /* pointer into x                       */
     int y;                        /* number of dummy codes added          */
     unsigned z;                   /* number of entries in current table   */

     memset(c,0,sizeof(c));
     p=b;
     i=n;
     do {
          c[*p++]++;
     } while (--i);
     if (c[0] == n) {
          *t=(struct huft *)NULL;
          *m=0;
          return(0);
     }
     l=*m;
     for (j=1 ; j <= BMAX ; j++) {
          if (c[j]) {
               break;
          }
     }
     k=j;
     if ((unsigned)l < j) {
          l=j;
     }
     for (i=BMAX ; i ; i--) {
          if (c[i]) {
               break;
          }
     }
     g=i;
     if ((unsigned)l > i) {
          l=i;
     }
     *m=l;
     for (y=1<<j ; j < i ; j++,y<<=1) {
          if ((y-=c[j]) < 0) {
               return(2);
          }
     }
     if ((y-=c[i]) < 0) {
          return(2);
     }
     c[i]+=y;
     x[1]=j=0;
     p=c+1;
     xp=x+2;
     while (--i) {
          *xp++=(j+=*p++);
     }
     p=b;
     i=0;
     do {
          if ((j=*p++) != 0) {
               v[x[j]++]=i;
          }
     } while (++i < n);

     x[0]=i=0;
     p=v;
     h=-1;
     w=-l;
     u[0]=(struct huft *)NULL;
     q=(struct huft *)NULL;
     z=0;

     for ( ; k <= g ; k++) { /* 1 */
          a=c[k];
          while (a--) { /* 2 */
               while (k > w+l) { /* 3 */
                    h++;
                    w+=l;
                    z=(z=g-w) > (unsigned)l ? l : z;
                    if ((f=1 << (j=k-w)) > a+1) {
                         f-=a+1;
                         xp=c+k;
                         while (++j < z) {
                              if ((f <<= 1) <= *++xp) {
                                   break;
                              }
                              f-=*xp;
                         }
                    }
                    z=1 << j;

                    if ((q=(struct huft *)malloc((z+1)*sizeof(struct huft))) ==
                        (struct huft *)NULL) {
                         if (h) {
                              huft_free(u[0]);
                         }
                         return(3);
                    }
                    zp.hufts+=z+1;
                    *t=q+1;
                    *(t=&(q->v.t))=(struct huft *)NULL;
                    u[h]=++q;
                    if (h) {
                         x[h]=i;
                         r.b=(unsigned char)l;
                         r.e = (unsigned char)(16 + j);
                         r.v.t=q;
                         j=i>>(w-l);
                         u[h-1][j]=r;
                    }
               }
               r.b=(unsigned char)(k-w);
               if (p >= v+n) {
                    r.e=99;
               }
               else if (*p < s) {
                    r.e=(unsigned char)(*p < 256 ? 16 : 15);
                    r.v.n=*p++;
               }
               else {
                    r.e=(unsigned char)e[*p-s];
                    r.v.n=d[*p++-s];
               }
               f=1 << (k-w);
               for (j=i>>w ; j < z ; j+=f) {
                    q[j] = r;
               }
               for (j=1<<(k-1) ; i&j ; j>>=1) {
                    i^=j;
               }
               i^=j;
               while ((i&((1<<w)-1)) != x[h]) {
                    h--;
                    w-=l;
               }
          }
     }
     return y != 0 && g != 1;
}

int
huft_free(struct huft *t)     /* "Release" Huftman tables                  */
{
     struct huft *p, *q;

     p=t;
     while (p != (struct huft *)NULL) {
          q=(--p)->v.t;
          free(p);
          p=q;
     }
     return(0);
}

int
readbyte(unsigned short *x)   /* Read in next byte from .ZIP file          */
{
     if (zp.csize-- <= 0) {
          return(0);
     }

     if (uz.input_avail == 0) {
          if ((uz.input_avail=
           fread((char *)uz.input_buf,1,INPUT_BUFFER_SIZE,uz.zip_file))
            <= 0) {
               return(0);
          }
          /* buffer ALWAYS starts on a block boundary:  */
          zp.cur_zip_bs+=INPUT_BUFFER_SIZE;
          zp.inptr=uz.input_buf;
     }
     *x=*zp.inptr;
     zp.inptr++;
     --(uz.input_avail);
     return(8);
}

int
outb(int intc)                     /* Output inflated byte                 */
{
     if (outcnt == OUTPUT_BUFFER_SIZE) {
          catastro("QWKMAIL: OUTPUT BUFFER OVERFLOW!");
     }
     uz.output_buf[outcnt++]=(byte)intc;
     return(intc);
}

void
unzip_close(void)
{
     close_if_open(uz.zip_file);
     uz.zip_file=NULL;
}

void
load_sf_tree(struct sf_tree *t,int tree_size)
{
     t->entries=tree_size;

     {
          int compressed_tree_bytes;
          int i,num,len;

          compressed_tree_bytes=read_bits(8)+1;
          i=0;
          t->max_length=0;
          while (compressed_tree_bytes) {
               len=read_bits(4)+1;
               num=read_bits(4)+1;
               while (num != 0) {
                    if (len > t->max_length) {
                         t->max_length=len;
                    }
                    t->tree[i].bit_length=len;
                    t->tree[i].value=i;
                    i++;
                    num--;
               }
               compressed_tree_bytes--;
          }
     }

     {
          char swapped;
          int i;
          char x, y;
          struct sf_tree_entry temp;

          do {
               swapped=0;
               for (i=0; i < t->entries-1; i++) {
                    x=t->tree[i].bit_length;
                    y=t->tree[i+1].bit_length;
                    if (x > y || (x == y && t->tree[i].value > t->tree[i+1].value)) {
                         temp=t->tree[i];
                         t->tree[i]=t->tree[i+1];
                         t->tree[i+1]=temp;
                         swapped=1;
                    }
               }
          } while (swapped);
     }

     {
          int code, code_increment;
          int last_bit_length;
          int i;

          code=0;
          code_increment=0;
          last_bit_length=0;
          i=t->entries-1;
          while (i >= 0) {
               code+=code_increment;
               if (t->tree[i].bit_length != last_bit_length) {
                    last_bit_length=t->tree[i].bit_length;
                    code_increment=1<<(16-last_bit_length);
               }
               t->tree[i].code=reverse_bits(code);
               i--;
          }
     }
}

int
reverse_bits(int x)
{
     register int in;
     register int out;
     int b;

     in=x;
     out=0;
     for (b=0; b < 16; b++) {
          out<<=1;
          if (in&1) {
               out|=1;
          }
          in>>=1;
     }
     return(out);
}

int
read_via_tree(struct sf_tree *t)
{
     int code, bits, index;

     code=0;
     bits=0;
     index=0;
     for (;;) {
          code|=read_bits(1)<<bits;
          bits++;
          while (t->tree[index].bit_length < bits) {
               index++;
               if (index >= t->entries) {
                    uz.zip_eof=1;
                    return(0);
               }
          }
          while (t->tree[index].bit_length == bits) {
               if (t->tree[index].code == code) {
                    return(t->tree[index].value);
               }
               index++;
               if (index >= t->entries) {
                    uz.zip_eof=1;
                    return(0);
               }
          }
     }
}

int
read_bits(int b)
{
     register int x;
     register int mask;
     int n;

     x=0;
     mask=1;
     while (b) {
          if (!uz.bits_left) {
               uz.input_index++;
               if (uz.input_index >= uz.input_avail) {
                    n=INPUT_BUFFER_SIZE;
                    if (uz.zlhdr.compressed-uz.input_offset < n) {
                         n=(int)(uz.zlhdr.compressed-uz.input_offset);
                    }
                    uz.input_avail=fread(uz.input_buf,1,n,uz.zip_file);
                    if (!uz.input_avail) {
                         uz.zip_eof=1;
                         return(0);
                    }
                    uz.input_offset+=uz.input_avail;
                    uz.input_index=0;
               }
               uz.bits_left=8;
          }
          if (uz.input_buf[uz.input_index]&1) {
               x|=mask;
          }
          uz.input_buf[uz.input_index] >>= 1;
          uz.bits_left--;
          mask<<=1;
          b--;
     }
     return(x);
}

void
output_byte(char b)
{
     uz.output_buf[uz.output_index]=b;
     uz.output_index=(uz.output_index+1)%OUTPUT_BUFFER_SIZE;
     uz.crc=crc32(b,uz.crc);
     uz.output_avail++;
     uz.output_offset++;
}

                    /* utility routines for converting MKS$ reals <-> longs*/
unsigned long
mks_to_long(unsigned long x)
{
     return(((x&~0xFF000000UL)|0x00800000UL)>>(int)(24-((x>>24)&0x7F)));
}

unsigned long
long_to_mks(unsigned long x)
{
     int exp;

     exp=0;
     if (x == 0) {
          exp=0x80+24;
     }
     else if (x >= 0x01000000L) {
          while (x&0xff000000L) {
               x>>=1;
               exp--;
          }
     }
     else {
          while ((x&0x00800000L) == 0) {
               x<<=1;
               exp++;
          }
     }
     return((x&~0x00800000L)|((24L-exp+0x80)<<24));
}

unsigned long
crc32block(void *buf,int len,unsigned long crc)   /* compute the crc32     */
{
     char *p=buf;

     while (len--) {
          crc=crc32(*p,crc);
          p++;
     }
     return(crc);
}


unsigned long
crc32(char c,unsigned long crc)    /* compute the crc32 of a byte          */
{
     int i;

     for (i=0; i < 8; i++) {
          if (c&1) {
               crc^=1;
          }
          if (crc&1) {
               crc=(crc>>1)^0xedb88320L;
          }
          else {
               crc>>=1;
          }
          c>>=1;
     }
     return(crc);
}


void
copy_fill(char *d,char *s,int len) /* copy null-term stg to space-filled stg*/
{
     while (len && *s) {
          *d++=*s++;
          len--;
     }
     while (len) {
          *d++=' ';
          len--;
     }
}

               /* copy a null-term stg to an uppercase space-filled string */
void
copy_fill_upper(char *d,char *s,int len)
{
     while (len && *s) {
          *d++=toupper(*s);
          s++;
          len--;
     }
     while (len) {
          *d++=' ';
          len--;
     }
}


void
close_if_open(FILE *f)        /* close a file if f != NULL                 */
{
     if (f != NULL) {
          fclose(f);
     }
}


int
exist(char *fn)               /* check to see if a file exists             */
{
     struct fndblk fb;

     return(fnd1st(&fb,fn,0));
}


void
qwkmail_hangup(void)          /* hangup, close open files and clean up     */
{
     int i;
     struct fndblk fb;

     if (usrptr->state == mjmstt) {
          switch (usrptr->substt) {
          case MAKEPCKT:
               abort_dl();
               break;
          }
          clrprf();
     }
     restqs();
     qscptr=qscoff(usrnum);
     if (sameas(qscptr->userid,usaptr->userid)) {
          setbtv(qscbb);
          geqbtv(NULL,usaptr->userid,0);
          upvbtv(qscptr,qscsiz);
     }
     setmem(qscptr,qscsiz,0);
     i=fnd1st(&fb,spr("%s%d\\*.*",QWKMAIL_DIR,usrnum),0);
     while (i) {
          unlink(spr("%s%d\\%s",QWKMAIL_DIR,usrnum,fb.name));
          i=fndnxt(&fb);
     }
}

void
restqs(void)                  /* restore quickscan data if present         */
{
     FILE *fp;

     if (qwksid[usrnum].wroteq
       && (fp=fopen(spr("%s%d\\TMPQSC.IMG",QWKMAIL_DIR,usrnum),FOPRB)) != NULL) {
          fread(&usaptr->emllim,sizeof(long),1,fp);
          fread(qscoff(usrnum),qscsiz,1,fp);
          fclose(fp);
          qwksid[usrnum].wroteq=0;
     }
}



void
qwkmail_cleanup(void)         /* process any rep packets, del outstanding qwk*/
{
     setmbk(qwkmail_msgs);
     setbtv(esgbb);

     while (ul->msg_number) {
          cont_ul();
     }
     while (start_ul()) {
          while (cont_ul()) {
          }
     }

     setmem(&compos,sizeof(compos),0);
     strcpy(compos.userid,QWKMAIL_NAME);
     compos.msgno=0;

     if (agtbtv(&ul->msg,&compos,FROMNUM) && sameas(ul->msg.from,QWKMAIL_NAME)) {
          do {
               delbtv();
               unlink(attach_fn(-1,ul->msg.msgno));
               sv.emlopn--;
          } while (anibtv(&ul->msg));
     }
}


void
qwkmail_close(void)           /* close files for shutdown                  */
{
     int i;

     for (i=0; i < nterms; i++) {
          rmdir(spr("%s%d",QWKMAIL_DIR,i));
     }
     clsmsg(qwkmail_msgs);
}

