/***************************************************************************
 *                                                                         *
 *   GALFIL.C                                                              *
 *                                                                         *
 *   Copyright (C) 1993-1994 GALACTICOMM, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   File Libraries - Main Routines                                        *
 *                                                                         *
 *                                                 - D. Pitchford  9/28/93 *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"
#include "majorbbs.h"
#include "fcntl.h"
#include "galfil.h"
#include "filexfer.h"
#include "fsdbbs.h"
#include "galfilh.h"

static
struct module flmod={              /* module interface block               */
     "",                           /*    name used to refer to this module */
     lslon,                        /*    user logon supplemental routine   */
     lsinp,                        /*    input routine if selected         */
     lssta,                        /*    status-input routine if selected  */
     NULL,                         /*    "injoth" routine for this module  */
     NULL,                         /*    user logoff supplemental routine  */
     lshang,                       /*    hangup (lost carrier) routine     */
     lsclean,                      /*    midnight cleanup routine          */
     lsdel,                        /*    delete-account routine            */
     lsend                         /*    system shutdown routine           */
};

struct fluser *flu,                /* current user pointed to (disk)       */
              *fluarr;             /* memory array                         */

struct fluson *flo;                /* online user pointed to               */

struct flusave flusmem;            /* memory for loading/saving fluser     */

struct fllib *curlib;              /* current Library in use               */

struct libdisk *libupd,            /* memory for loading/saving Libraries  */
               *libedt;            /* memory for editing Libraries         */

struct taglib *ftag;               /* current tagged file                  */

struct modeview mvarr[NVIEWS];     /* custom viewing routines              */

struct key0 countkey;              /* key for counting uploads in Libraries*/

struct key7 *kwbuf;                /* buffer for keyword insertion         */

struct srcs *srcu,*srcarr;         /* ptr & nterms array Lib. srch structs */

union srch srcactive;              /* active, found record for speed-search*/

FILE *flmsg,                       /* pointer for .msg file                */
     *csrc,                        /* pointer for general copying of files */
     *cdst,                        /* pointer for general copying of files */
     *movs,                        /* pointer for sysop copying of files   */
     *movd;                        /* pointer for sysop copying of files   */

BTVFILE *flldat,                   /* data file for Libraries              */
        *flfdat,                   /* data file for files                  */
        *flkdat;                   /* data file for keywords               */

char *arrower,                     /* cursor key detection flag            */
     *tempdir,                     /* default user upload temp directory   */
     *nochgkey,                    /* key to never be charged to d/l       */
     *listkey,                     /* key to be able to d/l file lists     */
     *nonkwds,                     /* non-keywords                         */
     *flsysop,                     /* key required to be Library sysop     */
     *defplop,                     /* default primary Lib-Op               */
     *copydir,                     /* destination directory, copied files  */
     *defdesc,                     /* default description for a Library    */
     *deflname,                    /* name of default Library              */
     *descedit,                    /* memory for file descriptions         */
     *dargv[MAXKWDS],              /* points to defdesc, as margv to input */
     *defproto,                    /* default d/l protocol for all users   */
     flmisc[MISCSIZE],             /* array for misc. test variable        */
     movflib[FLNAMESZ],            /* array for moving files from Library  */
     movtlib[FLNAMESZ],            /* array for moving files to Library    */
     movfnam[FLFILENM],            /* array for moving files file name     */
     countlib[FLNAMESZ],           /* Library currently being counted      */
     tagtmpp[TSHLEN+1],            /* memory for temporary wild file path  */
     tagtmpf[FLFILENM];            /* memory for temporary wild file name  */

void *flomem,                      /* memory for users online              */
     *libmem,                      /* memory for Libraries                 */
     *libmem2,                     /* more memory for adding Libraries     */
     *ftagmem;                     /* memory for tagged files              */

int numlib,                        /* number of libs memory allocated for  */
    numladd,                       /* max. number of libs to possibly add  */
    flstt,                         /* state for the File Libraries         */
    longsrch,                      /* require brute force searches         */
    vdd,                           /* half of the vda declaration          */
    freeuls,                       /* if true, never charge while uploading*/
    dargc,                         /* count of parsed words by darsdesc()  */
    notifsys,                      /* if true, notify sysops of unapp files*/
    notiflop,                      /* if true, notify libops of unapp files*/
    numoflib,                      /* actual number of Libraries           */
    comeff,                        /* estimated communications efficiency  */
    ncatlibs,                      /* actual number of top-level Libraries */
    auditall,                      /* if true, audit all file transfers    */
    unifile,                       /* if true, require unique file names   */
    pfnceil,                       /* profanity ceiling for File Libraries */
    chgabt,                        /* if true, charge for aborted downloads*/
    defallib,                      /* search all Libraries from d/l prompt */
    systags,                       /* number of ftagmem to allocate        */
    defstyp,                       /* default search/list mode             */
    defslib,                       /* default search/list range, one/all   */
    stplist,                       /* strip ansi always in file listings   */
    countuls[ULDAYS],              /* counter of Library files added daily */
    clnlevel,                      /* level of cleanup to run              */
    kwaut,                         /* flag, keywords being written now     */
    maxjoin,                       /* # of joined libs max for fast search */
    srcindex,                      /* index for found record in speed-srch */
    fltagf;                        /* is current file tag a Library tag    */

long byteroom,                     /* bytes free for uploading to a Library*/
     thresh;                       /* bytes assured free, copydir's drive  */

char *libedits="\
LIBDATE \
LIBTIME \
LIBNAME \
LIBDOS \
LIBDESC \
LIBDESC0 \
LIBDESC1 \
LIBDESC2 \
LIBDESC3 \
LIBDESC4 \
LIBPATH \
LIBHID(ALT=YES ALT=NO MULTICHOICE) \
LIBCBD(ALT=YES ALT=NO MULTICHOICE) \
LIBRDO(ALT=YES ALT=NO MULTICHOICE) \
LIBAUL(ALT=YES ALT=NO MULTICHOICE) \
LIBADL(ALT=YES ALT=NO MULTICHOICE) \
LIBFUL(ALT=YES ALT=NO MULTICHOICE) \
LIBFDL(ALT=YES ALT=NO MULTICHOICE) \
LIBCDF \
LIBCDK \
LIBROY \
LIBMFL \
LIBMBT \
LIBMUP \
LIBVIS \
LIBDLD \
LIBULD \
LIBOVW \
LIBAPU \
LIBLOP \
LIBPLOP \
DONE(ALT=SAVE ALT=EDIT ALT=QUIT MULTICHOICE)";

char *filedits="\
FILNAME \
FILLIB \
FILDATE \
FILTIME \
FILSIZE \
FILDL \
FILULD \
FILULT \
FILDLT \
FILCHG \
FILUSER \
FILTXT00 \
FILTXT01 \
FILTXT02 \
FILTXT03 \
FILTXT04 \
FILTXT05 \
FILTXT06 \
FILTXT07 \
FILTXT08 \
FILTXT09 \
FILTXT10 \
FILTXT11 \
FILTXT12 \
FILTXT13 \
FILTXT14 \
DONE(ALT=SAVE ALT=EDIT ALT=QUIT MULTICHOICE)";

char *libeditf="\
LIBDATE=%s%c\
LIBTIME=%s%c\
LIBNAME=%s%c\
LIBDOS=%s%c\
LIBDESC=%s%c\
LIBDESC0=%s%c\
LIBDESC1=%s%c\
LIBDESC2=%s%c\
LIBDESC3=%s%c\
LIBDESC4=%s%c\
LIBPATH=%s%c\
LIBHID=%s%c\
LIBCBD=%s%c\
LIBRDO=%s%c\
LIBAUL=%s%c\
LIBADL=%s%c\
LIBFUL=%s%c\
LIBFDL=%s%c\
LIBCDF=%ld%c\
LIBCDK=%ld%c\
LIBROY=%d%c\
LIBMFL=%ld%c\
LIBMBT=%ld%c\
LIBMUP=%ld%c\
LIBVIS=%s%c\
LIBDLD=%s%c\
LIBULD=%s%c\
LIBOVW=%s%c\
LIBAPU=%s%c\
LIBLOP=%s%c\
LIBPLOP=%s%c";

char *fileditf="\
FILNAME=%s%c\
FILLIB=%s%c\
FILDATE=%s%c\
FILTIME=%s%c\
FILSIZE=%s%c\
FILDL=%s%c\
FILULD=%s%c\
FILULT=%s%c\
FILDLT=%s%c\
FILCHG=%s%c\
FILUSER=%s%c\
FILTXT00=%s%c\
FILTXT01=%s%c\
FILTXT02=%s%c\
FILTXT03=%s%c\
FILTXT04=%s%c\
FILTXT05=%s%c\
FILTXT06=%s%c\
FILTXT07=%s%c\
FILTXT08=%s%c\
FILTXT09=%s%c\
FILTXT10=%s%c\
FILTXT11=%s%c\
FILTXT12=%s%c\
FILTXT13=%s%c\
FILTXT14=%s%c";

void EXPORT
init__galfil(void)                 /* system initialization routine        */
{
     int loop;

     stzcpy(flmod.descrp,gmdnam("GALFIL.MDF"),MNMSIZ);
     flstt=register_module(&flmod);
     flmsg=opnmsg("galfil.mcv");
     iniopts();
     flfdat=opnbtv("galfilf.dat",FLFILREC+DESCSIZ);
     flldat=opnbtv("galfill.dat",sizeof(struct libdisk));
     numlib=(int)cntrbtv()+5;
     numladd=numlib+20;
     if (!longsrch) {
          flkdat=opnbtv("galfilk.dat",FLKEYREC);
     }
     if (tempdir[0] == '\0') {
          tempdir="LIBTEMP";
     }
     if (copydir[0] == '\0' || weirddir(copydir)) {
          copydir="LIBCOPY";
     }
     arrower=(char *)alczer(nterms);
     descedit=(char *)alczer(DESCSIZ);
     libedt=(struct libdisk *)alczer(sizeof(struct libdisk));
     libupd=(struct libdisk *)alczer(sizeof(struct libdisk));
     fluarr=(struct fluser *)alczer(nterms*sizeof(struct fluser));
     srcarr=(struct srcs *)alczer(nterms*sizeof(struct srcs));
     for (loop=0 ; loop < nterms; loop++) {
          srcu=&srcarr[loop];
          srcu->tn=(union srch *)alczer(maxjoin*sizeof(union srch));
          srcu->tp=(union srch *)alczer(maxjoin*sizeof(union srch));
          srcu->fn=(union srch *)alczer(maxjoin*sizeof(union srch));
          srcu->fp=(union srch *)alczer(maxjoin*sizeof(union srch));
     }
     if (!longsrch) {
          kwbuf=(struct key7 *)alczer(SIZKWBUF*sizeof(struct key7));
     }
     kwaut=0;
     ftagmem=alcblok(systags,sizeof(struct taglib));
     flomem=alcblok(nterms,sizeof(struct fluson));
     libmem=alcblok(numlib,sizeof(struct fllib));
     libmem2=NULL;
     setmem(mvarr,NVIEWS*sizeof(struct modeview),0);
     register_modeview("ZIP",CMPVIEW,NULL);
     register_modeview("ARC",CMPVIEW,NULL);
     register_modeview("LZH",CMPVIEW,NULL);
     register_modeview("ZOO",CMPVIEW,NULL);
     register_modeview("ICE",CMPVIEW,NULL);
     register_modeview("PSE",CMPVIEW,NULL);
     register_modeview("ZSE",CMPVIEW,NULL);
     register_modeview("TXT",LSTVIEW,NULL);
     loadlibs();
     init_galfiluz();
     vdd=max(MAXKWDS*FLKEYSIZ,fsdroom(LIBEDITN,libedits,0));
     vdd=max(vdd,fsdroom(LIBEDITA,libedits,0));
     vdd=max(vdd,fsdroom(FILEDITN,filedits,0));
     vdd=max(vdd,fsdroom(FILEDITA,filedits,0));
     dclvda(2*vdd);
     if (sameto("_LIBOP",flsysop)) {
          shocst("GALFIL: WARNING","FLSYSOP key can't be _LIBOP pseudokey");
     }
     else {
          register_pseudok("_LIBOP",psislibop);
     }
     mkdir(tempdir);
     mkdir(copydir);
     purgecpy(0);
     regtvars();
     rtkick(5,libkick);
}

void
iniopts(void)                      /* read in configuration options        */
{
     longsrch=ynopt(LONGSRCH);
     pfnceil=numopt(PFNCEIL,0,3);
     flsysop=stgopt(FLSYSOP);
     nonkwds=stgopt(NONKWDS2);
     tempdir=checkdir(pthopt(TEMPDIR));
     comeff=numopt(COMEFF,1,100);
     thresh=lngopt(THRESH,1,1000)*1024L*1024L;
     auditall=ynopt(AUDITALL);
     chgabt=ynopt(CHGABT);
     defallib=ynopt(DEFALLIB);
     nochgkey=stgopt(NOCHGKEY);
     defdesc=stgopt(DEFDESC);
     deflname=stgopt(DEFLNAME);
     defplop=stgopt(DEFPLOP);
     listkey=stgopt(LISTKEY);
     notifsys=ynopt(NOTIFSYS);
     notiflop=ynopt(NOTIFLOP);
     unifile=ynopt(UNIFILE);
     freeuls=ynopt(FREEULS);
     stplist=ynopt(STPLIST);
     systags=numopt(SYSTAGS,20,3000);
     copydir=checkdir(pthopt(COPYDIR));
     defproto=stgopt(DEFPROTO);
     clnlevel=numopt(CLNLEVEL,0,2);
     switch (chropt(DEFSTYP)) {
     case 'd':
     case 'D':
          defstyp=2;
          break;
     case 'f':
     case 'F':
          defstyp=3;
          break;
     case 'k':
     case 'K':
          defstyp=4;
          break;
     case 'n':
     case 'N':
          defstyp=5;
          break;
     case 'w':
     case 'W':
          defstyp=6;
          break;
     case 'q':
     case 'Q':
          defstyp=7;
          break;
     default:
          defstyp=1;
     }
     defslib=tokopt(DEFSLIB,"ASK","CURLIB","ALL",NULL);
     if (defslib == 0) {
          defslib++;
     }
     maxjoin=numopt(MAXJOIN,5,500)+1;   /* include the top-level Library   */
}

int
psislibop(                         /* pseudokey: is user a libop?          */
int unum,                          /* test for _LIBOP! to determine sysop  */
char *lock)
{
     if (!sameto("_LIBOP",lock)) {
          return(0);
     }
     fluoff(unum);
     if (curlib == NULL) {
          return(0);
     }
     if (sameto("_LIBOP",curlib->libop)) {
          shocst("GALFIL: WARNING",
                 "LIBOP key can't be _LIBOP in Library %s",curlib->libname);
          return(0);
     }
     if (lock[strlen(lock)-1] == '!') {
          return(haskey(flsysop));
     }
     return(isflop(curlib));
}

char *
cnclib(void)                       /* grab a Library name                  */
{
     static char retlib[FLNAMESZ];
     char *rp;

     setmem(rp=retlib,FLNAMESZ,0);
     while (*nxtcmd != '\0' && *nxtcmd != ' ' && rp-retlib < FLNAMESZ-1) {
          *rp++=*nxtcmd++;
     }
     return(strupr(retlib));
}

int
isflop(                            /* is current user an operator at all?  */
struct fllib *libptr)
{
     if (libptr == NULL) {
          return(0);
     }
     return(haskey(flsysop) || (libptr->libop[0] != '\0'
        && haskey(libptr->libop)) || !stricmp(usaptr->userid,libptr->primary));
}

int
scanlib(                           /* count up total files in Library      */
int user,                               /* ... 1=use user's access keys    */
struct fllib *libptr)
{
     int loop,loop2;
     struct fllib *lib2;

     libptr->libs=0;
     libptr->totfiles=libptr->numfiles-libptr->appwait;
     for (loop=0 ; loop < numoflib ; loop++) {
          lib2=liboff(loop);
          if (lib2->cat[0][0] != '\0') {
               for (loop2=0 ; loop2 < FLNMCATS ; loop2++) {
                    if (sameas(lib2->cat[loop2],libptr->libname)
                       && (!user || haslibkey(lib2,lib2->keyreq))) {
                         libptr->libs++;
                         if (lib2 != libptr) {
                              libptr->totfiles+=lib2->numfiles-lib2->appwait;
                         }
                    }
               }
          }
     }
     return(libptr->libs != 0);
}

int
wldgetag(void)                     /* get next tagged wild file            */
{
     struct fllib *libptr;

     if (readline(flo->fsrc)) {
          inplen=strlen(input);
          parsin();
          if (margc >= 2 && (libptr=libfind(margv[0])) != NULL) {
               setbtv(flfdat);
               if ((libptr->flags&FLGDOS)
                  || acqbtv(NULL,compkey(libptr->libname,margv[1]),COMPLF)) {
                    sprintf(tagtmpp,"%s\\%s",libpath(libptr),margv[1]);
                    if (fnd1st(&flo->fb,tagtmpp,0)) {
                         stzcpy(tagtmpf,flo->fb.name,FLFILENM);
                         strcpy(spc->libname,libptr->libname);
                         spc->size=flo->fb.size;
                         return(1);
                    }
               }
          }
     }
     fclose(flo->fsrc);
     flo->fsrc=NULL;
     return(0);
}

int
dlbgnwld(void)                     /* begin download of wild tags          */
{
     int tagnum;

     for (tagnum=0 ; tagnum < systags ; tagnum++) {
          if (tagoff(tagnum) == spc) {
               break;
          }
     }
     flo->fsrc=fopen(spr("%s\\TAGS%d.fil",copydir,tagnum),FOPRB);
     return(flo->fsrc == NULL ? 0 : wldgetag());
}

int
tshlist(                           /* tagspc handler for file lists        */
int tshcod)
{
     int rc=0;
     char *stg,fname[FLFILENM];

     fluoff(usrnum);
     setmbk(flmsg);
     stzcpy(fname,ftgptr->tagspc,FLFILENM);
     strupr(fname);
     switch (tshcod) {
     case TSHDSC:                      /* Describe tagspec in English */
          if ((stg=strchr(fname,'.')) != NULL) {
               *stg='\0';
          }
          if (sameas(fname,"FILES!")) {
               strcpy(tshmsg,"list of files in all Libraries");
          }
          else {
               sprintf(tshmsg,"list of files in the %s Library",fname);
          }
          break;
     case TSHVIS:                                  /* Visible to this user? */
          *tshmsg='\0';
          rc=1;
          break;
     case TSHBEG:              /* Begin download, check permission, reserve */
          sprintf(tshmsg,"%s\\%s",copydir,fname);
          if ((stg=strchr(fname,'.')) != NULL) {
               *stg='\0';
          }
          sprintf(ftfscb->fname,"%s.LST",fname);
          rc=1;
          break;
     case TSHEND:             /* End complete download of a file, unreserve */
          sv.dwnlds++;
          shocst("LIBRARY FILE DOWNLOAD","User %s download %s\\%s",
                           usaptr->userid,copydir,fname);
          unlink(spr("%s\\%s",copydir,fname));
          break;
     case TSHFIN:                           /* Finish file transfer session */
          retoin();
          rc=1;
          break;
     case TSHSKP:                     /* Skip incomplete download of a file */
          shocst("LIBRARY FILE DOWNLOAD ABORTED",
             "User %s aborted dnld of %s\\%s",usaptr->userid,copydir,fname);
     }
     return(rc);
}

int
tshlib(                            /* tagspc handler for File Libraries      */
int tshcod)
{
     static char tmsgtmp[200];
     struct fllib *libptr=NULL;
     FILE *fp=NULL;
     int rc=0;
     char *stg;
     long chg;

     fluoff(usrnum);
     setmbk(flmsg);
     fltagf=1;
     switch (tshcod) {
     case TSHSCN:
          if ((rc=dlbgnwld()) != 0) {
               movmem(ftgptr->tagspc,tshmsg,TSLENG);
          }
          break;
     case TSHNXT:
          if ((rc=wldgetag()) != 0) {
               movmem(ftgptr->tagspc,tshmsg,TSLENG);
          }
          else {
               spc->status=-spc->status;
          }
          break;
     case TSHDSC:                      /* Describe tagspec in English */
          setmem(tmsgtmp,200,0);
          if (spc->filname[0] == '*') {
               sprintf(tmsgtmp,"%d file%s matching \"%s\" in the %s Library",
                  spc->nwld,(spc->nwld > 1 ? "s" : ""),spc->wldspc,
                  spc->reflib);
          }
          else {
               sprintf(tmsgtmp,"file %s in the %s Library",spc->filname,
                  spc->reflib);
          }
          switch (spc->status) {
          case TGCOPY:
               if (spc->size > 0L) {
                    strcat(tmsgtmp,spr(" (Not Ready - %ld%%%% Copied)",
                       100L*spc->copied/spc->size));
               }
               else {
                    strcat(tmsgtmp," (Not Ready - Copying)");
               }
               break;
          case TGLOCAL:
          case TGDLTMP:
               stg=skpwht(dnlmin(spc->size));
               strcat(tmsgtmp,spr(" (%sK, %s minute",fzer(spc->size/1024L),
                  stg));
               if (atol(stg) > 1L) {
                    strcat(tmsgtmp,"s");
               }
               chg=dnlchg(spc->size,spc->libname);
               if (chg > 0L) {
                    strcat(tmsgtmp,spr(", %ld credits",chg));
               }
               strcat(tmsgtmp,")");
               break;
          case TGINWAIT:
               strcat(tmsgtmp," (Not Ready - Queued)");
               break;
          case TGOTHER:
          case TGSERVER:
               strcat(tmsgtmp," (Not Ready - Retrieving)");
               break;
          case -TGLOCAL:
          case -TGDLTMP:
               strcat(tmsgtmp," (Removing)");
               break;
          default:
               if (spc->status < TGEMPTY) {
                    strcat(tmsgtmp," (Aborted - Removing)");
               }
          }
          stzcpy(tshmsg,tmsgtmp,TSHLEN);
          break;
     case TSHVIS:                                  /* Visible to this user? */
          *tshmsg='\0';
          rc=1;
          if (spc->filname[0] == '*') {
               break;
          }
          if (spc->libname[0] != '\0') {
               libptr=libfind(spc->libname);
          }
          if (libptr != NULL
             && (spc->status == TGLOCAL || spc->status == TGDLTMP)) {
               if (libptr->flags&FLGCBD) {
                    sprintf(tshmsg,"%s\\%s\\%s",copydir,libptr->libname,
                       spc->filname);
               }
               else {
                    sprintf(tshmsg,"%s\\%s",libpath(libptr),spc->filname);
               }
               if ((fp=fopen(tshmsg,FOPRB)) != NULL) {
                    fread(tshmsg,1,TSHLEN,fp);
                    fclose(fp);
               }
               else {
                    if (spc->status == TGLOCAL) {
                         shocst("FILE LIBRARIES: MISSING FILE",
                                "%s\\%s is missing!",
                                libptr->libname,spc->filname);
                         prfmsg(MISFILEB,spc->filname);
                    }
                    else {
                         prfmsg(MISFILE,spc->filname);
                    }
                    outprf(usrnum);
                    clrprf();
                    rc=0;
               }
          }
          break;
     case TSHBEG:              /* Begin download, check permission, reserve */
          if (spc->libname[0] != '\0') {
               libptr=libfind(spc->libname);
               strcpy(tshmsg,tagtmpp);
               strcpy(ftfscb->fname,tagtmpf);
          }
          if (libptr == NULL) {
               strcpy(tshmsg,"file is not available for download");
               break;
          }
          switch (spc->status) {
          case TGINWAIT:
          case TGCOPY:
          case TGOTHER:
          case TGSERVER:
               strcpy(tshmsg,"file is not yet available for download");
               rc=-1;
               break;
          case TGLOCAL:
          case TGDLTMP:
               if (!sameas(spc->filname,"*")) {
                    if (libptr->flags&FLGCBD) {
                         sprintf(tshmsg,"%s\\%s\\%s",copydir,libptr->libname,
                            spc->filname);
                    }
                    else {
                         sprintf(tshmsg,"%s\\%s",libpath(libptr),spc->filname);
                    }
                    strcpy(ftfscb->fname,spc->filname);
               }
               if (!sameas(ftfpsp->code,"V")) {
                    if (!zapcrd((libptr->flags&FLGFDL) != 0L,spc->size,
                       libptr)) {
                         sprintf(tshmsg,
                           "You don't have enough credits to download %s",
                           ftfscb->fname);
                    }
                    else {
                         dnlcount(libptr->libname,ftfscb->fname,-1L);
                         rc=1;
                    }
               }
               else {
                    rc=1;
               }
          }
          break;
     case TSHEND:             /* End complete download of a file, unreserve */
          if (!sameas(ftfpsp->code,"V")) {
               sv.dwnlds++;
               if (spc->libname[0] != '\0') {
                    libptr=libfind(spc->libname);
               }
               if (libptr != NULL) {
                    dncfin(1,ftfscb->actbyt,libptr);
                    if (auditall || (libptr->flags&FLGADL)) {
                         shocst("LIBRARY FILE DOWNLOAD",
                            "User %s download %s\\%s",usaptr->userid,
                            spc->libname,ftfscb->fname);
                    }
               }
               rstcrd();
               if (spc->status > TGEMPTY && !sameas(spc->filname,"*")) {
                    spc->status=-spc->status;
               }
          }
          break;
     case TSHFIN:                           /* Finish file transfer session */
          retoin();
          rc=1;
          break;
     case TSHSKP:                     /* Skip incomplete download of a file */
          if (!sameas(ftfpsp->code,"V")) {
               if (spc->libname[0] != '\0') {
                    libptr=libfind(spc->libname);
               }
               if (libptr != NULL) {
                    dncfin(0,ftfscb->actbyt,libptr);
                    if (auditall || (libptr->flags&FLGADL)) {
                         shocst("LIBRARY FILE DOWNLOAD ABORTED",
                            "User %s aborted dnld of %s\\%s",
                            usaptr->userid,spc->libname,spc->filname);
                    }
               }
               rstcrd();
          }
          break;
     }
     return(rc);
}

long
dnlprc(                            /* price of download, one file + size   */
long siz,
struct fllib *libptr)
{
     return(haskey(nochgkey) || (usrptr->cltptr->flags&CRDXMT) ? 0L
      : libptr->dlchge+libptr->kdlchge*(siz/1024L));
}

void
fluoff(                            /* sets pointer to passed usrnum        */
int unum)                          /* usrnum to set it to                  */
{
     int saveu;

     if (unum < 0 || unum >= nterms) {
          unum=0;
     }
     saveu=usrnum;
     usrnum=unum;
     curusr(usrnum);
     flo=(struct fluson *)ptrblok(flomem,usrnum);
     flu=&fluarr[usrnum];
     srcu=&srcarr[usrnum];
     curlib=setuaxs();
     if (saveu != usrnum) {
          usrnum=saveu;
          if (usrnum >= 0 && usrnum < nterms) {
               curusr(usrnum);
          }
     }
}

void
scanlibs(void)                     /* set up Libraries/top-level Libraries */
{
     int loop=0;
     struct fllib *libptr;

     ncatlibs=0;
     while (loop < numoflib) {
          libptr=liboff(loop++);
          if (libptr->libname[0] != '\0') {
               if (scanlib(0,libptr)) {
                    ncatlibs++;
               }
          }
     }
}

struct fllib *
libfind(                           /* return pointer to Library            */
char *libname)                          /* ... Library name                */
{
     int loop;
     struct fllib *retval;

     for (loop=0 ; loop < numoflib ; loop++) {
          if (!stricmp(libname,(retval=liboff(loop))->libname)) {
               return(retval);
          }
     }
     return(NULL);
}

struct fllib *
liboff(                            /* return pointer to Library            */
int libnum)                        /* Library number                       */
{
     if (libnum >= numlib) {
          if (libmem2 == NULL) {
               libmem2=alcblok(numladd,sizeof(struct fllib));
          }
          return((struct fllib *)ptrblok(libmem2,libnum-numlib));
     }
     return((struct fllib *)ptrblok(libmem,libnum));
}

struct fllib *
setuaxs(void)                      /* set user access by key, returns ptr  */
{                                  /* to user's current Library or NULL    */
     int loop;
     struct fllib *retval;

     if (flu->lib[0] == '\0'
        || (retval=libfind(flu->lib)) == NULL
        || !haslibkey(retval,retval->keyreq)) {
          setmem(flu->lib,FLNAMESZ,0);
          if ((retval=libfind(deflname)) != NULL && visilib(retval)) {
               stzcpy(flu->lib,deflname,FLNAMESZ);
          }
          else {
               for (loop=0 ; loop < numoflib ; loop++) {
                    if (valname((retval=liboff(loop))->libname)
                       && visilib(retval)) {
                         stzcpy(flu->lib,retval->libname,FLNAMESZ);
                         break;
                    }
               }
          }
          flo->nlibaxs=-1;
     }
     if (flo->nlibaxs == -1) {
          flo->nlibaxs=0;
          for (loop=0 ; loop < numoflib ; loop++) {
               retval=liboff(loop);
               if (haslibkey(retval,retval->keyreq)) {
                    flo->nlibaxs++;
               }
          }
     }
     return(flu->lib[0] != '\0' ? retval : NULL);
}

int
makwdlst(                          /* make keyword list                    */
char *stg,
char *filname)
{
     char filnmem[FLFILENM],*ext;

     descedit[0]='\0';
     stzcpy(filnmem,filname,FLFILENM);
     ext=strchr(strupr(filname=filnmem),'.');
     if (ext != NULL) {
          *ext++='\0';
          if (strlen(ext) == 3) {
               strcat(descedit,ext);
               strcat(descedit," ");
          }
     }
     if (strlen(filname) > 2) {
          strcat(descedit,filname);
          strcat(descedit," ");
     }
     stzcat(descedit,stg,DESCSIZ);
     strcrep(descedit,'\r',' ');
     strupr(descedit);
     darsdesc(MAXKWDS,' ');
     bubkwds();
     return(dargc > 0);
}

int
submit(                            /* submit a file for tagging, 1=success */
char *libname,                     /* works on current user                */
char *filname,
char *reflib,                           /* reference lib in case true lib  */
int view,                                    /* is invisible to user,      */
int quiet)                                   /* "" acceptable, best guess  */
{
     static struct fndblk fb;
     int loop,isdos=0,wild;
     char *proprlib,*pro;
     struct fllib *libptr;

     outprf(usrnum);
     prf("");
     for (loop=0 ; loop < nterms ; loop++) {
          if (loop != usrnum) {
               flo=(struct fluson *)ptrblok(flomem,loop);
               if ((flo->flags&REUPLOD) && sameas(flo->miscfil,filname)) {
                    flu=&fluarr[loop];
                    if (sameas(flu->lib,libname)) {
                         if (!quiet) {
                              prfmsg(CANTAGF,filname,libname);
                         }
                         return(0);
                    }
               }
          }
     }
     fluoff(usrnum);
     if ((loop=alrtag(libname,filname)) > 0) {
          if (!view) {
               return(0);
          }
     }
     ftag=NULL;
     for (loop=0 ; loop < systags ; loop++) {
          if (tagoff(loop)->status == TGEMPTY) {
               ftag=tagoff(loop);
               break;
          }
     }
     if (ftag == NULL) {
          if (!quiet) {
               prfmsg(CANTAGN,filname,libname);
          }
          return(0);
     }
     libptr=libfind(libname);
     setbtv(flfdat);
     if (libptr != NULL && libptr->flags&FLGDOS) {
          isdos=1;
          if (*filname != '*'
             && !fnd1st(&fb,spr("%s\\%s",libpath(libptr),filname),0)) {
               if (!quiet) {
                    prfmsg(CANTAGF,filname,libname);
               }
               rstbtv();
               return(0);
          }
     }
     else if (*filname != '*'
        && !acqbtv(NULL,compkey(libname,filname),COMPLF)) {
          if (!quiet) {
               prfmsg(CANTAGF,filname,libname);
          }
          rstbtv();
          return(0);
     }
     rstbtv();
     proprlib=(libptr != NULL && !isdos ? visxlib(libptr,reflib) : libname);
     ftag->usrnum=usrnum;
     stzcpy(ftag->libname,libname,FLNAMESZ);
     stzcpy(ftag->reflib,proprlib,FLNAMESZ);
     stzcpy(ftag->filname,filname,FLFILENM);
     if (*filname == '*') {
          ftag->nwld=flo->wtnum;
          ftag->size=flo->wtsiz;
          stzcpy(ftag->wldspc,flo->miscfil,FLFILENM);
     }
     else {
          ftag->size=isdos ? fb.size : flf->siz;
          stzcpy(ftag->udate,isdos ? dat2srt(ncdate(today())) :
             flf->udate,DATESZ);
     }
     ftag->tagtime=time(NULL);
     if (ftag->libname[0] == '\0' || (libptr=libfind(ftag->libname)) == NULL) {
          ftag->status=-1;
          if (quiet) {
               clrprf();
          }
          return(0);
     }
     ftag->status=((libptr->flags&FLGCBD)
        ? (libptr->path[0] != '\0' ? TGINWAIT : TGOTHER) : TGLOCAL);
     if (ftgnew()) {
          spc=ftag;
          wild=sameas(ftag->filname,"*");
          ftgptr->flags=(wild ? FTGWLD : 0);
          ftgptr->flags|=(view != NOTVIEW && !wild ? 0 : FTGABL);
          ftgptr->tshndl=tshlib;
          if (view == NOTVIEW) {
               ftgsbm("TQ");
          }
          else {
               pro="";
               if (flu->askme && view == DOWNLOD && flo->savprot[0] == '\0') {
                    ftgptr->flags|=FTGABL;
                    ftgsbm("TQ");
                    setmbk(flmsg);
                    prfmsg(CLRSCN);
                    prfmsg(DEFRIPM);
                    switch (usrptr->substt) {
                    case FILELST0:
                         prfmsg(usrptr->substt=LOGOFF3);
                         break;
                    case ENTDLFIL:
                         usrptr->substt=LOGOFF;
                         break;
                    default:
                         prfmsg(usrptr->substt=LOGOFF2);
                    }
                    outprf(usrnum);
                    prf("");
                    rstmbk();
                    echonu(usrnum);
                    btutrg(usrnum,0);
                    flo->pflg=ftuptr->numftg;
                    return(1);
               }
               if (pro[0] == '\0') {
                    pro=protocol();
               }
               if (flo->savprot[0] != '\0') {
                    pro=spr("%s",flo->savprot);
                    flo->savprot[0]='\0';
               }
               if (view == CMPVIEW) {
                    pro="V";
                    prf("[0;1;36m");
               }
               else if (view == LSTVIEW) {
                    pro="L";
               }
               else if (view == ANSVIEW) {
                    pro="A";
               }
               else if (view == CSTVIEW) {
                    prf("");
                    (*flo->rouptr)(ftag);
                    outprf(usrnum);
                    prf("");
                    return(1);
               }
               if (sameto("T",pro) && !wild) {
                    pro="";
               }
               if (pro[0] == '\0') {
                    pro="?";
               }
               ftgsbm(pro);
               if (usrptr->state != flstt) {
                    prf("");
                    outprf(usrnum);
               }
               else {
                    prf("");
                    if (!sameto("T",pro)) {
                         return(0);
                    }
               }
          }
     }
     if (quiet) {
          clrprf();
     }
     return(1);
}

int
updusr(                            /* update user field to disk            */
struct fluser *fluptr)
{
     int retval=-1;

     stzcpy(flusmem.userid,usaptr->userid,UIDSIZ);
     stzcpy(flusmem.modnam,"File Library",MNMSIZ);
     movmem(fluptr,&flusmem.udata,sizeof(struct fluser));
     setbtv(genbb);
     if (acqbtv(NULL,&flusmem,0)) {
          upvbtv(&flusmem,sizeof(struct flusave));
          retval=1;
     }
     else if (flusmem.userid[0] != '\0') {
          invbtv(&flusmem,sizeof(struct flusave));
          retval=0;
     }
     rstbtv();
     return(retval);
}

char *
userdir(                           /* return temp directory or filename    */
int which)                         /* 0=dir 1=user ul 2=sdi 3=diz          */
{
     switch (which) {
     case 1:
          return(spr("%s\\UPLOAD%02x",tempdir,channel[usrnum]));
     case 2:
          return(spr("%s\\DESC%02x.SDI",tempdir,channel[usrnum]));
     case 3:
          return(spr("%s\\DESC%02x.DIZ",tempdir,channel[usrnum]));
     }
     return(spr("%s",tempdir));
}

int
valname(                           /* is passed name valid for a Library?  */
char *libname)
{
     int len;
     char *cptr;

     len=strlen(cptr=libname);
     if (len < 1 || len > 8) {
          return(0);
     }
     while (*cptr != '\0') {
          if (!isfiln(*cptr,".")) {
               return(0);
          }
          cptr++;
     }
     if (rsvnam(libname) || profane(libname)) {
          return(0);
     }
     return(1);
}

int
fileditv(                          /* verify FSD edit file session         */
int fldno,
char *answer)
{
     char nts[9];
     long ndl;

     fluoff(usrnum);
     switch (fldno) {
     case FFDULT:
          stzcpy(nts,answer,9);
          if (nts[1] == ':') {
               nts[0]='0';
               stzcpy(&nts[1],answer,8);
          }
          if (strlen(nts) == 5) {
               strcat(nts,":00");
          }
          stzcpy(answer,nctime(dctime(nts)),9);
          if (!sameas(nts,answer)) {
               setmbk(flmsg);
               stzcpy(fsdemg,getmsg(BADTIM),MAXHLP);
               rstmbk();
               return(VFYREJ);
          }
          break;
     case FFDDL:
          ndl=atol(answer);
          if (ndl < 0L) {
               ndl=0;
          }
          if (ndl > 9999999L) {
               ndl=9999999L;
          }
          strcpy(answer,l2as(ndl));
          break;
     case FFDULD:
          fsdemg[0]='\0';
          setmbk(flmsg);
          if (atoi(answer) == 0) {
               stzcpy(fsdemg,getmsg(BADDAT),MAXHLP);
          }
          else {
               if (answer[1] == '/') {
                    strcpy(answer,spr("0%s",answer));
               }
               if (answer[4] == '/') {
                    strcpy(&answer[3],spr("0%s",&answer[3]));
               }
               if (!sameas(answer,srt2dat(dat2srt(answer)))) {
                    stzcpy(fsdemg,getmsg(BADDAT),MAXHLP);
               }
               else if (strcmp(dat2srt(answer),dat2srt(ncdate(today()))) < 0) {
                    stzcpy(fsdemg,getmsg(BADDAT2),MAXHLP);
               }
          }
          rstmbk();
          if (fsdemg[0] != '\0') {
               return(VFYREJ);
          }
          break;
     case FFDUSER:
          if (sameas(answer,"Sysop")) {
               stzcpy(answer,"Sysop",UIDSIZ);
               break;
          }
          setbtv(accbb);
          if (!acqbtv(&acctmp,answer,0)) {
               setmbk(flmsg);
               stzcpy(fsdemg,getmsg(BADUID),MAXHLP);
               rstmbk();
               rstbtv();
               return(VFYREJ);
          }
          else {
               stzcpy(answer,acctmp.userid,UIDSIZ);
          }
          rstbtv();
          break;
     case FFDTXT00:
     case FFDTXT01:
     case FFDTXT02:
     case FFDTXT03:
     case FFDTXT04:
     case FFDTXT05:
     case FFDTXT06:
     case FFDTXT07:
     case FFDTXT08:
     case FFDTXT09:
     case FFDTXT10:
     case FFDTXT11:
     case FFDTXT12:
     case FFDTXT13:
     case FFDTXT14:
          if (answer[0] == '\0' && (fsdscb->newans+fldptr->ansoff)[0]== '\0') {
               fldno=fsdscb->crsfld=FFDEXIT;
          }
          else if (profane(answer)) {
               setmbk(flmsg);
               stzcpy(fsdemg,getmsg(PROFDESC),MAXHLP);
               rstmbk();
               return(VFYREJ);
          }
     }
     return(vfyadn(fldno,answer));
}

int
lsinp(void)                        /* main input handler                   */
{
     fluoff(usrnum);
     setftu();
     setmbk(flmsg);
     if (curlib == NULL || flu->lib[0] == '\0') {
          updusr(flu);
          if (usrptr->substt == 0) {
               prfmsg(NOAXESS);
          }
          return(0);
     }
     if (usrptr->flags&ABOIP) {
          switch (usrptr->substt) {
          case VIEWASC:
               prfmsg(usrptr->substt=VIEWASC);
               break;
          case ENTRETT:
               buildview(flo->hold);
               break;
          case FILELST0:
               rebuild(2);
               break;
          case TAGMAN:
               retmenu(0);
               mainmenu();
               prfmsg(MMENU);
               break;
          default:
               clrprf();
          }
          prf("");
          outprf(usrnum);
          prf("");
     }
     if (!(usrptr->flags&INJOIP) && !(usrptr->flags&ABOIP)) {
          do {
               bgncnc();
               if ((flo->flags&ENTRCNC) && isripu()) {
                    prfmsg(DEFRIPM);
               }
               if (usrptr->substt == 0) {
                    cncchr();
                    usrptr->flags&=~X2MAIN;
                    usrptr->substt=MMENU;
                    flo->flags&=~ABOUPRF;
                    flo->flags|=LONGDSC;
                    flo->flags&=~INMVCPY;
                    if (morcnc() == '&') {
                         flo->flags|=ABOUPRF;
                         flo->flags|=ENTRCNC;
                         cncchr();
                    }
               }
               else {
                    switch (inpfunc()) {
                    case 0:
                         flu->cdayin=cofdat(today());
                         deresume();
                         return(0);
                    case 2:
                         return(1);
                    }
                    fluoff(usrnum);
                    setftu();
               }
               if (curlib == NULL) {
                    return(0);
               }
               if (nxtcmd == margv[0]) { /* if inp handler didn't use any, */
                    cncall();            /* don't let it go around again   */
               }
          } while (!endcnc());
          flo->flags&=~ENTRCNC;
     }
     promptin();
     return(1);
}

void
deresume(void)                     /* cancel possibility of resuming list  */
{
     flo->tagk='A'-1;
}

int
lslon(void)                        /* system logon routine                 */
{
     switch (usrptr->substt) {
          case -1:
               return(1);
          case -2:
               rmdir(userdir(1));
               return(0);
     }
     flu=&fluarr[usrnum];
     flo=(struct fluson *)ptrblok(flomem,usrnum);
     setmem(flu,sizeof(struct fluser),0);
     setmem(flo,sizeof(struct fluson),0);
     flo->nlibaxs=-1;
     fluoff(usrnum);
     setbtv(genbb);
     stzcpy(flusmem.userid,usaptr->userid,UIDSIZ);
     stzcpy(flusmem.modnam,"File Library",MNMSIZ);
     if (!acqbtv(&flusmem,&flusmem,0)) {
          stzcpy(flusmem.userid,usaptr->userid,UIDSIZ);
          stzcpy(flusmem.modnam,"File Library",MNMSIZ);
          setmem(&flusmem.udata,sizeof(struct fluser),0);
     }
     movmem(&flusmem.udata,flu,sizeof(struct fluser));
     curlib=setuaxs();
     rstbtv();
     updusr(flu);
     if (flu->newdate[0] == '\0') {
          stzcpy(flu->newdate,dat2srt(ncdate(datofc(cofdat(today())-3))),
             DATESZ);
     }
     stzcpy(flo->newdate,flu->newdate,DATESZ);
     if (curlib != NULL && (notiflop || notifsys)) {
          notify(1);
     }
     if (ulfileq(1)) {
          setmbk(flmsg);
          prfmsg(HANGON);
          rstmbk();
          spinner();
          usrptr->substt=-1;
          btuinj(usrnum,CYCLE);
          outprf(usrnum);
          return(1);
     }
     rmdir(userdir(1));
     return(0);
}

int
srcincx(void)                      /* is screen not full of search elements*/
{
     int loop;

     if (flo->flags&REVSRCH) {
          if (flo->atend != LSTFILS && flo->atend != LSTBACK) {
               return(0);
          }
          for (loop=NLISTER-1 ; loop >= 0 ; loop--) {
               if (flo->tdline[loop] == 0) {
                    return(loop+1);
               }
          }
          return(0);
     }
     if (flo->atend != LSTFILS && flo->atend != LSTFORE) {
          return(0);
     }
     for (loop=0 ; loop < NLISTER ; loop++) {
          if (flo->tdline[loop] == 0) {
               return(loop+1);
          }
     }
     return(0);
}

int
srcgood(void)                      /* display, reject, or abort search?    */
{
     int retval=0;
     struct fllib *libptr=NULL;
     char wildkey[FLFILENM];
     union srch *current,*new,*old;

     if (flo->keymeth > 2) {
          retval=-1;
     }
     if (srcu->nlibs > 0) {
          new=(flo->flags&REVSRCH) ? &srcu->tp[srcindex]
             : &srcu->tn[srcindex];
          old=(flo->flags&REVSRCH) ? &srcu->fp[srcindex]
             : &srcu->fn[srcindex];
          movmem(new,old,sizeof(union srch));
          current=&srcactive;
          switch (flo->keymeth) {
          case 3:
               if (((flo->flags&REVSRCH)
                  && altbtv(NULL,&current->key0,COMPLUF)
                  || !(flo->flags&REVSRCH)
                  && agtbtv(NULL,&current->key0,COMPLUF))
                  && sameas(flf->libname,current->key0.libname)) {
                    stzcpy(new->key0.libname,flf->libname,FLNAMESZ);
                    stzcpy(new->key0.udate,flf->udate,DATESZ);
                    stzcpy(new->key0.filname,flf->filname,FLFILENM);
               }
               else {
                    new->key0.udate[0]=(flo->flags&REVSRCH) ? 0x00 : 0xFF;
               }
               if (!acqbtv(NULL,&srcactive.key0,COMPLUF)) {
                    return(0);
               }
               break;
          case 4:
          case 7:
          case 8:
               if (((flo->flags&REVSRCH)
                  && altbtv(NULL,&current->key1,COMPLF)
                  || !(flo->flags&REVSRCH)
                  && agtbtv(NULL,&current->key1,COMPLF))
                  && sameas(flf->libname,current->key1.libname)) {
                    stzcpy(new->key1.libname,flf->libname,FLNAMESZ);
                    stzcpy(new->key1.filname,flf->filname,FLFILENM);
               }
               else {
                    new->key1.filname[0]=(flo->flags&REVSRCH) ? 0x00 : 0xFF;
               }
               if (!acqbtv(NULL,&srcactive.key1,COMPLF)) {
                    return(0);
               }
               break;
          }
     }
     switch (flo->keymeth) {
     case 0:
          if (sameas(flf->libname,flo->u.key0.libname)) {
               retval=0;
               if ((libptr=libfind(flo->u.key0.libname)) != NULL) {
                    retval=(notapped(flf->udate) && !isflop(libptr) ? -1 : 1);
               }
          }
          if ((flo->flags&DATESRC) && stricmp(flf->udate,flo->newdate) > 0) {
               retval=0;
          }
          break;
     case 1:
          if (sameas(flf->libname,flo->u.key1.libname)) {
               retval=0;
               if ((libptr=libfind(flo->u.key1.libname)) != NULL) {
                    retval=(notapped(flf->udate) && !isflop(libptr) ? -1 : 1);
               }
          }
          break;
     case 2:
          libptr=libfind(kyd->libkey);
          if (libptr == NULL || kyd->libkey[0] == '\0'
             || !strlen(visxlib(libptr,flo->u.key2.libname))) {
               retval=-1;
          }
          else {
               retval=1;
          }
          if (!sameto(flo->u.key2.origkey,kyd->keyword)) {
               retval=0;
          }
          if (retval == 1) {
               setbtv(flfdat);
               if (!acqbtv(NULL,compkey(kyd->libkey,kyd->filname),COMPLF)) {
                    retval=-1;
               }
               if (notapped(flf->udate) && !isflop(libptr)) {
                    retval=-1;
               }
               if ((retval == 1) && (flo->kcount > 1)) {
                    retval=keysin(0);
               }
               rstbtv();
          }
          break;
     case 3:
          keylib(flf->libname,flo->u.key3.libname,&retval);
          if ((flo->flags&DATESRC) && stricmp(flf->udate,flo->newdate) > 0) {
               retval=0;
          }
          break;
     case 4:
          keylib(flf->libname,flo->u.key4.libname,&retval);
          if (retval == 1 && flo->styp == 6) {
               retval=keyfig();
          }
          break;
     case 5:
          keylib(flf->libname,flo->u.key5.libname,&retval);
          break;
     case 6:
          if (sameas(flf->libname,flo->u.key1.libname)) {
               if ((libptr=libfind(flo->u.key1.libname)) == NULL) {
                    retval=0;
               }
               else if (notapped(flf->udate) && !isflop(libptr)) {
                    retval=-1;
               }
               else if (!compwild(flo->miscfil,flf->filname)) {
                    retval=(strlen(wldstuff(wildkey))
                         && !sameto(wildkey,flf->filname) ? 0 : -1);
               }
               else {
                    retval=1;
               }
          }
          else {
               retval=0;
          }
          break;
     case 7:
          keylib(flf->libname,flo->u.key4.libname,&retval);
          if (retval == 1 && !compwild(flo->miscfil,flf->filname)) {
               retval=(strlen(wldstuff(wildkey))
                    && !sameto(wildkey,flf->filname) ? 0 : -1);
          }
          break;
     case 8:
          keylib(flf->libname,flo->u.key4.libname,&retval);
          if (retval == 1 && !sameas(flf->filname,flo->u.key4.exactfn)) {
               retval=0;
          }
          break;
     case 9:
          flo->atend=LSTFORE;
          retval=1;
     }
     return(retval);
}

int
srcnext(void)                      /* get next search element              */
{
     int flag1,flag2;

     flag1=((flo->flags&REVSRCH) ? 1 : 0);
     flag2=((flo->flags&NXTEQUL) ? 1 : 0);
     flo->flags&=~NXTEQUL;
     setbtv(flfdat);
     switch (flo->keymeth) {
     case 0:
          return(nextrec(flag1,flag2,NULL,flo->u.key0.libname,COMPLUF));
     case 1:
     case 6:
          return(nextrec(flag1,flag2,NULL,flo->u.key1.libname,COMPLF));
     case 2:
          setbtv(flkdat);
          return(nextrec(flag1,flag2,NULL,flo->u.key2.keyword,COMPKFL));
     case 3:   
          if (srcu->nlibs > 0) {
               return(nextsrc(flag2) != NULL);
          }
          return(nextrec(flag1,flag2,NULL,flo->u.key3.udate,COMPUF));
     case 4:
     case 7:
     case 8:
          if (srcu->nlibs > 0) {
               return(nextsrc(flag2) != NULL);
          }
          return(nextrec(flag1,flag2,NULL,flo->u.key4.filname,COMPFL));
     case 5:
          return(nextrec(!flag1,flag2,NULL,flo->u.key5.numdls,COMPNLF));
     case 9:
          if (flo->u.key6.filname[0] == '\0') {
               return(fnd1st(&flo->fb,flo->srcpath,0));
          }
          return(fndnxt(&flo->fb));
     }
     return(0);
}

union srch *
nextsrc(                           /* return pointer to next join record   */
int nxteq)
{
     union srch *best=NULL,*current;
     int loop,si;
     char badchr;

     if (nxteq) {
          for (loop=0 ; loop < srcu->nlibs ; loop++) {
               current=(flo->flags&REVSRCH) ? &srcu->tp[loop]
                  : &srcu->tn[loop];
               switch (flo->keymeth) {
               case 3:
                    if (sameas(current->key0.libname,flo->u.key3.libkey)) {
                         if (sameas(current->key0.udate,flo->u.key3.udate)
                            && sameas(current->key0.filname,
                            flo->u.key3.filname)) {
                              srcindex=loop;
                              movmem(current,&srcactive,sizeof(union srch));
                              return(current);
                         }
                         loop=maxjoin;
                    }
                    break;
               case 4:
               case 7:
               case 8:
                    if (sameas(current->key1.libname,flo->u.key4.libkey)) {
                         if (sameas(current->key1.filname,
                            flo->u.key4.filname)) {
                              srcindex=loop;
                              movmem(current,&srcactive,sizeof(union srch));
                              return(current);
                         }
                         loop=maxjoin;
                    }
                    break;
               }
          }
     }
     badchr=(flo->flags&REVSRCH) ? 0x00 : 0xFF;
     for (loop=0 ; loop < srcu->nlibs ; loop++) {
          current=(flo->flags&REVSRCH) ? &srcu->tp[loop] : &srcu->tn[loop];
          switch (flo->keymeth) {
          case 3:
               if (current->key0.libname[0] != '\0') {
                    if (best != NULL) {
                         si=stricmp(best->key0.udate,current->key0.udate);
                         if (si == 0) {
                              si=stricmp(best->key0.filname,
                                 current->key0.filname);
                              if (si == 0) {
                                   si=stricmp(best->key0.libname,
                                      current->key0.libname);
                              }
                         }
                         if ((flo->flags&REVSRCH) && si < 0
                            || !(flo->flags&REVSRCH) && si > 0) {
                              if (current->key0.udate[0] != badchr) {
                                   best=current;
                              }
                         }
                    }
                    else if (current->key0.udate[0] != badchr) {
                         best=current;
                    }
               }
               break;
          case 4:
          case 7:
          case 8:
               if (current->key1.libname[0] != '\0') {
                    if (best != NULL) {
                         si=stricmp(best->key1.filname,current->key1.filname);
                         if (si == 0) {
                              si=stricmp(best->key1.libname,
                                 current->key1.libname);
                         }
                         if ((flo->flags&REVSRCH) && si < 0
                            || !(flo->flags&REVSRCH) && si > 0) {
                              if (current->key1.filname[0] != badchr) {
                                   best=current;
                              }
                         }
                    }
                    else if (current->key1.filname[0] != badchr) {
                         best=current;
                    }
               }
               break;
          }
          if (best == current) {
               srcindex=loop;
          }
     }
     if (best != NULL) {
          movmem(best,&srcactive,sizeof(union srch));
     }
     return(best);
}

void
resetkey(                          /* re-set key properly for direction.   */
char *libname,
char *filname)
{
     setbtv(flfdat);
     if (!acqbtv(NULL,compkey(libname,filname),COMPLF)) {
          setmem(flf,sizeof(struct flfile),0);
     }
     switch (flo->keymeth) {
     case 0:
          stzcpy(flo->u.key0.libname,flf->libname,FLNAMESZ);
          stzcpy(flo->u.key0.filname,flf->filname,FLFILENM);
          stzcpy(flo->u.key0.udate,flf->udate,DATESZ);
          break;
     case 1:
     case 6:
          stzcpy(flo->u.key1.libname,flf->libname,FLNAMESZ);
          stzcpy(flo->u.key1.filname,flf->filname,FLFILENM);
          break;
     case 2:
          setbtv(flkdat);
          stzcpy(flo->u.key2.libkey,flf->libname,FLNAMESZ);
          stzcpy(flo->u.key2.filname,flf->filname,FLFILENM);
          break;
     case 3:
          stzcpy(flo->u.key3.filname,flf->filname,FLFILENM);
          stzcpy(flo->u.key3.udate,flf->udate,DATESZ);
          stzcpy(flo->u.key3.libkey,flf->libname,FLNAMESZ);
          break;
     case 4:
     case 7:
     case 8:
          stzcpy(flo->u.key4.libkey,flf->libname,FLNAMESZ);
          stzcpy(flo->u.key4.filname,flf->filname,FLFILENM);
          break;
     case 5:
          sprintf(flo->u.key5.numdls,NUMSZP,atol(flf->numdls));
          stzcpy(flo->u.key5.libkey,flf->libname,FLNAMESZ);
          stzcpy(flo->u.key5.filname,flf->filname,FLFILENM);
     }
}

void
rset(void)                         /* find key to reset to and do it       */
{
     int loop;

     if (!(flo->flags&REVSRCH)) {
          for (loop=NLISTER-1 ; loop >= 0 ; loop--) {
               if (flo->tdline[loop] != 0) {
                    resetkey(flo->tags[loop].libname,flo->tags[loop].filname);
                    break;
               }
          }
     }
     else {
          for (loop=0 ; loop < NLISTER ; loop++) {
               if (flo->tdline[loop] != 0) {
                    resetkey(flo->tags[loop].libname,flo->tags[loop].filname);
                    break;
               }
          }
     }
}

int
dosinsrt(                          /* insert file into DOS-Only Library    */
struct fllib *libptr,              /* Library                              */
char *path,                        /* path where file is stored            */
struct fndblk *f)                  /* stuff including filename info        */
{
     stzcpy(flo->srcpath,spr("%s\\%s",fixpath(path),f->name),PATHSIZE);
     stzcpy(flo->destpath,spr("%s\\%s",libpath(libptr),f->name),PATHSIZE);
     if (sameas(flo->srcpath,flo->destpath)) {
          return(1);
     }
     unlink(flo->destpath);
     if (rename(flo->srcpath,flo->destpath) != 0) {
          flo->fsrc=fopen(flo->srcpath,FOPRB);
          flo->fdst=fopen(flo->destpath,FOPWB);
          if (flo->fsrc == NULL) {
               if (flo->fdst != NULL) {
                    fclose(flo->fdst);
                    flo->fdst=NULL;
               }
               return(-2);
          }
          if (flo->fdst == NULL) {
               if (flo->fsrc != NULL) {
                    fclose(flo->fsrc);
                    flo->fsrc=NULL;
               }
               return(-2);
          }
          return(2);
     }
     return(1);
}

int
insfile(                           /* insert file into file database       */
struct fllib *libptr,              /* Library                              */
char *path,                        /* path where file is stored            */
struct fndblk *f,                  /* stuff including filename info        */
char *appdate,                     /* approval date, NOTAPPED if unappved  */
char *u,                           /* uploaded by                          */
char *desc)                        /* var length description               */
{
     struct taglib *tag;
     int retval=1,loop;
     char *key;

     if (libptr->flags&FLGDOS) {
          return(dosinsrt(libptr,path,f));
     }
     setbtv(flfdat);
     if (unifile && agebtv(NULL,key=rcompkey("",f->name),COMPFL)
                 && sameas(flf->filname,key)) {
          rstbtv();
          return(-1);
     }
     if (acqbtv(NULL,key=compkey(libptr->libname,f->name),COMPLF)) {
          if (!(flo->flags&REUPLOD)) {
               flo->fsrc=fopen(spr("%s\\%s",libpath(libptr),f->name),FOPRB);
               if (flo->fsrc != NULL) {
                    fclose(flo->fsrc);
                    flo->fsrc=NULL;
                    rstbtv();
                    return(-1);
               }
               else if (acqbtv(NULL,key,COMPLF)) {
                    delbtv();
               }
          }
     }
     else if (flo->flags&REUPLOD) {
          flo->flags&=~REUPLOD;
     }
     if (!(flo->flags&REUPLOD)) {
          setmem(flf,FLFILREC+DESCSIZ,0);
          stzcpy(flf->libname,libptr->libname,FLNAMESZ);
          stzcpy(flf->filname,f->name,FLFILENM);
          stzcpy(flf->udate,appdate,DATESZ);
          flf->utime=now();
          flf->siz=f->size;
          stzcpy(flf->fdate,dat2srt(ncdate(f->date)),DATESZ);
          flf->tim=f->time;
          stzcpy(flf->numdls,spr(NUMSZP,0L),NUMSZ);
          stzcpy(flf->ulby,u,UIDSIZ);
          stzcpy(flf->desc,desc,DESCSIZ);
          invbtv(NULL,FLFILREC+strlen(desc)+1);
     }
     else {
          for (loop=0 ; loop < systags ; loop++) {
               tag=tagoff(loop);
               if (tag->status > TGEMPTY && tag->usrnum != usrnum
                  && sameas(tag->filname,f->name)
                  && sameas(tag->libname,libptr->libname)) {
                    prf("\rAnother user "
                        "has this file, %s, tagged for download!\r",f->name);
                    outprf(usrnum);
                    prf("");
                    return(-1);
               }
          }
          libptr->numfiles--;
          libptr->totbytes-=clfit(flf->siz,libptr->cluster);
          if (notapped(flf->udate)) {
               libptr->appwait--;
          }
          chuldate(libptr,flf->udate,0);
          stzcpy(flf->udate,appdate,DATESZ);
          flf->utime=now();
          flf->siz=f->size;
          stzcpy(flf->fdate,dat2srt(ncdate(f->date)),DATESZ);
          flf->tim=f->time;
          stzcpy(flf->ulby,u,UIDSIZ);
          upvbtv(NULL,FLFILREC+strlen(flf->desc)+1);
     }
     stzcpy(flo->key1.libname,libptr->libname,FLNAMESZ);
     stzcpy(flo->key1.filname,f->name,FLFILENM);
     stzcpy(flo->srcpath,spr("%s\\%s",fixpath(path),f->name),PATHSIZE);
     stzcpy(flo->destpath,spr("%s\\%s",libpath(libptr),f->name),PATHSIZE);
     if (!sameas(flo->srcpath,flo->destpath)) {
          unlink(flo->destpath);
          if (rename(flo->srcpath,flo->destpath) != 0) {
               retval=2;
               flo->fsrc=fopen(flo->srcpath,FOPRB);
               flo->fdst=fopen(flo->destpath,FOPWB);
               if (flo->fsrc == NULL) {
                    retval=-2;
               }
               if (flo->fdst == NULL) {
                    retval=-2;
                    if (flo->fsrc != NULL) {
                         fclose(flo->fsrc);
                         flo->fsrc=NULL;
                    }
               }
               else if (retval == -2) {
                    fclose(flo->fdst);
                    flo->fdst=NULL;
               }
          }
          else {
               retval=1;
          }
     }
     else {
          retval=1;
     }
     libptr->numfiles++;
     libptr->totbytes+=clfit(f->size,libptr->cluster);
     if (notapped(appdate)) {
          libptr->appwait++;
     }
     chuldate(libptr,appdate,1);
     libptr->flags|=LIBCHN;
     return(retval);
}

int
keywordy(void)                     /* state handler                        */
{
     char *curkwd,*lastkwd;
     int loop;

     spinner();
     vdaptr=vdaoff(usrnum);
     if (flo->miscflag == -1) {
          setbtv(flkdat);
          if (!delkw("",flo->kwdy.filname,flo->kwdy.libname)) {
               flo->miscflag=0;
               setbtv(flfdat);
               if (acqbtv(NULL,compkey(flo->kwdy.libkey,flo->kwdy.filname),
                  COMPLF) && makwdlst(flf->desc,flf->filname)) {
                    for (loop=0 ; loop < dargc ; loop++) {
                         stzcpy(&vdaptr[FLKEYSIZ*loop],dargv[loop],FLKEYSIZ);
                    }
                    flo->kcount=dargc;
               }
               rstbtv();
          }
     }
     else {
          if (flo->miscflag >= flo->kcount) {
               return(0);
          }
          lastkwd=(flo->miscflag ? &vdaptr[FLKEYSIZ*(flo->miscflag-1)] : "");
          curkwd=&vdaptr[FLKEYSIZ*flo->miscflag++];
          stzcpy(flo->kwdy.keyword,curkwd,FLKEYSIZ);
          if (!sameas(curkwd,lastkwd) && !samein(spr(" %s ",curkwd),nonkwds)) {
               setbtv(flkdat);
               insbtv(&flo->kwdy);
               rstbtv();
          }
     }
     prf("");
     outprf(usrnum);
     prf("");
     return(1);
}

int
libeditv(                          /* verify FSD edit Library session      */
int fldno,
char *answer)
{
     long lrange;
     char *stg;

     switch (fldno) {
     case FLDCBD:
          if (sameas(answer,"YES")) {
               fsdfxt(FLDPATH,stg=spr(""),PATHSIZE);
               if (stg[0] == '\0') {
                    setmbk(flmsg);
                    stzcpy(fsdemg,getmsg(SVRNOT),MAXHLP);
                    rstmbk();
               }
          }
          break;
     case FLDPATH:
          if (answer[0] != '\0' && !valpath(answer)) {
               setmbk(flmsg);
               stzcpy(fsdemg,getmsg(BADDIR),MAXHLP);
               rstmbk();
               return(VFYREJ);
          }
          strupr(checkdir(answer));
          break;
     case FLDPLOP:
          if (answer[0] == '\0') {
               break;
          }
          if (sameas(answer,"Sysop")) {
               stzcpy(answer,"Sysop",UIDSIZ);
               break;
          }
          setbtv(accbb);
          if (!acqbtv(&acctmp,answer,0)) {
               setmbk(flmsg);
               stzcpy(fsdemg,getmsg(BADUID),MAXHLP);
               rstmbk();
               rstbtv();
               return(VFYREJ);
          }
          else {
               stzcpy(answer,acctmp.userid,UIDSIZ);
          }
          rstbtv();
          break;
     case FLDVIS:
     case FLDDLD:
     case FLDULD:
     case FLDOVW:
     case FLDAPU:
     case FLDLOP:
          if (answer[0] != '\0' && !keynam(strupr(answer))) {
               setmbk(flmsg);
               stzcpy(fsdemg,getmsg(BADKEY),MAXHLP);
               rstmbk();
               return(VFYREJ);
          }
          break;
     case FLDROY:
          if ((lrange=atol(answer)) < 0L || lrange > 100L) {
               setmbk(flmsg);
               stzcpy(fsdemg,getmsg(BADROY),MAXHLP);
               rstmbk();
               return(VFYREJ);
          }
          strcpy(answer,l2as(lrange));
          break;
     case FLDCDF:
     case FLDCDK:
     case FLDMFL:
     case FLDMBT:
     case FLDMUP:
          if ((lrange=atol(answer)) < 0L || lrange > 999999999L) {
               setmbk(flmsg);
               stzcpy(fsdemg,getmsg(BADLONG),MAXHLP);
               rstmbk();
               return(VFYREJ);
          }
          strcpy(answer,l2as(lrange));
     }
     return(vfyadn(fldno,answer));
}

int
valpath(                           /* determine validity of a passed path  */
char *path)
{
     static struct fndblk fb;
     int flag;

     path=fixpath(path);
     flag=mkdir(path);
     if (flag != 0 && !fnd1st(&fb,path,FAMDIR)) {
          if (!samend(path,":\\.") && !samend(path,":/.")) {
               if (strlen(path) != 3 || !samend(path,":.")) {
                    return(0);
               }
          }
     }
     if (flag == 0) {
          rmdir(path);
     }
     return(1);
}

int
taglist(void)                      /* display taglist if there is one      */
{
     int loop,lastidx=-1,nlfiles=0,idx=-1,numdisp=0,lim,warntime=0,blimit,
         stoprf=0;
     long totsize=0L,totchg=0L,totsecs=0L,pbuf;
     struct fllib *lib;

     if (ftuptr->numftg > 0) {
          moploop();
          prfmsg(TAGLST);
          blimit=btuoba(usrnum)-1200;
          for (loop=0 ; loop < ftuptr->numftg ; loop++) {
               ftgptr=&ftgusr[loop];
               fltagf=0;
               ftgptr->tshndl(TSHDSC);
               setmbk(flmsg);
               if (fltagf) {
                    if (spc->status == TGLOCAL || spc->status == TGDLTMP) {
                         if ((lib=libfind(spc->libname)) != NULL) {
                              totsize+=spc->size;
                              totchg+=dnlchg(spc->size,spc->libname);
                              totsecs+=dnlsecl(spc->size,lib);
                              nlfiles++;
                         }
                         else {
                              spc->status=-spc->status;
                         }
                    }
                    if (spc->status > TGEMPTY) {
                         idx++;
                    }
               }
               else {
                    idx++;
               }
               if (lastidx != idx) {
                    if ((pbuf=prfptr-prfbuf) <= blimit) {
                         setmisc(spr("%d",idx+1));
                         prfmsg(TAGLSTL);
                    }
                    else if (pbuf > blimit && !stoprf) {
                         prfmsg(MORETAGS,ftuptr->numftg-loop);
                         stoprf=1;
                    }
                    numdisp++;
               }
               lastidx=idx;
          }
          if (nlfiles > 1) {
               if (totsize > 0L) {
                    setmisc(fzer(totsize/1024L));
                    prfmsg(DNLSIZE);
                    setmisc(skpwht(dnlmin(totsize)));
                    prfmsg(DNLTIME);
                    lim=usrptr->cltptr->limday;
                    if ((((usaptr->timtdy+15L+totsecs)/60L) >= lim)
                      && (lim != -1)) {
                         warntime=1;
                    }
                    lim=usrptr->cltptr->limcal;
                    if (((usrptr->minut4/4+totsecs/60L+1) >= lim)
                      && (lim != -1)) {
                         warntime=1;
                    }
               }
               if (totchg > 0L) {
                    setmisc(l2as(totchg));
                    prfmsg(DNLCHGS);
                    setmisc(l2as(usaptr->creds+    /* future api */
                       (fndcls(usaptr->curcls)->dbtlmt)));
                    prfmsg(DNLYOURC);
                    if (!tstcrd(totchg)) {
                         prfmsg(numdisp > 1 ? WARNDLM : WARNDLA);
                    }
               }
               if (warntime) {
                    prfmsg(numdisp > 1 ? WARNTMM : WARNTMA);
               }
          }
          if (uwaitcpy(usrnum) == 1) {
               prfmsg(WARNCOPY);
          }
          switch (numdisp) {
          case 0:
               clrprf();
               if (flo->flags&OFTGMAN) {
                    usrptr->substt=PRESENTR;
                    flo->retstt=FILELST0;
                    inpfunc();
                    prf("");
               }
               else {
                    retmenu(0);
               }
               break;
          case 1:
               prfmsg(TAGFOOTA);
               break;
          default:
               prfmsg(TAGFOOTN,lastidx+1,-(lastidx+1));
          }
     }
     return(ftuptr->numftg);
}

int
zapcrd(                            /* check for/stop charging credits      */
int yes,
long siz,
struct fllib *dlib)
{
     int retval=1;

     flo->crdrat=usrptr->crdrat;
     flo->nozap=(int)(usrptr->flags&NOZAP);
     if ((siz > 0L) && (dlib != NULL)) {
          if (!tstcrd(dnlchg(siz,dlib->libname))) {
               retval=0;
          }
     }
     if (yes) {
          usrptr->crdrat=0;
          usrptr->flags|=NOZAP;
     }
     return(retval);
}

struct fllib *
keylib(                            /* function to search with              */
char *libfound,
char *libname,
int *retval)
{
     struct fllib *libptr=NULL;

     libptr=libfind(libfound);
     if (libptr == NULL || libfound[0] == '\0'
        || !strlen(visxlib(libptr,libname))) {
          return(libptr);
     }
     *retval=1;
     if (sameas(libfound,flf->libname)
        && notapped(flf->udate) && !isflop(libptr)) {
          *retval=-1;
     }
     return(libptr);
}

struct fllib *
nxtlib(void)                       /* find next Library in flu's structure */
{
     struct fllib *retval;

     while (flo->index < numoflib) {
          retval=liboff(flo->index++);
          if (valname(retval->libname) && visilib(retval)) {
               return(retval);
          }
     }
     return(NULL);
}

void
optiprf(void)                      /* optimize prfbuf                      */
{
     char *spstart=NULL;

     for (prfptr=prfbuf ; *prfptr != '\0' ; prfptr++) {
          if (spstart == NULL) {
               if (*prfptr == ' ') {
                    spstart=prfptr;
               }
          }
          else if (*prfptr != ' ') {
               if (*prfptr == '\r') {
                    strcpy(spstart,prfptr);
                    prfptr=spstart;
               }
               spstart=NULL;
          }
     }
}

void
bgnfiled(                          /* begin file edit / or just display    */
int display)
{
     char *stgptr;
     int loop;

     setbtv(flfdat);
     setmem(descedit,DESCSIZ,0);
     if (!acqbtv(NULL,&flo->key1,COMPLF)) {
          return;
     }
     strupr(flo->key1.filname);
     stzcpy(flo->fdate,flf->fdate,DATESZ);
     flo->ftim=flf->tim;
     stzcpy(flo->udate,flf->udate,DATESZ);
     flo->siz=flf->siz;
     stzcpy(flo->ulby,flf->ulby,UIDSIZ);
     flo->timeul=flf->utime;
     flo->numdls=atol(flf->numdls);
     stzcpy(descedit,flf->desc,DESCSIZ);
     if (isansiu()) {
          if (!display) {
               fsdrhd(spr("%s",getmsg(EDITINFO)));
               outprf(usrnum);
          }
          fileditp(FILEDITA,(display ? -1 : 1),display);
          stgptr=(display ? getmsg(fsdusr->tmpmsg) : getasc(fsdusr->tmpmsg));
          if (display) {
               tpwipe(stgptr,FFDEXIT,12,3);
               fsddsp(stgptr);
               optiprf();
               outprf(usrnum);
               return;
          }
          tpwipe(stgptr,FFDDLT,6,1);
          tpwipe(stgptr,FFDCHG,3,1);
          fsdbkg(stgptr);
          fsdscb->flddat[FFDNAME].flags|=FFFAVD;
          fsdscb->flddat[FFDLIB].flags|=FFFAVD;
          fsdscb->flddat[FFDDATE].flags|=FFFAVD;
          fsdscb->flddat[FFDTIME].flags|=FFFAVD;
          fsdscb->flddat[FFDSIZE].flags|=FFFAVD;
          fsdscb->flddat[FFDDLT].flags|=FFFAVD;
          fsdscb->flddat[FFDCHG].flags|=FFFAVD;
          if (!isflop(curlib)) {
               fsdscb->flddat[FFDUSER].flags|=FFFAVD;
               fsdscb->flddat[FFDDL].flags|=FFFAVD;
               fsdscb->flddat[FFDULD].flags|=FFFAVD;
               fsdscb->flddat[FFDULT].flags|=FFFAVD;
          }
          if (notapped(flf->udate)) {
               fsdscb->flddat[FFDULD].flags|=FFFAVD;
               fsdscb->flddat[FFDULT].flags|=FFFAVD;
          }
          fsdego(fileditv,fileditd);
          optiprf();
     }
     else {
          if (display) {
               prfmsg(FILEDITX,flo->key1.filname,srt2dat(flo->fdate),
                  flo->key1.libname,nctime(flo->ftim),l2as(flo->siz));
               stgptr="UNAPPROVED";
               if (!notapped(flo->udate)) {
                    stgptr=srt2dat(flo->udate);
               }
               prfmsg(FILEDITY,flo->ulby,l2as(flo->numdls),stgptr,
                    nctime(flo->timeul),dnlmin(flo->siz),
                    l2as(dnlchg(flo->siz,flo->key1.libname)));
               darsdesc(NDESCLN,'\r');
               for (loop=0 ; loop < NDESCLN ; loop++) {
                    if (dargv[loop][0] != '\0') {
                         if (loop == 0) {
                              prfmsg(FILEDITD);
                         }
                         prf("   %s\r",dargv[loop]);
                    }
               }
          }
          else {
               fileditp(FILEDITN,-1,0);
               btuoes(usrnum,1);
               usrptr->substt=FILEDITN;
               prfmsg(FILEDITX,flo->key1.filname,srt2dat(flo->fdate),
                  flo->key1.libname,nctime(flo->ftim),l2as(flo->siz));
               prfmsg(FILEDITZ);
          }
     }
     if (isansiu()) {
          powprf();
     }
     else {
          outprf(usrnum);
     }
     clrprf();
}

int
uwaitcpy(                          /* does this user have files copying?   */
int unum)
{
     int loop,tg=0;
     struct taglib *tagptr;

     for (loop=0 ; loop < systags ; loop++) {
          tagptr=tagoff(loop);
          if (tagptr->usrnum == unum) {
               switch (tagptr->status) {
               case TGINWAIT:
               case TGOTHER:
               case TGSERVER:
               case TGCOPY:
                    return(1);
               default:
                    tg=1;
               case TGEMPTY:
                    break;
               }
          }
     }
     return(tg ? 0 : -1);
}

void
notifu(void)                       /* notify user optionally, assumes ftag */
{
     if (onsysn(uacoff(ftag->usrnum)->userid,1)) {
          if (!(othusp->flags&NOINJO) && !uwaitcpy(othusn)
             && (ntagged(othuap->userid) > 0)) {
               setmbk(flmsg);
               prfmlt(BEEP);
               if (othusp->state == flstt && othusp->substt == PLSWAIT) {
                    othusp->substt=TAGMAN;
               }
               prfmlt(YERFILE);
               rstmbk();
               injoth();
               clrmlt();
          }
     }
     else {
          ftag->status=-ftag->status;
     }
}

int
ntagged(                           /* # of files user has tagged           */
char *uid)
{
     struct taglib *tag;
     int loop,retval=0;

     if (!onsysn(uid,1)) {
          return(0);
     }
     for (loop=0 ; loop < systags ; loop++) {
          tag=tagoff(loop);
          if (tag->status > TGEMPTY && othusn == tag->usrnum) {
               retval++;
          }
     }
     return(retval);
}

void
checkoth(void)                     /* check if others waiting on same file */
{
     struct taglib *savetag;
     int loop;

     savetag=ftag;
     for (loop=0 ; loop < systags ; loop++) {
          ftag=tagoff(loop);
          if (ftag != savetag) {
               switch (savetag->status) {
               case TGINWAIT:
               case TGOTHER:
               case TGSERVER:
                    if (sameas(savetag->filname,ftag->filname)
                       && sameas(savetag->libname,ftag->libname)) {
                         ftag->status=TGDLTMP;
                         notifu();
                    }
               }
          }
     }
     ftag=savetag;
}

void
ulcount(void)                      /* ongoing count of uploads this week   */
{
     int retval=0,ago;
     struct fllib *libptr;

     setbtv(flfdat);
     if (agtbtv(NULL,&countkey,COMPLUF) && sameas(flf->libname,countlib)) {
          stzcpy(countkey.filname,flf->filname,FLFILENM);
          stzcpy(countkey.udate,flf->udate,DATESZ);
          ago=cofdat(today())-cofdat(dcdate(srt2dat(flf->udate)));
          if (ago >= 0 && ago < ULDAYS) {
               countuls[ago]++;
               retval=1;
          }
     }
     if (!retval) {
          libptr=libfind(countlib);
          countlib[0]='\0';
          if (libptr != NULL) {
               for (ago=0 ; ago < ULDAYS ; ago++) {
                    libptr->newfiles[ago]=countuls[ago];
               }
               libptr->flags|=LIBCHN;
          }
     }
     rstbtv();
}

void
inicount(                          /* initialize counting a Library        */
char *libname)
{
     int loop;

     setmem(&countkey,sizeof(struct key0),0);
     stzcpy(countkey.libname,libname,FLNAMESZ);
     stzcpy(countkey.udate,"0000009",DATESZ);
     for (loop=0 ; loop < ULDAYS ; loop++) {
          countuls[loop]=0;
     }
     stzcpy(countlib,libname,FLNAMESZ);
}

int
addkwnow(void)                     /* add the first keyword waiting...     */
{

     if (kwbuf[0].keyword[0] != '\0') {
          setbtv(flkdat);
          if (!acqbtv(NULL,&kwbuf[0],0)) {
               insbtv(&kwbuf[0]);
          }
          rstbtv();
          movmem(&kwbuf[1],&kwbuf[0],(SIZKWBUF-1)*sizeof(struct key7));
          setmem(&kwbuf[SIZKWBUF-1],sizeof(struct key7),0);
          return(1);
     }
     return(0);
}

void
addkw(                             /* add keyword to disk buffer memory    */
char *keyword,
char *filname,
char *libname)
{
     struct key7 *kwp;
     int loop;

     if ((kwp=&kwbuf[SIZKWBUF-1])->keyword[0] != '\0') {
          addkwnow();
     }
     else {
          for (loop=0 ; loop < SIZKWBUF ; loop++) {
               if ((kwp=&kwbuf[loop])->keyword[0] == '\0') {
                    break;
               }
          }
     }
     stzcpy(kwp->keyword,keyword,FLKEYSIZ);
     stzcpy(kwp->filname,filname,FLFILENM);
     stzcpy(kwp->libname,libname,FLNAMESZ);
}

void
keywdaut(                          /* insert keywords to .DAT one at a time*/
int taskid)
{
     if (!addkwnow()) {
          mfytask(taskid,NULL);
          kwaut=0;
     }
}

int
delkw(
char *keyword,
char *filname,
char *libname)
{
     struct key7 *kwp;
     int loop,retval=0;

     if (libname[0] == '\0') {
          return(0);
     }
     for (loop=0 ; loop < SIZKWBUF ; loop++) {
          if ((kwp=&kwbuf[loop])->libname[0] == '\0') {
               break;
          }
          if (sameas(libname,kwp->libname)) {
               if (keyword[0] == '\0' || sameas(keyword,kwp->keyword)) {
                    if (sameas(filname,kwp->filname)) {
                         movmem(&kwbuf[loop+1],&kwbuf[loop],
                            (SIZKWBUF-loop+1)*sizeof(struct key7));
                         setmem(&kwbuf[SIZKWBUF-1],sizeof(struct key7),0);
                         return(1);
                    }
               }
          }
     }
     setbtv(flkdat);
     if (filname[0] != '\0') {
          if (acqbtv(NULL,rcompkey(libname,filname),COMPFL_K)) {
               delbtv();
               retval=1;
          }
     }
     rstbtv();
     return(retval);
}

void
copyaut(                           /* copy a file, in chunks               */
int taskid)
{
     static long sleft;
     int readsiz,close=0;
     char *stg,dpath[80];
     struct fllib *libptr=NULL;
     struct fndblk fb;

     if (!findbest(TGCOPY)) {
          mfytask(taskid,NULL);
          return;
     }
     if (!space()) {
          return;
     }
     if (csrc == NULL && cdst == NULL) {
          libptr=libfind(ftag->libname);
          if (libptr == NULL) {
               ftag->status=-ftag->status;
               return;
          }
          stg=spr("%s\\%s",libpath(libptr),ftag->filname);
          readsiz=fnd1st(&fb,stg,0);
          sprintf(dpath,"%s\\%s",copydir,ftag->libname);
          mkdir(dpath);
          strcat(dpath,"\\");
          strcat(dpath,ftag->filname);
          cdst=fopen(dpath,FOPWB);
          if (cdst != NULL) {
               if (readsiz && (csrc=fopen(stg,FOPRB)) != NULL) {
                    ftag->size=sleft=fb.size;
               }
               else {
                    ftag->status=-ftag->status;
                    fclose(cdst);
                    cdst=NULL;
                    unlink(dpath);
               }
          }
          else {
               ftag->status=-ftag->status;
          }
          return;
     }
     readsiz=1024;
     if (sleft < 1024L) {
          readsiz=(int)sleft;
     }
     sleft-=(long)readsiz;
     ftag->copied+=readsiz;
     if (!fread(vdatmp,readsiz,1,csrc) || !fwrite(vdatmp,readsiz,1,cdst)) {
          ftag->status=-ftag->status;
          close=1;
     }
     if (close || sleft == 0L) {
          fclose(csrc);
          csrc=NULL;
          fclose(cdst);
          cdst=NULL;
          libptr=libfind(ftag->libname);
          if (libptr != NULL) {
               stg=spr("%s\\%s",libpath(libptr),ftag->filname);
               sprintf(dpath,"%s\\%s",copydir,ftag->libname);
               mkdir(dpath);
               strcat(dpath,"\\");
               strcat(dpath,ftag->filname);
               touch(stg,dpath);
          }
          if (!close) {
               ftag->status=TGDLTMP;
               notifu();
               checkoth();
          }
     }
}

void
doalr(void)                        /* re-mark files already tagged         */
{
     int loop;

     for (loop=0 ; loop < NLISTER ; loop++) {
          if (alrtag(flo->tags[loop].libname,flo->tags[loop].filname)) {
               if (flo->tdline[loop] > 0) {
                    flo->tdline[loop]=-flo->tdline[loop];
               }
          }
     }
}

void
dsearch(                           /* recursively get how user searches    */
int which,
int x)
{
     int mode;

     switch (which) {
     case 0:
          wipetag();
          setmem(flo->keylist,FLKEYLST,0);
          if (x == 0) {
               x=defstyp;
          }
          switch (x) {
          default:
          case 1:
               usrptr->substt=FLSTYPA;
               break;
          case 7:
               flo->styp=2;
               flo->flags|=DATESRC;
               dsearch(1,((flo->flags&ABOUPRF) ? 1 : flu->mylib));
               break;
          case 2:
               flo->flags&=~DATESRC;
          case 5:
               flo->styp=x;
               dsearch(1,((flo->flags&ABOUPRF) ? 1 : flu->mylib));
               break;
          case 3:
          case 6:
               flo->styp=(x == 3 ? 3 : 7);
               usrptr->substt=ASKNAME;
               break;
          case 4:
               flo->styp=4;
               usrptr->substt=ASKWORD;
               btumil(usrnum,FLKEYLST-1);
          }
          break;
     case 1:
          if (x == 0) {
               x=defslib;
          }
          switch (x) {
          default:
          case 1:
               usrptr->substt=FLSLIB;
               break;
          case 2:
          case 3:
               usrptr->substt=MMENU;
               switch (flo->styp) {
               case 3:
               case 4:
                    mode=flo->styp-1;
                    break;
               case 6:
                    mode=4;
                    break;
               case 5:
                    mode=5;
                    break;
               case 7:
                    mode=6;
                    break;
               default:
                    mode=1;
               }
               srcinit(mode,(x == 2) ? flu->lib : "");
          }
     }
}

void
fileditd(                          /* FSD finish editing file desc/etc.    */
int save)
{
     int loop,len,tim;
     char temp[UIDSIZ],date[DATESZ],*sptr;

     flu=&fluarr[usrnum];
     if (flu->lib[0] == '\0') {
          return;
     }
     setmbk(flmsg);
     curusr(usrnum);
     fluoff(usrnum);
     usrptr->state=flstt;
     usrptr->substt=flo->retstt;
     if ((fsdscb->chgcnt == 0) && (libfind(libedt->lib.libname) != NULL)) {
          prfmsg(NOCH);
     }
     else if (!save) {
          prfmsg(CHQUIT);
     }
     else {
          prfmsg(SAVED);
          setmem(descedit,DESCSIZ,0);
          for (loop=0 ; loop < NDESCLN ; loop++) {
               len=strlen(descedit);
               fsdfxt(FFDTXT00+loop,sptr=&descedit[strlen(descedit)],SDESCLN);
               if (!loop && sameas(sptr,DESCFNON) ||
                  loop == 1 && sameas(sptr,DESCFNO2)) {
                    *sptr='\0';
               }
               if (strlen(descedit) > len) {
                    strcat(descedit,"\r");
               }
          }
          fsdfxt(FFDUSER,flo->ulby,UIDSIZ);
          fsdfxt(FFDDL,temp,NUMSZ);
          flo->numdls=atol(temp);
          fsdfxt(FFDULD,temp,UIDSIZ);
          stzcpy(date,dat2srt(temp),DATESZ);
          fsdfxt(FFDULT,temp,UIDSIZ);
          tim=dctime(temp);
          setbtv(flfdat);
          if (acqbtv(NULL,&flo->key1,COMPLF)) {
               stzcpy(flf->ulby,flo->ulby,UIDSIZ);
               sprintf(flf->numdls,NUMSZP,flo->numdls);
               stzcpy(flf->desc,descedit,DESCSIZ);
               stzcpy(flf->udate,(atoi(date) != 0) ? date : NOTAPPED,DATESZ);
               flf->utime=tim;
               upvbtv(NULL,FLFILREC+strlen(flf->desc)+1);
               flo->retstt=usrptr->substt;
               if (!longsrch && kwdout()) {
                    outprf(usrnum);
                    clrprf();
                    return;
               }
               usrptr->substt=flo->retstt;
          }
     }
     outprf(usrnum);
     if (flo->retstt == AUTOLOG) {
          usrptr->substt=AUTOLOG;
          btuinj(usrnum,CYCLE);
     }
     else {
          btucli(usrnum);
          fluoff(usrnum);
          promptin();
     }
     clrprf();
}

void
fileditp(                          /* FSD utility function                 */
int msgno,
int amode,
int display)
{
     char *appdate,*proprlib;
     struct fllib *libptr;

     libptr=libfind(flo->key1.libname);
     proprlib=((display && libptr != NULL) ? visxlib(libptr,flo->lrange)
        : flo->key1.libname);
     appdate=(notapped(flo->udate) ? NULL : srt2dat(flo->udate));
     fsdroom(msgno,filedits,amode);
     darsdesc(NDESCLN,'\r');
     sprintf(vdatmp,fileditf,
          flo->key1.filname,'\0',
          proprlib,'\0',
          srt2dat(flo->fdate),'\0',
          spr("%s",nctime(flo->ftim)),'\0',
          spr("%s bytes",l2as(flo->siz)),'\0',
          l2as(flo->numdls),'\0',
          (appdate == NULL ? "UNAPP" : appdate),'\0',
          spr("%s",nctime(flo->timeul)),'\0',
          display ? spr("%s [32mminutes",dnlmin(flo->siz)) : "",'\0',
          display ? l2as(dnlchg(flo->siz,flo->key1.libname)) : "",'\0',
          flo->ulby,'\0',
          (display || strlen(dargv[0]) ? dargv[0] : DESCFNON),'\0',
          (display || strlen(dargv[1]) ? dargv[1] : DESCFNO2),'\0',
          dargv[2],'\0',
          dargv[3],'\0',
          dargv[4],'\0',
          dargv[5],'\0',
          dargv[6],'\0',
          dargv[7],'\0',
          dargv[8],'\0',
          dargv[9],'\0',
          dargv[10],'\0',
          dargv[11],'\0',
          dargv[12],'\0',
          dargv[13],'\0',
          dargv[14],'\0');
     fsdapr(vdaptr,vdasiz,vdatmp);
}

void
lsclean(void)                      /* nightly cleanup routine              */
{
     switch (clnlevel) {
     case 2:
     case 1:
          countupl();
          cleanit(clnlevel == 2 ? 1 : 0);
     default:
          do {
          } while (libchg());
     }
     purgecpy(1);
}

void
lsdel(                             /* deletes Library user reference       */
char *uid)
{
     setbtv(genbb);
     stzcpy(flusmem.userid,uid,UIDSIZ);
     stzcpy(flusmem.modnam,"File Library",MNMSIZ);
     if (acqbtv(NULL,&flusmem,0)) {
          delbtv();
     }
}

void
lsend(void)                        /* system shutdown                      */
{
     while (libchg()) {
     }
     if (kwaut) {
          while (addkwnow()) {
          }
          kwaut=0;
     }
     if (flmsg != NULL) {
          clsmsg(flmsg);
     }
     if (csrc != NULL) {
          fclose(csrc);
     }
     if (cdst != NULL) {
          fclose(cdst);
     }
     if (movs != NULL) {
          fclose(movs);
     }
     if (movd != NULL) {
          fclose(movd);
     }
     clsbtv(flfdat);
     clsbtv(flldat);
     clsbtv(flkdat);
     purgecpy(0);
}

void
purgecpy(                          /* purge copy and/or upload directories */
int rmvdirs)
{
     struct fndblk dirs,fils;

     if (fnd1st(&dirs,spr("%s\\*.*",copydir),FAMDIR)) {
          do {
               if ((dirs.attr&FAMDIR) && dirs.name[0] != '.') {
                    if (fnd1st(&fils,spr("%s\\%s\\*.*",copydir,dirs.name),0)) {
                         do {
                              unlink(spr("%s\\%s\\%s",
                                   copydir,dirs.name,fils.name));
                         } while (fndnxt(&fils));
                    }
                    if (rmvdirs) {
                         rmdir(spr("%s\\%s",copydir,dirs.name));
                    }
               }
          } while (fndnxt(&dirs));
     }
     if (rmvdirs && fnd1st(&fils,spr("%s\\*.*",userdir(0)),0)) {
          do {
               unlink(spr("%s\\%s",userdir(0),fils.name));
          } while (fndnxt(&fils));
     }
}

void
lshang(void)                       /* user hangup routine                  */
{
     char fname[FLFILENM];
     int ctr=0;

     if (usrptr->state == flstt) {
          echonu(usrnum);
          btutrg(usrnum,0);
     }
     fluoff(usrnum);
     if (flo->fsrc != NULL) {
          fclose(flo->fsrc);
     }
     if (flo->fdst != NULL) {
          fclose(flo->fdst);
     }
     flo->fdst=flo->fsrc=NULL;
     updusr(flu);
     flu->lib[0]='\0';
     if (flo->flags&AXSUSER) {
          while (ulfileq(2) && ctr < 5) {
               ctr++;
          }
          rmdir(userdir(1));
          sprintf(fname,"*.x%02X",channel[usrnum]);
          if (fnd1st(&flo->fb,spr("%s\\%s",copydir,fname),0)) {
               do {
                    unlink(spr("%s\\%s",copydir,flo->fb.name));
               } while (fndnxt(&flo->fb));
          }
     }
}

void
cfilmova(void)                     /* moving files                         */
{
     int loop;
     struct fllib *libptr;

     if (flo->movstt) {
          movecyc();
          btuinj(usrnum,CYCLE);
          return;
     }
     if (sameas(flo->miscfil,"x")) {
          flo->retstt=OPMENU;
          prfmsg(usrptr->substt=PRESENTR);
          return;
     }
     if (flo->miscfil[0] != '\0') {
          flo->movstt=1;
          stzcpy(movflib,curlib->libname,FLNAMESZ);
          stzcpy(movtlib,flo->misclib,FLNAMESZ);
          stzcpy(movfnam,flo->miscfil,FLFILENM);
          btuinj(usrnum,CYCLE);
          strcpy(flo->miscfil,"x");
          prfmsg((flo->flags&MOVFLAG) ? FILMOVAC : FILMOVA,movtlib,movfnam);
          return;
     }
     for (loop=0 ; loop < systags ; loop++) {
          if ((ftag=tagoff(loop))->status > TGEMPTY
             && usrnum == ftag->usrnum
             && !sameas(flo->misclib,ftag->libname)) {
               libptr=libfind(ftag->libname);
               if (libptr != NULL && !(libptr->flags&FLGCBD)) {
                    flo->movstt=1;
                    stzcpy(movflib,ftag->libname,FLNAMESZ);
                    stzcpy(movtlib,flo->misclib,FLNAMESZ);
                    stzcpy(movfnam,ftag->filname,FLFILENM);
                    prfmsg((flo->flags&MOVFLAG) ? FILMOVAC : FILMOVA,movtlib,
                       movfnam);
                    prf("%s\\%s\r",ftag->libname,ftag->filname);
               }
               else {
                    prf("\rCan't copy or move file from CD Library: %s\\%s\r",
                       ftag->libname,ftag->filname);
               }
               btuinj(usrnum,CYCLE);
               ftag->status=-ftag->status;
               return;
          }
     }
     flo->retstt=OPMENU;
     prfmsg(usrptr->substt=PRESENTR);
}

void
movecyc(void)                      /* move a file                          */
{
     static long pos;
     static struct key2 kwds;
     int retval=1,loop,byte;
     char *stg;
     struct fllib *libptr;
     struct fndblk fb;

     if (sameas(movflib,movtlib)) {
          flo->movstt=0;
     }
     switch (flo->movstt) {
     case 1:   /* redo data */
          setbtv(flfdat);
          if (acqbtv(NULL,compkey(movtlib,movfnam),COMPLF)) {
               prfmsg(BEEP);
               setmisc(movtlib);
               prfmsg(WARNMOVE);
               setmisc("");
               retval=0;
               break;
          }
          if (acqbtv(NULL,compkey(movflib,movfnam),COMPLF)) {
               if (!(flo->flags&MOVFLAG)) {
                    untagall(flf->libname,flf->filname);
               }
               stzcpy(flf->libname,movtlib,FLNAMESZ);
               if ((flo->flags&MOVFLAG)) {
                    invbtv(NULL,FLFILREC+strlen(flf->desc)+1);
               }
               else {
                    upvbtv(NULL,FLFILREC+strlen(flf->desc)+1);
               }
          }
          rstbtv();
          if (!(flo->flags&MOVFLAG) && (libptr=libfind(movflib)) != NULL) {
               if (notapped(flf->udate) && (libptr->appwait > 0)) {
                    libptr->appwait--;
               }
               chuldate(libptr,flf->udate,0);
               libptr->totbytes-=clfit(flf->siz,libptr->cluster);
               libptr->numfiles--;
               libptr->flags|=LIBONG;
          }
          if ((libptr=libfind(movtlib)) != NULL) {
               if (notapped(flf->udate)) {
                    libptr->appwait++;
               }
               libptr->totbytes+=clfit(flf->siz,libptr->cluster);
               libptr->numfiles++;
               chuldate(libptr,flf->udate,1);
               libptr->flags|=LIBCHN;
          }
          if (!(flo->flags&MOVFLAG)) {
               flo->movstt++;
          }
          else {
               setbtv(flkdat);
               if (!longsrch
                  && acqbtv(&kwds,rcompkey(movflib,movfnam),COMPFL_K)) {
                    pos=absbtv();
                    flo->movstt++; /* copy keyword records */
               }
               else {
                    flo->movstt=3; /* skip keywords, there aren't any */
               }
               rstbtv();
          }
          break;
     case 2:   /* redo keywords, if any */
          setbtv(flkdat);
          if (!(flo->flags&MOVFLAG)) { /* rename libraries */
               if (!longsrch
                  && acqbtv(&kwds,rcompkey(movflib,movfnam),COMPFL_K)) {
                    stzcpy(kwds.libkey,movtlib,FLNAMESZ);
                    updbtv(&kwds);
               }
               else {
                    flo->movstt++;
               }
          }
          else { /* copy them */
               stzcpy(kwds.libkey,movtlib,FLNAMESZ);
               insbtv(&kwds);
               if (!aabbtv(&kwds,pos,COMPFL_K) || !aqnbtv(&kwds)
                  || !sameas(kwds.libkey,movflib)) {
                    flo->movstt++;
               }
               else {
                    pos=absbtv();
               }
          }
          rstbtv();
          break;
     case 3:   /* open file for copy */
          if ((libptr=libfind(movflib)) != NULL) {
               if (libptr->flags&FLGCBD) {
                    retval=0;
                    prfmsg(MAWARN);
                    break;
               }
               stg=spr("%s\\%s",strlen(libptr->path) ? fixpath(libptr->path)
                  : libptr->libname,movfnam);
               if ((libptr=libfind(movtlib)) != NULL) {
                    if (libptr->flags&FLGCBD) {
                         retval=0;
                         prfmsg(MAWARN2);
                         break;
                    }
               }
               movs=fopen(stg,FOPRB);
               if (movs != NULL && libptr != NULL) {
                    stg=spr("%s\\%s",libpath(libptr),movfnam);
                    if (fnd1st(&fb,stg,0)) {
                         fclose(movs);
                         movs=NULL;
                         retval=0;
                         break;
                    }
                    movd=fopen(stg,FOPWB);
                    if (movd != NULL) {
                         flo->movstt++;
                    }
                    else {
                         fclose(movs);
                         movs=NULL;
                         retval=0;
                    }
               }
               else {
                    retval=0;
               }
          }
          else {
               retval=0;
          }
          break;
     case 4:   /* copy file */
          for (loop=0 ; loop < 1024 ; loop++) {
               byte=fgetc(movs);
               if (!feof(movs) && !ferror(movs) && !ferror(movd)) {
                    fputc(byte,movd);
               }
               else {
                    fclose(movs);
                    fclose(movd);
                    movs=movd=NULL;
                    flo->movstt++;
                    break;
               }
          }
          break;
     case 5:   /* delete old file */
          if ((libptr=libfind(movflib)) != NULL) {
               stg=spr("%s\\%s",libpath(libptr),movfnam);
               if ((libptr=libfind(movtlib)) != NULL) {
                    touch(stg,spr("%s\\%s",libpath(libptr),movfnam));
               }
               if (!(flo->flags&MOVFLAG)) {
                    unlink(stg);
               }
          }
          retval=0;
          break;
     default:
          retval=0;
     }
     if (!retval) {
          flo->movstt=0;
     }
}

void
cdellib(void)                      /* cycle Library deletion               */
{
     int cont=1,loop;

     switch (flo->miscflag) {
     case 0:
          setbtv(flfdat);
          if (agtbtv(NULL,compkey(flo->misclib,""),COMPLF)
               && sameas(flo->misclib,flf->libname)) {
                    stzcpy(flo->miscfil,flf->filname,FLFILENM);
                    delbtv();
                    if (!longsrch) {
                         flo->miscflag=1;
                    }
          }
          else {
               flo->miscflag=2;
          }
          rstbtv();
          break;
     case 1:
          setbtv(flkdat);
          if (acqbtv(NULL,rcompkey(flo->misclib,flo->miscfil),COMPFL_K)) {
               delbtv();
          }
          else {
               flo->miscflag=0;
          }
          rstbtv();
          break;
     case 2:
          setbtv(flldat);
          if (acqbtv(NULL,flo->misclib,0)) {
               delbtv();
               shocst(spr("LIBRARY DELETED: %s",flo->misclib),
                  "The \"%s\" Library was deleted",flo->misclib);
          }
          else {
               cont=0;
          }
          rstbtv();
          break;
     default:
          cont=0;
     }
     if (cont) {
          spinner();
          btuinj(usrnum,CYCLE);
     }
     else {
          unprop();
          prfmsg(DELETED);
          flo->retstt=OPMENU;
          prfmsg(usrptr->substt=PRESENTR);
          for (loop=0 ; loop < nterms ; loop++) {
               if (user[loop].class >= SUPLON) {
                    ((struct fluson *)ptrblok(flomem,loop))->nlibaxs=-1;
               }
          }
     }
     outprf(usrnum);
}

void
crencyc(void)                      /* cycle: renaming keywords             */
{
     if (!longsrch) {
          setbtv(flkdat);
          if (acqbtv(NULL,rcompkey(curlib->libname,flo->miscfil),COMPFL_K)) {
               stzcpy(kyd->filname,flo->destpath,FLFILENM);
               updbtv(NULL);
               spinner();
               btuinj(usrnum,CYCLE);
               return;
          }
     }
     unprop();
     prf("\r");
     usrptr->substt=DELMENU;
     setmisc(spr("%d",nlibtagd()));
     prfmsg(DELMENU);
     setmisc("");
     outprf(usrnum);
}

int
dupefile(void)                     /* determine if file is a duplicate     */
{
     int retval=0;

     if (curlib->flags&FLGDOS) {
          return(0);
     }
     setbtv(flfdat);
     if (unifile && agebtv(NULL,rcompkey("",flo->miscfil),COMPFL)
                 && sameas(flo->miscfil,flf->filname)) {
          rstbtv();
          retval=1;
     }
     else if (acqbtv(NULL,compkey(curlib->libname,flo->miscfil),COMPLF)) {
          flo->fsrc=fopen(spr("%s\\%s",libpath(curlib),flo->miscfil),FOPRB);
          if (flo->fsrc != NULL) {
               fclose(flo->fsrc);
               flo->fsrc=NULL;
               retval=1;
          }
     }
     rstbtv();
     return(retval);
}

void
autogone(void)
{
     flo->index=alwait;
     if (alwait > 0) {
          prf(getasc(AUTOGONE),alwait);
          powprf();
     }
     else {
          byenow(BANGFAST);
     }
     usrptr->substt=AUTOGONE;
     prf("");
     flo->flags&=~OFFUPLD;
}

void
cautolog(void)                     /* cycle: logging in uploaded files     */
{
     int edtstt;

     if (ulfileq(0) && !sameas(flo->miscfil,flmisc)) {
          stzcpy(flo->miscfil,flmisc,FLFILENM);
     }
     else {
          flo->miscfil[0]='\0';
          if (ulfileq(1)) {
               btuinj(usrnum,CYCLE);
          }
          else {
               prfmsg(DONE);
               if (flo->flags&OFFUPLD) {
                    autogone();
               }
               else if (!haskey(flsysop) || !(flo->flags&RETUOPM)) {
                    prfmsg(usrptr->substt=ENTULFIL);
               }
               else {
                    retmenu(1);
                    opmenu();
                    prfmsg(OPMENU);
               }
               rstrxf();
               outprf(usrnum);
          }
          return;
     }
     if (flo->dodesc == ASKDESC && !(curlib->flags&FLGDOS) && !dupefile()) {
          flo->miscfil[0]='\0';
          prfmsg(usrptr->substt=DODESC);
          outprf(usrnum);
     }
     else {
          unlink(userdir(2));
          unlink(userdir(3));
          prfmsg(AUTOLOG,flo->miscfil);
          switch (edtstt=editgo("")) {
          case 0:
               prfmsg(DONE);
               if (flo->flags&OFFUPLD) {
                    autogone();
               }
               else if (!haskey(flsysop) || !(flo->flags&RETUOPM)) {
                    prfmsg(usrptr->substt=ENTULFIL);
               }
               else {
                    retmenu(1);
                    opmenu();
                    prfmsg(OPMENU);
               }
               rstrxf();
               break;
          case -1:
               stzcpy(flo->miscfil,flf->filname,FLFILENM);
               if (haslibkey(curlib,curlib->overw) || (sameas(flf->ulby,
                  usaptr->userid) && (notapped(flf->udate) || haslibkey(curlib,
                  curlib->autoap)))) {
                    prfmsg(RENAMO);
               }
               else {
                    prfmsg(RENAME);
               }
               usrptr->substt=RENAME;
               break;
          default:
               stzcpy(flo->miscfil,flf->filname,FLFILENM);
               if (flo->flags&REUPLOD) {
                    if (edtstt == 2) {            /* copy reuploaded file */
                         flo->retstt=ENTULFIL;
                         prfmsg(usrptr->substt=COPYING);
                         outprf(usrnum);
                         btuinj(usrnum,CYCLE);
                         return;
                    }
                    prfmsg(usrptr->substt=ENTULFIL);
                    outprf(usrnum);
                    return;
               }
               unprop();
               outprf(usrnum);
               if (edtstt == 2) {
                    flo->retstt=DIZZYING;
                    prfmsg(usrptr->substt=COPYING);
                    btuinj(usrnum,CYCLE);
               }
               else {
                    if (strlen(flo->destpath) > 4
                       && sameas(".ZIP",&flo->destpath[strlen(flo->destpath)-4])
                       && openzip()) {
                         if (flo->retstt == SEARCHEM) {
                              flo->retstt=0;
                         }
                         prfmsg(usrptr->substt=DIZZYING);
                         btuinj(usrnum,CYCLE);
                    }
                    else {
                         flo->retstt=ENTULFIL;
                         if (longsrch || !kwdout()) {
                              entrdesc();
                         }
                    }
               }
          }
          prf("");
          outprf(usrnum);
     }
}

void
cunapp(void)                       /* cycle: unapproving files             */
{
     int cont=0;
     struct fllib *libptr;

     setbtv(flfdat);
     if (getaufil(1,1) && acqbtv(NULL,&flo->key1,COMPLF)) {
          libptr=libfind(flf->libname);
          chuldate(libptr,flf->udate,0);
          stzcpy(flf->udate,NOTAPPED,DATESZ);
          flf->utime=now();
          upvbtv(NULL,FLFILREC+strlen(flf->desc)+1);
          prfmsg(UNAPPED);
          untagall(flf->libname,flf->filname);
          if (libptr != NULL) {
               libptr->appwait++;
               libptr->flags|=LIBONG;
          }
          if (getaufil(0,1)) {
               cont=1;
          }
     }
     if (cont) {
          btuinj(usrnum,CYCLE);
     }
     else {
          prfmsg(UNAPDONE);
          flo->retstt=OPMENU;
          prfmsg(usrptr->substt=PRESENTR);
     }
     outprf(usrnum);
}

void
capp(void)                         /* cycle: approving files               */
{
     struct fllib *libptr;
     int cont=0;

     setbtv(flfdat);
     if ((flo->autol && agtbtv(NULL,&flo->u.key0,COMPLUF)
        && notapped(flf->udate) && sameas(flf->libname,flo->u.key0.libname))
        || (!flo->autol && getaufil(1,0) && acqbtv(NULL,&flo->key1,COMPLF))) {
          libptr=libfind(flf->libname);
          if (flo->autol) {
               stzcpy(flo->u.key0.filname,flf->filname,FLFILENM);
          }
          if (flo->autol != 2) {
               stzcpy(flf->udate,dat2srt(ncdate(today())),DATESZ);
               chuldate(libptr,flf->udate,1);
               flf->utime=now();
               upvbtv(NULL,FLFILREC+strlen(flf->desc)+1);
               prfmsg(APPED);
          }
          else {
               delbtv();
               untagall(flf->libname,flf->filname);
               prfmsg(DELED);
          }
          if (libptr != NULL) {
               if (libptr->numfiles > 0 && flo->autol == 2) {
                    libptr->numfiles--;
                    libptr->totbytes-=clfit(flf->siz,libptr->cluster);
                    libptr->flags|=LIBONG;
               }
               if (libptr->appwait > 0) {
                    libptr->appwait--;
                    libptr->flags|=LIBONG;
               }
          }
          if ((!flo->autol && getaufil(0,0)) || flo->autol) {
               cont=1;
          }
     }
     if (cont) {
          btuinj(usrnum,CYCLE);
     }
     else {
          prfmsg(APDONE);
          flo->retstt=(flo->autol == 2 ? DELMENU : APPMENU);
          prfmsg(usrptr->substt=PRESENTR);
     }
     outprf(usrnum);
}

void
cbigcpy(void)                      /* cycle: copying files                 */
{
     int loop,byte,flag=0;

     if (flo->fsrc == NULL) {
          flo->fsrc=fopen(spr("%s%s",flo->keylist,flo->fb.name),FOPRB);
          flo->fdst=fopen(spr("%s\\%s",userdir(1),flo->fb.name),FOPWB);
          if (flo->fsrc == NULL || flo->fdst == NULL) {
               flag=1;
               prfmsg(BEEP);
               prf("[0;1;35m%s - File Error!\r\r",flo->fb.name);
               if (flo->fsrc != NULL) {
                    fclose(flo->fsrc);
                    flo->fsrc=NULL;
               }
               if (flo->fdst != NULL) {
                    fclose(flo->fdst);
                    flo->fdst=NULL;
               }
          }
          else {
               prfmsg(NOWCOPY,flo->fb.name,fzer(flo->fb.size/1024L));
               flo->tot=0L;
          }
     }
     if (!flag) {
          for (loop=0 ; loop < 1024 ; loop++) {
               byte=fgetc(flo->fsrc);
               if (!feof(flo->fsrc) && !ferror(flo->fsrc) && !ferror(flo->fdst)) {
                    fputc(byte,flo->fdst);
               }
               else {
                    loop=2000;
               }
          }
     }
     if (flag || loop >= 2000) {
          if (flo->fsrc != NULL) {
               fclose(flo->fsrc);
               flo->fsrc=NULL;
          }
          if (flo->fdst != NULL) {
               fclose(flo->fdst);
               flo->fdst=NULL;
          }
          if (!flag) {
               touch(spr("%s%s",flo->keylist,flo->fb.name),
                  spr("%s\\%s",userdir(1),flo->fb.name));
          }
          while ((flag=fndnxt(&flo->fb)) != 0 && (flo->fb.attr&FAMDIR)) {
          }
          if (!flag) {
               if (ulfileq(0)) {
                    usrptr->substt=AUTOLOG;
                    flo->dodesc=ASKDESC;
                    btuinj(usrnum,CYCLE);
                    prf("%c%c%c%c100%%\r",8,8,8,8);
                    outprf(usrnum);
                    unbreak();
                    return;
               }
               flo->retstt=OPMENU;
               prfmsg(usrptr->substt=PRESENTR);
               outprf(usrnum);
               rstrxf();
               return;
          }
          flo->tot=flo->fb.size;
     }
     else {
          flo->tot+=1024;
     }
     if (flo->fb.size > 0L) {
          prf("%c%c%c%c%3s%%",8,8,8,8,l2as(100L*flo->tot/flo->fb.size));
     }
     else {
          prf("%c%c%c%c100%%",8,8,8,8);
     }
     btuinj(usrnum,CYCLE);
     prf("");
     outprf(usrnum);
}

void
csearch(void)                      /* cycle: maintenance routines          */
{
     int cont=0;

     switch (abs(flo->miscflag)) {
     case 1:
     case 3:
          cont=srch1();
          break;
     case 2:
     case 4:
          cont=srch2();
     }
     if (cont) {
          btuinj(usrnum,CYCLE);
          return;
     }
     flo->retstt=OPMENU;
     prfmsg(usrptr->substt=PRESENTR);
     outprf(usrnum);
     rstrxf();
}

void
cfildel(void)                      /* cycle: file deletion                 */
{
     int loop;
     struct fllib *libptr;

     switch (usrptr->substt) {
     case FILDELA:
          for (loop=0 ; loop < systags ; loop++) {
               if ((ftag=tagoff(loop))->status > TGEMPTY
                 && usrnum == ftag->usrnum
                 && (libptr=libfind(ftag->libname)) != NULL
                 && isflop(libptr)) {
                    prfmsg(usrptr->substt);
                    setbtv(flfdat);
                    if (acqbtv(NULL,compkey(ftag->libname,ftag->filname),
                       COMPLF)) {
                         delbtv();
                         if (flo->flags&DELTHEM) {
                              unlink(spr("%s\\%s",libpath(libptr),
                                 ftag->filname));
                         }
                    }
                    prf("%s\\%s\r",ftag->libname,ftag->filname);
                    rstbtv();
                    if (notapped(flf->udate)) {
                         libptr->appwait--;
                    }
                    chuldate(libptr,flf->udate,0);
                    libptr->numfiles--;
                    libptr->totbytes-=clfit(flf->siz,libptr->cluster);
                    libptr->flags|=LIBONG;
                    stzcpy(flo->miscfil,ftag->filname,FLFILENM);
                    stzcpy(flo->misclib,ftag->libname,FLNAMESZ);
                    if (!longsrch) {
                         prfmsg(usrptr->substt=FILDELB);
                         flo->prop=0;
                    }
                    btuinj(usrnum,CYCLE);
                    outprf(usrnum);
                    untagall(flo->misclib,flo->miscfil);
                    return;
               }
          }
          flo->retstt=OPMENU;
          prfmsg(DONE);
          prfmsg(usrptr->substt=PRESENTR);
          break;
     case FILDELB:
          setbtv(flkdat);
          if (acqbtv(NULL,rcompkey(flo->misclib,flo->miscfil),COMPFL_K)) {
               delbtv();
               spinner();
          }
          else {
               unprop();
               usrptr->substt=FILDELA;
          }
          btuinj(usrnum,CYCLE);
          rstbtv();
     }
     outprf(usrnum);
     prf("");
}

void
cflist(void)                       /* cycle: file list                     */
{
     int cont,flag;

     cont=(!(flo->flags&STOPLST) && srcincx());
     if (cont) {
          if (srcnext()) {
               flag=srcgood();
               if (flag == 1) {
                    srcukey();
                    srcdrec(0);
                    if (!srcincx() && flo->keymeth != 9 && !srcnext()) {
                         if (!(flo->flags&USRANSI)) {
                              unprop();
                         }
                         flo->prop=0;
                         flo->atend|=((flo->flags&REVSRCH)
                            ? LSTFORE : LSTBACK);
                         cont=0;
                    }
               }
               else if (flag == -1) {
                    srcukey();
                    if (flo->prop == 0 && (flo->flags&USRANSI)) {
                         prfmsg(SRCHIN);
                    }
                    spinner();
               }
               else {
                    if (!(flo->flags&USRANSI)) {
                         unprop();
                    }
                    flo->prop=0;
                    flo->atend|=((flo->flags&REVSRCH) ? LSTFORE : LSTBACK);
                    cont=0;
               }
          }
          else {
               if (!(flo->flags&USRANSI)) {
                    unprop();
               }
               flo->prop=0;
               flo->atend|=((flo->flags&REVSRCH) ? LSTFORE : LSTBACK);
               cont=0;
          }
     }
     if (!cont && !(flo->flags&STOPLST)) {
          flo->flags|=STOPLST;
          srcpaus(0);
     }
     prf("");
     outprf(usrnum);
     btuinj(usrnum,CYCLE);
}

void
entrdesc(void)                     /* enter a description if needed        */
{
     if (flo->dodesc == DOADESC) {
          flo->retstt=AUTOLOG;
          usrptr->substt=PRESENTR;
          flo->dodesc=ASKDESC;
          bgnfiled(0);
     }
     else {
          if (flo->dodesc != NEVRASK) {
               flo->dodesc=ASKDESC;
          }
          usrptr->substt=AUTOLOG;
          btuinj(usrnum,CYCLE);
     }
}

void
ccopying(void)                     /* cycle: copying cycle                 */
{
     int loop,byte;
     char *stg;
     struct fllib *libptr;

     if ((flo->fsrc == NULL) || (flo->fdst == NULL)) {
          return;
     }
     spinner();
     for (loop=0 ; loop < 1024 ; loop++) {
          byte=fgetc(flo->fsrc);
          if (!feof(flo->fsrc)
            && !ferror(flo->fsrc)
            && !ferror(flo->fdst)) {
               fputc(byte,flo->fdst);
          }
          else {
               loop=2000;
          }
     }
     if (loop >= 2000) {
          unprop();
          fclose(flo->fsrc);
          fclose(flo->fdst);
          touch(flo->srcpath,flo->destpath);
          unlink(flo->srcpath);
          flo->fsrc=flo->fdst=NULL;
          libptr=libfind(flo->u.key1.libname);
          if ((libptr == NULL || !(libptr->flags&FLGDOS))
             && flo->retstt == DIZZYING) {
               stg=flo->destpath;
               if ((strlen(stg) > 4) && sameas(".ZIP",&stg[strlen(stg)-4])
                  && openzip()) {
                    prfmsg(usrptr->substt=DIZZYING);
                    btuinj(usrnum,CYCLE);
               }
               else {
                    entrdesc();
               }
          }
          else {
               usrptr->substt=AUTOLOG;
               btuinj(usrnum,CYCLE);
          }
     }
     else {
          btuinj(usrnum,CYCLE);
     }
     outprf(usrnum);
}

void
cdizzy(void)                       /* cycle: manipulate zip/diz file       */
{
     spinner();
     if (dizread()) {
          btuinj(usrnum,CYCLE);
     }
     else {
          unprop();
          usrptr->substt=PRESENTR;
          gather();
          if (flo->retstt == SEARCHEM) {
               usrptr->substt=SEARCHEM;
               dofiler(descedit);
               btuinj(usrnum,CYCLE);
               outprf(usrnum);
               return;
          }
          setbtv(flfdat);
          setmem(flf,sizeof(struct flfile),0);
          if (acqbtv(NULL,&flo->key1,COMPLF)) {
               stzcpy(flf->desc,descedit,DESCSIZ);
               upvbtv(NULL,FLFILREC+strlen(flf->desc)+1);
               if (!longsrch && kwdout()) {
                    flo->retstt=DIZZYING;
                    outprf(usrnum);
                    return;
               }
               setmem(descedit,DESCSIZ,0);
               setmem(flf,FLFILREC+DESCSIZ,0);
          }
          entrdesc();
     }
     outprf(usrnum);
}

void
cliblst(void)                      /* cycle: list libs                     */
{
     int cont=1,loop=0;

     while (loop < 3 && cont) {
          curlib=nxtlib();
          if (curlib != NULL) {
               if (flo->retstt != SELLIB2 || isflop(curlib)) {
                    prfmsg(LIBLSTE);
                    loop++;
               }
          }
          else {
               if (flo->retstt != MMENU) {
                    usrptr->substt=flo->retstt;
                    prfmsg(SELLIB);
               }
               else {
                    retmenu(0);
                    flo->flags&=~LONGDSC;
                    usrptr->substt=MMENU;
                    injacr();
               }
               cont=0;
          }
     }
     outprf(usrnum);
     if (cont) {
          btuinj(usrnum,CYCLE);
     }

}

void
ckeyword(void)                     /* cycle: logging in kwds post-upload   */
{
     if (keywordy()) {
          btuinj(usrnum,CYCLE);
     }
     else {
          unprop();
          setmem(descedit,DESCSIZ,0);
          setmem(flf,FLFILREC+DESCSIZ,0);
          entrdesc();
     }
     prf("");
     outprf(usrnum);
}

void
cwldsrch(void)                     /* tagging wildcarded files             */
{
     int gd,loop;
     char filname[9],*path;
     struct fllib *libptr=NULL;

     spinner();
     if (flo->u.key4.libname[0] != '\0') {
          libptr=libfind(flo->u.key4.libname);
     }
     if (libptr != NULL && (libptr->flags&FLGDOS)) {
          if (flo->u.key4.filname[0] == '\0') {
               gd=fnd1st(&flo->fb,spr("%s\\%s",libpath(libptr),flo->miscfil),
                  0);
          }
          else {
               gd=fndnxt(&flo->fb);
          }
          if (gd) {
               stzcpy(flo->u.key4.filname,flo->fb.name,FLFILENM);
               gd=2;
          }
     }
     else {
          gd=srcnext();
          if (gd) {
               gd=srcgood();
               srcukey();
               if ((libptr->flags&FLGCBD) || !dlfroml(libptr)) {
                    gd=-1;
               }
          }
     }
     if (flo->wtnum < 0) {
          flo->wtnum=(-flo->wtnum)-1;
          gd=0;
     }
     switch (gd) {
     case 2:
          if (flo->fsrc != NULL) {
               fprintf(flo->fsrc,"%s %s\n",flo->u.key4.libname,
                  flo->u.key4.filname);
               unprop();
               prfmsg(WTAGLN,flo->u.key4.libname,flo->u.key4.filname);
               flo->wtnum++;
               flo->wtsiz+=flo->fb.size;
               btuinj(usrnum,CYCLE);
               break;
          }
     case 1:
          if (flo->fsrc != NULL) {
               fprintf(flo->fsrc,"%s %s\n",flf->libname,flf->filname);
               unprop();
               prfmsg(WTAGLN,flf->libname,flf->filname);
               flo->wtnum++;
               flo->wtsiz+=flf->siz;
               btuinj(usrnum,CYCLE);
               break;
          }
     case 0:
          unprop();
          if (flo->fsrc != NULL) {
               fclose(flo->fsrc);
               flo->fsrc=NULL;
          }
          if (flo->wtnum < 1) {
               prfmsg(ENDWTAGN);
               prfmsg(usrptr->substt=ENTDLFIL);
               unlink(spr("%s\\TEMPTAGS.%d",copydir,usrnum));
               break;
          }
          unlink(spr("%s\\TAGFILE.%d",copydir,usrnum));
          if (!rename(spr("%s\\TEMPTAGS.%d",copydir,usrnum),
             spr("%s\\TAGFILE.%d",copydir,usrnum))) {
               prfmsg(ENDWTAG,flo->wtnum,l2as(flo->wtsiz));
          }
          flo->retstt=ENTDLFIL;
          strcpy(filname,"*");
          flo->retstt=WLDSRCH;
          flo->flags&=~OFTGMAN;
          usrptr->substt=TAGMAN;
          if (!submit(curlib->libname,filname,"",DOWNLOD,0)) {
               prfmsg(ENDWTAGE);
               prfmsg(usrptr->substt=ENTDLFIL);
               unlink(spr("%s\\TAGFILE.%d",copydir,usrnum));
          }
          else {
               prf("");
               for (loop=0 ; loop < systags ; loop++) {
                    if (ftag == tagoff(loop)) {
                         break; /* get tag# submit() used */
                    }
               }
               if (loop < systags) {
                    unlink(path=spr("%s\\TAGS%d.FIL",copydir,loop));
                    rename(spr("%s\\TAGFILE.%d",copydir,usrnum),path);
               }
          }
          break;
     default:
          btuinj(usrnum,CYCLE);
          break;
     }
     outprf(usrnum);
     prf("");
}

void
cwldsys(void)                      /* selecting wildcarded files           */
{
     int gd;

     spinner();
     if (flo->u.key4.libname[0] != '\0') {
          if (libfind(flo->u.key4.libname) == NULL) {
               return;
          }
     }
     gd=srcnext();
     if (gd) {
          gd=srcgood();
          srcukey();
     }
     if (flo->wtnum < 0) {
          flo->wtnum=(-flo->wtnum)-1;
          gd=0;
     }
     switch (gd) {
     case 2:
          if (flo->fsrc != NULL) {
               fprintf(flo->fsrc,"%s %s\n",flo->u.key4.libname,
                  flo->u.key4.filname);
               unprop();
               prfmsg(WTAGLN,flo->u.key4.libname,flo->u.key4.filname);
               flo->wtnum++;
               btuinj(usrnum,CYCLE);
               break;
          }
     case 1:
          if (flo->fsrc != NULL) {
               fprintf(flo->fsrc,"%s %s\n",flf->libname,flf->filname);
               unprop();
               prfmsg(WTAGLN,flf->libname,flf->filname);
               flo->wtnum++;
               btuinj(usrnum,CYCLE);
               break;
          }
     case 0:
          unprop();
          if (flo->fsrc != NULL) {
               fclose(flo->fsrc);
               flo->fsrc=NULL;
          }
          flo->fsrc=fopen(spr("%s\\TEMPTAGS.%d",copydir,usrnum),FOPRB);
          if (flo->fsrc == NULL || flo->wtnum < 1) {
               prfmsg(ENDWTAGN);
               prfmsg(usrptr->substt=abs(flo->retstt));
               unlink(spr("%s\\TEMPTAGS.%d",copydir,usrnum));
               break;
          }
          strcpy(flo->miscfil,"x"); /* necessary for MOVMENU */
          prfmsg(usrptr->substt=RESOLVE);
          btuinj(usrnum,CYCLE);
          break;
     default:
          btuinj(usrnum,CYCLE);
     }
     outprf(usrnum);
     prf("");
}

void
cresolve(void)
{
     if (flo->retstt == MOVMENU) {
          cfilmova();
          if (usrptr->substt == PRESENTR) {
               clrprf();
               usrptr->substt=RESOLVE;
               flo->retstt=MOVMENU;
          }
          else {
               prf("");
               outprf(usrnum);
               return;
          }
     }
     if (readline(flo->fsrc)) {
          inplen=strlen(input);
          parsin();
          if (margc >= 2 && (curlib=libfind(margv[0])) != NULL) {
               if (strchr(margv[1],'*') == NULL
                  && strchr(margv[1],'?') == NULL) {
                    if (flo->retstt == MOVMENU) {
                         stzcpy(flo->miscfil,margv[1],FLFILENM);
                         btuinj(usrnum,CYCLE);
                         return;
                    }
                    ienuadnm(margv[1]);
                    prf("");
                    outprf(usrnum);
                    if (usrptr->substt == flo->retstt) {
                         usrptr->substt=RESOLVE;
                    }
                    switch (usrptr->substt) {
                    case RESOLVE:
                         btuinj(usrnum,CYCLE);
                         return;
                    case INDDELK:
                         flo->flags|=WLDRSLV;
                         return;
                    }
               }
          }
     }
     fclose(flo->fsrc);
     flo->fsrc=NULL;
     rstrxf();
     usrptr->substt=abs(flo->retstt);
     promptin();
}

void
clstcyc(void)                      /* cycle file list building             */
{
     int end=0,loop;
     char *pro;

     if (srcnext()) {
          switch (srcgood()) {
          case 0:
               end=1;
               break;
          case -1:
               srcukey();
               break;
          case 1:
               srcukey();
               stzcpy(descedit,flf->desc,DESCSIZ);
               darsdesc(NDESCLN,'\r');
               setmisc(dargv[0]);
               prfmsg((flo->flags&LISTALL) ? LSTLINA : LSTLIN);
               for (loop=1 ; loop < NDESCLN ; loop++) {
                    if (dargv[loop][0] != '\0') {
                         setmisc(dargv[loop]);
                         prfmsg((flo->flags&LISTALL) ? LSTLINC : LSTLINB);
                    }
               }
               if (!(flo->flags&USRANSI) || stplist) {
                    stpans(prfbuf);
               }
               optiprf();
               strcrep(prfbuf,13,10);
               fprintf(flo->fsrc,"%s",prfbuf);
               clrprf();
          }
     }
     else {
          end=1;
     }
     if (end) {
          unprop();
          fclose(flo->fsrc);
          flo->fsrc=NULL;
          prfmsg(APDONE);
          if (ftgnew()) {
               flo->retstt=usrptr->substt;
               usrptr->substt=TAGMAN;
               ftgptr->flags=FTGABL;
               ftgptr->tshndl=tshlist;
               sprintf(ftgptr->tagspc,"%s.x%02X",((flo->flags&LISTALL)
                  ? "FILES!" : curlib->libname),channel[usrnum]);
               pro=protocol();
               if (flo->savprot[0] != '\0') {
                    pro=spr("%s",flo->savprot);
                    flo->savprot[0]='\0';
               }
               ftgsbm(strlen(pro) ? pro : "?");
               if (usrptr->state == flstt) {
                    injacr();
               }
          }
          else {
               flo->retstt=MMENU;
               prfmsg(usrptr->substt=PRESENTR);
          }
     }
     else {
          btuinj(usrnum,CYCLE);
     }
}

void
lssta(void)                        /* user status routine                  */
{
     if (status == CYCLE && usrptr->state == flstt) {
          if (btuoba(usrnum) <= (outbsz-3072)) {
               if (usrptr->substt == FILELST0 || usrptr->substt == ENTRETT) {
                    btucli(usrnum);
               }
               btuinj(usrnum,CYCLE);
          }
          else {
               setmbk(flmsg);
               fluoff(usrnum);
               curlib=setuaxs();
               setftu();
               clrprf();
               switch (usrptr->substt) {
               case INDDELK:
                    setbtv(flkdat);
                    if (!longsrch && acqbtv(NULL,rcompkey(curlib->libname,
                       flo->miscfil),COMPFL_K)) {
                         delbtv();
                         spinner();
                         btuinj(usrnum,CYCLE);
                    }
                    else {
                         unprop();
                         if (flo->flags&WLDRSLV) {
                              usrptr->substt=RESOLVE;
                              btuinj(usrnum,CYCLE);
                         }
                         else {
                              prfmsg(usrptr->substt=PRESENTR);
                         }
                    }
                    rstbtv();
                    prf("");
                    outprf(usrnum);
                    break;
               case -1:
               case -2:
                    if (ulfileq(1)) {
                         spinner();
                         btuinj(usrnum,CYCLE);
                    }
                    else {
                         unprop();
                         outprf(usrnum);
                         prf("");
                         usrptr->substt=-2;
                         btuinj(usrnum,CRSTG);
                    }
                    break;
               case CYCIDX:
                    if (ccycidx()) {
                         spinner();
                         btuinj(usrnum,CYCLE);
                    }
                    else {
                         unprop();
                         if (flo->retstt != FILELST0) {
                              setmisc(flo->miscfil);
                              prfmsg(usrptr->substt=flo->retstt);
                              setmisc("");
                              btuinj(usrnum,CYCLE);
                         }
                         else {
                              gosearch();
                         }
                    }
                    prf("");
                    outprf(usrnum);
                    prf("");
                    break;
               case ENTRETT:
                    cycinp();
               case VIEWASC:
                    if (usrptr->state == flstt) {
                         btuinj(usrnum,CYCLE);
                    }
                    break;
               case TAGSTAT:
                    cdsptags();
                    break;
               case LSTCYC:
                    spinner();
                    clstcyc();
                    prf("");
                    outprf(usrnum);
                    break;
               case WLDSRCH:
                    cwldsrch();
                    break;
               case WLDSYS:
                    cwldsys();
                    break;
               case RESOLVE:
                    cresolve();
                    break;
               case FILHELP:
               case POPWIN1:
               case POPWIN2:
               case POPWIN3:
               case POPWIN4:
               case POPWIN5:
               case POPWIN6:
               case POPWIN7:
                    cycinp();
                    btuinj(usrnum,CYCLE);
                    break;
               case SEARCHEM:
                    if (kwaut) {
                         btuinj(usrnum,CYCLE);
                    }
                    else {
                         csearch();
                    }
                    break;
               case FILDELA:
               case FILDELB:
                    cfildel();
                    break;
               case FILELST0:
                    cycinp();
                    if (usrptr->state == flstt) {
                         if (usrptr->substt != FILELST0) {
                              btuinj(usrnum,CYCLE);
                              break;
                         }
                    }
                    else {
                         break;
                    }
               case FILELST2:
               case FILELST1:
                    cflist();
                    break;
               case LIBLST:
                    cliblst();
                    break;
               case COPYING:
                    ccopying();
                    break;
               case KEYWORDY:
                    ckeyword();
                    break;
               case DIZZYING:
                    cdizzy();
                    break;
               case FILMOVA:
                    cfilmova();
                    prf("");
                    outprf(usrnum);
                    if (usrptr->substt != FILMOVA) {
                         rstrxf();
                    }
                    break;
               case BIGCPY:
                    cbigcpy();
                    break;
               case RENCYC:
                    crencyc();
                    break;
               case DELLIB:
                    cdellib();
                    break;
               case AUTOLOG:
                    cautolog();
                    break;
               case UNAPPING:
                    cunapp();
                    break;
               case APPING:
                    capp();
                    break;
               }
               clrprf();
          }
          return;
     }
     else if (status == OUTMT && usrptr->state == flstt) {
          statstrt();
          return;
     }
     dfsthn();
}

void
flagit(                            /* decode binary flag bits              */
int fldspec,
long flag)
{
     char yn[4];

     fsdfxt(fldspec,yn,4);
     libedt->lib.flags=(sameas(yn,"NO") ? libedt->lib.flags&~flag : libedt->lib.flags|flag);
}

char *
dprfm(                             /* strips first flmisc in msgno         */
int msgno)
{
     char *msg,*cr;

     msg=rawmsg(msgno);
     if (flmisc[0] == '\0') {
          if (strsrep(msg,"FL_MISC","")) {
               if ((cr=strchr(msg,'')) != NULL) {
                    cr-=3;
                    strcpy(cr,&cr[4]);
               }
          }
     }
     return(xlttxv(msg,2048));
}

void
srcdrec(                           /* display line for searching           */
int redisplay)
{
     int loop,idx;
     struct key0 *key;

     if (!redisplay) {
          idx=srcincx();
          flo->tagk='A'-1+idx;
     }
     else {
          flo->tagk++;
     }
     if (!redisplay && idx == ((flo->flags&REVSRCH) ? NLISTER : 1)) {
          for (loop=0 ; loop < NLISTER ; loop++) {
               flo->tdline[loop]=0;
          }
     }
     key=&flo->tags[flo->tagk-'A'];
     if (flo->keymeth != 9) {
          stzcpy(key->filname,flf->filname,FLFILENM);
          stzcpy(key->libname,flf->libname,FLNAMESZ);
          stzcpy(key->udate,flf->udate,DATESZ);
          stzcpy(descedit,flf->desc,DESCSIZ);
          darsdesc(NDESCLN,'\r');
          setmisc(dargv[0]);
          while ( dargc > 0 && dargv[dargc-1][0] == '\0') {
               dargc--;
          }
          unprop();
     }
     loop=flo->tagk-'A';
     prf("[%df[K",flo->tagk-'A'+4);
     switch (flo->keymeth) {
     case 0:
          prf(dprfm(LISTLN0));
          break;
     case 1:
     case 6:
          prf(dprfm(LISTLN1));
          break;
     case 2:
          prf(dprfm(LISTLN2));
          break;
     case 3:
          prf(dprfm(LISTLN3));
          break;
     case 4:
     case 7:
          prf(dprfm(LISTLN4));
          break;
     case 5:
          prf(dprfm(LISTLN5));
          break;
     case 8:
          prf(dprfm(LISTLN6));
          break;
     case 9:
          if (redisplay) {
               stzcpy(flo->u.key6.filname,flo->tags[loop].filname,FLFILENM);
          }
          else {
               stzcpy(key->filname,flo->fb.name,FLFILENM);
               stzcpy(key->libname,curlib->libname,FLNAMESZ);
          }
          prfmsg(LISTLN7,flo->u.key6.filname,l2as(flo->u.key6.size[loop]),
             ncdate(flo->u.key6.date[loop]),nctime(flo->u.key6.time[loop]));
     }
     setmisc("");
     if (!redisplay) {
          flo->tdline[loop]=loop+1;
     }
     if (alrtag(flo->tags[loop].libname,flo->tags[loop].filname)
        || flo->tdline[loop] < 0) {
          flo->tdline[loop]=-abs(flo->tdline[loop]);
          if (flo->flags&USRANSI) {
               prfmsg(TAGGED,(-flo->tdline[loop])+3,'A'+loop);
          }
     }
     if (flo->cursor == loop) {
          dcurs(0);
     }
     optiprf();
}

void
unprop(void)                       /* backspace over propellor             */
{
     if (flo->prop != 0) {
          prf("");
     }
     flo->prop=0;
}

void
srcinit(                           /* initialize file search/list          */
int mode,
char *lib)
{
     struct fllib *libptr=NULL;

     btutsw(usrnum,0);
     setmem(&flo->u,sizeof(union combo),0);
     if (mode > 6) {
          mode-=6;
     }
     flo->keymeth=0;
     if (lib[0] != '\0') {
          libptr=libfind(lib);
     }
     if (libptr != NULL && mode == -1) {
          mode=13;
     }
     else if (lib[0] != '\0') {
          if (libptr != NULL) {
               if (scanlib(1,libptr)) {
                    mode+=6;
               }
               scanlib(0,libptr);
          }
          else {
               lib="";
               mode+=6;
          }
     }
     else {
          mode+=6;
     }
     if ((mode == 1 || mode == 7) && (flo->flags&DATESRC)) {
          stzcpy(flu->newdate,dat2srt(ncdate(today())),DATESZ);
     }
     switch (mode) {
     case 1:
          flo->keymeth=0;
          stzcpy(flo->u.key0.libname,lib,FLNAMESZ);
          if (!isflop(libptr)) {
               stzcpy(flo->u.key0.udate,"0000009",DATESZ);
          }
          break;
     case 2:
          flo->keymeth=1;
          stzcpy(flo->u.key1.libname,lib,FLNAMESZ);
          stzcpy(flo->u.key1.filname,flo->miscfil,FLFILENM);
          break;
     case 3:
     case 9:
          flo->keymeth=2;
          stzcpy(flo->u.key2.libname,lib,FLNAMESZ);
          stzcpy(flo->u.key2.keyword,vdaptr,FLKEYSIZ);
          stzcpy(flo->u.key2.origkey,vdaptr,FLKEYSIZ);
          break;
     case 4:
          flo->keymeth=4;
          stzcpy(flo->u.key4.libname,lib,FLNAMESZ);
          break;
     case 7:
          flo->keymeth=3;
          stzcpy(flo->u.key3.libname,lib,FLNAMESZ);
          if (!haskey(flsysop) && ((libptr == NULL) || !isflop(libptr))) {
               stzcpy(flo->u.key3.udate,"0000009",DATESZ);
          }
          break;
     case 8:
          flo->keymeth=(flo->styp == 8) ? 8 : 4;
          stzcpy(flo->u.key4.libname,lib,FLNAMESZ);
          stzcpy(flo->u.key4.filname,flo->miscfil,FLFILENM);
          if (flo->keymeth == 8) {
               stzcpy(flo->u.key4.exactfn,flo->miscfil,FLFILENM);
          }
          break;
     case 10:
          flo->keymeth=4;
          stzcpy(flo->u.key4.libname,lib,FLNAMESZ);
          break;
     case 5:
     case 11:
          flo->keymeth=5;
          stzcpy(flo->u.key5.numdls,"A000000",NUMSZ);
          setmem(flo->u.key5.libkey,FLNAMESZ,0);
          setmem(flo->u.key5.filname,FLFILENM,0);
          stzcpy(flo->u.key5.libname,lib,FLNAMESZ);
          break;
     case 6:
          flo->keymeth=6;
          stzcpy(flo->u.key1.libname,lib,FLNAMESZ);
          wldstuff(flo->u.key1.filname);
          break;
     case 12:
          flo->keymeth=7;
          stzcpy(flo->u.key4.libname,lib,FLNAMESZ);
          wldstuff(flo->u.key4.filname);
          break;
     case 13:
          wipetag();
          flo->keymeth=9;
          flo->styp=-1;
          sprintf(flo->srcpath,"%s\\*.*",libpath(libptr));
     }
     switch (flo->keymeth) {
     case 0:
          stzcpy(flo->lrange,flo->u.key0.libname,FLNAMESZ);
          break;
     case 1:
     case 6:
          stzcpy(flo->lrange,flo->u.key1.libname,FLNAMESZ);
          break;
     case 2:
          stzcpy(flo->lrange,flo->u.key2.libname,FLNAMESZ);
          break;
     case 3:
          stzcpy(flo->lrange,flo->u.key3.libname,FLNAMESZ);
          break;
     case 4:
     case 7:
     case 8:
          stzcpy(flo->lrange,flo->u.key4.libname,FLNAMESZ);
          break;
     case 5:
          stzcpy(flo->lrange,flo->u.key5.libname,FLNAMESZ);
          break;
     case 9:
          stzcpy(flo->lrange,curlib->libname,FLNAMESZ);
          break;
     }
     if (!initsrc(FILELST0)) {
          gosearch();
     }
}

char *
wldstuff(                          /* place starting characters in key     */
char *stg)
{
     char *sptr,*kptr;

     setmem(kptr=stg,FLFILENM,0);
     strupr(sptr=flo->miscfil);
     while (1) {
          switch (*sptr) {
          case '\0':
          case '*':
          case '?':
          case '.':
               return(stg);
          }
          *kptr++=toupper(*sptr++);
     }
}

void
srcpaus(                           /* pause in file search, screen full    */
int rebuild)
{
     if (flo->flags&USRANSI) {
          switch (flo->atend) {
          case LSTFILS:
               dcurs(0);
               prfmsg(LISTPAUS);
               doalr();
               break;
          case LSTBACK:
               dcurs(0);
               prfmsg(BOTLIST);
               doalr();
               if (flo->tagk == 'A'-1 && !rebuild) {
                    flo->flags|=REVSRCH;
                    flo->flags|=NXTEQUL;
                    flo->flags&=~STOPLST;
               }
               break;
          case LSTFORE:
               dcurs(0);
               if (flo->keymeth == 9) {
                    prfmsg(DOSLIST);
               }
               else {
                    prfmsg(TOPLIST);
                    if (flo->tagk == 'A'-1 && !rebuild) {
                         flo->flags&=~REVSRCH;
                         flo->flags|=NXTEQUL;
                         flo->flags&=~STOPLST;
                    }
               }
               doalr();
               break;
          case LSTONLY:
               if (flo->tagk != 'A'-1) {
                    dcurs(0);
                    prfmsg(ENDLIST);
                    doalr();
                    break;
               }
               flo->atend=LSTNONE;
          case LSTNONE:
               prfmsg(usrptr->substt=POPWIN6);
               deresume();
          }
          if (totags != 0) {
               prfmsg(CTRLT);
          }
          else {
               prfmsg(CLRCTRLT);
          }
     }
     else {
          switch (flo->atend) {
          case LSTFILS:
          case LSTFORE:
               prfmsg(LISTPAUX);
               break;
          case LSTBACK:
          case LSTONLY:
               if (flo->atend == LSTBACK || flo->tagk != 'A'-1) {
                    prfmsg(ENDLISTX);
                    break;
               }
               flo->atend=LSTNONE;
          case LSTNONE:
               prfmsg(NOFILES);
               usrptr->substt=PRESENTR;
               flo->retstt=MMENU;
               deresume();
          }
     }
}

void
srcukey(void)                      /* update keys now for file search      */
{
     int idx;

     switch (flo->keymeth) {
     case 0:
          stzcpy(flo->u.key0.filname,flf->filname,FLFILENM);
          stzcpy(flo->u.key0.udate,flf->udate,DATESZ);
          break;
     case 1:
     case 6:
          stzcpy(flo->u.key1.filname,flf->filname,FLFILENM);
          stzcpy(flo->u.key1.libname,flf->libname,FLNAMESZ);
          break;
     case 2:
          stzcpy(flo->u.key2.keyword,kyd->keyword,FLKEYSIZ);
          stzcpy(flo->u.key2.filname,kyd->filname,FLFILENM);
          stzcpy(flo->u.key2.libkey,kyd->libkey,FLNAMESZ);
          break;
     case 3:
          stzcpy(flo->u.key3.filname,flf->filname,FLFILENM);
          stzcpy(flo->u.key3.udate,flf->udate,DATESZ);
          stzcpy(flo->u.key3.libkey,flf->libname,FLNAMESZ);
          break;
     case 4:
     case 7:
     case 8:
          stzcpy(flo->u.key4.filname,flf->filname,FLFILENM);
          stzcpy(flo->u.key4.libkey,flf->libname,FLNAMESZ);
          break;
     case 5:
          stzcpy(flo->u.key5.numdls,flf->numdls,NUMSZ);
          stzcpy(flo->u.key5.filname,flf->filname,FLFILENM);
          stzcpy(flo->u.key5.libkey,flf->libname,FLNAMESZ);
          break;
     case 9:
          idx=flo->tagk-'A'+1;
          stzcpy(flo->u.key6.filname,flo->fb.name,FLFILENM);
          flo->u.key6.date[idx]=flo->fb.date;
          flo->u.key6.time[idx]=flo->fb.time;
          flo->u.key6.size[idx]=flo->fb.size;
          break;
     }
}

void
gosearch(void)                     /* begin a list/search                  */
{
     unbreak();
     if (isansiu()) {
          flo->flags|=USRANSI;
     }
     else {
          flo->flags&=~USRANSI;
     }
     cncall();
     dispfhdr(1);
     flo->retstt=MMENU;
     flo->tagk='A'-1;
     flo->flags&=~REVSRCH;
     flo->flags&=~STOPLST;
     flo->cursor=0;
     flo->flags&=~DBLCLCK;
     if (flo->keymeth == 1 && flo->u.key1.filname[0] != '\0'
        || flo->keymeth == 4 && flo->u.key4.filname[0] != '\0') {
          flo->atend=LSTFILS;
     }
     else {
          flo->atend=LSTFORE;
     }
     btuinj(usrnum,CYCLE);
     setbusy();
     if (flo->flags&USRANSI) {
          btutrg(usrnum,255);
     }
}

void
libeditd(                          /* finish editing Library area          */
int save)
{
     struct fllib *libptr;
     char lng[10];
     int loop;

     flu=&fluarr[usrnum];
     if (flu->lib[0] == '\0') {
          return;
     }
     setmbk(flmsg);
     curusr(usrnum);
     fluoff(usrnum);
     flo->flags&=~ISEDLIB;
     usrptr->state=flstt;
     usrptr->substt=OPMENU;
     if ((fsdscb->chgcnt == 0) && (libfind(libedt->lib.libname) != NULL)) {
          prfmsg(NOCH);
          setmem(libedt,sizeof(struct libdisk),0);
     }
     else if (!save || (libedt->lib.libname[1] == '')) {
          prfmsg(CHQUIT);
          setmem(libedt,sizeof(struct libdisk),0);
     }
     else {
          if (libedt->lib.libname[0] == '\0') {
               fsdfxt(FLDNAME,libedt->lib.libname,FLNAMESZ);
          }
          fsdfxt(FLDDESC,libedt->lib.libdesc,FLDESCSZ);
          if (sameas(libedt->lib.libdesc,DESCSNON)) {
               setmem(libedt->lib.libdesc,FLDESCSZ,0);
          }
          fsdfxt(FLDDESC4,libedt->ldesc[4],FLLDESCS);
          fsdfxt(FLDDESC3,libedt->ldesc[3],FLLDESCS);
          fsdfxt(FLDDESC2,libedt->ldesc[2],FLLDESCS);
          fsdfxt(FLDDESC1,libedt->ldesc[1],FLLDESCS);
          fsdfxt(FLDDESC0,libedt->ldesc[0],FLLDESCS);
          if (sameas(libedt->ldesc[0],DESCLNON)) {
               setmem(libedt->ldesc[0],FLDESCSZ,0);
          }
          for (loop=(NLDLIN-2) ; loop >= 0 ; loop--) {
               if (libedt->ldesc[loop][0] == '\0') {
                    movmem(libedt->ldesc[loop+1],libedt->ldesc[loop+1],
                       FLLDESCS*NLDLIN-1-loop);
                    libedt->ldesc[NLDLIN-1][0]='\0';
               }
          }
          fsdfxt(FLDPATH,libedt->lib.path,PATHSIZE);
          fsdfxt(FLDPLOP,libedt->lib.primary,UIDSIZ);
          flagit(FLDHID,FLGHID);
          flagit(FLDCBD,FLGCBD);
          flagit(FLDRDO,FLGRDO);
          flagit(FLDAUL,FLGAUL);
          flagit(FLDADL,FLGADL);
          flagit(FLDFDL,FLGFDL);
          flagit(FLDFUL,FLGFUL);
          fsdfxt(FLDCDF,lng,10);
          libedt->lib.dlchge=atol(lng);
          fsdfxt(FLDCDK,lng,10);
          libedt->lib.kdlchge=atol(lng);
          fsdfxt(FLDROY,lng,10);
          libedt->lib.royal=atoi(lng);
          fsdfxt(FLDMFL,lng,10);
          libedt->lib.maxfil=atol(lng);
          fsdfxt(FLDMBT,lng,10);
          libedt->lib.maxbyt=atol(lng);
          fsdfxt(FLDMUP,lng,10);
          libedt->lib.maxbup=atol(lng);
          fsdfxt(FLDVIS,libedt->lib.keyreq,KEYSIZ);
          fsdfxt(FLDDLD,libedt->lib.dlkey,KEYSIZ);
          fsdfxt(FLDULD,libedt->lib.ulkey,KEYSIZ);
          fsdfxt(FLDOVW,libedt->lib.overw,KEYSIZ);
          fsdfxt(FLDAPU,libedt->lib.autoap,KEYSIZ);
          fsdfxt(FLDLOP,libedt->lib.libop,KEYSIZ);
          if ((libptr=libfind(libedt->lib.libname)) == NULL) {
               libptr=liboff(numoflib++);
          }
          mkdir(strupr(libedt->lib.libname));
          if (libedt->lib.path[0] != '\0') {
               mkdir(libedt->lib.path);
          }
          libedt->lib.cluster=clsize(drvnum(libpath(&libedt->lib)));
          movmem(&libedt->lib,libptr,sizeof(struct fllib));
          setbtv(flldat);
          if (acqbtv(NULL,libptr->libname,0)) {
               updbtv(libedt);
               prfmsg(SAVED);
          }
          else {
               insbtv(libedt);
               shocst(spr("LIBRARY CREATED: %s",libptr->libname),
                  "The \"%s\" Library was created",libptr->libname);
               prfmsg(SAVADDED);
          }
          for (loop=0 ; loop < nterms ; loop++) {
               if (user[loop].class >= SUPLON) {
                    ((struct fluson *)ptrblok(flomem,loop))->nlibaxs=-1;
               }
          }
          rstbtv();
          fluoff(usrnum);
          stzcpy(flu->lib,libptr->libname,FLNAMESZ);
          setmem(libedt,sizeof(struct libdisk),0);
          sortlibs();
          scanlibs();
          curlib=setuaxs();
     }
     btucli(usrnum);
     fluoff(usrnum);
     promptin();
     clrprf();
}

void
libeditp(                             /* FSD utility function                 */
int msgno,
int amode)
{
     char *y="YES",*n="NO";

     fsdroom(msgno,libedits,amode);
     sprintf(vdatmp,libeditf,
          ncdate(libedt->lib.day),'\0',
          nctime(libedt->lib.time),'\0',
          libedt->lib.libname,'\0',
          libedt->lib.flags&FLGDOS ? "(DOS-ONLY)" : "",'\0',
          libedt->lib.libdesc[0] != '\0' ? libedt->lib.libdesc : DESCSNON,'\0',
          libedt->ldesc[0][0] != '\0' ? libedt->ldesc[0] : DESCLNON,'\0',
          libedt->ldesc[1],'\0',
          libedt->ldesc[2],'\0',
          libedt->ldesc[3],'\0',
          libedt->ldesc[4],'\0',
          libedt->lib.path,'\0',
          libedt->lib.flags&FLGHID ? y : n,'\0',
          libedt->lib.flags&FLGCBD ? y : n,'\0',
          libedt->lib.flags&FLGRDO ? y : n,'\0',
          auditall || libedt->lib.flags&FLGAUL ? y : n,'\0',
          auditall || libedt->lib.flags&FLGADL ? y : n,'\0',
          freeuls || libedt->lib.flags&FLGFUL ? y : n,'\0',
          libedt->lib.flags&FLGFDL ? y : n,'\0',
          libedt->lib.dlchge,'\0',
          libedt->lib.kdlchge,'\0',
          libedt->lib.royal,'\0',
          libedt->lib.maxfil,'\0',
          libedt->lib.maxbyt,'\0',
          libedt->lib.maxbup,'\0',
          libedt->lib.keyreq,'\0',
          libedt->lib.dlkey,'\0',
          libedt->lib.ulkey,'\0',
          libedt->lib.overw,'\0',
          libedt->lib.autoap,'\0',
          libedt->lib.libop,'\0',
          libedt->lib.primary,'\0');
     fsdapr(vdaptr,vdasiz,vdatmp);
}

void
libkick(void)                      /* tag handler rtkick                   */
{
     int loop,loop2,numftg;

     while (findbest(TGOTHER) && time(NULL)-ftag->tagtime > 60) {
          ftag->status=-ftag->status;
     }
     moploop();
     for (loop=0 ; loop < systags ; loop++) {
          if ((ftag=tagoff(loop))->status > TGEMPTY) {
               if (ftag->usrnum >= 0 && ftag->usrnum < nterms
                  && user[ftag->usrnum].class >= SUPLON) {
                    usrnum=ftag->usrnum;
                    fluoff(usrnum);
                    ftag->status=-ftag->status;
                    setftu();
                    if ((numftg=ftuptr->numftg) == maxtags) {
                         numftg--;
                    }
                    for (loop2=0 ; loop2 <= numftg ; loop2++) {
                         ftgptr=&ftgusr[loop2];
                         if (ftag == spc) {
                              if (loop2 != ftuptr->numftg
                                 || flstt != user[usrnum].state) {
                                   ftag->status=-ftag->status;
                                   break;
                              }
                         }
                    }
                    if (ftag->status < TGEMPTY) {
                         for (loop2=0 ; loop2 < ftuptr->savetags ; loop2++) {
                              ftgptr=&ftgusr[maxtags-loop2-1];
                              if (ftag == spc) {
                                   ftag->status=-ftag->status;
                                   break;
                              }
                         }
                    }
               }
               else {
                    ftag->status=-ftag->status;
               }
          }
     }
     if (!findbest(TGCOPY)) {
          if (cdst != NULL) {
               fclose(cdst);
               cdst=NULL;
          }
          if (csrc != NULL) {
               fclose(csrc);
               csrc=NULL;
          }
          if (findbest(TGINWAIT)) {
               ftag->status=TGCOPY;
               initask(copyaut);
          }
     }
     libchg();
     if (!longsrch && !kwaut && kwbuf[0].keyword[0] != '\0') {
          initask(keywdaut);
          kwaut=1;
     }
     for (loop=0 ; loop < nterms ; loop++) {
          if (user[loop].class > SUPIPG && user[loop].state == flstt
             && user[loop].substt == AUTOGONE && !(user[loop].flags&BYEBYE)) {
               curusr(loop);
               fluoff(usrnum);
               setmbk(flmsg);
               if (flo->index > 0) {
                    if (flo->index >= 3) {
                         flo->index-=3;
                    }
                    else {
                         flo->index=0;
                    }
                    prfmsg(BEEP);
                    outprf(usrnum);
               }
               else {
                    byenow(BANGNOW);
               }
          }
     }
     rtkick(3,libkick);
}

void
prfopt(                            /* output potentially built RIP button  */
int optno,
int tot,
int ctr)
{
     char *msg,*stg,fntsty[RFNTSZ+1],butsty[RBSYSZ+1];
     int len,loop;

     msg=stg=getmsg(optno);
     if (!isripu()) {
          prf("%s",msg);
          return;
     }
     strcpy(fntsty,"|Y00000100");
     strcpy(butsty,"|1B770F0207QQ020E000F080700000F07000077");
     len=strlen(stg);
     for (loop=0 ; loop < len && strncmp(stg,RIP_BUTTON,BCSIZ) != 0
        ; loop++,stg++) {
          if (strncmp(stg,RIP_FONT_STYLE,FSSIZ) == 0) {
               stzcpy(fntsty,stg,RFNTSZ+1);
          }
          else if (strncmp(stg,RIP_BUTTON_STYLE,BSSIZ) == 0) {
               stzcpy(butsty,stg,RBSYSZ+1);
          }
     }
     if (strncmp(stg,RIP_BUTTON,BCSIZ) == 0) {
          for (loop=0 ; loop < 8 ; loop++) {
               stg[3+loop]=autscns[tot-1][ctr][3+loop];
          }
          prf("\r!%s%s\r!%s",fntsty,butsty,stg);
     }
     else {
          prf("%s",msg);
     }
}

void
prfups(void)                       /* sets flmisc to report newest files   */
{
     int loop,day,week;

     week=day=curlib->newfiles[0];
     for (loop=1 ; loop < ULDAYS ; loop++) {
          week+=curlib->newfiles[loop];
     }
     if (week != 0) {
          if (week == day) {
               prfmsg(day == 1 ? FLNFDAY : FLNFDAYS,day);
          }
          else {
               if (day == 0) {
                    prfmsg(week == 1 ? FLNFWK : FLNFWKS,week);
               }
               else {
                    prfmsg(day == 1 ? FLNFDWK : FLNFDWKS,day,week);
               }
          }
     }
}

void
mainmenu(void)                     /* display main File Libraries menu     */
{
     int riptot,ripctr=0;
     char *nfiles;

     if (flo->flags&LONGDSC) {
          setmisc("");
          prfmsg(FLMMNULD);
          prfups();
          if (*(tvdesc0()) != '\0') {
               if (!isripu()) {
                    prf("\r");
               }
               prfmsg(FLMMNULC);
               prfmsg(FLMMNULT);
          }
          setmisc("");
          flo->flags&=~LONGDSC;
     }
     else {
          prfmsg(FLMMNU);
     }
     if (!(curlib->flags&FLGDOS)) {
          nfiles=tvfnum();
          switch (atoi(nfiles)) {
          case 0:
               prfmsg(FLMMNUA0);
               break;
          case 1:
               prfmsg(FLMMNUA1);
               break;
          default:
               prfmsg(FLMMNUA2,nfiles);
          }
     }
     riptot=2;
     if (flo->tagk >= 'A'
        && flo->styp != 4 && flo->styp != 6 && flo->styp != -1) {
          riptot++;
     }
     if (dlfroml(curlib)) {
          riptot++;
     }
     if (ftuptr->numftg > 0) {
          riptot++;
     }
     if (haslibkey(curlib,curlib->ulkey) && writable(curlib)) {
          riptot++;
     }
     if (flo->nlibaxs > 1) {
          riptot++;
     }
     if (isflop(curlib)) {
          riptot++;
     }
     if (haskey(listkey) && !(curlib->flags&FLGDOS)) {
          riptot++;
     }
     if (!isripu()) {
          prf("\r");
     }
     prfopt(((curlib->flags&FLGDOS) ? FLMMNUFD : FLMMNUF),riptot,ripctr++);
     if (flo->tagk >= 'A') {
          if ((flo->styp == 4) || (flo->styp == 6) || flo->styp == -1) {
               setmem(flo->u.key0.libname,FLNAMESZ,0);
          }
          else {
               prfopt(FLMMNUR,riptot,ripctr++);
          }
     }
     if (dlfroml(curlib)) {
          prfopt(FLMMNUD,riptot,ripctr++);
     }
     if (ftuptr->numftg > 0) {
          setmisc(spr("%d",ftuptr->numftg));
          prfopt(FLMMNUT,riptot,ripctr++);
          setmisc("");
     }
     if (haskey(curlib->ulkey) && writable(curlib)) {
          prfopt(FLMMNUU,riptot,ripctr++);
     }
     if (flo->nlibaxs > 1) {
          prfopt(FLMMNUS,riptot,ripctr++);
     }
     if (haskey(listkey) && !(curlib->flags&FLGDOS)) {
          prfopt(FLMMNUL,riptot,ripctr++);
     }
     prfopt(FLMMNUP,riptot,ripctr++);
     if (isflop(curlib)) {
          prfopt(FLMMNUO,riptot,ripctr++);
     }
     prfmsg(FLMMNUX);
     usrptr->substt=MMENU;
}

void
opmenu(void)                       /* display operations menu              */
{
     prfmsg(FLOMNU);
     if (curlib->flags&FLGDOS) {
          prfmsg(haskey(flsysop) ? FLOMNUCD : FLOMNUE3);
     }
     else {
          prfmsg(haskey(flsysop) ? FLOMNUC : FLOMNUE2);
     }
}

void
promptin(void)                     /* display the prompt                   */
{
     int clingsav;

     setftu();
     if (usrptr->state != flstt) {
          return;
     }
     switch (usrptr->substt) {
     case SELLIB2:
     case SELLIB3:
          prfmsg(SELLIB);
          break;
     case TRANSPRT:
          prfmsg(PROTOS);
          outprf(usrnum);
          setftu();
          pmcare=pmvalu=FTFXMT;
          clingsav=clingo;
          if (isripu()) {
               clingo=0;
          }
          (*hdlpmu)();
          clingo=clingsav;
          setmbk(flmsg);
          prfmsg(usrptr->substt);
          break;
     case APPMENU:
          setmisc(spr("%d",getaufil(0,0)));
          prfmsg(APPMENU);
          setmisc("");
          break;
     case RENNAME:
          setmisc(flo->miscfil);
          prfmsg(RENNAME);
          setmisc("");
          break;
     case DELMENU:
          setmisc(spr("%d",nlibtagd()));
          prfmsg(DELMENU);
          setmisc("");
          break;
     case MOVMENU:
          setmisc(spr("%d",nlibtagd()));
          prfmsg(MOVMENU);
          setmisc("");
          break;
     case UNAPPMNU:
          setmisc(spr("%d",getaufil(0,1)));
          prfmsg(UNAPPMNU);
          setmisc("");
          break;
     case OPMENU:
          if (!(usrptr->flags&INJOIP) || (usrptr->flags&ABOIP)) {
               opmenu();
          }
          prfmsg(OPMENU);
          break;
     case TAGMAN:
          if (ftuptr->numftg > 0) {
               rstrxf();
               taglist();
               break;
          }
          else if (flo->flags&OFTGMAN) {
               usrptr->substt=FILELST0;
               rebuild(2);
               unbreak();
               btuinj(usrnum,CYCLE);
               btutrg(usrnum,255);
               return;
          }
          retmenu(0);
          mainmenu();
          prfmsg(MMENU);
          break;
     case MMENU:
          if (isripu() || !(usrptr->flags&INJOIP) || (usrptr->flags&ABOIP)) {
               mainmenu();
          }
          prfmsg(MMENU);
          break;
     case ENTUADNM:
          switch (flo->retstt) {
          case APPMENU:
               setmisc("approve");
               break;
          case DELMENU:
               setmisc("delete");
               break;
          case -DELMENU:
               setmisc("rename");
               break;
          case MOVMENU:
               setmisc((flo->flags&MOVFLAG) ? "copy" : "move");
               break;
          case UNAPPMNU:
               setmisc("unapprove");
          }
          prfmsg(ENTUADNM);
          setmisc("");
          break;
     case CHUNJ:
          prfmsg(flo->index ? CHUNU : CHUNJ);
          break;
     case CHAINMNU:
          scanlib(0,curlib);
          if (chjoined(curlib,curlib->libname)) {
               curlib->libs--;
          }
          prfmsg(CHAINMNU,curlib->libs);
          break;
     case FILMOVA:
          break;
     case WARNMARK:
          prfmsg((flo->miscflag%2) ? WARNMARK : WARNMARB);
          break;
     case ASKNAME:
          prfmsg(flo->styp == 3 ? ASKNAME : ASKWILD);
          break;
     case RENAME:
          if (haslibkey(curlib,curlib->overw)) {
               prfmsg(RENAMO);
          }
          else {
               prfmsg(RENAME);
          }
          break;
     case VIEWASC:
          switch (candlnow(flo->tags[flo->hold].libname,
             flo->tags[flo->hold].filname)) {
          case 0:
               prfmsg(VIEWASCN);
               break;
          case 1:
               prfmsg(VIEWASC);
               break;
          default:
               prfmsg(VIEWASCC);
          }
          break;
     case FILELST2:
          usrptr->substt=FILELST1;
          break;
     case FILELST1:
          prfmsg((flo->atend&LSTBACK) ? ENDLISTX : LISTPAUX);
          break;
     case ASKWHLPA:
          if ((usrptr->flags&INJOIP) && isripu()) {
               prfmsg(usrptr->substt);
          }
          prfmsg(ASKWHLP1);
          break;
     case ASKWHLPB:
          if ((usrptr->flags&INJOIP) && isripu()) {
               prfmsg(usrptr->substt);
          }
          prfmsg(ASKWHLP2);
          break;
     case ASKWHLPC:
          if ((usrptr->flags&INJOIP) && isripu()) {
               prfmsg(usrptr->substt);
          }
          prfmsg(ASKWHLP3);
          break;
     case DODESC:
          ulfileq(0);
          prfmsg(DODESC);
          break;
     case LOGOFF2:
          prfmsg(CLRSCN);
          prfmsg(DEFRIPM);
          prfmsg(LOGOFF2);
          break;
     case LOGOFF3:
          prfmsg(CLRSCN);
          prfmsg(DEFRIPM);
          prfmsg(LOGOFF3);
          break;
     case PLSWAIT:
          prfmsg(CLRSCN);
          prfmsg(DEFRIPM);
          prfmsg(PLSWAIT);
          break;
     case ENTDLFIL:
     case BIGCOPY:
     case SELLIB:
     case PREFERS:
     case DELLIBNM:
     case PRESENTR:
     case ENTULFIL:
     case DELFIL:
     case LOGOFF:
     case MANAGMNU:
     case FLSTYPA:
     case FLSLIB:
     case ASKWORD:
     case ASKOFF:
     case ASKTYPA:
     case ASKLIB:
     case FDESCED:
     case MOVPATH:
     case RENCYC:
     case ULMOD:
     case DOSO:
     case CLIBNAM:
     case FLBLIST:
     case OVERW:
          prfmsg(usrptr->substt);
     default:
          prf("");
     }
     outprf(usrnum);
     prf("");
}

void
retmenu(                           /* return to main/op menu, or exit      */
int opermenu)
{
     cncall();
     usrptr->substt=(opermenu ? OPMENU : MMENU);
     ((struct fluson *)ptrblok(flomem,usrnum))->flags&=~INMVCPY;
     condex();
}

void
buildview(                         /* build viewscreen                     */
int item)
{
     movmem(vdaptr,&vdaptr[vdd],vdd);
     stzcpy(flo->key1.filname,flo->tags[item].filname,FLFILENM);
     stzcpy(flo->key1.libname,flo->tags[item].libname,FLNAMESZ);
     setmbk(flmsg);
     prfmsg(CLRSCN);
     outprf(usrnum);
     unbreak();
     bgnfiled(1);
     movmem(&vdaptr[vdd],vdaptr,vdd);
     if (flo->flags&USRANSI) {
          usrptr->substt=ENTRETT;
          prfmsg(candlnow(flo->key1.libname,flo->key1.filname) > DOWNLOD ?
             ENTRETV : ENTRETT);
     }
     if (flo->tdline[item] < 0) {
          prfmsg(ENTRETRU);
     }
}

void
retoin(void)                       /* passed to return to this module      */
{
     int tagnum;

     if (usrptr->state == flstt) {
          return;
     }
     prf("");
     outprf(usrnum);
     prf("");
     fluoff(usrnum);
     usrptr->state=flstt;
     if (flo->retstt == ENTRETT
        || flo->retstt == FILELST0
        || flo->retstt == VIEWASC) {
          tagnum=alrtag(flo->tags[flo->hold].libname,
             flo->tags[flo->hold].filname);
          if (tagnum != 0) {
               ftag=tagoff(--tagnum);
               ftag->status=-abs(ftag->status);
               for (tagnum=0 ; tagnum < ftuptr->numftg ; tagnum++) {
                    ftgptr=&ftgusr[tagnum];
                    if (spc == ftag) {
                         removetg(tagnum);
                    }
               }
          }
          unbreak();
          if (flo->retstt == VIEWASC) {
               setmbk(flmsg);
               usrptr->substt=VIEWASC;
               switch (candlnow(flo->tags[flo->hold].libname,
                  flo->tags[flo->hold].filname)) {
               case 0:
                    prfmsg(VIEWASCN);
                    break;
               case 1:
                    prfmsg(VIEWASC);
                    break;
               default:
                    prfmsg(VIEWASCC);
               }
               outprf(usrnum);
               prf("");
          }
          else {
               if (flo->retstt == ENTRETT) {
                    setmbk(flmsg);
                    prfmsg(LSTFRAME);
                    if (!isripu()) {
                         prf("\r");
                    }
                    buildview(flo->hold);
               }
               else {
                    prf("\r");
                    usrptr->substt=FILELST0;
                    rebuild(2);
               }
               prf("");
               outprf(usrnum);
               prf("");
               btutrg(usrnum,255);
               usrptr->flags|=NOINJO;
          }
          btuinj(usrnum,CYCLE);
     }
     else {
          usrptr->substt=TAGMAN;
          setmbk(flmsg);
          promptin();
          if (usrptr->substt != MMENU) {
               flo->retstt=TAGMAN;
          }
          prf("");
     }
}

void
retoinx(void)                      /* passed to return, does less          */
{
     usrptr->state=flstt;
     usrptr->substt=flo->retstt;
     flo->retstt=MMENU;
}

void
retoinl(void)                      /* passed to return from listing()      */
{
     retoinx();
     setmbk(flmsg);
     prf("");
     prfmsg(usrptr->substt);
     outprf(usrnum);
     prf("");
}

void
rstcrd(void)                       /* restore from zapcrd                  */
{
     usrptr->crdrat=flo->crdrat;
     usrptr->flags&=~(flo->nozap^NOZAP);
}

void
setbusy(void)                      /* set user's busy flag                 */
{
     flo->flags|=UNOINJO;
     if (!(flo->flags&USRANSI) || !(usrptr->flags&NOINJO)) {
          flo->flags&=~UNOINJO;
          if (flo->flags&USRANSI) {
               usrptr->flags|=NOINJO;
          }
     }
}

void
statstrt(void)                     /* begin fsd : line edit                */
{
     setmbk(flmsg);
     fluoff(usrnum);
     switch (usrptr->substt) {
     case LIBEDITN:
          btuoes(usrnum,0);
          if (libedt->lib.libname[0] != '\0') {
               clrprf();
               prfmsg(LIBEDITX,libedt->lib.libname,
                  ((libedt->lib.flags&FLGDOS) ? "(DOS-ONLY)" : ""),
                  ncdate(libedt->lib.day),nctime(libedt->lib.time));
               outprf(usrnum);
          }
          libeditp(LIBEDITN,0);
          fsdscb->flddat[FLDDATE].flags|=FFFAVD;
          fsdscb->flddat[FLDTIME].flags|=FFFAVD;
          fsdscb->flddat[FLDNAME].flags|=FFFAVD;
          fsdscb->flddat[FLDDOSO].flags|=FFFAVD;
          fsdscb->flddat[FLDPATH].flags|=FFFNSP;
          fsdscb->flddat[FLDVIS].flags|=FFFNSP;
          fsdscb->flddat[FLDDLD].flags|=FFFNSP;
          fsdscb->flddat[FLDULD].flags|=FFFNSP;
          fsdscb->flddat[FLDOVW].flags|=FFFNSP;
          fsdscb->flddat[FLDAPU].flags|=FFFNSP;
          fsdscb->flddat[FLDLOP].flags|=FFFNSP;
          if (libedt->lib.flags&FLGDOS) {
               fsdscb->flddat[FLDHID].flags|=FFFAVD;
               fsdscb->flddat[FLDCBD].flags|=FFFAVD;
               fsdscb->flddat[FLDROY].flags|=FFFAVD;
               fsdscb->flddat[FLDOVW].flags|=FFFAVD;
               fsdscb->flddat[FLDAPU].flags|=FFFAVD;
          }
          if (auditall) {
               fsdscb->flddat[FLDAUL].flags|=FFFAVD;
               fsdscb->flddat[FLDADL].flags|=FFFAVD;
          }
          if (freeuls) {
               fsdscb->flddat[FLDFUL].flags|=FFFAVD;
          }
          fsdego(libeditv,libeditd);
          outprf(usrnum);
          break;
     case FILEDITN:
          btuoes(usrnum,0);
          fileditp(FILEDITN,0,0);
          fsdscb->flddat[FFDNAME].flags|=FFFAVD;
          fsdscb->flddat[FFDLIB].flags|=FFFAVD;
          fsdscb->flddat[FFDDATE].flags|=FFFAVD;
          fsdscb->flddat[FFDTIME].flags|=FFFAVD;
          fsdscb->flddat[FFDSIZE].flags|=FFFAVD;
          fsdscb->flddat[FFDDLT].flags|=FFFAVD;
          fsdscb->flddat[FFDCHG].flags|=FFFAVD;
          if (notapped(flo->udate)) {
               fsdscb->flddat[FFDULD].flags|=FFFAVD;
               fsdscb->flddat[FFDULT].flags|=FFFAVD;
          }
          if (!isflop(curlib)) {
               fsdscb->flddat[FFDUSER].flags|=FFFAVD;
               fsdscb->flddat[FFDDL].flags|=FFFAVD;
               fsdscb->flddat[FFDULD].flags|=FFFAVD;
               fsdscb->flddat[FFDULT].flags|=FFFAVD;
          }
          fsdego(fileditv,fileditd);
          outprf(usrnum);
     }
}

int
getaufil(                          /* check tagspc is ok to approve/unapp  */
int wipe,
int unapp)
{
     struct taglib *tag;
     struct fllib *savclb;
     int loop,retval=0;

     savclb=curlib;
     for (loop=0 ; loop < systags ; loop++) {
          tag=tagoff(loop);
          if (tag->status > TGEMPTY && (!notapped(tag->udate) && unapp
             || notapped(tag->udate) && !unapp) && usrnum == tag->usrnum) {
               curlib=libfind(tag->libname);
               if (curlib != NULL && isflop(curlib)) {
                    if (retval == 0) {
                         stzcpy(flo->key1.filname,tag->filname,FLFILENM);
                         stzcpy(flo->key1.libname,tag->libname,FLNAMESZ);
                         if (wipe) {
                              stzcpy(tag->udate,
                                 unapp ? NOTAPPED : dat2srt(ncdate(today())),
                                 DATESZ);
                         }
                    }
                    retval++;
               }
          }
     }
     curlib=savclb;
     return(retval);
}

int
candlnow(                          /* can user d/l or view now?            */
char *libname,
char *filname)
{
     struct fllib *libptr;
     char *ext;

     setftu();
     if ((libptr=libfind(libname)) != NULL) {
          if (!(libptr->flags&FLGCBD)
            && (maxtags-ftuptr->numftg) > 0) {
               if ((ext=strchr(filname,'.')) == NULL) {
                    ext="";
               }
               else {
                    ext++;
               }
               return(viewmode(ext));
          }
     }
     return(0);
}

int
chjoined(                          /* see if check is joined to Library    */
struct fllib *libptr,
char *check)
{
     int loop;

     if (libptr != NULL) {
          for (loop=0 ; loop < FLNMCATS ; loop++) {
               if (sameas(check,libptr->cat[loop])) {
                    return(1);
               }
          }
     }
     return(0);
}

int
chjoin(                            /* join/unjoin new to l                 */
struct fllib *libptr,
struct fllib *newlib,
int unjoin)
{
     int loop;
     char *catptr;

     if (libptr != NULL && newlib != NULL) {
          for (loop=0 ; loop < FLNMCATS ; loop++) {
               catptr=newlib->cat[loop];
               if (!unjoin) {
                    if (sameas(catptr,libptr->libname)) {
                         prfmsg(LIBALRJN,newlib->libname);
                         break;
                    }
                    else if (*catptr == '\0') {
                         newlib->flags|=LIBCHN;
                         stzcpy(catptr,libptr->libname,FLNAMESZ);
                         return(1);
                    }
               }
               else if (sameas(libptr->libname,catptr)) {
                    catptr[0]='\0';
                    movmem(newlib->cat[loop+1],catptr,
                       (FLNMCATS-loop-1)*FLNAMESZ);
                    newlib->cat[FLNMCATS-1][0]='\0';
                    newlib->flags|=LIBCHN;
                    return(1);
               }
          }
     }
     return(0);
}

void
listjoin(void)                     /* list Libraries joined to curlib      */
{
     int loop,loop2,num=0;
     struct fllib *libptr;

     for (loop=0 ; loop < numoflib ; loop++) {
          libptr=liboff(loop);
          if (libptr->cat[0][0] != '\0' && curlib != libptr) {
               for (loop2=0 ; loop2 < FLNMCATS ; loop2++) {
                    if (sameas(libptr->cat[loop2],curlib->libname)) {
                         prf("%-8s ",libptr->libname);
                         if ((++num%8) == 0) {
                              prf("\r");
                         }
                         outprf(usrnum);
                         prf("");
                    }
               }
          }
     }
     if (num == 0) {
          prfmsg(CHAINO);
     }
}

int
profane(                           /* return true if stg is profane        */
char *stg)
{
     int pfnlvl=0;

     if ((pfnlvl=profan(stg)) != 0) {
          if (isflop(curlib)) {
               pfnlvl=0;
          }
          else if (pfnlvl > pfnceil) {
               pfnlvl=pfnceil;
          }
     }
     return(pfnlvl);
}

int
wldmatch(                          /* match wild word to ordinary word     */
char *wild,                             /* ... word including * or ?s      */
char *sfnm)                             /* ... word to match against       */
{
     char *sptr,chr,*cptr,cmp;

     for (sptr=wild,cptr=sfnm ; (chr=toupper(*sptr)) != '\0' ; sptr++,cptr++) {
          cmp=toupper(*cptr);
          if (chr == '*') {
               return(1);
          }
          if (chr != '?' && chr != cmp || cmp == '\0') {
               return(0);
          }
     }
     return(*cptr == '\0');
}

int
compwild(                          /* does filename qualify as wildfile?   */
char *wildfile,
char *filename)
{
     char *stg;
     char wtot[13],wname[9],wext[4];
     char ftot[13],fname[9],fext[4];

     stzcpy(wtot,wildfile,13);
     stg=strchr(wtot,'.');
     if (stg == NULL) {
          stg="*";
     }
     else {
          *stg++='\0';
     }
     stzcpy(wname,wtot,9);
     stzcpy(wext,stg,4);
     stzcpy(ftot,filename,13);
     stg=strchr(ftot,'.');
     if (stg == NULL) {
          fext[0]='\0';
     }
     else {
          *stg++='\0';
          stzcpy(fext,stg,4);
     }
     stzcpy(fname,ftot,9);
     return(wldmatch(wname,fname) && wldmatch(wext,fext));
}

int
space(void)                        /* check space for copying a file       */
{
     return(getdfre(drvnum(copydir))-thresh > 0L);
}

void
dncfin(                            /* finalize d/l charges                 */
int endok,                         /* 0=aborted 1=ended ok                 */
long bytxfer,                      /* # of bytes actually sent             */
struct fllib *libptr)              /* Library file was in                  */
{
     if (endok || chgabt) {
          dlcharge(dnlprc(bytxfer,libptr),libptr);
     }
}

int
weirddir(                          /* see if dir is suspicious             */
char *dirpath)
{
     int retval=0;
     struct fndblk fb;

     if (fnd1st(&fb,spr("%s\\*.EXE",dirpath),0)) {
          retval=1;
     }
     else if (fnd1st(&fb,spr("%s\\*.COM",dirpath),0)) {
          retval=1;
     }
     else if (fnd1st(&fb,spr("%s\\*.BAT",dirpath),0)) {
          retval=1;
     }
     if (retval) {
          shocst("GALFIL: WARNING - COPYDIR DIRECTORY",
                 "Directory not erased, it has .COM, .EXE, or .BAT files");
     }
     return(retval);
}

int
isansiu(void)                      /* is an ansi user w/ screen settings?  */
{
     return (isripu()
          || (usaptr->ansifl&ANSON)
          && usaptr->scnfse >= 23
          && usaptr->scnwid >= 80);
}

void
touch(                             /* get date from src and give to dest   */
char *src,
char *dest)
{
     int s;
     struct ftime ftp;

     s=open(src,O_RDONLY); /* note: uses fcntl.h */
     if (s > 0) {
          if (!getftime(s,&ftp)) {
               close(s);
               s=open(dest,O_WRONLY); /* note: uses fcntl.h */
               if (s > 0) {
                    setftime(s,&ftp);
                    close(s);
               }
          }
          else {
               close(s);
          }
     }
}

void
untagall(                          /* untag all files                      */
char *libname,
char *filname)
{
     struct taglib *tag;
     int loop;

     for (loop=0 ; loop < systags ; loop++) {
          if (sameas((tag=tagoff(loop))->libname,libname)) {
               if (filname[0] == '\0' || sameas(filname,tag->filname)) {
                    tag->status=-abs(tag->status);
               }
          }
     }
}

int
exfile(                            /* examine file closely                 */
struct fllib *libptr,
struct key0 *key)
{
     struct fndblk fb;
     int del=0,upd=0;

     if (fnd1st(&fb,spr("%s\\%s",libpath(libptr),flf->filname),0)) {
          if (fb.size != flf->siz || fb.time != flf->tim
             || !sameas(ncdate(fb.date),srt2dat(flf->fdate))) {
               upd=1;
          }
          libptr->totbytes+=clfit(fb.size,libptr->cluster);
     }
     else {
          del=1;
     }
     if ((del || upd) && acqbtv(NULL,key,COMPLUF)) {
          if (del) {
               stzcpy(flf->udate,NOTAPPED,DATESZ);
          }
          if (upd) {
               stzcpy(flf->fdate,dat2srt(ncdate(fb.date)),DATESZ);
               flf->siz=fb.size;
               flf->tim=fb.time;
          }
          upvbtv(NULL,FLFILREC+strlen(flf->desc)+1);
     }
     return(1);
}

void
cleanit(                           /* cleanup routine                      */
int total)
{
     int loop,appwait,numfiles,countit,dnum;
     long totbytes;
     unsigned clustsiz,c0siz;
     struct fllib *libptr;
     struct key0 key;

     setbtv(flfdat);
     c0siz=clsize(0);
     for (loop=0 ; loop < numoflib ; loop++) {
          libptr=liboff(loop);
          if (libptr->libname[0] != '\0') {
               appwait=numfiles=0;
               setmem(&key,sizeof(struct key0),0);
               stzcpy(key.libname,libptr->libname,FLNAMESZ);
               totbytes=libptr->totbytes;
               libptr->totbytes=0L;
               dnum=drvnum(libpath(libptr));
               clustsiz=clsize(dnum == 0 ? c0siz : clsize(dnum));
               if (libptr->cluster != clustsiz) {
                    libptr->cluster=clustsiz;
                    libptr->flags|=LIBCHN;
               }
               while (agtbtv(NULL,&key,COMPLUF)
                  && sameas(flf->libname,key.libname)) {
                    stzcpy(key.filname,flf->filname,FLFILENM);
                    stzcpy(key.udate,flf->udate,DATESZ);
                    countit=1;
                    if (total && !(libptr->flags&FLGRDO)
                       && (!(libptr->flags&FLGCBD)
                       || libptr->path[0] != '\0')) {
                         countit=exfile(libptr,&key);
                    }
                    if (!total) {
                         libptr->totbytes=totbytes;
                    }
                    if (countit) {
                         numfiles++;
                         if (notapped(flf->udate)) {
                              appwait++;
                         }
                    }
               }
               if (appwait != libptr->appwait
                  || numfiles != libptr->numfiles
                  || totbytes != libptr->totbytes) {
                    libptr->appwait=appwait;
                    libptr->numfiles=numfiles;
                    libptr->flags|=LIBCHN;
               }
          }
     }
     rstbtv();
}

char *
manytims(                          /* return "> 99K" or the number         */
long howmany)
{
     static char retval[6];

     if (howmany <= 0L) {
          return("0");
     }
     if (howmany > 99000L) {
          return("> 99K");
     }
     sprintf(retval,"%ld",howmany);
     return(retval);
}

struct taglib *
tagoff(                            /* return pointer to tagged file spec   */
int index)
{
     return((struct taglib *)ptrblok(ftagmem,index));
}

char *
isedtlib(void)                     /* userid currently editor of a Library */
{
     for (othusn=0 ; othusn < nterms ; othusn++) {
          if (othusn != usrnum) {
               othusp=&user[othusn];
               if (othusp->class == ACTUSR) {
                    if (othusp->state == flstt) {
                         switch (othusp->substt) {
                         case DOSO:
                         case CLIBNAM:
                              return(uacoff(othusn)->userid);
                         }
                    }
                    else {
                         if (((struct fluson *)ptrblok(flomem,
                            othusn))->flags&ISEDLIB) {
                              return(uacoff(othusn)->userid);
                         }
                    }
               }
          }
     }
     return(NULL);
}

void
countupl(void)                     /* count uploads for all Libraries      */
{
     struct fllib *libptr;
     int loop;

     for (loop=0 ; loop < numoflib ; loop++) {
          libptr=liboff(loop);
          if (libptr->libname[0] != '\0' && !(libptr->flags&FLGRDO)
             && (!(libptr->flags&FLGCBD) || libptr->path[0] != '\0')) {
               inicount(libptr->libname);
               do {
                    ulcount();
               } while (countlib[0] != '\0');
          }
     }
}

void
chuldate(                          /* add/subtract new upload today        */
struct fllib *libptr,
char *date,
int add)
{
     int ago,*numuls;

     if (!sameas(date,NOTAPPED) && libptr != NULL) {
          ago=cofdat(today())-cofdat(dcdate(srt2dat(date)));
          if (ago >= 0 && ago < ULDAYS) {
               numuls=&libptr->newfiles[ago];
               *numuls+=(add ? 1 : -1);
               if (*numuls < 0) {
                    *numuls=0;
               }
               libptr->flags|=LIBCHN;
          }
     }
}

int
dlfrom(                            /* can current user d/l from a Library? */
char *libname)                          /* ... Library name                */
{
     return(libname[0] != '\0' && dlfroml(libfind(libname)));
}

int
dlfroml(                           /* can current user d/l from a Library? */
struct fllib *libptr)                   /* ... Library pointer             */
{
     return(libptr != NULL && haslibkey(libptr,libptr->dlkey));
}

void
dlcant(void)                       /* error - cannot download that file    */
{
     prfmsg(BEEP);
     if (!(flo->flags&XDLBEEP) && (flo->flags&STOPLST)) {
          prfmsg(usrptr->substt=POPWIN5);
          flo->flags|=XDLBEEP;
     }
}

void
setmisc(                           /* set the flmisc text variable         */
char *stg)
{
     stzcpy(flmisc,stg,MISCSIZE);
}

int
viewmode(                          /* given extension, is there a view mode*/
char *ext)
{
     int loop,retval=NOTVIEW;

     for (loop=0 ; loop < NVIEWS && retval == NOTVIEW; loop++) {
          if (sameas(ext,mvarr[loop].ext)) {
               retval=mvarr[loop].mode;
               if (retval == CSTVIEW) {
                    flo->rouptr=mvarr[loop].rouptr;
               }
          }
     }
     return(retval == NOTVIEW ? DOWNLOD : retval);
}

int
register_modeview(                 /* register a CTRL-V viewing mode       */
char *ext,                              /* ...extension to treat           */
int mode,                               /* ...mode to use                  */
void (*rouptr)())                       /* ...if mode CSTVIEW, custom view */
{
     int loop;

     for (loop=0 ; loop < NVIEWS ; loop++) {
          if (mvarr[loop].ext[0] == '\0') {
               stzcpy(mvarr[loop].ext,ext,4);
               mvarr[loop].mode=mode;
               if (mode == 5) {
                    mvarr[loop].rouptr=rouptr;
               }
               return(loop);
          }
     }
     return(-1);
}

void
cycinp(void)
{
     int c=0;

     setmem(input,2,0);
     while (c == 0 && btuica(usrnum,input,1) > 0) {
          c=toupper(*input);
          if (!isalnum(c)) {
               switch (c) {
               case 14:
                    c='+';
                    break;
               case 16:
                    c='-';
                    break;
               case '?':
                    break;
               case 23:
               case ' ':
                    c='@';
                    break;
               case 4:
                    c='%';
                    break;
               case 9:
                    c='>';
                    break;
               case 22:
                    c='&';
                    break;
               case 20:
                    c='#';
                    break;
               case 13:
                    c='!';
                    break;
               case 27:
                    arrower[usrnum]=1;
                    c=0;
                    break;
               case '[':
                    arrower[usrnum]=(arrower[usrnum] == 1 ? 2 : 0);
                    c=0;
                    break;
               default:
                    c=0;
                    arrower[usrnum]=0;
               }
          }
          if (c > 0) {
               if (arrower[usrnum] == 2) {
                    switch (c) {
                    case 'A':
                    case 'D':
                         c='<';
                         break;
                    case 'B':
                    case 'C':
                         c='>';
                         break;
                    case 'H':
                         c='(';
                         break;
                    case 'K':
                         c=')';
                         break;
                    default:
                         c=0;
                    }
               }
               if (c > 0) {
                    input[0]=c;
                    inplen=1;
                    parsin();
                    if (lsinp() == 0) {
                         btuclo(usrnum);
                         btupbc(usrnum,0);
                         prfmsg(CLRSCN);
                         rstrxf();
                         btutsw(usrnum,usaptr->scnwid);
                         echonu(usrnum);
                         btutrg(usrnum,0);
                         if ((flo->flags&USRANSI) && !(flo->flags&UNOINJO)) {
                              usrptr->flags&=~NOINJO;
                         }
                         outprf(usrnum);
                         usrptr->substt=MMENU;
                         injacr();
                         return;
                    }
               }
               arrower[usrnum]=0;
          }
     }
}

