/***************************************************************************
 *                                                                         *
 *   FTFCRC.H                                                              *
 *                                                                         *
 *   Copyright (C) 1993-1994 GALACTICOMM, Inc.      All Rights Reserved.   *
 *                                                                         *
 *   File Transfer CRC computation for X/Y/ZMODEM                          *
 *                                                                         *
 *                                               - R. Stein  7/20/93       *
 *                                                                         *
 *                                                                         *
 * updcrc macro derived from article Copyright (C) 1986 Stephen Satchell.  *
 *                                                                         *
 * Programmers may incorporate any or all code into their programs,        *
 * giving proper credit within the source. Publication of the              *
 * source routines is permitted so long as proper credit is given          *
 * to Stephen Satchell, Satchell Evaluations and Chuck Forsberg,           *
 * Omen Technology.                                                        *
 *                                                                         *
 ***************************************************************************/

unsigned
crc16(                                                /* compute 16-bit CRC */
unsigned char *stg,                                      /* of a byte array */
int nbytes);

unsigned long
crc32(                                                /* compute 32-bit CRC */
unsigned char *stg,                                      /* of a byte array */
int nbytes);

#define CRC32GOOD 0xDEBB20E3L

/*

         for generating 16-bit CRC:  store    crc16(stg,nbytes)
for testing validity of 16-bit CRC:  compare  crc16(stg,nbytes) == 0

         for generating 32-bit CRC:  store   ~crc32(stg,nbytes)
for testing validity of 32-bit CRC:  compare  crc32(stg,nbytes) == CRC32GOOD

*/

/* The following low-level CRC computation macros and the tables they use */
/* come from Omen Technology's CRCTAB.H source file.  See also FTFCRC.C   */

#define updcrc(cp, crc) ( crctab[((crc >> 8) & 255)] ^ (crc << 8) ^ cp)
#define UPDC32(b, c) (cr3tab[((int)c ^ b) & 0xff] ^ ((c >> 8) & 0x00FFFFFFL))

extern unsigned short crctab[];
extern long cr3tab[];
