/***************************************************************************
 *                                                                         *
 *   FILEXFER.H                                                            *
 *                                                                         *
 *   Copyright (C) 1988-1994 GALACTICOMM, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   This is the header for The Major BBS interface into the FTF file      *
 *   transfer routines.                                                    *
 *                                                                         *
 *                                                 - Bob Stein, 3/18/92    *
 *                                                                         *
 ***************************************************************************/

#include "ftf.h"
#include "ftg.h"
#include "fup.h"

struct ftuser {                    /* file transfer user structure         */
     FILE *fp;                     /*   pointer to the current file        */
     struct ftfpsp *ftfpsp;        /*   pointer to protocol specs          */
     char flags;                   /*   general flag variable              */
     char filid;                   /*   view file id (see FTFVIEW.H)       */
     int numftg;                   /*   number of tagspecs                 */
     struct ftg *ftgptr;           /*   current tag in ftgusr array        */
     struct ftg ftg;               /*   local sub-tagspec                  */
     int stchg;                    /*   time of state change               */
                                   /*   (also used by SPCXIT path)         */
     int oubsiz;                   /*   output buffer size (for ftfomt)    */
     void (*retrou)(void);         /*   return to caller routine (ftgdnl())*/
     int (*fuphdl)(int fupcod);    /*   file upload handler                */
     char msgbuf[TSHLEN+1];        /*   record recoverable file xmit error */
                                   /*   record FUPBEG reported abort msg   */
                                   /*   record File Import path            */
     struct fndblk fb;             /*   for breaking down wildcard filespec*/
     FILE *fiep;                   /*   file for importing or exporting    */
     int savetags;                 /*   # of saved tagspecs at array's end */
};

                                    /* ftuptr->flags bit definitions        */
#define FTFBYE  0x01                /*   byebye detected & reported         */
#define VIATAG  0x02                /*   file transfer was via tagging menu */
#define FUPMUL  0x04                /*   multi-file upload                  */
#define FTBANG  0x08                /*   automatic logoff after transfer    */
#define FTFREF  0x10                /*   "F" upload can be by reference     */
#define ASEARCH 0x20                /*   ASCII search mode (download)       */
#define TSHIPG  0x40                /*   Tagspec'd download ses in progress */
#define FUPIPG  0x80                /*   Upload session in progress         */

extern
struct ftuser *ftuser,                         /* FILEXFER.C array x nterms */
              *ftuptr;                 /* FILEXFER.C stuff for current user */
extern int maxtags;              /* maximum number of tagged files per user */
extern char alwait;                          /* auto log-off waiting period */

extern int whomon;                  /* channel being monitored by GALFTSC.C */
extern void (*ftscope)();                  /* GALFTSC.C entry point, if any */

#define FTSSRT 0  /* File xfer starting:           (*ftscope)(0)            */
#define FTSINS 1  /* File xfer inputing a string:  (*ftscope)(1,stg,nbytes) */
#define FTSOUS 2  /* File xfer outputing a string: (*ftscope)(2,stg,nbytes) */
#define FTSEND 3  /* File xfer ending:             (*ftscope)(3)            */
#define FTSHUP 4  /* File xfer user hanging up     (*ftscope)(4)            */
#define FTSCMT 5  /* File xfer diagnostic comment  (*ftscope)(5,comment)    */
#define FTSLON 6  /* File xfer user logging on     (*ftscope)(6)            */

extern
char pmcare,pmvalu;      /* globals for prtmnu(), hdlpmu() and subordinates */
extern
void (*hdlpmu)(void);                    /* Handler chain for protocol menu */
extern
char *fprlock;                                         /* "F" protocol lock */

void
iniftf1(void);             /* FTF initialization, phase 1 (before alcvda()) */

void
iniftf2(void);              /* FTF initialization, phase 2 (after alcvda()) */

void
setftu(void);                   /* set up lots of globals for file transfer */

int
ispvis(                                             /* is protocol visible? */
struct ftfpsp *ftp);                                            /* protocol */
                              /* (call only from within a hdlpmu() routine) */

void
listing(                         /* list an ASCII file to the user's screen */
char *path,         /* DOS path of the file (WARNING: must be non-volatile) */
void (*whndun)());             /* restore state & substate, prompt the user */
     /* optional argument to whndun routine: 1=list completed 0=interrupted */
/* IMPORTANT - path must remain valid, e.g. literal, vdaptr, malloc(nterms) */

void
listingq(           /* E-Z-Quick ASCII file listing, with prompt & substate */
char *path,         /* DOS path of the file (WARNING: must be non-volatile) */
int msgno);              /* msg number, under curmbk, for prompt & substate */
/* IMPORTANT - path must remain valid, e.g. literal, vdaptr, malloc(nterms) */

void
ftfzer(void);                 /* zero out FTF user structure (numftg, etc.) */
                                                    /* (usrnum is implicit) */
