/***************************************************************************
 *                                                                         *
 *   ESGUTL.C                                                              *
 *                                                                         *
 *   Copyright (C) 1988-1994 GALACTICOMM, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   E-mail and SIG utilities and common-code segments.                    *
 *                                                                         *
 *                                  - T. Stryker 7/28/88                   *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"
#include "majorbbs.h"
#include "galms.h"
#include "message.h"
#include "datutils.h"
#include "filexfer.h"

STATIC int tshesg(int tshcod);
STATIC int fupesg(int fupcod);

FILE *esgmb;                  /* esigs named-message file block ptr        */
BTVFILE *esgbb,               /* vesigs btrieve message file block ptr     */
        *qscbb,               /* esigs quickscan/config btrieve file ptr   */
        *qikbb;               /* personal distribution list btrv file ptr  */
struct compos compos;         /* concrete allocation of composite struct   */
long filen;                   /* length of attachment found, from opnatt() */
int esgstt;                   /* current/new usrptr->substt hold register  */
int msgbyts;                  /* maximum number of bytes in message texts  */
int esgvda=0;                 /* max number of bytes required by email/sigs*/
int autfwd;                   /* msg written auto-forwarded? 0,1,or 2=MHS  */
struct sigdat *sdtptr;        /* scratch ptr for scanning thru sigdat      */
struct qscfg *tmpqsc,         /* temp one-shot qscsiz quickscan hold area  */
             *sopqsc,         /* quickscan/config scratch buffer           */
             *qscptr;         /* ptr to current user's quickscan entry     */
struct usracc *sopusa;        /* user account scratch buffer               */
int cb4hdr;                   /* clear screen before messages displayed?   */

char *dftnlv,                 /* default non-live SIG access bits     */
     *dftliv,                 /* default live SIG access bits         */
     *maxnlv,                 /* maximum non-live SIG access bits     */
     *msgatr;                 /* default attribute for message texts  */

char *accstg[]={"Zero","","Read","","Download","","Write","",
                "Upload","","Co-Op","","Forum-Op","","SYSOP","<unassigned>"};

#define MEMENU (isripu() ? ESTART : REPRMT)
#define MSMENU (readac() >= OPAXES ? ORSPRMT : (stlcop ? RSPRMT : NTRSPRMT))
#define MMENU  either(MEMENU,MSMENU)
#define HUH    either(EMLHUH,SIGHUH)
#define FRMFSZ 50

#define acclvl(x,sn) (((sn)&1) ? x[(sn)>>1]>>4 : (x[(sn)>>1]&0x0F))

struct ftgesg {               /* TAGSPEC structure for Email and Forums    */
     long fpos;               /* pointer to message info in GALMSG.DAT     */
     int signo;               /* sig number (for anyone()'s sake)          */
};
#define etgptr ((struct ftgesg *)(ftgptr->tagspc))

#if sizeof(struct ftgesg) > TSLENG
#error ftgesg structure too big
#endif

#define msgbbf ((struct message *)(esgbb->data))

STATIC char *curfor(void);
STATIC int formop(int unum,char *lock);

void EXPORT
init__esig(void)              /* initialize email, sigs and MHS            */
{
     if (esgmb == NULL) {
          esgmb=opnmsg("galms.mcv");
          msgatr=stgopt(MSGATR);
          cb4hdr=ynopt(CB4HDR);
          msgbyts=outbsz-384;
          dclvda(esgvda=sizeof(struct esgusr)+msgbyts);
          qikbb=opnbtv("galdist.dat",sizeof(struct dstdat));
          qscbb=opnbtv("galqsc.dat",MAXQSC);
          esgbb=opnbtv("galmsg.dat",sizeof(struct message)+msgbyts);
          inieml();
          inisig();
          inimhs();
          register_textvar("CURRENT_FORUM",curfor);
          register_pseudok("_FORUMOP",formop);
     }
}

int
fireup(void)                  /* fire up status 3 input handling           */
{
     setmbk(esgmb);
     setbtv(esgbb);
     esgstt=usrptr->substt;
     qscptr=qscoff(usrnum);

     if (usrptr->flags&INJOIP) {
          if (usrptr->flags&ABOIP) {
               switch (esgstt) {
               case MMINF:
               case SRCHNG:
               case SCANNG:
               case SCANAP:
               case LISTNG:
               case CPYING:
                    btuclo(usrnum);
                    abostf();
                    break;
               case SLSTTL:
                    esgptr->usigno=qscptr->cursig;
                    (*esgptr->whndun)();
                    break;
               case OPSTART:
               case SSTART:
               case NTSSTART:
                    prompt(readac() >= OPAXES ? ORSPRMT :
                          (stlcop ? RSPRMT : NTRSPRMT));
                    break;
               default:
                    prompt(esgstt);
               }
          }
          else {
               prompt(esgstt);
          }
     }
     else if (usrptr->pfnacc > MAXPFN) {
          byenow(MUCH2P);
     }
     else if (usrptr->pfnacc > WRNPFN && pfnlvl > 0) {
          errmsg(RAUNCH);
     }
     else if (pfnlvl > 2) {
          errmsg(PFNMSG);
     }
     else if (esgstt != LONFIN) {
          chkdft(esgptr->dftinp);
          return(1);
     }
     return(0);
}

void
hdlesg(void)                  /* handle common email/sigs substates        */
{
     switch (esgstt) {
     case SCOSIG:
     case SCDSIG:
          sscosig();
          break;
     case GONUM:
          sgonum();
          break;
     case REPSIG:
     case REPOP2:
          srepsig();
          break;
     case REPOPX:
     case REPOPU:
     case REPOPA:
          srepopx();
          break;
     case OPFWD1:
          sopfwd();
          break;
     case OPCPY1:
          sopcpy();
          break;
     case THRFBP:
          sthrfbp();
          break;
     case DNLNOW:
          sdnldq();
          break;
     case ATTFIQ:
          sattfiq();
          break;
     case REEFNM:
          sreefnm();
          break;
     case NEWTFN:
          snewtfn();
          break;
     case USEQUO:
          susequo();
          break;
     default:
          catastro("E/SIGS STATE ERROR (esgstt=%d)",esgstt);
     }
}

void
susequo(void)
{
     switch (cncyesno()) {
     case 'Y':
          quotem();
          edimsg(3,1,esgptr->whndun,0);
          break;
     case 'N':
          edimsg(2,1,esgptr->whndun,0);
          break;
     default:
          errmsg(YORN);
     }
}

int
isrepl(void)                         /* is this message a reply to another? */
{
     return(sameto("Reply to #",esgptr->msg.auxtpc));
}

void
dnload(whndun)                /* download attachment, invoke arg when done */
void (*whndun)();
{
     if (attfs(&esgptr->msg) != NULL && filen >= 0) {
          prfmsg(ATTMNT2,attfnm(&esgptr->msg),l2as(filen));
          prompt(DNLNOW);
          esgptr->whndun=whndun;
     }
     else {
          prfmsg(ATTNF,l2as(esgptr->msg.msgno));
          cncall();
          (*whndun)();
     }
}

int
tshesg(int tshcod)                 /* Handle tagspecs for E-mail and Forums */
{                    /* implicit inputs: ftgptr,usrnum,usrptr,usaptr,vdaptr */
                                  /* return value meaning depends on tshcod */
                             /* implicit input/output in many cases: tshmsg */
                                     /* expect caller to do outprf() if any */
     int rc=0;
     char *cp;
     FILE *fp;

     setmbk(esgmb);
     setbtv(esgbb);
     switch(tshcod) {
     case TSHDSC:                            /* Describe tagspec in English */
          if (!aabbtv(NULL,etgptr->fpos,TONUM)) {
               strcpy(tshmsg,"file attached to a message that's now deleted!");
               break;
          }
          sprintf(tshmsg,"file attached to message #%ld",msgbbf->msgno);
          cp=tshmsg+strlen(tshmsg);
          if (msgbbf->to[0] == SIGIDC) {
               sprintf(cp," in %s",msgbbf->to);
          }
          else if (sameas(usaptr->userid,msgbbf->from)) {
               sprintf(cp," to %s",msgbbf->userto);
          }
          else {
               sprintf(cp," from %s",msgbbf->from);
          }
          break;
     case TSHVIS:                                  /* Visible to this user? */
          if (aabbtv(NULL,etgptr->fpos,TONUM)
           && (cp=attfs(msgbbf)) != NULL
           && (fp=fopen(cp,FOPRB)) != NULL) {
               fread(tshmsg,1,TSHLEN,fp);
               fclose(fp);
          }
          rc=1;
          break;
     case TSHSCN:             /* Scan of multi-file wildcard tagspec begins */
          break;
     case TSHNXT:                             /* Next file in wildcard scan */
          break;
     case TSHBEG:              /* Begin download, check permission, reserve */
          if (!aabbtv(NULL,etgptr->fpos,TONUM)) {
               strcpy(tshmsg,"The message has been deleted!");
          }
          else if ((cp=attfs(msgbbf)) == NULL) {
               sprintf(tshmsg,"The file that was attached to message #%ld"
                              " is now missing.",msgbbf->msgno);
          }
          else {
               stzcpy(tshmsg,cp,TSHLEN);
               stzcpy(ftfscb->fname,attfnm(msgbbf),8+1+3+1);
               rc=1;
          }
          break;
     case TSHEND:             /* End complete download of a file, unreserve */
          break;
     case TSHSKP:                     /* Skip incomplete download of a file */
          break;
     case TSHFIN:                           /* Finish file transfer session */
          usrptr->state=esgptr->blknum;
          if (ftfscb->actfil > 0) {
               sv.dwnlds++;
               if (meither(ednaud,sdnaud)) {
                    shocst(meither("E-MAIL ATTACHMENT DOWNLOAD",
                                   "FORUM ATTACHMENT DOWNLOAD"),
                           "%s downld %s from %s",     /* this code expects */
                           usaptr->userid,             /* audrec[AUDSIZ+20] */
                           attfnm(&esgptr->msg),
                           meither(esgptr->msg.from,esgptr->msg.to));
               }
          }
          esgstt=usrptr->substt;
          qscptr=qscoff(usrnum);
          (*esgptr->whndun)();
          usrptr->substt=esgstt;
          rc=lonfin();
          break;
     case TSHHUP:                /* Finish session because user logging off */
          usrptr->state=esgptr->blknum;
          esghup();
          break;
     }
     return(rc);
}

int
begdld(void)                                              /* begin download */
{                           /* returns 0 if tag buffer full (user notified) */
     esgptr->blknum=usrptr->state;
     if (ftgnew() > 0) {
          etgptr->fpos=esgptr->fpos;
          etgptr->signo=findsigu(esgptr->msg.to,0);
          ftgptr->flags=hasmkey(TAGLOCK) ? FTGABL : 0;
          ftgptr->tshndl=tshesg;
     }
     morcnc();
     ftgsbm(cncall());
     if (usrptr->state != esgptr->blknum) {
          esgstt=EDITING;
          outprf(usrnum);
          return(1);
     }
     return(0);
}

void
sdnldq(void)                  /* state: do you want to download file now?  */
{
     switch (cncyesno()) {
     case 'Y':
          prfmsg(DNLHDR);
          if (begdld()) {
               break;
          }
     case 'N':
          (*esgptr->whndun)();
          break;
     default:
          errmsg(YORN);
     }
}

void
emsthn(void)                  /* email/sigs status handler                 */
{
     setmbk(esgmb);
     setbtv(esgbb);
     qscptr=qscoff(usrnum);
     esgstt=usrptr->substt;
     cncall();
     if (status == OUTMT) {
          btuoes(usrnum,0);
          btutru(usrnum,'O'&0x1F);
     }
     if (status == CYCLE) {
          switch (esgstt) {
          case CYCQIK:
          case CYCMSS:
          case CYCQKF:
               dstcyc();
               break;
          default:
               cycmed();
          }
     }
     else {
          dfsthn();
     }
     usrptr->substt=esgstt;
}

void
possat(rouptr)                /* possibly begin attachment proceedings     */
void (*rouptr)();
{
     int sn;

     if (((sn=findsig(esgptr->msg.to)) == NOSIG || rdautl(sn) >= ULAXES)
         && hasmkey(EATKEY)) {
          prompt(ATTFIQ);
          esgptr->whndun=rouptr;
     }
     else {
          (*rouptr)();
     }
}

void
sattfiq()                     /* state: attach file to this msg?           */
{
     switch (cncyesno()) {
     case 'Y':
          if (either(credok(hasmkey(EATKEY),eattck),credsf(esgptr->sattck))) {
               if (isrepl() || tpcfnm(&esgptr->msg) == NULL) {
                    prompt(REEFNM);
               }
               else {
                    prfmsg(UPLHDR);
                    begupl();
               }
          }
          break;
     case 'N':
          if (esgstt != ATTFIQ) {
               prfmsg(NUPLD);
          }
          (*esgptr->whndun)();
          break;
     default:
          errmsg(YORN);
     }
}

int
fupesg(int fupcod)                     /* Handle uploads for Email and SIGs */
{                          /* implicit inputs:  usrnum,usrptr,usaptr,vdaptr */
                                  /* return value meaning depends on fupcod */
                             /* implicit input/output in many cases: fupmsg */
                                     /* expect caller to do outprf() if any */
     int rc=0;
     char *cp;
     int sn;

     setmbk(esgmb);
     qcurusr=&qkusrs[usrnum];
     esgptr=esgarr(usrnum);
     switch(fupcod) {
     case FUPBEG:                /* Begin upload, check permission, reserve */
          if (ftfscb->actfil > 0) {
               sprintf(ftfbuf,"One file at a time.");
          }
          else {
               strcpy(ftfbuf,cp=attfs(&esgptr->msg));
               stzcpy(qcurusr->fspec,cp,FSPSIZ);
               rc=1;
          }
          break;
     case FUPREF:
          ftfrwr(ftfbuf,FSPSIZ-1);
          esgptr->msg.flags|=INDRCT;
          stzcpy(qcurusr->fspec,ftfbuf,FSPSIZ);
          break;
     case FUPEND:               /* End complete upload of a file, unreserve */
          esgptr->msg.flags|=FILATT;
          qscptr=qscoff(usrnum);
          if ((sn=findsig(esgptr->msg.to)) == NOSIG || rdautl(sn) >= COAXES) {
               esgptr->msg.flags|=APPVED;
          }
          strcpy(ftfbuf,cp=attfs(&esgptr->msg));
          break;
     case FUPSKP:                       /* Skip incomplete upload of a file */
          unlink(attfsd(&esgptr->msg));
          break;
     case FUPFIN:                             /* Finish file upload session */
          usrptr->state=esgptr->blknum;
          if (ftfscb->actfil > 0) {
               if ((sn=findsig(esgptr->msg.to)) != NOSIG) {
                    prfmsg(esgptr->msg.flags&APPVED ? FILAVL : FILNVL);
               }
               sv.uplds++;
               if (meither(eupaud,supaud)) {
                    shocst(meither("E-MAIL ATTACHMENT UPLOAD",
                                   "FORUM ATTACHMENT UPLOAD"),
                           "%s uploaded %s to %s",     /* this code expects */
                           usaptr->userid,             /* audrec[AUDSIZ+20] */
                           attfnm(&esgptr->msg),
                           esgptr->msg.to);
               }
          }
          esgstt=usrptr->substt;
          qscptr=qscoff(usrnum);
          (*esgptr->whndun)();
          usrptr->substt=esgstt;
          rc=lonfin();
          break;
     case FUPHUP:                /* Finish session because user logging off */
          usrptr->state=esgptr->blknum;
          esghup();
          break;
     }
     return(rc);
}

void
begupl(void)                                                /* begin upload */
{
     esgptr->blknum=usrptr->state;
     morcnc();
     fileup(attfnm(&esgptr->msg),cncall(),fupesg);
     ftuptr->flags|=FTFREF;
     if (usrptr->state != esgptr->blknum) {
          esgstt=EDITING;
          outprf(usrnum);
     }
}

void
sreefnm(void)                       /* state: reenter topic with file name? */
{
     switch (cncyesno()) {
     case 'Y':
          prompt(NEWTFN);
          break;
     case 'N':
          prfmsg(GODTFN,attfnm(&esgptr->msg));
          prfmsg(UPLHDR);
          begupl();
          break;
     default:
          errmsg(YORN);
     }
}

void
snewtfn(void)           /* state: new file name and description */
{
     char *newtfn;

     if (sameas(newtfn=cncall(),".")) {
          prfmsg(GODTFN,attfnm(&esgptr->msg));
          prfmsg(UPLHDR);
          begupl();
     }
     else {
          stzcpy(esgptr->msg.topic,newtfn,TPCSIZ);
          if ((newtfn=tpcfnm(&esgptr->msg)) == NULL) {
               prfmsg(BADTFN);
               prompt(REEFNM);
          }
          else {
               prfmsg(GODTFN,newtfn);
               prfmsg(UPLHDR);
               begupl();
          }
     }
}

void
ediwqu(whndun)                /* edit a message (w/ possible quoting)      */
void (*whndun)();                  /* where to go when done                */
{
     if (qscptr->flags&ALWQUO) {
          quotem();
          if (!(qscptr->flags&USRSET)) {
               prfmsg(QUOUSD);
          }
          edimsg(3,1,whndun,0);
     }
     else if (qscptr->flags&MSGQUO) {
          esgptr->whndun=whndun;
          prompt(USEQUO);
     }
     else {
          edimsg(2,1,whndun,0);
     }
}

void
edimsg(clr,tpc,whndun,ffv)    /* fire up editor, invoke whndun when done   */
int clr,tpc;
void (*whndun)();
int ffv;                           /* file flavor of edit if set           */
{
     int flags=0,hldflg=0;

     if (clr) {
          if (esgptr->msg.flags&MHSMSG && esgptr->msg.to[0] != SIGIDC) {
               hldflg=1;
          }
          mkmsgn();
          esgptr->msg.flags=(hldflg == 1 ? MHSMSG : 0);
          switch (clr) {
          case 1:
               flags=ED_CLRTOP+ED_CLRTXT;
               break;
          case 2:
               flags=ED_CLRTXT;
               break;
          }
     }
     if (ffv) {
          flags|=ED_FILESD;
     }
     setmbk(esgmb);
     esgptr->whndun=whndun;
     esgptr->blknum=usrptr->state;
     esgptr->dftinp='\0';
     esgstt=usrptr->substt=EDITING;
     prf("");
     outprf(usrnum);
     btuoes(usrnum,0);        /* just in case we're waiting for an OUTMT   */
     btutru(usrnum,'O'&0x1F);
     bgnedt(msgbyts+1,esgptr->msg.text,TPCSIZ,
            tpc ? esgptr->msg.topic : NULL,dunedtg,flags);
     edtimr(esgimr);
}

int
dunedtg(flags)                /* all done editing                          */
int flags;                         /* flags passed back from the editor    */
{
     setmbk(esgmb);
     setbtv(esgbb);
     qscptr=qscoff(usrnum);
     usrptr->state=esgptr->blknum;
     esgstt=usrptr->substt;
     (*esgptr->whndun)(!(flags&ED_QUITEX));
     usrptr->substt=esgstt;
     outprf(usrnum);
     return(lonfin());
}

int
esgimr(mno)                   /* e/sigs message importer utility           */
long mno;
{
     char temp[TPCSIZ+AXTSIZ];
     char tempto[UIDSIZ];
     char temputo[UIDSIZ];
     int koldtp,ftemp;
     long ltemp;

     esgptr=esgarr(usrnum);
     compos.msgno=mno;
     strcpy(compos.userid,usaptr->userid);
     movmem(esgptr->msg.topic,temp,TPCSIZ+AXTSIZ);
     strcpy(tempto,esgptr->msg.to);
     strcpy(temputo,esgptr->msg.userto);
     koldtp=(strlen(esgptr->msg.topic) > 1);
     ltemp=esgptr->msg.msgno;
     ftemp=esgptr->msg.flags;
     setbtv(esgbb);
     if (acqbtv(&esgptr->msg,&compos,FROMNUM)
      || acqbtv(&esgptr->msg,&compos,UTONUM)) {
          strcpy(esgptr->msg.to,tempto);
          strcpy(esgptr->msg.userto,temputo);
          esgptr->msg.msgno=ltemp;
          if (koldtp) {
               movmem(temp,esgptr->msg.topic,TPCSIZ+AXTSIZ);
          }
          else {
               movmem(temp+TPCSIZ,esgptr->msg.auxtpc,AXTSIZ);
          }
          esgptr->msg.flags=ftemp;
          esgptr->msg.nreply=0;
          rstbtv();
          return(1);
     }
     rstbtv();
     return(0);
}

int
uidxst(uid)                   /* does this User-ID exist?                  */
char *uid;
{
     int retval;

     setbtv(accbb);
     if ((retval=(acqbtv(&acctmp,uid,0) && !(acctmp.flags&DELTAG))) != 0) {
          strcpy(uid,acctmp.userid);
     }
     rstbtv();
     return(retval);
}

char *
tpcfnm(msg)      /* extract file name from topic, if any (else return NULL) */
struct message *msg;
{
     static char fname[8+1+3+1];
     char *sp,*cp;
     int i;

     sp=cp=msg->topic;
     for (i=0 ; *cp != '\0' && *cp != '.' && !isspace(*cp) ; cp++,i++) {
     }
     if (i < 1 || i > 8 || *cp != '.') {
          return(NULL);
     }
     cp++;
     for (i=0 ; *cp != '\0' && *cp != '.' && !isspace(*cp) ; cp++,i++) {
     }
     if (i > 3 || *cp == '.') {
          return(NULL);
     }
     stzcpy(fname,sp,(int)(cp-sp+1));
     strupr(fname);
     return(fname);
}

char *
attfnm(msg)                        /* return real file name or ATT name    */
struct message *msg;
{
     char *fnm;

     if ((fnm=tpcfnm(msg)) != NULL) {
          return(fnm);
     }
     else if (msg->flags&INDRCT && (fnm=attfsn(msg)) != NULL) {
          return(fnm);
     }
     else {
          return(spr("%ld.ATT",msg->msgno));
     }
}

char *
attfsn(msg)                   /* attachment filespec, name part only       */
struct message *msg;
{                             /* returns NULL if can't find indirect file  */
     char *alias,*cp;

     if ((alias=attfs(msg)) != NULL) {
          for (cp=alias ; *cp != '\0' ; cp++) {
               if (*cp == '\\' || *cp == ':') {
                    alias=cp+1;
               }
          }
     }
     return(alias);
}

char *
attfsd(msg)                   /* attachment filespec, "direct" only        */
struct message *msg;
{
     static char filespec[FSPSIZ];
     char *fnp;
     int fnplen;

     strcpy(filespec,msg->to[0] == SIGIDC ? msg->to+1 : "email");
     fnp=spr("\\%ld.att",msg->msgno);
     while ((fnplen=strlen(fnp)) >= 14) {         /* ensures over 2 billion */
          fnp[fnplen-2]=fnp[fnplen-1];            /*   unique filenames     */
          fnp[fnplen-1]=fnp[1];
          movmem(fnp+2,fnp+1,strlen(fnp+1));
     }
     strcat(filespec,fnp);
     return(filespec);
}

char *
attfs(msg)                    /* attachment filespec, net (may be indirect)*/
struct message *msg;
{                             /* (may corrupt filespec[] local to attfsd()) */
     FILE *indrfp;
     struct fndblk fb;
     char *filespec;

     filespec=attfsd(msg);
     if (msg->flags&INDRCT) {
          if ((indrfp=fopen(filespec,FOPRB)) == NULL) {
               return(NULL);
          }
          if (fread(filespec,1,FSPSIZ-1,indrfp) != FSPSIZ-1) {
               fclose(indrfp);
               return(NULL);
          }
          fclose(indrfp);
     }
     if (fnd1st(&fb,filespec,0)) {
          filen=fb.size;
     }
     else {
          filen=-1L;
     }
     strupr(filespec);
     return(filespec);
}

int
findsig(name)                 /* find sig number, given name and access    */
char *name;
{
     return(findsigu(name,1));
}

int
findsigu(name,cond)           /* find sig number utility, conditionally    */
char *name;
int cond;
{
     int retval;

     for (retval=0 ; retval < nsigs ; retval++) {
          sdtptr=sigoff(retval);
          if (sameas(name,sdtptr->signam)) {
               strcpy(name,sdtptr->signam);
               if (!cond) {
                    return(retval);
               }
               return(rdautl(retval) == NOAXES ? NOSIG : retval);
          }
     }
     return(NOSIG);
}

void
addaux(newaux)                /* add on to existing auxillary msg topic    */
char *newaux;
{
     if (esgptr->msg.flags&ISSHDR) {
          strcpy(esgptr->msg.auxtpc,newaux);
     }
     else {
          aauxut(newaux,esgptr->msg.auxtpc);
     }
}

void
aauxut(newaux,auxtpc)         /* add-to-aux-topic utility                  */
char *newaux,*auxtpc;
{
     char auxbuf[AXTSIZ*2];

     strcpy(auxbuf,newaux);
     if (strlen(auxtpc) != 0) {
          strcat(auxbuf,", ");
          strcat(auxbuf,auxtpc);
          if (strlen(auxbuf) > AXTSIZ-1) {
               auxbuf[AXTSIZ-2]='*';
               auxbuf[AXTSIZ-1]='\0';
          }
     }
     strcpy(auxtpc,auxbuf);
}

char *
formax(leader)                /* form aux topic fragment, 15 chars max     */
char *leader;
{
     static char auxbuf[AXTSIZ/2+1],*l2asp;

     strcpy(auxbuf,leader);
     l2asp=l2as(esgptr->msg.msgno);
     strcpy(auxbuf+min(strlen(auxbuf),AXTSIZ/2-strlen(l2asp)-1),l2asp);
     return(auxbuf);
}

void
mkmsgn(void)                  /* make msg number                           */
{
     esgptr->msg.msgno=++sv.msgtot;
}

void
postit(void)                  /* post the msg built                        */
{
     strcpy(esgptr->msg.from,usaptr->userid);
     posti();
}

void
posti(void)                   /* post the msg built; don't overwrite 'from'*/
{
     esgptr->msg.crdate=today();
     esgptr->msg.crtime=now();
     esgptr->msg.nreply=0;
     wrtmsg();
}

void
wrtmsg(void)                  /* write message to disk (w/ possible fwd)   */
{
     struct qscfg *qsptr;

     autfwd=0;
     if (isuidc(esgptr->msg.to[0])) {
          if (onsqsc(esgptr->msg.to)) {
               qsptr=qscoff(othusn);
          }
          else {
               if (!grbqsc(tmpqsc,esgptr->msg.to)) {
                    setmem(tmpqsc,qscsiz,0);
               }
               qsptr=tmpqsc;
          }
          if (qsptr->fwdee[0] != '\0') {
               if (valmhs(qsptr->fwdee)) {
                    if (mhsact) {
                         esgptr->mhs.msgno=esgptr->msg.msgno;
                         strcpy(esgptr->mhs.addr,qsptr->fwdee);
                         mhscpy();
                         autfwd=2;
                         return;
                    }
               }
               else {
                    setbtv(accbb);
                    if (acqbtv(&acctmp,qsptr->fwdee,0)
                      && acctmp.credat <= qsptr->fwdate) {
                         movmem(&esgptr->msg,vdatmp,NVMSIZ);
                         addaux(spr("Auto-fwd from %s",esgptr->msg.to));
                         strcpy(esgptr->msg.to,qsptr->fwdee);
                         strcpy(esgptr->msg.userto,qsptr->fwdee);
                         autfwd=1;
                    }
                    else {
                         qsptr->fwdee[0]='\0';
                         if (qsptr == tmpqsc) {
                              setbtv(qscbb);
                              upvbtv(qsptr,qscsiz);
                         }
                    }
               }
          }
     }
     setbtv(esgbb);
     invbtv(&esgptr->msg,NVMSIZ+strlen(esgptr->msg.text));
     if (autfwd) {
          movmem(vdatmp,&esgptr->msg,NVMSIZ);
     }
}

void
stdcnf(void)                  /* standard confirmation after posting       */
{
     prfmsg(WCONFM,l2as(esgptr->msg.msgno));
     if (esgptr->msg.to[0] == SIGIDC) {
          pstpst(SWRITSU,SNOTIFD);
     }
     else {
          pstpst(SWRITU,SNOTIFD);
     }
}

void
pstpst(recip,sender)          /* "post-posting" cleanup                    */
int recip,sender;
{
     outprf(usrnum);
     prf("");
     if (autfwd != 2) {
          figin(1);
     }
     if (!autfwd && onsys(esgptr->msg.userto) && !(usrptr->flags&INVISB)
         && !sameas(esgptr->msg.userto,usaptr->userid)) {
          prfmlt(recip,usaptr->userid,esgptr->msg.to);
          if (injoth()) {
               prfmsg(sender,esgptr->msg.userto);
               outprf(usrnum);
          }
     }
     prf("");
}

void
figin(addend)                 /* figure in the current msg to totals       */
int addend;
{
     if (esgptr->msg.to[0] == SIGIDC) {
          sv.sigopn+=addend;
          if (findsigu(esgptr->msg.to,0) == NOSIG) {
               catastro("FIGIN: NO SIG!");
          }
          sdtptr->nmsgs+=addend;
          switch (esgptr->msg.flags&(FILATT+APPVED)) {
          case FILATT:
               sdtptr->nw4app+=addend;
               break;
          case FILATT+APPVED:
               sdtptr->nfiles+=addend;
               break;
          }
     }
     else {
          sv.emlopn+=addend;
     }
}

void
sgonum(void)                  /* state: email go-to-message number         */
{
     oncors();
     if (strtup(GNMHLP)) {
          sumscn(morcnc() == 'P');
     }
}

void
oncors(void)                  /* get back on course after possible threads */
{
     if (esgptr->prethr != 0L) {
          esgptr->fpos=esgptr->prethr;
          esgptr->prethr=0L;
          esgptr->keynum=esgptr->pthkyn;
     }
}

int
strtup(hlpmsn)                /* start up a scan or list utility           */
int hlpmsn;
{
     long begin;
     char c='\0';

     if (isdigit(morcnc())) {
          begin=cnclon();
          alomsg(esgptr->keynum,begin);
          if (esgptr->msg.msgno != begin) {
               prfmsg(MISMSG,l2as(begin));
          }
     }
     else if ((c=cncchr()) == 'F' || c == 'L') {
          begin=(c == 'F' ? FIRSTM : LASTM);
          alomsg(esgptr->keynum,begin);
     }
     else {
          switch (c) {
          case '?':
               prohlp(hlpmsn);
               if (esgstt == ERTFQN || esgstt == ERTFQL || esgstt == STARTF
                   || esgstt == STARTN) {
                    prompt(esgstt);
               }
               return(0);
          case '.':
               if (esgstt == ERTFQL || esgstt == STARTF) {
                    prfmsg(esgstt == STARTF ? NONWMS : NONEWM);
                    prompt(MMENU);
                    return(0);
               }
               estabc();
               break;
          default:
               errmsg(HUH);
               return(0);
          }
     }
     return(1);
}

void
estabc(void)                  /* establish current galmsg.dat msg again    */
{
     gabbtv(&esgptr->msg,esgptr->fpos,esgptr->keynum);
}

void
estabn(void)                  /* establish position but don't load text    */
{
     gabbtv(NULL,esgptr->fpos,esgptr->keynum);
}

int
estaab(void)                  /* establish current galmsg.dat msg, if ok   */
{
     return(aabbtv(&esgptr->msg,esgptr->fpos,esgptr->keynum));
}

/* The following routine spits out the message summary lines like this:

Date: Monday, December 16, 1991  11:23am                     Electronic Mail
From: Scott Brinker                                            Msg#: 1234567
  To: Chris Robert                                *RETURN RECEIPT REQUESTED*
FILE: HAMBURG.WAF - a recipe fit for kings!                    (123 replies)
      (Reply to #76543, Reply to #78124)

     or this (SIG messages viewed from E-mail or SIGs):

Date: Monday, December 16, 1991  11:23am                       /Tech Support
From: Scott Brinker                                            Msg#: 1234567
  To: Chris Robert                                                  *EXEMPT*
  Re: the second law of thermodynamics...                      (123 replies)
      (Reply to #76123, fwd by Tim Stryker)


*/

void
sumams(void)                       /* spit out the message summary lines   */
{
     int flags,nr;
     char *nrstg,*restg,*dtstg;
     char tmpto,*tmptop;

     if (esgstt != LISTNG && ((qscptr->flags&CMBHDR) || isripu()) && cb4hdr) {
          prf("");
     }
     flags=esgptr->msg.flags;
     if (flags&ISSHDR) {
          prfmsg(esgstt == LISTNG ? SUMLHD : SUMHDR,
            l2as(esgptr->msg.msgno),
            esgptr->msg.to,
            ncedat(esgptr->msg.crdate),
            dthour(esgptr->msg.crtime),
            dtmin(esgptr->msg.crtime),
            esgptr->msg.from,
            esgptr->msg.topic);
     }
     else {
          tmptop=esgptr->msg.userto;
          tmpto=*tmptop;
          *tmptop=uclchr(*tmptop);
          nr=esgptr->msg.nreply;
          nrstg=((nr == 0) ? "" : spr(" (%d repl%s)",nr,(nr == 1) ? "y" : "ies"));
          dtstg=datlin();
          restg=((flags&APPVED) ? "FILE" : "  Re");
          if (esgptr->msg.to[0] == SIGIDC) {
               prfmsg(esgstt == LISTNG ? SUMLST : SUMAMS3,
                 dtstg,
                 esgptr->msg.to,
                 frmfld(),
                 spr("Msg#: %ld",esgptr->msg.msgno),
                 esgptr->msg.userto,
                 (flags&EXEMPT) ? " *EXEMPT*" : "",
                 restg,
                 esgptr->msg.topic,
                 nrstg,
                 axtstg(),
                 "");
          }
          else if (!sameas(usaptr->userid,esgptr->msg.from)
                && !sameas(usaptr->userid,esgptr->msg.userto)) {
               catastro("SUMAMS ERROR");
          }
          else {
               prfmsg(esgstt == LISTNG ? SUMLST : SUMAMS3,
                 dtstg,
                 "Electronic Mail",
                 frmfld(),
                 spr("Msg#: %ld",esgptr->msg.msgno),
                 esgptr->msg.userto,
                 (flags&RECREQ) ? " *RETURN RECEIPT REQUESTED*" : "",
                 restg,
                 esgptr->msg.topic,
                 nrstg,
                 axtstg(),
                 "");
          }
          *tmptop=tmpto;
     }
}

char *
datlin(void)                       /* build the date/time string           */
{
     static char retval[40];

     strcpy(retval,prnday(esgptr->msg.crdate,9));
     strcat(retval,", ");
     strcat(retval,prndat(22,esgptr->msg.crdate,','));
     strcat(retval,"  ");
     strcat(retval,prntim(2,esgptr->msg.crtime));
     return(retval);
}

char *
axtstg(void)                  /* auxillary topic string formatter          */
{
     return(esgptr->msg.auxtpc[0] == '\0' ? ""
            : spr("      (%s)\r",esgptr->msg.auxtpc));
}

char *
frmfld(void)                  /* return contents of from field for display */
{
     int len;

     if (!(esgptr->msg.flags&MHSMSG) || !mhsfsnd()) {
          return(esgptr->msg.from);
     }
     strcpy(vdatmp,esgptr->mhs.addr);
     if (strlen(vdatmp) > FRMFSZ-1) {
          len=(((strlen(vdatmp)-(FRMFSZ-1)-1)/80)+1)*80+FRMFSZ;
          padfld(vdatmp,len);
     }
     return(vdatmp);
}

void
sumnew(void)                  /* summarize new msg, set fpos, prompt       */
{
     esgptr->fpos=absbtv();
     sumams();
     esgptr->usigno=findsigu(esgptr->msg.to,0);
     if ((qscptr->flags&CMBHDR) || isripu()) {
          outprf(usrnum);
          if (esgptr->msg.to[0] != SIGIDC || esgptr->keynum == FROMNUM) {
               scoutle();
          }
          else {
               scoutls();
          }
     }
     else {
          prompt(meither(SCOSCN,scoscd()));
     }
}

void
sumscn(dsifmore)              /* sumnew(), but don't show if more input    */
int dsifmore;
{
     sumnew();
     if (dsifmore && morcnc() && numcat+1 < maxcat) {
          clrprf();
     }
     else {
          outprf(usrnum);
     }
     prf("");
}

void
refclr(cflmsg)                /* clear current msg (w/check), go on        */
int cflmsg;
{
     int isanxt;
     long temp,ultdest;

     estabc();
     cncall();
     if (esgcfl()) {
          prfmsg(cflmsg);
          isanxt=aqnxut();
     }
     else {
          temp=esgptr->fpos;
          isanxt=aqnxut();
          ultdest=absbtv();
          esgptr->fpos=temp;
          estabc();
          if (sameas(usaptr->userid,esgptr->msg.userto)) {
               esgptr->msg.userto[0]=clrchr(esgptr->msg.userto[0]);
          }
          if (sameas(usaptr->userid,esgptr->msg.to)) {
               esgptr->msg.to[0]=clrchr(esgptr->msg.to[0]);
          }
          upvbtv(&esgptr->msg,NVMSIZ+strlen(esgptr->msg.text));
          esgptr->fpos=ultdest;
          estaab();
     }
     if (!isanxt) {
          blwoff(RPREND);
     }
}

int
aqnxut(void)                  /* acquire next message utility for refclr() */
{
     if (anibtv(&esgptr->msg)) {
          sumnew();
          return(1);
     }
     return(0);
}

int
alomsg(keyno,msgno)           /* acquire highest msg less than msgno, or?  */
int keyno;
long msgno;
{
     char *tffield;

     tffield=either(usaptr->userid,sigoff(esgptr->usigno)->signam);
     strcpy(compos.userid,tffield);
     compos.msgno=msgno;
     if (msgno == FIRSTM
       || !alebtv(&esgptr->msg,&compos,keyno)
       || !sameas(esgbb->key,compos.userid)) {
          if (!agebtv(&esgptr->msg,&compos,keyno)
            || !sameas(esgbb->key,compos.userid)) {
               return(0);
          }
     }
     esgptr->fpos=absbtv();
     esgptr->keynum=keyno;
     return(1);
}

void
prompt(news)                  /* prompt user, set new state, default input */
int news;
{
     int i;
     char reqkey[KEYSIZ];

     if (isripu()) {
          switch (news) {
          case RSPRMT:
               news=SSTART;
               break;
          case ORSPRMT:
               news=OPSTART;
               break;
          case NTRSPRMT:
               news=NTSSTART;
          }
     }
     esgstt=news;
     if (!morcnc() || numcat+1 >= maxcat || (usrptr->flags&INJOIP)) {
          sdtptr=sigoff(esgptr->usigno);
          switch (news) {
          case ESTART:
          case REPRMT:
          case RSPRMT:
          case NTRSPRMT:
          case ORSPRMT:
               if (usrptr->flags&CONCEX) {
                    btuoes(usrnum,0);
                    btutru(usrnum,'O'&0x1F);
                    condex();
               }
               else if (esgptr->sflags&LONIPG) {
                    prfmsg(LONDUN);
                    esgptr->sflags|=LONFIN;
               }
               else {
                    prfmsg(news);
               }
               break;
          case EINFO:
               prfmsg(news,emltck,eattck,rrrtck,emllif);
               break;
          case ERTFQF:
          case ERFHLP:
          case STARTN:
          case STARTF:
          case STARTL:
          case RTSHLP:
          case RTLHLP:
               prfmsg(news,l2as(esgptr->msg.msgno));
               break;
          case OPSTART:
               if (haskey(sigsys)) {
                    news=SYSTART;
               }
          case SSTART:
          case NTSSTART:
               if (usrptr->flags&CONCEX) {
                    btuoes(usrnum,0);
                    btutru(usrnum,'O'&0x1F);
                    condex();
               }
               else {
                    prfmsg(news,sdtptr->signam,sdtptr->descrp,sdtptr->nw4app);
               }
               break;
          case SRKEY:
               prfmsg(esgptr->keywds[0] == '\0' ? SRKEY : SRKYWD,esgptr->keywds);
               break;
          case SRCHNG:
               if (!(esgptr->sflags&SCNQUI)) {
                    prfmsg(news,sdtptr->signam,esgptr->keywds);
                    break;
               }
               news=SRCHQS;
          case SCANNG:
          case LISTNG:
               prfmsg(news,sdtptr->signam);
               break;
          case QUICKC:
               prfmsg(news);
               for (i=0 ; i < nsigs ; i++) {
                    if ((i=qsignx(i)) != NOSIG) {
                         prf("%-9s ",sigoff(i)->signam);
                    }
               }
               prf("\r");
               prfmsg(QUICKC4);
               break;
          case QCKWDS:
               prfmsg(news);
               for (i=0 ; i < NQSKWG ; i++) {
                    prf("   %d. %s\r",i+1,qscptr->qskwds[i]);
               }
               prfmsg(QCKWDS2);
               break;
          case SIGCON3:
          case SIGCON4:
          case SIG123N2:
          case SYS123N2:
               stzcpy(reqkey,sigoff(esgptr->usigno)->sigloc,KEYSIZ);
               if (reqkey[0] == '\0') {
                    stzcpy(reqkey,sigprv,KEYSIZ);
               }
               prfmsg(news,accstg[dftlvl(dftnlv)],
                           accstg[dftlvl(dftliv)],
                           accstg[dftlvl(maxnlv)],
                           reqkey);
               break;
          case DELRUS1:
               sdtptr=sigoff(esgptr->blknum);
               prfmsg(news,sdtptr->signam,sdtptr->descrp,
                           sdtptr->nmsgs,sdtptr->nfiles);
               break;
          case SYSPMT:
               btumil(usrnum,LFILSZ-5);
               prfmsg(news);
               break;
          case SYSTWO:
               btumil(usrnum,UIDSIZ-1);
               prfmsg(news);
               break;
          case ENTUID:
               btumil(usrnum,UIDSIZ-1);
               prfmsg(news,(int)qcurusr->curpos+1);
               break;
          case QPRICE:
          case QPRICC:
               prfmsg(news,qcurusr->countr);
               break;
          case WHOTO1:
          case CPYUID1:
               btumil(usrnum,255);
               prfmsg(esgstt);
               break;
          case REEFNM:
               prfmsg(isrepl()
                   && usrptr->state != emlstt
                   && esgptr->msg.to[0] == SIGIDC ? RERFNM : REEFNM,
                      esgptr->msg.topic,attfnm(&esgptr->msg));
               break;
          case NEWTFN:
               prfmsg(esgstt);
               btumil(usrnum,TPCSIZ-1);
               break;
          case MODLOC:
          case SIGLOC:
               prfmsg(news,sigprv);
               break;
          case SIGLOCH:
               prfmsg(news,sigprv);
               prfmsg(SIGLOC,sigprv);
               break;
          case MODLOCH:
               prfmsg(news,sigprv);
               prfmsg(MODLOC,sigprv);
               break;
          case SIGLOCB:
               prfmsg(news);
               prfmsg(SIGLOC,sigprv);
               break;
          case MODLOCB:
               prfmsg(news);
               prfmsg(MODLOC,sigprv);
               break;
          case SIGMTO:
               if (sigoff(esgptr->usigno)->mhsaddr != NULL) {
                    prfmsg(SIGETO);
               }
               else {
                    prfmsg(SIGMTO);
               }
               break;
          default:
               prfmsg(news);
          }
          esgptr->dftinp=getdft();
     }
     else {
          prf("");
     }
}

void
prohlp(news)                  /* prompt with help msg (don't change state) */
int news;
{
     int xstt;

     cncall();
     xstt=esgstt;
     prompt(news);
     esgstt=xstt;
}

void
errmsg(msgnum,parm1,parm2)    /* error msg, then re-prompt current state   */
int msgnum;
long parm1,parm2;
{
     if (msgnum != 0) {
          prfmsg(msgnum,parm1,parm2);
     }
     outprf(usrnum);
     cncall();
     clrinp();
     prompt(esgstt);
}

void
blwoff(msgnum,parm)           /* blow off back to main e/s menu, with msg  */
int msgnum;
long parm;
{
     esgstt=MMENU;
     errmsg(msgnum,parm);
}

void
xtext(void)                   /* transmit text of current msg to user      */
{
     char *cp;

     for (cp=esgptr->msg.text ; *cp != '\0' ; cp++) {
          if (*cp == '\r' && isalnum(*(cp+1))) {
               *cp='\n';
          }
     }
     btuoes(usrnum,1);
     btutru(usrnum,'\r');
     btuxmt(usrnum,msgatr);
     btuxmt(usrnum,esgptr->msg.text);
     btuxmt(usrnum,"\r");
     if (esgptr->prethr == 0L) {
          if (usrptr->state == emlstt) {
               if (esgptr->keynum != FROMNUM
                 && usaptr->emllim < esgptr->msg.msgno) {
                    usaptr->emllim=esgptr->msg.msgno;
               }
          }
          else if (LSOFAR[esgptr->usigno] < esgptr->msg.msgno) {
               LSOFAR[esgptr->usigno]=esgptr->msg.msgno;
          }
     }
}

void
quotem(void)                  /* "quote" the current in-memory message     */
{
     int len=0;
     char *curlin,inits[]="  >";

     if ((curlin=strstr(esgptr->msg.userto,"{MBBS:")) != NULL) {
          curlin=skpwht(curlin+strlen("{MBBS:"));
     }
     else {
          curlin=esgptr->msg.userto;
     }
     inits[0]=toupper(curlin[0]);
     if (strchr(curlin,' ') == NULL) {
          inits[1]=toupper(curlin[1]);
     }
     else {
          inits[1]=toupper(*lastwd(curlin));
     }
     stpans(esgptr->msg.text);
     curlin=esgptr->msg.text;
     if (*curlin == '\n') {                  /* skip leading \n's          */
          do {
               len++;
          } while (*(curlin+len) == '\n');
          movmem(curlin+len,curlin,strlen(curlin+len)+1);
     }
     while (strlen(esgptr->msg.text)+strlen(inits) < msgbyts) {
          if ((len=linlen(curlin)) != 0) {
               movmem(curlin,curlin+strlen(inits),strlen(curlin)+1);
               movmem(inits,curlin,strlen(inits));
               if ((len+=strlen(inits)) > 79) {
                    movmem(curlin+len,curlin+79,strlen(curlin+len)+1);
                    len=79;
               }
          }
          if (*(curlin=curlin+len) == '\0' || *++curlin == '\0') {
               break;
          }
     }
}

int
linlen(ptr)                   /* find the length of line (up to first \r)  */
char *ptr;                         /* pointer to line to get length of     */
{
     int retval;

     for (retval=0 ; *ptr != '\r' && *ptr != '\0'; retval++,ptr++) {
          if (*ptr == '\n') {
               *ptr='\r';
               break;
          }
     }
     return(retval);
}

int
tovalid(void)                 /* check if proposed msg recipient is valid  */
{
     if (validwr(*nxtcmd == SIGIDC ? cncsig() : cncall())) {
          sendto(uidxrf.userid);
          return(1);
     }
     return(0);
}

int
validwr(dest)                 /* ck if msg destination is ok, leave "to" be */
char *dest;
{
     int signo,attach;

     if ((signo=findsig(dest)) != NOSIG) {
          attach=(esgptr->msg.flags&FILATT);
          if (rdautl(signo) < (attach ? ULAXES : WRAXES)) {
               errmsg(attach ? FWUNUP : FWUNWR,either(EMAIL,SIGS));
               return(0);
          }
          strcpy(uidxrf.userid,dest);
          return(1);
     }
     switch (hdluid(dest)) {
     case UIDFND:
          return(1);
     case UIDPMT:
          prompt(esgstt);
          break;
     case UIDCAL:
          esgptr->dftinp=languages[clingo]->yes[0];
          break;
     }
     return(0);
}

int
isalon(void)                  /* check if input is a "long", prep compos   */
{
     if (!isdigit(morcnc())) {
          errmsg(HUH);
          return(0);
     }
     compos.msgno=cnclon();
     strcpy(compos.userid,either(usaptr->userid,sigoff(esgptr->usigno)->signam));
     return(1);
}

void
moddun(save)                  /* modify-msg done, update and go on         */
int save;
{
     if (save) {
          wrtmod();
     }
     else {
          prfmsg(WABORT);
     }
     prompt(MMENU);
}

void
wrtmod(void)                  /* write modified record to disk (&ck SIGHDR)*/
{
     int oidx,sn,rst=0;
     char *bptr,*eptr;
     struct sighdr *hdrptr;

     if (!esgcfl()) {
          if (esgptr->msg.flags&ISSHDR) {
               hdrptr=(struct sighdr *)(&esgptr->msg);
               movmem(esgptr->msg.topic,sigoff((sn=hdrptr->signo))->descrp,
                                        TPCSIZ);
               if ((oidx=findstg("mhs-addr:",esgptr->msg.text)) > 0) {
                    bptr=esgptr->msg.text+oidx;
                    while (isspace(*bptr)) {
                         bptr++;
                    }
                    eptr=strchr(bptr,'\r');
                    if (eptr == NULL) {
                         eptr=bptr+strlen(bptr);
                    }
                    else {
                         *eptr='\0';
                         rst=1;
                    }
                    if (sigoff(sn)->mhsaddr == NULL) {
                         sigoff(sn)->mhsaddr=alcdup(bptr);
                    }
                    else if (!(sameas(sigoff(sn)->mhsaddr,bptr))) {
                         free(sigoff(sn)->mhsaddr);
                         sigoff(sn)->mhsaddr=alcdup(bptr);
                    }
                    if (rst) {
                         *eptr='\r';
                    }
               }
               else if (sigoff(sn)->mhsaddr != NULL) {
                    free(sigoff(sn)->mhsaddr);
                    sigoff(sn)->mhsaddr=NULL;
               }
          }
          estabn();
          upvbtv(&esgptr->msg,NVMSIZ+strlen(esgptr->msg.text));
          prfmsg(WCONFM,l2as(esgptr->msg.msgno));
     }
}

int
fwdit(recip,copy)             /* forward or copy current msg to new recp.  */
char *recip;
int copy;
{
     char orgto[UIDSIZ];
     char oldnam[FSPSIZ];
     char *fsp;

     estabc();
     strcpy(oldnam,attfsd(&esgptr->msg));
     strcpy(orgto,esgptr->msg.to);
     if (recip != NULL) {
          sendto(recip);
     }
     if (copy) {
          addaux(spr("Copy by %s",usaptr->userid));
     }
     else {
          addaux(spr("Fw by %s",usaptr->userid));
     }
     esgptr->curpos=esgptr->msg.msgno;
     mkmsgn();
     if (esgptr->msg.flags&FILATT) {
          if (copy) {
               if ((esgptr->fp=fopen(oldnam,FOPRB)) == NULL) {
                    errmsg(CPYFNG,oldnam);
                    return(1);
               }
               esgptr->sflags|=CPYIPG;
               if ((esgptr->fpout=
                         fopen(fsp=attfsd(&esgptr->msg),FOPWB)) == NULL) {
                    errmsg(CPYFNG,fsp);
                    return(1);
               }
               cncall();
               fupqs(CPYING,0);
               return(0);
          }
          rename(oldnam,attfsd(&esgptr->msg));
          if (recip != NULL) {
               dwfwdf();
          }
     }
     if (recip == NULL) {
          mhscpy();
          prfmsg(SNTMHS);
     }
     else {
          if (esgptr->msg.to[0] == SIGIDC && sdtptr->mhsaddr != NULL &&
              mhsact && !sameas(orgto,esgptr->msg.to)) {
               if (esgptr->msg.flags&MHSMSG) {    /* NOTE:  needed to ack  */
                    esgptr->msg.flags&=~MHSMSG;   /* that reply info in    */
               }                                  /* mhsbb will be lost    */
               wrtmsg();
               mhscpy();
               clrprf();
          }
          else if (autfwd != 2 && (esgptr->msg.flags&MHSMSG)) {
               wrtmsg();
               setbtv(mhsbb);
               if (aabbtv(&esgptr->mhs,esgptr->mhsfpos,0)) {
                    esgptr->mhs.msgno=esgptr->msg.msgno;
                    if (copy) {
                         insbtv(&esgptr->mhs);
                    }
                    else {
                         updbtv(&esgptr->mhs);
                    }
               }
               rstbtv();
          }
          else {
               wrtmsg();
          }
          dunfwc(copy);
     }
     return(1);
}

void
cpedun(void)                  /* copy of email completed stuff             */
{
     if (esgptr->mhs.addr[0] == '\0') {
          dwfwdf();
          wrtmsg();
          dunfwc(1);
     }
     else {
          mhscpy();
          prfmsg(SNTMHS);
     }
     estabn();
     if (anibtv(&esgptr->msg)) {
          sumnew();
     }
     else {
          blwoff(RPREND);
     }
}

void
cpsdun(void)                  /* copy of sig message completed stuff       */
{
     char *oldnxc;

     if (esgptr->mhs.addr[0] == '\0') {
          dwfwdf();
          wrtmsg();
          dunfwc(1);
     }
     else {
          oldnxc=nxtcmd;
          nxtcmd=esgptr->mhs.addr;
          esgptr->sflags|=MHSORG;
          mhscpy();
          esgptr->sflags&=~MHSORG;
          nxtcmd=oldnxc;
          prfmsg(SNTMHS);
     }
     if (usrptr->state == emlstt) {
          oncors();
          estabc();
          if (anibtv(&esgptr->msg)) {
               esgptr->fpos=absbtv();
               if (estaab()) {
                    sumnew();
               }
               else {
                    blwoff(WOWEE);
               }
          }
          else {
               blwoff(RPREND);
          }
     }
     else {
          estabc();
          esgptr->prethr=0L;
          asig((esgptr->sflags&SCN4UA) ? LASTM : esgptr->msg.msgno);
          sgonext();
     }
}

void
dunfwc(copy)                  /* display msgs when done with forward/copy  */
int copy;
{
     prfmsg(copy ? CPYCNF : FWDCNF,l2as(esgptr->curpos),
                                   l2as(esgptr->msg.msgno),
                                   esgptr->msg.to);
     pstpst(copy ? SCOPYU : SFWDDU,SNOTIFD);
}

void
sendto(recip)                 /* send current message to spec'd recipient  */
char *recip;
{
     char *cp;

     strcpy(esgptr->msg.to,recip);
     if (*recip == SIGIDC) {
          if (morcnc() == '-') {
               cncchr();
               if (*(cp=cncuid()) != '\0' && uidxst(cp)) {
                    strcpy(esgptr->msg.userto,cp);
                    return;
               }
          }
          strcpy(esgptr->msg.userto,ALL);
     }
     else {
          strcpy(esgptr->msg.userto,recip);
     }
}

void
dwfwdf(void)                  /* deal with forwarding of file              */
{
     int sn;

     esgptr->msg.flags|=APPVED;
     if ((sn=findsig(esgptr->msg.to)) != NOSIG) {
          if (rdautl(sn) >= COAXES) {
               prfmsg(FWDCAP);
          }
          else {
               esgptr->msg.flags&=~APPVED;
               prfmsg(FWDCNA);
          }
     }
}

void
delwck(void)                  /* delete msg, with sighdr and collision cks */
{
     esgptr->fpos=absbtv();
     if (esgptr->msg.flags&ISSHDR) {
          blwoff(NDELHD);
     }
     else if ((esgptr->msg.flags&ISRETR)
            && sameas(usaptr->userid,esgptr->msg.from)
            && !sameas(esgptr->msg.from,esgptr->msg.userto)) {
          blwoff(NDELMS);
     }
     else if (esgcfl()) {
          blwoff(USING);
     }
     else {
          delmsg();
          prfmsg(OKGONE,l2as(compos.msgno));
          prompt(MMENU);
     }
}

void
delmsg(void)                  /* delete msg and any direct attachment      */
{
     if (esgptr->msg.flags&MHSMSG) {
          setbtv(mhsbb);
          if (acqbtv(NULL,&esgptr->msg.msgno,0)) {
               delbtv();
          }
          rstbtv();
     }
     delbtv();
     unlink(attfsd(&esgptr->msg));
     figin(-1);
}

void
qikdel(tdy)                   /* delete old distributed attachment files  */
int tdy;
{
     int age;
     char temp[FSPSIZ];

     if (fnd1st(&sigfnd,"email\\*.atq",0)) {
          do {
               age=tdy-cofdat(sigfnd.date);
               setmem(temp,sizeof(temp),0);
               strcpy(temp,"email\\");
               strcat(temp,sigfnd.name);
               if (emllif >= 0 && age > emllif) {
                    unlink(temp);
               }
          } while (fndnxt(&sigfnd));
     }
}

void
esgmcu(void)                  /* email/sigs midnight cleanup               */
{
     int ctoday,age,smslif;

     ctoday=cofdat(today());
     qikdel(ctoday);
     setbtv(esgbb);
     esgptr=esgarr(0);
     usrptr=user;
     if (qlobtv(TONUM)) {
          do {
               gcrbtv(&esgptr->msg,TONUM);
               age=ctoday-cofdat(esgptr->msg.crdate);
               if (esgptr->msg.to[0] == SIGIDC) {
                    if (esgptr->msg.flags&ISSHDR) {
                         smslif=sigopt("message-lifetime:",siglif);
                    }
                    else if (!(esgptr->msg.flags&EXEMPT)
                      && smslif >= 0 && age > smslif) {
                         delmsg();
                    }
               }
               else if (emllif >= 0 && age > emllif) {
                    delmsg();
               }
          } while (qnxbtv());
     }
}

char *
sigtpc(signo)                 /* sig topic (for use by teleconference)     */
int signo;
{
     if (signo < 0 || signo >= nsigs) {
          return("");
     }
     else {
          return(sigoff(signo)->descrp);
     }
}

void
esgmod(whndun)                /* email/sigs modify-msg utility             */
void (*whndun)();
{
     esgptr->fpos=absbtv();
     if (esgcfl()) {
          prfmsg(USING);
          cncall();
          (*whndun)(0);
     }
     else if ((esgptr->msg.flags&ISRETR)
            && sameas(usaptr->userid,esgptr->msg.from)) {
          errmsg(NMODMS);
     }
     else {
          if (esgptr->msg.flags&ISSHDR) {
               if (!sopmhd && !haskey(sigsys)) {
                    errmsg(NOMODH);
                    return;
               }
               if (!morcnc()) {
                    prfmsg(EHDPF2,sigccr,siglif,sigtck,sattck);
                    outprf(usrnum);
               }
          }
          edimsg(0,1,whndun,(esgptr->msg.flags&FILATT));
     }
}

int
anyone(insig)                 /* is there anyone in this sig right now?    */
int insig;
{
     struct ftgesg *ftep;

     for (othusn=0,othusp=user ; othusn < nterms ; othusn++,othusp++) {
          if ((othusp->state == sigstt || inedit(othusn,dunedtg))
            && (esgarr(othusn)->usigno == insig
             || qscoff(othusn)->cursig == insig)) {
               return(1);
          }
          else if ((ftep=(struct ftgesg *)tagths(tshesg)) != NULL
                && ftep->signo == insig) {
               return(1);
          }
     }
     return(0);
}

int
esgcfl(void)                  /* email/sigs "conflict" (collision) detect  */
{
     long recpos;
     struct esgusr *othesg;
     struct ftgesg *ftep;
     int i;

     recpos=esgptr->fpos;
     for (othusn=0,othusp=user ; othusn < nterms ; othusn++,othusp++) {
          if (othusn != usrnum && othusp->class > SUPIPG) {
               if (othusp->state == emlstt || othusp->state == sigstt ||
                   inedit(othusn,dunedtg)) {
                    switch (othusp->substt) {
                    case ESTART:
                    case REPRMT:
                    case SSTART:
                    case NTSSTART:
                    case RSPRMT:
                    case NTRSPRMT:
                    case OPSTART:
                    case ORSPRMT:
                         break;
                    default:
                         othesg=esgarr(othusn);
                         if (recpos == othesg->fpos
                          || recpos == othesg->prethr) {
                              return(1);
                         }
                    }
               }
               else if ((ftep=(struct ftgesg *)tagths(tshesg)) != NULL
                     && ftep->fpos == recpos) {
                    return(1);
               }
          }
     }
     setftu();
     for (i=0 ; i < ftuptr->numftg ; i++) {
          if (ftgusr[i].tshndl == tshesg &&
              ((struct ftgesg *)(ftgusr[i].tagspc))->fpos == recpos) {
               return(1);
          }
     }
     return(mhschk(recpos));
}

void
esghup(void)                  /* email/sigs hang-up-phone vector           */
{
     setmbk(esgmb);
     if (usrptr->state == emlstt || usrptr->state == sigstt) {
          if (usrptr->substt == RRRQ && esgptr->msg.to[0] != '!' &&
              esgptr->msg.to[0] != '@') {
               sigmhs();
               postit();
          }
          cpyoff();
          clrprf();
     }
     qscptr=qscoff(usrnum);
     if (sameas(qscptr->userid,usaptr->userid)) {
          setbtv(qscbb);
          geqbtv(NULL,usaptr->userid,0);
          upvbtv(qscptr,qscsiz);
     }
     setmem(qscptr,qscsiz,0);
     qcurusr=&qkusrs[usrnum];
     qfclose();
     setmem(qcurusr,sizeof(struct qikusr),0);
}

int
credok(nlvflg,howmny)         /* credits ok for this operation?            */
int nlvflg;
int howmny;
{
     if (!nlvflg) {
          prfmsg(NOACCS,either(EMAIL,SIGS));
     }
     else if (!dedcrd(howmny,0)) {
          prfmsg(tstcrd(1) ? NECREDS : NOCREDS,howmny,either(EMAIL,SIGS));
          howbuy();
     }
     else {
          return(1);
     }
     errmsg(0);
     return(0);
}

int
credsf(howmny)                /* credits sufficient for this operation?  */
int howmny;
{
     return(credok(1,howmny));
}

int
clrchr(c)                          /* reversable clobber of user-id char   */
int c;                             /*   (for "cleared" message to/userto)  */
{
     return(isuidc(c) ? lwclch(c) : c);
}

int
uclchr(c)                          /* un-clobber of clobbered user-id char */
int c;
{
     return(isuidc(c) ? c : lwclch(c));
}

int
lwclch(c)                          /* reversable clobber/unclobber of char */
int c;                             /*   character to clobber/unclobber     */
{
     static char xform[256]={
            0, 32, 34, 39, 40, 41, 44, 45, 46, 48, 49, 50, 51, 52, 53, 54,
           55, 56, 57, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77,
            1, 78,  2, 79, 80, 81, 82,  3,  4,  5, 42, 83,  6,  7,  8, 47,
            9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 84, 85, 86, 87, 88, 89,
           90, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 33, 35,
           36, 37, 38, 43, 58, 59, 60, 61, 62, 63, 64, 95, 97, 98, 99, 91,
          100, 92, 93, 94, 96,123,124,125,126,127,166,167,168,169,170,171,
          172,173,174,175,176,177,178,179,180,181,182,101,102,103,104,105,
          183,184,185,186,187,188,189,190,191,192,193,194,195,196,197,198,
          199,200,201,202,203,204,205,206,207,208,209,210,211,212,213,214,
          215,216,217,218,219,220,106,107,108,109,110,111,112,113,114,115,
          116,117,118,119,120,121,122,128,129,130,131,132,133,134,135,136,
          137,138,139,140,141,142,143,144,145,146,147,148,149,150,151,152,
          153,154,155,156,157,158,159,160,161,162,163,164,165,224,225,226,
          221,222,223,240,241,242,243,244,245,246,247,248,249,250,251,252,
          227,228,229,230,231,232,233,234,235,236,237,238,239,  0,  0,  0
     };

     return(xform[c&0xFF]);
}

STATIC char *
curfor(void)                       /* current forum text variable          */
{
     if (sameas(qscoff(usrnum)->userid,usaptr->userid) &&
         qscoff(usrnum)->cursig != NOSIG) {
          return(sigoff(qscoff(usrnum)->cursig)->signam);
     }
     return(dftsig);
}

STATIC int
formop(unum,lock)                  /* forum op of current forum pseudokey  */
int unum;                               /* user number to check on         */
char *lock;                             /* lock name to check on           */
{
     int signo,axs;
     struct qscfg *qsctmp;

     if (sameas(lock,"_FORUMOP")) {
          if (gen_haskey(sigsys,unum,&user[unum])) {
               return(1);
          }
          qsctmp=qscoff(unum);
          if ((signo=qsctmp->cursig) != NOSIG ||
              (signo=findsig(dftsig)) != NOSIG) {
               if (sameas(qsctmp->userid,uacoff(unum)->userid) &&
                   (axs=acclvl(qsctmp->acclso,signo)) >= OPAXES &&
                   axs != NOTSET) {
                    return(1);
               }
          }
     }
     return(0);
}

/***********************************************************************
  New exportable message-send API code follows... should convert
  existing wrtmsg() calls and so forth to this standard at some point
 ***********************************************************************/

int
sendmsg(msg,to)               /* write message wherever (w/ possible fwd)  */
struct message *msg;
char *to;
{
     struct qscfg *qsptr;
     char tmpto[UIDSIZ],tmputo[UIDSIZ],tmpaux[AXTSIZ];
     int retval;

     if (to == NULL || *to == '\0') {
          to=msg->to;
     }
     autfwd=0;
     if (!valmhs(to) && isuidc(to[0])) {
          if (onsqsc(to)) {
               qsptr=qscoff(othusn);
          }
          else {
               if (!grbqsc(tmpqsc,to)) {
                    setmem(tmpqsc,qscsiz,0);
               }
               rstbtv();
               qsptr=tmpqsc;
          }
          if (qsptr->fwdee[0] != '\0') {
               to=qsptr->fwdee;
               if (valmhs(to)) {
                    autfwd=2;
               }
               else {
                    setbtv(accbb);
                    if (acqbtv(&acctmp,to,0)
                      && acctmp.credat <= qsptr->fwdate) {
                         stzcpy(tmpaux,msg->auxtpc,AXTSIZ);
                         stzcpy(tmpto,msg->to,UIDSIZ);
                         stzcpy(tmputo,msg->userto,UIDSIZ);
                         aauxut(spr("Auto-fwd from %s",msg->to),msg->auxtpc);
                         strcpy(msg->to,to);
                         strcpy(msg->userto,to);
                         autfwd=1;
                    }
                    else {
                         qsptr->fwdee[0]='\0';
                         if (qsptr == tmpqsc) {
                              setbtv(qscbb);
                              upvbtv(qsptr,qscsiz);
                              rstbtv();
                         }
                    }
                    rstbtv();
               }
          }
     }
     if (valmhs(to)) {
          retval=snd2mhs(msg,to);
     }
     else {
          if (*to == SIGIDC) {
               if (findsigu(to,0) == NOSIG) {
                    return(0);
               }
               if (sdtptr->mhsaddr != NULL) {
                    snd2mhs(msg,sdtptr->mhsaddr);
               }
               sv.sigopn++;
               sdtptr->nmsgs++;
               if (msg->flags&FILATT) {
                    if (msg->flags&APPVED) {
                         sdtptr->nfiles++;
                    }
                    else {
                         sdtptr->nw4app++;
                    }
               }
          }
          else {
               sv.emlopn++;
          }
          setbtv(esgbb);
          invbtv(msg,NVMSIZ+strlen(msg->text));
          retval=1;
          if (autfwd == 1) {
               stzcpy(msg->auxtpc,tmpaux,AXTSIZ);
               stzcpy(msg->to,tmpto,UIDSIZ);
               stzcpy(msg->userto,tmputo,UIDSIZ);
          }
          rstbtv();
     }
     return(retval);
}

