/***************************************************************************
 *                                                                         *
 *   BRKTHU.H                                                              *
 *                                                                         *
 *   Copyright (C) 1986-1994 GALACTICOMM, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   This is the header file prototyping all of the GSBL routines.         *
 *                                                                         *
 *                                            - T. Stryker 2/12/92         *
 *                                                                         *
 ***************************************************************************/

#define RING   1              /* btusts() return for ringing/lost carrier  */
#define CMDOK  2              /* btusts() return for command completed ok  */
#define CRSTG  3              /* btusts() return for CR-term'd string avail*/
#define INBLK  4              /* btusts() return for count-trg input avail */
#define OUTMT  5              /* btusts() return for output buffer empty   */
#define OBFCLR 6              /* btusts() return for output buffer cleared */
#define ABOREQ 7              /* btusts() return for abort output requested*/
#define LOST2C 11             /* btusts() return for 2400 baud lost-carrier*/
#define CMN2OK 12             /* btusts() return for 2400 baud cmd complete*/
#define LOST25 21             /* btusts() return for X.25 lost-carrier     */
#define CM25OK 22             /* btusts() return for X.25 cmd complete     */
#define RCVX29 24             /* btusts() return for X.29 string received  */
#define SPXTRM 31             /* btusts() for SPX terminate by other side  */
#define IPXPSE 32             /* btusts() for IPX/SPX pause complete       */
#define SPXINC 34             /* btusts() for SPX incoming call complete   */
#define SPXOUT 35             /* btusts() for SPX outgoing call complete   */
#define SPXTDN 36             /* btusts() for SPX termination complete     */
#define IPXRER 37             /* btusts() for IPX recv error (chan group)  */
#define IPXUNK 38             /* btusts() for IPX unknown packet (chan grp)*/
#define SPXWDG 39             /* btusts() for SPX watchdog error, etc      */
#define INAPP 'I'             /* Inappropriate status (fm ^H cmd if 300bd) */
                              /* status codes 200-249 are app-specific     */
                              /* status codes 250-255 are buffer overflow  */

#define X25CLO     0x500      /* btux29() return code for window-full error*/

#define SDFANY  0             /* GSBL btusdf() argument for XECOM/UART hdw */
#define SDFX25  4             /* GSBL btusdf() argument for X.25 hardware  */
#define SDFIPXD 5             /* GSBL btusdf() argument for IPX Direct hdw */
#define SDFIPXV 6             /* GSBL btusdf() argument for IPX Virtual hdw*/
#define SDFSPX  7             /* GSBL btusdf() argument for SPX hardware   */

#define CNTCHR 0         /* bturep()/btuset() code for character count     */
#define CNTPAK 1         /* bturep()/btuset() code for packet count        */
#define CNTOVR 2         /* bturep()/btuset() code for input overrun count */
#define CNTPTY 3         /* bturep()/btuset() code for input parity errors */
#define CNTFMG 4         /* bturep()/btuset() code for input framing errors*/
#define X25ERR -13       /* btusdf() return code -- no GSBL/X25 linked     */
#define LANERR -14       /* btusdf() return code -- LAN access not avail   */
#define MEMERR -15       /* btuitz()/btusdf() return code -- out of memory */

extern
char btuver[];                /* GSBL version code                         */
extern
volatile unsigned ticker;     /* increments once per second                */
extern
volatile unsigned long btuhrt; /* increments 65536 times a second          */
extern
int ictact,                   /* after btuict() or btuica():# of bytes avl */
    btusrs,                   /* # of users supported under this license   */
    btudtr,                   /* 1 to disable DTR-dropping during reset    */
    btux25,                   /* flag indicating X.25 support in GSBL      */
    x25ign,                   /* count of received packets ignored by GSBL */
    x25udt,                   /* set to 1 to capture User Data Field       */
    lanecb,                   /* # of listen-ECBs per LAN channel          */
    lansop,                   /* socket actually opened by btusdf() call   */
    lansca;                   /* SPX connections available                 */
extern
int btulan;                   /* Flags from the GSBL/LAN:                  */
#define BTLIPXD  0x0001       /*    bit 0: IPX Direct circuits supported   */
#define BTLIPXV  0x0002       /*    bit 1: IPX Virtual circuits supported  */
#define BTLSPX   0x0004       /*    bit 2: SPX circuits supported          */
#define BTLI7A   0x0100       /*    bit 8: IPX driver is loaded            */
#define BTLSPXL  0x0200       /*    bit 9: SPX is loaded                   */
extern
char bturno[];                /* registration # of this copy of GSBL       */
extern
char lanrev[2];               /* SPX revision number                       */

unsigned btusiz(int nchan,int isiz,int osiz);
long btulsz(int nchan,int isiz,int osiz);
int btuitz(void *region);
int btuitm(void *region);
int btudef(int schan,int sport,int n);
int btusdf(int schan,int nchan,int chtype,...);
int btux29(int chan,int nbyt,char *data);
long btuset(int chan,int stid,long newval);
long bturep(int chan,int stid);
int btuudf(int schan,int n);
int btumxs(unsigned bdrate);
int bturti(int n,void (*rtirou)(void));
int btupfl(void (*pflrou)(int type,unsigned off,unsigned sel));
extern long *ppflreal;
extern long pflplap;
extern long pflmys3;
extern long pflgsbl;
extern long pflrng3;
extern char pfn;
int btubsz(int chan,int isiz,int osiz);
int btusts(int chan);
int btucmd(int chan,char *cmdstg);
int btubrt(int chan,unsigned bdrate);
int btuxmt(int chan,char *datstg);
int btuscn(void);
int btuinp(int chan,char *rdbptr);
void btuxlt(char oldchr,char newchr);
int btupmt(int chan,char pmchar);
int btubse(int chan,char bschar);
int btutrm(int chan,char crchar);
int btuchi(int chan,char (*rouadr)(int chan,int c));
int btuche(int chan,int onoff);
int btulfd(int chan,char lfchar);
int btutsw(int chan,int width);
int btumil(int chan,int maxinl);
int btuscr(int chan,char softcr);
int btuhcr(int chan,char hardcr);
int btuech(int chan,int onoff);
int btuxnf(int chan,int xon,int xoff,...);
int btuhwh(int chan,int inpcut);
int btutru(int chan,char trunch);
int btuerp(int chan,int onoff);
int btumon(int chan);
int btumds(void);
void btumks(char kyschr);
int btumon2(int chan);
int btumds2(void);
void btumks2(char kyschr);
int btuinj(int chan,int status);
int btuoes(int chan,int onoff);
int btuoba(int chan);
int btuibw(int chan);
int btuxct(int chan,int nbyt,char *datstg);
int btutrg(int chan,int nbyt);
int btuict(int chan,char *rdbptr);
int btuica(int chan,char *rdbptr,int max);
int btuffo(int chan,int onoff);
int btulok(int chan,int onoff);
int btuclo(int chan);
int btucli(int chan);
int btuclc(int chan);
int btucls(int chan);
int bturst(int chan);
int btutrs(int chan,int onoff);
int btupbc(int chan,char pausch);
int btucpc(int chan,char clrpch);
int btuhpk(int chan,int (*hpkrou)(int chan,char c));
int btuolk(int chan,int onoff);
int btuirp(int comno);
int btuhit(int comint);
int btuxmn(int chan,char *datstg);
int btuhdr(int sapchn,int bufsiz,void *buffer);
void btuend(void);
void chiinp(int chan,char c);
void chiout(int chan,char c);
void chious(int chan,char *stg);
void chiinj(int chan,int s);
int btuusp(int chan,int onoff);
