/***************************************************************************
 *                                                                         *
 *   BBSGEN.C                                                              *
 *                                                                         *
 *   Copyright (C) 1993-1994 GALACTICOMM, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   Manages mainline 'Main Executive' records in the generic user         *
 *   database BBSGEN.DAT                                                   *
 *                                                                         *
 *                                      -R. Stein 2/9/93                   *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"
#include "majorbbs.h"

struct bbsgen genbuf;    /* for reading Main Exec records from BBSGEN.DAT  */
STATIC int ggrc;         /* global used between getgen() and setgen()      */

int
getgen(genbuf,userid)              /* read BBSGEN.DAT's Main Executive info*/
struct bbsgen *genbuf;                  /* where to put (or format) stuff  */
char *userid;
{                                       /* returns 1=read 0=new, formatted */
     setmem(genbuf,sizeof(struct bbsgen),0);
     strcpy(genbuf->userid,userid);
     strcpy(genbuf->modnam,BBSGMX);
     setbtv(genbb);
     if ((ggrc=acqbtv(genbuf,genbuf,0)) != 0) {
          if (llnbtv() > sizeof(struct bbsgen)) {
               catastro("BBSGEN.DAT record too large for Main Executive\n"
                        "(did you downgrade your version??)");
          }
     }
     rstbtv();
     return(ggrc);
}

void
setgen(genbuf)                     /* write Main Exec record to BBSGEN.DAT */
struct bbsgen *genbuf;                  /* record, could be from getgen()  */
{
     setbtv(genbb);
     if (ggrc) {
          upvbtv(genbuf,sizeof(struct bbsgen));
     }
     else {
          invbtv(genbuf,sizeof(struct bbsgen));
     }
     rstbtv();
}
