@ECHO OFF
ECHO OFF
CLS
ECHO 
ECHO                       Market Center/Market Monitor 5.0
ECHO                          Demonstration Installation
ECHO 

REM if the source or dest. drive is not specified, go to display usage and abort
REM else, continue
IF "%1"=="" GOTO USAGE
IF "%2"=="" GOTO USAGE

REM if the source drive is valid, go to continuation point 1
REM else, go to display usage and abort
IF "%1"=="A:" GOTO CONT1
IF "%1"=="a:" GOTO CONT1
IF "%1"=="B:" GOTO CONT1
IF "%1"=="b:" GOTO CONT1
GOTO USAGE

:CONT1
REM if the destination drive is valid, go to continuation point 2
REM else, go to display usage and abort
IF "%2"=="C:" GOTO CONT2
IF "%2"=="c:" GOTO CONT2
IF "%2"=="d:" GOTO CONT2
IF "%2"=="D:" GOTO CONT2
IF "%2"=="E:" GOTO CONT2
IF "%2"=="e:" GOTO CONT2
IF "%2"=="F:" GOTO CONT2
IF "%2"=="f:" GOTO CONT2
GOTO USAGE

:CONT2
REM create the demo directory at the root of the destination drive
MD %2\MDEMO

REM copy all files from the root of the source drive to the demo directory
COPY %1\*.* %2\MDEMO\*.*

REM delete files which really did not need to be copied
DEL %2\MDEMO\INSTALL.EXE
DEL %2\MDEMO\INSTALL.BAT

REM go into the demo directory
%2
CD \MDEMO

REM if we're not in the demo directory, go to display error message and abort
REM else, continue
IF NOT EXIST DEMO.BAT GOTO ERROR1

REM de-compress and delete compressed files
PKWUNZIP MMDEMO.CMP   MMDEMO.EXE
DEL MMDEMO.CMP
PKWUNZIP TDEMO.CMP    TDEMO.DFL
DEL TDEMO.CMP
PKWUNZIP MMSETUP.CMP  MMSETUP.EXE
DEL MMSETUP.CMP
PKWUNZIP NEWSDEL.CMP  NEWSDEL.EXE
DEL NEWSDEL.CMP
PKWUNZIP COPAGE.CMP   COPAGE.DAT
DEL COPAGE.CMP
PKWUNZIP FPAGE.CMP    FPAGE.DAT
DEL FPAGE.CMP
PKWUNZIP SPAGE.CMP    SPAGE.DAT
DEL SPAGE.CMP
PKWUNZIP SECURITY.CMP SECURITY.DAT
DEL SECURITY.CMP
PKWUNZIP CHART.CMP    CHART.DAT
DEL CHART.CMP
PKWUNZIP SFDSF.CMP    SFDSF.DAT
DEL SFDSF.CMP
PKWUNZIP FFDSF.CMP    FFDSF.DAT
DEL FFDSF.CMP
PKWUNZIP COFDSF.CMP   COFDSF.DAT
DEL COFDSF.CMP
PKWUNZIP ROIRPRO.CMP  ROIRPRO.EXE
DEL ROIRPRO.CMP

REM if the last (and biggest) de-compressed file does not exist, go to err msg
REM else, continue
IF NOT EXIST ROIRPRO.EXE GOTO ERROR2

REM delete de-compression utility
DEL PKWUNZIP.EXE

REM display success message and go to end
CLS
ECHO 
ECHO The Market Center/Market Monitor 5.0 demonstration programs have been
ECHO installed onto drive %2 in the directory \MDEMO.
ECHO 
ECHO INSTALL will now start the demonstration for you...
ECHO 
demo
GOTO END

:USAGE
ECHO 
ECHO To install the Market Center/Market Monitor 5.0 demonstration onto your hard
ECHO drive, you should specify the source and destination drives on the command
ECHO line.
ECHO 
ECHO As an example, if the demo diskette is in drive A: and you wanted to install
ECHO the demo onto your hard drive C:, you would run:
ECHO 
ECHO     A:INSTALL  A:  C:
ECHO 
ECHO Or, if the demo diskette is in drive B: and you wanted to install the demo
ECHO onto your hard drive C:, you would run:
ECHO 
ECHO     B:INSTALL  B:  C:
ECHO 
ECHO The source drive may be A: or B:.
ECHO The destination drive may be C:, D:, E: or F:.
ECHO 
GOTO END

:ERROR2
ECHO 
ECHO 
ECHO Unable to de-compress the last compressed file. There is probably not enough
ECHO disk space on drive %2 for all of the demo files.
ECHO 
ECHO You should either free-up some disk space on drive %2 and re-install the demo,
ECHO or you should install Market Center/Market Monitor 5.0 on another drive.
ECHO 
ECHO Contact Bonneville Market Information at 1-800-255-7374 for assistance.
ECHO 
GOTO END

:ERROR1
ECHO 
ECHO 
ECHO The installation program is having trouble installing the demo. Please call
ECHO Bonneville Market Information at 1-800-255-7374 for assistance.
ECHO 
GOTO END

:END
