
			'---------------
			'   QELIB.BAS
			'---------------

'-----------------------------------------------------------
'  Copyright: 1988-1993 Pioneer Software Systems, Inc.
'	This software contains confidential and	proprietary
'	information of Pioneer Software Systems, Inc.
'-----------------------------------------------------------

' Result Code Values.  All routines which return a result code will return a
' value from this set. This also defines the set of values which will be
' returned from qeErr

Global Const qeLOCK_CHANGE_REC = -8	' Attempt to lock a record and
					' the lock was obtained, but the
					' record has been changed since it
					' was originally read.  This can
					' only occur for dbms that require
					' a log file.
Global Const qeLOCK_MULTI_REC =  -7	' Attempt to lock a record and
					' the lock was obtained, but more
					' than one record was locked. This
					' occured because the primary key
					' fields caused more than one
					' record to be selected.
Global Const qeLOCK_NO_REC =     -6	' Attempt to lock a record, but
					' no record in the database was
					' selected by the primary key,
					' the record has been deleted by
					' another user, or another user
					' has changed the value of a
					' key field.
Global Const qeEOF =		-5	' No more records to read.
Global Const qeUSER_CANCELLED = -4	' User cancelled out of the logon
					' dialog box.
Global Const qeOUT_OF_MEMORY =  -3	' Insufficient memory for operation
Global Const qeNULL_DATA =	-2	' NULL value.  Returned as the
					' length from a qeDataLen call
Global Const qeTRUNCATION =	-1	' The buffer passed in to hold
					' a result is not large
					' enough to hold the result.
					' A partial result has been
					' returned in the buffer.
Global Const qeSUCCESS =	0	' Success
Global Const qeSUCCESS_WITH_INFO = 1	' Success with information(warning)
Global Const qeNO_DATA_WITH_INFO = 2	' EOF with additional information
					' (usually ESC during a fetch)
Global Const qeDBSYS_ERROR =	4	' Error detected by the underlying
					' database system or driver. The
					' native error returned by qeDBErr
					' gives more specifics.

' QELIB Data Types.  These are the values returned from qeColType

Global Const qeCHAR =		1	' Blank padded fixed length string
Global Const qeVARCHAR =	2	' Variable length string
Global Const qeDECIMAL =	3	' BCD number
Global Const qeINTEGER =	4	' 4-byte signed integer
Global Const qeSMALLINT =	5	' 2-byte signed integer
Global Const qeFLOAT =		6	' 4-byte floating point
Global Const qeDOUBLEPRECISION = 7	' 8-byte floating point
Global Const qeDATETIME =	8	' 26-byte date time value
					' YYYY-MM-DD HH:MM:SS.FFFFFF

' Native data types. These types, plus the 8 QELIB types, are the values
' returned by qeColDBType.

Global Const qeLONGVARCHAR =	100	' Large text fields
Global Const qeBINARY =		101	' Fixed length binary or raw data
Global Const qeVARBINARY =	102	' Variable length binary data
Global Const qeLONGVARBINARY =	103	' Large binary data fields
Global Const qeNATIONALCHAR =	104	' Fixed length char strings may
					' have 2-byte chars (e.g. Kanji)
Global Const qeVARNATIONALCHAR =105	' Variable length national strings
Global Const qeLONGVARNATIONALCHAR =106	' Large national strings
Global Const qeNUMERIC =	107	' Numeric, no fixed scale
Global Const qeBIGINT =		108	' 8-byte signed integer
Global Const qeTINYINT =	109	' 1-byte signed integer
Global Const qeBIT =		110	' Bit value (0 or 1)
Global Const qeDATE =		111	' Date
Global Const qeTIME =		112	' Time
Global Const qeRECID =		113	' Unique row ID
Global Const qeRECVER =		114	' Row version number
Global Const qeSERIAL =		115	' Automatically generated
					' sequential number
Global Const qeMONEY =		116	' Money


'-----------
' Routines 
'-----------

'--------------------------
' Data dictionary routines
'--------------------------
Declare Function qeSources Lib "qelib.dll" (ByVal options%) As Integer
Global Const qeSRC_AVAIL_LOGON = 1	' All Sources
Global Const qeSRC_CONN_LOGON =	2	' All Connected Sources

Global Const qeSRC_NUM_COLS = 	4	' Number of columns returned
Global Const qeSRC_NAME_COL =	1	' Source name
Global Const qeSRC_EXT_COL =	2
Global Const qeSRC_HDBC_COL =	3	' QELIB HDBC
Global Const qeSRC_REMARKS_COL =4	' Remarks

Global Const qeSRC_MAX_LEN =	32	' Maximum length of a source name
Global Const qeSRC_REMARK_MAX_LEN = 256	' Maximum length of a remark field

Declare Function qeDatabases Lib "qelib.dll" (ByVal hdbc%) As Integer
Global Const qeDB_NUM_COLS =	2	' Number of columns returned
Global Const qeDB_DATABASE_COL =1	' Database name
Global Const qeDB_REMARKS_COL =	2	' Remarks

Global Const qeDB_MAX_LEN =	128	' Maximum length of a database name
Global Const qeDB_REMARK_MAX_LEN = 256	' Maximum length of a remark field

Declare Function qeTables Lib "qelib.dll" (ByVal hdbc%, ByVal qualifier_pattern$, ByVal user_pattern$, ByVal table_pattern$, ByVal options%) As Integer

Global Const qeTBL_TABLE =	&H0001		' Get table names
Global Const qeTBL_VIEW =	&H0002		' Get view names
Global Const qeTBL_PROCEDURE =	&H0004		' Get stored procedure names
Global Const qeTBL_SYSTABLE =	&H0008		' Get system table names
Global Const qeTBL_SYNONYM =	&H0010		' Get synonym names
Global Const qeTBL_DATABASE =	&H0080		' Get database names

Global Const qeTBL_NUM_COLS =		5	' Number of columns returned
Global Const qeTBL_TABLE_QUAL_COL =	1	' Table qualifier
Global Const qeTBL_TABLE_OWNER_COL =	2	' Table owner
Global Const qeTBL_TABLE_NAME_COL =	3	' Table name
Global Const qeTBL_TYPE_COL =		4	' Type of item returned
Global Const qeTBL_REMARK_COL =		5	' Remarks

Global Const qeUSER_MAX_LEN =	128	' Maximum length of a user name
Global Const qeTBL_MAX_LEN =	128	' Maximum length of a table/file/qual
					' name
Global Const qeMAX_REMARK_LEN =	256	' Maximum length of a remark fields

Declare Function qeColumns Lib "qelib.dll" (ByVal hdbc%, ByVal table_name$) As Integer
Global Const qeCOL_NUM_COLS =	    12	' Number of columns in record

Global Const qeCOL_TABLE_QUAL_COL = 1	' Table qualifier
Global Const qeCOL_TABLE_OWN_COL =  2	' Table owner
Global Const qeCOL_TABLE_NAME_COL = 3	' Table name
Global Const qeCOL_NAME_COL =	    4	' Column name
Global Const qeCOL_TYPE_COL =	    5	' Column type
Global Const qeCOL_WIDTH_COL =	    6	' Column width
Global Const qeCOL_DBTYPE_COL =     7	' Column database type
Global Const qeCOL_DBTYPE_NAME_COL =8	' Column database type name
Global Const qeCOL_ATTR1_COL =	    9	' Column precision/date start
Global Const qeCOL_ATTR2_COL =	    10	' Column scale/date end
Global Const qeCOL_NULLABLE_COL =   11	' Column nullable
Global Const qeCOL_REMARKS_COL =    12	' Column remarks

' Maximum length of returned char column value (not including 0-terminator)
 
Global Const qeCOL_MAX_LEN =	    128	' Maximum length of a column name


Declare Function qeTypeInfo Lib "qelib.dll" (ByVal hdbc%) As Integer
' Number of columns & column numbers

Global Const qeTYPE_NUM_COLS =	     16	' Number of columns in record

Global Const qeTYPE_TYPE_NAME_COL =  1	' Database type name
Global Const qeTYPE_TYPE_COL =	     2	' QELIB type
Global Const qeTYPE_DBTYPE_COL =     3	' Database type
Global Const qeTYPE_WIDTH_COL =      4	' Bytes to represent type
Global Const qeTYPE_ATTR1_COL =      5	' Precision/ date start
Global Const qeTYPE_ATTR2_COL =      6	' Scale/ date end
Global Const qeTYPE_LIT_PREFIX_COL = 7	' Literal prefix
Global Const qeTYPE_LIT_SUFFIX_COL = 8	' Literal suffix
Global Const qeTYPE_CREATE_PARAM_COL =9	' Parameters in create table stmt
Global Const qeTYPE_NULLABLE_COL =   10	' If type is nullable
Global Const qeTYPE_CASE_SENS_COL =  11	' If type is case-sensitive for sort
Global Const qeTYPE_SEARCHABLE_COL = 12	' If type can appear in WHERE clause
Global Const qeTYPE_UNSIGNED_COL =   13	' If type is unsigned
Global Const qeTYPE_MONEY_COL =      14	' If type is a money type
Global Const qeTYPE_AUTO_INCRE_COL = 15	' If type is auto-incrementing
Global Const qeTYPE_LOCAL_NAME_COL = 16	' Local type name

' Maximum length of returned char column value (not including 0-terminator)
 
Global Const qeTYPE_MAX_LEN =	     128 ' Maximum length of a column name


Declare Function qeProcedureColumns Lib "qelib.dll" (ByVal hdbc%, ByVal proc_name$) As Integer
' Number of columns & column numbers

Global Const qePROC_NUM_COLS =	     12	' Number of columns in result

Global Const qePROC_QUAL_COL =	     1	' Procedure qualifier
Global Const qePROC_OWN_COL =	     2	' Procedure owner
Global Const qePROC_NAME_COL =	     3	' Procedure name
Global Const qePROC_COL_NAME_COL =   4	' Column name
Global Const qePROC_TYPE_COL =	     5	' IN, OUT or IN/OUT
Global Const qePROC_DATA_TYPE_COL =  6	' Data type
Global Const qePROC_DBTYPE_NAME_COL =7	' Database type name
Global Const qePROC_WIDTH_COL =      8	' Width in bytes
Global Const qePROC_ATTR1_COL =      9	' Precision / date start
Global Const qePROC_ATTR2_COL =      10	' Scale / date end
Global Const qePROC_NULLABLE_COL =   11	' If column can be NULL
Global Const qePROC_REMARKS_COL =    12	' Remarks for column

' Maximum length of returned char column values (not including 0-terminator)
 
Global Const qePROC_MAX_LEN =	     128 ' Maximum length of a column name

' Values for the Col Type column
Global Const qePARAM_UNKNOWN =	     1	' Don't know
Global Const qePARAM_INPUT =	     2	' Column only an input parameter
Global Const qePARAM_INOUT =	     3	' Column is an input/output param
Global Const qeRESULT_COL =	     4	' Column only an output parameter


'--------------------------
' Error Handling functions
'--------------------------

Declare Function qeErr Lib "qelib.dll" () As Integer

Declare Function qeDBErr Lib "qelib.dll" () As Long

Declare Function qeWarning Lib "qelib.dll" () As Integer

Declare Function qeErrMsgBuf Lib "qelib.dll" (ByVal msg_buf$) As Integer
Global Const qeMAX_ERR_MSG_LEN = 512	' Maximum length of an error message

'---------------------
' Debugging functions
'---------------------

Declare Function qeTraceOn Lib "qelib.dll" (ByVal pathname$)  As Integer

Declare Function qeTraceOff Lib "qelib.dll" () As Integer

Declare Function qeSetTraceOptions Lib "qelib.dll" (ByVal flags%) As Integer
Declare Function qeGetTraceOptions Lib "qelib.dll" () As Integer
Global Const qeTRACE_NON_VAL_CALLS =&H0001 ' Trace all calls except qeValXXX
Global Const qeTRACE_USER =	&H0002 ' Write calls from qeTraceUser
Global Const qeTRACE_VAL_CALLS =&H0004 ' Trace qeValXXX calls
Global Const qeTRACE_WINDOW =	&H0008 ' Write trace info to a window
Global Const qeTRACE_ODBC =	&H0010 ' Tell ODBC driver to turn on tracing

Declare Function qeTraceUser Lib "qelib.dll" (ByVal trace_string$) As Integer

Declare Function qeSetDriverTracefile Lib "qelib.dll" (ByVal hdbc%, ByVal pathname$) As Integer

'-------------------------------
' Task functions		
'-------------------------------

'--------------------------------------------------------------------------
Declare Function qeLibInit Lib "qelib.dll" () As Integer

Declare Function qeLibTerm Lib "qelib.dll" () As Integer

'-------------------------------
' Database Connection functions
'-------------------------------

Declare Function qeConnect Lib "qelib.dll" (ByVal con_string$) As Integer

Declare Function qeDisconnect Lib "qelib.dll" (ByVal hdbc%) As Integer

Declare Function qeSetLoginTimeout Lib "qelib.dll" (ByVal seconds&) As Integer

Declare Function qeGetLoginTimeout Lib "qelib.dll" () As Long

Declare Function qeSetDB Lib "qelib.dll" (ByVal hdbc%, ByVal db_name$) As Integer

'-------------------------
' SQL execution functions
'-------------------------

Declare Function qeSQLPrepare Lib "qelib.dll" (ByVal hdbc%, ByVal sql_stmt$) As Integer

Declare Function qeSQLExecute Lib "qelib.dll" (ByVal hstmt%) As Integer

Declare Function qeExecSQL Lib "qelib.dll" (ByVal hdbc%, ByVal sql_stmt$) As Integer

Declare Function qeSetSQL Lib "qelib.dll" (ByVal hdbc%, ByVal sql_stmt$) As Integer

Declare Function qeAppendSQL Lib "qelib.dll" (ByVal hdbc%, ByVal sql_stmt$) As Integer

Declare Function qeEndSQL Lib "qelib.dll" (ByVal hstmt%) As Integer

Declare Function qeNumModRecs Lib "qelib.dll" (ByVal hstmt%) As Long 

'-----------------------------
' Column Definition functions
'-----------------------------

Declare Function qeNumCols Lib "qelib.dll" (ByVal hstmt%) As Integer

Declare Function qeColNameBuf Lib "qelib.dll" (ByVal hstmt%, ByVal dest_buf$, ByVal col_num%) As Integer

Declare Function qeColAliasBuf Lib "qelib.dll" (ByVal hstmt%, ByVal buffer$, ByVal col_num%) As Integer

Declare Function qeColExprBuf Lib "qelib.dll" (ByVal hstmt%, ByVal buffer$, ByVal col_num%) As Integer

Declare Function qeColType Lib "qelib.dll" (ByVal hstmt%, ByVal col_num%) As Integer

Declare Function qeColDBType Lib "qelib.dll" (ByVal hstmt%, ByVal col_num%) As Integer

Declare Function qeColWidth Lib "qelib.dll" (ByVal hstmt%, ByVal col_num%) As Long

Declare Function qeColPrecision Lib "qelib.dll" (ByVal hstmt%, ByVal col_num%) As Integer

Declare Function qeColScale Lib "qelib.dll" (ByVal hstmt%, ByVal col_num%) As Integer

Declare Function qeColDateStart Lib "qelib.dll" (ByVal hstmt%, ByVal col_num%) As Integer

Declare Function qeColDateEnd Lib "qelib.dll" (ByVal hstmt%, ByVal col_num%) As Integer

Declare Function qeColTypeAttr Lib "qelib.dll" (ByVal hstmt%, ByVal col_num%, ByVal attribute%) As Integer

Global Const qeCOL_UNKNOWN =		100

Global Const qeATTRIBUTE_UPDATABLE =	1

Global Const qeCOL_READ_ONLY =		0
Global Const qeCOL_WRITABLE =		1

Global Const qeATTRIBUTE_NULLABLE = 	2

Global Const qeCOL_NOT_NULLABLE	=	0
Global Const qeCOL_NULLABLE =		1

Global Const qeATTRIBUTE_SEARCHABLE =	3

Global Const qeCOL_UNSEARCHABLE	=	0
Global Const qeCOL_LIKE_ONLY =		1
Global Const qeCOL_ALL_EXCEPT_LIKE =	2
Global Const qeCOL_SEARCHABLE =		3

Global Const qeATTRIBUTE_UNSIGNED =	4

Global Const qeCOL_SIGNED =		0
Global Const qeCOL_UNSIGNED =		1

Global Const qeATTRIBUTE_MONEY =	5

Global Const qeCOL_NOT_MONEY =		0
Global Const qeCOL_MONEY =		1

Global Const qeATTRIBUTE_AUTO_INCRE =	6

Global Const qeCOL_NOT_AUTO_INCRE =	0
Global Const qeCOL_AUTO_INCRE =		1

Declare Function qeColDBTypeNameBuf Lib "qelib.dll" (ByVal hstmt%, ByVal dest_buf$, ByVal col_num%) As Integer

'-------------------------
' Data Fetching functions
'-------------------------

Declare Function qeFetchSetOptions Lib "qelib.dll" (ByVal hstmt%, ByVal options&) As Integer

Declare Function qeFetchGetOptions Lib "qelib.dll" (ByVal hstmt%) As Long

Global Const qeFETCH_FORWARD =	   &H00	' Only Fetch Next is allowed
Global Const qeFETCH_RANDOM =	   &H01	' Whether Random and Previous fetching
					' is enabled.
Global Const qeFORCE_LOG =	   &H02	' Whether to force a log file when it
					' is not required.

Declare Function qeSetSelectOptions Lib "qelib.dll" (ByVal hdbc%, ByVal options&) As Integer

Declare Function qeGetSelectOptions Lib "qelib.dll" (ByVal hdbc%) As Long

' Option flag values for qeSet/GetSelectOptions

Global Const qeFETCH_FORWARD_DIR = &H01
Global Const qeFETCH_ANY_DIR =	   &H02

Global Const qeLOG_IF_NEEDED =	   &H08
Global Const qeLOG_ALWAYS =	   &H10

Global Const qeCURSOR_INVALIDATE = &H20	' disable fetching at EOT
Global Const qeCURSOR_TRUNCATE =   &H40	' truncate the cursor at EOT
Global Const qeCURSOR_PERSIST =    &H60	' cursor persists at EOT

Declare Function qeSetOneHstmtPerHdbcOptions Lib "qelib.lib" (ByVal hdbc%, ByVal options&) As Integer

Declare Function qeGetOneHstmtPerHdbcOptions Lib "qelib.lib" (ByVal hdbc%) As Long

' Option flag values for qeSet/GetOneHstmtPerHdbcOptions

Global Const qeREADAHEAD_AT_EXEC =        &H0001 'Read entire solution set into
					         'log at execute time
Global Const qeREADAHEAD_AT_UPDATE =	  &H0002 ' Read remainder of solution
						 ' set into log at update,
						 ' delete, or lock
Global Const qeREADAHEAD_COMMIT_UPDATES = &H0003 ' All updates must be 
						 ' committed before any 
						 ' additional fetching

Global Const qeROUTING_READ =		  &H0008 ' Sends the statement to a
						 ' read connection.
Global Const qeROUTING_UPDATE =		  &H0010 ' Sends the statement to the
						 ' transaction connection
Global Const qeROUTING_DEFAULT =	  &H0018 ' Lets qelib decide which
						 ' connection to send the
						 ' statement

Global Const qeHSTMT_LOCAL =		  &H0020 ' States that this hstmt
						 ' cannot affect any other
						 ' active hstmts in the same
						 ' app
Global Const qeHSTMT_NONLOCAL =		  &H0040 ' States that this hstmt may
						 ' affect other hstmts in the
						 ' same app

Declare Function qeRecNum Lib "qelib.dll" (ByVal hstmt%) As Long

Declare Function qeRecState Lib "qelib.dll" (ByVal hstmt%) As Integer

' Return state of current record, from the values defined below

Global Const qeSTATE_NEW =	1 ' A new record which has not been sent to
				  ' the database
Global Const qeSTATE_UNCHANGED =2 ' Record has no changes waiting to be
				  ' sent to the database
Global Const qeSTATE_CHANGED =	3 ' Record has changes waiting to be sent
				  ' to the database
Global Const qeSTATE_NOREC =	4 ' The cursor is not currently positioned
				  ' on a record
Global Const qeSTATE_NEW_CHANGED = 5 ' A new record which has not been sent to
				  ' the database, and which has fields which
				  ' have been updated

Declare Function qeFetchLogClose Lib "qelib.dll" (ByVal hstmt%) As Integer

Declare Function qeFetchNext Lib "qelib.dll" (ByVal hstmt%) As Integer

Declare Function qeFetchPrev Lib "qelib.dll" (ByVal hstmt%) As Integer

Declare Function qeFetchRandom Lib "qelib.dll" (ByVal hstmt%, ByVal rec_num&) As Integer

Declare Function qeFetchNumRecs Lib "qelib.dll" (ByVal hstmt%) As Long

Declare Function qeDataLen Lib "qelib.dll" (ByVal hstmt%) As Long

Declare Function qeValCharBuf Lib "qelib.dll" (ByVal hstmt%, ByVal dest_buf$, ByVal col_num%, ByVal format_string$, ByVal max_len%) As Integer

Declare Function qeValMultiCharBuf Lib "qelib.dll" (ByVal hstmt%, ByVal dest_buf$, ByVal start_col_num%, ByVal end_col_num%, ByVal num_fmt_string$, ByVal date_fmt_string$, ByVal separator$) As Integer

Declare Function qeValInt Lib "qelib.dll" (ByVal hstmt%, ByVal col_num%) As Integer

Declare Function qeValLong Lib "qelib.dll" (ByVal hstmt%, ByVal col_num%) As Long

Declare Function qeValFloat Lib "qelib.dll" (ByVal hstmt%, ByVal col_num%) As Single

Declare Function qeValDouble Lib "qelib.dll" (ByVal hstmt%, ByVal col_num%) As Double

Declare Function qeValDecimalBuf Lib "qelib.dll" (ByVal hstmt%, ByVal dest_buf$, ByVal col_num%, ByVal precision%, ByVal valscale%) As Integer


'-----------------------
' Update functions     
'-----------------------

Declare Function qeRecSetKey Lib "qelib.dll" (ByVal hstmt%, ByVal col_num%, ByVal is_key%) As Integer

Declare Function qeRecGetKey Lib "qelib.dll" (ByVal hstmt%, ByVal col_num%) As Integer

Declare Function qeRecNew Lib "qelib.dll" (ByVal hstmt%, ByVal record_num&) As Integer

Declare Function qeRecLock Lib "qelib.dll" (ByVal hstmt%) As Integer

Declare Function qeRecUpdate Lib "qelib.dll" (ByVal hstmt%) As Integer

Declare Function qeRecDelete Lib "qelib.dll" (ByVal hstmt%) As Integer

Declare Function qeRecUndo Lib "qelib.dll" (ByVal hstmt%) As Integer

Declare Function qePutChar Lib "qelib.dll" (ByVal hstmt%, ByVal col_num%, ByVal format_string$, ByVal new_val$) As Integer

Declare Function qePutBinary Lib "qelib.dll" (ByVal hstmt%, ByVal col_num%, ByVal new_val$, ByVal val_len&) As Integer

Declare Function qePutDecimal Lib "qelib.dll" (ByVal hstmt%, ByVal col_num%, ByVal precision%, ByVal valscale%, ByVal new_val$) As Integer

Declare Function qePutDouble Lib "qelib.dll" (ByVal hstmt%, ByVal col_num%, ByVal new_val#) As Integer

Declare Function qePutFloat Lib "qelib.dll" (ByVal hstmt%, ByVal col_num%, ByVal new_val!) As Integer

Declare Function qePutInt Lib "qelib.dll" (ByVal hstmt%, ByVal col_num%, ByVal new_val%) As Integer

Declare Function qePutLong Lib "qelib.dll" (ByVal hstmt%, ByVal col_num%, ByVal new_val&) As Integer

Declare Function qePutNull Lib "qelib.dll" (ByVal hstmt%, ByVal col_num%) As Integer

'-----------------------
' Transaction functions
'-----------------------

Declare Function qeBeginTran Lib "qelib.dll" (ByVal hdbc%) As Integer

Declare Function qeCommit Lib "qelib.dll" (ByVal hdbc%) As Integer

Declare Function qeRollback Lib "qelib.dll" (ByVal hdbc%) As Integer

'---------------------------
' Data Conversion Functions
'---------------------------

	'---------------------
	' To Hex String      
	'---------------------

Declare Function qeBinToHexBuf Lib "qelib.dll" (ByVal hex_value$, ByVal bin_value$, ByVal length%) As Integer

	'---------------------
	' From Hex String    
	'---------------------
Declare Function qeHexToBinBuf Lib "qelib.dll" (ByVal bin_value$, ByVal hex_value$, ByVal length&) As Integer

	'---------------------
	' To Character String
	'---------------------

Declare Function qeDateToCharBuf Lib "qelib.dll" (ByVal dest_buf$, ByVal value$, ByVal format_string$) As Integer

Declare Function qeIntToCharBuf Lib "qelib.dll" (ByVal dest_buf$, ByVal value%, ByVal format_string$) As Integer

Declare Function qeLongToCharBuf Lib "qelib.dll" (ByVal dest_buf$, ByVal value&, ByVal format_string$) As Integer

Declare Function qeFloatToCharBuf Lib "qelib.dll" (ByVal dest_buf$, ByVal value!, ByVal format_string$) As Integer

Declare Function qeDoubleToCharBuf Lib "qelib.dll" (ByVal dest_buf$, ByVal value#, ByVal format_string$) As Integer

Declare Function qeDecimalToCharBuf Lib "qelib.dll" (ByVal dest_buf$, ByVal value$, ByVal precision%, ByVal valscale%, ByVal format_string$) As Integer

	'------------
	'   To Date 
	'------------

Declare Function qeCharToDateBuf Lib "qelib.dll" (ByVal date_value$, ByVal char_value$, ByVal format_string$) As Integer

	'------------
	' To Integer
	'------------

Declare Function qeCharToInt Lib "qelib.dll" (ByVal value$, ByVal format_string$) As Integer

Declare Function qeLongToInt Lib "qelib.dll" (ByVal value&) As Integer

Declare Function qeFloatToInt Lib "qelib.dll" (ByVal value!) As Integer

Declare Function qeDoubleToInt Lib "qelib.dll" (ByVal value#) As Integer

Declare Function qeDecimalToInt Lib "qelib.dll" (ByVal value$, ByVal precision%, ByVal valscale%) As Integer

	'-----------------
	' To Long Integer
	'-----------------

Declare Function qeCharToLong Lib "qelib.dll" (ByVal value$, ByVal format_string$) As Long

Declare Function qeDateToLong Lib "qelib.dll" (ByVal value$) As Long

Declare Function qeIntToLong Lib "qelib.dll" (ByVal value%) As Long

Declare Function qeFloatToLong Lib "qelib.dll" (ByVal value!) As Long

Declare Function qeDoubleToLong Lib "qelib.dll" (ByVal value#) As Long

Declare Function qeDecimalToLong Lib "qelib.dll" (ByVal value$, ByVal precision%, ByVal valscale%) As Long

	'-------------------
	' To Floating Point
	'-------------------

Declare Function qeCharToFloat Lib "qelib.dll" (ByVal value$, ByVal format_string$) As Single

Declare Function qeIntToFloat Lib "qelib.dll" (ByVal value%) As Single

Declare Function qeLongToFloat Lib "qelib.dll" (ByVal value&) As Single

Declare Function qeDoubleToFloat Lib "qelib.dll" (ByVal value#) As Single

Declare Function qeDecimalToFloat Lib "qelib.dll" (ByVal value$, ByVal precision%, ByVal valscale%) As Single

	'------------------------------------
	' To Double Precision Floating Point
	'------------------------------------

Declare Function qeCharToDouble Lib "qelib.dll" (ByVal value$, ByVal format_string$) As Double

Declare Function qeDateToDouble Lib "qelib.dll" (ByVal value$) As Double

Declare Function qeIntToDouble Lib "qelib.dll" (ByVal value%) As Double

Declare Function qeLongToDouble Lib "qelib.dll" (ByVal value&) As Double

Declare Function qeFloatToDouble Lib "qelib.dll" (ByVal value!) As Double

Declare Function qeDecimalToDouble Lib "qelib.dll" (ByVal value$, ByVal precision%, ByVal valscale%) As Double

	'------------
	' To Decimal
	'------------

Declare Function qeCharToDecimalBuf Lib "qelib.dll" (ByVal dest_buf$, ByVal precision%, ByVal valscale%, ByVal value$, ByVal format_string$) As Integer

Declare Function qeIntToDecimalBuf Lib "qelib.dll" (ByVal dest_buf$, ByVal precision%, ByVal valscale%, ByVal value%) As Integer

Declare Function qeLongToDecimalBuf Lib "qelib.dll" (ByVal dest_buf$, ByVal precision%, ByVal valscale%, ByVal value&) As Integer

Declare Function qeFloatToDecimalBuf Lib "qelib.dll" (ByVal dest_buf$, ByVal precision%, ByVal valscale%, ByVal value!) As Integer

Declare Function qeDoubleToDecimalBuf Lib "qelib.dll" (ByVal dest_buf$, ByVal precision%, ByVal valscale%, ByVal value#) As Integer

'-----------------------
' System Info functions
'-----------------------

Declare Function qeVerNumBuf Lib "qelib.dll" (ByVal dest_buf$) As Integer

Declare Function qeSetupInfoBuf Lib "qelib.dll" (ByVal dest_buf$) As Integer

'-----------------------
' Find Functions	
'-----------------------

' Find operator definitions

Global Const qeFIND_LESS_THAN =		1
Global Const qeFIND_LESS_THAN_OR_EQ =	2
Global Const qeFIND_GREATER_THAN =	3
Global Const qeFIND_GREATER_THAN_OR_EQ =4
Global Const qeFIND_EQUAL =		5
Global Const qeFIND_NOT_EQUAL =		6
Global Const qeFIND_LIKE =		7
Global Const qeFIND_NOT_LIKE =		8
Global Const qeFIND_IN =		9

Declare Function qeRecClearConditions Lib "qelib.dll" (ByVal hstmt%) As Integer

Declare Function qeRecSetConditionBinary Lib "qelib.dll" (ByVal hstmt%, ByVal col_num%, ByVal oper%, ByVal value$, ByVal length%) As Integer

Declare Function qeRecSetConditionChar Lib "qelib.dll" (ByVal hstmt%, ByVal col_num%, ByVal oper%, ByVal value$, ByVal case_sens%) As Integer

Declare Function qeRecSetConditionDecimal Lib "qelib.dll" (ByVal hstmt%, ByVal col_num%, ByVal oper%, ByVal value$, ByVal precision%, ByVal valscale%) As Integer

Declare Function qeRecSetConditionDouble Lib "qelib.dll" (ByVal hstmt%, ByVal col_num%, ByVal oper%, ByVal value#) As Integer

Declare Function qeRecSetConditionFloat Lib "qelib.dll" (ByVal hstmt%, ByVal col_num%, ByVal oper%, ByVal value!) As Integer

Declare Function qeRecSetConditionLong Lib "qelib.dll" (ByVal hstmt%, ByVal col_num%, ByVal oper%, ByVal value&) As Integer

Declare Function qeRecSetConditionInt Lib "qelib.dll" (ByVal hstmt%, ByVal col_num%, ByVal oper%, ByVal value%) As Integer

Declare Function qeRecSetConditionNull Lib "qelib.dll" (ByVal hstmt%, ByVal col_num%, ByVal oper%) As Integer

Declare Function qeRecFind Lib "qelib.dll" (ByVal hstmt%, ByVal start_pos%, ByVal direction%) As Long

' Start position constants

Global Const	qeFIND_BEGIN =	1	' from beginning of result set
Global Const	qeFIND_END =	2	' from end of result set
Global Const	qeFIND_CURRENT =3	' from current position in result set

' Direction constants

Global Const qeFIND_BACKWARD =&H0001	' set this flag for backward finds
					' default is forward
Global Const qeFIND_SKIP_ROW =&H0002	' set this flag to skip the current row
					' meaningful only for qeFIND_CURRENT
					' default is to start with current row

Declare Function qeQBEPrepare Lib "qelib.dll" (ByVal hstmt%) As Integer

Declare Function qeClauseGetBuf Lib "qelib.dll" (ByVal hstmt%, ByVal which_clause%, ByVal clause_buf$) As Integer

' Clause defines

Global Const qeCLAUSE_WHERE =		1	' Return WHERE clause
Global Const qeCLAUSE_HAVING =		2	' Return HAVING clause
Global Const qeCLAUSE_GROUPBY =		3	' Return GROUP BY clause
Global Const qeCLAUSE_ORDERBY =		4	' Return ORDER BY clause
Global Const qeCLAUSE_COMPUTEBY =	5	' Return COMPUTE BY clause
Global Const qeCLAUSE_FROM =		6	' Return FROM clause
Global Const qeCLAUSE_OTHER =		7	' Return OTHER clause

Declare Function qeUniqueWhereClauseBuf Lib "qelib.dll" (ByVal hstmt%, ByVal clause_buf$) As Integer

Declare Function qeNativeSQLBuf Lib "qelib.dll" (ByVal hstmt%, ByVal clause_buf$) As Integer

'---------------------------------
' Parameter Bind and Set Routines
'---------------------------------

Declare Function qeClearParam Lib "qelib.dll" (ByVal hstmt%, ByVal param_num%) As Integer

Declare Function qeSetParamNull Lib "qelib.dll" (ByVal hstmt%, ByVal param_num%, ByVal datatype%, ByVal precision&, ByVal valscale%) As Integer

Global Const qeNO_DATA_TYPE =	0

Declare Function qeParamNum Lib "qelib.dll" (ByVal hstmt%, ByVal param_name$) As Integer

Declare Function qeSetParamBinary Lib "qelib.dll" (ByVal hstmt%, ByVal param_num%, ByVal value$, ByVal length&) As Integer

Declare Function qeSetParamChar Lib "qelib.dll" (ByVal hstmt%, ByVal param_num%, ByVal value$, ByVal max_len&) As Integer

Declare Function qeSetParamDate Lib "qelib.dll" (ByVal hstmt%, ByVal param_num%, ByVal value$) As Integer

Declare Function qeSetParamDateTime Lib "qelib.dll" (ByVal hstmt%, ByVal param_num%, ByVal value$, ByVal precision%) as Integer

Declare Function qeSetParamDecimal Lib "qelib.dll" (ByVal hstmt%, ByVal param_num%, ByVal value$, ByVal precision%, ByVal valscale%) As Integer

Declare Function qeSetParamDouble Lib "qelib.dll" (ByVal hstmt%, ByVal param_num%, ByVal value#) As Integer

Declare Function qeSetParamFloat Lib "qelib.dll" (ByVal hstmt%, ByVal param_num%, ByVal value!) As Integer

Declare Function qeSetParamInt Lib "qelib.dll" (ByVal hstmt%, ByVal param_num%, ByVal value%) As Integer

Declare Function qeSetParamLong Lib "qelib.dll" (ByVal hstmt%, ByVal param_num%, ByVal value&) As Integer

Declare Function qeSetParamTime Lib "qelib.dll" (ByVal hstmt%, ByVal param_num%, ByVal value$) as Integer

Declare Function qeNumParams Lib "qelib.dll" (ByVal hstmt%) As Integer

Declare Function qeMoreResults Lib "qelib.dll" (ByVal hstmt%) As Integer

'-----------------------
' ODBC Get Info Routines
'-----------------------

' Definitions for the qeGetInfo calls

Global Const qeINFO_ACTIVE_CONNECTIONS =	0	' Long	  
Global Const qeINFO_ACTIVE_STATEMENTS =		1	' Long	  
Global Const qeINFO_DRIVER_VER =		7	' Char	  
Global Const qeINFO_SEARCH_PATTERN_ESCAPE =	14	' Char	  
Global Const qeINFO_DATA_SOURCE_READ_ONLY =	25	' Char	  
Global Const qeINFO_EXPRESSIONS_IN_ORDERBY =	27	' Char	  
Global Const qeINFO_IDENTIFIER_CASE =		28	' Long	  
Global Const qeINFO_IDENTIFIER_QUOTE_CHAR = 	29	' Char	  
Global Const qeINFO_MAX_COLUMN_NAME_LEN	=	30	' Long	  
Global Const qeINFO_MAX_CURSOR_NAME_LEN =	31	' Long	  
Global Const qeINFO_MAX_OWNER_NAME_LEN =	32	' Long	  
Global Const qeINFO_MAX_PROCEDURE_NAME_LEN =	33	' Long	  
Global Const qeINFO_MAX_QUALIFIER_NAME_LEN =	34	' Long	  
Global Const qeINFO_MAX_TABLE_NAME_LEN =	35	' Long	  
Global Const qeINFO_OUTER_JOINS =		38	' Char	  
Global Const qeINFO_OWNER_TERM =		39	' Char	  
Global Const qeINFO_PROCEDURE_TERM =		40	' Char	  
Global Const qeINFO_QUALIFIER_NAME_SEPARATOR =	41	' Char	  
Global Const qeINFO_QUALIFIER_TERM =		42	' Char	  
Global Const qeINFO_TABLE_TERM =		45	' Char	  
Global Const qeINFO_CONVERT_FUNCTIONS =		48	' Long	  
Global Const qeINFO_NUMERIC_FUNCTIONS =		49	' Long	  
Global Const qeINFO_STRING_FUNCTIONS = 		50	' Long	  
Global Const qeINFO_SYSTEM_FUNCTIONS =		51	' Long	  
Global Const qeINFO_TIMEDATE_FUNCTIONS =	52	' Long	  

Declare Function qeGetODBCInfoLong Lib "qelib.dll" (ByVal hdbc%, ByVal opt%) As Long

Declare Function qeGetODBCInfoCharBuf Lib "qelib.dll" (ByVal hdbc%, ByVal opt%, ByVal value$) As Integer

'--------------
' Query Builder
'--------------

Declare Function qeQryBuilder Lib "qelib.dll" (ByVal hqry%, ByVal parent_window%, ByVal options%, ByVal init_dialog%) As Integer

' Definitions for options parameter

Global Const qeQRY_NO_COL_ALIAS =	&H0001 ' Column aliases disallowed
Global Const qeQRY_EXIT_AFTER_DLG =	&H0002 ' Exit after dialog is exited.
					       ' Valid only if initial
					       '  dialog is specified.
Global Const qeQRY_ALLOW_SRC_CHANGE =	&H0004 ' Source can be changed in file
					       '  open box.
Global Const qeQRY_SYSTABLES =		&H0008 ' List system tables in table
					       '  dialog box.
Global Const qeQRY_SYNONYMS =		&H0010 ' List synonyms in table
					       '  dialog box.
Global Const qeQRY_TABLES =	        &H0020 ' List tables in table
					       '  dialog box.
Global Const qeQRY_VIEWS =		&H0040 ' List views in table
					       '  dialog box.
Global Const qeQRY_NO_PARAMS =		&H0080 ' Disallow parameters.
Global Const qeQRY_BIG_ICONS =		&H0100 ' Use big icons in icon bar.
Global Const qeQRY_VALIDATE =		&H0200 ' Use database to validate SQL.
Global Const qeQRY_SAMPLE =		&H0400 ' Show sample values in
					       ' conditions dialog box.

' Definitions for init_dialog parameter

Global Const qeQRY_DEFAULT =	1	' Bring up the default initial
					'	dialog box.
Global Const qeQRY_FILE =	2	' File dialog box.
Global Const qeQRY_JOIN =	3	' Join dialog box.
Global Const qeQRY_SELECT =	4	' Select dialog box.
Global Const qeQRY_ORDER =	5	' Order By dialog box.
Global Const qeQRY_WHERE =	6	' Where By dialog box.
Global Const qeQRY_GROUP =	7	' Group dialog box.
Global Const qeQRY_HAVING =	8	' Having dialog box.
Global Const qeQRY_TEXT =	9	' Edit query text dialog box.

Declare Function qeQryAllocate Lib "qelib.dll" (ByVal hdbc%, ByVal statement$) As Integer

Declare Function qeQryPrepare Lib "qelib.dll" (ByVal hqry%) As Integer

Declare Function qeQryFree Lib "qelib.dll" (ByVal hqry%) As Integer

Declare Function qeQryOpenQueryFile Lib "qelib.dll" (ByVal pathname$) As Integer

Declare Function qeQrySaveQueryFile Lib "qelib.dll" (ByVal hqry%, ByVal pathname$) As Integer

Declare Function qeQryGetHdbc Lib "qelib.dll" (ByVal hqry%) As Integer

Declare Function qeQrySetHdbc Lib "qelib.dll" (ByVal hqry%, ByVal hdbc%) As Integer

Declare Function qeQryGetSourceBuf Lib "qelib.dll" (ByVal hqry%, ByVal source$) As Integer

Declare Function qeQrySetSource Lib "qelib.dll" (ByVal hqry%, ByVal source$) As Integer

Declare Function qeQryGetStmtBuf Lib "qelib.dll" (ByVal hqry%, ByVal stmt$) As Integer

Declare Function qeQrySetStmt Lib "qelib.dll" (ByVal hqry%, ByVal stmt$) As Integer

Declare Function qeQryGetNumParams Lib "qelib.dll" (ByVal hqry%) As Integer

Declare Function qeQrySetNumParams Lib "qelib.dll" (ByVal hqry%, ByVal num_params%) As Integer

Declare Function qeQryGetFileNameBuf Lib "qelib.dll" (ByVal hqry%, ByVal file_name$) As Integer

Declare Function qeQrySetFileName Lib "qelib.dll" (ByVal hqry%, ByVal file_name$) As Integer

Declare Function qeQryGetFileOffset Lib "qelib.dll" (ByVal hqry%) As Long

Declare Function qeQryGetParamNameBuf Lib "qelib.dll" (ByVal hqry%, ByVal param_num%, ByVal param_name$) As Integer

Declare Function qeQrySetParamName Lib "qelib.dll" (ByVal hqry%, ByVal param_num%, ByVal param_name$) As Integer

Declare Function qeQryGetParamType Lib "qelib.dll" (ByVal hqry%, ByVal param_num%) As Integer

Declare Function qeQrySetParamType Lib "qelib.dll" (ByVal hqry%, ByVal param_num%, ByVal param_type%) As Integer

' Definition of datatypes for parameters
Global Const qeQRYPARM_CHAR =		1
Global Const qeQRYPARM_NUM =		2
Global Const qeQRYPARM_DATE =		3
Global Const qeQRYPARM_TIME =		4
Global Const qeQRYPARM_DATETIME =	5
Global Const qeQRYPARM_LOGICAL =	6

Declare Function qeQryGetParamPromptBuf Lib "qelib.dll" (ByVal hqry%, ByVal param_num%, ByVal prompt$) As Integer

Declare Function qeQrySetParamPrompt Lib "qelib.dll" (ByVal hqry%, ByVal param_num%, ByVal prompt$) As Integer

Declare Function qeQryGetParamDefaultBuf Lib "qelib.dll" (ByVal hqry%, ByVal param_num%, ByVal param_default$) As Integer

Declare Function qeQrySetParamDefault Lib "qelib.dll" (ByVal hqry%, ByVal param_num%, ByVal param_default$) As Integer

Declare Function qeQryGetParamFormatBuf Lib "qelib.dll" (ByVal hqry%, ByVal param_num%, ByVal param_format$) As Integer

Declare Function qeQrySetParamFormat Lib "qelib.dll" (ByVal hqry%, Byval param_num%, ByVal param_format$) As Integer

'---------
' Options
'---------


Declare Function qeSetQueryTimeout Lib "qelib.dll" (ByVal hdbc%, ByVal seconds&) As Integer

Declare Function qeGetQueryTimeout Lib "qelib.dll" (ByVal hdbc%) As Long

Declare Function qeSetTableCaching Lib "qelib.dll" (ByVal hdbc%, ByVal setting%) As Integer

Declare Function qeGetTableCaching Lib "qelib.dll" (ByVal hdbc%) As Integer

' Definitions for setting

Global Const qeCACHE_PERMANENT = 1	' Turn caching on and set .INI file
					'	to have it remain on across
					'	sessions
Global Const qeCACHE_SESSION =	 2	' Turn caching on for this session
Global Const qeCACHE_OFF =	 3	' Turn caching off and set INIT file
					'	to have it remain off across
					'	sessions

Declare Function qeSetCacheFileName Lib "qelib.dll" (ByVal hdbc%, ByVal file_name$) As Integer

Declare Function qeSetMaxRows Lib "qelib.dll" (ByVal hdbc%, ByVal max_rows&) As Integer

Declare Function qeGetMaxRows Lib "qelib.dll" (ByVal hdbc%) As Long

Declare Function qeSetLockOptions Lib "qelib.dll" (ByVal hdbc%, ByVal options%) As Integer

Declare Function qeGetLockOptions Lib "qelib.dll" (ByVal hdbc%) As Integer

Global Const qeLOCK_COMPARE = 1	' Lock will compare current buffer with row
				' in logfile. Raise a warning if different.
Global Const qeLOCK_REFRESH = 2	' Lock will refresh the logfile with new
				'	values.

Declare Function qeSetAutoUpdate Lib "qelib.dll" (ByVal hstmt%, ByVal value%) As Integer

Declare Function qeGetAutoUpdate Lib "qelib.dll" (ByVal hdbc%) As Integer

' Values for qeSet/GetAutoUpdate
Global Const qeAUTOUPD_DISCARD = 1	' Modifications to the current
					' record will be discarded when
					' user moves off record.
Global Const qeAUTOUPD_DEFER =   2	' Modifications to the current
					' will be saved when user
					' moves off record.  They may
					' be applied to the database or
					' discarded by later calls.
Global Const qeAUTOUPD_UPDATE =  3	' Modifications to the current
					' record are immediately sent to
					' the database.

Declare Function qeSetIsolationLevel Lib "qelib.dll" (ByVal hdbc%, ByVal level%) As Integer

Declare Function qeGetIsolationLevel Lib "qelib.dll" (ByVal hdbc%) As Integer

Declare Function qeGetSupportedIsolationLevels Lib "qelib.dll" (ByVal hdbc%) As Integer

' Values for qeSet/GetIsolationLevel
Global Const qeISO_READ_UNCOMMITTED =  &H0001 ' Dirty read, non-repeatable
					      ' read, phantoms possible.
Global Const qeISO_READ_COMMITTED =    &H0002 ' Non-repeatable read, phantoms
					      ' possible
Global Const qeISO_REPEATABLE_READ =   &H0004 ' Repeatable read, phantoms
					      ' possible
Global Const qeISO_SERIALIZABLE =      &H0008 ' Repeatable read, no phantoms
Global Const qeISO_VERSIONING =        &H0010 ' Repeatable read, no phantoms,
					      ' more concurrency.

Declare Function qeUndoAll Lib "qelib.dll" (ByVal hstmt%) As Integer

Declare Function qeApplyAll Lib "qelib.dll" (ByVal hstmt%) As Integer

'--------------------------------
' Visual Basic specific functions
'--------------------------------
Global Const qeCREATE_HLSTR_FAILED = -1025

Declare Function qeVBFetchNext Lib "qelib.dll" (ByVal hstmt As Integer, VariantArray() As Variant, FormatStrings() As String, Errors() As Integer) As Integer

Declare Function qeVBFetchPrev Lib "qelib.dll" (ByVal hstmt As Integer, VariantArray() As Variant, FormatStrings() As String, Errors() As Integer) As Integer

Declare Function qeVBFetchRandom Lib "qelib.dll" (ByVal hstmt As Integer, ByVal rec_num As Long, VariantArray() As Variant, FormatStrings() As String, Errors() As Integer) As Integer

Declare Function qeVBPutRecord Lib "qelib.dll" (ByVal hstmt As Integer, VariantArray() As Variant, FormatStrings() As String, Errors() As Integer) As Integer

