
ViewManager subclass: #QELIBDemo
  instanceVariableNames: 
    'dir hdbc hstmt mode '
  classVariableNames: 
    'QELIB '
  poolDictionaries: '' !


!QELIBDemo class methods ! !



!QELIBDemo methods !
 
cleanUp: aPane

" End the query "
     QELIB qeEndSQL: hstmt.

" Disconnect from the database "
     QELIB qeDisconnect: hdbc.

" Free the DLL "
     QELIB qeLibTerm.
     QELIB free.
     self close!

deleteButton: aPane
     | result |

" Delete the current record "

     result := QELIB qeRecDelete: hstmt.
     result=0
        ifFalse:[^false].

" Fetch the next record (or prev record if at the end) "

     result := QELIB qeFetchNext: hstmt.
     result = 0
        ifFalse:[result := QELIB qeFetchPrev: hstmt].
     result = 0
        ifFalse:[^result].
     mode := 'update'.
     self fillFields!

drawButtons
" Draw the buttons on the form "

     self
         addSubpane: (
            Button new
            owner: self;
            when: #clicked perform: #firstButton:;
            contents: 'First';
            framingBlock: [ :box | (box leftTop rightAndDown: (270 @ 16))
               extentFromLeftTop: (72 @ 24) ]
         );
         addSubpane: (
            Button new
            owner: self;
            when: #clicked perform: #nextButton:;
            contents: 'Next';
            framingBlock: [ :box | (box leftTop rightAndDown: (270 @ 44))
               extentFromLeftTop: (72 @ 24) ]
         );
         addSubpane: (
            Button new
            owner: self;
            when: #clicked perform: #prevButton:;
            contents: 'Prev';
            framingBlock: [ :box | (box leftTop rightAndDown: (270 @ 72))
               extentFromLeftTop: (72 @ 24) ]
         );
         addSubpane: (
            Button new
            owner: self;
            when: #clicked perform: #deleteButton:;
            contents: 'Delete';
            framingBlock: [ :box | (box leftTop rightAndDown: (270 @ 100))
               extentFromLeftTop: (72 @ 24) ]
         );
         addSubpane: (
            Button new
            owner: self;
            when: #clicked perform: #updateButton:;
            contents: 'Update';
            framingBlock: [ :box | (box leftTop rightAndDown: (270 @ 128))
               extentFromLeftTop: (72 @ 24) ]
         );
         addSubpane: (
            Button new
            owner: self;
            when: #clicked perform: #newButton:;
            contents: 'New';
            framingBlock: [ :box | (box leftTop rightAndDown: (270 @ 156))
               extentFromLeftTop: (72 @ 24) ]
         );
         addSubpane: (
            Button new
            owner: self;
            when: #clicked perform: #exitButton:;
            contents: 'Exit';
            framingBlock: [ :box | (box leftTop rightAndDown: (270 @ 184))
               extentFromLeftTop: (72 @ 24) ]
            )!
  
drawFields
" Draw the fields on the form "

     self
         addSubpane: (
             ( EntryField new
                setName: 'edit1';
                owner: self;
                framingBlock: [ :box | (box leftTop rightAndDown: (120 @ 16))
                  extentFromLeftTop: (110 @ 24) ] )
          );
         addSubpane: (
             ( EntryField new
                setName: 'edit2';
                owner: self;
                framingBlock: [ :box | (box leftTop rightAndDown: (120 @ 44))
                  extentFromLeftTop: (110 @ 24) ] )
          );
         addSubpane: (
             ( EntryField new
                setName: 'edit3';
                owner: self;
                framingBlock: [ :box | (box leftTop rightAndDown: (120 @ 72))
                  extentFromLeftTop: (110 @ 24) ] )
          );
         addSubpane: (
             ( EntryField new
                setName: 'edit4';
                owner: self;
                framingBlock: [ :box | (box leftTop rightAndDown: (120 @ 100))
                  extentFromLeftTop: (110 @ 24) ] )
          );
         addSubpane: (
             ( EntryField new
                setName: 'edit5';
                owner: self;
                framingBlock: [ :box | (box leftTop rightAndDown: (120 @ 128))
                  extentFromLeftTop: (110 @ 24) ] )
          );
         addSubpane: (
             ( EntryField new
                setName: 'edit6';
                owner: self;
                framingBlock: [ :box | (box leftTop rightAndDown: (120 @ 156))
                  extentFromLeftTop: (110 @ 24) ] )
          );
         addSubpane: (
             ( EntryField new
                setName: 'edit7';
                owner: self;
                framingBlock: [ :box | (box leftTop rightAndDown: (120 @ 184))
                  extentFromLeftTop: (110 @ 24) ] )
          )!
  
drawText
" Draw the text on the form "

     self
         addSubpane: (
             ( StaticText new
                 setName: 'msg1';
                 contents: 'First Name:';
                 framingBlock: [ :box | (box leftTop rightAndDown: (20 @ 20))
                   extentFromLeftTop: (90 @ 18) ] )
         );
         addSubpane: (
             ( StaticText new
                 setName: 'msg2';
                 contents: 'Last Name:';
                 framingBlock: [ :box | (box leftTop rightAndDown: (20 @ 48))
                   extentFromLeftTop: (90 @ 18) ] )
         );
         addSubpane: (
             ( StaticText new
                 setName: 'msg3';
                 contents: 'Employee ID:';
                 framingBlock: [ :box | (box leftTop rightAndDown: (20 @ 76))
                   extentFromLeftTop: (90 @ 18) ] )
         );
         addSubpane: (
             ( StaticText new
                 setName: 'msg4';
                 contents: 'Hire Date:';
               framingBlock: [ :box | (box leftTop rightAndDown: (20 @ 104))
                 extentFromLeftTop: (90 @ 18) ] )
         );
         addSubpane: (
             ( StaticText new
                 setName: 'msg5';
                 contents: 'Salary:';
                 framingBlock: [ :box | (box leftTop rightAndDown: (20 @ 132))
                   extentFromLeftTop: (90 @ 18) ] )
         );
         addSubpane: (
             ( StaticText new
                 setName: 'msg6';
                 contents: 'Department:';
                 framingBlock: [ :box | (box leftTop rightAndDown: (20 @ 160))
                   extentFromLeftTop: (90 @ 18) ] )
         );
         addSubpane: (
             ( StaticText new
                 setName: 'msg7';
                 contents: 'Exempt:';
                 framingBlock: [ :box | (box leftTop rightAndDown: (20 @ 188))
                  extentFromLeftTop: (90 @ 18) ] )
         )!

exitButton: aPane
" Exit the form "

     self cleanUp: aPane.
     self close!
 
fillFields
" Fill the fields with data from the database "

     | value err errmsg|
     value := QELIB qeValChar: hstmt colnum: 1 fmtstring: '' asParameter maxlen: 0.
     ( self paneAt: 'edit1' ) contents: value.
     value := QELIB qeValChar: hstmt colnum: 2 fmtstring: '' asParameter maxlen: 0.
     ( self paneAt: 'edit2' ) contents: value.
     value := QELIB qeValChar: hstmt colnum: 3 fmtstring: '' asParameter maxlen: 0.
     ( self paneAt: 'edit3' ) contents: value.
     value := QELIB qeValChar: hstmt colnum: 4 fmtstring: 'MM/DD/YYYY' asParameter maxlen: 0.
     ( self paneAt: 'edit4' ) contents: value.
     value := QELIB qeValChar: hstmt colnum: 5 fmtstring: '' asParameter maxlen: 0.
     ( self paneAt: 'edit5' ) contents: value.
     value := QELIB qeValChar: hstmt colnum: 6 fmtstring: '' asParameter maxlen: 0.
     ( self paneAt: 'edit6' ) contents: value.
     value := QELIB qeValChar: hstmt colnum: 7 fmtstring: '##0' asParameter maxlen: 0.
     value='1'
        ifTrue:[value:='T']
        ifFalse:[value:='F'].
     ( self paneAt: 'edit7' ) contents: value.!

firstButton: aPane
" Read the first record "

     QELIB qeFetchRandom: hstmt recnum: 1.
     mode := 'update'.
     self fillFields!
  
newButton: aPane
" Set up the form for a new record "

" Clear the fields "
     ( self paneAt: 'edit1' ) contents: ''.
     ( self paneAt: 'edit2' ) contents: ''.
     ( self paneAt: 'edit3' ) contents: ''.
     ( self paneAt: 'edit4' ) contents: ''.
     ( self paneAt: 'edit5' ) contents: ''.
     ( self paneAt: 'edit6' ) contents: ''.
     ( self paneAt: 'edit7' ) contents: ''.
     mode := 'insert'!
   
nextButton: aPane
     | result |

" Fetch the next record "
     result := QELIB qeFetchNext: hstmt.
     result = 0
        ifFalse:[^result].
     mode := 'update'.
     self fillFields!
   
open
" Open the QELIB Demo window."

" QELIB Sample Application
   Copyright 1991-1993 Q+E Software.
   Written by David Motsinger "

   | result name err sql |

" Get the name of the data directory "
dir := Prompter prompt: 'Enter the name of the data directory' default: 'C:\QELIB'.
dir := dir, '\'.

" Connect to the QELIB DLL "
     QELIB := QELIBDLL open: 'QELIB.dll' asParameter.
     QELIB qeLibInit.
     hdbc := QELIB qeConnect: 'DRV=QEDBF' asParameter.
     QELIB qeSetSelectOptions: hdbc flags: 2.

" Execute the SQL query "
     sql := 'SELECT * FROM '.
     sql := sql, dir.
     sql := sql, 'EMP.DBF'.
     hstmt := QELIB qeExecSQL: hdbc stmt:  sql asParameter.

" Fetch the first record "
     QELIB qeFetchNext: hstmt.
     mode := 'update'.

" Draw the form "
     self label: 'QELIB Demo';
        when: #close perform: #cleanUp:;
        drawButtons;
        drawText;
        drawFields;
        openWindow.
     self fillFields!

prevButton: aPane
     | result |

" Fetch the previous record "
     result := QELIB qeFetchPrev: hstmt.
     result = 0
        ifFalse:[^result].
     mode := 'update'.
     self fillFields!
   
temp
        "comment"
    | temporaries |

"     QELIB := QELIBDLL open: 'QELIB.dll'.
     result := QELIB qeTraceOn: 'c:trace.out'.
     hdbc := QELIB qeConnect: 'DRV=QEDBF'.
     hstmt := QELIB qeExecSQL: hdbc stmt: 'select * from c:\QELIB\emp.dbf'.
     QELIB qeFetchNext: hstmt.
     name := QELIB qeValChar: hstmt colnum: 1 fmtstring: '' maxlen: 0.
     err := QELIB qeErr.
     QELIB qeEndSQL: hstmt.
     QELIB qeDisconnect: hdbc.
     QELIB qeTraceOff.
     QELIB free.
     MessageBox message: hdbc printString.
     MessageBox message: hstmt printString.
     MessageBox message: result printString.
     MessageBox message: name printString.
     MessageBox message: err printString. "!
   
updateButton: aPane
     | firstname lastname empid hiredate salary dept exempt err record |

" Get the values from the form "
     firstname := ( self paneAt: 'edit1' ) contents.
     lastname := ( self paneAt: 'edit2' ) contents.
     empid := ( self paneAt: 'edit3' ) contents.
     hiredate := ( self paneAt: 'edit4' ) contents.
     salary := ( self paneAt: 'edit5' ) contents.
     dept := ( self paneAt: 'edit6' ) contents.
     exempt := ( self paneAt: 'edit7' ) contents.

" Build the SQL statement "
     mode='update'
     ifFalse:[
        record := QELIB qeRecNum: hstmt.
        QELIB qeRecNew: hstmt recnum: record].

" Update each field "
     QELIB qePutChar: hstmt colnum: 1 fmtstring: '' asParameter newval: firstname asParameter.
     QELIB qePutChar: hstmt colnum: 2 fmtstring: '' asParameter newval: lastname asParameter.
     QELIB qePutChar: hstmt colnum: 3 fmtstring: '' asParameter newval: empid asParameter.
     QELIB qePutChar: hstmt colnum: 4 fmtstring: 'm//d//yy' asParameter newval: hiredate asParameter.
     QELIB qePutChar: hstmt colnum: 5 fmtstring: '' asParameter newval: salary asParameter.
     QELIB qePutChar: hstmt colnum: 6 fmtstring: '' asParameter newval: dept asParameter.
     QELIB qePutChar: hstmt colnum: 7 fmtstring: '' asParameter newval: exempt asParameter.

" Update the record and check for errors "
     QELIB qeRecUpdate: hstmt.
     err := QELIB qeErr.
     err=0
        ifFalse:[QELIB checkError.
                    ^false].
     mode := 'update'! !
