/***************************************************************************

	Database Connection Application:
	This program lets the user test different connection strings
	and SQL Statement.
	
	Q+E Software, Inc
	5540 Centerview Drive
	Suite 324
	Raleigh, NC  27606
		
	Tech Support : (919) 851-1152
	Fax          : (919) 859-9337
	BBS          : (919) 851-1381
	CompuServe   : GO QESOFT
		
***************************************************************************/

#include <windows.h>		/* required for all Windows applications */
#include "connect.h"		/* specific to this program */
#include "..\include\qelib.h"	/* function prototypes */

/* Global variables */

HANDLE	hInst = 0;		/* current instance */
HWND	hWnd = 0;		/* Main window handle. */
HMENU	hMenu = NULL;		/* Handle to menu */
HANDLE  hHourGlass = NULL;	/* Handle to hourglass cursor      */
HANDLE  hSaveCursor = NULL;	/* Current cursor handle      */
int	hdbc = 0;		/* Handle to a database connection */
int	hstmt = 0;		/* Handle to a SQL Statement */
HWND	hWndStaticConnect;	/* Handle to Static Text-"Connection string"*/
HWND	hWndStaticSQL;		/* Handle to Static Text-"SQL Statement " */
HWND	hWndEditConnect;	/* Handle to Edit Window-Connection string*/
HWND	hWndEditSQL;		/* Handle to Edit Window-SQL Statement */
HWND	hWndButton[3];		/* Handles to Connect, Disconnect, &
                                   Execute buttons */

LPSTR	ButtonText[] = {"Connect", "Disconnect", "Execute"};

int PASCAL WinMain(hInstance, hPrevInstance, lpCmdLine, nCmdShow)
HANDLE hInstance;		/* current instance */
HANDLE hPrevInstance;		/* previous instance */
LPSTR lpCmdLine;		/* command line */
int nCmdShow;			/* show-window type (open/icon) */
{
	MSG msg;			/* message */

	if (!hPrevInstance)		 /* Other instances of app running? */
	if (!InitApplication(hInstance)) /* Initialize shared things */
		return (FALSE);		 /* Exits if unable to initialize */

/* Perform initializations that apply to a specific instance */

	if (!InitInstance(hInstance, nCmdShow)) return (FALSE);

/* Acquire and dispatch messages until a WM_QUIT message is received. */

	while (GetMessage(&msg,	NULL, NULL, NULL)) {
		TranslateMessage(&msg);	/* Translates virtual codes */
		DispatchMessage(&msg);	/* Dispatches message */
	}
	return (msg.wParam);   /* Returns value from PostQuitMessage */
}


BOOL InitApplication(hInstance)
HANDLE hInstance;			       /* current instance */
{
	WNDCLASS  wc;

/* Fill in window class structure with parameters that describe the */
/* main window.	*/

	wc.style = NULL;		/* Class style(s). */
	wc.lpfnWndProc = MainWndProc;	/* Function to retrieve messages */
					/* for windows of this class. */
	wc.cbClsExtra = 0;		/* No per-class extra data. */
	wc.cbWndExtra = 0;		/* No per-window extra data. */
	wc.hInstance = hInstance;	/* Application that owns the class. */
	wc.hIcon = LoadIcon(hInstance, "ExampleIcon");
	wc.hCursor = LoadCursor(NULL, IDC_ARROW);
	wc.hbrBackground = GetStockObject(WHITE_BRUSH); 
	wc.lpszMenuName =  "ConnectMenu";/* Name of menu resource in RC file*/
	wc.lpszClassName = "ConnectWClass";/* Used in call to CreateWindow*/

/* Register the window class and return success/failure code. */

	return (RegisterClass(&wc));

}

BOOL InitInstance(hInstance, nCmdShow)
	HANDLE	hInstance;		/* Current instance identifier. */
	int	nCmdShow;		/* Param for first ShowWindow() call*/
{
	FARPROC lpProcDataDir;	        /* Pointer to the DataDir funtion */
	int	result;			/* Result from dialog procedure */

/* Save the instance handle in global variable */

	hInst = hInstance;

/* Create a main window for this application instance. */

	hWnd = CreateWindow(
		"ConnectWClass",	/* See RegisterClass() call. */
		"Database Connection",/* Text for win title bar */
		WS_OVERLAPPEDWINDOW,	/* Window style */
		CW_USEDEFAULT,		/* Default horicontal pos. */
		CW_USEDEFAULT,		/* Default vertical position */
		CW_USEDEFAULT,		/* Default Width */
		CW_USEDEFAULT,		/* Default Height */
		NULL,			/* Overlapped windows have no parent*/
		NULL,			/* Use the window class menu. */
		hInstance,		/* This instance owns this window. */
		NULL			/* Pointer not needed. */
		);

/* If window could not be created, return "failure" */

	if (!hWnd) return (FALSE);

/* Get the menu & hourglass handles */
	
	hMenu = GetMenu(hWnd);
	hHourGlass = LoadCursor(NULL, IDC_WAIT);
	
/* Make the window visible; update its client area */

	ShowWindow(hWnd, nCmdShow | SW_SHOWMAXIMIZED);  /* Show the window */
	UpdateWindow(hWnd);          /* Sends WM_PAINT message */

	return (TRUE);	

}

long FAR PASCAL MainWndProc(hWnd, message, wParam, lParam)
HWND hWnd;				  /* window handle */
unsigned message;			  /* type of message */
WORD wParam;				  /* additional information */
LONG lParam;				  /* additional information */
{
	FARPROC		lpProcAbout;	/* pointer to the "About" function */
	int		result;		/* Result from dialog procedure */
	LPSTR		ptr;		/* Generic pointer to text */
	int		fatal = 0;	/* Flag for fatal errors */
	HDC		hDC;		/* Handle to device context */
	TEXTMETRIC	tm;		/* Text metric info */
	int		cxChar, cyChar;	/* Char width & height */
	int		i;		/* Generic loop counter */
	char		connect[256];   /* Connect string */
	char		sql[2048];	/* SQL Statement */
	

	switch (message) {
	case WM_CREATE:
		
/* Initialize QELIB */
		
		result = qeLibInit();
		if (result != qeSUCCESS) goto fatal_err;
		
/* Get text metric information */
		
		hDC = GetDC (hWnd);
		SelectObject (hDC, GetStockObject (SYSTEM_FIXED_FONT));
		GetTextMetrics (hDC, &tm);
		cxChar = tm.tmAveCharWidth;
		cyChar = tm.tmHeight + tm.tmExternalLeading;
		ReleaseDC (hWnd, hDC);
		
/* Create Static Text Windows and Edit Windows */
		
		hWndStaticConnect = CreateWindow (
			"static", "Connection String", WS_CHILD | WS_VISIBLE,
			cxChar, cyChar * 1,
			15 * cxChar, 7 * cyChar / 4,
			hWnd, 1, hInst, NULL);
		
		hWndEditConnect = CreateWindow (
			"edit",	"DSN=QEDBF", 
			WS_CHILD | WS_BORDER | ES_AUTOHSCROLL | WS_VISIBLE,
			cxChar, cyChar * (2 * 1),
			52 * cxChar, 7 * cyChar / 4,
			hWnd, 2, hInst, NULL);
		
		hWndStaticSQL = CreateWindow (
			"static", "SQL Statement", WS_CHILD | WS_VISIBLE,
			cxChar, cyChar * (1 + 2 * 2),
			15 * cxChar, 7 * cyChar / 4,
			hWnd, 3, hInst, NULL);

		hWndEditSQL = CreateWindow (
			"edit",	"SELECT * FROM C:\\QELIB\\EMP.DBF", 
			WS_CHILD | WS_BORDER | ES_AUTOHSCROLL | WS_VISIBLE |
			WS_HSCROLL | WS_VSCROLL | ES_LEFT | ES_MULTILINE,
			cxChar, cyChar * (2 * 3),
			52 * cxChar, 56 * cyChar / 4,
			hWnd, 4, hInst, NULL);
						
		
/* Create Connect, Disconnect, & Execute buttons*/

		for (i = 0; i < 3; i++) {
			hWndButton[i] = CreateWindow (
				"button", ButtonText[i],
				WS_CHILD | BS_PUSHBUTTON | WS_VISIBLE,
				57 * cxChar, cyChar * (2 * (i+1)),
				10 * cxChar, 7 * cyChar / 4,
				hWnd, 50 + i, hInst, NULL);
		}
		
/* Disable the Disconnect & Execute buttons */
		
		EnableWindow (hWndButton[1], FALSE);
		EnableWindow (hWndButton[2], FALSE);
		break;
		
	case WM_COMMAND:	   /* message: command from application menu*/
		switch (wParam) {
			
		case IDM_CONNECT:
		case BTN_CONNECT:

/* Change the cursor to the hourglass */
			
			hSaveCursor = SetCursor(hHourGlass);
			
/* Get connect string from Edit window */
			
			GetWindowText (hWndEditConnect, connect, 256);
			
/* Connect to database */
		
			hdbc = qeConnect (connect);
			
/* Set the cursor back to the arrow */
			
			SetCursor(hSaveCursor);
			
/* Check for errors */
			
			if (hdbc == 0) goto err;
			
/* Turn on the Disconnect & Execute menu choices */
/* Turn off the Connect menu choice */
				
			EnableMenuItem(hMenu, IDM_DISCONNECT, MF_ENABLED);
			EnableMenuItem(hMenu, IDM_EXECUTE, MF_ENABLED);
			EnableMenuItem(hMenu, IDM_CONNECT, MF_GRAYED);
			
/* Enable the Disconnect & Execute buttons */
/* Disable the Connect button */
		
			EnableWindow (hWndButton[1], TRUE);
			EnableWindow (hWndButton[2], TRUE);
			EnableWindow (hWndButton[0], FALSE);
			
			break;
			
		case IDM_DISCONNECT:
		case BTN_DISCONNECT:
			
/* Disconnect from database system */
			
			result = qeDisconnect (hdbc);
			if (result != qeSUCCESS) goto err;
			hdbc = 0;
			
/* Turn off the Disconnect & Execute menu choices */
/* Turn on the Connect menu choice */
		
			EnableMenuItem(hMenu, IDM_DISCONNECT, MF_GRAYED);
			EnableMenuItem(hMenu, IDM_EXECUTE, MF_GRAYED);
			EnableMenuItem(hMenu, IDM_CONNECT, MF_ENABLED);
			
/* Disable the Disconnect & Execute buttons */
/* Enable the Connect button */
		
			EnableWindow (hWndButton[1], FALSE);
			EnableWindow (hWndButton[2], FALSE);
			EnableWindow (hWndButton[0], TRUE);
			break;
			
		case IDM_EXECUTE:
		case BTN_EXECUTE:
/* Change the cursor to the hourglass */
			
			hSaveCursor = SetCursor(hHourGlass);
			
			
/* Get SQL Statement from Edit window */
			
			GetWindowText (hWndEditSQL, sql, 2048);
			
/* Execute the SQL Statement */
			
			hstmt = qeExecSQL (hdbc, sql);
			
/* Set the cursor back to the arrow */
			
			SetCursor(hSaveCursor);
			hSaveCursor = 0;
			
/* Check for errors */
			
			if (hstmt == 0)
				goto err;
			else 
				MessageBox(hWnd, "SQL Statment Executed", 
					"Success", MB_ICONINFORMATION|MB_OK);
			qeEndSQL (hstmt);
			
			break;
			
		case IDM_EXIT:
			DestroyWindow(hWnd);
			break;
		    
		case IDM_ABOUT:
			
/* Display the about box */
			
			lpProcAbout = MakeProcInstance(About, hInst);
			DialogBox(hInst, "AboutBox", hWnd, lpProcAbout);
			FreeProcInstance(lpProcAbout);
			break;
			
		default:
			return (DefWindowProc(hWnd, message, wParam, lParam));
			
		}
		break;
			
	case WM_DESTROY:		  /* message: window being destroyed*/
		
/* Disconnect from the database system (QEDBF) */
		
		if (hdbc) qeDisconnect(hdbc);
		
/* Terminate QELIB Session */
		
		qeLibTerm ();
		
/* Post QUIT message */
		
		PostQuitMessage(0);
		break;

	default:			  /* Passes it on if unproccessed */
		return (DefWindowProc(hWnd, message, wParam, lParam));
	}
	return (NULL);
	
fatal_err:
	fatal = TRUE;
err:
	if (hSaveCursor) {
		SetCursor(hSaveCursor);
		hSaveCursor = 0;
	}
	ptr = qeErrMsg();
	MessageBox(hWnd, ptr, NULL, MB_ICONEXCLAMATION | MB_OK);
	if (fatal) DestroyWindow(hWnd);
	return (FALSE);
}

BOOL FAR PASCAL About(hDlg, message, wParam, lParam)
HWND hDlg;                                /* window handle of the dialog box*/
unsigned message;                         /* type of message */
WORD wParam;                              /* message-specific information */
LONG lParam;
{
	switch (message) {
	case WM_INITDIALOG:		   /* message: initialize dialog box*/
		return (TRUE);

	case WM_COMMAND:			/* received a command */
		if (wParam == IDOK		/* "OK" box selected? */
		|| wParam == IDCANCEL) {	/* System menu close command*/
			EndDialog(hDlg, TRUE);	/* Exits the dialog box */
			return (TRUE);
		}
		break;
	}
	return (FALSE);			      /* Didn't process a message */
}

