/*-----------------------------------------
   FONTFILL.C -- Paths for Filling Fonts
                 (c) Charles Petzold, 1994
  -----------------------------------------*/

#include <windows.h>
#include <string.h>
#include "ezfont.h"

char szClass [] = "FontFill" ;
char szTitle [] = "FontFill: Paths for Filling Fonts" ;

void PaintRoutine (HWND hwnd, HDC hdc, int cxArea, int cyArea)
     {
     static char szString [] = "Filling" ;
     HFONT       hFont ;
     SIZE        size ;

     hFont = EzCreateFont (hdc, "Times New Roman", 1440, 0, 0, TRUE) ;

     SelectObject (hdc, hFont) ;
     SetBkMode (hdc, TRANSPARENT) ;

     GetTextExtentPoint (hdc, szString, strlen (szString), &size) ;

     BeginPath (hdc) ;
     TextOut (hdc, (cxArea - size.cx) / 2, (cyArea - size.cy) / 2,
              szString, strlen (szString)) ;

     EndPath (hdc) ;

     SelectObject (hdc, CreateHatchBrush (HS_DENSE4, RGB (255, 0, 0))) ;
     SetBkColor (hdc, RGB (0, 0, 255)) ;
     SetBkMode (hdc, OPAQUE) ;

     StrokeAndFillPath (hdc) ;

     DeleteObject (SelectObject (hdc, GetStockObject (WHITE_BRUSH))) ;
     SelectObject (hdc, GetStockObject (SYSTEM_FONT)) ;
     DeleteObject (hFont) ;
     }
