
(*
 * nozzinfo - Remove ZipZap File info entries from a DIR file
 *
 * SLe, 06-17-94
 * last edited: 07-20-94
 *)

{$v-}
uses DOS, Qread,tools,qtools;

const

   zzinfo_prefix1 = '                               | Files: ';
   zzinfo_prefix2 = '                               | Compression Ratio: ';
   zzinfo_prefix3 = '                               | Uncompressed Size: ';
   zzinfo_prefix4 = '                               | Uploaded by: ';
var
   infile:  string[65];
   tmpfile: string[65];
   bakfile: string[65];

   ibuf:    array[1..20480] of byte;
   obuf:    array[1..20480] of byte;

   remfiles, remcomp, remuncomp, remulby: LongInt;
   dontwrite : boolean;

(* --------------------------------------------------------- *)
procedure update_dirfile;
var
   ifd:     text;
   ofd:     text;
   line:    string;
   tmp:     string;
   d,n,e:   string[65];

begin
   infile := paramstr(1);
   fsplit(infile,d,n,e);
   tmpfile := d+n+'.tmp';
   bakfile := d+n+'.bak';

   assign(ifd,infile);
   {$i-} reset(ifd); {$i+}
   if ioresult <> 0 then
   begin
      writeln('Can''t open DIR file ',infile);
      halt(99);
   end;

   assign(ofd,tmpfile);
   {$i-} rewrite(ofd); {$i+}
   if ioresult <> 0 then
   begin
      writeln('Can''t create tempfile ',tmpfile);
      halt(99);
   end;

   setTextBuf(ifd,ibuf);
   setTextBuf(ofd,obuf);

   repeat
      qreadln(ifd,line,sizeof(line));
      dontwrite:=false;
      if (copy(stripatx(line),1,length(zzinfo_prefix1))=zzinfo_prefix1) then begin
       dontwrite:=true;
       inc(remfiles);
      end;
      if (copy(stripatx(line),1,length(zzinfo_prefix2))=zzinfo_prefix2) then begin
       dontwrite:=true;
       inc(remcomp);
      end;
      if (copy(stripatx(line),1,length(zzinfo_prefix3))=zzinfo_prefix3) then begin
       dontwrite:=true;
       inc(remuncomp);
      end;
      if (copy(stripatx(line),1,length(zzinfo_prefix4))=zzinfo_prefix4) then begin
       dontwrite:=true;
       inc(remulby);
      end;

      if not dontwrite then writeln(ofd,line);
   until eof(ifd);

   close(ifd);
   close(ofd);

   assign(ifd,bakfile);
   {$i-} erase(ifd); {$i+}
   if ioresult <> 0 then ;

   assign(ifd,infile);
   {$i-} rename(ifd,bakfile); {$i+}
   if ioresult <> 0 then
   begin
      writeln('Can''t backup ',infile);
      halt(99);
   end;

   assign(ifd,tmpfile);
   {$i-} rename(ifd,infile); {$i+}
   if ioresult <> 0 then
   begin
      writeln('Can''t rename ',tmpfile,' to ',infile);
      halt(99);
   end;

end;


(* --------------------------------------------------------- *)
begin


   if paramcount < 1 then
   begin
      writeln;
      writemciln('|09NOZZINFO v1.10 - (c) 1994 SLe (Q-Tip PCBoard Productions) ');
      writeln;
      writemciln('|11NOZZINFO removes the following:');
      writemciln('|03"Files: xx, New: xx.xx.xx, Old: xx.xx.xx"');
      writemciln('|03"Files: xx, Nfo: xx.xx.xx, Diz: xx.xx.xx"');
      writemciln('|03"Compression Ratio: xx%"');
      writemciln('|03"Uncompressed Size: xx bytes"');
      writemciln('|03"Uploaded by: xx"');
      writeln;
      writemciln('|02Usage:    |10NOZZINFO DIRFILENAME [/MONO]');
      writemciln('          |10NOZZINFO D:\PCB\CONFS\1\UPLD');
      writemciln('          |10/MONO = No Colors|07');
      halt(99);
   end;

   if upstring(paramstr(2))='/MONO' then cmono:=true;

   writeln;
   writemciln('|09NOZZINFO v1.10 - (c) 1994 SLe (Q-Tip PCBoard Productions) ');
   writemci('|08Removing Strings from Dirfile...');
   update_dirfile;
   writemciln('|08done!');
   writemciln('|07"Files: xx, N..."    was removed '+itoa(remfiles)+' times');
   writemciln('|07"Compression Ratio:" was removed '+itoa(remcomp)+' times');
   writemciln('|07"Uncompressed Size:" was removed '+itoa(remuncomp)+' times');
   writemciln('|07"Uploaded by: xx"    was removed '+itoa(remulby)+' times');
end.

