#include "sockets.h"

#define MAX_NUM_ERRS 80

HANDLE hInst;
int bInitialized=FALSE;
char far *local_hostname;
HGLOBAL hGlobalLocalHostName;
char strTmp[256];
int iSocketDebugLevel=0;
int iErrArray[MAX_NUM_ERRS];
int iErrIdx=0;

int FAR PASCAL LibMain(HANDLE hInstance,WORD wDataSeg,WORD wHeapSize,LPSTR lpszCmdLine) {
    hInst= hInstance;
    if (iSocketDebugLevel)
        OutputDebugString("NCSASOCK:LibMain \r\n");
    return(1);
}

void FAR PASCAL Wep(int ExitCode) {
    GlobalFree(hGlobalLocalHostName);
    if (iSocketDebugLevel)
        OutputDebugString("WINSOCK:WEP - bye bye");
}

u_long FAR PASCAL htonl( u_long hostlong) {
    return (longswap(hostlong));
}

u_short FAR PASCAL htons( u_short hostshort) {
    return (intswap(hostshort));
}

u_short FAR PASCAL ntohs( u_short netshort) {
    return (intswap(netshort));
}

u_long FAR PASCAL ntohl( u_long netlong) {
    return (longswap(netlong));
}

int FAR PASCAL WSAStartup (WORD wVersionRequired, LPWSADATA lpWSAData) {
    FARPROC lpfnNetworkTimerProc;

    if (wVersionRequired > 0x0101)
        return(WSAVERNOTSUPPORTED);
    if (bInitialized) return(0);
    if (!InitNetwork()) return(0);
    
    hStartOfSocketList = NULL;
    lpfnNetworkTimerProc= (TIMERPROC) MakeProcInstance((FARPROC)NetworkTimerProc,hInst);
    SetTimer(NULL,NETWORK_TIMER,NETWORK_TIMER_INTERVAL,lpfnNetworkTimerProc);
    
    hGlobalLocalHostName=GlobalAlloc(GPTR,128);
    local_hostname=GlobalLock(hGlobalLocalHostName);
    GetPrivateProfileString("local_host","name","",local_hostname,128,"ncsa_net.ini");
    bInitialized=TRUE;
    if (lpWSAData) {
        lpWSAData->wVersion = 0x0101;
        lpWSAData->wHighVersion = 0x0101;
        lpWSAData->szDescription[0]='\0';
        lpWSAData->szSystemStatus[0]='\0';
        lpWSAData->iMaxSockets=200;
        lpWSAData->iMaxUdpDg=1;
        lpWSAData->lpVendorInfo=NULL;
    }
    return (0);
}

/****************************************************************************
 * GetSocketFromTelID                                                       *
 *  Gets the socket associated with a TelID.  If the ID is not found, a -1  *
 *  is returned.                                                            *
 ****************************************************************************/
hSOCKLIST GetSocketFromTelID(int searchID){
    hSOCKLIST hCurPos, hNextPos;
    SocketIDList far * pCurPos;
    
    hCurPos = hStartOfSocketList;
    pCurPos = (SocketIDList far *)GlobalLock(hCurPos);
    while (pCurPos != NULL) {
        if (pCurPos->telnetID == searchID) {
            GlobalUnlock(hCurPos);
            return(hCurPos);
        } else {
            hNextPos = pCurPos->hNextElement;
            GlobalUnlock(hCurPos);
            hCurPos=hNextPos;
            pCurPos=(SocketIDList far *)GlobalLock(hCurPos);
        }
    }
    return(NULL);
}
    
void CALLBACK NetworkTimerProc(HWND hWnd, WORD msg, WORD wParam, LONG lParam) {
    int ev,what,dat;
    hSOCKLIST hSock;
    SocketIDList far *pSock;

    ev=Sgetevent(CONCLASS,(int FAR *)&what,(int FAR *)&dat);
    
    switch (ev) {
        case CONCLOSE:
            if (iSocketDebugLevel)
                OutputDebugString("CONCLOSE");
            hSock=GetSocketFromTelID(dat);
            if (hSock) {
                pSock=(SocketIDList far *)GlobalLock(hSock);
                if (pSock) {
                    closesocket(pSock->socketID);
                    GlobalUnlock(hSock);
                }
            }
            break;
        case CONOPEN:
            /* mark as CONOPEN Pending */
            hSock=GetSocketFromTelID(dat);
            if (iSocketDebugLevel)
                OutputDebugString("<CON_OPEN>");
            if (hSock) {
                pSock=(SocketIDList far *)GlobalLock(hSock);
                if (pSock) {
                    pSock->status=SOCK_CON_PENDING;
                    GlobalUnlock(hSock);
                }
            }
        default:
            if (ev) {
                if (iSocketDebugLevel>100) {
                    wsprintf(strTmp,"<what=%d ev=%d dat=%d>",what,ev,dat);
                    OutputDebugString(strTmp);
                }
                netputuev(what,ev,dat);
            }
            break;
    }    

    netsleep(0);
    return;
}


/******************************************************************************
 * Socket                                                                     *
 *  Parameters:                                                               *
 *    family   - The protocol family.  Only supports the AF_INET family       *
 *    type     - The type AF_INET that is desired. SOCK_STREAM and SOCK_DGRAM *
 *    protocol - The IPPROTO_TCP is the only one that's supported             *
 *                                                                            *
 *  Return value - The socket ID number                                       *
 ******************************************************************************/

SOCKET FAR PASCAL socket  (int family,int type,int protocol) {
    if (iSocketDebugLevel) {
        wsprintf(strTmp,"[Created socket %d]",SOCKET_COUNTER);    
        OutputDebugString(strTmp);
    }
    
#ifdef CHECK_TYPE
    if ((family == AF_INET) && (((type == SOCK_STREAM) && (protocol == IPPROTO_TCP)) ||
        ((type == SOCK_DGRAM) && (protocol == IPPROTO_UDP)))) {
        if (iSocketDebugLevel)
            OutputDebugString("Valid Socket request made \r\n");
#endif
 /* Since a valid socket is created, we need to remember that its a valid ID */

        AddToValidList((SOCKET)SOCKET_COUNTER,type);
        return((SOCKET)SOCKET_COUNTER++);
#ifdef CHECK_TYPE      
    } else {
        if (iSocketDebugLevel)
            OutputDebugString("Inavlid Socket request made");
        WSASetLastError(WSAESOCKTNOSUPPORT);
        return(SOCKET_ERROR);
    }
#endif        
}

/************************************************************************
 * AddToValidList                                                       *
 *  Adds the "newID" to the list of sockets that have been created and  *
 *  are currently in use.  Once the newID is allocated, the valid       *
 *  global variable is increased.  A 1 is always returned               *
 ************************************************************************/

int AddToValidList(SOCKET newID,int sockettype) {
    SocketIDList far *pStart;
    SocketIDList far *pElem;
    hSOCKLIST hElem;
    int idx=0;
    
    if (hStartOfSocketList == NULL){
        hStartOfSocketList = (hSOCKLIST) GlobalAlloc(GHND,sizeof(SocketIDList));
        pStart=(SocketIDList far *)GlobalLock(hStartOfSocketList);
        pStart->socketID = newID;
        pStart->hNextElement = NULL;
        pStart->hPrevElement = NULL;
        pStart->local_addr = NULL;
        pStart->remote_addr = NULL;
        if (sockettype == SOCK_DGRAM)
              pStart->telnetID = -1; //newudp();
        else  pStart->telnetID = -1;
        pStart->socket_type = sockettype;
        for(idx=0;idx<31;idx++)
            FD_CLR((SOCKET)idx,&pStart->options);
        GlobalUnlock(hStartOfSocketList);
        return(1);
    }
    else {
        hElem= (hSOCKLIST) GlobalAlloc(GHND,sizeof(SocketIDList));
        pElem=(SocketIDList far *)GlobalLock(hElem);
        pElem->socketID = newID;
        pElem->hNextElement = hStartOfSocketList;
        pElem->hPrevElement = NULL;
        pElem->local_addr = NULL;
        pElem->remote_addr = NULL;
        if (sockettype == SOCK_DGRAM)
              pElem->telnetID = 0; //newudp();
        else  pElem->telnetID = -1;
        pElem->socket_type = sockettype;
        for(idx=0;idx<31;idx++)
            FD_CLR((SOCKET)idx,&pElem->options);
        pStart=(SocketIDList far *)GlobalLock(hStartOfSocketList);
        pStart->hPrevElement=hElem;
        GlobalUnlock(hElem);
        GlobalUnlock(hStartOfSocketList);
        hStartOfSocketList=hElem;
        return(1);
     }
}

/****************************************************************************
 * FindValidID                                                              *
 *  Returns a pointer to the structure that contains the socket ID passed   *
 *  to the function.  If the ID was not found, a null is returned           *
 ****************************************************************************/
hSOCKLIST FindValidID(SOCKET searchID) {
    hSOCKLIST   hCurPos,hNextPos;
    SocketIDList far * pCurPos;
    hSOCKLIST   hRetList;
    
    hCurPos = hStartOfSocketList;
    pCurPos = (SocketIDList far *)GlobalLock(hCurPos);
    while (pCurPos != NULL) {
        if (pCurPos->socketID == (SOCKET)searchID) {
            hRetList = hCurPos;
            GlobalUnlock(hCurPos);
            return(hRetList);
        } else {
            hNextPos = pCurPos->hNextElement;
            GlobalUnlock(hCurPos);
            hCurPos=hNextPos;
            pCurPos=(SocketIDList far *)GlobalLock(hCurPos);
        }
    }
    return(NULL);    
}

/****************************************************************************
 * DeleteValidID                                                            *
 *  Deletes the memory & list element associated with a socket.  If the ID  *
 *  is not found, a null is returned.                                       *
 ****************************************************************************/
int DeleteValidID(SOCKET searchID) {
    hSOCKLIST   hCurPos,hNextPos;
    SocketIDList far * pCurPos;
    SocketIDList far * pTmpPos;
    
    hCurPos = hStartOfSocketList;
    pCurPos = (SocketIDList far *)GlobalLock(hCurPos);
    while (pCurPos != NULL) {
        if (pCurPos->socketID == (SOCKET)searchID) {
            if (hCurPos==hStartOfSocketList) /* top element */
                 hStartOfSocketList=pCurPos->hNextElement;        
            if (pCurPos->hPrevElement) {
                pTmpPos=(SocketIDList far *)GlobalLock(pCurPos->hPrevElement);
                pTmpPos->hNextElement=pCurPos->hNextElement;
                GlobalUnlock(pCurPos->hPrevElement);
            }
            if (pCurPos->hNextElement) {
                pTmpPos=(SocketIDList far *)GlobalLock(pCurPos->hNextElement);
                pTmpPos->hPrevElement=pCurPos->hPrevElement;
                GlobalUnlock(pCurPos->hNextElement);
            }                
                
            /* Delete all the memory associated with the socket */
            if (pCurPos->local_addr)
                LocalFree((HLOCAL) (WORD) (DWORD)pCurPos->local_addr);
            if (pCurPos->remote_addr)
                LocalFree((HLOCAL) (WORD) (DWORD)pCurPos->remote_addr);
            GlobalUnlock(hCurPos);
            GlobalFree(hCurPos);
            return(1);
        } else {
            hNextPos = pCurPos->hNextElement;
            GlobalUnlock(hCurPos);
            hCurPos=hNextPos;
            pCurPos=(SocketIDList far *)GlobalLock(hCurPos);
        }
    }
    return(0);
}

/****************************************************************************
 * Bind                                                                     *
 *  The purpose of bind is to fill in the information for the local IP      *
 *  address and local port.  In this respect, it is the opposite of         *
 *  connect.  Connect fills in the destination IP address and destination   *
 *  port.  Whereas, bind fills in the local information.  In most           *
 *  situations, one does not need to call bind.  But its a good idea to.    *
 *  Much like failing to intialize variables.                               *
 ****************************************************************************/

int FAR PASCAL bind(SOCKET sockfd,struct sockaddr FAR *myaddr,int namelen)
{
    hSOCKLIST    hThisSocket;
    SocketIDList far *pThisSocket;
    char    hostname[MAXHOSTNAMELEN];
    struct  hostent far *hp;    
    
    if (iSocketDebugLevel) {
        wsprintf(strTmp,"[Bind socket:%d]",sockfd);
        OutputDebugString(strTmp);
    }
    /* First, let's see if the socket "sockfd" was created */

    if ((hThisSocket = FindValidID(sockfd)) == NULL) {
        if (iSocketDebugLevel) {
            OutputDebugString("Attempting to bind a socket that was never made!");
            OutputDebugString("Apparently, this is still legal, but we must create the socket");
        }
        return(0);   // EBADF
    } else {
        pThisSocket=(SocketIDList far *)GlobalLock(hThisSocket);
        if (sizeof(struct sockaddr) == namelen) {
            pThisSocket->local_addr = (struct sockaddr far*) ((struct sockaddr near *)LocalAlloc(LPTR,sizeof(struct sockaddr)));
            if (((struct sockaddr_in far *)myaddr)->sin_addr.s_addr==INADDR_ANY) {
                gethostname((char far *) hostname, sizeof hostname );
                hp = gethostbyname((char far *)hostname);
                _fmemcpy(((struct in_addr far *)&((struct sockaddr_in far *)myaddr)->sin_addr),
                    ((struct in_addr far *)( hp -> h_addr_list[ 0 ])),
                    sizeof (struct in_addr));
            }         
            if ((((struct sockaddr_in far *)myaddr)->sin_port)==0)
                ((struct sockaddr_in far *)myaddr)->sin_port=GetRandomPort();
            movebytes(pThisSocket->local_addr,myaddr,sizeof(struct sockaddr));
            GlobalUnlock(hThisSocket);
            return(0);
        }
        else {
            GlobalUnlock(hThisSocket);
            WSASetLastError(WSAEINVAL);
            return(SOCKET_ERROR);
        }       
    }
}

/************************************************************************
 * gethostbyname                                                        *
 *  Returns the IP number (inside hostent) for the machine name inside  *
 *  "host".  "gethostbyname" first looks in the CONFIG.TEL file to see  *
 *  if there is an IP number for "host".  If this fails,                *
 *  "gethostbyname" will call up the name server, and query it for the  *
 *  IP address.                                                         *
 *                                                                      *
 * Returns:                                                             *
 *          -1      If there is no name server to get an IP address     *
 *          NULL    If no IP address could be found for "host"          *
 *          else    A valid pointer to a hostent structure              *
 ************************************************************************/

struct hostent FAR * PASCAL FAR gethostbyname(char FAR * host)
{
    int                     what,dat;
    int                     machine_number;
    static struct hostent  far*    returned_info=NULL;
    struct machinfo far*    machine_info=NULL;
    int iTmp=0;

    machine_info = NULL;
    machine_info = (struct machinfo far *)Sgethost((char FAR *)host);  /* look up in hosts cache */

    if (iSocketDebugLevel) {
        wsprintf(strTmp,"[GHBN: \"%s\"]",host);
        OutputDebugString(strTmp);
    }
    if (!machine_info) {
            if ((machine_number = Sdomain((char FAR *)host)) <0 ) return(NULL);
            SetTimer(NULL,1,100,NULL);
            while (machine_info == NULL) {
               WaitMessage();
//               if (PeekMessage(&msg,NULL,WM_TIMER,WM_TIMER,PM_REMOVE)) {
                   iTmp = Sgetevent(USERCLASS,(int FAR *)&what,(int FAR *)&dat);
                   switch(iTmp) {
                    case DOMFAIL:   /* Shouldn't this be a Dialog box? -CGW */
                         OutputDebugString("Domain Lookup failed! \r\n");
                         return(NULL);
                    case DOMOK:     
                                machine_info = Slooknum(machine_number);
                                if (returned_info == NULL) {
                                    returned_info = (struct hostent far*) ((struct hostent near *)LocalAlloc(LPTR,sizeof(struct hostent)));
                                    returned_info->h_addr_list= (char far * far *) ((char far * near *)LocalAlloc(LPTR,2*sizeof(char far *)));
                                    returned_info->h_addr_list[0] = (char far *)((char near *) LocalAlloc(LPTR,4));
                                }    
                                returned_info->h_name = machine_info->hname;
                                returned_info->h_addrtype = PF_INET;
                                returned_info->h_aliases = NULL;
                                returned_info->h_addr_list[1] = (char far *)NULL;
                                returned_info->h_addr_list[0][0] = (unsigned char) machine_info->hostip[0];
                                returned_info->h_addr_list[0][1] = (unsigned char) machine_info->hostip[1];
                                returned_info->h_addr_list[0][2] = (unsigned char) machine_info->hostip[2];
                                returned_info->h_addr_list[0][3] = (unsigned char) machine_info->hostip[3];
                                returned_info->h_length = 4;
                                break;
                                
                    default:    break;
                   }               
//               }
            }   
        }
    else {
        if (returned_info == NULL) {
            returned_info = (struct hostent far *) ((struct hostent near *)LocalAlloc(LPTR,sizeof(struct hostent)));
            returned_info->h_addr_list= (char far * far *) ((char far * near *)LocalAlloc(LPTR,2*sizeof(char far *)));
            returned_info->h_addr_list[0] = (char far *)((char near *) LocalAlloc(LPTR,4));
        }    
        returned_info->h_name = machine_info->hname;
        returned_info->h_addrtype =PF_INET;
        returned_info->h_aliases = NULL;
        returned_info->h_addr_list[1] = (char far *)NULL;
        returned_info->h_addr_list[0][0] = (unsigned char) machine_info->hostip[0];
        returned_info->h_addr_list[0][1] = (unsigned char) machine_info->hostip[1];
        returned_info->h_addr_list[0][2] = (unsigned char) machine_info->hostip[2];
        returned_info->h_addr_list[0][3] = (unsigned char) machine_info->hostip[3];
        returned_info->h_length = 4;
    }

    if (machine_info == NULL)
        return(NULL);
    else
        return(returned_info);
}

/**************************************************************************
 * connect                                                                  *
 *  "connect" will attempt to open a connection on a foreign IP address and *
 *  foreign port address.  This is achieved by specifying the foreign IP    *
 *  address and foreign port number in the "servaddr".                      *
 *                                                                          *
 *  "connect" also requires "sockfd" which is the socket number that was    *
 *  returned when a socket was created using "socket".  "sockfd" serves as  *
 ****************************************************************************/

int PASCAL FAR connect(SOCKET sockfd, struct sockaddr far *servaddr, int addrlen)
{
    hSOCKLIST           hSockStruct;
    SocketIDList far   *pSockStruct;
    int                 ev,what,dat,conid;
    struct machinfo     machine_record;
    struct machinfo far *tmp_info;
    struct sockaddr_in  far *temp;
    char    strTmp[256];

    if (iSocketDebugLevel) {
        wsprintf(strTmp,"[Connect socket:%d]",sockfd);
        OutputDebugString(strTmp);
    }

    if ((hSockStruct = FindValidID(sockfd)) == NULL) {
        if (iSocketDebugLevel)
            OutputDebugString("Invalid sockfd: Trouble with the linked list or bogus sockfd \r\n");
        WSASetLastError(WSAENETDOWN);
        return(SOCKET_ERROR);
    } else {
        pSockStruct=(SocketIDList far *)GlobalLock(hSockStruct);
        if (pSockStruct->remote_addr != NULL) {
            if (iSocketDebugLevel)
                OutputDebugString("SocketOut structure already exists: Thats bad \r\n");
            WSASetLastError(WSAEISCONN);
            return(SOCKET_ERROR);
        }
        temp = (struct sockaddr_in far*) servaddr;
        pSockStruct->remote_addr = (struct sockaddr far*) ((struct sockaddr_in near *)LocalAlloc(LPTR,sizeof(struct sockaddr_in)));
        ((struct sockaddr_in far *)pSockStruct->remote_addr)->sin_family = AF_INET;
        ((struct sockaddr_in far *)pSockStruct->remote_addr)->sin_port = htons(temp->sin_port);
        ((struct sockaddr_in far *)pSockStruct->remote_addr)->sin_addr = temp->sin_addr;
    }

    tmp_info=(struct machinfo far *)Shostlook((char FAR *)"default");
    _fmemcpy((struct machinfo far *)(&machine_record),tmp_info,sizeof(struct machinfo));
    machine_record.hostip[0]=((struct sockaddr_in far *)pSockStruct->remote_addr)->sin_addr.S_un.S_un_b.s_b1;
    machine_record.hostip[1]=((struct sockaddr_in far *)pSockStruct->remote_addr)->sin_addr.S_un.S_un_b.s_b2;
    machine_record.hostip[2]=((struct sockaddr_in far *)pSockStruct->remote_addr)->sin_addr.S_un.S_un_b.s_b3;
    machine_record.hostip[3]=((struct sockaddr_in far *)pSockStruct->remote_addr)->sin_addr.S_un.S_un_b.s_b4;
    machine_record.mstat= HAVEIP;
    if (pSockStruct->local_addr == NULL) {
//        OutputDebugString("Bind was not called--- picking a source port for you \r\n");
        pSockStruct->local_addr = (struct sockaddr far*) ((struct sockaddr_in near *)LocalAlloc(LPTR,sizeof(struct sockaddr)));
        ((struct sockaddr_in far *)pSockStruct->local_addr)->sin_family = AF_INET;
        ((struct sockaddr_in far *)pSockStruct->local_addr)->sin_port = GetRandomPort();
    }

    netfromport(((struct sockaddr_in far *)pSockStruct->local_addr)->sin_port);

    if(pSockStruct->socket_type == SOCK_DGRAM) {
        if (iSocketDebugLevel)
            OutputDebugString("Socket is a datagram so connections aren't established...\n\r");
        GlobalUnlock(hSockStruct);        
        return(0);
    }

    if (0 > (conid = Snetopen((struct machinfo far*)(&machine_record),
                ((struct sockaddr_in far *)pSockStruct->remote_addr)->sin_port))) {
        /* Should this be a message box? */
        OutputDebugString("Couldn't open connection \r\n");
        GlobalUnlock(hSockStruct);
        WSASetLastError(WSAECONNREFUSED);
        return(SOCKET_ERROR);
    }

    if (iSocketDebugLevel) {
        wsprintf(strTmp,"[conid=%d]",conid);
        OutputDebugString(strTmp);
    }

    while (1) {
        netsleep(0);
        if (0 != (ev = Sgetevent(CONCLASS,(int FAR *)&what,(int FAR *)&dat))) {
            if (iSocketDebugLevel>100) {
                wsprintf(strTmp,"[ev= %d what=%d dat=%d]",ev,what,dat);
                OutputDebugString(strTmp);
            }
            if (dat != conid) {
                netputuev(what,ev,dat);
                continue;
            }
            if (ev == CONOPEN) {
                if (iSocketDebugLevel)
                    OutputDebugString("[CONOPEN]");
                break;
            }    
            if (ev == CONFAIL) {
                if (iSocketDebugLevel)
                    OutputDebugString("CONFAIL \r\n");
                WSASetLastError(WSAECONNREFUSED);
                return(SOCKET_ERROR);
            }
        }
    }
    pSockStruct->telnetID = conid;
    pSockStruct->status=SOCK_CONNECTED;
    GlobalUnlock(hSockStruct);
    return(0);
}

int FAR PASCAL recv(SOCKET s, char FAR * buf, int len, int flags) {
    SocketIDList far *pSockStruct;
    hSOCKLIST   hSockStruct;
    int RetVal;

    netsleep(0);
    if (iSocketDebugLevel>25) {
        wsprintf(strTmp,"[Recv socket: %d]",s);
        OutputDebugString(strTmp);
    }

    hSockStruct = FindValidID(s);

    if (hSockStruct == NULL){
        if (iSocketDebugLevel)
            OutputDebugString("WSAENOTSOCK");
        WSASetLastError(WSAENOTCONN);
        return(SOCKET_ERROR);
    }
    pSockStruct=(SocketIDList far *)GlobalLock(hSockStruct);
    if (pSockStruct->local_addr == NULL) {
        if (iSocketDebugLevel)
            OutputDebugString("No SocketIn structure ever created.");
        GlobalUnlock(hSockStruct);
        WSASetLastError(WSAENOTCONN);
        return(SOCKET_ERROR);
    }
//    if (pSockStruct->socket_type==SOCK_DGRAM) {
//        net(pSockStruct->local_addr->sin_port,pSockStruct->telnetID);
//        Stask();
//        return(neturead(buf,SockStruct->telnetID));
//    }
//    wsprintf(strTmp,"telID=%d sock_type=%d \r\n",pSockStruct->telnetID,pSockStruct->socket_type);
//    OutputDebugString(strTmp);
    if (pSockStruct->socket_type==SOCK_STREAM) {
        netsleep(0);
        RetVal=netread(pSockStruct->telnetID,buf,len);
        while (RetVal==0) {
          netsleep(0);
          RetVal=netread(pSockStruct->telnetID,buf,len);
        }  
        if (iSocketDebugLevel) {
            wsprintf(strTmp,"[Recv returns %d]",RetVal);
            OutputDebugString(strTmp);
        }
        GlobalUnlock(hSockStruct);
        return(RetVal);
    }
    GlobalUnlock(hSockStruct);    
    WSASetLastError(WSAENOTCONN);
    return(SOCKET_ERROR);
}

int FAR PASCAL send(SOCKET s, char FAR *buf, int len, int flags) {
    SocketIDList far * pSockStruct;
    hSOCKLIST   hSockStruct;
    int         RetVal;

    netsleep(0);
    if (iSocketDebugLevel>25) {
        wsprintf(strTmp,"[Send socket:%d len=%d]",s,len);
        OutputDebugString(strTmp);
    }
    hSockStruct = FindValidID(s);

    if (hSockStruct==NULL) {
        if (iSocketDebugLevel)
            OutputDebugString("Bogus sockfd \r\n");
        WSASetLastError(WSAENOTCONN);
        return(SOCKET_ERROR);
    }

    pSockStruct=(SocketIDList far *)GlobalLock(hSockStruct);
    if (pSockStruct->remote_addr == NULL){
        if (iSocketDebugLevel)
            OutputDebugString("No SocketOut structure.  Either call connect to create one, or use sendto \r\n");
        GlobalUnlock(hSockStruct);
        WSASetLastError(WSAENOTCONN);
        return(SOCKET_ERROR);
    }

    if (pSockStruct->local_addr == NULL) {
        if (iSocketDebugLevel)
            OutputDebugString("No SocketIn structure.  Need to call bind to put one in place \r\n");
        GlobalUnlock(hSockStruct);
        WSASetLastError(WSAENOTCONN);
        return(SOCKET_ERROR);
    }

//    netulisten(SockStruct->SocketIn->sin_port,SockStruct->telnetID);
//    returnValue = netusend((uint8 *) &SockStruct->SocketOut->sin_addr,SockStruct->SocketOut->sin_port,SockStruct->SocketIn->sin_port,buff,nbytes,SockStruct->telnetID);
//    Stask();
//    wsprintf(strTmp,"telID=%d sock_type=%d \r\n",pSockStruct->telnetID,pSockStruct->socket_type);
//    OutputDebugString(strTmp);

    RetVal= netwrite(pSockStruct->telnetID,buf,len);
    if (iSocketDebugLevel>50) {
        wsprintf(strTmp,"{Send=%d}",RetVal);
        OutputDebugString(strTmp);
    }
    netpush(pSockStruct->telnetID);
    GlobalUnlock(hSockStruct);
    return(RetVal);
}

int PASCAL FAR sendto (SOCKET s, char FAR * buf, int len, int flags,
                       struct sockaddr FAR *to, int tolen) {

    if (iSocketDebugLevel>25)
        OutputDebugString("SENDTO!!!!!!");
    return (send(s,buf,len,flags));
}                       

int PASCAL FAR ioctlsocket (SOCKET s, long cmd, u_long FAR *argp) {
    SocketIDList far * pSockStruct;
    hSOCKLIST   hSockStruct;
    u_long ulTmp;

//    wsprintf(strTmp,"[IOCTL:%d]",s);
//    OutputDebugString(strTmp);

    hSockStruct = FindValidID(s);    

    if (hSockStruct == NULL){
        if (iSocketDebugLevel)
            OutputDebugString("WSAENOTSOCK");
        WSASetLastError(WSAENOTSOCK);
        return(SOCKET_ERROR);
    }

    pSockStruct=(SocketIDList far *)GlobalLock(hSockStruct);    
    if (cmd==FIONREAD) {
        if (pSockStruct->telnetID > -1)
            ulTmp=(u_long)netqlen(pSockStruct->telnetID);
          else
            ulTmp = (u_long)0;
//        wsprintf(strTmp,"[netqlen=%lu]",ulTmp);
//        OutputDebugString(strTmp);        
        *argp=ulTmp;
    } else {
        WSASetLastError(WSAESOCKTNOSUPPORT);
        if (iSocketDebugLevel)
            OutputDebugString("MAJOR PROBLEM!!!!!!!");
        return(SOCKET_ERROR);
    }
    GlobalUnlock(hSockStruct);
    return(0);
}

long PASCAL FAR select (int nfds, fd_set FAR *readfds,fd_set far *writefds,
                fd_set FAR *exceptfds, struct timeval far*timeout) {

    SocketIDList far *pSockStruct;
    hSOCKLIST hSockStruct;
    int ctr=0,length=0,ret_count=0;

    netsleep(0);
    if (readfds) {
        for(ctr=0;ctr<32;ctr++)
            if (FD_ISSET(ctr,readfds)) { /* Is this bit set */
                if (iSocketDebugLevel>25) {
                    wsprintf(strTmp,"[S:%i]",ctr);
                    OutputDebugString(strTmp);
                }
                if ((hSockStruct = FindValidID(ctr)) == NULL) { /* Find the socket structure */
                    WSASetLastError(WSAENOTSOCK);
                    if (iSocketDebugLevel) {
                        wsprintf(strTmp,"Select: %i does not exist\n",ctr);
                        OutputDebugString(strTmp);
                    }
                    return(ret_count);
                }

                /*** If a socket is connected, it can be read from if there is
                 *** outstanding data.  If the socket is not connected, but there
                 *** is an outstanding listen() AND a pending CONOPEN on the Telnet
                 *** stack, then we return a read available even though it is to be
                 *** interpreted as call accept and you won't be blocked instead
                 *** of call read and you won't be blocked.
                 ***/

                pSockStruct=(SocketIDList far *)GlobalLock(hSockStruct);    
                switch (pSockStruct->status) {
                    case SOCK_CONNECTED:
                        if (iSocketDebugLevel>25)
                            OutputDebugString("[Select:1]");
                        if (length = netqlen(pSockStruct->telnetID)) { 
                            if (iSocketDebugLevel>25) {
                                wsprintf(strTmp,"[Length is %i]",length);  
                                OutputDebugString(strTmp);
                            }
                            GlobalUnlock(hSockStruct);
                            ret_count++; 
                        } else
                            FD_CLR((SOCKET)ctr,readfds);
                        break;

                    case SOCK_CON_PENDING:
                        ret_count++;
                        break;

                    case SOCK_LISTENING:
                        FD_CLR((SOCKET)ctr,readfds);
                        break;

                    default:
                        FD_CLR((SOCKET)ctr,readfds);
                        break;
                } /* switch */
            } /* if FD_ISSET */
            GlobalUnlock(hSockStruct);
        } /* if (readfds) */
    
        if (writefds) {
            if (iSocketDebugLevel)
                OutputDebugString("WAHAHHAAH \r\n");
            for(ctr=0;ctr<32;ctr++)
                if (FD_ISSET(ctr,writefds)) {
                    if ((hSockStruct = FindValidID(ctr)) == NULL) {
                        WSASetLastError(WSAENOTSOCK);
                        return(SOCKET_ERROR);
                    }
                    pSockStruct=(SocketIDList far *)GlobalLock(hSockStruct);
                    if ((netroom(pSockStruct->telnetID)) &&  /* Netroom tells us if there is buffer out space */
                        (pSockStruct->status == SOCK_CONNECTED)) {
                            GlobalUnlock(hSockStruct);                        
                            return(ctr);
                        }    
                    }
                }
       return(ret_count);
}                

int GetRandomPort(void) {
    int temp=0;

    srand((unsigned) time(NULL));
    while((temp < 1024) || (temp > 32000))
        temp = rand();
    return temp;
}

int FAR PASCAL recvfrom(SOCKET s, char FAR * buf, int len, int flags, struct sockaddr FAR *from, int FAR * fromlen) {
    SocketIDList far *pSockStruct;
    hSOCKLIST   hSockStruct;
    int RetVal;
    
    if (iSocketDebugLevel) {
        wsprintf(strTmp,"[RECVFROM:%d]",s);
        OutputDebugString(strTmp);
    }

    hSockStruct = FindValidID(s);

    if (hSockStruct == NULL){
        if (iSocketDebugLevel)
            OutputDebugString("WSAENOTSOCK");
        WSASetLastError(WSAENOTSOCK);
        return(SOCKET_ERROR);
    }
    pSockStruct=(SocketIDList far *)GlobalLock(hSockStruct);
    if (pSockStruct->local_addr == NULL) {
        if (iSocketDebugLevel)
            OutputDebugString("No SocketIn structure ever created.");
        GlobalUnlock(hSockStruct);
        WSASetLastError(WSAENOTCONN);
        return(SOCKET_ERROR);
    }
//    if (SockStruct->socket_type==SOCK_DGRAM) {
//        netulisten(SockStruct->local_addr->sin_port,SockStruct->telnetID);
//        Stask();
//        return(neturead(buf,SockStruct->telnetID));
//    }
    if (pSockStruct->socket_type==SOCK_STREAM) {
        _fmemcpy((struct sockaddr far *)from,pSockStruct->remote_addr,sizeof(struct sockaddr));
        *fromlen=sizeof(struct sockaddr);
        RetVal=netread(pSockStruct->telnetID,buf,len);
        GlobalUnlock(hSockStruct);
        return(RetVal);
    }    
    GlobalUnlock(hSockStruct);
    WSASetLastError(WSAENOTSOCK);
    return(SOCKET_ERROR);
}

int PASCAL FAR getsockname (SOCKET s, struct sockaddr FAR *name,int FAR * namelen){
    SocketIDList far *pSockStruct;
    hSOCKLIST   hSockStruct;

    if (iSocketDebugLevel>25) {
        wsprintf(strTmp,"[GSN:%d]",s);
        OutputDebugString(strTmp);
    }

    hSockStruct = FindValidID(s);

    if (hSockStruct == NULL){
        if (iSocketDebugLevel)
            OutputDebugString("WSAENOTSOCK");
        WSASetLastError(WSAENOTSOCK);
        return(SOCKET_ERROR);
    }                            
    pSockStruct=(SocketIDList far *)GlobalLock(hSockStruct);
    _fmemcpy((struct sockaddr far *)name,pSockStruct->local_addr,sizeof(struct sockaddr));
    *namelen=sizeof(struct sockaddr);
    GlobalUnlock(hSockStruct);
    return(0);
}

int PASCAL FAR getpeername (SOCKET s, struct sockaddr FAR *name,int FAR * namelen) {
    SocketIDList far *pSockStruct;
    hSOCKLIST   hSockStruct;

    if (iSocketDebugLevel) {
        wsprintf(strTmp,"[GPN:%d]",s);
        OutputDebugString(strTmp);
    }
    hSockStruct = FindValidID(s);
    if (hSockStruct == NULL){
        WSASetLastError(WSAENOTSOCK);
        return(SOCKET_ERROR);
    }
    pSockStruct=(SocketIDList far *)GlobalLock(hSockStruct);                        
    _fmemcpy((struct sockaddr far *)name,pSockStruct->remote_addr,sizeof(struct sockaddr));
    *namelen=sizeof(struct sockaddr);
    GlobalUnlock(hSockStruct);
    return(0);
}                            

int PASCAL FAR closesocket (SOCKET s) {
    SocketIDList far *pSockStruct;
    hSOCKLIST   hSockStruct;
    int RetVal=-1,len=-1;
    char buf[256];
    
    if (iSocketDebugLevel) {
        wsprintf(strTmp,"[CLOSE socket:%d]",s);
        OutputDebugString(strTmp);
    }
    hSockStruct = FindValidID(s);

    if (hSockStruct == NULL) {
        if (iSocketDebugLevel)
            OutputDebugString("Bogus sockfd \r\n");
        WSASetLastError(WSAENOTSOCK);
        return(SOCKET_ERROR);
    }

    pSockStruct=(SocketIDList far *)GlobalLock(hSockStruct);
    
    if (pSockStruct->status!=SOCK_CONNECTED) return(0);

    while (netpush(pSockStruct->telnetID) != 0) {
        MSG msg;
        BOOL ret;

//        OutputDebugString("[DATA]");        
        netsleep(0);
        ret=(BOOL) PeekMessage(&msg,0,0,0,PM_REMOVE);
        if (ret) {
            TranslateMessage(&msg);
            DispatchMessage(&msg);
        }
    }
    
    RetVal=netread(pSockStruct->telnetID,buf,256);
    if (iSocketDebugLevel) {
        wsprintf(strTmp,"[CLOSE: ret=%d len=%d]",RetVal,len);
        OutputDebugString(strTmp);
    }
    netclose(pSockStruct->telnetID);
    GlobalUnlock(hSockStruct);
    DeleteValidID(s);
    return(0);

//    netpush(pSockStruct->telnetID);
//    netsleep(1);
//    netclose(pSockStruct->telnetID);
//    LocalUnlock((HLOCAL)pSockStruct->local_addr);
//    LocalUnlock((HLOCAL)pSockStruct->remote_addr);
//    GlobalUnlock(hSockStruct);
//    return(0);
}

SOCKET PASCAL FAR accept (SOCKET s, struct sockaddr FAR *addr,int FAR *addrlen) {
    SocketIDList far *pSockStruct;
    hSOCKLIST       hSockStruct;    
    SocketIDList far *pDestination;
    hSOCKLIST       hDestination;
    int iTmp=0,iNewID=-1;
    int             ev,what,dat;
    SOCKET          RetVal;

    if (iSocketDebugLevel) {
        wsprintf(strTmp,"[ACCEPT:%d]",s);
        OutputDebugString(strTmp);
    }                        
    hSockStruct = FindValidID(s);
    if (hSockStruct == NULL) {
        if (iSocketDebugLevel)
            OutputDebugString("Bogus socket descriptor");
        WSASetLastError(WSAENOTCONN);
        return(INVALID_SOCKET);
    }

    pSockStruct=(SocketIDList far *)GlobalLock(hSockStruct);
    if (pSockStruct->local_addr == NULL) {
        if (iSocketDebugLevel)
            OutputDebugString("Non existent SocketIn--- never called bind");
        GlobalUnlock(hSockStruct);
        WSASetLastError(WSAENOTCONN);
        return(INVALID_SOCKET);
    }
    if ((pSockStruct->status != SOCK_LISTENING)&&(pSockStruct->status != SOCK_CON_PENDING)) {
        if (iSocketDebugLevel)
            OutputDebugString("Accept: error not listening! \r\n");
        GlobalUnlock(hSockStruct);
        WSASetLastError(WSAENOTCONN);
        return(INVALID_SOCKET);
    }
    while (TRUE) {    
        {
            MSG msg;
            BOOL ret;

            ret=(BOOL) PeekMessage(&msg,0,0,0,PM_REMOVE);
            if (ret) {
                TranslateMessage(&msg);
                DispatchMessage(&msg);
            }
        } 
        ev = Sgetevent(CONCLASS,(int FAR *)&what,(int FAR *)&dat);
        if (ev==0)
            continue;
            
        if (ev == CONFAIL) {
            GlobalUnlock(hSockStruct);
            return(WSAEINVAL);
        }
        if (ev == CONOPEN) {
            if (iSocketDebugLevel)
                OutputDebugString("[CONOPEN2]");
            break;
        } else {
            if (iSocketDebugLevel)
                OutputDebugString(":");
            netputuev(CONCLASS,ev,dat);
        }    
    }
         
    AddToValidList(SOCKET_COUNTER,SOCK_STREAM);
    hDestination = FindValidID(SOCKET_COUNTER);
    pDestination = (SocketIDList far *)GlobalLock(hDestination);       
    pDestination->local_addr = (struct sockaddr *) LocalAlloc(LPTR,sizeof(struct sockaddr_in));
    ((struct sockaddr_in far *)pDestination->local_addr)->sin_family = AF_INET;
    ((struct sockaddr_in far *)pDestination->local_addr)->sin_port = 
#ifdef NO_SWAP
        ((struct sockaddr_in far *)pSockStruct->local_addr)->sin_port;
#else
        htons(((struct sockaddr_in far *)pSockStruct->local_addr)->sin_port);
#endif
    ((struct sockaddr_in far *)pDestination->local_addr)->sin_addr = 
        ((struct sockaddr_in far *)pSockStruct->local_addr)->sin_addr;
    pDestination->remote_addr = (struct sockaddr *) LocalAlloc(LPTR,sizeof(struct sockaddr_in));
    pDestination->telnetID = dat;
    if (iSocketDebugLevel) {
        wsprintf(strTmp,"[Accept telID=%d]",dat);
        OutputDebugString(strTmp);
    }
    netgetinaddr((int)pDestination->telnetID,(struct sockaddr_in far *)pDestination->remote_addr);
    SOCKET_COUNTER++;
    
    RetVal=(SOCKET)pDestination->socketID;
    pDestination->status=SOCK_CONNECTED;
    pSockStruct->status = SOCK_LISTENING;
    pSockStruct->telnetID=netlisten(((struct sockaddr_in far *)pSockStruct->local_addr)->sin_port);

    GlobalUnlock(hDestination);
    GlobalUnlock(hSockStruct);
    return(RetVal);
}

int PASCAL FAR listen (SOCKET s, int backlog) {
    SocketIDList far *pSockStruct;
    hSOCKLIST   hSockStruct;

    if (iSocketDebugLevel) {
        wsprintf(strTmp,"[LISTEN:%d]",s);
        OutputDebugString(strTmp);
    }
    hSockStruct = FindValidID(s);
    if (hSockStruct == NULL) {
        WSASetLastError(WSAENOTSOCK);
        return(-1);
    } else {
        pSockStruct= (SocketIDList far *) GlobalLock(hSockStruct);
        if (pSockStruct->local_addr == NULL) {
            WSASetLastError(WSAEINVAL);
            GlobalUnlock(hSockStruct);
            return(-1);
        }
//        pSockStruct->options |= SO_ACCEPTCONN;
#ifdef NO_SWAP
        pSockStruct->telnetID=netlisten(((struct sockaddr_in far *)pSockStruct->local_addr)->sin_port);
#else
        pSockStruct->telnetID=netlisten(htons(((struct sockaddr_in far *)pSockStruct->local_addr)->sin_port));
#endif
        pSockStruct->status=SOCK_LISTENING;
        GlobalUnlock(hSockStruct);
    }
    return(0);
}


unsigned long PASCAL FAR inet_addr (char FAR * cp) {
    unsigned long   n1,n2,n3,n4;
    unsigned long   sum;
    static char tmpBuf[4];
    char far *str;
    int cnt=0;

    str=cp;    
    while (str[cnt]!='.') {
        tmpBuf[cnt]=str[cnt];
        cnt++;
    }
    tmpBuf[cnt++]='\0';
    n1=atol(tmpBuf);    
    
    str+=cnt;
    cnt=0;
    while (str[cnt]!='.') {
        tmpBuf[cnt]=str[cnt];
        cnt++;
    }
    tmpBuf[cnt++]='\0';
    n2=atol(tmpBuf);    
    
    str+=cnt;
    cnt=0;
    while (str[cnt]!='.') {
        tmpBuf[cnt]=str[cnt];
        cnt++;
    }
    tmpBuf[cnt++]='\0';
    n3=atol(tmpBuf);    

    str+=cnt;
    cnt=0;
    while (str[cnt]) {
        tmpBuf[cnt]=str[cnt];
        cnt++;
    }
    tmpBuf[cnt++]='\0';
    n4=atol(tmpBuf);    
    
    if (iSocketDebugLevel>25) {
        wsprintf(strTmp,"Address is: %lu.%lu.%lu.%lu \r\n",n1,n2,n3,n4);
        OutputDebugString(strTmp);
    }
    n3= n3<< 8;
    n2= n2<< 16;
    n1= n1<< 24;
    sum = n1 + n2 + n3 + n4;
    return(sum);
}

char FAR * PASCAL FAR inet_ntoa (struct in_addr in) {
    char temp[20];

    wsprintf(temp,"%i.%i.%i.%i",in.S_un.S_un_b.s_b1,in.S_un.S_un_b.s_b2,
                                in.S_un.S_un_b.s_b3,in.S_un.S_un_b.s_b4);
    return((char far *)temp);
}    

void PASCAL FAR bzero(char far *generic, int length) {
    int counter=0;

    while (counter<length)
        generic[counter++] = 0;
    return;
}

int PASCAL FAR __WSAFDIsSet(SOCKET fd, fd_set FAR *set) {
    int i= set->fd_count;
    
    while (i--)
        if (set->fd_array[i]==fd)
            return TRUE;
    return FALSE;
}

void PASCAL FAR gethostname(char far *hostname, int length) {    
    lstrcpyn(hostname,local_hostname,length);
}

int PASCAL FAR setsockopt (SOCKET s, int level, int optname,
                           char FAR * optval, int optlen) {
    return(0);
}                           

int FAR PASCAL setSockDebugLevel(int newlevel) {
    int oldlevel=iSocketDebugLevel;
    iSocketDebugLevel=newlevel;
    return(oldlevel);
}

int PASCAL FAR WSAGetLastError(void) {
    if (iErrIdx==0)
        return(0);
    return(iErrArray[--iErrIdx]);
}

void PASCAL FAR WSASetLastError(int iError) {
    iErrArray[iErrIdx] = iError;
    if (iErrIdx < (MAX_NUM_ERRS -1))
        iErrIdx++;
}

