.286
        name    NCSABIND
        page    55,132
        title   Stub Program to handle calling Packet Driver from NCSA/Windows

cr      equ     0dh
lf  equ 0ah

IC_ANY          equ     0
IC_ETHERNET     equ     1
IC_SLIP         equ     6
IT_ANY          equ     0ffffh

_TEXT   segment  para public 'CODE'
        org  100h
        assume  cs:_TEXT, ds:_TEXT

start:
        jmp     init

        db      '(c) Joe Lepore 1992'
PktVect dw      65h      ;Packet Driver Vector
iphdl   dw      -1      ;IP Handle
arphdl  dw      -1      ;ARP Handle
rarphdl dw      -1      ;RARP Handle

iptype  db      8,0
arptype db      8,6
rarptype        db      80h,35h

;       Common block layout - must conform to packed C structure
rmcb_open       EQU     0
rmcb_close      EQU     4
rmcb_xmit       EQU     8
rmcb_recv       EQU     12
rmcb_getaddr    EQU     16
rmcb_update     EQU     20
rmPtr           EQU     24
pmPtr           EQU     26
BufOrg          EQU     28
BufBig          EQU     30
BufEnd          EQU     32
BufRead         EQU     34
BufLim          EQU     36
BufPtr          EQU     38
IOHandle        EQU     40
ThisHandle      EQU     42
nextavail       EQU     44
debug           EQU     52
debug1          EQU     54
debug2          EQU     56
debug3          EQU     58
debug4          EQU     60
holdcx          EQU     62

;*************  Start of Code  *********************************************

;
;       On entry:  AX = proposed vector, or 0 for search
;       Destroys:  Nothing
;       On Exit :  AX = 0 if ok , 1 if not found
;
FindVector      proc    near
        pusha
        push    ds
        push    cs
        pop     ds              ; point to our data
        cmp     PktVect,0
        jne     FindExit        ; Already Set Up
        cmp     ax,0            ; default vector passed in
        je      FindSearch
        mov     vmin,ax         ; just check the passed vector
        mov     vmax,ax
FindSearch:        
        push    es
;DEBUG                          something wrong below - patch it for now ...
        mov     dx,65h
        jmp     FindOk
;DEBUG
        xor     dx,dx
        mov     es,dx           ; point to int table
        mov     dx,vmin         ; dx= current int
FindNext:
        mov     bx,dx           ; get int #
        shl     bx,2            ; get int table offset
        mov     di,es:[bx]      ; get vector offset
        mov     ax,es:[bx+2]    ; get vector segment
        push    es
        push    ax
        pop     es              ; load it into es
        xor     ax,ax           ; clear for no error
        add     di,3            ; point to signature
        mov     cx,8
        mov     si,offset pktstr
        repe    cmpsb
                                ; compare DSSI to ESDI
        pop     es
        jz      FindOk          ; match was found
        inc     dx
        cmp     vmax,dx
        jle     FindNext
        mov     ax,1            ; error - not found
        jmp     FindExit1
FindOk:           
        mov     PktVect,dx      ; save off the packet vector
FindExit1:
        pop     es
FindExit:
        pop     ds
        popa
        ret
vmin    dw      60h
vmax    dw      7fh
pktstr  db      'PKT DRVR'
FindVector      endp

;
;       On Entry:  stack (reverse push order)  rcvr_seg, rcvr_off, type_len,
;                        type_seg, type_off, if_nbr, if_type, if_class
;       On Exit:   ax = ip handle or -1 if error
;
pkt_access_type proc    near
        push    ds
        push    cs
        pop     ds              ; point to our data
        mov     ax,-1           ; default answer
        cmp     PktVect,0
        je      pkt_exit        ; no packet driver, nothing to do!
        push    bp
        mov     bp,sp
        pusha
        push    ds
        push    es

;        mov     ax,[bp+6]               ; first param rcvr_seg
;        mov     es,ax
;        mov     di,[bp+8]              ; rcvr offset
        push    ds
        pop     es
        mov     di,offset IntCB

        mov     cx,[bp+10]              ; type length
        mov     ax,[bp+12]              ; type segment
        mov     ds,ax
        mov     si,[bp+14]              ; type offset
        mov     dx,[bp+16]              ; if number
        mov     bx,[bp+18]              ; if type
        mov     al,[bp+20]              ; if class
        mov     ah,2                    ; call type (register type)
;        pushf
;        call    far  ptr [bp+4]              ; simulate interrupt
        int     65h
        jnc     pkt_ok
        mov     ax,-1
pkt_ok:
        pop     es
        pop     ds
        mov     rtn_val,ax
        popa
        pop     bp
        mov     ax,rtn_val
pkt_exit:
        pop     ds
        ret     16                              ; clean the stack
rtn_val dw      0h
pkt_access_type endp

;
;       On Entry:       bx = handle, cx = mode
;       On Exit:        ax = result
;       Destroys:       everything
;
pkt_set_rcv_mode proc   near
        push    ds
        push    cs
        pop     ds              ; point to our data
        mov     ax,-1
        cmp     PktVect,0
        je      pkts_exit        ; no packet driver, nothing to do!
        mov     ax,2000h        ; set up for call
;        mov     bp,PktVect
;        pushf
;        call    far [bp]           ; simulate interrupt
        int     65h
        jnc     pkts_exit1
        xor     dl,dl
        pop     ds
        mov     ax,dx
        ret
pkts_exit1:
        xor     ax,ax
        pop     ds
        ret
pkts_exit:
        ret
pkt_set_rcv_mode endp

;
;       On Entry:       bx = handle
;
pkt_rel_type    proc    near
        push    ds
        push    cs
        pop     ds                      ; point to our data
        cmp     PktVect,0
        je      pkt_rel_exit            ; no packet driver, nothing to do!
        mov     ax,0300h                ; set up for call
;        mov     bp,PktVect
;        pushf
;        call    far [bp]                ; simulate interrupt
        int     65h
pkt_rel_exit:
        pop     ds
        ret
pkt_rel_type    endp

;
;       On Entry:       bx= handle, ES:DI = storage area, cx = len of storage
;
pkt_get_address proc    near
        push    ds
        push    cs
        pop     ds                      ; point to our data
        cmp     PktVect,0
        je      pkt_add_exit            ; no packet driver, nothing to do!
        mov     ax,0600h                ; set up for call
;        mov     bp,PktVect
;        pushf
;        call    far [bp]                ; simulate interrupt
        int     65h
pkt_add_exit:
        pop     ds
        ret
pkt_get_address endp

;
;       On Entry:       DS:SI= packet, CX = length
;       On Exit:        AX = result code
;
pkt_send        proc    near
        push    ds
        push    cs
        pop     ds                      ; point to our data
        mov     ax,-1
        cmp     PktVect,0
        je      pkt_send_exit           ; no packet driver, nothing to do!
        mov     ax,0400h                ; set up for call
;        mov     bp,PktVect
;        pushf
;        call    far [bp]                ; simulate interrupt
        int     65h
        jnc     pkt_send_ok
        xor     ax,ax
        mov     al,dh
        pop     ds
        ret
pkt_send_ok:
        xor     ax,ax
pkt_send_exit:
        pop     ds
        ret
pkt_send        endp

;
;       On Entry:       ax = vector, bx = class, cx = irq, ES:DI = buffer
;       On Exit:        ax = status
;       ***  CALLED FROM DPMI CALLBACK!  ***
;
pkOpen  proc    far
        push    es
        push    cs
        pop     ds                      ; point to our data
        xor     ax,ax
        call    FindVector
        cmp     iphdl,-1
        jne     pkOpenExit              ; been here before ... done
        cmp     bx,1
        jl      pkOpenBad
        cmp     bx,11
        jg      pkOpenBad
        jmp     pkOpenOk
pkOpenBad:
        mov     bx,IC_ETHERNET          ; force class >1 && <11
pkOpenOk:
        push    ax
        push    bx      ; preserve
                                        ; set up for ip handle
        push    bx                      ; class
        push    IT_ANY                  ; type
        push    0                       ; IF number
        mov     bx,offset iptype
        push    bx
        mov     bx,cs                   ; ip type exists in our segment
        push    bx
        push    2                       ; size of type
        mov     bx,offset IntCB         ; offset handler
        push    bx
        mov     bx,SEG IntCB            ; segment handler
        push    bx
        call    pkt_access_type
        cmp     ax,-1
        jne     pkOpenOk1
        mov     ax,-2                   ; error out
        jmp     pkOpenExit
pkOpenOk1:
        mov     iphdl,ax                ; save the ip handle
        pop     bx
        pop     ax
        push    ax
        push    bx      ; preserve
                                        ;setup for arp handle
        push    bx                      ; class
        push    IT_ANY                  ; type
        push    0                       ; IF number
        mov     bx,offset arptype
        push    bx
        mov     bx,cs
        push    bx
        push    2                       ; size of type
        mov     bx,offset IntCB         ; offset handler
        push    bx
        mov     bx,SEG IntCB            ; segment handler
        push    bx
        call    pkt_access_type
        cmp     ax,-1
        jne     pkOpenOk2
        mov     ax,-3                   ; error out
        jmp     pkOpenExit
pkOpenOk2:
        mov     arphdl,ax               ; save the arp handle
        pop     bx
        pop     ax
        push    ax
        push    bx      ; preserve
                                        ;setup for rarp handle
        push    bx                      ; class
        push    IT_ANY                  ; type
        push    0                       ; IF number
        mov     bx,offset rarptype
        push    bx
        mov     bx,cs
        push    bx
        push    2                       ; size of type
        mov     bx,offset IntCB         ; offset handler
        push    bx
        mov     bx,SEG IntCB            ; segment handler
        push    bx
        call    pkt_access_type
        cmp     ax,-1
        jne     pkOpenOk3
        mov     ax,-4                   ; error out
        jmp     pkOpenExit
pkOpenOk3:
        mov     rarphdl,ax              ; save off the rarp handle
        pop     bx
        pop     ax
                                        ; set up for Get Address
        push    cs
        pop     es                      ; point ES:DI to the temp buffer
        mov     di,offset TempBuf
        mov     bx,iphdl
        mov     cx,6                    ; length of address
        call    pkt_get_address
                                        ; set up for set rcv mode
        pusha
        mov     bx,iphdl
        mov     cx,3
        call    pkt_set_rcv_mode
        popa
        xor     ax,ax                   ; all done, no error
pkOpenExit:
        pop     es
        retf
pkOpen  endp

pkClose proc    far
        push    cs
        pop     ds                      ; point to our data
        mov     bx,iphdl
        call    pkt_rel_type
        mov     bx,arphdl
        call    pkt_rel_type
        mov     bx,rarphdl
        call    pkt_rel_type
        xor     ax,ax
        retf
pkClose endp

;
;       On Entry:       Packet is in TempBlock, CX = byte count
;
;
pkXmit  proc    far
        pusha
        push    cs
        pop     ds                      ; point to data
        cmp     cx,60
        jge     pkXmitOk
        mov     cx,60                   ; what a hack!
pkXmitOk:        
        mov     si,offset TempBuf
        call    pkt_send
        mov     rtnval,ax
        popa
        mov     ax,rtnval
        cmp     ax,0
        je      pkXmitExit
        mov     ax,-1
pkXmitExit:
        retf
rtnval  dw      0h
pkXmit  endp

pkRecv  proc    far
        ; routine not used for packet drivers, not even called from Windows
        retf
pkRecv  endp

;
;       On Entry:       ax = vector, bx = class
;       On Exit:        ax = status, TempBuf = address
;       ***  CALLED FROM DPMI CALLBACK!  ***
;
pkGetaddr  proc    far
        push    cs
        pop     ds
        cmp     iphdl,-1
        jne     pkGetOk                 ; already opened
        xor     cx,cx
        call    pkOpen                  ; open it up - regs are same
pkGetOk:
                                        ; set up for Get Address
        push    ds
        pop     es
        mov     di,offset TempBuf
        mov     bx,iphdl
        mov     cx,6                    ; length of address
        call    pkt_get_address
        xor     ax,ax
        retf
pkGetaddr  endp

pkUpdate  proc    far
        push    cs
        pop     ds                              ; Point to data
        mov     bx,offset smBuf                 ; point to shared mem block
        mov     di,offset ioBuf
;DEBUG
        SUB     di,20h
;DEBUG
        add     di,[bx+BufRead]                 ; get the byte position
        mov     ax,WORD PTR [di]                ; get the packet size
        add     ax,2
        mov     cx,ax                           ; store it off in CX for later
        add     WORD PTR [bx+BufRead],ax        ;bufread+=packet_size+2
        mov     ax,WORD PTR [bx+BufRead]
        cmp     WORD PTR [bx+BufEnd],ax
        jb      pkUpdate1
        jmp     pkUpdate2
pkUpdate1:                                      ;bufread>bufend
        mov     ax,[bx+BufOrg]
        mov     [bx+BufRead],ax                 ;bufread=buforg
pkUpdate2:
        cli
        mov     ax,cx
        sub     [bx+BufBig],ax                  ;bufbig-=packet_size+2
        sti
        retf
pkUpdate  endp

IntCB   proc    far
        push    ds
        push    cs
        pop     ds                      ; point to our data
;        mov     dx, offset IntCBS        ; print on aux terminal
;        mov     ah, 40h
;        mov     bx, 03h
;        mov     cx, IntCBS_len
;        int     21h
;        pop     ds
;        mov     di,0
;        mov     es,di
;        retf
;
;       routine below blows up if allowed to run.  Possible writing
;       past the end of the segment?  After failure you will eventually
;       hang the entire machine. Also get lots of out of memory errors
;       once it's humped.  stack looks good, still confusion about iret
;
        mov     di,0                    ;default answer - no room
        mov     es,di
        mov     bx,offset smBuf                    ; point to shared mem block
        mov     WORD PTR [bx+holdcx],cx
        mov     BYTE PTR [bx+debug],9

;        cmp     ax,0
        cmp     cx,0                            ; possible kludge
        je      IntCBExit

        mov     BYTE PTR [bx+debug],1

        mov     ax,[bx+BufBig]
        cmp     WORD PTR [bx+BufLim],ax         ;check buffer space
        jae     IntCB1

        mov     BYTE PTR [bx+debug],2

        jmp     IntCBElse
IntCB1:

        mov     BYTE PTR [bx+debug],3

        mov     ax,WORD PTR [bx+BufPtr]          ;past end?
;        cmp     WORD PTR [bx+BufEnd],ax
        cmp     WORD PTR [bx+BufLim],ax
        jb      IntCB2


        mov     BYTE PTR [bx+debug],4
        jmp     IntCB3
IntCB2:
        mov     BYTE PTR [bx+debug],5
;        mov     ax,WORD PTR [bx+BufOrg]         ; wrap it around
        xor     ax,ax                           ; force to 0
        mov     WORD PTR [bx+BufPtr],ax
IntCB3:
;        mov     ax,WORD PTR [bx+BufPtr]
;        mov     save_size_ptr,ax                   ;save_size=(int *)bufpt
;DEBUG
;        mov     WORD PTR [bx+BufPtr],0
;DEBUG
        add     WORD PTR [bx+BufPtr],2           ;bufpt+=sizeof(int)
        mov     ax,WORD PTR [bx+BufPtr]
        mov     WORD PTR [where],ax             ;where=bufpt
        mov     di,offset ioBuf                 ; load ES:DI with buffer addr
;DEBUG
        sub     di,20h
;DEBUG        
        add     di,[where]
        push    ds
        pop     es
;        mov     cx,WORD PTR[bx+holdcx]
        mov     [di-2],cx                        ; save size
        add     WORD PTR [bx+BufPtr],cx          ;bufpt+=cx
        add     cx,2
; was mov below!
        add     WORD PTR [bx+BufBig],cx         ;bufbig+=cx+2
;        mov     WORD PTR [bx+BufBig],cx         ;bufbig+=cx+2
        mov     BYTE PTR [bx+debug],6
        mov     WORD PTR [bx+debug1],di
        mov     ax,where
        mov     WORD PTR [bx+debug2],ax
        mov     WORD PTR [bx+debug3],cx
        mov     ax,WORD PTR [bx+BufPtr]
        mov     WORD PTR [bx+debug4],ax
        jmp     IntCBExit
IntCBElse:
        mov     BYTE PTR [bx+debug],7
        xor     ax,ax                           ; signal no room
        mov     es,ax
        mov     di,ax
IntCBExit:
        pop     ds
        iret
save_size_ptr   dw      0
where           dw      0
IntCBS  db     cr,lf,'CallBack Int',cr,lf
IntCBS_len equ $ - IntCBS
IntCB   endp

;
;       On Entry:       BX:DI = IO Buffer address, DX:SI = Common block address
;       On Exit:        AX=4a4ch
;

IntRtn  proc    far
        push    cs
        pop     ds

; DEBUG
;        mov     dx, offset Int66        ; print on aux terminal
;    mov ah, 40h
;    mov bx, 03h
;        mov     cx, Int66_len
;        int     21h
; DEBUG
        mov     si,offset smBuf

        mov     [si+rmcb_open],offset pkOpen    ;Set up the callback addresses
        mov     [si+rmcb_open+2],SEG pkOpen

        mov     [si+rmcb_close],offset pkClose
        mov     [si+rmcb_close+2],SEG pkClose

        mov     [si+rmcb_xmit],offset pkXmit
        mov     [si+rmcb_xmit+2],SEG pkXmit

        mov     [si+rmcb_recv],offset pkRecv
        mov     [si+rmcb_recv+2],SEG pkRecv

        mov     [si+rmcb_getaddr],offset pkGetaddr
        mov     [si+rmcb_getaddr+2],SEG pkGetaddr

        mov     [si+rmcb_update],offset pkUpdate
        mov     [si+rmcb_update+2],SEG pkUpdate

        mov     ax,4a4ch                ; return our signature
        mov     bx,offset smBuf         ; shared memory block
        mov     cx,offset ioBuf         ; I/O memory block
;DEBUG
        sub     cx,20h
;DEBUG
        mov     dx,offset TempBuf       ; temporary buffer
                                        ; DS contains the segment for above
        iret
Int66     db      cr,lf,'Int 66 Called..',cr,lf
Int66_len      equ     $ - Int66
IntRtn  endp

        ALIGN 16
TempBuf         db      2048 dup("T")    ; Temporary Buffer
smBuf           db      2048 dup("S")    ; Shared Memory Buffer
ioBuf           db      18000 dup(0)  ; I/O buffer


;*****  End of Resident Section -  Anything below this gets blown away!  *****
pgm_len     equ $ - start

init:
        push    cs
        pop     ds                              ; point to our data
        mov     dx, offset IntRtn
        mov     ax, 2566h                       ; Default to int x66
    int 21h
        
        mov     dx, offset tsr_installed        ; print on main terminal
    mov ah, 40h
        mov     bx, 01h
        mov     cx, tsr_inst_len
        int     21h

    mov dx, ((pgm_len + 15) / 16) + 20h ;
    mov ax, 3100h
    int 21h

; At this point I'm dead
tsr_installed     db    cr,lf,'NCSABIND v1.0 sucessfully Installed on INT 0x66',cr,lf
xx                db    'The packet driver must be installed in INT 0x65',cr,lf
xx1               db    'Thanks to Joe Lepore for the DPMI code ',cr,lf
tsr_inst_len      equ     $ - tsr_installed

_TEXT   ENDS
         END    init
        
