/* cu-notic.txt      NCSA Telnet version 2.2C    2/3/89
   Notice:
        Portions of this file have been modified by
        The Educational Resources Center of Clarkson University.

        All modifications made by Clarkson University are hereby placed
        in the public domain, provided the following statement remain in
        all source files.

        "Portions Developed by the Educational Resources Center, 
                Clarkson University"

        Bugs and comments to bkc@omnigate.clarkson.edu
                                bkc@clgw.bitnet

        Brad Clements
        Educational Resources Center
        Clarkson University
*/

/* packet.c - FTP Software Packet Interface for NCSA TELNET
   Author: Brad Clements  bkc@omnigate.clarkson.edu
           Clarskon University
           10/24/88

   Assumes Microsoft C large model
*/
/*
*  packet.c
*****************************************************************************
*                                                                           *
*     part of:                                                              *
*     TCP/UDP/ICMP/IP Network kernel for NCSA Telnet                        *
*     by Tim Krauskopf                                                      *
*                                                                           *
*     National Center for Supercomputing Applications                       *
*     152 Computing Applications Building                                   *
*     605 E. Springfield Ave.                                               *
*     Champaign, IL  61820                                                  *
*                                                                           *
*****************************************************************************
*
*   Packet driver code modifed for Microsoft and Lattice C by
*       Quincey Koziol 8/18/89
*
*****************************************************************************
*
*   Modified for Windows        Joe Lepore  2-17-92
*
*   This code allows the above layers to make the calls in the normal way. All
*   calls are translated and made via DPMI to the real mode TSR.
*
*****************************************************************************
*/

#include "windows.h"
#include "roitcp.h"
#include "dos.h"
#include "stdlib.h"
#include "netevent.h"
#include "..\include\protocol.h"
#include "..\include\data.h"
#include "..\include\hostform.h"
#include "..\include\externs.h"

void FAR PASCAL OutDebStr(LPSTR);
void NEAR PASCAL tcperrhandle(void);

#define IC_ANY          0
#define IC_ETHERNET     1
#define IC_SLIP         6
#define IT_ANY          0xFFFF
#define errMsg OutputDebugString

RCALLSTRUCT RStruct = {0L,0L,0L,0L,0L,0L,0L,0L,0,0,0,0,0,0,0,0,0};
WORD      PCommonBlock, PIOBlock, PTempBlock;
WORD      RCommonBlock, RIOBlock, RTempBlock;
WORD      wDataSelector;
COMMONBLOCK _far *cb;
LPSTR       io;
LPSTR       tb;

int FAR PASCAL InitNetwork(void)
{
    int j;
    HGLOBAL hConfigFile;
    char far * config_tcp;

     hConfigFile=GlobalAlloc(GPTR,128);
     config_tcp=GlobalLock(hConfigFile);

     GetPrivateProfileString("config.tel","location","\\telnet\\config.tel",
        config_tcp,128,"ncsa_net.ini");

     RStruct.EAX=0;  // If these are not initialized, they dont seem to return values
     RStruct.EBX=0;
     RStruct.ECX=0;
     RStruct.EDX=0;
     if(!SimRealInt((BYTE)0x66)){
       MessageBox (GetActiveWindow(), "Init call to INT66 failed","ERROR!", MB_OK|MB_ICONSTOP) ;
       PostQuitMessage(0);
       return(FALSE);
     }

     if(RStruct.EAX!=0x4a4c){
       MessageBox (GetActiveWindow(), "INT66 Signature failed","ERROR!", MB_OK|MB_ICONSTOP) ;
       PostQuitMessage(0);
       return(FALSE);
     }

     // bx=smBuf  cx=ioBuf  dx=TempBuf, ds= common seg addr

     // I have no idea what the folling line does - thanks microsoft!
     wDataSelector = HIWORD((DWORD)(WORD FAR *)&wDataSelector);
     PCommonBlock = AllocSelector(wDataSelector);
     PIOBlock =     AllocSelector(wDataSelector);
     PTempBlock =   AllocSelector(wDataSelector);

     SetSelectorBase(PCommonBlock,(((DWORD)RStruct.DS)<<4)+RStruct.EBX);
     SetSelectorBase(PIOBlock,(((DWORD)RStruct.DS)<<4)+RStruct.ECX);
     SetSelectorBase(PTempBlock,(((DWORD)RStruct.DS)<<4)+RStruct.EDX);
     SetSelectorLimit(PCommonBlock,(DWORD)2048);
     SetSelectorLimit(PTempBlock,(DWORD)2048);
     SetSelectorLimit(PIOBlock,(DWORD)18000);

     cb=(COMMONBLOCK _far *) MAKELONG(0,PCommonBlock);
     tb=(LPSTR) MAKELONG(0,PTempBlock);
     io=(LPSTR) MAKELONG(0,PIOBlock);

     RCommonBlock = LOWORD(GetSelectorBase(PCommonBlock)>>4);
     RIOBlock =     LOWORD(GetSelectorBase(PIOBlock)>>4);
     RTempBlock =   LOWORD(GetSelectorBase(PTempBlock)>>4);

     cb->IoHandle=PIOBlock;
     cb->ThisHandle=PCommonBlock;
     cb->BufOrg=0;
     cb->BufBig=0;
     cb->BufEnd=12000;
     cb->BufRead=0;
     cb->BufLim=12000;
     cb->BufPtr=0;

     if (config_tcp) Shostfile((LPSTR)config_tcp);
     if(j=Snetinit()) {  /* Read in the config.tel file and fire up the network */
        errMsg("Error initializing network or getting configuration file\r\n");
        switch (j) {
            case -1:
                errMsg("Cannot initialize board.");
                break;

            case -5:
                errMsg("Error in config.tel file.");
                break;

            case -2:
                errMsg("RARP failed!!");
                break;

            case -3:
                errMsg("BOOTP failed!!");
                break;

            case -4:
                errMsg("X25 Initialization Failed!!");
                break;

            default:
                errMsg("Error from Snetinit()");
                break;
          } /* end switch */
     return(FALSE);
     }
     return(TRUE);
}

void NEAR PASCAL tcperrhandle(void)
{
     LPSTR errmsg;
     UINT i,j;

    while(ERR1==Sgetevent(ERRCLASS,(LPINT) &i,(LPINT) &j)){
        errmsg=neterrstring(j);
        MessageBox(NULL,errmsg,"TCPLIB.DLL",MB_ICONINFORMATION|MB_OK);
    }
}

int FAR PASCAL DestroyDll(void)
{
    if(PTempBlock)   FreeSelector(PTempBlock);
    if(PIOBlock)     FreeSelector(PIOBlock);
    if(PCommonBlock) FreeSelector(PCommonBlock);
    PTempBlock=PIOBlock=PCommonBlock=NULL;
    return(TRUE);
}


int pketopen(s,irq,address,ioaddr)
unsigned char *s;           /* ethernet address */
unsigned int    irq;            /* don't need this    */
unsigned int    address;        /* address is packet class */
unsigned int    ioaddr;         /* packet int, or 0 */
{
//OutDebStr("PACKET:pketopen:Calling DPMI");
    RStruct.CS=FP_SEG(cb->rmcb_open);
    RStruct.IP=FP_OFF(cb->rmcb_open);
    RStruct.EAX=ioaddr;                    // packet vector
    RStruct.ECX=irq;                       // irq - unused
    RStruct.EBX=address;                   // Class - IC_ANY
    MakeDPMICall(0x0301,0);
    movebytes(s,(void _far *)tb,6);
{char str[255];
    wsprintf(str,"PACKET:pketopen:returning %d",LOWORD(RStruct.EAX));
//    OutDebStr(str);

}
    return(LOWORD(RStruct.EAX));
}

int pkgetaddr(s,address,ioaddr)    /* get the ethernet address */
unsigned char   *s;         /* ethernet address */
unsigned int     address;       /* address is packet class */
unsigned int     ioaddr;        /* packet int, or 0 */
{
//OutDebStr("PACKET:pkgetaddr:entry");
    RStruct.CS=FP_SEG(cb->rmcb_getaddr);
    RStruct.IP=FP_OFF(cb->rmcb_getaddr);
    RStruct.EAX=ioaddr;                    // packet vector
    RStruct.ECX=0;                         // irq - unused
    RStruct.EBX=address;                   // Class - IC_ANY
    MakeDPMICall(0x0301,0);
    movebytes(s,(void _far *)tb,6);
//OutDebStr("PACKET:pkgetaddr:exit");
    return(LOWORD(RStruct.EAX));
}

void pkrecv()                       /* no op for this interface  */
{
}

int pketclose()                  /* throw away our handles */
{
//OutDebStr("PACKET:pketclose:entry");
    RStruct.CS=FP_SEG(cb->rmcb_close);
    RStruct.IP=FP_OFF(cb->rmcb_close);
    MakeDPMICall(0x0301,0);
//OutDebStr("PACKET:pketclose:exit");
    return(0);
}

int pkxmit(DLAYER *packet,int length)          /* transmit a packet */
{
//OutDebStr("PACKET:xmit:called");
    movebytes((void _far *)tb,(void _far *)packet,length);
    RStruct.CS=FP_SEG(cb->rmcb_xmit);
    RStruct.IP=FP_OFF(cb->rmcb_xmit);
    RStruct.ECX=length;
    MakeDPMICall(0x0301,0);
    return(LOWORD(RStruct.EAX));
}

void pketupdate()                   /* update the pointers */
{
    RStruct.CS=FP_SEG(cb->rmcb_update);
    RStruct.IP=FP_OFF(cb->rmcb_update);
    MakeDPMICall(0x0301,0);
}

//          DPMI Helper Subroutines Follow:

BOOL SimRealInt(BYTE InterruptNumber)
{
 BOOL ret_value;

 ret_value = MakeDPMICall( 0x0300, InterruptNumber);
 return( ret_value );
}

BOOL MakeDPMICall(int DPMIFunc, BYTE bl_value)
{
 BOOL ret_value;

  RStruct.SS=0;
  RStruct.SP=0;         // force DPMI to give us a stack to work with
 _asm
 {
  push di                             ;Save old junk
  push es                             ;Save old junk

  mov  bl, byte ptr bl_value          ;Get value of bl
  mov  bh, 00h                         ;For DOSX to reset the int controller
                                      ;and A20 line.  Windows/386 ingores it.
  xor  cx, cx                         ;0 bytes to copy to real mode stack
  mov  ax, seg RStruct + 2            ;Get selector of real mode structure
  mov  es, ax                         ;Put it where it belongs
  mov  di, offset RStruct             ;Get offset of real mode structure
  mov  ax, word ptr DPMIFunc          ;Get DPMI function number
  int  31h                            ;Returns CF set on error, else

  jc   ErrSRI

  mov  ret_value, 1                   ;Return TRUE
  jmp  EndSRI                         ;Jump to all-done

ErrSRI:                              
  mov  ret_value, 0                   ;Return FALSE

EndSRI:                               ;All done this ASM stuff.
  pop  es                             ;Get back old junk
  pop  di                             ;Get back old junk
 }
 return( ret_value );
}

