
/*
*  netroi.c
*****************************************************************************
*                                                                           *
*     part of:                                                              *
*     TCP/UDP/ICMP/IP Network kernel for NCSA Telnet                        *
*     by Tim Krauskopf                                                      *
*                                                                           *
*     National Center for Supercomputing Applications                       *
*     152 Computing Applications Building                                   *
*     605 E. Springfield Ave.                                               *
*     Champaign, IL  61820                                                  *
*                                                                           *
*****************************************************************************
*
*  those generic tool-type things that only work on PCs.
*  includes all hardware-level calls to Ethernet that are unique to the PC
*
*  Function pointers for Ether calls
*
*   Modified to allow only packet drivers - not individual card drivers
*   9-19-91 JPL
*   Modified for Windows Compatibility  - JPl  2-13-92
*
*/

#include "windows.h"
#include "roitcp.h"

extern COMMONBLOCK *cb;
extern LPSTR io;

void _far _pascal OutDebStr(char _far *);

#include <stdio.h>
#include <string.h>
#include "../include/protocol.h"
#include "../include/data.h"
#include "../include/hostform.h"
#include "../include/externs.h"

/*
*   defined in assembly language file for interrupt driven Ether buffering
*
*/

struct config def;

/*
*  Declare each and every Ethernet driver.
*  To add a driver, pick a unique 2 char prefix and declare your own
*  routines.  I want to keep the same parameters for EVERY driver.
*  If your driver needs additional parameters, then see netconfig() below 
*  for an indication of where to put custom board code.
*/
extern int pketopen(),pkgetaddr(),pkxmit(),pketclose();
extern void pkrecv(),pketupdate();

#ifdef __WATCOMC__
static int cdecl
#else
static int 
#endif /* __WATCOMC__ */
    (*etopen)(unsigned char *s,unsigned int irq,unsigned int addr,
      unsigned int ioaddr)=NULL,                    /* open the device */
    (*getaddr)(unsigned char *s,unsigned int addr,
      unsigned int ioaddr)=NULL,                    /* get the Ether address */
    (*setaddr)(char *s,int addr,int ioaddr)=NULL,   /* set the Ether address */
    (*etclose)(void )=NULL,                         /* shut down network */
    (*xmit)(DLAYER *packet,int count)=NULL;         /* transmit a packet */
#ifdef __WATCOMC__
static void cdecl
#else
static void
#endif /* __WATCOMC__ */
    (*recv)(void )=NULL,                        /* load a packet from queue  */
    (*etupdate)(void )=NULL;                    /* update pointers in buffer */

/**********************************************************************/
/*  statcheck
*   look at the connection status of the memory buffers to see if the
*   allocation schemes are working.  Only used as a debug tool.
*/

void statcheck(void )
{
    int i;
    struct port *p;

    for(i=0; i<20; i++) {
        printf("\n%d > ",i);
        p=portlist[i];
        if(p!=NULL) 
            printf("state: %d  %5u  %5u  %10ld  %5d  %5d",
                    p->state,intswap(p->tcpout.t.source),
                    intswap(p->tcpout.t.dest),p->out.lasttime,p->rto,
                    p->out.contain);
      } /* end for */
}

/*************************************************************************/
/*  config network parameters
*   Set IRQ and DMA parameters for initialization of the 3com adaptor
*/
static uint nnirq=3,nnaddr=0xd000,nnioaddr=0x300;

int netparms(irq,address,ioaddr)
uint irq,address,ioaddr;
{
    nnirq=irq;
    nnaddr=address;
    nnioaddr=ioaddr;
    return(0);
}

/**********************************************************************/
/* netconfig
*  load the function pointers for network access
*  Currently setaddr() is not used, so it isn't loaded.
*
*  Note that netparms is called BEFORE netconfig.  So if you have any
*  really special variables to set for your board that involve
*  irq,address and ioaddr, you can add calls to your special routines
*  in this section.
*
*  Some drivers will do the interrupt driver and board initialization
*  in etopen() and some will do it in getaddr().
*/
void netconfig(s)
char *s;
{

    Sgetconfig(&def);               /* get information provided in hosts file */

//  For now there's no choice - packet drivers only
//    if(!strncmp(s,"packet",6)) {
        etopen=pketopen;
        xmit=pkxmit;
        recv=pkrecv;
        getaddr=pkgetaddr;
        etupdate=pketupdate;
        etclose=pketclose;
//      }
//    }
//    else {      /* default choice = 3c501 */
//        etopen=E1etopen;
//        xmit=E1xmit;
//        recv=E1recv;
//        getaddr=E1getaddr;
//        etupdate=E1etupdate;
//        etclose=E1etclose;
//    }
}

/**********************************************************************/
/*  netarpme
*   send an arp to my address.  arpinterpret will notice any response.
*   Checks for adapters which receive their own broadcast packets.
*/
int netarpme(s)
char *s;
{
    reqarp(s);      /* send it */
    return(0);
}


int initbuffer()
{

    cb->BufPtr=cb->BufRead=cb->BufOrg=0;   /*  start at the beginning */
    cb->BufBig=0;
    cb->BufEnd= 14500;                /* leave 2K breathing room, required */
    cb->BufLim= 12000;                /* another 2K breathing room */
    (*getaddr)(nnmyaddr,nnaddr,nnioaddr);

#ifdef NETD
    printf("Addr=%x.%x.%x.%x.%x.%x\n",nnmyaddr[0],nnmyaddr[1],nnmyaddr[2],
        nnmyaddr[3],nnmyaddr[4],nnmyaddr[5]);
#endif
    return(0);
}

/**********************************************************************/
/*   demux
*     find the packets in the buffer, determine their lowest level
*  packet type and call the correct interpretation routines
*
*  the 'all' parameter tells demux whether it should attempt to empty
*  the input packet buffer or return after the first packet is dealt with.
*
*  returns the number of packets demuxed
*/
int demux(all)
int all;
{
    uint16 getcode;
    int nmuxed;
    DLAYER *firstlook;
    UINT iTemp;

    nmuxed=0;
    if(!etupdate) return(0);
    do {                            /* while all flag is on */
//        (*recv)();                  /* NULL operation for 3COM & windows*/

        if(cb->BufBig>0) {
            nmuxed++;
            iTemp=((UINT)(cb->BufRead)+2);
            firstlook=(DLAYER *)&io[iTemp];    /* where packet is */
            getcode=firstlook->type;        /* where does it belong? */
            switch(getcode) {               /* what to do with it? */
                case EARP:
                case ERARP:
//OutDebStr("NETROI:demux:ARP");
                    arpinterpret((ARPKT *)firstlook);   /* handle ARP packet */
                    break;
                case EIP:
//OutDebStr("NETROI:demux:IP");
                    ipinterpret((IPKT *)firstlook);
                    break;
                default:
/*
{char str[2048]; int x;
    wsprintf(str,"NETROI:demux:buf %8lx, tp=%x, Big %d, dst %2x%2x%2x%2x%2x%2x, me %2x%2x%2x%2x%2x%2x",
      firstlook,getcode,cb->BufBig,
      firstlook->dest[0],firstlook->dest[1],firstlook->dest[2],
      firstlook->dest[3],firstlook->dest[4],firstlook->dest[5],firstlook->me[0],
      firstlook->me[1],firstlook->me[2],firstlook->me[3],firstlook->me[4],
      firstlook->me[5]);
//    OutDebStr(str);
}
*/
                    break;
              } /* end switch */
{char str[255]; int x;
//    wsprintf(str,"NETROI:bufread %x, bufbig %d",cb->BufRead,(UINT)cb->BufBig);
//    OutDebStr(str);
// DEBUG
//            (*etupdate)();      /* update read pointers in buffer, free packet */

    {LPINT lpTemp; UINT iTemp;

_asm    cli
{
  long y;                       // this gets around a C6 bug
        lpTemp=(LPINT)io;
        y=lpTemp;
        y+=cb->BufRead;
//        lpTemp+=(cb->BufRead);
        lpTemp=y;
        iTemp=*lpTemp;
}

//    wsprintf(str,"NETROI:bufread %x, bufbig %d, Size %d, lpTemp %8lx\r\n",cb->BufRead,(UINT)cb->BufBig,iTemp,lpTemp);
//    OutDebStr(str);
//    lstrcpy(str,">"); for(x=0;x<16;x++) {wsprintf(str,"%s <%8lx - %x>",str,lpTemp,lpTemp[x]);}
//    OutDebStr(str);

//_asm    cli
        cb->BufBig-=(iTemp+2);
        cb->BufRead+=(iTemp+2);
// was 60 below
        if((int)cb->BufBig<0){ // kludge - dont know why this is getting fucked up
wsprintf(str,"NETROI:KLUDGE!!!!:BufBig = %d",cb->BufBig);OutDebStr(str);
          cb->BufBig=0;
          cb->BufRead=0;
          cb->BufPtr=0;
        }
//        if(cb->BufRead>cb->BufEnd) {
        if(cb->BufRead>cb->BufLim) {
            cb->BufRead=0;
//            cb->BufPtr=0;
//            cb->BufBig=0;
//            OutDebStr("NETROI:reset buffer");
        }
_asm    sti


    }

// DEBUG

//    wsprintf(str,"NETROI:bufread %x, bufbig %d",cb->BufRead,(UINT)cb->BufBig);
//    OutDebStr(str);
}
          } /* end if */
        else 
            all=0;
      } while(all);     /* should we look for more to deal with? */
    return(nmuxed);     /* no packets anymore */
}

/************************************************************************/
/*  dlayersend
*
*  usage:   err=dlayersend(ptr,size)
*     err=0 for successful, non-zero error code otherwise
*     ptr is to a dlayer packet header
*     size is the number of bytes total
*
*  This particular dlayer routine is for Ethernet.  It will have to be
*  replaced for any other dlayer.
*
*  Ethernet addresses are resolved at higher levels because they will only
*  need to be resolved once per logical connection, instead of once per
*  packet.  Not too layer-like, but hopefully modular.
*
*/

int dlayersend(ptr,size)
DLAYER *ptr;
unsigned size;
{
    int ret;

#ifdef OLD_WAY
    if(size<60) size=60;
    if(size&0x01) size+=1;
#else
    unsigned char *c;

    c=(unsigned char *)ptr;
    *(c+size++)=0;      /* NULL pad last char */
    *(c+size++)=0;      /* NULL pad last char */
#endif
//OutDebStr("NETROI:dlayersend:entry");

    ret=(*xmit)((DLAYER *)ptr,size);    /* send it out, pass back return code */
                                    /* xmit checks for size < 60 */
{char str[255];
    if(ret){
        wsprintf(str,"NETROI:dlayersend:packet xmit error %d",ret);
        OutDebStr(str);
    }
}

/*
*   automatic, immediate retry once
*/
    if(ret) {
        if(ret==(*xmit)((DLAYER *)ptr,size)) nnerror(100);       /* post user error message */
    }
{char str[255];
    if(ret){
        wsprintf(str,"NETROI:dlayersend:packet xmit error %d on retry",ret);
        OutDebStr(str);
    }
}
    return(ret);
}

/***************************************************************************/
/* dlayerinit
*  Do machine dependent initializations of whatever hardware we have
*  (happens to be ethernet board here ) 
*/
int dlayerinit(void )
{
    int my_var;
//OutDebStr("NETROI:Calling InitBuffer()");
    if(initbuffer() || !etopen) return(-10);

/*
 * Call (*etopen) first to be sure any board/driver initializations are taken care of
 */
//OutDebStr("NETROI:Calling card open routine");
    my_var = ((*etopen)(nnmyaddr,nnirq,nnaddr,nnioaddr));
    return my_var;
}

void dlayershut(void )
{
    if(etclose) (*etclose)();
}

/***************************************************************************/
/*  pcgetaddr
*   return results from indirect getaddr call.
*   This is a pc-specific request for the 48-bit address which was added
*   so that the user program could print the value.
*/
void pcgetaddr(s,x,y)
char *s;
int x,y;
{
    if(getaddr) (*getaddr)(s,x,y);
}
