;
;  ncsaio.asm
;  Support for BIOS calls in NCSA Telnet
;****************************************************************************
;*																			*
;*																			*
;*	  part of NCSA Telnet													*
;*	  by Tim Krauskopf, VT100 by Gaige Paulsen, Tek by Aaron Contorer		*
;*																			*
;*	  National Center for Supercomputing Applications						*
;*	  152 Computing Applications Building									*
;*	  605 E. Springfield Ave.												*
;*	  Champaign, IL  61820													*
;*																			*
;*																			*
;****************************************************************************

	TITLE	NCSAIO	-- LOW-LEVEL I/O FOR SANE HARDWARE HANDLING

;
;   From original code by Tim Krauskopf	1984-1985
;
;   Modified and ported to Lattice C, Sept. 1986
;   ifdefs for Microsoft C, June 1987
;   Tim Krauskopf
;
;   Modified for version 2.3 release May 1990 by Heeren Pathak
;
;   National Center for Supercomputing Applications
;
	NAME	NIO

;
;  Macros for reading and writing I/O ports
;
MOUT	MACRO	REG,STUFF	   ; one byte to the given I/O register
	MOV		DX,REG
	MOV		AL,STUFF
	OUT		DX,AL
	ENDM
;
MIN	MACRO	REG		 		; get one byte to al
	MOV		DX,REG
	IN		AL,DX
	ENDM
;
;  Internal data 
;
X 	EQU	6					;  for the large model programs

ifdef Microsoft
DGROUP	group	_DATA
_DATA	segment	public 'DATA'
	assume	DS:DGROUP

	PUBLIC _DTAPTR				; pointer to dta location
_DTAPTR 	DW	0000H			; DTA address for me
_DTADS		DW	0000H			; DS for DTA
_KEYBOARD_TYPE	DB	?			; KEYBOARD TYPE (0) - is standard
								; (0x10) is enhanced
else
	INCLUDE	DOS.MAC
	DSEG
	PUBLIC	DTAPTR				; pointer to dta location
DTAPTR		DW	0000H			; dta ADDRESS FOR ME
DTADS		DW	0000H			; ds FOR dta
KEYBOARD_TYPE	DB	?			; KEYBOARD TYPE (0) - is standard
                                                          ; (0x10) is enhanced
endif

ATT                     DB      7               ; CURRENT DEFAULT ATTRIBUTE
TOPL            DB      00                      ; TOP LINE OF CURRENT WINDOW
BOTL            DB      24                      ; BOTTOM LINE OF CURRENT WINDOW
LEFTC           DB      00                      ; LEFT SIDE OF CURRENT WINDOW
RIGHTC          DB      79                      ; RIGHT SIDE OF CURRENT WINDOW
ROW                     DB      00              ; CURSOR POSITION ROW
COL                     DB      00              ; CURSOR POSITION COL
WRAP            DB      00                      ; WRAP AT END OR NOT
REGEN		DW	0B000H			; DEFAULT TO COLOR SCREEN
CURSOR  	DW  0607H			; DEFAULT CURSOR SHAPE
CURSOR_SAVE     DW      ?                       ; PLACE TO SAVE THE USER'S CURSOR IN
BREAK_STATE     DB      ?                       ; WHETHER THE BREAK IS SET TO ON OR OFF
EGAMODE 	DB  ?				; DEFAULT EGA MODE

ifdef Microsoft
_DATA	ends
else
	ENDDS
endif
;
;
;
;   The subroutines to call from C
;
ifdef Microsoft
_TEXT	segment	public	'CODE'
	assume CS:_TEXT
	PUBLIC	_n_color,_n_upscroll,_n_dnscroll,_n_wrap,_n_erase,_n_getchar
	PUBLIC  _n_cur,_n_row,_n_col,_n_clear,_n_window,_n_putchar,_n_chkchar
	PUBLIC  _n_savewin,_n_restwin,_n_puts,_n_sound,_n_findfirst,_n_findnext
	PUBLIC  _n_draw,_n_scrup,_n_scrdn,_n_cheat,_n_clicks,_n_biosattr
	PUBLIC  _getdsk, _chgdsk, _ega43,_n_flags,_set_cur,_ega24,_n_scrlck
	PUBLIC	_save_break,_restore_break,_n_gmode,_save_cursor,_restore_cursor
	PUBLIC  _install_cursor, _n_attr, _install_keyboard
	PUBLIC	_fix_vid
else
	PSEG
	PUBLIC	n_color,n_upscroll,n_dnscroll,n_wrap,n_erase,n_getchar
	PUBLIC  n_cur,n_row,n_col,n_clear,n_window,n_putchar,n_chkchar
	PUBLIC  n_savewin,n_restwin,n_puts,n_sound,n_findfirst,n_findnext
	PUBLIC  n_draw,n_scrup,n_scrdn,n_cheat,n_clicks,n_biosattr,n_srclck
	PUBLIC  ega43,n_flags,set_cur,ega24,save_break,restore_break,g_mode
	PUBLIC	save_cursor,restore_cursor,install_cursor,n_attr,install_keyboard
	PUBLIC	fix_vid
endif


;****************************************************************
; install_keyboard
;
; check for enhanced keyboard, and set keyboard type variable
;
;
ifdef Microsoft
_install_keyboard	proc 	far
else
install_keyboard	proc	far
endif
	PUSH	DS
	PUSH	SI
        MOV             AX,040H                 ; load the address of the keyboard flag
	MOV		DS,AX
	MOV		SI,096H
        LODSB                                   ; get the keyboard flag
	POP		SI
	POP		DS
        AND             AL,10H                  ; mask off all bits except the enhanced flag
ifdef Microsoft
	MOV		_KEYBOARD_TYPE,AL	; store the keyboard type
else
	MOV		KEYBOARD_TYPE,AL	; store the keyboard type
endif
    RET
ifdef Microsoft
_install_keyboard	endp
else
install_keyboard	endp
endif

;****************************************************************
; install cursor
;
; put in user defined cursor settings
;
;
ifdef Microsoft
_install_cursor	proc 	far
else
install_cursor	proc	far
endif
		push	bp	 	; save the base pointer
		mov	bp,sp		; point to the stack
		mov	AX,[bp+x]	; read our first parameter
		mov	CURSOR, AX	; save into the cursor variable
		pop	bp		; get the old base
		ret			; exit
ifdef Microsoft
_install_cursor	endp
else
install_cursor	endp
endif

;/***************************************************************/
; scrlck
;   returns whether scroll lock is on or not
;
ifdef Microsoft
_n_scrlck	proc	far
else
n_scrlck	proc	far
endif
		push bp
		mov		ax,0200h		; get shift states
                int             16h                     ; keyboard int
		and		al,010h			; scroll lock state bit
		xor		ah,ah
		pop bp
		ret	
ifdef Microsoft
_n_scrlck	endp
else
n_scrlck	endp
endif

;*********************************************************************
;*	  save_break
;*	  record the state of the DOS BREAK status, and turn BREAK ON
;*
ifdef Microsoft
_save_break	proc	far
else
save_break	proc 	far
endif
	PUSH	BP

        MOV             AX,3300H                ; request current break state
	INT		21H					;
	MOV		BREAK_STATE,DL		; preserve the break state

        MOV             AX,3301H                ; set break state
        MOV             DL,1                    ; turn break on
	INT		21H					;

	POP 	BP
	RET
ifdef Microsoft
_save_break 	endp
else
save_break	endp
endif	

;*********************************************************************
;*	  restore_break
;*	  restore the previous state of the DOS BREAK state
;*
ifdef Microsoft
_restore_break	proc	far
else
restore_break	proc 	far
endif
	PUSH	BP

        MOV             AX,3301H                ; set break state
	MOV		DL,BREAK_STATE		; return break state to previous value
	INT		21H					;

	POP 	BP
	RET
ifdef Microsoft
_restore_break 	endp
else
restore_break	endp
endif	

;*********************************************************************
;*	  save_cursor
;*	  record the state of the DOS keyboard cursor for page 0
;*
ifdef Microsoft
_save_cursor	proc	far
else
save_cursor	proc 	far
endif
	PUSH	BP

	MOV		AX,0300h			; GET THE CURRENT CURSOR TYPE
	MOV		BX,0000h			; INFO FOR PAGE 0
	INT	10h
	MOV		CURSOR_SAVE,CX

	POP 	BP
	RET
ifdef Microsoft
_save_cursor 	endp
else
save_cursor	endp
endif	

;*********************************************************************
;*	  restore_cursor
;*	  restore the previous state of the DOS keyboard cursor
;*
ifdef Microsoft
_restore_cursor	proc	far
else
restore_cursor	proc 	far
endif
	PUSH	BP

	MOV		AH,01H			; set the keyboard cursor
	MOV		CX,CURSOR_SAVE	; get the user's keyboard cursor
	INT		10H				; set the cursor

	POP 	BP
	RET
ifdef Microsoft
_restore_cursor 	endp
else
restore_cursor	endp
endif	

;*********************************************************************
;*	  n_gmode
;*	  change the type of video display being used
;*
ifdef Microsoft
_n_gmode	PROC	FAR
else
n_gmode		PROC	FAR
endif
	PUSH	BP
	MOV		BP,SP
	
	MOV		AX,[BP+X]		;GET SCREEN MODE TO SWITCH TO
	XOR		AH,AH			;ENTER VIDEO_IO ROUTINE (SET MODE=0)
        INT             10H                     ;VIDEO INTERUPT

	POP	BP
	RET
ifdef Microsoft	
_n_gmode	ENDP
else
n_gmode	ENDP
endif

;*********************************************************************
;*	  ega24
;*	  set char set for 24 line mode
;*

ifdef Microsoft
_ega24	proc	far
else
ega24	proc 	far
endif
	PUSH	BP
	MOV		BP, SP
ifdef not_used
	PUSH 	DS
	PUSH 	SI
	PUSH 	DI
endif

	MOV	 	AL,3				; reset egamode
	XOR  	AH,AH
	INT 	10H

	MOV		AX,0100H			; SET CURSOR
	MOV		CX,CURSOR			; TURN ON
	INT 	10H

ifdef not_used
	POP 	DI
	POP 	SI
	POP		DS
endif
	POP 	BP
	RET
ifdef Microsoft
_ega24 	endp
else
ega24	endp
endif	

;****************************************************************
;*   set_cur
;*   sets cursor
;*

ifdef Microsoft
_set_cur 	proc	far
else
set_cur		proc	far
endif
	PUSH 	BP
	MOV		BP,SP
	MOV		AL,[BP+X]			;get var
	OR		AL,AL
        JNZ             CUR                             ; MAKE CURSOR
	MOV		AX,0100H			; TURN OFF
	MOV		CX,2000H			; BEGIN END OF CURSOR
	INT 	10h
    JMP     SHORT EXIT                ; we are done
CUR:	
	MOV		CX,CURSOR			; get cursOR type
	MOV		AX,0100h			; reset cursOR
	INT 	10h
EXIT:
	POP 	BP
	RET

ifdef Microsoft
_set_cur endp
else
set_cur endp
endif

;****************************************************************
;*   n_flags
;*	 returns the keyboard status flags
;*

ifdef Microsoft
_n_flags	proc	far
else
n_flags 	proc	far
endif
	PUSH 	BP
	MOV		AX,0200h			; get shift states
        INT             16h                             ; keyboard INT
	XOR		AH,AH
	POP 	BP
	RET	
ifdef Microsoft
_n_flags	endp
else
n_flags	endp
endif

;****************************************************************
;*   ega43
;*   code fOR 43 line ega mode
;*	 

ifdef Microsoft
_ega43 proc far
else
ega43 proc far
endif
	PUSH 	BP
ifdef not_used
	PUSH 	SI
	PUSH 	DI
	PUSH 	DS
endif

        MOV             AH,00H                  ; SET TO 80X25 CHAR MODE
	MOV		AL,03H
	INT		10H

        MOV             AX,1112H                ; CHAR. GENERATOR BIOS ROUTINUE
        MOV             BL,00H                  ; LOAD 8 BY 8 DOUBLE DOT CHARACTER FONT
        INT     10H                             ; VIDEO CALL

        MOV             AX,1200H                ; ALTERNATE SCREEN ROUTINE
        MOV             BL,20H                  ; SELECT ALTERNATE PRint SCREEN ROUTINE
        INT     10H                             ; VIDEO CALL

	MOV		AX,0007H	
        MOV             CURSOR,AX               ; full cursOR

ifdef not_used
	POP 	DS
	POP 	DI
	POP		SI
endif
	POP 	BP
	RET	
ifdef Microsoft
_ega43 	endp
else
ega43	endp
endif
	
;*****************************************************************
;*   getDSk
;*   gets the active drive
;*	 
ifdef Microsoft
_getdsk proc	far
	PUSH 	BP
	MOV		AH,19H
	INT		21h
	POP 	BP
	RET
_getdsk 	endp	
endif 		

;*****************************************************************
;*	 chgdsk
;*   changes current drive
;*

ifdef Microsoft
_chgdsk	proc	far
	PUSH	BP
	MOV		AH,0Eh
	MOV		DL,[BP+X]
	INT		21H
	POP		BP
	RET
_chgdsk	endp
endif

;*****************************************************************
;*  n_attr
;*  replaces char. attribute
;*

ifdef Microsoft
_n_attr	proc	far
else 
n_attr	proc	far
endif

	PUSH 	BP
	MOV		BP,SP
	PUSH 	ES
	PUSH	DI
;
;  fOR now, assume that the cursOR location has ALready been set
;  (cursOR is there)
;
	MOV		AX,REGEN
        MOV             ES,AX                   ; set up fOR segment where screen is

        MOV             AL,ROW                  ; row where chars go
	XOR		AH,AH
	MOV		BL,160
        MUL             BL                      ; AX now equALs start of row
	XOR		BH,BH

	MOV		BL,COL
        SHL             BL,1                    ; COL*2
        ADD             AX,BX                   ; add in column offset
	INC		AX
	MOV 	DI,AX
        MOV             AL,[BP+X]               ; ATTRIBUTE For CHARS
        STOSB                                   ; STorE aTTR

	POP		DI
	POP		ES
	POP		BP
	RET


ifdef Microsoft
_n_attr 	endp
else
n_attr	  endp
endif
		
;*****************************************************************
;*  n_biosattr
;*  replaces char. attribute
;*  uses bios instead of directly screen write
;*

ifdef Microsoft
_n_biosattr	proc	far
else 
n_biosattr	proc	far
endif
	PUSH 	BP
	MOV		BP,SP	
        MOV             AH,8h                   ; we want to read
        MOV             BH,0H                   ; GET FROM PAGE ZERO
	INT 	10H
        MOV             BL,[BP+X]               ; GET CHANGED ATTRIBUTE
        MOV             AH,9H                   ; WE WANT TO WRITE
        MOV             CX,1H                   ; ONLY ONCE
	INT 	10H
	POP 	BP
	RET
ifdef Microsoft
_n_biosattr 	endp
else
n_biosattr	  endp
endif

;/***************************************************************/
;
;   Change the vALue of my current colOR
;
ifdef Microsoft
_n_color	proc	far
else
n_color	proc	far
endif
	PUSH	BP
	MOV		BP,SP

	XOR		AX,AX
	MOV		DL,[BP+X]			; PARAMETER, ONE BYTE
	MOV		AL,ATT				; RETURN OLD COLor
	MOV		ATT,DL

	POP		BP
	RET
ifdef Microsoft
_n_color	endp
else
n_color	endp
endif

;/*****************************************************************/
;   Determine the current type of DISPlay
;
;   ask the BIOS which screen is currently active
;
ifdef Microsoft
_n_which	proc	far
else
n_which	proc	far
endif
	PUSH 	BP
	MOV		AH,0Fh				; get screen mode
	INT		10h					; cALl video BIOS
	CMP		AL,7				; is it mono?
	JZ		K1					; yes
	MOV		AX,0B800H			; NO, SET For COLor
        JMP     SHORT K2
K1: 
	MOV		AX,0B000H
K2: 
        MOV             REGEN,AX                        ; SAVE SCREEN REGION

	MOV		AX,0300h			; GET THE CURRENT
	MOV		BX,0000h			; INFO FOR PAGE 0
	INT	10h
	MOV		CURSOR,CX

	POP 	BP
	RET
ifdef Microsoft
_n_which	endp
else
n_which	endp
endif

;
;/***************************************************************/
;
;   Set whether wORd wrap will be on OR not
;   usage:  n_wrap(flag);
;
ifdef Microsoft
_n_wrap	proc	far
else
n_wrap	proc	far
endif
	PUSH	BP
	MOV		BP,SP
	MOV		DL,[BP+X]			; PARAMETER, ONE BYTE FLAG
	MOV		AL,WRAP				; RETURN OLD COLor
	MOV		WRAP,DL
	POP		BP
	RET
ifdef Microsoft
_n_wrap	endp
else
n_wrap	endp
endif

;/***************************************************************/
;
;   Move the cursOR somewhere
;
ifdef Microsoft
_n_cur	proc	far
else
n_cur	proc	far
endif
	PUSH	BP
	MOV		BP,SP

	MOV		DH,[BP+X]			; row poSItion
	MOV		DL,[BP+X+2]			; column poSItion
	MOV		ROW,DH				; save a copy fOR me
	MOV		COL,DL				; save column too
	MOV	 	AX,0200h			; ah=2 FUNCTION CalL
	XOR 	BX,BX				; video page 0
	INT  	10H	  			; set cursOR poSItion

	POP		BP
	RET
ifdef Microsoft
_n_cur	endp
else
n_cur	endp
endif

;/***************************************************************/
;
;  set the window boundaries
;
;  usage:  n_window(ulrow,ulcol,lrrow,lrcol);
;	 sets window SIze fOR future operations.
;
;
ifdef Microsoft
_n_window	proc	far
else
n_window	proc	far
endif
	PUSH		BP
	MOV			BP,SP
	MOV			AL,[BP+X]		; UPPER LEFT Y
	MOV			TOPL,AL
	MOV			AL,[BP+X+2]		; COLUMN POsiTION
	MOV			LEFTC,AL		; save a copy fOR me
	MOV			AL,[BP+X+4]
	MOV			BOTL,AL			; bottom row
	MOV			AL,[BP+X+6]
	MOV			RIGHTC,AL		; keep this one too
ifdef Microsoft
	CALL		_N_WHICH		; what kind of screen?
else
	CALL		N_WHICH			; WHAT KIND OF SCREEN?
endif
	POP			BP
	RET
ifdef Microsoft
_n_window	endp
else
n_window	endp
endif

;/***************************************************************/
;
;  erase pORtion of the screen
;
;  usage:  n_erase(ulrow,ulcol,lrrow,lrcol);
;
;
ifdef Microsoft
_n_erase	proc	far
else
n_erase	proc	far
endif
	PUSH	BP
	MOV		BP,SP
	MOV		CH,[BP+X]			; UPPER LEFT X
	MOV		CL,[BP+X+2]			; COLUMN POsiTION
	MOV		DH,[BP+X+4]
	MOV		DL,[BP+X+6]
	XOR		AX,AX				; clear area
	MOV		AH,6				; scroll up function
	MOV		BH,ATT				; ATTRIBUTE For ERAsiNG IS SAME AS PRint
	INT		10H					; CalL bios
	POP		BP
	RET
ifdef Microsoft
_n_erase	endp
else
n_erase	endp
endif

;/***************************************************************/
;  scroll up and down
;  given the number of lines to scroll and the DImenSIons of the
;  box to scroll.
;  
ifdef Microsoft
_n_scrup	proc	far
else
n_scrup	proc	far
endif
	PUSH	BP
	MOV		BP,SP

	MOV		CH,[BP+X+2]			; UPPER LEFT X
	MOV		CL,[BP+X+4]			; COLUMN POsiTION
	MOV		DH,[BP+X+6]
	MOV		DL,[BP+X+8]
	MOV		AL,[BP+X]			; NUMBER OF LINES TO SCROLL
	MOV		AH,6				; scroll up function
	MOV		BH,ATT				; ATTRIBUTE For BLANK LINE IS SAME AS PRint
	INT		10H					; CalL bios

	POP		BP
	RET
ifdef Microsoft
_n_scrup	endp
else
n_scrup	endp
endif

ifdef Microsoft
_n_scrdn	proc	far
else
n_scrdn	proc	far
endif
	PUSH	BP
	MOV		BP,SP
	MOV		CH,[BP+X+2]			; upper left x
	MOV		CL,[BP+X+4]			; column poSItion
	MOV		DH,[BP+X+6]
	MOV		DL,[BP+X+8]
	MOV		AL,[BP+X]			; number of lines to scroll
	MOV		AH,7				; scroll down function
	MOV		BH,ATT				; attribute fOR blank line is same as prINT
	INT		10H					; CalL bios
	POP		BP
	RET
ifdef Microsoft
_n_scrdn	endp
else
n_scrdn	endp
endif

;/***************************************************************/
; 
;  Find the cursOR poSItion, return the row vALue
;  
ifdef Microsoft
_n_row	proc	far
else
n_row	proc	far
endif
	PUSH 	BP

	MOV		AX,0300H			;video find cursOR function
	XOR 	BX,BX
	INT 	10H  				; find cursOR
	MOV		ROW,DH
	MOV		COL,DL				; save col fOR next routine
	XOR		AX,AX
	MOV		AL,DH				; return row location

	POP 	BP
	RET
ifdef Microsoft
_n_row	endp
else
n_row	endp
endif

;/****************************************************************************/
  ;-----------------------------------------------------------
  ;  This routine was submitted by David T. Burhans, Jr.
  ;  It was obtained from an RBBS-PC electronic bulleton board 
  ;  deDIcated to the "C" language [(703) 321-7003].
  ;-----------------------------------------------------------
  ;
  ; SOUND - This routine produces a tone of a SPecified frequency 
  ; and duration on the SPeaker.
  ; The frequency in Hertz is moved INTo DI (21 to 65535 Hertz) 
  ; and the duration in hundredths of a second, is moved INTo BX 
  ; (0 to 65535).
  ; The routine is cALled with the following sequence:
  ;
  ;		UnSIgned		frequency, duration;
  ;
  ;	   n_sound(frequency, duration);
  ;
ifdef Microsoft
_n_sound	proc	far
else
n_sound	proc	far
endif
	PUSH	BP
	MOV		BP,SP
	PUSH	DI

	MOV		 DI,[BP+X]		  ; Frequency
	MOV		 BX,[BP+X+2]		; Duration
	CMP	  DI, 21H			; See if freq. is below minimum
	JB	   DONE			   ; iF LESS THAN LIMIT, THEN
								; clean up and return
	MOV		 AL,0B6H			; Write timer mode register
	OUT	  43H, AL
	MOV		 DX, 14H			; Timer DIvisOR =
	MOV		 AX, 4F38H		  ; 1331000/Frequency
	DIV	  DI 
	OUT	  42H,AL			 ; Write timer 2 count low byte
	MOV		 AL,AH
	OUT	  42H,AL			 ; Write timer 2 count high byte
	IN	   AL,61H			 ; Get current PORt B setting
	MOV		 AH,AL			  ; and save it in AH
	OR	   AL,3			   ; Turn SPeaker on
	OUT	  61H,AL
HOLD:
	MOV		 CX, 2801
SPKR_ON: 
	LOOP   SPKR_ON
	DEC	  BX				; Speaker-on count expired?
	JNZ	  HOLD			  ; iF NOT, KEEP spEAKER ON
	MOV		 AL,AH			 ; Otherwise, recover vALue of pORt
	OUT	  61H,AL
DONE:
	POP		DI
	MOV		SP,BP			 ; RestORe locALs from stack.
	POP		BP				; RestORe cALler's BP
	RET						; rETURN TO CalLER
ifdef Microsoft
_n_sound	endp
else
n_sound	endp
endif

;/***************************************************************/
;
;  Find the column poSItion of the cursOR.
;  Must be preceded by a n_row cALl!!!!
;  Will wORk when these routines ALready know the cursOR poSItion
;
ifdef Microsoft
_n_col	proc	far
else
n_col	proc	far
endif
	XOR		AH,AH
	MOV		AL,COL				; RETURN COL LOCATION
	RET
ifdef Microsoft
_n_col	endp
else
n_col	endp
endif

;/***************************************************************/
;  n_clear
;  Clear what we think is the current window
;
ifdef Microsoft
_n_clear	proc	far
else
n_clear	proc	far
endif
	PUSH 	BP
	MOV		AL,0			; clear window
	MOV		AH,6			; scroll up function
	MOV		CH,TOPL			; TOP ROW TO CLEAR
	MOV		CL,LEFTC		; LEFT COLUMN
	MOV		DH,BOTL			; BOTTOM ROW TO CLEAR
	MOV		DL,RIGHTC		; RIGHT siDE TO CLEAR
	MOV		BH,ATT			; ATTRIBUTE TO USE For BLANKS
	INT		10H				; CalL bios
	POP 	BP
	RET
ifdef Microsoft
_n_clear	endp
else
n_clear	endp
endif

;/***************************************************************/
;  n_upscroll
;  Scroll up what we think is the current window, n lines
;
ifdef Microsoft
_n_upscroll	proc	far
else
n_upscroll	proc	far
endif
	PUSH	BP
	MOV		BP,SP

	MOV		AL,[BP+X]			; number of lines to scroll
	MOV		AH,6				; scroll up function
	MOV		CH,TOPL				; top row to clear
	MOV		CL,LEFTC			; left column
	MOV		DH,BOTL				; bottom row to clear
	MOV		DL,RIGHTC			; RIGHT siDE TO CLEAR
	MOV		BH,ATT				; attribute to use
	INT		10H					; cALl BIOS

	POP		BP
	RET
ifdef Microsoft
_n_upscroll	endp
else
n_upscroll	endp
endif

;/***************************************************************/
;  n_dnscroll
;  Scroll up what we think is the current window, n lines
;
ifdef Microsoft
_n_dnscroll	proc	far
else
n_dnscroll	proc	far
endif
	PUSH	BP
	MOV		BP,SP
	MOV		AL,[BP+X]			; number of lines to scroll
	MOV		AH,7				; scroll down function
	MOV		CH,TOPL				; top row to clear
	MOV		CL,LEFTC			; left column
	MOV		DH,BOTL				; bottom row to clear
	MOV		DL,RIGHTC			; right SIde to clear
	MOV		BH,ATT				; attribute to use fOR blank lines
	INT		10h					; CalL bios
	POP		BP
	RET
ifdef Microsoft
_n_dnscroll	endp
else
n_dnscroll	endp
endif

;/***************************************************************/
;  n_putchar(letter)
;	  puts onto screen at current cursOR location
;
ifdef Microsoft
_n_putchar	proc	far
else
n_putchar	proc	far
endif
	PUSH 	BP
	MOV		BP,SP

	MOV		AL,[BP+X]   		; char to write
	XOR  	BX,BX	   		;  set page number fOR ALl cursOR addresses
	CMP  	AL,10		   	; line feed
	JNZ 	NXT
	MOV		AL,ROW				; get current cursOR row poSItion
	CMP		AL,BOTL	
	JL		NOSCR				; within window area
	MOV		AX,1				; scroll up one line
	PUSH	AX
ifdef Microsoft
	CALL	_N_UPSCROLL			; scrolls it up one
else
	CALL	N_UPSCROLL			; scrolls it up one
endif
	POP		AX					; take parameter off of stack
;	MOV		AL,LEFTC			; get left SIde vALue
;	MOV		COL,AL				; set cursOR to left
	JMP		PUTCUR
NOSCR:
;	MOV		AL,LEFTC			; return cursOR to left SIde
;	MOV		COL,AL
	INC		ROW
	JMP		PUTCUR				; set new cursOR poSItion, return
NXT:
	CMP  	AL,7 				; ctrl-G, bell
	JNZ  	NXT2
;
;  handle bell with a cALl to a SPeciAL routine
;
	MOV		AX,12				; duration of tone
	PUSH	AX
	MOV		AX,1000	  		; frequency of tone
	PUSH 	AX
ifdef Microsoft
	CALL _N_SOUND
else
	CALL N_SOUND
endif
	ADD 	SP,4		 		; remove params from stack
HERE2:
	POP		BP
	RET
NXT2:
	CMP		AL,13		   	; cr,  home the cursOR
	JNZ		TRYTAB
	MOV		AL,LEFTC			; new cursOR poSItion
	MOV		COL,AL
	JMP		PUTCUR
TRYTAB:
	CMP  	AL,9				; tab character
	JNZ  	NOTCRLF   			; ready fOR regular character
;  expand tabs
	MOV		DL,COL				; get cursOR poSItion
	MOV		CL,3
	SHR 	DL,CL				; DIvide cursOR poSItion by 8
	INC		DL					; increment cursOR poSItion
	SHL		DL,CL				; multiply back by 8
	MOV		COL,DL
								; check to see if past right SIde
	MOV		DL,COL				; get where the cursOR has moved to
	CMP		DL,RIGHTC			; over the SIde yet?
	JA		TABOVER				; set the new poSItion
	JMP		PUTCUR
TABOVER:
	MOV		DL,LEFTC
	MOV		COL,DL
	INC		ROW					; TO NEXT ROW
	MOV		DL,ROW				; WHAT ROW?
	CMP		DL,BOTL
	JG		TABNOS				; we are okay
    JMP     SHORT PUTCUR
TABNOS:
	DEC		ROW					; need to scroll
	MOV		AX,1
	PUSH	AX
ifdef Microsoft
	CALL	_N_UPSCROLL			; scroll window up one line
else
	CALL	N_UPSCROLL			; scroll window up one line
endif
	POP		AX
	MOV		AL,LEFTC			; reset cursOR poSItion to left
	MOV		COL,AL
    JMP     SHORT PUTCUR
NOTCRLF:
   	CMP  	AL,8		   		; backSPace
	JNZ 	REGCHAR
	MOV		AL,COL				; where is cursOR?
	CMP		AL,LEFTC			; is at left of screen?
	JZ		HERE2
	DEC		COL					; decrement cursOR poSItion
    JMP     SHORT PUTCUR              ; okay, move cursOR where it belongs
REGCHAR:
	MOV	 	CX,1H		 		; number of repetitions = 1
	MOV	 	BL,ATT 				; attribute of char
	MOV		BH,0				; write to page zero
	MOV	 	AH,9		 		; write char
	INT  	10H

	INC  	COL			 	; move cursOR over one. 
	MOV		DL,COL				; get current poSItion
   	CMP  	DL,RIGHTC			; is at right SIde of screen?
	JLE   	PUTCUR	 			; no, char can just be put out, cursOR moved.
;
;  check wORd-wrap because we are at edge of window
;
	MOV		DL,WRAP
	OR		DL,DL				; 0 = NO WRAP, 1 = WRAP
	JZ		NOWRAP
   	MOV	 	DL,LEFTC			; cursOR will wrap around
	MOV		COL,DL				; save the new column poSItion
	INC		ROW					; to next row
	MOV		DL,BOTL
	CMP  	ROW,DL				; do we need to scroll?
	JNG  	PUTCUR				; no, okay fOR next row, nORmAL wrap
; scroll screen up one 
	MOV		AX,1
	PUSH	AX
Ifdef Microsoft
	CALL	_N_UPSCROLL			; scroll window up one line
else
	CALL	N_UPSCROLL			; scroll window up one line
endif
	POP		AX
	DEC		ROW					; scrolled up one
    JMP     SHORT PUTCUR              ; don't wrap
NOWRAP:
	DEC		COL
PUTCUR:
	MOV		DH,ROW
	MOV		DL,COL
   	MOV	 	AH,2h
   	XOR 	BX,BX
	INT  	10H			 	; set cursOR poSItion

ESCAPEHERE:
	POP 	BP
	RET
ifdef not_used
TELE:
	MOV		BL,3			  	; SEND WHATEVER CHAR
	MOV		AH,14
	INT 	10H

	POP		BP
	RET
endif
ifdef Microsoft
_n_putchar	endp
else
n_putchar	endp
endif

;/**********************************************************************/
;  draw
;  place characters on the screen-- checking fOR bounDS, etc.  ALl done
;  at a higher level.
;
;  n_draw(s,len)
;	char*s ; INT len;
;
ifdef Microsoft
_n_draw proc far
else
n_draw proc far
endif
	PUSH 	BP
	MOV		BP,SP
	PUSH 	ES
	PUSH	SI
	PUSH	DI
;
;  fOR now, assume that the cursOR location has ALready been set
;  (cursOR is there)
;
;	MOV		SI,[BP+X]			; poINTer to string
;	MOV		AX,[BP+X+2]			; ds OF STRING
;	MOV		ES,AX
	LES		SI,[BP+X]			; get the segment and offset of the string
	MOV		DI,[BP+X+4]			; # OF CHARACTERS
;	OR		DI,DI				; check for no characters to draw
;	JZ		ENDDRAW				; exit if no characters to draw
	MOV		DH,ROW				; row where cursOR is
LOOPDRAW:
	MOV		AL,ES:[SI]			; get character to write from es:SI
	INC		SI
	MOV	 	CX,1H		  		; number of repetitions = 1
	XOR  	BH,BH				; dispLAY PAGE 0
   	MOV	 	BL,ATT 				; attribute of char
	MOV	 	AH,9		   		; write char
   	INT  	10h
	INC		COL					; MOVE THE CURSor OVER
	MOV		DL,COL
   	MOV	 	AH,2H
	XOR		BX,BX
	INT  	10H				 	; SET CURSor POsiTION
	DEC 	DI					; check counter
	JNZ 	LOOPDRAW			; GO THROUGH TO REQUIRED COUNT

ENDDRAW:
	POP		DI
	POP		SI
	POP 	ES
	POP		BP
	RET
ifdef Microsoft
_n_draw endp
else
n_draw endp
endif

;/**********************************************************************/
;  cheat
;  put characters on the screen as per n_draw, but write DIrectly
;  to DISPlay memORy.  Don't even check fOR retrace
;
ifdef Microsoft
_n_cheat proc	far
else
n_cheat proc	far
endif
	PUSH 	BP
	MOV		BP,SP
	PUSH 	ES
	PUSH 	DS
	PUSH	SI
	PUSH	DI
;
;  fOR now, assume that the cursOR location has ALready been set
;  (cursOR is there)
;
	MOV		AX,REGEN
	MOV		ES,AX				; set up fOR segment where screen is
	MOV		AL,ROW				; row where chars go
	XOR		AH,AH
	MOV		BL,160
	MUL		BL					; AX now equALs start of row
	XOR		BH,BH
	MOV		BL,COL
	SHL		BL,1				; COL*2
	ADD		AX,BX				; add in column offset
	MOV		DI,AX				; stORe in DI (es:DI)
	MOV		CX,[BP+X+4]			; # of characters
;	OR		CX,CX				; check whether we really have ANY characters
;	JZ		ENDCHEAT			; exit if we have no characters
	ADD		COL,CL				; COLUMN POsiTION OF CURSor
	MOV		AH,ATT				; ATTRIBUTE For CHARS
;	MOV		SI,[BP+X]			; POintER TO STRING
;	MOV		BX,[BP+X+2]			; ds OF STRING
;	MOV		DS,BX
	LDS		SI,[BP+X]			; get the segment and offset of the string
;
;  do the move
;
	CLD
LPCHEAT:
	LODSB						; GET NEXT BYTE
	STOSW						; STorE BYTE AND ATTRIBUTE
	LOOP 	LPCHEAT

ENDCHEAT:
	POP		DI
	POP		SI
	POP		DS
	POP		ES
	POP		BP
	RET
ifdef Microsoft
_n_cheat	endp
else
n_cheat	endp
endif

;/**********************************************************************/
;
;  New keyboard handling

;	the interrupt and codes for the keyboard interface.

KEYBOARD	EQU	16H			; interrupt 16 to deal with keyboard
GETC	  	EQU	0			; code for reading a character
CHECKC		EQU	1			; code for keyboard status
SHIFTSTAT	EQU	2			; code for shift key status
SCAN		EQU	00100H		; scan code
SHIFT		EQU	00200H		; left or right shift key pressed
CONTROL		EQU	00400H		; control key pressed
ALT			EQU	00800H		; alt key pressed
ENHANCE		EQU	01000H		; enhanced keyboard special key

;**********************************************************************
;
;  Get a translated character from the keyboard.
;
;	Return the next character pressed with the new translation method for
;		kermit compatibility.
;	Quincey Koziol
;
;	Usage:
;		unsigned int n_newgetchar(void);
;
ifdef Microsoft
_n_getchar	proc	far
else
n_getchar	proc	far
endif
	PUSH  	BP
ifdef Microsoft
    MOV     AH,_KEYBOARD_TYPE   ; ask for a keyboard character
else
	MOV	   	AH,_KEYBOARD_TYPE	; ask for a keyboard character
endif
	INT		KEYBOARD
	MOV		BX,AX				; store the scan code character
	MOV		AH,SHIFTSTAT		; get the shift keys' status
	INT		KEYBOARD			; shift status returned in AX
	XOR		AH,AH				; clear the top part of the shift status
	XOR		DX,DX				; set local variables to zero
	XOR		CX,CX				; 
	CMP		BH,0				; check for enhanced key
	JE		NOT_ENHANCED1		; jump around first enchanced key checks
	CMP		BH,0E0H				; check for other part of enhanced key
	JNE		NOT_ENHANCED2
	XCHG	BH,BL				; shift key from bios left 8 bits
	XOR		BL,BL				; 
	OR		DX,ENHANCE			; set the enhanced bit
NOT_ENHANCED2:
	CMP		BL,0E0H				; check for second part of enhanced key
	JNE		NOT_ENHANCED1
	XOR		BL,BL				; clear the character code from the bios key
	OR		DX,ENHANCE			; set the enhanced bit
NOT_ENHANCED1:
	CMP		BL,0				; check for not scan code only being zero
	JE		NOT_ALIAS			; not one of the alias'ed keys from BIOS
	CMP		BX,(14*SCAN)+8		; check for Backspace
	JE		ALIAS_KEY
	CMP		BX,(55*SCAN)+'*'	; check for '*'
	JE		ALIAS_KEY
	CMP		BX,(74*SCAN)+'-'	; check for '-'
	JE		ALIAS_KEY
	CMP		BX,(78*SCAN)+'+'	; check for '+'
	JE		ALIAS_KEY
	CMP		BX,(71*SCAN)+'7'	; check for '7'
	JE		ALIAS_KEY
	CMP		BX,(72*SCAN)+'8'	; check for '8'
	JE		ALIAS_KEY
	CMP		BX,(73*SCAN)+'9'	; check for '9'
	JE		ALIAS_KEY
	CMP		BX,(75*SCAN)+'4'	; check for '4'
	JE		ALIAS_KEY
	CMP		BX,(76*SCAN)+'5'	; check for '5'
	JE		ALIAS_KEY
	CMP		BX,(77*SCAN)+'6'	; check for '6'
	JE		ALIAS_KEY
	CMP		BX,(79*SCAN)+'1'	; check for '1'
	JE		ALIAS_KEY
	CMP		BX,(80*SCAN)+'2'	; check for '2'
	JE		ALIAS_KEY
	CMP		BX,(81*SCAN)+'3'	; check for '3'
	JE		ALIAS_KEY
	CMP		BX,(82*SCAN)+'0'	; check for '0'
	JE		ALIAS_KEY
	CMP		BX,(83*SCAN)+'.'	; check for '.'
	JE		ALIAS_KEY
	CMP		BX,(83*SCAN)+','	; check for ','
	JE		ALIAS_KEY
	CMP		BX,(15*SCAN)+9		; check for Tab
	JE		ALIAS_KEY
    JMP     SHORT NOT_ALIAS           ; key didn't match one of the alias'ed keys
ALIAS_KEY:
	XOR		BL,BL				; clear ascii code for alias'ed keys
NOT_ALIAS:
	CMP		BL,0				; no ascii value, get a kermit scan code
	JNE		REGULAR_KEY
	MOV		DL,BH				; get the scancode
	OR		DX,SCAN				; set the SCAN flag
	TEST	AX,3				; check for shift key down
	JE		NOT_SHIFT			; shift key not down
	OR		CX,SHIFT			; set the SHIFT help flag
NOT_SHIFT:
	TEST	AL,20h				; check for NumLock set
	JE		NOT_NUMLOCK			; NumLock not down
	CMP		DX,71+SCAN			; on numeric keypad?
	JB		NOT_NUMLOCK
	CMP		DX,83+SCAN
	JA		NOT_NUMLOCK
	CMP		DX,74+SCAN			; not the grey - key
	JE		NOT_NUMLOCK
	CMP		DX,78+SCAN			; not the grey + key
	JE		NOT_NUMLOCK
	XOR		CX,SHIFT			; all true, xor the shift help
NOT_NUMLOCK:
	OR		DX,CX				; set the correct shift status
	TEST	AL,4				; check for the CONTROL key down
	JE		NOT_CONTROL
	OR		DX,CONTROL			; set the control flag
NOT_CONTROL:
	TEST	AX,8				; check for the ALT key down
	JE		NOT_ALT
	OR		DX,ALT				; set the alt flag
NOT_ALT:
	MOV		AX,DX				; set the return value
    JMP     SHORT END_NEWGETCHAR
	
REGULAR_KEY:					; we have an ascii value, return that
	XOR		BH,BH				;
	MOV		AX,BX				; return the key id

END_NEWGETCHAR:
	POP	BP
	RET
ifdef Microsoft
_n_getchar	endp
else
n_getchar	endp
endif

;**********************************************************************
;  Check for character present at the keyboard
;  If there is one available, return it, if not, return -1
;
;  translate any extended characters
;
ifdef Microsoft
_n_chkchar	proc	far
else
n_chkchar	proc	far
endif
	PUSH 	BP
ifdef Microsoft
	MOV		AH,_KEYBOARD_TYPE	; get the correct BIOS setting for the keyboard
else
	MOV		AH,KEYBOARD_TYPE	; get the correct BIOS setting for the keyboard
endif
	INC		AH					; increment for the setting to check the keyboard
	INT	 	KEYBOARD
	MOV		AX,-1
	JZ		NEW_NOKEY
ifdef Microsoft
	CALL	_N_GETCHAR			;get the coded character
else
	CALL	N_GETCHAR			;get the coded character
endif
NEW_NOKEY:
   	POP	BP
	RET
ifdef Microsoft
_n_chkchar	endp
else
n_chkchar	endp
endif

;/***************************************************************/
;  savewin
;	copy the current window INTo a buffer
;
;   usage:  n_savewindow(buffer);
;
ifdef Microsoft
_n_savewin	proc	far
else
n_savewin	proc	far
endif
	PUSH	BP
	MOV		BP,SP
	PUSH	ES
	PUSH	DS
	PUSH	SI
	PUSH	DI

	MOV		AX,[BP+X+2]			; DS of buffer
	MOV		ES,AX
	MOV		DI,[BP+X]			; poINTer to buffer
	CLD
;
;  stORe parameters in first, fOR recALl later
;
	MOV		AL,ROW				; cursOR poSItion: row,col
	STOSB
	MOV		AL,COL
	STOSB
	MOV		AL,TOPL				; window boundaries
	STOSB
	MOV		AL,LEFTC
	STOSB
	MOV		AL,BOTL
	STOSB
	MOV		AL,RIGHTC
	STOSB						; STorE IN BUFFER TOO
;
;  cALculate amount to move
;
;
;  cALculate number of lines to move
;
	MOV	 	AL,TOPL			 ; X1
	MOV	 	BL,BOTL				; X2
	SUB  	BL,AL			   ; x2 = x2-x1
	INC  	BL				  ; ADD 1 LINE
	MOV	 	[BP+X],BL			; KEEP IT SOMEWHERE SAFE
;
;  cALculate screen offset  = 160*x1+2*y1;
;
;   AL has topl in it
	XOR  	AH,AH
	MOV	 	BL,160
	MUL  	BL					; how many chars in x1 lines, in AX
	XOR  	CH,CH
	MOV	 	CL,LEFTC			; chars to left SIde
	SHL  	CL,1				; *2 counts attributes
	ADD  	AX,CX			   ; add them
	MOV	 	SI,AX		   	; place INTo source index
;
;  find number of characters to move each time
;
	MOV	 	CL,RIGHTC
	SUB  	CL,LEFTC	   		; Y2 = Y2-Y1
	INC  	CL			 		;  ADD 1
	MOV	 	[BP+X+1],CL			; SAFE PLACE AGAIN
;
;  find number to add to wrap around fOR each line
;
	MOV	 	BL,CL		  		; # OF CHARS MOVED EACH TIME
	SHL  	BL,1		   		; CHARS*2
	MOV	 	AL,160
	SUB  	AL,BL		  		; 160-chars*2
	MOV	 	[BP+X+2],AL			; safe place to keep it
;
;
	MOV	 	AX,REGEN   			; where source segment is (screen)
	MOV	 	DS,AX
	MOV	 	DX,03dAH			; colOR card status pORt
	XOR  	BH,BH
	MOV	 	BL,[BP+X]		   ; howmany lines to move
	CMP  	AX,0B000H		   ; CHECK For MONO CARD
	JNZ 	GETLINE
	MOV	 	DX,03BAH			; change status pORt vALue
GETLINE:
	MOV	 	CL,[BP+X+1]		 ; # OF CHARS TO MOVE
GETCHAR:
;   IN   	AL,DX			   ; GET STATUS BYTE
	TEST 	AL,1				; hORizontAL retrace
;   JNZ  	GETCHAR			 ; not there yet
;ISON:
	IN   	AL,DX
;   TEST 	AL,1
;   JZ   	ISON				; STILL ON, TRY AGAIN
	MOVSW					 	; NOW IS TIME, MOVE THE WorD
	LOOP 	GETCHAR			 ; DO ANOTHER UNTIL THIS LINE IS DONE
;
	DEC 	BX
	JZ  	ENDKEEP			 ; DONE, WE ARE OUT OF HERE
	MOV		AL,[BP+X+2]
	XOR		AH,AH
	ADD 	SI,AX			   
; go to next line, skip 160-n*2 bytes
	JMP 	GETLINE
ENDKEEP:
	POP		DI
	POP		SI
	POP  	DS
	POP  	ES
	POP  	BP
	RET
ifdef Microsoft
_n_savewin	endp
else
n_savewin	endp
endif

;/***************************************************************/
;  restwindow
;	restORe the contents of the window to the screen
;
ifdef Microsoft
_n_restwin	proc	far
else
n_restwin	proc	far
endif
	PUSH	BP
	MOV		BP,SP
	PUSH	ES
	PUSH	DS
	PUSH	SI
	PUSH	DI

	MOV		AX,[BP+X+2]			; ds OF BUFFER
	PUSH	AX					; will POP to DS later 
	MOV		ES,AX				; used to restORe variable vALues
	MOV		SI,[BP+X]			; POintER TO BUFFER
	CLD
;
;  get back stORed variables
;
	MOV		AL,ES:[SI]			; get cursOR row
	MOV		ROW,AL
	INC		SI
	MOV		AL,ES:[SI]
	MOV		COL,AL
	INC		SI
	MOV		AL,ES:[SI]			; window boundaries
	MOV		TOPL,AL
	INC		SI
	MOV		AL,ES:[SI]
	MOV		LEFTC,AL
	INC		SI
	MOV		AL,ES:[SI]
	MOV		BOTL,AL
	INC		SI
	MOV		AL,ES:[SI]
	MOV		RIGHTC,AL
	INC		SI					; now we are ready fOR data
;
;  cALculate amount to move
;
;
;  cALculate number of lines to move
;
	MOV		AL,TOPL			 ; X1
	MOV		BL,BOTL				; X2
	SUB  	BL,AL			   ; x2 = x2-x1
	INC  	BL				  ; ADD 1 LINE
	MOV	 	[BP+X],BL			; KEEP IT SOMEWHERE SAFE
;
;  cALculate screen offset  = 160*x1+2*y1;
;
;   AL has topl in it
	XOR 	AH,AH
	MOV		BL,160
	MUL 	BL					; HOW MANY CHARS IN X1 LINES, IN ax
	XOR 	CH,CH
	MOV		CL,LEFTC			; CHARS TO LEFT siDE
	SHL 	CL,1				; *2 COUNTS ATTRIBUTES
	ADD 	AX,CX			   ; add them
	MOV		DI,AX		   	; place INTo source index
;
;  find number of characters to move each time
;
	MOV	 	CL,RIGHTC
	SUB  	CL,LEFTC			; Y2 = Y2-Y1
	INC  	CL			  	;  add 1
	MOV	 	[BP+X+1],CL			; safe place again
;
;  find number to add to wrap around fOR each line
;
	MOV 	BL,CL		   	; # of chars moved each time
	SHL 	BL,1				; chars*2
	MOV 	AL,160
	SUB 	AL,BL		   	; 160-chars*2
	MOV 	[BP+X+2],AL	 	; safe place to keep it
;
;
ifdef CHECK_FOR_REFRESH
	MOV	 	AX,REGEN			; screen will receive this data
	MOV	 	ES,AX
	POP  	DS					; set DS to where data is coming from 
	MOV	 	DX,03DAH			; COLor CARD STATUS PorT
	XOR  	BH,BH
	MOV	 	BL,[BP+X]		   ; howmany lines to move
	CMP  	AX,0B000H		   ; check fOR mono card
	JNZ 	RGETLINE
	MOV	 	DX,03BAH  			; change status pORt vALue
RGETLINE:
	MOV	 	CL,[BP+X+1]			; # of chars to move
RGETCHAR:
	IN   	AL,DX			   ; GET STATUS BYTE
	TEST 	AL,1				; hORizontAL retrace
	JNZ  	RGETCHAR			; NOT THERE YET
RISON:
	IN   	AL,DX
	TEST 	AL,1
	JZ   	RISON			   ; STILL ON, TRY AGAIN
	MOVSW					   ; NOW IS TIME, MOVE THE WorD
	LOOP 	RGETCHAR			; DO ANOTHER UNTIL THIS LINE IS DONE
else
	MOV	 	AX,REGEN			; screen will receive this data
	MOV	 	ES,AX
	POP  	DS					; set DS to where data is coming from 
;	MOV	 	DX,03DAH			; COLor CARD STATUS PorT
	XOR  	BH,BH
	MOV	 	BL,[BP+X]		   ; howmany lines to move
;	CMP  	AX,0B000H		   ; check fOR mono card
;	JNZ 	RGETLINE
;	MOV	 	DX,03BAH  			; change status pORt vALue
RGETLINE:
	XOR		CH,CH
	MOV	 	CL,[BP+X+1]			; # of chars to move
RGETCHAR:
;   IN   	AL,DX			   ; GET STATUS BYTE
;   TEST 	AL,1				; hORizontAL retrace
;   JNZ  	RGETCHAR			; NOT THERE YET
;RISON:
;	IN   	AL,DX
;   TEST 	AL,1
;   JZ   	RISON			   ; STILL ON, TRY AGAIN
;	MOVSW					   ; NOW IS TIME, MOVE THE WorD
;	LOOP 	RGETCHAR			; DO ANOTHER UNTIL THIS LINE IS DONE
	REP		MOVSW				; move all the words
endif
;
	DEC 	BX
	JZ  	RENDKEEP			; DONE, WE ARE OUT OF HERE
	MOV		AL,[BP+X+2]
	XOR		AH,AH
	ADD 	DI,AX			   ; go to next line, skip 160-n*2 bytes
	JMP 	RGETLINE
RENDKEEP:
	POP		DI
	POP		SI
	POP  	DS
	MOV		DH,ROW				; LOAD STorED CURSor POsiTION
	MOV		DL,COL
   	MOV	 	AH,2H
   	XOR 	BX,BX
	INT  	10H			 	; SET CURSor POsiTION TO SAVED ValUE
	POP  	ES
	POP  	BP
	RET
ifdef Microsoft
_n_restwin	endp
else
n_restwin	endp
endif

;************************************************************************
;  n_puts
;  Window-compatible puts, uses n_putchar and ALso translates
;  \n to CRLF
;
;	 usage:  identicAL to puts()
;
ifdef Microsoft
_n_puts	proc	far
else
n_puts	proc	far
endif
	PUSH	BP
	MOV		BP,SP
NEXTC:
	PUSH	DS
	MOV		DX,[BP+X+2]			; ds OF STRING
	MOV		DS,DX
	MOV		BX,[BP+X]			; PTR TO STRING
	MOV		AL,[BX]				; GET CHARACTER
	XOR		AH,AH				; clear AH
	POP		DS
	OR		AL,AL				; is it end of string?
	JZ		DONEST
	INC		WORD PTR [BP+X]		; INCREMENT POintER For NEXT ONE
	CMP		AL,10				; newline?
	JNZ		DOCHAR
	MOV		AL,13
	PUSH	AX
Ifdef Microsoft
	CALL	_N_PUTCHAR
Else
	CALL	N_PUTCHAR
endif
	POP		AX
	MOV		AX,10
DOCHAR:
	PUSH	AX
ifdef Microsoft
	CALL	_N_PUTCHAR
else
	CALL	N_PUTCHAR
endif
	POP		AX					; take off of the stack
	JMP		NEXTC
DONEST:
	MOV		AX,13				; CR
	PUSH	AX
ifdef Microsoft
	CALL	_N_PUTCHAR
else
	CALL	N_PUTCHAR
endif
	POP		AX
	MOV		AX,10				; LF
	PUSH	AX
ifdef Microsoft
	CALL	_N_PUTCHAR
else
	CALL	N_PUTCHAR
endif
	POP		AX
	POP		BP
	RET
ifdef Microsoft
_n_puts	endp
else
n_puts	endp
endif

;**********************************************************************
;
;  find first
;	make dos find file names accORDIng to wildcarDS
;  n_findfirst(filename,attr)
;	char *filename; INT attr;
;
ifdef Microsoft
_n_findfirst	proc	far
else
n_findfirst		proc	far
endif
	PUSH	BP
	MOV		BP,SP
	PUSH	ES
	PUSH	DS
	MOV		AH,02FH				; dos FUNCTION GET dta
	INT		21H
ifdef Microsoft
	MOV 	_DTAPTR,BX			; SQUIRREL A COPY For ME
	MOV		AX,ES
	MOV 	_DTADS,AX
else
	MOV		DTAPTR,BX			; SQUIRREL A COPY For ME
	MOV		AX,ES
	MOV		DTADS,AX
endif
	MOV		AX,[BP+X+2]			; ds OF FILENAME PTR
	MOV		DS,AX
	MOV		DX,[BP+X]			; PTR PART OF FILENAME
	MOV		CX,[BP+X+4]			; ATTRIBUTE TO SEARCH For
	MOV		AH,04EH				; FIND MATCHING FILE dos CalL
	INT		21H
	JC		BADRET				; ax alREADY CONTAINS ERRor CODE
	XOR		AX,AX
BADRET:
	POP		DS
	POP		ES
	POP		BP
	RET
ifdef Microsoft
_n_findfirst	endp
else
n_findfirst	endp
endif
;
;  n_findnext()
;  will find entries that follow findfirst
;  no need to respecify file name
;
ifdef Microsoft
_n_findnext	proc	far
else
n_findnext	proc	far
endif
	PUSH	BP
	MOV		AH,04FH				; FIND NEXT dos CalL
	INT		21H
	JC		NBADRET
	XOR		AX,AX
NBADRET:
	POP		BP
	RET
ifdef Microsoft
_n_findnext	endp
else
n_findnext	endp
endif
;
;  get the number of timer clicks from BIOS
;
ifdef Microsoft
_n_clicks  proc	far			 ; must be declared long n_clicks()
else
n_clicks  proc	far			 ; must be declared long n_clicks()
endif
	MOV		AH,0
	INT		1AH
ifdef Microsoft
	MOV		AX,DX				; msc USES ax-LO, dx-HI
	MOV		DX,CX				; return vALues from INTerrupt 1A
else
	MOV		AX,CX				; Lattice uses AX-hi, BX-lo
	MOV		BX,DX				; Lattice returns in BX, MSC in DX and switched
endif
	RET
ifdef Microsoft
_n_clicks endp
else
n_clicks endp
endif

;
;	void fix_vid(void)
;
ifdef Microsoft
_fix_vid proc far
else
fix_vid proc far
endif

	push es

	mov ax,0
	push ax
	pop es
	mov bx,410h
	mov al,es:[bx]		; get equipment flags
	and al,0ch
	cmp al,3
	je done_vid_fix				; if mono, we don't do anything

	mov ax,40h
	push ax
	pop es
	mov bx,89h
	mov al,es:[bx]		; get VDD flag byte
	and al,0fdh			; Make sure bit 1 (gray scale summing enable)
								;   is UNSET
	mov es:[bx],al	; put new flag byte in VDD 

	mov ah,0fh
	int 10h						; get current mode
	xor ah,ah
	int 10h						; reset current mode (new flags take affect)

done_vid_fix:
	pop es
	ret

ifdef Microsoft
_fix_vid endp
else
fix_vid endp
endif

;-----------------------------------------------------------------

ifdef Microsoft
_TEXT	ENDS
else
	endps
endif
	end
