* Program............: vendors.FRG
* Date...............: 6-22-94
* Versions...........: dBASE 5.0, Report
*
* Notes:
* ------
* Prior to running this procedure with the DO command
* it is necessary use LOCATE because the CONTINUE
* statement is in the main loop.
*
*-- Parameters
PARAMETERS gl_noeject, gl_plain, gl_summary, gc_heading, gc_extra
** The first three parameters are of type Logical.
** The fourth parameter is a string.  The fifth is extra.
PRIVATE _peject, _wrap, ll_heading, ll_temp, ll_toprint
ll_heading = .F.
ll_toprint = (SET("PRINTER") = "ON")

*-- Test for no records found
IF EOF() .OR. .NOT. FOUND()
   RETURN
ENDIF

*-- turn word wrap mode off
_wrap=.F.

IF _plength < (_pspacing * 3 + 1) + (_pspacing + 1) + 2
   SET DEVICE TO SCREEN
   DEFINE WINDOW gw_report FROM 7,17 TO 11,62 DOUBLE
   ACTIVATE WINDOW gw_report
   @ 0,1 SAY "Increase the page length for this report."
   @ 2,1 SAY "Press any key ..."
   x=INKEY(0)
   DEACTIVATE WINDOW gw_report
   RELEASE WINDOW gw_report
   RETURN
ENDIF

_plineno=0          && set lines to zero
*-- NOEJECT parameter
IF gl_noeject
   IF _peject="BEFORE"
      _peject="NONE"
   ENDIF
   IF _peject="BOTH"
      _peject="AFTER"
   ENDIF
ENDIF

*-- Set-up environment
ON ESCAPE DO Prnabort
IF SET("TALK")="ON"
   SET TALK OFF
   gc_talk="ON"
ELSE
   gc_talk="OFF"
ENDIF
gc_space=SET("SPACE")
SET SPACE OFF
gc_time=TIME()      && system time for predefined field
gd_date=DATE()      && system date  "    "    "     "
gl_fandl=.F.        && first and last page flag
gl_prntflg=.T.      && Continue printing flag
gl_widow=.T.        && flag for checking widow bands
gn_length=LEN(gc_heading)  && store length of the HEADING
gn_level=2          && current band being processed
gn_page=_pageno     && grab current page number
gn_pspace=_pspacing && get current print spacing


*-- Set up procedure for page break
gn_atline=_plength - (_pspacing + 1)
ON PAGE AT LINE gn_atline EJECT PAGE

*-- Print Report

PRINTJOB

*-- Initialize summary variables.
r_msum1=0

IF gl_plain
   ON PAGE AT LINE gn_atline DO Pgplain
ELSE
   ON PAGE AT LINE gn_atline DO Pgfoot
ENDIF

DO Pghead

gl_fandl=.T.        && first physical page started

DO Rintro

*-- File Loop
DO WHILE FOUND() .AND. .NOT. EOF() .AND. gl_prntflg
   gn_level=0
   *-- Detail lines
   IF gl_summary
      DO Upd_Vars
   ELSE
      DO __Detail
   ENDIF
   gl_widow=.T.         && enable widow checking
   CONTINUE
ENDDO

IF gl_prntflg
   DO Rsumm
   IF _plineno <= gn_atline
      EJECT PAGE
   ENDIF
ELSE
   DO Rsumm
   DO Reset
   RETURN
ENDIF

ON PAGE

ENDPRINTJOB

DO Reset
RETURN
* EOP: vendors.FRG

*-- Update summary fields and/or calculated fields.
PROCEDURE Upd_Vars
*-- Count
r_msum1=r_msum1+1
RETURN
* EOP: Upd_Vars

*-- Set flag to get out of DO WHILE loop when escape is pressed.
PROCEDURE Prnabort
gl_prntflg=.F.
RETURN
* EOP: Prnabort

PROCEDURE Pghead
?? IIF(gl_plain,'',gd_date) AT 0,;
 IIF(gl_plain,'' , "PAGE " ) AT 71,;
 IIF(gl_plain,'',_pageno) PICTURE "999" 
?
?
?
RETURN
* EOP: Pghead

PROCEDURE Rintro
?
DEFINE BOX FROM 27 TO 56 HEIGHT 4 DOUBLE
?
?? "A-T FURNITURE INDUSTRIES" STYLE "B" AT 30
?
?? "VENDOR REPORT" STYLE "B" AT 35
?
?
?
?? ;
"";
+ "";
AT 0
?
RETURN
* EOP: Rintro

PROCEDURE __Detail
IF 8 * gn_pspace < gn_atline - (_pspacing * 3 + 1)
   IF gl_widow .AND. _plineno+8 * gn_pspace > gn_atline + 1
      EJECT PAGE
   ENDIF
ENDIF
DO Upd_Vars
?
?? "VENDOR I.D.: " STYLE "BU" AT 0,;
 Vendor_id FUNCTION "T" STYLE "BU" 
?
?? Vendor FUNCTION "T" AT 0
?
?? Address1 FUNCTION "T" AT 0,;
 " " ,;
 Address2 FUNCTION "T" 
?
?? City FUNCTION "T" AT 0,;
 ", " ,;
 State FUNCTION "T" ,;
 " " ,;
 Zip FUNCTION "T" 
?
?? "CONTACT: " AT 0,;
 Contact FUNCTION "T" ,;
 Phone FUNCTION "T" PICTURE "(XXX)XXX-XXXX" AT 50,;
 "EXT. " AT 64,;
 Phone_ext FUNCTION "T" 
?
?? "TERMS: " AT 0,;
 Terms FUNCTION "T" ,;
 "DISCOUNT: " AT 23,;
 Discount PICTURE "99" ,;
 " %" 
?
?? ;
"";
+ "";
AT 0
?
RETURN
* EOP: __Detail

PROCEDURE Rsumm
?
?? ;
"";
+ "";
AT 0
?
?? "TOTAL NUMBER OF VENDORS: " AT 0,;
 r_msum1 PICTURE "999" 
?
?? ;
"";
+ "";
AT 0
gl_fandl=.F.        && last page finished
?
RETURN
* EOP: Rsumm

PROCEDURE Pgfoot
PRIVATE _box, _pspacing
gl_widow=.F.         && disable widow checking
_pspacing=1
?
IF .NOT. gl_plain
   _pspacing=gn_pspace
   ?? "PREPARED BY SALES DEPARTMENT" AT 28
ENDIF
EJECT PAGE
*-- is the page number greater than the ending page
IF _pageno > _pepage
   GOTO BOTTOM
   SKIP
   gn_level=0
ENDIF
IF .NOT. gl_plain .AND. gl_fandl
   _pspacing=gn_pspace
   DO Pghead
ENDIF
RETURN
* EOP: Pgfoot

*-- Process page break when PLAIN option is used.
PROCEDURE Pgplain
PRIVATE _box
EJECT PAGE
RETURN
* EOP: Pgplain

*-- Reset dBASE environment prior to calling report
PROCEDURE Reset
SET SPACE &gc_space.
SET TALK &gc_talk.
ON ESCAPE
ON PAGE
RETURN
* EOP: Reset

