PROCEDURE DoChisel
*---------------------------------------------------------------------
* DESCRIPTION
*   Display two chiseled message boxes.  The first one is bright
*   white text with a gray background.  The second one is yellow
*   text on a cyan background.
*---------------------------------------------------------------------
  SET COLOR TO N/W
  SET TALK OFF
  SET STATUS OFF

  DO TestChis WITH .F., "W+", "W"
  DO TestChis WITH .F., "RG+", "BG"

RETURN
*-- EOP: DoChisel


PROCEDURE TestChis
PARAMETER pl_in, pc_fore, pc_back
*---------------------------------------------------------------------
* DESCRIPTION
*   Displays one chisel box inside of another for a bold chisel
*   effect.  Then display a message inside of the inner box.
*---------------------------------------------------------------------

  SAVE SCREEN TO Temp

  *-- Display the outer chisel window with a shadow behind it.
  DO Chisel WITH "Win2",4,13,10,67,pc_fore,pc_back,pl_in, .T.

  *-- Display the inner chisel window without a shadow
  DO Chisel WITH "Win1",5,15,9,65,pc_fore,pc_back,.NOT. pl_in, .f.

  @ 2, 12 SAY "Out to lunch!  Back at 1pm"
  ACTIVATE SCREEN
  WAIT

  RELEASE WINDOW Win2
  RELEASE WINDOW Win1

  RESTORE SCREEN FROM Temp
  RELEASE SCREEN Temp
RETURN
*-- EOP: TestChis


PROCEDURE Chisel
PARAMETERS pc_WinName, pn_TopRow, pn_LeftCol, pn_BotRow, pn_RtCol, ;
           pc_ClrFore, pc_ClrBack, pl_Indent, pl_Shadow
*---------------------------------------------------------------------
* DESCRIPTION
*   Creates a chisel window with or without a shadow background
*
* PARAMETERS
*   pc_WinName  = Name of the window that will contain the chisel.
*                 The calling program must release it when done.
*   pn_TopRow   = Top row for the window
*   pn_LeftCol  = Left column for the window
*   pn_BotRow   = Bottom row for the window
*   pn_RtCol    = Right column for the window
*   pc_ClrFore  = Foreground color for the interior text
*   pc_ClrBack  = Background color for the window
*   pl_Indent   = .T. for a chisel in effect, .F. for chisel out
*   pl_Shadow   = .T. for a shadow effect behind the window.
*---------------------------------------------------------------------

  DEFINE WINDOW &pc_WinName FROM pn_TopRow, pn_LeftCol TO pn_BotRow, pn_RtCol ;
         NONE ;
         COLOR &pc_ClrFore./&pc_ClrBack.

  IF pl_Shadow
    DO ShadowG WITH pn_TopRow, pn_LeftCol, pn_BotRow, pn_RtCol
  ENDIF

  ACTIVATE WINDOW &pc_WinName

  IF pl_Indent
    pc_ClrUp = "N"
    pc_ClrDn = "W+"
  ELSE
    pc_ClrUp = "W+"
    pc_ClrDn = "N"
  ENDIF
  ln_wide = pn_RtCol  - pn_LeftCol
  ln_high = pn_BotRow - pn_TopRow

  @ 0,0 SAY CHR( 218 ) ;
            COLOR &pc_ClrUp./&pc_ClrBack.
  @ 0,1 SAY REPLICATE( CHR( 196 ), ln_Wide - 1 ) ;
            COLOR &pc_ClrUp./&pc_ClrBack.
  @ ln_High, 0 SAY CHR( 192 ) ;
            COLOR &pc_ClrUp./&pc_ClrBack.
  @ 1,0 TO ln_High - 1, 0 ;
            COLOR &pc_ClrUp./&pc_ClrBack.

  @ 0, ln_Wide SAY CHR( 191 ) ;
            COLOR &pc_ClrDn./&pc_ClrBack.
  @ ln_High, 1 SAY REPLICATE( CHR( 196 ), ln_Wide - 1 ) ;
            COLOR &pc_ClrDn./&pc_ClrBack.
  @ ln_High, ln_Wide SAY CHR( 217 ) ;
            COLOR &pc_ClrDn./&pc_ClrBack.
  @ 1,ln_wide TO ln_High - 1, ln_Wide ;
            COLOR &pc_ClrDn./&pc_ClrBack.

RETURN
*-- EOP: Chisel


PROCEDURE Shadowg                      && displays shadow that grows
PARAMETER x1,y1,x2,y2
*---------------------------------------------------------------------
* DESCRIPTION
*   Display a shadow effect behind a window.  ShadowG uses the
*   same coordinates as the window and computes the display offset.
*---------------------------------------------------------------------

  PRIVATE   x1,y1,x2,y2

  x0 = x2+1
  y0 = y2+2
  dx = 1
  dy = (y2-y1) / (x2-x1)
  DO WHILE x0 <> x1 .OR. y0 <> y1+2
    @ x0,y0 FILL TO x2+1,y2+2 COLOR n+/n
    x0 = IIF(x0<>x1,x0 - dx,x0)
    y0 = IIF(y0<>y1+2,y0 - dy,y0)
    y0 = IIF(y0<y1+2,y1+2,y0)
  ENDDO
RETURN
*-- EOP: Shadowg




