******************************************************************************
* PROGRAM NAME: BUSINESS.PRG
*               MAIN MENU
*               SAMPLE BUSINESS APPLICATION SYSTEM
* LAST CHANGED: 06/20/90 08:00AM
* WRITTEN BY:   Borland International Inc.
******************************************************************************

PROCEDURE Business
   * Link to external procedure file of "tool" procedures
   SET PROCEDURE TO Library

   CLEAR ALL
   DO Set_env
   PUBLIC gl_MainMenu                   && Indicate to the sub-applications
                                        && that the Main menu called them

   * Define help key
   ON KEY LABEL F1 DO Helper


   * Set display characteristics - depends on hardware
   IF ISCOLOR()
      c_normal = "W+/B,GR+/R,B"
      c_pop    = "B/W,GR+/R,W+/R"
      red      = "R/W"
      blue     = "B/W"
      lt_blue  = "W/BG"
   ELSE
      STORE "W+/N,N/W" TO c_normal, c_pop
      STORE "W"   TO red, blue
      STORE "N/W" TO lt_blue
   ENDIF

   * Define popup
   DO Main_def

   * Display menu and loop for choices
   **mstrloop = .T.
   PUBLIC gl_Error
   gl_Error = .F.
   DO WHILE BAR() <> 13 .AND. .NOT. gl_Error
      SET COLOR TO &c_normal.
      CLEAR
      DO Title
      SET COLOR TO &c_pop.
      ACTIVATE POPUP mainmenu
      DO Main
   ENDDO
   RELEASE gl_MainMenu                  && Allow Rest_env to reset the
   DO Rest_env                          && environment back.
   ON ERROR
   ON KEY LABEL F1 
   CLEAR ALL
   CLOSE ALL
   CLEAR

RETURN
*** END MAIN PROCEDURE *******************************************************

PROCEDURE Title
   CLEAR
   * Draw lines and box for menu with colors for effect
   @ 2,24 TO 5,53 DOUBLE COLOR &blue.
   @ 2,24 FILL TO 5,53   COLOR &blue.
   SET COLOR TO &red.
   @ 3,27 SAY "A-T FURNITURE INDUSTRIES"
   @ 4,26 SAY "dBASE IV ACCOUNTING SYSTEM"
   SET COLOR TO &c_normal.
RETURN

PROCEDURE Main_def
   * Defines the main popup menu
   DEFINE POPUP mainmenu FROM 7,27 TO 22,50;
     MESSAGE "Press first letter of menu choice, " + ;
             "or highlight and press <Enter>"
   DEFINE BAR  1 OF mainmenu PROMPT "===== MAIN  MENU =====" SKIP
   DEFINE BAR  2 OF mainmenu PROMPT "      Databases:" SKIP
   DEFINE BAR  3 OF mainmenu PROMPT " EMPLOYEES"
   DEFINE BAR  4 OF mainmenu PROMPT " CUSTOMERS"
   DEFINE BAR  5 OF mainmenu PROMPT " VENDORS"
   DEFINE BAR  6 OF mainmenu PROMPT " INVENTORY"
   DEFINE BAR  7 OF mainmenu PROMPT " ORDERS"
   DEFINE BAR  8 OF mainmenu PROMPT " ACCOUNTS RECEIVABLE"
   DEFINE BAR  9 OF mainmenu PROMPT " AREA CODES"
   DEFINE BAR 10 OF mainmenu PROMPT "     Utilities:" SKIP
   DEFINE BAR 11 OF mainmenu PROMPT " PRINT INVOICES"
   DEFINE BAR 12 OF mainmenu PROMPT " BACK UP/RESTORE DATA"
   DEFINE BAR 13 OF mainmenu PROMPT " RETURN TO dBASE"
   DEFINE BAR 14 OF mainmenu PROMPT " QUIT TO DOS"
   ON SELECTION POPUP mainmenu DEACTIVATE POPUP
RETURN

PROCEDURE Main
   * Execute case depending on user's choice
   DO CASE
      CASE BAR() =  3
         DO Employee
      CASE BAR() =  4
         DO Cust
      CASE BAR() =  5
         DO Vendors
      CASE BAR() =  6
         DO Goods
      CASE BAR() =  7
         DO Orders
      CASE BAR() =  8
         DO Acct_rec
      CASE BAR() =  9
         DO Areacode
      CASE BAR() =  11
         DO Invoices
      CASE BAR() =  12
         DO Back_res
      CASE BAR() =  13 .OR. BAR() = 14
         RELEASE ALL
         IF BAR() = 13
            SET CLOCK ON
	          * Reset colors to Control Center/dot prompt colors
	          DO Colo_rese
            RETURN TO MASTER
         ELSE
            QUIT
         ENDIF
   ENDCASE
RETURN

*** END BUSINESS.PRG *********************************************************

