mFormOpen=.F.
DEFINE FORM mTemp PROPERTY VISIBLE .F.
lVoid = mTemp.OPEN()
mDesk = mTemp.PARENT
lVoid = mTemp.CLOSE()

mFormName=SPACE(8)
mActive=mDesk.ActiveControl()
IF TYPE("mActive.ClassName")="C"
	mClass=mActive.ClassName
	IF mClass="FORM"
		mFormName=mActive.Name
		mFormOpen=.T.
	ENDIF
ENDIF

#include "orders.dfm"
PUBLIC NewRecord

NewRecord = .F.

Ord.Action = .F.
lVoid = Ord.Open()

RETURN

PROCEDURE OpenOrd
	SELECT SELECT()
	USE Orders ALIAS Orders AGAIN

	SELECT SELECT()
	USE Goods ORDER Part_Id ALIAS OrdGoods AGAIN
	SEEK(Orders->Part_ID)

	SELECT SELECT()
	USE Employee ORDER Emp_ID ALIAS OrdEmp AGAIN
	SEEK(Orders->Emp_Id)

	SELECT SELECT()
	USE Cust ORDER Cust_ID ALIAS OrdCust AGAIN
	SEEK(Orders->Cust_ID)

	This.Pname.Text = LTRIM(OrdGoods->Part_Name)
	This.Price.Text = LTRIM(STR(OrdGoods->Price))
	This.QtyHand.Text = LTRIM(STR(OrdGoods->Qty_OnHand))
	This.Profmgn.Text = LTRIM(STR((OrdGoods->Price - OrdGoods->Cost) / 100))
	Name = TRIM(OrdEmp->FirstName) +" "+OrdEmp->LastName
	This.EmpName.Text = Name
	SELE Orders



	IF .NOT. mFormOpen
		Main.F1.CloseAll.Enabled=.F.
		Main.V.Frm.Enabled=.F.
		Main.S.Srch.Enabled=.T.
		Main.S.Tp.Enabled=.T.
		Main.S.Btm.Enabled=.T.
		Main.S.Pck.Enabled=.F.
		Main.S.Indx.Enabled=.F.
		Main.E.Undo.Enabled=.T.
		Main.E.Save.Enabled=.T.
		Main.App.Cust.Enabled=.F.
		Main.App.Gds.Enabled=.F.
		Main.App.Acc.Enabled=.F.
		Main.App.Emp.Enabled=.F.
		Main.F1.Bac.Enabled=.F.
		Main.App.Inv.Enabled=.F.
	ENDIF
 	Main.App.Ord.Enabled=.F.

	lVoid = Ord.Refresh()

RETURN


PROCEDURE UndoIt
	lVoid = Form.Refresh()
RETURN

PROCEDURE SubmitIt
	lVoid = Form.Submit()
RETURN

PROCEDURE PrevHand
       IF Form.Modified()
		lVoid = Form.Submit()
       ENDIF
	IF .NOT. BOF()
		SKIP -1
      IF BOF()
         DO ErrorMsg WITH "Top of file!"
      ENDIF
		SELE OrdGoods
		SEEK(Orders->Part_ID)
		SELE OrdEmp
		SEEK(Orders->Emp_Id)
		SELE OrdCust
		SEEK(Orders->Cust_Id)

		Form.Pname.Text = LTRIM(OrdGoods->Part_Name)
		Form.Price.Text = LTRIM(STR(OrdGoods->Price))
		Form.QtyHand.Text = LTRIM(STR(OrdGoods->Qty_OnHand))
		Form.Profmgn.Text = LTRIM(STR((OrdGoods->Price - OrdGoods->Cost) / 100))
		Name = TRIM(OrdEmp->FirstName)+" "+OrdEmp->LastName
		Form.EmpName.Text = Name
		SELE Orders
		* Show user if the record is marked for deletion
		IF DELETED()
		   Form.cStatus.Text = "DELETED"
		ELSE
		   Form.cStatus.Text = ""
		Endif

		lVoid = Ord.Refresh()
	ELSE
		DO ErrorMsg WITH "Top of file!"
	ENDIF
	Form.Action = .F.
RETURN
******************
PROCEDURE SkipHand
       IF Form.Modified()
          lVoid = Form.Submit()
       ENDIF
	IF .NOT. EOF()
      SKIP
      IF PART_ID=' '
         SKIP -1
         DO ErrorMsg WITH "End of file encountered!"
      ENDIF
		SELE OrdGoods
		SEEK(Orders->Part_ID)
		SELE OrdEmp
		SEEK(Orders->Emp_Id)
		SELE OrdCust
		SEEK(Orders->Cust_Id)

		Form.Pname.Text = LTRIM(OrdGoods->Part_Name)
		Form.Price.Text = LTRIM(STR(OrdGoods->Price))
		Form.QtyHand.Text = LTRIM(STR(OrdGoods->Qty_OnHand))
		Form.Profmgn.Text = LTRIM(STR((OrdGoods->Price - OrdGoods->Cost) / 100))
		Name = TRIM(OrdEmp->FirstName)+" "+OrdEmp->LastName
		Form.EmpName.text = name
		SELE Orders

		* Show user if the record is marked for deletion
		IF DELETED()
		   Form.cStatus.Text = "DELETED"
		ELSE
		   Form.cStatus.Text = ""
		Endif

		lVoid = Ord.Refresh()

	ELSE
		DO ErrorMsg WITH "End of file encountered!"

	ENDIF
	Form.Action = .F.
RETURN
******************
PROCEDURE CloseOrd
	IF This.Action
		lVoid = This.Submit()
	ELSE
	       IF This.Modified()
			DO ErrorMsg WITH "Data write was cancelled!"
	       ENDIF
	ENDIF
   USE IN Orders
   USE IN OrdGoods
   USE IN OrdEmp
   USE IN OrdCust

	lVoid = This.Release()

	mFormOpen=.F.
	DEFINE FORM mTemp PROPERTY VISIBLE .F.
	lVoid = mTemp.OPEN()
	mDesk = mTemp.PARENT
	lVoid = mTemp.CLOSE()

	mFormName=SPACE(8)
	mActive=mDesk.ActiveControl()
	IF TYPE("mActive.ClassName")="C"
		mClass=mActive.ClassName
		IF mClass="FORM"
			mFormName=mActive.Name
			mFormOpen=.T.
		ENDIF
	ENDIF

	IF .NOT. mFormOpen
	 	Main.F1.CloseAll.Enabled=.T.
	 	Main.V.Frm.Enabled=.T.
	 	Main.S.Srch.Enabled=.F.
	 	Main.S.Tp.Enabled=.F.
	 	Main.S.Btm.Enabled=.F.
	 	Main.S.Pck.Enabled=.T.
	 	Main.S.Indx.Enabled=.T.
	 	Main.E.Undo.Enabled=.F.
	 	Main.E.Save.Enabled=.F.
	 		 	Main.App.Cust.Enabled=.T.
	 	Main.App.Gds.Enabled=.T.
	 	Main.App.Acc.Enabled=.T.
	 	Main.App.Emp.Enabled=.T.
	 	Main.F1.Bac.Enabled=.T.
	 	Main.App.Inv.Enabled=.T.
	ENDIF
	Main.App.Ord.Enabled=.T.


RETURN
******************
FUNCTION LookupId

    PRIVATE This, Form
    lReturn = .F.
    SELECT (This.ALIASNAME)  && Custom Property
    IF SEEK( This.Value )    && Value of the current object
	lReturn = .T.
    ELSE
	DEFINE BROWSE LookUp
	Lookup.Top           =  This.Top + 2
	Lookup.Left          =  This.Left
	Lookup.Key           =  "KeyHand"
	Lookup.OnMouseDblClk =  "KeyHand"
	Lookup.Sizeable      =  .T.
	Lookup.Moveable      =  .T.
	Lookup.MDI           =  .F.
	Lookup.Width         =  77 - This.Left
	Lookup.Alias         =  This.ALIASNAME
	Lookup.StatusMessage =  [Select the desired value and ] + ;
				[press Enter to choose it] ;

	Lookup.Action        = .F.

	lVoid = LookUp.ReadModal()
	IF LookUp.Action
	    DO CASE
		CASE This.AliasName = "CUST"
			This.Value = OrdCust->Cust_id

		CASE This.AliasName = "GOODS"
			This.Value = OrdGoods->Part_id

		CASE This.AliasName = "EMPLOYEE"
			This.Value = OrdEmp.Emp_id
	    ENDCASE
	    lReturn = .T.
	ELSE
	    DO ErrorMsg WITH [Lookup failed: ] + LTRIM( STR( This.Value ) )
	ENDIF

    ENDIF
    SELECT Orders

RETURN lReturn

FUNCTION KeyHand
*----------------------------------------------------------------------------
* NAME
*   KeyHand() -
*
*----------------------------------------------------------------------------
*    PRIVATE Form, This
*#define evMouseDown       1
*#define evKeyDown        16
*#define kbEnter          13

    IF Event.EventType = 16
	IF Event.KeyValue = 13
	    Lookup.Action = .T.
	    lVoid = Lookup.Close()
	ENDIF
    ELSE
	IF Event.EventType = 1
	    Lookup.Action = .T.
	    lVoid = Lookup.Close()
	ENDIF
    ENDIF

RETURN .T.

******************
PROCEDURE Add_new
	NewRecord = .T.

	*Write data to disk
	lvoid = Form.submit()

	* Append a record
	APPEND BLANK

	*Refresh Screen Data
	lvoid = Form.refresh()
   Form.cStatus.Text=""
RETURN
******************
PROCEDURE DelIt && Marks record for deletion
	IF DELETED()
	  Form.cStatus.Text = ""
	  RECALL
	ELSE
	  Form.cStatus.Text = "DELETED"
	  DELETE
	ENDIF

RETURN
*****************
PROCEDURE CanHand
    Form.Action = .F.
    lVoid = Form.Close()
RETURN
*****************
PROCEDURE RePaint
	SELE Orders
	lVoid = Ord.Refresh()
RETURN
******************
PROCEDURE PrintForm

DEFINE FORM Prt FROM 5,25 TO 16,50 ;
	PROPERTY ;
		TEXT "Print Form"

DEFINE TEXT t1 OF Prt AT 1,1 ;
	PROPERTY ;
		Text "Type :",;
		COLORNORMAL "R/W"

DEFINE RADIOBUTTON Rep OF Prt AT 2,1 ;
	PROPERTY ;
		Text "Report",;
		Group .T.,;
		COLORNORMAL "N/W",;
		WIDTH 15

DEFINE RADIOBUTTON Lab OF Prt AT 3,1 ;
	PROPERTY ;
		Text "Labels",;
		Group .F.,;
		COLORDISABLED "N+/W",;
		WIDTH 15,;
		ENABLED .F.,;
		TABSTOP .F.

DEFINE TEXT T3 OF Prt AT 9,5 ;
	PROPERTY ;
		TEXT "PRINTING ..." ,;
		VISIBLE .F.,;
		WIDTH 15

DEFINE PUSHBUTTON P1 OF Prt AT 8,12 ;
	PROPERTY ;
		TEXT "&Ok",;
		ONCLICK "RunRep",;
		Width 10

DEFINE PUSHBUTTON P2 OF Prt AT 8,2 ;
	PROPERTY ;
		TEXT "&Cancel",;
		ONCLICK "CanHand",;
		Width 10

lVoid = Prt.Open()

******************
PROCEDURE Runrep

* Check for Labels or Reports
DO CASE
	CASE Form.Rep.Value
	     * display to user something is happening
	     Form.T3.Visible = .t.
	     REPORT FORM Orders TO PRINTER

ENDCASE
lVoid = Form.Close()
lVoid = Form.Release()
RETURN
