************************************************************
* FILE MENUWIN.PRG
* Shows how to use OnClick with pushbuttons and menu items.
* Sample program for Chapter 22 of the "Programmer's Guide."
************************************************************ 
DEFINE MENUBAR Main PROPERTY ColorMenubarNormal "B+/W"

DEFINE MENUITEM OpenWin OF Main ;
   PROPERTY ;
      Text "&Open Window", ;
      OnClick WinOpen

DEFINE MENUITEM Exit OF Main ;
   PROPERTY ;
      Text "E&xit", ;
      OnClick ExitAll
   
DEFINE FORM f1 AT 9,20 ;
   PROPERTY ;
      Text "Form window", Height 6, Width 40, ;
      OnOpen FormOpen

DEFINE PUSHBUTTON pb1 OF f1 AT 1,1 ;
   PROPERTY ;
      Text "&Close window", Width 16, OnClick WinClose
      
DEFINE PUSHBUTTON pb2 OF f1 AT 1,19 ;
   PROPERTY ;
      Text "&Does nothing", Width 16

lVoid = Main.Open()

PROCEDURE WinOpen              && OnClick event handler for OpenWin menuitem
   lVoid = f1.Open()           && Open the form window f1.
RETURN            

PROCEDURE FormOpen             && OnOpen event handler for form window f1.
   lVoid = f1.pb1.Setfocus()   && Force focus to the first pushbutton.
RETURN

PROCEDURE WinClose             && OnClick event handler for pushbutton pb1.
   lVoid = form.Close()        && Close form window f1.
RETURN            

PROCEDURE ExitAll              && OnClick event handler for menu item Exit
   lVoid = Main.Release()      && Release the menu bar.
   lVoid = f1.Release()        && Release the form window.
   RELEASE Main                && Remove the unused object reference 
   RELEASE f1                  && variables from memory.
